import os
import re
from typing import Union


def get_version_number(fname: str) -> Union[int, None]:

    match = re.search(r"last-v(\d+).ckpt", fname)
    if match:
        return int(match.group(1))
    elif fname == "last.ckpt":
        return 0
    return None


def fetch_last_ckpt(ckpt_dir: str) -> Union[str, None]:

    if not os.path.exists(ckpt_dir):
        return None
    last_ckpts = [
        f
        for f in os.listdir(ckpt_dir)
        if "last" in f and f.endswith(".ckpt") and get_version_number(f) is not None
    ]
    if len(last_ckpts) == 0:
        return None
    sorted_files = sorted(last_ckpts, key=get_version_number, reverse=True)
    return sorted_files[0]
