import os
import sys
import torch
from torch.utils.tensorboard import SummaryWriter
from .parameter_sweeper import Sweeper


class Parameters:
    def __init__(self, args):
        args.config_idx = int(float(args.config_idx))
        sweeper = Sweeper(args.config_file)
        cfg = sweeper.generate_config_for_idx(args.config_idx)
        if args.config_idx > sweeper.config_dicts['num_combinations']:
            print("Config ID is invalid", flush=True)
            sys.exit()
        print("Running configuration ID: {}".format(args.config_idx), flush=True)



        ###Algorithm Level Parameters#####
        self.gamma = cfg['gamma']
        self.lmda = cfg['lmda']
        self.learning_rate = cfg['learning_rate']
        self.training_batch_size = cfg['batch_size']
        self.report_freq = cfg['report_freq']
        self.test_freq = cfg['test_freq']
        self.steps_per_env = cfg['steps_per_env']
        self.safe_reg = cfg['safe_reg']

        ### Start-Training Level Parameters####
        self.port = cfg['port']
        self.static_envs = cfg['static_envs']
        self.run_benchmarks = cfg['run_benchmarks']
        self.shutdown = False
        self.impact_penalty = cfg['impact_penalty']
        self.penalty_baseline = cfg['penalty_baseline']
        self.env_type = cfg['env_type']
        self.algo = cfg['algo']
        self.seed = None
        self.steps = cfg['steps']

        self.data_dir = cfg['save_tag'] + \
                       str(self.algo) + '-' + \
                       'env' + '-' + str(self.env_type) + '-' \
                       'safe-reg' + '-' + str(self.safe_reg) + '-' \
                        'impact' + '-' + str(self.impact_penalty)



