import sys
import pickle
import matplotlib.pyplot as plt
plt.rcParams.update({'font.size': 12})

map_boundary_2d = [
    (10374, -7377), (7265, -7329), (5901, -6723), (4813, -4819), (4017, -4027), (2609, -3632), 
    (865, -3326), (-518, -3012), (-1440, -1870), (-1534, 1298), (-874, 2747), (971, 3326), 
    (2501, 3631), (3490, 3738), (4607, 4485), (5355, 6204), (6471, 7106), (10037, 7377), 
    (9936, 6781), (8838, 6416), (8737, 4530), (8722, 2114), (10093, 2072), (10079, -2071), 
    (8737, -2130), (8737, -4529), (8751, -4895), (8952, -6729), (9910, -6778), (10145, -7192)
]

floor_bounary_2d = {
    'Floor_1': [(8751, 4895), (8968, 6582), (9912, 6778), (10374, 7377), (7340, 7347), (6234, 6988), (5335, 6176), 
                (4851, 4919), (4520, 4405), (5238, 3599), (5794, 4026), (7575, 4836)],
    'Floor_2': [(8751, -4895), (9092, -6722), (9939, -6778), (10374, -7377), (7456, -7369), (6179, -6960), (5358, -6208),
                (4851, -4916), (4462, -4361), (5190, -3551), (5857, -4055), (7374, -4756)], 
    'Floor_4': [(4191, 2179), (4780, 3189), (3972, 3993), (3283, 3677), (2501, 3607), (2464, 2172), (3884, 1984)], 
    'Floor_5': [(1046, -3326), (865, -3326), (-518, -3012), (-1440, -1870), (-1534, 1298), (-874, 2747), (971, 3326), 
                (1192, 2505), (1460, 1362), (3064, 1362), (3158, 954), (4877, 972), (4880, -991), (3104, -939), 
                (3107, -1362), (1178, -1254), (1350, -2025), (1330, -2516)],
    'Floor_6': [(2501, -2021), (2504, -3632), (3207, -3659), (3971, -3993), (4822, -3231), (4415, -2779), (4187, -2179), (3884, -1935)], 
    'Floor_7': [(5105, -2900), (4682, -2802), (4377, -2242), (4350, -1687), (5333, -1635), (5356, -455), (4919, -411), (4919, 410), 
                (5321, 422), (5333, 1637), (4350, 1686), (4445, 2466), (4837, 2885), (5126, 2909), (5906, 3727), (7713, 4497), 
                (8737, 4530), (8732, 2095), (10093, 2071), (10093, -2071), (8791, -2071), (8737, -4530), (7765, -4514), 
                (5766, -3643)],
    'Floor_8': [(821, -317), (821, 773), (1097, 1228), (1690, 1489), (3394, 1519), (3390, 949), (3959, 949), (4004, 1519), 
                (4897, 1386), (4946, -1393), (4009, -1519), (4014, -949), (3454, -949), (3440, -1519), (1308, -1325), (821, -666)], 
}

sys.path.append('../DataCollection')

from sampling_clean import plot_path

navigation_image_path = 'videos/ignet-goal-40epoch_2023_09_29_05_51_07/hard/iter-5'
navigation_data_path = 'eval_data/ignet-goal-40epoch_2023_09_29_05_51_07'

with open(f'{navigation_data_path}/data.pickle', 'rb') as file:
    data = pickle.load(file)

print(data['hard-raw'][5].keys())

start_point = data['hard-raw'][5]['start_point']
goal_point = data['hard-raw'][5]['goal_point']

import numpy as np
trajectory = np.array(data['hard-raw'][5]['path_position'])
print(trajectory.shape)

plot_path(map_boundary_2d, goal_point[:3], goal_point[-1], start_point[:3], start_point[-1], floor_bounary_2d, trajectory, 'point.png')
