import pandas as pd
import os
import pickle

# with open('eval_data/ignet-goal-alldata-30epoch_2023_09_28_14_37_05/data.pickle', 'rb') as file:
#     data = pickle.load(file)

# for i in range(50):
#     print(data['hard-raw'][i]['metrics'])

# exit(0)

algs = ['ignet-goal-alldata-30epoch_2023_09_28_14_37_05', 'ignet-noaux-goal-30epoch_2023_09_28_13_59_45', 'ignet-noaux-position-goal-30epoch_2023_09_28_14_57_33', 'ignet-noaux-path-goal-30epoch_2023_09_28_14_58_15']
algs_names = ['IG-Net', 'IG-Net (no aux)', 'IG-Net (no position)', 'IG-Net (no path and dist)']


difficulties = ['easy', 'medium', 'hard']
difficulties_names = ['d < 4000', '4000 < d < 8000', 'd > 8000']

metrics = ['success', 'success_weighted_path_length', 'distance_decrement_rate']
metrics_names = ['SR', 'SPL', 'DDR']


df = pd.DataFrame(columns=pd.MultiIndex.from_product([difficulties_names, metrics_names], names=['Difficulty', 'Metric']), index=algs_names)

for alg, alg_name in zip(algs, algs_names):
    alg_result_path = f'eval_data/{alg}/data.pickle'
    if not os.path.exists(alg_result_path):
        continue
    with open(alg_result_path, 'rb') as file:
        result_data = pickle.load(file)
        
    for difficulty, difficulty_name in zip(difficulties, difficulties_names):
        for metric, metric_name in zip(metrics, metrics_names):
            df.loc[alg_name, (difficulty_name, metric_name)] = \
                result_data[difficulty][metric]
    
num_results_per_env = len(metrics)
column_format = "c|" + "|".join(["c" * num_results_per_env for _ in difficulties])


print(df.to_latex(float_format=lambda x: "%.2f" % x, column_format=column_format))

