import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import numpy as np

def save_images(name, imgs, r, c):
#    print(imgs.shape)
    imgs = np.clip(imgs, 0,1)
    fig, axs = plt.subplots(r, c)
    cnt = 0
    for i in range(r):
        for j in range(c):
#            print(str(i) + '==' + str(j))
            _img = imgs[cnt, :,:]
            axs[i,j].imshow(_img, interpolation = "hanning")
            axs[i,j].axis('off')
            cnt += 1
    plt.gca().set_axis_off()
    plt.subplots_adjust(top = 1, bottom = 0, right = 1, left = 0, 
            hspace = 0, wspace = 0)
    plt.margins(0,0)
    plt.gca().xaxis.set_major_locator(plt.NullLocator())
    plt.gca().yaxis.set_major_locator(plt.NullLocator())
#    plt.subplots_adjust(left=0., right=1, top=0.8, bottom=0.0)
    fig.savefig(name, bbox_inches = 'tight',
    pad_inches = 0)
    plt.close()    


def save_images_1d(name, imgs, r):
#    print(imgs.shape)    
    imgs = np.clip(imgs, 0,1)
    fig, axs = plt.subplots(1,r)
    cnt = 0
    for i in range(r):
            _img = imgs[cnt, :,:]
            axs[i].imshow(_img, interpolation = "hanning")
            axs[i].axis('off')
            cnt += 1
    
    plt.gca().set_axis_off()
    plt.subplots_adjust(top = 1, bottom = 0, right = 1, left = 0, 
            hspace = 0.03, wspace = 0.03)
    plt.margins(0,0)
    plt.gca().xaxis.set_major_locator(plt.NullLocator())
    plt.gca().yaxis.set_major_locator(plt.NullLocator())
#    plt.subplots_adjust(left=0., right=1, top=0.8, bottom=0.0)
    fig.savefig(name, bbox_inches = 'tight',
    pad_inches = 0)
    plt.close()    
