# Robust Covariate Shift
Adversarial Robust Classifier with Covariate Shift Adaptation

We have provided the codes for our experiments on ImageNet.
These codes are modified from the [robustness package](https://github.com/MadryLab/robustness) provided by Engstrom et. al. (2019).

Please check the codes inside and change the parameters and correctly set the appropriate directory.

# Experiment 1: Robustness against Gaussian Augmented Noise.
Code: `./robustness/eval_noise_adv.py`

Execution: `CUDA_VISIBLE_DEVICES=0,1,2,3 nohup python -m robustness.eval_noise_adv.py imagenet > log_gaussian.log &`

# Experiment 2: L2 Certification.
Code: `./robustness/eval_certify.py` 

Please note that: this code produces a vector of length equal to the number of classes (i.e., 1000 for ImageNet) for each image.
For a given test image, it reports the number of time a class `c` is predicted for the corresponding Gaussian augmented images.

The calculation of the certified L2 radius is not included in this code. You can get it from [here](https://github.com/locuslab/smoothing) (Cohen et al., 2019).
Execution: `CUDA_VISIBLE_DEVICES=0,1,2,3 nohup python -m robustness.eval_certify.py imagenet > log_gaussian.log &`

# Experiment 3: Adversarial Attack.
Code: `./robustness/pgd_bn_imagenet.py`

Attack the models with adaptive BN:-

Execution: `CUDA_VISIBLE_DEVICES=0,1,2,3 nohup python -m robustness.pgd_bn_imagenet.py imagenet> log_attack_bn.log &`

Attack the models without BN:-

Execution: `CUDA_VISIBLE_DEVICES=0,1,2,3 nohup python -m robustness.pgd_std_imagenet.py imagenet> log_attack_std.log &`

# Experiment 4: Common Perturbations.
Code: `./robustness/common_perturb_adv.py`

Execution: `CUDA_VISIBLE_DEVICES=0,1,2,3 nohup python -m robustness.common_perturb_adv.py imagenet> log_cp.log &`

# Experiment 5: Visualize Loss Gradients.
Code: `./robustness/loss_gradients_cp.py` & `loss_gradients.py`

Loss gradients for ImageNet testset with user defined Gaussian Noise:- `loss_gradients.py`

Execution: `CUDA_VISIBLE_DEVICES=0,1,2,3 nohup python -m robustness.loss_gradients imagenet > log_lossGrads_noise.log &`

Loss gradients for ImageNet-C dataset:-

Execution: `CUDA_VISIBLE_DEVICES=0,1,2,3 nohup python -m robustness.loss_gradients_cp imagenet > log_lossGrads_cp.log &`

Please download the ImageNet models from https://github.com/locuslab/robust_overfitting (Rice et. al., 2020).

For more details, please follow the instructions provided in https://robustness.readthedocs.io/en/latest/index.html (Engstrom et. al., 2019)

