from sklearn.model_selection import train_test_split


def make_val_data(images, labels, class_names, val_percent):

    # Ensure that at least one sample from all the classes if
    # present in val data
    val_size = max(int(len(images) * val_percent/100.), len(set(labels)))

    train_images, val_images, train_labels, val_labels, \
        train_class_names, val_class_names = train_test_split(images, labels, class_names,
                                                              shuffle=True, test_size=val_size, random_state=42, 
                                                              stratify=labels)

    return train_images, val_images, train_labels, val_labels, train_class_names, val_class_names
