import os
from pathlib import Path
from timm.data.readers.reader import Reader


class PickleReader(Reader):

    def __init__(
            self,
            root,
            images, 
            labels):
        super().__init__()

        self.root = root
        self.samples = list(zip(images, labels))
        
        if len(self.samples) == 0:
            raise RuntimeError(
                f'Found 0 images')

    def __getitem__(self, index):
        array, target = self.samples[index]
        return array, target

    def __len__(self):
        return len(self.samples)

    def _filename(self, index, basename=False, absolute=False):
        raise NotImplementedError()
