#!/bin/bash

# Download from http://www.robots.ox.ac.uk/~vgg/share/decathlon-1.0-data.tar.gz and follow the instructions 
# here https://www.robots.ox.ac.uk/~vgg/decathlon/ to download the ImageNet data.

if [ $# -lt 1 ]
    then
        echo "The script should be invoked as ./prepare_vdd.sh <DATA_ROOT>. For e.g., ./prepare_vdd.sh ~/data/vdd"
        exit 1
fi

if [ $# -gt 1 ]
    then
        echo "The script should be invoked as ./prepare_vdd.sh <DATA_ROOT>. For e.g., ./prepare_vdd.sh ~/data/vdd"
        exit 1
fi

DATA_ROOT=$1

cd $DATA_ROOT
# Extract the structure
echo "Extracting devkit from $DATA_ROOT/decathlon-1.0-devkit.tar.gz"
tar -xzf decathlon-1.0-devkit.tar.gz
echo "Renaming decathlon-1.0 to vdd"
mv decathlon-1.0 vdd

# Move the data
echo "Moving the data to $DATA_ROOT/vdd/data"
mv decathlon-1.0-data.tar.gz vdd/data/
mv decathlon-1.0-data-imagenet.tar vdd/data/

# Extract
echo "Extracting the data from tar.gz files"
tar -xzf vdd/data/decathlon-1.0-data.tar.gz -C vdd/data/
echo "Extracting aircraft.tar"
tar -xf vdd/data/aircraft.tar -C vdd/data/
echo "Extracting cifar100.tar"
tar -xf vdd/data/cifar100.tar -C vdd/data/
echo "Extracting daimlerpedcls.tar"
tar -xf vdd/data/daimlerpedcls.tar -C vdd/data/
echo "Extracting dtd.tar"
tar -xf vdd/data/dtd.tar -C vdd/data/
echo "Extracting gtsrb.tar"
tar -xf vdd/data/gtsrb.tar -C vdd/data/
echo "Extracting omniglot.tar"
tar -xf vdd/data/omniglot.tar -C vdd/data/
echo "Extracting svhn.tar"
tar -xf vdd/data/svhn.tar -C vdd/data/
echo "Extracting ucf101.tar"
tar -xf vdd/data/ucf101.tar -C vdd/data/
echo "Extracting vgg-flowers.tar"
tar -xf vdd/data/vgg-flowers.tar -C vdd/data/
echo "Extracting decathlon-1.0-data-imagenet.tar"
tar -xf vdd/data/decathlon-1.0-data-imagenet.tar  -C vdd/data/

# Cleanup
echo "Removing tar files"
cd vdd/data
rm aircraft.tar cifar100.tar daimlerpedcls.tar dtd.tar gtsrb.tar omniglot.tar svhn.tar ucf101.tar vgg-flowers.tar
rm decathlon-1.0-data.tar.gz
rm decathlon-1.0-data-imagenet.tar

cd ../..
rm decathlon-1.0-devkit.tar.gz
