
# UniEdit: A Unified Tuning-Free Framework for Video Motion and Appearance Editing
## [<a href="https://uni-edit.github.io/UniEdit/" target="_blank">Project Page</a>]


![fig1_demo_video](https://github.com/Uni-Edit/UniEdit/assets/157126651/9d480439-3a8e-4a45-a11a-04f38d805e26)


## Support Various Editing Scenarios

**UniEdit** supports both video ***motion*** editing in the time axis (i.e., from playing guitar to eating or waving) and various video ***appearance*** editing scenarios (i.e., stylization, rigid/non-rigid object replacement, background modification).


<div align="center">

  **1. Motion editing.**

  <img src="https://github.com/Uni-Edit/UniEdit/assets/157126651/c336db32-ec05-4724-9339-48f1d5750e40" style="width: 50%; margin-top: 0px;"/>
</div>
<div align="center">

  **2. Stylization.**

  <img src="https://github.com/Uni-Edit/UniEdit/assets/157126651/af1a13d4-abf1-46d4-a0ad-75f2218076f0" style="width: 50%; margin-top: 0px;"/>
</div>
<div align="center">

  **3. Rigid object replacement.**

  <img src="https://github.com/Uni-Edit/UniEdit/assets/157126651/1dbbf818-ce12-4b0f-ab33-b06084df6324" style="width: 50%; margin-top: 0px;"/>
</div>
<div align="center">

  **4. Non-rigid object replacement.**

  <img src="https://github.com/Uni-Edit/UniEdit/assets/157126651/a77a7d33-ed35-409a-8923-ace5ca26b184" style="width: 50%; margin-top: 0px;"/>
</div>
<div align="center">

  **5. Background modification.**

  <img src="https://github.com/Uni-Edit/UniEdit/assets/157126651/13d8f58c-c3a6-4aa3-a107-8e0bc39cd6b5" style="width: 50%; margin-top: 0px;"/>
</div>

## Introduction
>**Abstract:** Recent advances in text-guided video editing have showcased promising results in appearance editing (e.g., stylization). However, video motion editing in the temporal dimension (e.g., from eating to waving), which distinguishes video editing from image editing, is underexplored. In this work, we present UniEdit, a tuning-free framework that supports both video motion and appearance editing by harnessing the power of a pre-trained text-to-video generator within an inversion-then-generation framework. To realize motion editing while preserving source video content, based on the insights that temporal and spatial self-attention layers encode inter-frame and intra-frame dependency respectively, we introduce auxiliary motion-reference and reconstruction branches to produce text-guided motion and source features respectively. The obtained features are then injected into the main editing path via temporal and spatial self-attention layers. Extensive experiments demonstrate that UniEdit covers video motion editing and various appearance editing scenarios, and surpasses the state-of-the-art methods.

**Features**:<br>

- **Versatile**: supports both video motion editing and various video appearance editing scenarios.
- **Tuning-free**: no training or optimization required.
- **Flexibility**: compatible with off-the-shelf T2V models.

## Demo

Please visit the [project webpage](https://uni-edit.github.io/UniEdit/) to see more results and information.

## Usage

Due to company policy reasons, we are currently unable to upload the code.

**The code will be publicly available after the paper is published.**