pretrained_path=/root/paddlejob/workspace/env_run/huitingfeng/MoE/output/sheared-moe-router
data_path=data/all-500k.json
output_path=output/sheared-moe

torchrun --nproc_per_node=8 --nnodes=1 --master_port=4741 train_moe.py \
    --deepspeed ds_config/ds_z2_config.json \
    --model_name_or_path $pretrained_path \
    --data_path $data_path \
    --bf16 True \
    --overwrite_output_dir \
    --model_max_length 2048 \
    --output_dir $output_path \
    --num_train_epochs 4 \
    --per_device_train_batch_size 1 \
    --gradient_accumulation_steps 16 \
    --evaluation_strategy "no" \
    --save_strategy "epoch" \
    --lr_scheduler_type "constant" \
    --logging_strategy "steps" \
    --save_total_limit 4 \
    --logging_steps 1 \
    --learning_rate 2e-5 \
    --weight_decay 0.0 \
    --warmup_steps 0 \
    --tf32 True \
    --expert_num 4 \
    --topk 2 \