REVIEWER_GUIDELINES = """
# Reviewer Guide

## We're counting on you

As a reviewer you are central to the program creation process for ICLR 2025. Your Area Chairs (ACs), Senior Area Chairs (SACs) and the Program Chairs (PCs) will rely greatly on your expertise and your diligent and thorough reviews to make decisions on each paper. Therefore, your role as a reviewer is critical to ensuring a strong program for ICLR 2025.

High-quality reviews are also very valuable for helping authors improve their work, whether it is eventually accepted by ICLR 2025, or not. Therefore it is important to treat each valid ICLR 2025 submission with equal care.

As a token of our appreciation for your essential work, top reviewers will be acknowledged permanently on the ICLR 2025 website.

## Code of Ethics

All ICLR participants, including reviewers, are required to adhere to the ICLR Code of Ethics. All reviewers are required to read the Code of Ethics and adhere to it. The Code of Ethics applies to all conference participation, including paper submission, reviewing, and paper discussion.

As part of the review process, reviewers are asked to raise potential violations of the ICLR Code of Ethics. Note that authors are encouraged to discuss questions and potential issues regarding the Code of Ethics as part of their submission. This discussion is not counted against the maximum page limit of the paper and should be included as a separate section.

## ICLR Code of Ethics

Responsible Stewardship. The International Conference on Learning Representations (ICLR) is committed to promoting good conduct and a reflexive and responsible approach to research and its applications, especially with respect to research and development related to machine learning and artificial intelligence. This Code is a vital part of our continuing effort to encourage reflection of the wider impacts of work that is considered by the conference, and to encourage work that consistently supports the responsible stewardship of trustworthy research that advances knowledge, public good and well-being.

Aims. This Code of Ethics provides general ethical principles, applicable to both individual researchers and to organisations that carry out, fund, host, or are otherwise involved in research, and associated with ICLR. The Code should not be seen as prescriptive but as a set of principles to guide ethical, responsible research.

Positive Action. This code applies to all contributors to ICLR, including reviewers, authors, speakers, organisers of the conference, tutorials, workshops, sponsors, and attendees. ICLR's contributors are expected to acknowledge this code, and whenever necessary, include a discussion in their contributions that expands on the wider impacts of their work, using this Code as one source of ethical considerations.

Acknowledgments. This code is influenced by and borrows from the ACM Code of Ethics and Professional Conduct, the UKRIO Code of Practice for Research, the European Code Of Conduct For Research Integrity, the Committee on Publication Ethics, and input from a broad range of community groups in machine learning.

### General Ethical Principles

- Contribute to society and to human well-being.
- Uphold high standards of scientific excellence.
- Avoid harm.
- Be honest, trustworthy and transparent.
- Be fair and take action to avoid discrimination.
- Respect the work required to produce new ideas and artefacts.
- Respect privacy.
- Honour confidentiality.

#### Contribute to Society and to Human Well-being

- Researchers must acknowledge that all people globally are stakeholders in computing, and that we should use our skills for the benefit of society, its members, and our natural environment.
- Research should minimise negative consequences, including threats to health, safety, personal security, and privacy. In order to do so, it must take into consideration a multiplicity of socio-economic factors and geographies.
- When the interests of multiple groups conflict, the needs of those less advantaged should be given increased attention and priority.
- Researchers should consider whether the results of their efforts will respect diversity, will be used in socially responsible ways, will meet social needs, and will be broadly accessible.

#### Uphold High Standards of Scientific Excellence

- Researchers and organisations should strive for excellence when conducting research and aim to produce and disseminate work of the highest quality.  This implies a commitment to open enquiry, intellectual rigor, integrity, and collaboration.
- Findings must be reported accurately and honestly. Researchers must not make deliberately false or misleading claims, fabricate or falsify data, or misrepresent results. Methods and results should be presented in a way that is transparent and reproducible.
- Where human subjects are involved in the research process (e.g., in direct experiments, or as annotators), the need for ethical approvals from an appropriate ethical review board should be assessed and reported.
- All contributions to the research must be acknowledged, and agreements relating to intellectual property, publication and authorship must be complied with.

#### Avoid Harm

- Here, "harm" means negative consequences. Well-intended actions, including those that accomplish desired outcomes, may lead to harm.
- When that harm is unintended, those responsible are obliged to undo or mitigate the harm as much as possible. Avoiding harm begins with engaging with application domain experts, engagement with the communities that the research is intended to serve, and a careful consideration of potential impacts on all those affected.
- When harm is an intentional part of the system, those responsible are obligated to ensure that the harm is ethically justified.
- Harm to the natural environment, whether in the process of producing research or in its application, should also be considered. In all cases, ensure that all harm is minimized.
- The consequences of data aggregation and emergent properties of systems should be carefully analyzed, including those that can become integrated into the structure of society. Researchers have an additional obligation to report any signs of system risks that might result in harm. For reporting, see the section at the end on Concerns and Remediation.

#### Be Honest, Trustworthy and Transparent

- Researchers should be honest about their qualifications, and about any limitations in their competence to complete a task.
- Researchers should provide full disclosure of all pertinent system capabilities, limitations, and potential problems to the appropriate parties, including any party that may deploy the system.
- Researchers should be open and transparent about any circumstances that might lead to either real or perceived conflicts of interest or otherwise tend to undermine the independence of their judgment.  Researchers must consider their competing interests, including from sources of the funding, and report any possible conflicts.
- Researchers should not misrepresent work that might be competing or related, and should not misrepresent an organization's policies or procedures.

#### Be Fair and Take Action not to Discriminate

- The values of equality, tolerance, respect for others, and justice govern this principle. The ICLR Code of Conduct provides additional details of expected behaviour at the Conference.
- Fairness requires that even careful decision processes provide some avenue for redress of grievances.
- Researchers should foster fair participation of all people—in their research, at the conference and generally—including those of underrepresented groups.
- The use of information and technology may cause new, or enhance existing, inequities. Technologies and practices should be as inclusive and accessible as possible and researchers should take action to avoid creating systems or technologies that disenfranchise or oppress people.

#### Respect the Work Required to Produce New Ideas and Artefacts

- Researchers must show respect for colleagues, research participants, society, ecosystems, cultural heritage and the environment.
- Developing new ideas, inventions, creative works, and computing artefacts creates value for society, and those who expend this effort should expect to gain value from and receive credit for their work.
- Researchers should therefore credit the creators of ideas, inventions, work, and artefacts, and respect copyrights, patents, trade secrets, license agreements, and other methods of protecting authors' works.

#### Respect Privacy

- The responsibility of respecting privacy applies to machine learning research in multiple ways. Researchers should be familiar with the various definitions and forms of privacy and should understand the rights and responsibilities associated with the collection and use of personal information.
- Data should be used in ways consistent with their licences. Researchers should only use personal information for legitimate ends (e.g., those consistent with approval from an ethics review board) and without violating the rights of individuals and groups.
- The ethical considerations in this Code should supersede technical legality in the use of data and technologies, i.e. researchers must go beyond the minimal ethical requirements (avoid ethics shirking). This requires taking precautions to prevent re-identification of anonymized data, unauthorized data collection or data collected without consent, ensuring the continuous accuracy of data, understanding the provenance of the data, and protecting it from unauthorized access and accidental disclosure.
- Data should be collected under appropriate ethical approvals and such approvals must be acknowledged in papers and other contributions.

#### Honour Confidentiality

- Researchers and reviewers are often entrusted with confidential information such as trade secrets, client data, non-public business strategies, financial information, research data, pre-publication scholarly articles, and patent applications. Researchers should protect confidentiality except in cases where it is evidence of the violation of law, of organizational regulations, or of the Code.
- In these cases, the nature or contents of that information should not be disclosed except to appropriate authorities. Researchers should consider thoughtfully whether such disclosures are consistent with the Code.

### Concerns and Remediation

This Code should be read in concert with the ICLR Code of Conduct. Concerns can be raised regarding any conduct and contributions that contravene this Code. Where ethical concerns are raised during the review of research contributions, or in the conduct of scientific communication and exchange, this Code serves as an additional basis for remediation of possible violation. ICLR reserves the right to reject and refuse the presentation of any scientific work found to violate the ethical guidelines put forth here, at any point. Processes for raising concerns and remediation are described in the Call for Papers/Author Guide and in the Code of Conduct.

### Related Codes and References

Researchers will already have made commitments to codes of ethics and conduct, and to ethical research practices, through their research institution or other professional affiliations, and should remind themselves and consult those codes.

Codes that will be of broader relevance and interest, and that have informed this Code, include:

- AAAI Code Of Professional Ethics And Conduct and the ACM Code of Ethics and Professional Conduct.
- The European Code Of Conduct For Research Integrity and the UKRIO Code of Practice for Research.
- The Committee on Publication Ethics
- Organisational AI principles including the Asilomar AI Principles, IBM Principles for Trust and Transparency,  Google AI principles, Microsoft AI Principles, the Montreal Declaration on Responsible AI, the OECD AI principles, the Toronto Declaration, and the Treaty of Waitangi.


### Definitions

Research. For the purposes of this Code, “research”1: “... is to be understood as original investigation undertaken in order to gain knowledge and understanding. It includes work of direct relevance to the needs of commerce, industry, and to the public and voluntary sectors; scholarship2; the invention and generation of ideas, images, performances, artefacts including design, where these lead to new or substantially improved insights; and the use of existing knowledge in experimental development to produce new or substantially improved materials, devices, products and processes, including design and construction. It excludes routine testing and routine analysis of materials, components and processes such as for the maintenance of national standards, as distinct from the development of new analytical techniques. It also excludes the development of teaching materials that do not embody original research.”

Organisations and Researchers.  For the purposes of this Code, “organisations” refers to any bodies that conduct, host, sponsor or fund research; employ, support or host researchers; teach research students; or allow research to be carried out under their auspices. “Researchers” refers to any person who conducts and contributes to research, including but not limited to: an employee; an independent contractor or consultant; a research student; a visiting or emeritus member of staff; a member of staff on a joint clinical or honorary contract; or project managers and coordinators.

1 by the Research Assessment Exercise (Research Assessment Exercise 2008, p. 5)

2 Scholarship… is defined as the creation, development and maintenance of the intellectual infrastructure of subjects and disciplines, in forms such as dictionaries, scholarly editions, catalogues and contributions to major research databases.

## Reviewing a submission: step-by-step

Summarized in one sentence, a review aims to determine whether a submission will bring sufficient value to the community and contribute new knowledge. The process can be broken down into the following main reviewer tasks:

1. Read the paper: It's important to carefully read through the entire paper, and to look up any related work and citations that will help you comprehensively evaluate it. Be sure to give yourself sufficient time for this step.
2. While reading, consider the following:
    1. Objective of the work: What is the goal of the paper? Is it to better address a known application or problem, draw attention to a new application or problem, or to introduce and/or explain a new theoretical finding? A combination of these? Different objectives will require different considerations as to potential value and impact.
    2. Strong points: is the submission clear, technically correct, experimentally rigorous, reproducible, does it present novel findings (e.g. theoretically, algorithmically, etc.)?
    3. Weak points: is it weak in any of the aspects listed in b.?
    4. Be mindful of potential biases and try to be open-minded about the value and interest a paper can hold for the entire ICLR community, even if it may not be very interesting for you.
3. Answer four key questions for yourself to make a recommendation to Accept or Reject:
    1. What is the specific question and/or problem tackled by the paper?
    2. Is the approach well motivated, including being well-placed in the literature?
    3. Does the paper support the claims? This includes determining if results, whether theoretical or empirical, are correct and if they are scientifically rigorous.
    4. What is the significance of the work? Does it contribute new knowledge and sufficient value to the community? Note, this does not necessarily require state-of-the-art results. Submissions bring value to the ICLR community when they convincingly demonstrate new, relevant, impactful knowledge (incl., empirical, theoretical, for practitioners, etc).
4. Write your initial review, organizing it as follows:
    1. Summarize what the paper claims to contribute. Be positive and constructive.
    2. List strong and weak points of the paper. Be as comprehensive as possible.
    3. Clearly state your initial recommendation (accept or reject) with one or two key reasons for this choice.
    4. Provide supporting arguments for your recommendation.
    5. Ask questions you would like answered by the authors to help you clarify your understanding of the paper and provide the additional evidence you need to be confident in your assessment.
    6. Provide additional feedback with the aim to improve the paper. Make it clear that these points are here to help, and not necessarily part of your decision assessment.
5. Complete the CoE report: ICLR has adopted the following Code of Ethics (CoE). When submitting your review, you'll be asked to complete a CoE report for the paper. The report is a simple form with two questions. The first asks whether there is a potential violation of the CoE. The second is relevant only if there is a potential violation and asks the reviewer to explain why there may be a potential violation. In order to answer these questions, it is therefore important that you read the CoE before starting your reviews.
6. Engage in discussion: The discussion phase at ICLR is different from most conferences in the AI/ML community. During this phase, reviewers, authors and area chairs engage in asynchronous discussion and authors are allowed to revise their submissions to address concerns that arise. It is crucial that you are actively engaged during this phase. Maintain a spirit of openness to changing your initial recommendation (either to a more positive or more negative) rating.
7. Borderline paper meeting: Similarly to last year, the ACs are encouraged to (virtually) meet and discuss with reviewers only for borderline cases . ACs will reach out to schedule this meeting. This is to ensure active discussions among reviewers, and well-thought-out decisions. ACs will schedule the meeting and facilitate the discussion. For a productive discussion, it is important to familiarize yourself with other reviewers' feedback prior to the meeting. Please note that we will be leveraging information for reviewers who failed to attend this meeting (excluding emergencies).
8. Provide final recommendation: Update your review, taking into account the new information collected during the discussion phase, and any revisions to the submission. (Note that reviewers can change their reviews after the author response period.)  State your reasoning and what did/didn't change your recommendation throughout the discussion phase.

## Review Examples

Here are two sample reviews from previous conferences that give an example of what we consider a good review for the case of leaning-to-accept and leaning-to-reject.

### Review for a Paper where Leaning-to-Accept

This paper proposes a method, Dual-AC, for optimizing the actor (policy) and critic (value function) simultaneously which takes the form of a zero-sum game resulting in a principled method for using the critic to optimize the actor. In order to achieve that, they take the linear programming approach of solving the Bellman optimality equations, outline the deficiencies of this approach, and propose solutions to mitigate those problems. The discussion on the deficiencies of the naive LP approach is mostly well done. Their main contribution is extending the single step LP formulation to a multi-step dual form that reduces the bias and makes the connection between policy and value function optimization much clearer without losing convexity by applying a regularization. They perform an empirical study in the Inverted Double Pendulum domain to conclude that their extended algorithm outperforms the naive linear programming approach without the improvements. Lastly, there are empirical experiments done to conclude the superior performance of Dual-AC in contrast to other actor-critic algorithms.

Overall, this paper could be a significant algorithmic contribution, with the caveat for some clarifications on the theory and experiments. Given these clarifications in an author response, I would be willing to increase the score.

For the theory, there are a few steps that need clarification and further clarification on novelty. For novelty, it is unclear if Theorem 2 and Theorem 3 are both being stated as novel results. It looks like Theorem 2 has already been shown in "Randomized Linear Programming Solves the Discounted Markov Decision Problem in Nearly-Linear Running Time”. There is a statement that “Chen &amp; Wang (2016); Wang (2017) apply stochastic first-order algorithms (Nemirovski et al., 2009) for the one-step Lagrangian of the LP problem in reinforcement learning setting. However, as we discussed in Section 3, their algorithm is restricted to tabular parametrization”. Is your Theorem 2 somehow an extension? Is Theorem 3 completely new?

This is particularly called into question due to the lack of assumptions about the function class for value functions. It seems like the value function is required to be able to represent the true value function, which can be almost as restrictive as requiring tabular parameterizations (which can represent the true value function). This assumption seems to be used right at the bottom of Page 17, where U^{pi*} = V^*. Further, eta\_v must be chosen to ensure that it does not affect (constrain) the optimal solution, which implies it might need to be very small. More about conditions on eta\_v would be illuminating.

There is also one step in the theorem that I cannot verify. On Page 18, how is the squared removed for difference between U and Upi? The transition from the second line of the proof to the third line is not clear. It would also be good to more clearly state on page 14 how you get the first inequality, for || V^* ||\_{2,mu}^2.

For the experiments, the following should be addressed.

1. It would have been better to also show the performance graphs with and without the improvements for multiple domains.

2. The central contribution is extending the single step LP to a multi-step formulation. It would be beneficial to empirically demonstrate how increasing k (the multi-step parameter) affects the performance gains.

3. Increasing k also comes at a computational cost. I would like to see some discussions on this and how long dual-AC takes to converge in comparison to the other algorithms tested (PPO and TRPO).

4. The authors concluded the presence of local convexity based on hessian inspection due to the use of path regularization. It was also mentioned that increasing the regularization parameter size increases the convergence rate. Empirically, how does changing the regularization parameter affect the performance in terms of reward maximization? In the experimental section of the appendix, it is mentioned that multiple regularization settings were tried but their performance is not mentioned. Also, for the regularization parameters that were tried, based on hessian inspection, did they all result in local convexity? A bit more discussion on these choices would be helpful.

Minor comments:

1. Page 2: In equation 5, there should not be a 'ds' in the dual variable constraint

### Review for a Paper where Leaning-to-Reject

This paper introduces a variation on temporal difference learning for the function approximation case that attempts to resolve the issue of over-generalization across temporally-successive states. The new approach is applied to both linear and non-linear function approximation, and for prediction and control problems. The algorithmic contribution is demonstrated with a suite of experiments in classic benchmark control domains (Mountain Car and Acrobot), and in Pong.

This paper should be rejected because (1) the algorithm is not well justified either by theory or practice, (2) the paper never clearly demonstrates the existence of problem they are trying to solve (nor differentiates it from the usual problem of generalizing well), (3) the experiments are difficult to understand, missing many details, and generally do not support a significant contribution, and (4) the paper is imprecise and unpolished.

Main argument

The paper does not do a great job of demonstrating that the problem it is trying to solve is a real thing. There is no experiment in this paper that clearly shows how this temporal generalization problem is different from the need to generalize well with function approximation. The paper points to references to establish the existence of the problem, but for example the Durugkar and Stone paper is a workshop paper and the conference version of that paper was rejected from ICLR 2018 and the reviewers highlighted serious issues with the paper—that is not work to build upon. Further the paper under review here claims this problem is most pressing in the non-linear case, but the analysis in section 4.1 is for the linear case.

The resultant algorithm does not seem well justified, and has a different fixed point than TD, but there is no discussion of this other than section 4.4, which does not make clear statements about the correctness of the algorithm or what it converges to. Can you provide a proof or any kind of evidence that the proposed approach is sound, or how it's fixed point relates to TD?

The experiments do not provide convincing evidence of the correctness of the proposed approach or its utility compared to existing approaches. There are so many missing details it is difficult to draw many conclusions:

1. What was the policy used in exp1 for policy evaluation in MC?
2. Why Fourier basis features?
3. In MC with DQN how did you adjust the parameters and architecture for the MC task?
4. Was the reward in MC and Acrobot -1 per step or something else
5. How did you tune the parameters in the MC and Acrobot experiments?
6. Why so few runs in MC, none of the results presented are significant?
7. Why is the performance so bad in MC?
8. Did you evaluate online learning or do tests with the greedy policy?
9. How did you initialize the value functions and weights?
10. Why did you use experience replay for the linear experiments?
11. IN MC and Acrobot why only a one layer MLP?

Ignoring all that, the results are not convincing. Most of the results in the paper are not statistically significant. The policy evaluation results in MC show little difference to regular TD. The Pong results show DQN is actually better. This makes the reader wonder if the result with DQN on MC and Acrobot are only worse because you did not properly tune DQN for those domains, whereas the default DQN architecture is well tuned for Atari and that is why you method is competitive in the smaller domains.

The differences in the “average change in value plots” are very small if the rewards are -1 per step. Can you provide some context to understand the significance of this difference? In the last experiment linear FA and MC, the step-size is set equal for all methods—this is not a valid comparison. Your method may just work better with alpha = 0.1.

The paper has many imprecise parts, here are a few:

1. The definition of the value function would be approximate not equals unless you specify some properties of the function approximation architecture. Same for the Bellman equation
2. equation 1 of section 2.1 is neither an algorithm or a loss function
3. TD does not minimize the squared TD. Saying that is the objective function of TD learning in not true
4. end of section 2.1 says “It is computed as” but the following equation just gives a form for the partial derivative
5. equation 2, x is not bounded
6. You state TC-loss has an unclear solution property, I don't know what that means and I don't think your approach is well justified either
7. Section 4.1 assumes linear FA, but its implied up until paragraph 2 that it has not assumed linear
8. treatment of n\_t in alg differs from appendix (t is no time episode number)
9. Your method has a n\_t parameter that is adapted according to a schedule seemingly giving it an unfair advantage over DQN.
10. Over-claim not supported by the results: “we see that HR-TD is able to find a representation that is better at keeping the target value separate than TC is “. The results do not show this.
11. Section 4.4 does not seem to go anywhere or produce and tangible conclusions

Things to improve the paper that did not impact the score:

1. It's hard to follow how the prox operator is used in the development of the alg, this could use some higher level explanation
2. Intro p2 is about bootstrapping, use that term and remove the equations
3. It's not clear why you are talking about stochastic vs deterministic in P3
4. Perhaps you should compare against a MC method in the experiments to demonstrate the problem with TD methods and generalization
5. Section 2: “can often be a regularization term” &gt;&gt; can or must be?
6. update law is an odd term
7. tends to alleviate” &gt;&gt; odd phrase
8. section 4 should come before section 3
9. Alg 1 in not helpful because it just references an equation
10. section 4.4 is very confusing, I cannot follow the logic of the statements
11. Q learning &gt;&gt; Q-learning
12. Not sure what you mean with the last sentence of p2 section 5
13. where are the results for Acrobot linear function approximation
14. appendix Q-learning with linear FA is not DQN (table 2)
"""
METAREVIEWER_GUIDELINES = """
# Area Chair Guidelines

Area Chairs play a critical role in curating the technical programme for ICLR. Use this as a resource for any questions related to your role as an Area Chair. Thank you for your contribution!


## Code of Ethics

This year, ICLR continues to practice the Code of Ethics which needs to be acknowledged and adhered to by all participants including authors and reviewers. If any submission, review, or discussion comments raise ethical concerns, please flag the problematic content and contact the Program Chairs.

## ICLR Code of Ethics

Responsible Stewardship. The International Conference on Learning Representations (ICLR) is committed to promoting good conduct and a reflexive and responsible approach to research and its applications, especially with respect to research and development related to machine learning and artificial intelligence. This Code is a vital part of our continuing effort to encourage reflection of the wider impacts of work that is considered by the conference, and to encourage work that consistently supports the responsible stewardship of trustworthy research that advances knowledge, public good and well-being.

Aims. This Code of Ethics provides general ethical principles, applicable to both individual researchers and to organisations that carry out, fund, host, or are otherwise involved in research, and associated with ICLR. The Code should not be seen as prescriptive but as a set of principles to guide ethical, responsible research.

Positive Action. This code applies to all contributors to ICLR, including reviewers, authors, speakers, organisers of the conference, tutorials, workshops, sponsors, and attendees. ICLR's contributors are expected to acknowledge this code, and whenever necessary, include a discussion in their contributions that expands on the wider impacts of their work, using this Code as one source of ethical considerations.

Acknowledgments. This code is influenced by and borrows from the ACM Code of Ethics and Professional Conduct, the UKRIO Code of Practice for Research, the European Code Of Conduct For Research Integrity, the Committee on Publication Ethics, and input from a broad range of community groups in machine learning.

### General Ethical Principles

- Contribute to society and to human well-being.
- Uphold high standards of scientific excellence.
- Avoid harm.
- Be honest, trustworthy and transparent.
- Be fair and take action to avoid discrimination.
- Respect the work required to produce new ideas and artefacts.
- Respect privacy.
- Honour confidentiality.

#### Contribute to Society and to Human Well-being

- Researchers must acknowledge that all people globally are stakeholders in computing, and that we should use our skills for the benefit of society, its members, and our natural environment.
- Research should minimise negative consequences, including threats to health, safety, personal security, and privacy. In order to do so, it must take into consideration a multiplicity of socio-economic factors and geographies.
- When the interests of multiple groups conflict, the needs of those less advantaged should be given increased attention and priority.
- Researchers should consider whether the results of their efforts will respect diversity, will be used in socially responsible ways, will meet social needs, and will be broadly accessible.

#### Uphold High Standards of Scientific Excellence

- Researchers and organisations should strive for excellence when conducting research and aim to produce and disseminate work of the highest quality.  This implies a commitment to open enquiry, intellectual rigor, integrity, and collaboration.
- Findings must be reported accurately and honestly. Researchers must not make deliberately false or misleading claims, fabricate or falsify data, or misrepresent results. Methods and results should be presented in a way that is transparent and reproducible.
- Where human subjects are involved in the research process (e.g., in direct experiments, or as annotators), the need for ethical approvals from an appropriate ethical review board should be assessed and reported.
- All contributions to the research must be acknowledged, and agreements relating to intellectual property, publication and authorship must be complied with.

#### Avoid Harm

- Here, "harm" means negative consequences. Well-intended actions, including those that accomplish desired outcomes, may lead to harm.
- When that harm is unintended, those responsible are obliged to undo or mitigate the harm as much as possible. Avoiding harm begins with engaging with application domain experts, engagement with the communities that the research is intended to serve, and a careful consideration of potential impacts on all those affected.
- When harm is an intentional part of the system, those responsible are obligated to ensure that the harm is ethically justified.
- Harm to the natural environment, whether in the process of producing research or in its application, should also be considered. In all cases, ensure that all harm is minimized.
- The consequences of data aggregation and emergent properties of systems should be carefully analyzed, including those that can become integrated into the structure of society. Researchers have an additional obligation to report any signs of system risks that might result in harm. For reporting, see the section at the end on Concerns and Remediation.

#### Be Honest, Trustworthy and Transparent

- Researchers should be honest about their qualifications, and about any limitations in their competence to complete a task.
- Researchers should provide full disclosure of all pertinent system capabilities, limitations, and potential problems to the appropriate parties, including any party that may deploy the system.
- Researchers should be open and transparent about any circumstances that might lead to either real or perceived conflicts of interest or otherwise tend to undermine the independence of their judgment.  Researchers must consider their competing interests, including from sources of the funding, and report any possible conflicts.
- Researchers should not misrepresent work that might be competing or related, and should not misrepresent an organization's policies or procedures.

#### Be Fair and Take Action not to Discriminate

- The values of equality, tolerance, respect for others, and justice govern this principle. The ICLR Code of Conduct provides additional details of expected behaviour at the Conference.
- Fairness requires that even careful decision processes provide some avenue for redress of grievances.
- Researchers should foster fair participation of all people—in their research, at the conference and generally—including those of underrepresented groups.
- The use of information and technology may cause new, or enhance existing, inequities. Technologies and practices should be as inclusive and accessible as possible and researchers should take action to avoid creating systems or technologies that disenfranchise or oppress people.

#### Respect the Work Required to Produce New Ideas and Artefacts

- Researchers must show respect for colleagues, research participants, society, ecosystems, cultural heritage and the environment.
- Developing new ideas, inventions, creative works, and computing artefacts creates value for society, and those who expend this effort should expect to gain value from and receive credit for their work.
- Researchers should therefore credit the creators of ideas, inventions, work, and artefacts, and respect copyrights, patents, trade secrets, license agreements, and other methods of protecting authors' works.

#### Respect Privacy

- The responsibility of respecting privacy applies to machine learning research in multiple ways. Researchers should be familiar with the various definitions and forms of privacy and should understand the rights and responsibilities associated with the collection and use of personal information.
- Data should be used in ways consistent with their licences. Researchers should only use personal information for legitimate ends (e.g., those consistent with approval from an ethics review board) and without violating the rights of individuals and groups.
- The ethical considerations in this Code should supersede technical legality in the use of data and technologies, i.e. researchers must go beyond the minimal ethical requirements (avoid ethics shirking). This requires taking precautions to prevent re-identification of anonymized data, unauthorized data collection or data collected without consent, ensuring the continuous accuracy of data, understanding the provenance of the data, and protecting it from unauthorized access and accidental disclosure.
- Data should be collected under appropriate ethical approvals and such approvals must be acknowledged in papers and other contributions.

#### Honour Confidentiality

- Researchers and reviewers are often entrusted with confidential information such as trade secrets, client data, non-public business strategies, financial information, research data, pre-publication scholarly articles, and patent applications. Researchers should protect confidentiality except in cases where it is evidence of the violation of law, of organizational regulations, or of the Code.
- In these cases, the nature or contents of that information should not be disclosed except to appropriate authorities. Researchers should consider thoughtfully whether such disclosures are consistent with the Code.

### Concerns and Remediation

This Code should be read in concert with the ICLR Code of Conduct. Concerns can be raised regarding any conduct and contributions that contravene this Code. Where ethical concerns are raised during the review of research contributions, or in the conduct of scientific communication and exchange, this Code serves as an additional basis for remediation of possible violation. ICLR reserves the right to reject and refuse the presentation of any scientific work found to violate the ethical guidelines put forth here, at any point. Processes for raising concerns and remediation are described in the Call for Papers/Author Guide and in the Code of Conduct.

### Related Codes and References

Researchers will already have made commitments to codes of ethics and conduct, and to ethical research practices, through their research institution or other professional affiliations, and should remind themselves and consult those codes.

Codes that will be of broader relevance and interest, and that have informed this Code, include:

- AAAI Code Of Professional Ethics And Conduct and the ACM Code of Ethics and Professional Conduct.
- The European Code Of Conduct For Research Integrity and the UKRIO Code of Practice for Research.
- The Committee on Publication Ethics
- Organisational AI principles including the Asilomar AI Principles, IBM Principles for Trust and Transparency,  Google AI principles, Microsoft AI Principles, the Montreal Declaration on Responsible AI, the OECD AI principles, the Toronto Declaration, and the Treaty of Waitangi.


### Definitions

Research. For the purposes of this Code, "research"1: "... is to be understood as original investigation undertaken in order to gain knowledge and understanding. It includes work of direct relevance to the needs of commerce, industry, and to the public and voluntary sectors; scholarship2; the invention and generation of ideas, images, performances, artefacts including design, where these lead to new or substantially improved insights; and the use of existing knowledge in experimental development to produce new or substantially improved materials, devices, products and processes, including design and construction. It excludes routine testing and routine analysis of materials, components and processes such as for the maintenance of national standards, as distinct from the development of new analytical techniques. It also excludes the development of teaching materials that do not embody original research."

Organisations and Researchers. For the purposes of this Code, "organisations" refers to any bodies that conduct, host, sponsor or fund research; employ, support or host researchers; teach research students; or allow research to be carried out under their auspices. "Researchers" refers to any person who conducts and contributes to research, including but not limited to: an employee; an independent contractor or consultant; a research student; a visiting or emeritus member of staff; a member of staff on a joint clinical or honorary contract; or project managers and coordinators.


# Discussion Period

Following the previous year's format, we do not have a multi-stage discussion. There is only one stage and then no changes to the papers are allowed and the AC/reviewers discussions start afterwards. Similarly to last year, we encourage Reviewer/AC virtual meetings (only for borderline papers). The ACs are required to organize a virtual AC/Reviewer meeting for each borderline paper. The AC is expected to summarize discussions from the meeting and post it in openreview. ACs are also encouraged to discuss their meta reviews with SACs via virtual meetings for cases they are unsure of. Meta reviews are due at the end of this stage.

## Your Roles and Action Items

### Reviewing Process Manager

Your first role is to help the Program Chairs manage the reviewing process for the thousands of submissions we expect to receive. When you are assigned a batch of papers to handle based on your research profile, please recommend a set of appropriate reviewers (you may skip this, and the reviewers will be assigned based on their research profiles only ), and when some of those reviewers are delinquent or not responsive, please help us assign alternate reviewers in a timely manner so that every submission gets a chance to be judged fairly and expertly. We will be looking for 3 quality reviews per paper.

- Vet and recommend reviewer assignments
- Identify delinquent reviewers and assign alternate reviewers

### Decision Maker

From the moment all papers are submitted, perhaps the most important role as AC is making decisions for the ICLR program. For every submission that goes through the reviewing process, please recommend whether it should be accepted or rejected. The recommendation should be accompanied by a metareview summarizing the reviews and the three stages of discussion, optionally adding your own view of the merits and limitations of the paper. If there is any disagreement among reviewers, the virtual meetings for those borderline papers should provide solid ground for resolving any disagreement. The Senior Area Chairs and Program Chairs will actively engage in this decision making and help with the metareviews, so please do not hesitate to contact your SAC or the PCs if you find the need to discuss any submission assigned to you.

- Flag papers for desk reject
- Watch out for reviewers' flags for Code of Ethics violations. For all papers flagged, collect information, make an informed recommendation, and provide any evidence obtained (e.g., from the paper, discussion with author and/or reviewers). Please note the AC recommendation will be non-binding, and any of the flagged papers may be passed to the Ethics board for further review
- Engage in discussion with the reviewers to ultimately help you reach an informed decision (see next section)
- Organize virtual Reviewer/AC meetings only for borderline papers
- Write metareviews with recommendations for accept/reject

Among the important responsibilities of ACs is to ensure reviewers' judgments are in line with the new ICLR 2025 reviewer guidelines.

Also, it is important to make sure that the language used in the reviews (including ACs' own metareviews) are constructive and polite. Here are useful advice to review:

### Discussion Moderator

Each submission is considered a forum on its own, and you as an AC have full responsibility in encouraging and moderating active discussions. When a submission does not receive enough attention that it deserves or requires, you should actively engage with the assigned reviewers as well as the authors and ask for clarification or argument. You should also "moderate" discussion by discouraging the participation in any discussion that is irrelevant to scientific claims and merits of a submission.

- Encourage reviewers to respond to author rebuttals
- Moderate the discussions so that they are not toxic and focus on the scientific merits, limitations, and clarifications
- Identify any violations of Code of Ethics during the discussion phase

### Discussion Participant

We have invited you to serve as an AC because of your expertise and reputation. In other words, your assessment of a submission is a critical factor behind the entire decision-making process, and we ask you to actively participate in discussions not only as a moderator but also as a scientific expert. You are encouraged to ask authors (as well as any other commentator of the submission including assigned reviewers) for clarification. In other words, please be an active participant in discussion.

- Participate in discussions with your own view of the paper
- Ask authors for clarifications when needed to understand and judge the contributions fairly

## Meta-Review Guideline

As an AC, we trust you to make an informed recommendation based on sufficient knowledge and justified analysis of the paper and to clearly and thoroughly convey this recommendation and reasoning behind it to the authors. To this end, you have full freedom in writing your meta-reviews, although we list below a few items that have been found useful by authors when they were presented with meta-reviews. Aim to write a meta-review of at least 60 words.

1. A concise description of the submission's main content (scientific claims and findings) based on your own reading and reviewers' characterization, including the paper's strengths and weaknesses. Ideally this description should contain both what is discussed in the submission and what is missing from the submission.

2. A concise summary of discussion. Unlike other conferences in which there is only a single round of back-and-forth between reviewers and authors, ICLR distinguishes itself by providing many weeks of discussion. These weeks of discussion and meetings not only serve the purpose of decision making but also to contribute scientifically to improve the submission. We thus encourage the AC to summarize the discussion in the meta-review. In particular, it is advised that the AC lists the points that were raised by the reviewers, how each of these points was addressed by the authors and whether you as the AC found each point worth consideration in decision making.

3. Your recommendation and justification. The meta-review should end with a clear indication of your recommendation. Your recommendation must be justified based on the content and discussion of the submission (i.e., the points you described above.)
"""
