import warp as wp
import warp.sim
import warp.sim.render

import numpy as np
import trimesh
import math

def load_warp_mesh(path):
    mesh = trimesh.load(path, process=False)
    vertices = np.array(mesh.vertices, dtype=np.float32)
    print(vertices.min(), vertices.max())
    faces = np.array(mesh.faces, dtype=np.int32)
    return wp.sim.Mesh(vertices, faces)

def create_usd_with_two_meshes(mesh_path_1, mesh_path_2, output_usd_path):
    # Load meshes
    mesh1 = load_warp_mesh(mesh_path_1)
    mesh2 = load_warp_mesh(mesh_path_2)

    # Create a model builder
    builder = wp.sim.ModelBuilder()

    # Set identical material properties
    ke = 1e5
    kd = 100.0
    kf = 100.0

    # Add a body and shape for mesh 1
    body1 = builder.add_body(origin=wp.transform((0.0, 0.0, 0.0), wp.quat_identity()))
    builder.add_shape_mesh(
        body=body1,
        mesh=mesh1,
        pos=wp.vec3(0.0, 0.0, 0.0),
        rot=wp.quat_identity(),
        scale=wp.vec3(1.0),
        ke=ke,
        kd=kd,
        kf=kf,
        density=0.0
    )

    # Add a body and shape for mesh 2
    body2 = builder.add_body(origin=wp.transform((0.0, 0.0, 0.0), wp.quat_identity()))
    builder.add_shape_mesh(
        body=body2,
        mesh=mesh2,
        pos=wp.vec3(0.0, 0.0, 0.0),  # adjust for offset if needed
        rot=wp.quat_identity(),
        scale=wp.vec3(1.0),
        ke=ke,
        kd=kd,
        kf=kf,
        density=0.0
    )

    # Finalize model
    model = builder.finalize()
    model.ground = False

    # Setup renderer
    renderer = wp.sim.render.SimRenderer(model, output_usd_path)

    # Initial state (needed by renderer)
    state = model.state()
    wp.sim.eval_fk(model, model.joint_q, model.joint_qd, None, state)

    # Render a single frame
    renderer.begin_frame(0.0)
    renderer.render(state)
    renderer.end_frame()
    renderer.save()

    print(f"✅ Exported USD to: {output_usd_path}")

# Example usage
if __name__ == "__main__":
    create_usd_with_two_meshes(
        mesh_path_1="/home/ /Downloads/letters_3d/A_3d.obj",
        mesh_path_2="/home/ /PycharmProjects/ray-casting/meshes/mesh_A_mid.obj",
        output_usd_path="compare_meshes.usd"
    )
