import trimesh
import time
import numpy as np

def normalize_mesh_to_unit_box(mesh: trimesh.Trimesh) -> trimesh.Trimesh:
    # Center the mesh
    centroid = mesh.bounds.mean(axis=0)
    mesh.vertices -= centroid

    # Scale the mesh to fit in [-1, 1]^3
    max_extent = np.max(np.abs(mesh.vertices))
    if max_extent > 0:
        mesh.vertices /= max_extent

    return mesh

mesh1 = trimesh.load_mesh('meshes/mesh_koala_collision_outer.obj')
# mesh1 = trimesh.load_mesh('/home/ /Downloads/Teapot.obj')
# mesh1.fill_holes()
# print(mesh1.vertices.shape)
mesh1.show()
# mesh1.process()
# mesh1 = normalize_mesh_to_unit_box(mesh1)
# mesh1.export('/home/ /Downloads/H_3d.obj')
# mesh1.show()
# mesh1 = trimesh.load_mesh('/home/ /Downloads/ribcage.obj')
# mesh1.show()

# rotation_x_90 = np.array([
#         [1, 0, 0],
#         [0, 0, -1],
#         [0, 1, 0]
#     ])
#
# mesh1.vertices = mesh1.vertices @ rotation_x_90
# print(mesh1.vertices[:, 1].max())
# mesh1.show()
# mesh1.export('meshes/mesh_fox_0lvl_rot.obj')
# if not mesh1.is_volume:
#     print("mesh 1 is not volume")
#     components = mesh1.split(only_watertight=True)  # Set to True if you only want watertight components
#
#     mesh1 = max(components, key=lambda m: len(m.faces))
#     mesh1.show()
# mesh2 = trimesh.load_mesh('meshes/mesh_tree_27_inner.obj')
# if not mesh2.is_volume:
#     print("mesh 2 is not volume")
#     components = mesh2.split(only_watertight=True)  # Set to True if you only want watertight components
#
#     mesh2 = max(components, key=lambda m: len(m.faces))
#     mesh2.show()
# mesh1.show()
# mesh2.show()

# mesh1.show()
# print(mesh1.vertices[0])
# mesh1.vertices = mesh1.vertices * 0.0035
# print(mesh1.vertices[0])
# mesh1.export("meshes/armadillo_s.obj")
print(len(mesh1.vertices))
print(len(mesh1.faces))

# both_shell_verts = np.concatenate((np.array(mesh1.vertices), np.array(mesh2.vertices)), axis=0)
# both_shell_faces = np.concatenate((np.array(mesh1.faces), np.array(mesh2.faces) + len(mesh1.vertices)), axis=0)
# both_shells = trimesh.Trimesh(both_shell_verts, both_shell_faces)
# both_shells.export("meshes/mesh_tree_27_both_wt.obj")
