import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
# plt.rcParams['font.family'] = 'serif'

mpl.rcParams.update({
    'font.family': 'serif',
    'font.serif': ['Times New Roman', 'Times', 'Nimbus Roman', 'Liberation Serif'],
    'mathtext.fontset': 'custom',
    'mathtext.rm': 'Times New Roman',
    'font.weight': 'regular',
    'axes.labelweight': 'regular'
})


# without_shell = np.load('exp_results/cloth/time_koala.npz')['time']
# with_shell = np.load('exp_results/cloth/time_koala_with_shell.npz')['time']
# with_bbox = np.load('exp_results/cloth/time_koala_with_shell.npz')['time']

# without_shell = np.load('assets/collision_detection_time.npz')['time'][:200]
# with_shell = np.load('assets/collision_detection_time_with_shell.npz')['time'][:200]
# with_bbox = np.load('assets/collision_detection_time_with_bbox.npz')['time'][:200]

without_shell = np.load('exp_results/collision/time_tree.npz')['time'][:200]
with_shell = np.load('exp_results/collision/time_with_shell_tree.npz')['time'][:200]
with_bbox = np.load('exp_results/collision/time_with_bbox_tree.npz')['time'][:200]

plt.figure(figsize=(5, 4))
plt.plot(np.arange(200), without_shell, label='Without Accel.', color='tab:red', linewidth=2)
plt.plot(np.arange(200), with_bbox, label='With AABB', color='tab:green', linewidth=2)  # New line
plt.plot(np.arange(200), with_shell, label='With GIOM', color='tab:blue', linewidth=2)

# plt.axvline(x=35)
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)
plt.xlim(left=0, right=200)
plt.ylim(bottom=0, top=20)
plt.legend(loc='right', fontsize=16, frameon=False)
plt.xlabel('Frame', fontsize=18)
plt.ylabel('Collision Detection\nTime (ms)', fontsize=18)
plt.tick_params(axis='both', labelsize=16)
plt.yticks(np.linspace(0, 20, 5))
plt.tight_layout()
plt.savefig('/home/ /3d_vnn_ref/collision_detection_time_new.pdf', dpi=600)
plt.show()
