import torch

# Check if CUDA is available
if not torch.cuda.is_available():
    print("CUDA is not available. Exiting.")
    exit()

# Set default device to GPU
torch.set_default_device('cuda')

# Create a tensor (automatically on GPU)
a = torch.tensor([1.0, 2.0, 3.0])
b = torch.tensor([4.0, 5.0, 6.0])

# Perform a simple operation
c = a + b

# Print results
print("Tensor a:", a)
print("Tensor b:", b)
print("Tensor c = a + b:", c)
print("Device of c:", c.device)
