import argparse

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        '-d', '--dataset_name',
        help="Dataset to use; either 'mnist', 'cifar10' or 'svhn'",
        type=str, default='cifar10'
    )
    parser.add_argument(
        '-l', '--loss',
        help="Loss to use; either 'CE', 'KL', 'Rao', or 'g'",
        type=str, default='CE'
    )

    parser.add_argument(
        '--attack', '-a',
        type=str, default='pgdi'
    )

    parser.add_argument(
        '--epsilon', '-e',
        type=str, default=0.03125
    )
    
    parser.add_argument(
        '--checkpoints_dir',
        type=str, default='model_ckpt'
    )

    parser.add_argument(
        '--depth_method', '-dm',
        default='int_w_halfs_pace', type=str
        )

    parser.add_argument(
        '--K', '-k',
        help="Depth parameter",
        type=int, default=10000
    )

    parser.add_argument(
        '--device', '-dv',
        type=int, default=0
    )

    parser.add_argument(
        '--transformer',
        default=True
    )

    parser.add_argument(
        '--model_type', '-type',
        type=str, default="ViT-B_16"
    )
    parser.add_argument(
        '--data_dir',
        type=str, default='data')
    parser.add_argument(
        '--adv_path',
        type=str, default='detectors/adv_data/'
    )
    args = parser.parse_args()
    return args



