import numpy as np
import matplotlib.pyplot as plt


####Estimation of Delta
N=1000000
Eps = [0.05,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,0.95]
X = [np.log(eps + (1-eps)*np.exp(np.random.normal(0,2,N))) for eps in Eps]
avg = np.array([np.mean(x) for x in X])
err = np.array([np.std(x)/np.sqrt(N) for x in X])
plt.plot(Eps,avg)
plt.fill_between(Eps, avg - err, avg + err, alpha=0.2)
plt.show()

####Estimation of Sigma
X = [np.log(eps + (1-eps)*np.exp(np.random.normal(0,1,(N,10)))) for eps in Eps]
sigma = np.array([np.std(x,axis=0) for x in X])
sigma_avg = np.mean(sigma,axis=1)
sigma_err = np.std(sigma,axis=1)/np.sqrt(10)
plt.plot(Eps,sigma_avg)
plt.fill_between(Eps, sigma_avg - sigma_err, sigma_avg + sigma_err, alpha=0.2)
plt.xticks([0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9])
plt.show()



