# DDM4signal (A temp name, and will be renamed in the future)

This is a repository for the Wireless Signal Recognition (WSR) based on PyTorch, integrating various signal datasets, models, and model experiment pipelines. We try to provide a user-transparent and easy-to-use benchmarking interface. Currently, the model name of the TSDDAE is "signal", we will modify this in the future.

# Requirements and Installation

- PyTorch >= 2.2.0
- sklearn
- Optuna (if you want hyperparameters optimization)
- matplotlib, seaborn (if you want visualization)

# Get started

## Running an existing baseline model

```bash
python main.py -m model_name -d dataset_name -t task_name -g 0 --load_from_pretrained
```

*optional arguments*:

``--model -m ``    name of models

``--task -t``    name of task

``--dataset -d``    name of datasets

``--gpu -g``    controls which gpu you will use. If you do not have gpu, set -g -1.

``--load_from_pretrained`` will load the model from a default checkpoint.

``--compile`` will use the ``torch.compile`` optimization. (still under development)

Note: we also provide the few_shot and the probe experiments interface in the ``few_shot.py`` and the ``probe.py`` (Still under development). 



For running TSDDAE, you may

```bash
python main.py -m signal -d RML2016.10a -t train -g 0
```

## Model config

We provide two ways of modifying the hyperparameters of the model

1. By specifying parameters in the experiment function in ``main.py``.
2. By modifying the ``config.yaml`` file in each model folder in the ddm4signal/models.

Note: the first method has higher priority than the second.

## Pipeline support

If you want to add new pipelines, you need to

1. Inherit the BasePipe from ``ddm4signal.pipeline.base_pipe``.

2. Register the pipeline name using ``register_pipe`` in ``ddm4signal.pipeline.__init__``.

3. Add the pipeline name and file path to the ``SUPPORTED_PIPES`` variable in ``ddm4signal.pipeline.__init__``.

4. Write the pipeline's operation logic.

5. Add the task name and pipeline name to ``supported.yaml`` in the ddm4signal folder.

The pipeline calling logic has been encapsulated in the ``experiment.py`` file in the ``ddm4signal`` folder.

## Dataset support

Similar to the pipeline support, if you want to add new datasets, you need to

1. Inherit the BaseDataset from ``ddm4signal.dataset.base_dataset``.

2. Register the dataset name using ``register_dataset`` in ``ddm4signal.dataset.__init__``.

3. Add the dataset name and file path to the ``SUPPORTED_DATASETS`` variable in ``ddm4signal.dataset.__init__``.

4. Write the dataset's operation logic.

Note: we recommend you to write the @classmethod ``create`` if you want to enjoy the ``build_dataset`` from ``ddm4signal.dataset.__init__``. In ``create``, users can define the initial data loading and data partitioning. For task-specific dataset like ``MaskedDataset``, you may not write the ``create``.

We have not provide the dataset download function, so you may need to download the raw data. The dataset used in this work can be downloaded from:

- RML2016.10A (611 MB): https://www.kaggle.com/datasets/nolasthitnotomorrow/radioml2016-deepsigcom
- RML2016.10B (3.26 GB): https://www.kaggle.com/datasets/marwanabudeeb/rml201610b
- RML2018 (19.98 GB): https://www.kaggle.com/datasets/pinxau1000/radioml2018
- TechRec (1.76 GB): https://cloud.ilabt.imec.be/index.php/s/qrJCWgzQaGPfHPr
- ICARUS (4.76 GB):  https://genesys-lab.org/ICARUS

## Model support

Similar to the dataset support, if you want to add new models, you need to

1. Create a folder in the ``ddm4signal.models``.

2. Inherit the BaseModel from ``ddm4signal.models.base_model``.

3. Register the model name using ``register_model`` in ``ddm4signal.models.__init__``.

4. Add the model name and file path to the ``SUPPORTED_MODELS`` variable in ``ddm4signal.models.__init__``.

5. Write the model's operation logic.

6. Add ``config.yaml`` to specify the hyperparameters used in this model.

Note: we recommend you to write the @classmethod ``build_model_from_args`` if you want to enjoy the ``build_model`` from ``ddm4signal.model.__init__``. In ``build_model_from_args``, users can define the initial input hyperparameters.