# Functional_Pllay

## Requirements
All codes were run in the following environment:
- gudhi=3.8.0
- pytorch=1.13.1
- python 3.10.8
- torchvision=0.14.1

Run the following commands to create a new conda virtual enviroment and download all necessary packages:
```
conda create -n pllay python=3.10.8
conda config --append channels conda-forge
conda install --yes --file requirements.txt
```

Run
```
pip install -e.
```

To build eclayr

For cubical
```
cd ./eclayr/cubical/cython_eclayr
python setup.py build_ext --inplace
```

For alpha
```
cd ./eclayr/alpha/cython_eclayr
python setup.py build_ext --inplace
```

For VR
```
cd .//eclayr/vr/cython_eclayr
python setup.py build_ext --inplace
```

To run dataset, move to directory. For example, to run mnist,
```
cd ./MNIST
python preprocess.py
python run_data.py args
python run_noise.py args
```
where args is the name of the model that can be found in the ```run_data.py``` or ```run_noise.py``` script.
