# Code Submission


## Installation


Before installing this project,
and [after creating & activating your virtual environment](https://realpython.com/python-virtual-environments-a-primer/),
you must install JAX yourself because CPU and GPU backends require different installation commands.
See [here](https://jax.readthedocs.io/en/latest/installation.html) for instructions.
For the small examples, `pip install jax[cpu]` will suffice.
For the bigger experiments, a GPU is helpful.

Then, install the project via
```commandline
pip install .
```

To install the development-related dependencies, run
```commandline
pip install ".[dev]"
```

To install the experiment-related dependencies, first make sure
that JAX and pytorch are installed (JAX has been mentioned above;
for PyTorch, see [here](https://pytorch.org/), then run
```commandline
pip install ".[experiments]"
```


To install everything and in editable mode (recommended!),
first install JAX and PyTorch, and then run
```commandline
pip install -e ".[dev,experiments]"
```

## Running dev-related code

Run tests via
```
pytest
```
or use the pre-defined script
```commandline
make test
```

## Pre-commit hook

after activating your virtual environment, run
```commandline
pre-commit install
```
you only do this once! not every time you activate the environment.


The pre-commit hook is useful, because it implies that we do not accidentally (auto)format each others' code, which would lead to nasty merge conflicts.

# Experiments

All experiments are in experiments/, all source-code in src/.
The directories for data/, results/, and figures/ are for storing results and currently empty. Running code will fill them up.
(Downloading the UCI datasets, SuiteSparse matrices, and ImageNet is left to the user). Generating the PDE data can be done via experiments/applications/partial_differential_equations/make_data.py.
See scripts/ for example scripts for some of the experiments.
