import matplotlib.pyplot as plt
import numpy as np
from pathlib import Path

# Set font properties for all text
plt.rcParams.update({
    'font.weight': 'bold',
    'font.size': 24,
    'axes.titlesize': 28,
    'axes.labelsize': 24,
    'xtick.labelsize': 20,
    'ytick.labelsize': 20
})

# Data setup
actions = ['Action 1', 'Action 2']
cvar_means = [0.35, 0.55]  # CVaR estimates
cvar_ci_halfwidth = [0.05, 0.05]  # Confidence interval half-widths

# For overlapping case - adjust means to be closer together
cvar_means_overlap = [0.40, 0.50]  # Closer means for overlap
cvar_ci_halfwidth_overlap = [0.08, 0.08]  # Wider confidence intervals for overlap

# X locations
x = np.arange(len(actions))
width = 0.6

# Create subplots side by side
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 4))

# Plot 1: Non-overlapping bounds (original)
bars1 = ax1.bar(x, cvar_means, width, yerr=cvar_ci_halfwidth, capsize=10, color=['skyblue', 'lightcoral'])
ax1.set_ylabel('CVaR', weight='bold')
ax1.set_title('Non-overlapping Bounds', weight='bold')
ax1.set_xticks(x)
ax1.set_xticklabels(actions)
ax1.set_ylim(0.2, 0.7)
ax1.grid(True, axis='y', linestyle='--', alpha=0.6)

# Plot 2: Overlapping bounds (new)
bars2 = ax2.bar(x, cvar_means_overlap, width, yerr=cvar_ci_halfwidth_overlap, capsize=10, color=['skyblue', 'lightcoral'])
ax2.set_ylabel('CVaR', weight='bold')
ax2.set_title('Overlapping Bounds', weight='bold')
ax2.set_xticks(x)
ax2.set_xticklabels(actions)
ax2.set_ylim(0.2, 0.7)
ax2.grid(True, axis='y', linestyle='--', alpha=0.6)

plt.tight_layout()
save_path = Path('./dist_disc_plots/bounded_actions_plot.png')
save_path.parent.mkdir(parents=True, exist_ok=True)
plt.savefig(save_path, dpi=300, bbox_inches='tight')
plt.close()
