(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      7188,        213]
NotebookOptionsPosition[      6384,        190]
NotebookOutlinePosition[      6792,        207]
CellTagsIndexPosition[      6749,        204]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"CalculateRhoL3", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"cons", ",", "f", ",", "p", ",", "g", ",", "c1"}], "}"}], ",", 
    RowBox[{
     RowBox[{"\[Delta]1", "=", "a"}], ";", 
     RowBox[{"\[Delta]2", "=", "b"}], ";", 
     RowBox[{"\[Delta]3", "=", "c"}], ";", "\[IndentingNewLine]", 
     RowBox[{"cons", "=", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]2"}], ")"}]}]], "<=", "p", "<=", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Delta]1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Delta]2"}], ")"}]}]]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"f", "[", "p_", "]"}], ":=", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"p", "/", "2"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SuperscriptBox["\[Delta]1", "2"]}], ")"}], 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SuperscriptBox["\[Delta]2", "2"]}], ")"}]}], "+", 
            FractionBox["1", 
             RowBox[{"2", "p"}]], "-", 
            RowBox[{"\[Delta]1", " ", "\[Delta]2"}]}], ")"}], 
          FractionBox["1", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Delta]3", "2"]}]]}], "-", 
         RowBox[{
          FractionBox["\[Delta]3", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Delta]3", "2"]}]], "p"}]}], " ", ")"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "-", 
             FractionBox["1", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"1", "+", "y"}], ")"}]}]]}], ",", 
            RowBox[{
             RowBox[{"x", "+", "y"}], "<=", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox[
              RowBox[{"x", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"], "-", 
                 SuperscriptBox["y", "2"]}], ")"}]}], 
              RowBox[{"2", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"]}], ")"}], 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["y", "2"]}], ")"}]}]], "+", 
             FractionBox["y", 
              RowBox[{"1", "+", "y"}]]}], ",", 
            RowBox[{
             RowBox[{"x", "+", "y"}], ">", "1"}]}], "}"}]}], "}"}], ",", 
        "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c1", ",", "pstar"}], "}"}], "=", 
      RowBox[{"Assuming", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p", "\[Element]", "Reals"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Minimize", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"f", "[", "p", "]"}], ",", "cons"}], "}"}], ",", 
           RowBox[{"{", "p", "}"}]}], "]"}], "//", "Simplify"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[Rho]L", " ", "=", " ", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"\[Delta]2", ",", "\[Delta]3"}], "]"}], "+", 
       RowBox[{"\[Delta]1", " ", "c1"}]}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.909618545864368*^9, 3.909618629891245*^9}, {
  3.909618722589863*^9, 3.909618736030107*^9}},
 CellLabel->
  "In[5456]:=",ExpressionUUID->"8f912d42-c3f4-4325-8a8b-2c0e12bf2d1e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalculateRhoL3", "[", 
  RowBox[{"0.27", ",", "0.50", ",", "0.53"}], "]"}]], "Input",
 CellChangeTimes->{{3.909618691300949*^9, 3.909618701279649*^9}},
 CellLabel->
  "In[5457]:=",ExpressionUUID->"f954445c-ea84-414d-b2cc-b95eb5a25b1d"],

Cell[BoxData["0.6321888426201483`"], "Output",
 CellChangeTimes->{3.909618709417226*^9, 3.909618739902122*^9, 
  3.909622786933011*^9},
 CellLabel->
  "Out[5457]=",ExpressionUUID->"f83e7b9b-d4a6-4536-a5e4-7d44194e3336"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CalculateRhoL3", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
     RowBox[{"0", "<=", "a", "<", "1"}], ",", 
     RowBox[{"0", "<=", "b", "<", "1"}], ",", 
     RowBox[{"0", "<=", "c", "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.909619259976159*^9, 3.909619270908793*^9}, {
  3.909619305132843*^9, 3.909619334140469*^9}, {3.909623086081876*^9, 
  3.909623093768763*^9}},
 CellLabel->
  "In[5459]:=",ExpressionUUID->"f3633039-39f7-4458-a817-2014e7f7bec7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6322419618797527`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "0.2728990811199164`"}], ",", 
     RowBox[{"b", "\[Rule]", "0.5127526002568942`"}], ",", 
     RowBox[{"c", "\[Rule]", "0.5155221543456832`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.909619285046167*^9, {3.909619322350562*^9, 3.909619349661759*^9}, 
   3.909623102857656*^9},
 CellLabel->
  "Out[5459]=",ExpressionUUID->"daef57e2-d821-463a-8c24-73e9b14b9dab"]
}, Open  ]]
},
WindowSize->{808, 647},
WindowMargins->{{Automatic, 15}, {-20, Automatic}},
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) \
(2021\:5e746\:670819\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"98759581-cb30-4dd8-811d-eca31577566a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 4107, 116, 347, "Input",ExpressionUUID->"8f912d42-c3f4-4325-8a8b-2c0e12bf2d1e"],
Cell[CellGroupData[{
Cell[4690, 140, 259, 5, 30, "Input",ExpressionUUID->"f954445c-ea84-414d-b2cc-b95eb5a25b1d"],
Cell[4952, 147, 219, 4, 34, "Output",ExpressionUUID->"f83e7b9b-d4a6-4536-a5e4-7d44194e3336"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5208, 156, 653, 16, 44, "Input",ExpressionUUID->"f3633039-39f7-4458-a817-2014e7f7bec7"],
Cell[5864, 174, 504, 13, 34, "Output",ExpressionUUID->"daef57e2-d821-463a-8c24-73e9b14b9dab"]
}, Open  ]]
}
]
*)

