(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13556,        368]
NotebookOptionsPosition[     12472,        342]
NotebookOutlinePosition[     12879,        359]
CellTagsIndexPosition[     12836,        356]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.9096215522874393`*^9, 3.9096215736067142`*^9}},
 CellLabel->
  "In[5432]:=",ExpressionUUID->"ad39d31e-ac20-48a9-811c-6bfbeea183a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CalculateRhoL4", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "cons", ",", " ", "f", ",", "p", ",", "g", ",", "cons1", ",", "cons2", 
      ",", "umin"}], "}"}], ",", " ", 
    RowBox[{
     RowBox[{"\[Delta]0", "=", "a"}], ";", 
     RowBox[{"\[Delta]1", "=", "b"}], ";", 
     RowBox[{"\[Delta]2", "=", "c"}], ";", 
     RowBox[{"\[Delta]3", "=", "d"}], ";", "\[IndentingNewLine]", 
     RowBox[{"cons", "=", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Delta]2"}], ")"}]}]], "<=", "p", "<=", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Delta]1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Delta]2"}], ")"}]}]]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"f", "[", "p_", "]"}], ":=", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"p", "/", "2"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SuperscriptBox["\[Delta]1", "2"]}], ")"}], 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               SuperscriptBox["\[Delta]2", "2"]}], ")"}]}], "+", 
            FractionBox["1", 
             RowBox[{"2", "p"}]], "-", 
            RowBox[{"\[Delta]1", " ", "\[Delta]2"}]}], ")"}], 
          FractionBox["1", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Delta]3", "2"]}]]}], "-", 
         RowBox[{
          FractionBox["\[Delta]3", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Delta]3", "2"]}]], "p"}]}], " ", ")"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "-", 
             FractionBox["1", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"1", "+", "y"}], ")"}]}]]}], ",", 
            RowBox[{
             RowBox[{"x", "+", "y"}], "<=", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox[
              RowBox[{"x", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"], "-", 
                 SuperscriptBox["y", "2"]}], ")"}]}], 
              RowBox[{"2", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"]}], ")"}], 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["y", "2"]}], ")"}]}]], "+", 
             FractionBox["y", 
              RowBox[{"1", "+", "y"}]]}], ",", 
            RowBox[{
             RowBox[{"x", "+", "y"}], ">", "1"}]}], "}"}]}], "}"}], ",", 
        "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c1", ",", "pstar"}], "}"}], "=", 
      RowBox[{"Assuming", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p", "\[Element]", "Reals"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Minimize", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"f", "[", "p", "]"}], ",", "cons"}], "}"}], ",", 
           RowBox[{"{", "p", "}"}]}], "]"}], "//", "Simplify"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"cons1", "=", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", 
            FractionBox["1", 
             RowBox[{"1", "-", 
              SuperscriptBox["\[Delta]2", "2"]}]]}], ")"}], "2"], "+", 
         SuperscriptBox["y", "2"]}], "]"}], "==", 
       RowBox[{
        FractionBox["\[Delta]2", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Delta]2", "2"]}]], "+", 
        RowBox[{"\[Delta]3", " ", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "]"}]}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cons2", "=", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"u", "-", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"1", "-", 
               SuperscriptBox["\[Delta]0", "2"]}]], "x"}]}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"v", "-", 
            RowBox[{
             FractionBox["1", 
              RowBox[{"1", "-", 
               SuperscriptBox["\[Delta]0", "2"]}]], "y"}]}], ")"}], "2"]}], 
        "]"}], "==", 
       RowBox[{
        RowBox[{
         FractionBox["\[Delta]0", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[Delta]0", "2"]}]], 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "]"}]}], "+", 
        RowBox[{"\[Delta]1", " ", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           SuperscriptBox["u", "2"], "+", 
           SuperscriptBox["v", "2"]}], "]"}]}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"umin", "=", 
      RowBox[{
       RowBox[{"Minimize", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "cons1", ",", "cons2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"u", ",", "v", ",", "x", ",", "y"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Rho]L", " ", "=", " ", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"\[Delta]2", ",", "\[Delta]3"}], "]"}], "+", 
       RowBox[{"\[Delta]1", " ", "c1"}], "+", 
       RowBox[{"\[Delta]0", " ", "umin"}]}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.909618001579125*^9, 3.909618074420887*^9}, {
   3.9096181215352993`*^9, 3.909618245079299*^9}, {3.90961830367488*^9, 
   3.909618304607808*^9}, {3.909618637671132*^9, 3.909618638842301*^9}, {
   3.9096187427544203`*^9, 3.909618743239615*^9}, 3.909618806225502*^9, 
   3.909621548783539*^9},
 CellLabel->
  "In[5433]:=",ExpressionUUID->"9e799ac1-1cd5-44bb-b161-19ffe62be5b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalculateRhoL4", "[", 
  RowBox[{"0.22", ",", "0.31", ",", "0.39", ",", "0.44"}], "]"}]], "Input",
 CellChangeTimes->{{3.9096206474297037`*^9, 3.9096208580038157`*^9}, {
  3.909623460975336*^9, 3.909623623634513*^9}},
 CellLabel->
  "In[5482]:=",ExpressionUUID->"7ed88ace-df7a-4670-96fe-a9922eee9e38"],

Cell[BoxData["0.6577241578862415`"], "Output",
 CellChangeTimes->{{3.909620653504529*^9, 3.9096208326441927`*^9}, {
   3.909623497528864*^9, 3.909623588216118*^9}, 3.909623629260065*^9},
 CellLabel->
  "Out[5482]=",ExpressionUUID->"2ad40380-546c-4d03-8f63-681ff198c72b"]
}, Open  ]],

Cell["The following code is computationally unfeasible.", "Text",
 CellChangeTimes->{{3.909620470429515*^9, 3.909620509518672*^9}, {
  3.9096206164974203`*^9, 3.90962061894833*^9}, {3.909624024929597*^9, 
  3.909624027963675*^9}, {3.9096241830377274`*^9, 
  3.9096241841815567`*^9}},ExpressionUUID->"c77c1252-26c9-4def-8909-\
e80b097fa2bd"],

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CalculateRhoL4", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", 
     RowBox[{"0", "<=", "a", "<", "1"}], ",", 
     RowBox[{"0", "<=", "b", "<", "1"}], ",", 
     RowBox[{"0", "<=", "c", "<", "1"}], ",", 
     RowBox[{"0", "<=", "d", "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], "\:ff0c", 
   RowBox[{"PrecisionGoal", "->", "1"}], ",", 
   RowBox[{"AccuracyGoal", "->", "1"}], ",", " ", 
   RowBox[{"WorkingPrecision", "->", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.909618348750306*^9, 3.909618409935856*^9}, 
   3.9096188088624983`*^9, {3.9096189121333427`*^9, 3.909618921210224*^9}, {
   3.90961903677004*^9, 3.909619057125176*^9}, {3.9096191768718443`*^9, 
   3.90961922349755*^9}, {3.909619997839918*^9, 3.909620016084959*^9}, {
   3.909620054894527*^9, 3.909620071035144*^9}, {3.909620223408717*^9, 
   3.9096202302490788`*^9}},ExpressionUUID->"91b7518a-e09b-4237-b9cc-\
7bf3c7b90d5c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"aRange", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0.2", ",", "0.5", ",", "0.1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bRange", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0.2", ",", "0.5", ",", "0.1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cRange", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0.2", ",", "0.5", ",", "0.1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dRange", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0.2", ",", "0.5", ",", "0.1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TableXY", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", 
       RowBox[{"CalculateRhoL4", "[", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "aRange"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "bRange"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "cRange"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "dRange"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ValuesXY", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"TableXY", ",", "3"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxValueXY", "=", 
   RowBox[{"MaximalBy", "[", 
    RowBox[{"ValuesXY", ",", "Last"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.909621114658389*^9, 3.9096212146007843`*^9}, {
  3.9096212535926657`*^9, 3.909621262272172*^9}, {3.909621317231203*^9, 
  3.9096213471773367`*^9}, {3.909621384523841*^9, 3.9096214748421*^9}, {
  3.909621534851821*^9, 3.9096215373752832`*^9}, {3.9096215854570436`*^9, 
  3.909621596757351*^9}, {3.909621661174293*^9, 3.9096216627753563`*^9}, {
  3.9096217367292557`*^9, 3.909621736909013*^9}, {3.909621794636891*^9, 
  3.909621829628314*^9}, {3.909621869855064*^9, 3.909621873960553*^9}, {
  3.909621910480151*^9, 3.909621925702743*^9}, {3.909621968034346*^9, 
  3.909621974525419*^9}, {3.909622571537442*^9, 3.909622585051166*^9}, {
  3.909624013828157*^9, 3.909624019783943*^9}},
 CellLabel->
  "In[5483]:=",ExpressionUUID->"7bc78775-7ea2-44e3-8cca-f4a0c8dd7835"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
   "0.2`", ",", "0.30000000000000004`", ",", "0.4`", ",", "0.4`", ",", 
    "0.6557303794975824`"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9096212513631983`*^9, 3.9096213128514843`*^9, {3.9096213742541037`*^9, 
   3.909621410338203*^9}, {3.909621442393021*^9, 3.909621480199758*^9}, {
   3.9096215190942917`*^9, 3.909621542285054*^9}, 3.909621580490973*^9, 
   3.909621616949744*^9, 3.909621758085929*^9, 3.909621896579989*^9, 
   3.909621955811379*^9, 3.909622594318305*^9, 3.909622762600522*^9, 
   3.9096240963239737`*^9},
 CellLabel->
  "Out[5489]=",ExpressionUUID->"b4964407-05e0-417c-9c45-ff7b09f07c8a"]
}, Open  ]]
},
WindowSize->{808, 647},
WindowMargins->{{12, Automatic}, {Automatic, 24}},
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) \
(2021\:5e746\:670819\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ebdc1a74-58e6-4610-bbc4-5305cafb1646"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 230, 4, 44, "Input",ExpressionUUID->"ad39d31e-ac20-48a9-811c-6bfbeea183a3"],
Cell[791, 26, 6620, 187, 522, "Input",ExpressionUUID->"9e799ac1-1cd5-44bb-b161-19ffe62be5b7"],
Cell[CellGroupData[{
Cell[7436, 217, 325, 6, 30, "Input",ExpressionUUID->"7ed88ace-df7a-4670-96fe-a9922eee9e38"],
Cell[7764, 225, 270, 4, 34, "Output",ExpressionUUID->"2ad40380-546c-4d03-8f63-681ff198c72b"]
}, Open  ]],
Cell[8049, 232, 340, 5, 35, "Text",ExpressionUUID->"c77c1252-26c9-4def-8909-e80b097fa2bd"],
Cell[8392, 239, 1062, 22, 80, "Input",ExpressionUUID->"91b7518a-e09b-4237-b9cc-7bf3c7b90d5c"],
Cell[CellGroupData[{
Cell[9479, 265, 2297, 58, 325, "Input",ExpressionUUID->"7bc78775-7ea2-44e3-8cca-f4a0c8dd7835"],
Cell[11779, 325, 677, 14, 34, "Output",ExpressionUUID->"b4964407-05e0-417c-9c45-ff7b09f07c8a"]
}, Open  ]]
}
]
*)

