close;
clear all;
k1=0.5; k2=0.5;

hold on
% fimplicit(@(x,y) (x-1/((1-k1-k2)*(1+k1)*(1+k2))).^2+y.^2-((k1+k2)/((1-k1-k2)*(1+k1)*(1+k2)))^2,'Color','g','LineWidth',2);

for t=0:0.05*pi:2*pi
    x0=1/(1-k1^2)+cos(t)*k1/(1-k1^2);
    y0=sin(t)*k1/(1-k1^2);
    c0=[x0,y0]/(1-k2^2);
    r0=k2/(1-k2^2)*sqrt(x0^2+y0^2);
    viscircles(c0,r0,'Color','c','LineWidth',1);
end
quiver(0,0,1,0,1,'Color',"#77AC30",'LineWidth',2)
fimplicit(@(x,y) (x-1/(1-k1^2)).^2+y.^2-(k1/(1-k1^2))^2,'Color','b','LineWidth',2);
fimplicit(@(x,y) sqrt((x-1/(1-k1^2)).^2+y.^2)-k1/(1-k1^2)-k2*sqrt(x.^2+y.^2),'Color','r','LineWidth',2);

legend({'Fz^k_2','Fz^k_1','Fz^k'},'Location','northwest','FontSize',16)

axis off
axis equal