(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    272522,       5349]
NotebookOptionsPosition[    271542,       5326]
NotebookOutlinePosition[    271950,       5343]
CellTagsIndexPosition[    271907,       5340]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", ";"}]], "Input",
 CellChangeTimes->{{3.9046758395087547`*^9, 3.904675882652114*^9}, {
   3.90467597954259*^9, 3.90467597990091*^9}, 3.90467601385382*^9, {
   3.9046760554450207`*^9, 3.904676057119492*^9}, 3.904676232901587*^9, {
   3.9046768083586483`*^9, 3.904676808764234*^9}, {3.904677095062833*^9, 
   3.904677139175105*^9}, {3.9046784805202227`*^9, 3.904678508747361*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"98204e13-b355-4b54-98a9-c836aed98c0f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getW", "[", "L_", "]"}], ":=", 
   RowBox[{"Evaluate", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"L", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"L", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SolveFlow", "[", 
    RowBox[{"W_", ",", "wstart_", ",", "horizon_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NDSolve", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"w1", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"W", "[", 
            RowBox[{
             RowBox[{"w1", "[", "t", "]"}], ",", 
             RowBox[{"w2", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
           "1", "\[RightDoubleBracket]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"w2", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"W", "[", 
            RowBox[{
             RowBox[{"w1", "[", "t", "]"}], ",", 
             RowBox[{"w2", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
           "2", "\[RightDoubleBracket]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"w1", "[", "0", "]"}], "\[Equal]", 
         RowBox[{
         "wstart", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"w2", "[", "0", "]"}], "\[Equal]", 
         RowBox[{
         "wstart", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"w1", ",", "w2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "horizon"}], "}"}]}], "]"}], "//", "Flatten"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"plotFlow", "[", 
     RowBox[{"W_", ",", 
      RowBox[{"side_", ":", 
       RowBox[{"7", "/", "4"}]}]}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"StreamPlot", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"-", 
          RowBox[{"W", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)\>\"", ",", 
           "\"\<\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}],
         ",", 
        RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"StreamColorFunction", "->", "None"}], ",", 
        RowBox[{"StreamStyle", "\[Rule]", "Gray"}]}], "]"}]}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotTrajectory", "[", 
    RowBox[{"W_", ",", 
     RowBox[{"p_", ":", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"k_", ":", "25"}], ",", 
     RowBox[{"T_", ":", "25"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sol", "=", 
       RowBox[{"SolveFlow", "[", 
        RowBox[{"W", ",", "p", ",", "T"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"plotFlow", "[", "W", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ParametricPlot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"w1", "[", "t", "]"}], ",", 
              RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "}"}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotMultipleTrajectories", "[", 
    RowBox[{"W_", ",", 
     RowBox[{"stableInits_", ":", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}]}], ",", 
     RowBox[{"unstableInits_", ":", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}]}], ",", 
     RowBox[{"k_", ":", "25"}], ",", 
     RowBox[{"T_", ":", "50"}], ",", 
     RowBox[{"sides_", ":", 
      RowBox[{"7", "/", "4"}]}], ",", 
     RowBox[{"withEq_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Wreverse", ",", "stable", ",", " ", "unstable", ",", "eq"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Wreverse", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
       RowBox[{"-", 
        RowBox[{"W", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"stable", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "p", "}"}], ",", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"sol", " ", "=", 
               RowBox[{"SolveFlow", "[", 
                RowBox[{"W", ",", "p", ",", "T"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w1", "[", "t", "]"}], ",", 
                   RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], "]"}], ",", "stableInits"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"unstable", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "p", "}"}], ",", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"sol", " ", "=", 
               RowBox[{"SolveFlow", "[", 
                RowBox[{"Wreverse", ",", "p", ",", "T"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w1", "[", "t", "]"}], ",", 
                   RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], "]"}], ",", "unstableInits"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"If", "[", 
        RowBox[{"withEq", ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"getEquilibria", "[", 
            RowBox[{"W", ",", 
             RowBox[{"side", "=", "sides"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], "]"}], 
         ",", 
         RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"plotFlow", "[", 
            RowBox[{"W", ",", "sides"}], "]"}], ",", "eq"}], "}"}], ",", 
         "stable", ",", "unstable"}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numTotalIterates", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotIterates", "[", 
    RowBox[{"W_", ",", "iterates_", ",", "legends_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"Length", "[", "iterates", "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"iteratesReduces", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArrayResample", "[", 
           RowBox[{"#", ",", "numTotalIterates"}], "]"}], "&"}], ",", 
         "iterates"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"legend", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "legends", "]"}], "\[NotEqual]", "0"}], ",", 
         
         RowBox[{
          RowBox[{"ListLinePlot", "[", 
           RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
            RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
            RowBox[{"PlotLegends", "\[Rule]", 
             RowBox[{"Placed", "[", 
              RowBox[{"legends", ",", "Below"}], "]"}]}]}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         StyleBox[
          RowBox[{"{", "}"}],
          FontWeight->"Plain"]}], 
        StyleBox["]",
         FontWeight->"Plain"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"lines", "=", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"iterates", ",", 
         RowBox[{"PlotLegends", "\[Rule]", "legend"}], ",", 
         RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"markers", "=", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
         RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Joined", "\[Rule]", "False"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"plotFlow", "[", 
         RowBox[{"W", ",", "side"}], "]"}], ",", "\[IndentingNewLine]", 
        "lines", ",", "\[IndentingNewLine]", "markers", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.904677020568327*^9, 3.904677044927948*^9}, 
   3.904678514407029*^9, {3.90467893523694*^9, 3.904678935532865*^9}, {
   3.9046836370861807`*^9, 3.90468363729296*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"4fc9de00-5343-4fd5-8bb7-8a6c47b7b7a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"threshold", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AEGPlus", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Gamma]1", "*", 
             RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]1", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGn", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_", ",", "nSteps_"}], "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "0"}], ",", 
            RowBox[{"i", "<", "nSteps"}], ",", 
            RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{"zbar", "=", 
             RowBox[{"zbar", "-", 
              RowBox[{"\[Gamma]2", "*", 
               RowBox[{"V", "[", "zbar", "]"}]}]}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]2", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEG", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Hzdiffs", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "Fzbars", ",", "\[Alpha]", ",", "\[Gamma]1", ",", "dold", 
      ",", "d"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Gamma]3", "=", 
      RowBox[{"1", "/", "L"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"d", "=", 
      RowBox[{"-", "1000"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"zbar", "=", "zbar"}], ";", "\[IndentingNewLine]", 
             RowBox[{"dold", "=", "d"}], ";", "\[IndentingNewLine]", 
             RowBox[{"Print", "[", "d", "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"Fzbar", "=", 
              RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"zbar", "=", 
              RowBox[{"zbar", "-", 
               RowBox[{"\[Gamma]3", "*", "Fzbar"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"d", "=", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Rho]", "*", 
                  RowBox[{"Total", "[", 
                   RowBox[{
                    RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}]}], "-", 
                 RowBox[{"Fzbar", ".", 
                  RowBox[{"(", 
                   RowBox[{"zbar", "-", "z"}], ")"}]}]}], ")"}], "/", 
               RowBox[{"Norm", "[", "Fzbar", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"d", "-", "dold"}], "<", 
                RowBox[{"\[Epsilon]", "*", 
                 RowBox[{"Norm", "[", "Fzbar", "]"}]}]}], ",", 
               RowBox[{
                RowBox[{"d", "=", 
                 RowBox[{"-", "1000"}]}], ";", 
                RowBox[{"Print", "[", "i", "]"}], ";", 
                RowBox[{"Break", "[", "]"}]}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "MaxIter"}], "}"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Rho]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdzUsowwEAx/GRtZxkWZMme4SyNa9Qs7F5P1KzGgflYI9stTjIcWpl2nLQ
2MYytXGwGUN/s7lNHmspRUkyQ6LGLrstafb7H3596nf5cqZmFJpCCoXCyg/W
CYpr7cy0zHqcEUDXt8oBE3KRk/zbNgNQwEofwhQzREBxJyMCW2MdF9Bmj5KW
Ey13UHK1ew/DDVGuI2/w18yDFfN8ITwoyNZDRU+jBLq/bN2wuizeD2/eaANQ
SV1VwgWdbxzuqM418LnkaRpmEsOX0JgbJTW/xm5hzV+aVCrsS0ATe4/UexKq
cubN0nNs6M9U8uGIJ0BKdXAmoWGQqYZz104dVFuSeshq+rDAd3WRFcofwyuw
a1Zmgy8Ta25o1G6Qasc+9yHh7Q3CMzuXgPHkYgSmhnQPcMmwnIRu07ZoPe8W
gyeGTp+H5kL39IhU3/xTCqXtfjr8ByTH2GQ=
  "],
 CellLabel->"In[22]:=",ExpressionUUID->"1f605237-06e1-4004-a2c0-dcfd70672f09"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{"1.5", ",", "1.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstep", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"3", " ", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "7", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"side", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "y"}], "+", 
      RowBox[{"b", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "x"}], "+", 
      RowBox[{"b", " ", "y"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", 
   RowBox[{"b", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]1", "=", 
   RowBox[{"1", "/", "L"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]2", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"nstep", "*", "L"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Gamma]1"}], "/", "2"}], "*", "0.99"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Sigma]2", "=", 
     RowBox[{
      RowBox[{"-", "nstep"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"1", "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"1", "/", "nstep"}]}], ")"}], "^", "nstep"}]}]}], ")"}], 
      "*", "\[Gamma]2", "*", "0.99"}]}], ";"}], ";"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Sigma]1", "=", "\[Rho]"}], ";", " ", 
    RowBox[{"\[Sigma]2", "=", "\[Rho]"}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.904677921084033*^9, 3.904678026828352*^9}, {
   3.904678080679626*^9, 3.90467810349658*^9}, {3.904678141222587*^9, 
   3.9046781418313828`*^9}, {3.904678222000551*^9, 3.904678231162981*^9}, {
   3.904678781141758*^9, 3.9046787926355553`*^9}, {3.9046788538632708`*^9, 
   3.904678859075272*^9}, {3.904679059951167*^9, 3.904679113810698*^9}, {
   3.9046793825694733`*^9, 3.9046793852082663`*^9}, {3.904679681841154*^9, 
   3.9046796833506927`*^9}, {3.904680799914598*^9, 3.9046808123573112`*^9}, {
   3.90468092449886*^9, 3.904680958283567*^9}, {3.904681004662218*^9, 
   3.9046810407866917`*^9}, {3.904681072210801*^9, 3.9046810840092087`*^9}, {
   3.9046811546764708`*^9, 3.904681157595323*^9}, {3.904681188572945*^9, 
   3.9046811907325068`*^9}, {3.9046812217801857`*^9, 3.904681223984742*^9}, 
   3.904681414078163*^9, {3.904681453782587*^9, 3.904681454953491*^9}, {
   3.90468148519704*^9, 3.904681485730461*^9}, {3.904681727938191*^9, 
   3.9046817489492617`*^9}, {3.904681818881843*^9, 3.904681849158907*^9}, {
   3.904681879413641*^9, 3.904681899441991*^9}, {3.904681944777953*^9, 
   3.9046819512827177`*^9}, {3.904681987824791*^9, 3.904682008230101*^9}, {
   3.904682156534088*^9, 3.904682156917536*^9}, {3.904682434893135*^9, 
   3.904682443384974*^9}, {3.9046825441818533`*^9, 3.904682545710216*^9}, {
   3.90468280823776*^9, 3.904682809674079*^9}, 3.9046830139408712`*^9, {
   3.904683177403406*^9, 3.9046832204172287`*^9}, {3.904683277025416*^9, 
   3.904683296740877*^9}, {3.904683326754285*^9, 3.904683347022284*^9}, {
   3.904683390414177*^9, 3.904683394677227*^9}, {3.904683504772533*^9, 
   3.9046835528552647`*^9}, {3.904683654705864*^9, 3.904683655565941*^9}, {
   3.9046838602696533`*^9, 3.904684009107777*^9}, {3.904684051151514*^9, 
   3.9046840866250467`*^9}, {3.904684153323841*^9, 3.9046841696492167`*^9}, {
   3.904684285255888*^9, 3.904684285385824*^9}, 3.904684417527142*^9, {
   3.904684466829834*^9, 3.904684490148085*^9}, {3.904684524505808*^9, 
   3.9046845248*^9}, {3.904684669758772*^9, 3.90468467402182*^9}, {
   3.9046878959999313`*^9, 3.9046878977152567`*^9}, {3.904764647794938*^9, 
   3.904764648026484*^9}, {3.904764770636397*^9, 3.9047648425474052`*^9}, {
   3.904765097823573*^9, 3.9047651410896606`*^9}, {3.904765279305985*^9, 
   3.904765296075946*^9}, 
   3.904978205397436*^9},ExpressionUUID->"07fe36ad-9c3f-4298-a221-\
e9ceb5f6393c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"AEGPlusIterates", "=", 
   RowBox[{"AEGPlus", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGnIterates", "=", 
   RowBox[{"EGn", "[", 
    RowBox[{"W", ",", "init", ",", "T", ",", "nstep"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEGIterates", "=", 
   RowBox[{"MDEG", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legends", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<AdaptiveEG+\>\"", ",", 
     RowBox[{"StringForm", "[", 
      RowBox[{"\"\<`1`-step EG\>\"", ",", "nstep"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iterates", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"First", ",", 
     RowBox[{"{", 
      RowBox[{"AEGPlusIterates", ",", "EGnIterates"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"plotIterates", "[", 
   RowBox[{"W", ",", "iterates", ",", "legends"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.904678811815544*^9, 3.904678842713599*^9}, 
   3.9046790092753677`*^9, {3.9046793515043993`*^9, 3.90467935634138*^9}, {
   3.904679638797206*^9, 3.9046796574539213`*^9}, {3.904680533522923*^9, 
   3.90468053374251*^9}, {3.904681293207996*^9, 3.904681313081657*^9}, {
   3.9046813595563927`*^9, 3.904681390103552*^9}, {3.904681933549253*^9, 
   3.904681963265789*^9}, {3.904682019067993*^9, 3.9046820192078247`*^9}, {
   3.904682118089205*^9, 3.9046821370254793`*^9}, {3.904682891951832*^9, 
   3.904682899899241*^9}, {3.904683304722539*^9, 3.904683323673231*^9}, {
   3.904683403268262*^9, 3.9046834102693453`*^9}, {3.9046835355936613`*^9, 
   3.904683540101819*^9}, 3.9046836857263613`*^9, {3.904684075378223*^9, 
   3.904684076310137*^9}, 3.904684132907564*^9, {3.9046844564707823`*^9, 
   3.904684460002019*^9}, {3.9046852761787577`*^9, 3.9046852981133204`*^9}, {
   3.90468692052129*^9, 3.904686958567831*^9}, {3.90468703457903*^9, 
   3.9046870435537558`*^9}, {3.904688211410625*^9, 3.904688256871242*^9}, {
   3.904765158104164*^9, 3.904765182201645*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"9f1bf222-de69-49af-9d91-79ef34383170"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{3.904918955789907*^9, 3.904977546282792*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[40]:=",ExpressionUUID->"0533ff87-d0fc-4661-8db6-\
0d4dc5a6b4d1"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{}}, {{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.062234207064126974`, -0.039733608557813015`}, {
            0.07150785295680813, -0.03446653439414692}, {
            0.08073711729086648, -0.02765721380094314}, {
            0.10256962906758055`, -0.003581220162493048}, {
            0.11940778553177402`, 0.0319492749831989}, {0.12392987189146609`, 
            0.10802932473373449`}, {0.0979016502582854, 
            0.18084023323515816`}, {0.07173746127552634, 
            0.21851389179617786`}, {0.05290076859810747, 
            0.23735273540387064`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.04724423731273364, 0.24300991259904378`}, {
            0.03550807699442539, 0.2547474130497713}, {-0.011629636775454404`,
             0.28741176129832524`}, {-0.06989371072560142, 
            0.31396662737524705`}, {-0.13932665933878738`, 
            0.33155684022779935`}, {-0.21907182251732044`, 
            0.3371344056375762}, {-0.24940613535064107`, 
            0.3344161372239366}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.25737420744876377`, 
            0.3337021154881899}, {-0.28823481624657893`, 
            0.33093668550855826`}, {-0.3620057527240908, 
            0.31369410380912266`}, {-0.4002517624607575, 
            0.3004304467462915}, {-0.4392088334452661, 
            0.2838049225418077}, {-0.478589579495209, 
            0.26364925522633353`}, {-0.5181066144281781, 
            0.23979516883053106`}, {-0.5508225401231348, 
            0.2167426023533722}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5573621445516317, 
            0.21213461212782014`}, {-0.557538000739289, 
            0.21201069888464344`}, {-0.5966094419816387, 
            0.18011483171924897`}, {-0.6349550135597906, 
            0.14401571756551262`}, {-0.6722087908783082, 
            0.10362150665459925`}, {-0.7082146626091234, 
            0.05870677382983818}, {-0.7426486668102729, 
            0.009152954244827378}, {-0.7650783973207966, \
-0.028496864554385132`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7691728456231517, -0.03536967279405992}, \
{-0.774893102965479, -0.0449715114038658}, {-0.8043302705584635, \
-0.10359818241967401`}, {-0.8218870052477918, -0.14472679219711773`}, \
{-0.8378430283799038, -0.18782408222118646`}, {-0.8521983399547998, \
-0.23289005249188016`}, {-0.8649529399724797, -0.27992470300919886`}, \
{-0.8758249350583057, -0.3288628438235839}, {-0.8769040048014808, \
-0.33515527466937484`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8782561624508911, -0.3430401760442267}, \
{-0.8845324318376395, -0.3796392849854763}, {-0.8910754303104811, \
-0.432254026494876}, {-0.8954539304768309, -0.4867070683517831}, \
{-0.897368894317997, -0.5428673432844032}, {-0.8965212838152877, \
-0.6006037840209416}, {-0.8929110989687036, -0.6599163905613988}, \
{-0.8927174968385644, -0.66176616954647}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8918847470382986, -0.669722709483538}, \
{-0.8865383397782441, -0.7208051629057742}, {-0.8776156438259325, \
-0.791777633398929}, {-0.8646271080638351, -0.8646271332525102}, \
{-0.8463050242447733, -0.9296468046272138}, {-0.8287461137651925, \
-0.9823562312903614}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.8262177040735479, -0.9899461683409039}, \
{-0.824354501663181, -0.9955392449114597}, {-0.8005203349108152, \
-1.0617897962301275`}, {-0.7729188798169022, -1.1287565696176394`}, \
{-0.7414133100568365, -1.1962799782742688`}, {-0.7058667993060123, \
-1.264200435400289}, {-0.695747716234388, -1.2815601123823257`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6917189450042792, -1.2884716246897334`}, \
{-0.6661513549457814, -1.3323338107675688`}, {-0.6221389843574952, \
-1.4004959741479766`}, {-0.5850999409244267, -1.4532130389299467`}, \
{-0.5454082055004794, -1.505738009230918}, {-0.5089533513545726, \
-1.550630327191878}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5039102899433274, -1.556840603482222}, \
{-0.5030007280296531, -1.5579606831969952`}, {-0.4578144584559475, \
-1.609770858974283}, {-0.4097863467233629, -1.661058334708886}, \
{-0.3588533427758988, -1.7117129085469092`}, {-0.3049523965575556, \
-1.7616243786344572`}, {-0.27900497087138426`, -1.7839832357145844`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.27294458090236334`, -1.7892054644938884`}, \
{-0.2480204580123331, -1.8106825431176343`}, {-0.18806889292934095`, \
-1.8587382662364238`}, {-0.12513196428080026`, -1.9056304325673858`}, \
{-0.05918096778537694, -1.9512308707614918`}, {-0.015727956770806323`, \
-1.979056245044065}}]}, {
           Arrowheads[{{0.001395535155548145, 1.}}], 
           
           ArrowBox[{{-0.006459889190350926, -1.9937906799738663`}, {
            0.0072818168551003, -1.9937906799738663`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.03396411917207042, 0.0659150107703906}, {
            0.027907087575461714`, 0.0746142863556955}, {
            0.020343243059557058`, 
            0.08313224802865592}, {-0.005603325850123416, 
            0.1027285902553011}, {-0.042487760181660485`, 
            0.11633916801931873`}, {-0.11866103420319082`, 
            0.11413536058470689`}, {-0.18852410768826622`, 
            0.08209921709916011}, {-0.22359025647390207`, 
            0.05304642239128653}, {-0.24139298492400801`, 
            0.03198656275747214}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.24655762241697973`, 
            0.025877019438516884`}, {-0.25640702824540534`, 
            0.01422559730934981}, {-0.28482922441901515`, \
-0.035011766037801456`}, {-0.3063626895935968, -0.09467632753345813}, \
{-0.31822445971105995`, -0.1645836980301305}, {-0.3175112743924784, \
-0.24366389042616896`}, {-0.31173245103137687`, -0.2776460031351945}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.3103912665793341, -0.28553277841192193`}, \
{-0.30579226136064497`, -0.31257702322183756`}, {-0.28249171745397805`, \
-0.3852684768568513}, {-0.26601487219739833`, -0.42261330557483096`}, \
{-0.2460624451518897, -0.46040139240550904`}, {-0.22248650200086223`, \
-0.4983224183008734}, {-0.1951391084277257, -0.5360660642129126}, \
{-0.16850181240909734`, -0.5677854847560287}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.16332046652614923`, -0.5738787476160817}, \
{-0.12830731471104742`, -0.6099787994811914}, {-0.08859920782111233, \
-0.6454651071207124}, {-0.04461450750685209, -0.679458186240027}, {
            0.003865053934010536, -0.7117756197984217}, {
            0.056932202083887704`, -0.7420730112734772}, {
            0.09433175661604318, -0.7600483075852225}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.10154217188397296`, -0.7635138395305384}, {
            0.11445996381542767`, -0.7697225000497894}, {
            0.17632136600127857`, -0.7940962255119532}, {
            0.2187453750288454, -0.8078371088108385}, {
            0.2629706859825407, -0.8198227449843389}, {
            0.30899729886236443`, -0.8300531340324545}, {
            0.3568252136683167, -0.8385282759551854}, {
            0.40636572496274664`, -0.8449772301895495}, {
            0.4094374649661036, -0.8452264919687245}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.4174112551420654, -0.8458735392851823}, {
            0.4575301273080033, -0.8491290561725642}, {
            0.5103184207040867, -0.8509837539042299}, {
            0.5647306051509972, -0.8505413233845466}, {
            0.6206120317707468, -0.8475198591567236}, {
            0.6778080516853476, -0.8416374557639701}, {
            0.7362132043070734, -0.8329098723650828}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.7440676051846936, -0.8313910530176157}, {
            0.7961438713991044, -0.8212898314836726}, {
            0.8678503747303623, -0.8058361648995535}, {
            0.9411491175511011, -0.7859560978507999}, {
            1.0030402356009942`, -0.7624316106769881}, {
            1.0502382151684642`, -0.7419703551461181}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.0575781609359443`, -0.7387883438120005}, {
            1.065460514842744, -0.7353711878457959}, {
            1.128066791070283, -0.7064843432762837}, {
            1.1910450612694001`, -0.6739446552301318}, {
            1.2542355492037416`, -0.6376372755199897}, {
            1.3174784786369533`, -0.5974473559585071}, {
            1.336944310875318, -0.5838220061501588}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.3434982821429196`, -0.5792344729760603}, {
            1.3805923807640985`, -0.5532700002861739}, {
            1.4433957867802403`, -0.5050003122434801}, {
            1.4925381435884282`, -0.46412122266591144`}, {
            1.5412788463730422`, -0.4206484592090537}, {
            1.5891794377225645`, -0.3748409259680935}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.5947754397381146`, -0.3691242311479743}, {
            1.6371047406268227`, -0.3257111946104762}, {
            1.6839646574736267`, -0.2741413354452588}, {
            1.729972371052131, -0.2197670863537577}, {
            1.7750152440511549`, -0.16253576832422387`}, {
            1.8019434261840654`, -0.12570021676448406`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.8066646896920928`, -0.11924191428722505`}, {
            1.8189806391595167`, -0.10239470234490841`}, {
            1.8617238369517721`, -0.039366232860634794`}, {1.903090246582703, 
            0.026504211543289802`}, {1.9429524236114688`, 
            0.09523468366788877}, {1.9739137748028897`, 
            0.15322758325374825`}}]}, {
           Arrowheads[{{0.0004646618020881276, 1.}}], 
           
           ArrowBox[{{1.9784734812343048`, 0.16535978491340098`}, {
            1.9803909359552392`, 0.16535978491340098`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.0820928615203757, 
            0.03659013014027307}, {-0.10790437569139626`, 
            0.01258429941808666}, {-0.12917062268580892`, \
-0.024608731235636186`}, {-0.1399956361405699, -0.10369453887329343`}, \
{-0.11803111948457139`, -0.18407748532762738`}, {-0.09278487511529201, \
-0.22673045036627637`}, {-0.07363744891249122, -0.2487622582658772}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.06838968422911357, -0.2548005498974477}, \
{-0.0564042325689661, -0.26859149839201324`}, {-0.007785527689829557, \
-0.3073556994147987}, {0.05349769291911173, -0.3402070301140628}, {
            0.08896739590604033, -0.353418391735929}, {
            0.12769790696595745`, -0.3639551629491803}, {
            0.16946916827743813`, -0.37135015825600115`}, {
            0.21406112201905744`, -0.3751361921585758}, {
            0.21891219368026246`, -0.3749894641203197}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.22690853678121245`, -0.3747476025651075}, {
            0.28703186293158556`, -0.3729290811505455}, {
            0.36542472445472335`, -0.35966574826969494`}, {
            0.40631465447025905`, -0.3483622803852746}, {
            0.448152359468433, -0.3336638951426242}, {
            0.4906626191395244, -0.31538237950331427`}, {
            0.5327311313822124, -0.2937607763153969}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5396081199852876, -0.28967725905651553`}, {
            0.5766688355428832, -0.2672596524105742}, {
            0.6196970487932765, -0.2369730719157775}, {
            0.6622969354777043, -0.20235050887060277`}, {
            0.7041105781488791, -0.16327269320112797`}, {
            0.7449996853518354, -0.11950546717694611`}, {
            0.7779012941499974, -0.07917865506968715}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7829586235937468, -0.0729799923996118}, {
            0.7846502648377492, -0.07090658319283807}, {
            0.8224408479685461, -0.01749463636266363}, {0.8577499661061508, 
            0.04071177819971744}, {0.8797139769869207, 0.08246823484706049}, {
            0.9001685103806014, 0.12642346948069716`}, {0.9191135662871934, 
            0.17257748210062743`}, {0.9320928445194423, 
            0.20857194741081397`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.9348065369147172, 0.21609762834902996`}, {
            0.9365491447066968, 0.22093027270685134`}, {0.9521754414856041, 
            0.2714378077794477}, {0.9656926524704079, 0.3240560537984954}, {
            0.9771007776611087, 0.37878501076399446`}, {0.9863998170577057, 
            0.4356246786759448}, {0.9932665133025051, 0.4944643345480209}, {
            0.9956255166137014, 0.5293114251011409}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.9961658467122297, 0.5372931569548569}, {
            0.9973776090378124, 0.5551932553938973}, {0.9987331042636276, 
            0.617811441213574}, {0.9973329989799506, 0.6823188920070511}, {
            0.9943133362758748, 0.753467176947661}, {0.9876416942718581, 
            0.8266830383595731}, {0.9817951805136665, 0.8562830644733738}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9802449925151449, 0.8641314348245511}, {
            0.9712580908574854, 0.9096307759278144}, {0.9610820997191172, 
            0.9517334361900559}, {0.9495833156266277, 0.9942552907710447}, {
            0.9304162389376512, 1.062354809436164}, {0.9075951866279293, 
            1.1312520435667177`}, {0.8923489702141659, 
            1.1713873849638055`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8895080769939118, 1.178865976121979}, {
            0.8811201586974615, 1.2009469931627055`}, {0.8509911551462482, 
            1.2714396582241276`}, {0.8169554365575975, 1.3424213138923906`}, {
            0.7787602635148174, 1.4135832353089008`}, {0.7480111776606209, 
            1.4653770337153524`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7439272095510816, 1.4722560746717843`}, {
            0.736405636017908, 1.484925422473658}, {0.6898915540668693, 
            1.5564478753866628`}, {0.6650207489124552, 1.5921792769127725`}, {
            0.6390021426273165, 1.627760895703973}, {0.6118357352114528, 
            1.6631927317602648`}, {0.5835215266648645, 1.6984747850816477`}, {
            0.5562459290656153, 1.7309998465340064`}}]}, {
           Arrowheads[{{0.0085519801806439, 1.}}], 
           
           ArrowBox[{{0.5510321246386639, 1.7370669174990565`}, {
            0.5234497061795134, 1.7685895435196863`}, {0.4916920942407506, 
            1.8034222486363418`}, {0.45878668117126303`, 
            1.8381051710180887`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.05242463497897715, -0.0721769783842435}, \
{-0.04627432159594541, -0.08453829306146907}, {-0.037983591552340906`, \
-0.0969449603699533}, {0.001942740593107623, -0.13274737442820803`}, {
            0.06641400326242054, -0.15579141556630416`}, {
            0.11208171985909235`, -0.15791083693056623`}, {
            0.163422476004916, -0.14925074326123217`}, {
            0.2068610122692461, -0.13300538807538628`}, {
            0.22849626149521993`, -0.12044283556356544`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.23541455227618305`, -0.11642571561638429`}, {
            0.2513841093974832, -0.10715295902220526`}, {
            0.2953617282977677, -0.0704739821870376}, {
            0.33667717641636496`, -0.022157457997692052`}, {
            0.3729208534657146, 0.038533519765145276`}, {0.4012956677021563, 
            0.11166709534162206`}, {0.4089287987076258, 
            0.14229071385603326`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4108636501275317, 0.15005321023174178`}, {
            0.41156256846331135`, 0.15285722453102568`}, {0.4186986341585689, 
            0.1971068438390995}, {0.42227519255071916`, 0.2441668037310738}, {
            0.4218635714025521, 0.2937879546721789}, {0.41836536425459225`, 
            0.3352539251854825}, {0.41180800168787474`, 0.3781942209638175}, {
            0.4019800933062156, 0.42239994643032625`}, {0.3892470935584869, 
            0.4657005526671943}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.386611052351828, 0.4732501577269606}, {
            0.3716443698483451, 0.5138645939117206}, {0.3506865247817761, 
            0.560816712522433}, {0.32561257231552976`, 0.6081986785138898}, {
            0.29623837125141195`, 0.6556906085596912}, {0.26231222744091237`, 
            0.7030429933413215}, {0.22567082919407708`, 
            0.7474827190380869}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.22033801450095963`, 0.7534401352921669}, {
            0.18010807855818126`, 0.7960073694017413}, {0.1316239181703206, 
            0.8408106964088122}, {0.07794203226776315, 0.8841854583151547}, {
            0.018931563591371617`, 
            0.9257732800040779}, {-0.027372799021292353`, 
            0.9539561087663371}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.03420654709752012, 
            0.9581154220787305}, {-0.04534388790873188, 
            0.9648940872247109}, {-0.11482072228242515`, 
            1.0008678057261824`}, {-0.16388578387070646`, 
            1.0226805932187895`}, {-0.21526555603627043`, 
            1.042677472111948}, {-0.2689600387791171, 
            1.0608584424056584`}, {-0.32496923209924655`, 
            1.0772235040999203`}, {-0.3296854981960501, 
            1.0783756568705605`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.3374569608937545, 
            1.0802741740651596`}, {-0.3832267777379275, 
            1.0914554391181315`}, {-0.44366631743642904`, 
            1.1032370293836888`}, {-0.5062878511947512, 
            1.112568274896593}, {-0.5710913790128938, 
            1.1194491756568439`}, {-0.6379402357063271, 
            1.1235422735406944`}, {-0.6537909430314736, 
            1.1237653894863586`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6617901506042536, 
            1.1238779870333042`}, {-0.7066977560905214, 
            1.1245101104243969`}, {-0.777363940165477, 
            1.1223526863079523`}, {-0.8499387879311935, 
            1.1170700011913601`}, {-0.9286956151285221, 
            1.1097380094299347`}, {-0.9807119585964447, 
            1.1024487410333086`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.9886345465189095, 
            1.1013385155558424`}, {-1.0094501775844533`, 
            1.0984215338618972`}, {-1.0543400600839012`, 
            1.0881224488433061`}, {-1.0996742569967028`, 
            1.0764933925594562`}, {-1.1453567545413228`, 
            1.0634386030704328`}, {-1.1914195573116066`, 
            1.0489900010228745`}, {-1.2673119867748515`, 
            1.0243199994549341`}, {-1.2959030204875313`, 
            1.013600665039753}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.3033938522819357`, 
            1.0107922065608113`}, {-1.3439286216289774`, 
            0.9955949334422647}, {-1.4212694618739845`, 
            0.9628148029848665}, {-1.4993345075098725`, 
            0.9259796080827396}, {-1.5385531761603874`, 
            0.9059764766764032}, {-1.5777820337806039`, 
            0.8848298095818856}, {-1.593258491394226, 0.8760382254699993}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.600214502458077, 
            0.8720867814200877}, {-1.6170210803705216`, 
            0.8625396067991864}, {-1.6562703159301406`, 
            0.839105868328306}, {-1.695529740459461, 
            0.8145285941692442}, {-1.7347993539584827`, 
            0.788807784322001}, {-1.7740791564272058`, 
            0.7619434387865766}, {-1.8133691478656306`, 
            0.7339355575629706}, {-1.8525630431052182`, 
            0.704729640982494}, {-1.8659441740610383`, 0.694276891417868}}]}, {
           Arrowheads[{{0.007834338712184166, 1.}}], 
           
           ArrowBox[{{-1.8722486568129393`, 
            0.6893521074397646}, {-1.8915545569774308`, 
            0.6742711893764578}, {-1.9303436894822674`, 
            0.6425602027448617}, {-1.968930440619729, 
            0.6095966810877058}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.047465057445625715`, 
            0.18927845839303312`}, {-0.09463068042586815, 
            0.19946129916815658`}, {-0.14908272296511624`, 
            0.20036205812548682`}, {-0.20967545693578404`, 
            0.18923286920932952`}, {-0.2742495103542996, 
            0.16358751390909237`}, {-0.32597621822594935`, 
            0.1316705230399311}, {-0.34531274426774405`, 
            0.11516887387229664`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3513980591982538, 
            0.10997571084803916`}, {-0.3768408617541787, 
            0.08826301019478888}, {-0.4248704105830945, 
            0.03240051965822603}, {-0.4676846516046055, \
-0.036418150567534856`}, {-0.4863104302935648, -0.07580443967005387}, \
{-0.5026416603578497, -0.1185718376223}, {-0.5147077779614142, \
-0.15930530567269643`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5167951015478339, -0.16702295549802976`}, \
{-0.5268085695831106, -0.2137576009264931}, {-0.5338503065452498, \
-0.26606896994921303`}, {-0.537000002232396, -0.32143610856679544`}, \
{-0.5358402680082608, -0.37956890709725577`}, {-0.5299537152365557, \
-0.44017725585860956`}, {-0.5224529250731941, -0.4844735644822758}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5211172810805708, -0.4923612799389191}, \
{-0.5210084672625741, -0.49300388563238906`}, {-0.50814382644895, \
-0.5473339260661947}, {-0.4911283302420694, -0.6029015594042142}, \
{-0.4697305160883191, -0.6594409678906353}, {-0.4436859644433393, \
-0.7167880153756138}, {-0.41275662135536717`, -0.7746972204245312}, \
{-0.4041617007383298, -0.7885622048147718}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.39994666860224865`, -0.795361727157687}, \
{-0.3767505726596847, -0.8327807473544127}, {-0.3354759041915737, \
-0.8906507604822845}, {-0.2886603486121257, -0.9479951929655525}, \
{-0.23609592112178435`, -1.0044413628893185`}, {-0.1969983959151427, \
-1.04130340801889}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.19117758140349478`, -1.0467914056884404`}, \
{-0.17768713136486025`, -1.0595105119621515`}, {-0.11333848898566422`, \
-1.1127238818926204`}, {-0.07886101599422492, -1.138555351537675}, \
{-0.042787716965465565`, -1.163858401023035}, {-0.005131673604381166, \
-1.1885348325672112`}, {0.034094032384033454`, -1.212486448388713}, {
            0.06874293992554101, -1.2321366657738124`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.07571661667308861, -1.2360559359008692`}, {
            0.11720210542287277`, -1.2578224417377333`}, {
            0.16105830906330748`, -1.279010423702272}, {
            0.20643184851109225`, -1.299080798818176}, {
            0.2689678993406552, -1.3237780280375446`}, {
            0.3341931222496631, -1.3461899265911943`}, {
            0.3712270884188736, -1.357165017135558}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.37889735689735066`, -1.3594381166644132`}, {
            0.4021075172381159, -1.3663164944791253`}, {
            0.4727110843060136, -1.3841577317013376`}, {
            0.5459148659105509, -1.3993518686977258`}, {
            0.6216299045089223, -1.411537135908184}, {
            0.6926587647702396, -1.4198692324932887`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7006072251981084, -1.420770904009611}, {
            0.7805937526871678, -1.4268810609713127`}, {
            0.8636758628497946, -1.4296581405892328`}, {
            0.9489358311717606, -1.428663193951723}, {
            0.9923825121424961, -1.4267512107871823`}, {
            1.020221366442006, -1.4249444916814844`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.028204571856663, -1.4244263881132773`}, {
            1.0363736576530662`, -1.4238962210587838`}, {
            1.0809092677034715`, -1.4200982247665281`}, {
            1.1259893422937115`, -1.4153572219104151`}, {
            1.171763398615719, -1.4106031150579426`}, {
            1.2180463791274512`, -1.4047767707103165`}, {
            1.2648530130210869`, -1.3979040171460861`}, {
            1.3121391127200897`, -1.389907369529604}, {
            1.345064030656333, -1.382033978074177}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.3528446595704944`, -1.380173383088664}, {
            1.3635516934131613`, -1.3776129919304214`}, {
            1.4154100332462545`, -1.3639456044889224`}, {
            1.4676260625049236`, -1.3488172422926004`}, {
            1.5202291377606505`, -1.3322572269789579`}, {
            1.566773596250327, -1.317617175529802}, {
            1.6135342512960873`, -1.3017738287336318`}, {
            1.6583602431661975`, -1.2855076760208113`}}]}, {
           Arrowheads[{{0.015871801924115508`, 1.}}], 
           
           ArrowBox[{{1.665838543472026, -1.2826670217726404`}, {
            1.7077041510558575`, -1.2664772491002465`}, {
            1.7551133957698684`, -1.2470240162630322`}, {
            1.8027388370399626`, -1.2263674880788027`}, {
            1.8505804748661399`, -1.2045076645475585`}, {
            1.8986383092484012`, -1.1814445456693}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1946334358974773, 0.054604270253789305`}, {
            0.20377794754812012`, 0.10329317296283458`}, {0.203284242915783, 
            0.1591501389935105}, {0.19041176313737204`, 
            0.22095006418401125`}, {0.16270379201092017`, 
            0.28645962727204655`}, {0.12894236169880746`, 
            0.33872018880610233`}, {0.11690630194668367`, 
            0.35227681970819397`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.11159491208198989`, 0.35825922204381366`}, {
            0.08352942244552548, 0.389870354916504}, {0.02553342364813316, 
            0.43790289903267904`}, {-0.045507405293282545`, 
            0.4804119521049708}, {-0.08602411445192812, 
            0.4987625160097849}, {-0.12992741120729437`, 
            0.5147330229657774}, {-0.157316563635652, 0.5223917865732255}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.16502102024133572`, 
            0.5245461654654208}, {-0.17708791079710892`, 
            0.5279204013964286}, {-0.2273762284590993, 
            0.5379215797252183}, {-0.28080189329587724`, 
            0.5443437668450393}, {-0.33726330331814725`, 
            0.546785947273254}, {-0.3964643771257761, 
            0.5448327128700476}, {-0.45810903331863084`, 
            0.5380686554956048}, {-0.4823364499110967, 
            0.5336635507348332}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.4902074023346281, 
            0.5322324295147735}, {-0.5120647429048688, 
            0.5282582593990164}, {-0.5675074326871619, 
            0.5144267577475541}, {-0.6241634945517364, 
            0.4963414594030909}, {-0.6817593203848183, 
            0.47376967322749974`}, {-0.7401241950145154, 
            0.44644402113698994`}, {-0.7882194152039625, 
            0.4200450253703769}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7952324263854523, 
            0.4161956521527868}, {-0.7990050889154301, 
            0.414124874604302}, {-0.8580049224435312, 
            0.376621166826105}, {-0.9167266159547878, 
            0.3337418309990685}, {-0.9748492632470993, 
            0.28521333455950776`}, {-1.0319910193648205`, 
            0.23082811755202143`}, {-1.0445169830626266`, 
            0.2172533053796999}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0499421405478007`, 
            0.21137387800443116`}, {-1.0876633965336038`, 
            0.1704940720857038}, {-1.1413779069791001`, 
            0.10411909026964915`}, {-1.167419268840747, 
            0.06859021202138617}, {-1.1929040959801076`, 
            0.03143923696503819}, {-1.2177326224674156`, \
-0.0073195742985709715`}, {-1.2402015672781215`, -0.044984007311356676`}}]}, {
          
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.24416408771142, -0.05193257606755839}, \
{-1.2650217097668142`, -0.08960366304427714}, {-1.2872827387193737`, \
-0.13310041932472674`}, {-1.3084884033008197`, -0.17814796940914207`}, \
{-1.3285389375813865`, -0.2247320526966994}, {-1.3531052249727604`, \
-0.28878059796007627`}, {-1.3717284271529806`, -0.3447375202924464}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3742546956439279`, -0.3523281702983186}, \
{-1.375323348443026, -0.3555391391263817}, {-1.3951933079921834`, \
-0.4250076761956154}, {-1.4127151036202323`, -0.49718620916777734`}, \
{-1.4275234913217383`, -0.5719813578097882}, {-1.4392532270912661`, \
-0.6492997418885682}, {-1.440937642048998, -0.6648453568296463}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.4417994224780353`, -0.672798804792142}, \
{-1.4479043109288157`, -0.7291413614041172}, {-1.453476742834387, \
-0.8115062163564354}, {-1.4555860177246, -0.8962224136231925}, \
{-1.4538476305160728`, -0.9831180600820577}, {-1.4533719709297166`, \
-0.9922246854862153}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.4529546817226702`, -1.000213794930808}, \
{-1.4515355636247818`, -1.0273831767585309`}, {-1.448261581208806, \
-1.0721931557330313`}, {-1.4440256832681453`, -1.1175479970055588`}, \
{-1.4388278698027994`, -1.1634477005761132`}, {-1.433614608574644, \
-1.2100148372995854`}, {-1.4273108025865446`, -1.2570890109515827`}, \
{-1.4199423765578234`, -1.304685289920795}, {-1.417570960571334, \
-1.3180801804768891`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.4161763368432825`, -1.3259576816452263`}, \
{-1.4114315563305155`, -1.3527584690411527`}, {-1.3985414023143106`, \
-1.404962561168923}, {-1.3842589001054941`, -1.4576074541958224`}, \
{-1.368496172666998, -1.5106039472779624`}, {-1.3512825123445122`, \
-1.5639817740299726`}, {-1.3360267413730498`, -1.6113245194068355`}, \
{-1.328381905994103, -1.6333841597716592`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.325762327051598, -1.6409431151336111`}, \
{-1.319546692358005, -1.65887870945097}, {-1.301842365299378, \
-1.7066443441623758`}, {-1.2829137601971683`, -1.7546214235410522`}, \
{-1.2627608770513767`, -1.8028099475870007`}, {-1.2413837158620025`, \
-1.85120991630022}, {-1.218782276629046, -1.899821329680711}, \
{-1.201349898590693, -1.93554317211353}}]}, {
           Arrowheads[{{0.0004111106648393485, 1.}}], 
           
           ArrowBox[{{-1.197178579137419, -1.9472860455416585`}, \
{-1.1956193372614266`, -1.9472860455416585`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.21218889902128257`, -0.11374156118375627`}, \
{-0.21040174972175682`, -0.1718874508569037}, {-0.1957509615835846, \
-0.23588607468243397`}, {-0.16577816644836235`, -0.30341887148627955`}, \
{-0.129958171653947, -0.35701640575115795`}, {-0.09097897390992973, \
-0.3997246218931464}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.0855859705624888, -0.40563355706748117`}, \
{-0.08223597705407329, -0.4093040340170389}, {-0.021700722023592654`, \
-0.45824164816385027`}, {0.0520867011611468, -0.50139710896334}, {
            0.09404637787561285, -0.5199667797786692}, {
            0.13943477910574273`, -0.5360832097621642}, {
            0.1881198997855147, -0.5493420162406122}, {
            0.19518905718496993`, -0.5507049705243926}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.20304438641469766`, -0.5522195010432615}, {
            0.23996973484890724`, -0.5593388165408013}, {
            0.2949901367632335, -0.5656791217913781}, {
            0.35307667196913844`, -0.5679605280795021}, {
            0.41393190636059857`, -0.5657667801697299}, {
            0.47725840583159007`, -0.5586816228266183}, {
            0.520795242350449, -0.5507002249161254}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.5286641062043564, -0.5492576641206407}, {
            0.5329691508627042, -0.5484684410812996}, {
            0.5901996646149565, -0.5341285569430944}, {
            0.6486712549814154, -0.5154249555191248}, {
            0.708105229855149, -0.49212062191651335`}, {
            0.7683267990867471, -0.46394357848572176`}, {
            0.8252459438400873, -0.4327499433524612}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8321437395628706, -0.4287057097013533}, {
            0.8899556110212975, -0.3920442802220828}, {
            0.9505561048123355, -0.3479319062194642}, {
            1.010553471590535, -0.2980346011569354}, {
            1.0695597996424582`, -0.2421406984430382}, {
            1.081515995450714, -0.22966913697923463`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.0870522719965867`, -0.22389422208742704`}, {
            1.098536276986356, -0.21191520498387323`}, {
            1.127078938057033, -0.18015478053232242`}, {
            1.1551257639906047`, -0.14684749789520446`}, {
            1.1826147359231878`, -0.11198142987933792`}, {
            1.2095560673345718`, -0.07549724052924199}, {
            1.2359337053977564`, -0.037352833439363096`}, {
            1.2616462317886712`, 0.0024378592585894802`}, {1.279009509520825, 
            0.031269734476565156`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.2831366824077877`, 0.03812294131432514}, {
            1.2865922281832474`, 0.04386090543290647}, {1.3106702762574143`, 
            0.0869023729518781}, {1.3337789576871033`, 
            0.13154832968379507`}, {1.3558168541482436`, 
            0.17778484349694806`}, {1.3766825473167659`, 
            0.22559798225962732`}, {1.402356987783417, 0.2914974526711779}, {
            1.415066564315882, 0.32900182448393345`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.4176341954529565`, 0.33657858304838073`}, {
            1.4256364324967357`, 0.36019218438726697`}, {1.4465208814567216`, 
            0.43168217740789444`}, {1.4650103346633745`, 0.50596743173306}, {
            1.480730898346913, 0.5829547307555787}, {1.4909483696803798`, 
            0.6476140841367167}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.492197036042641, 0.6555160353081526}, {
            1.4933086787375547`, 0.6625508578682651}, {1.5027436758352999`, 
            0.744755813071119}, {1.5090358896401481`, 0.8295695963641405}, {
            1.51090495282175, 0.872911566696799}, {1.5117913202081557`, 
            0.9168192803566694}, {1.511694991799365, 0.9612927373437516}, {
            1.5113761158503112`, 0.9746028352004753}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.5111845112619964`, 0.9826005403514381}, {
            1.5106159675953776`, 1.0063319376580455`}, {1.5085542475961944`, 
            1.0519368812995513`}, {1.5055098318018145`, 
            1.0981075682682688`}, {1.5014827202122385`, 1.144843998564198}, {
            1.496472912827466, 1.192146172187339}, {1.4915076797387803`, 
            1.2395381517543476`}, {1.485455713260519, 1.2874450527709083`}, {
            1.4834326188314058`, 1.3012212493897122`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.4822702510842534`, 1.3091363552778466`}, {
            1.4783426049861335`, 1.335881535393087}, {1.4700915801352687`, 
            1.384803619152686}, {1.4575206075492084`, 1.4378342234419343`}, {
            1.4435689812775476`, 1.4913163109095406`}, {1.4281500644162974`, 
            1.545163843837523}, {1.4112927359334546`, 1.5994055014652093`}, {
            1.4051297091724486`, 1.6192405727026182`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4027559456494885`, 1.6268802877978992`}, {
            1.3961221433397655`, 1.648230501984989}, {1.379700711820395, 
            1.6972854986184327`}, {1.3620284413753434`, 
            1.7465704913655402`}, {1.3431053320046102`, 
            1.7960854802263109`}, {1.3229313837081962`, 
            1.8458304652007462`}, {1.3015065964861008`, 
            1.8958054462888445`}, {1.2881317285535108`, 1.92541807684009}}]}, {
           Arrowheads[{{0.004401120267619675, 1.}}], 
           
           ArrowBox[{{1.284838744004903, 1.932708910315258}, {
            1.278830970338324, 1.946010423490607}, {1.254904505264866, 
            1.9964453968060332`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.26696283523509146`, -0.19794311772468082`}, {
            0.33733574100070546`, -0.1622328771283844}, {
            0.39231933009432285`, -0.12133244499127938`}, {
            0.4453487787367831, -0.06805154203522476}, {
            0.4704488429168926, -0.03652819913646436}, {
            0.49425380744721664`, -0.0016061446572077263`}, {
            0.5016754010312113, 0.011227501646623977`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5056802908474077, 0.018152879438494012`}, {
            0.5164034461190237, 0.036695687052450666`}, {0.5365375327235828, 
            0.07835836164241666}, {0.5543346834851025, 0.1234714078269208}, {
            0.5694424406814395, 0.17203758386873386`}, {0.5814539671843346, 
            0.22390779974057198`}, {0.5899624258655289, 0.2789329654151513}, {
            0.5934363213837245, 0.3228225907898468}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5940675529621344, 0.3307976485761214}, {
            0.5945665624678355, 0.3371021963522179}, {0.5948606564372096, 
            0.3982940436218939}, {0.5904311712001055, 0.46219357061245936`}, {
            0.5808645701829774, 0.5284858407121945}, {0.5681676936162492, 
            0.5873580942236688}, {0.5514661461304053, 0.6462615497530787}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.5488888165941158, 0.6538324021459732}, {
            0.5292942398717363, 0.709216634582619}, {0.5026366816231643, 
            0.7716016599492111}, {0.4708047943619209, 0.8346637248445277}, {
            0.43355013007635856`, 0.8981236739397072}, {0.4060093582818835, 
            0.9388714718322944}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.4015295524770332, 0.9454995439464788}, {
            0.39067994308860715`, 0.9615520240248254}, {0.34200148772079675`, 
            1.0245192918899584`}, {0.2872330125655353, 1.0866745165379381`}, {
            0.2261639707990482, 1.147603919201392}, {0.19323988156083152`, 
            1.1774452779560367`}, {0.1875305379899374, 
            1.1822960330410257`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.1814338711942992, 1.1874758645038208`}, {
            0.1587084236188924, 1.2067837900150875`}, {0.12255885462292536`, 
            1.2355539916453906`}, {0.08478043222262498, 
            1.2636904191137919`}, {0.04531108971288392, 
            1.2912017065122463`}, {0.004107423790340919, 
            1.3180695432690333`}, {-0.03881331279269007, 
            1.3441880486554838`}, {-0.08174054237288658, 
            1.368492614191885}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.08879448948306617, 
            1.372264865443428}, {-0.1297369869309606, 
            1.3937535424027052`}, {-0.17770541898157233`, 
            1.4169887693061394`}, {-0.22732191068341648`, 
            1.439051141924565}, {-0.27856920928417944`, 
            1.4598347795293147`}, {-0.3487380590014764, 
            1.4851031635207843`}, {-0.38338272254572986`, 
            1.4958713345986832`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.39102221252374747`, 
            1.4982458225173234`}, {-0.4217601216011405, 
            1.5077997055590644`}, {-0.49763539708317195`, 
            1.5279244056441554`}, {-0.5763638854475706, 
            1.545477263776057}, {-0.6578400241322024, 
            1.5600745755599223`}, {-0.7033123985807888, 
            1.5661604238816187`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7112416984881214, 
            1.5672216509918904`}, {-0.7419582505749331, 
            1.5713326366009042`}, {-0.7850081467055856, 
            1.5757094480928135`}, {-0.828718564775763, 
            1.5792514468990024`}, {-0.8730895047854649, 
            1.58195863301947}, {-0.9181209667346917, 
            1.583831006454217}, {-0.9637660836532506, 
            1.5847679845106164`}, {-1.009977988570949, 
            1.5846689844960415`}, {-1.0304654556006925`, 
            1.5841719029262655`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.0384631019224924`, 
            1.5839778583143873`}, {-1.0567566814877867`, 
            1.5835340064104921`}, {-1.1041021624037635`, 
            1.5813630502539682`}, {-1.15201443131888, 
            1.5781561160264703`}, {-1.2004934882331362`, 
            1.5739132037279981`}, {-1.2495393331465312`, 
            1.5686343133585514`}, {-1.2991519660590658`, 
            1.5623194449181304`}, {-1.3487875476949551`, 
            1.5560566741651716`}, {-1.356949930015902, 1.55485191323494}}]}, {
          
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3648641864058113`, 
            1.5536837754884478`}, {-1.398933705447143, 
            1.54865514244495}, {-1.4496060471351067`, 
            1.5401407765371646`}, {-1.5007577493004125`, 
            1.5304357961027157`}, {-1.5560409502541468`, 
            1.5161799194647099`}, {-1.61176304873956, 
            1.500487471308735}, {-1.6678346519795324`, 
            1.4832717093517562`}, {-1.6758823148196338`, 
            1.4806043814995762`}}]}, {
           Arrowheads[{{0.016382338290392387`, 1.}}], 
           
           ArrowBox[{{-1.6834760804803557`, 
            1.4780874939196391`}, {-1.7242855575664373`, 
            1.4645615476881189`}, {-1.7753644943424252`, 
            1.4476326256943}, {-1.8266598079940248`, 
            1.4293935025049276`}, {-1.878171498521236, 
            1.4098441781200015`}, {-1.9298995659240594`, 
            1.388984652539522}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2568186181493335, 0.00463270427271921}, {
            0.280935841274935, 0.05419236324882863}, {0.2979859835780504, 
            0.11304310383585503`}, {0.30541436683357165`, 
            0.1808447668418154}, {0.3006664168221083, 0.25676481599091755`}, {
            0.2868180797944093, 0.31446336080711956`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2849510086888475, 0.3222424382258612}, {
            0.28084785861821476`, 0.3393380496169238}, {0.26449203755015027`, 
            0.38241212817036063`}, {0.24344551115785046`, 
            0.42619881833727785`}, {0.21727910072050727`, 
            0.47033774775373294`}, {0.1856545558953121, 0.5143870628818107}, {
            0.15489771678113404`, 0.550710284502272}, {0.12003791619799671`, 
            0.5863078886600965}, {0.11643777421795061`, 
            0.5894893111693069}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1104430603063003, 0.5947868016239908}, {
            0.08106236135589381, 0.6207503379220674}, {0.03764575543626232, 
            0.6538610794569908}, {-0.010075177337241208`, 
            0.6850895357849928}, {-0.06229238077099396, 
            0.7141511994386712}, {-0.11893782764761687`, 
            0.7405511059325625}, {-0.16276835927582978`, 
            0.7572505580300417}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{-0.17024414161131543`, 
            0.7600988344338412}, {-0.1799434907497309, 
            0.7637942907812024}, {-0.24538137944403177`, 
            0.7834035416706366}, {-0.31521147382995535`, 
            0.7988874445497027}, {-0.3891977027892328, 
            0.8097297323271261}, {-0.4671039952035954, 
            0.8154141379116315}, {-0.48399565961152075`, 
            0.8154395817377139}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4919956505358402, 
            0.8154516320823586}, {-0.549038968325301, 
            0.8155375561347163}, {-0.6348354887101861, 
            0.8096063522896602}, {-0.6789787987629144, 
            0.804166497904516}, {-0.7238438591953499, 
            0.796968464977861}, {-0.7693494578621298, 
            0.7879307458348698}, {-0.8088907896026482, 
            0.7785238051289758}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8166595736092277, 
            0.7766185426852262}, {-0.872100943151993, 
            0.7608885157375355}, {-0.9294544642553773, 
            0.7417088694478928}, {-0.987474945928044, 
            0.7194328939317891}, {-1.0461623881699933`, 
            0.6940605891892244}, {-1.1052490724632453`, 
            0.665378518794603}, {-1.1141460356658708`, 
            0.6605399879671339}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.1211739627353159`, 
            0.6567179150862795}, {-1.1644672802898204`, 
            0.6331732463223287}, {-1.2238170116497185`, 
            0.5974447717724021}, {-1.283298266542939, 
            0.5581930951448226}, {-1.3425746094741495`, 
            0.5152342150946168}, {-1.3871140365578702`, 
            0.4797072533612626}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3933681439502377`, 
            0.4747186522823292}, {-1.4013096049480165`, 
            0.4683841302768108}, {-1.4595032529645404`, 
            0.4176428406914047}, {-1.517155553523721, 
            0.36301034633839846`}, {-1.5629494609128396`, 
            0.3178577031435501}, {-1.6081628379596502`, 
            0.2701181794733066}, {-1.6228408681951387`, 
            0.25222343496904004`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.6279144017939218`, 
            0.2460380282061813}, {-1.6533211752115595`, 
            0.2150633189507683}, {-1.6973746232890516`, 
            0.15710208016582214`}, {-1.7238787946941025`, 
            0.1213359581466734}, {-1.7498492778882995`, 
            0.084482984685458}, {-1.7752860728716424`, 
            0.046543159782175964`}, {-1.8001891796441314`, 
            0.007516483436827211}, {-1.8134612807109391`, \
-0.014330192699259049`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.8176149458973163`, -0.021167375271011715`}, \
{-1.8245585982057668`, -0.03259704435058813}, {-1.8483943285565483`, \
-0.07379742358007019}, {-1.871696370696476, -0.11608465425161894`}, \
{-1.8944647246255495`, -0.15945873636523428`}, {-1.9165669633013933`, \
-0.20392093319396462`}, {-1.9378706596816306`, -0.24947250801085827`}, \
{-1.9583758137662624`, -0.2961134608159154}, {-1.9625238915968386`, \
-0.306160298350904}}]}, {
           Arrowheads[{{0.0020480642492446874`, 1.}}], 
           
           ArrowBox[{{-1.9685171412846172`, -0.33672239554141103`}, \
{-1.975142186395611, -0.33672239554141103`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.37385714218393845`, -0.04052520701388821}, \
{-0.40253381628466717`, -0.11595402396995787`}, {-0.41270435041941606`, \
-0.1585193849732361}, {-0.41953790802440394`, -0.20429293001303592`}, \
{-0.42257015675409526`, -0.25299531355294647`}, {-0.4213367642629542, \
-0.30434719005655664`}, {-0.41590655669125204`, -0.35314211454719774`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.41477911216192526`, -0.36105536402422994`}, \
{-0.4040965786005132, -0.41451675165315427`}, {-0.3871983543742415, \
-0.47257739822209444`}, {-0.36422183990831436`, -0.5319321386676203}, \
{-0.34109442143148405`, -0.5801726375870666}, {-0.313505813324034, \
-0.6287971367354992}, {-0.2958575353275821, -0.6554443943005054}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.2914401523949644, -0.6621142314819228}, \
{-0.28129102429236796`, -0.6774384705189835}, {-0.24428506304288974`, \
-0.7257294733435847}, {-0.20224623613807227`, -0.7734107642297551}, \
{-0.1549942118555331, -0.8201367345064372}, {-0.10245604147439305`, \
-0.8654108770424321}, {-0.0693051721100628, -0.8902184078472131}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.06290001738889361, -0.8950115271862118}, \
{-0.044558776273772825`, -0.9087366847065407}, {
            0.01889454423405992, -0.9496736929319544}, {
            0.08800167112335508, -0.9877366031003525}, {
            0.1626867389947682, -1.0223616570032668`}, {
            0.219076672448318, -1.0438969510308516`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.2265502167058733, -1.0467510947256158`}, {
            0.2428738824489549, -1.0529850964322296`}, {
            0.2850854204172223, -1.0666776258359352`}, {
            0.3287723118499493, -1.0792525797500536`}, {
            0.3738823122077111, -1.0906080759128347`}, {
            0.42036317695108283`, -1.100642232062527}, {
            0.4681626615406396, -1.109253165937381}, {
            0.5172285214369566, -1.1163389952756453`}, {
            0.537585194178852, -1.118549096543924}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5455384581294263, -1.1194125735456415`}, {
            0.567508512100609, -1.1217978378155695`}, {
            0.6189503889921719, -1.125527811295403}, {
            0.6837375045978658, -1.1275548547704155`}, {
            0.7502001068772828, -1.1266721841212262`}, {
            0.8183381958304223, -1.1228797993478348`}, {
            0.8649171418704198, -1.1184082234386699`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8728805307804797, -1.1176437386009288`}, {
            0.8881517714572846, -1.1161777004502411`}, {
            0.9594480164687734, -1.1062739942002684`}, {
            1.0320341135757922`, -1.0928767873697387`}, {
            1.1059100627783407`, -1.0759860799586525`}, {
            1.1810758640764192`, -1.0556018719670095`}, {
            1.1860350419739616`, -1.054029106076049}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.1936607348245203`, -1.0516106750662955`}, {
            1.2572644643820032`, -1.0314392316430887`}, {
            1.3342088106070678`, -1.0032132272351684`}, {
            1.4119089027516138`, -0.9709238587432494}, {
            1.4903647408156404`, -0.9345711261673306}, {
            1.4910022494067028`, -0.9342696120016137}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.4982341854207408`, -0.9308492170699048}, {
            1.532262941788815, -0.9147550777429261}, {
            1.5742902679100417`, -0.8937074881730769}, {
            1.6164709434377857`, -0.8714494325438411}, {
            1.6587322955966501`, -0.8479176855970434}, {
            1.7281073654527586`, -0.8026260019627373}, {
            1.7741687489707902`, -0.7700111241442169}}]}, {
           Arrowheads[{{0.01210495744973694, 1.}}], 
           
           ArrowBox[{{1.7806977427064135`, -0.7653881120524965}, {
            1.7972669397072871`, -0.7536558909496948}, {
            1.8662438828656913`, -0.702810951588713}, {
            1.9005953811228005`, -0.6759823606472679}, {
            1.9348555638318474`, -0.6482163555318532}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.40010251586642537`, 
            0.16207728931932225`}, {-0.45841019945718026`, 
            0.11291710933389346`}, {-0.5138455934104675, 
            0.050604397396112576`}, {-0.5397669010680184, 
            0.014307617802105996`}, {-0.5641178881620197, \
-0.02554296865931458}, {-0.5865291772214464, -0.06891211483725776}, \
{-0.5944978939526526, -0.08748489394381437}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.597652242542877, -0.09483677023299045}, \
{-0.6066313907752745, -0.11576457358083295`}, {-0.624089686377511, \
-0.16617396423363162`}, {-0.6385415935621378, -0.22012681294365927`}, \
{-0.6495762928280928, -0.27745723276664613`}, {-0.6567829646743143, \
-0.3379993367583231}, {-0.6597529577891676, -0.4017237288548907}, \
{-0.6596304312325714, -0.40660179424023135`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.659429551721897, -0.4145992718064513}, \
{-0.6580758863094763, -0.46849182028817316`}, {-0.6513383289068658, \
-0.5379739350573368}, {-0.6391268642529615, -0.6098403971615487}, \
{-0.6235407270861635, -0.6747373622010487}, {-0.606874971466174, \
-0.7288736717140776}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6045211971158404, -0.7365195690654492}, \
{-0.6031021408507914, -0.7411291691899676}, {-0.5775592180414999, \
-0.8086876194023063}, {-0.5466600711529438, -0.8770845141120661}, \
{-0.5101087160338003, -0.9461039321640721}, {-0.4676444458495284, \
-1.0154401303464902`}, {-0.4628757969557611, -1.0224662881012059`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.4583832057085419, -1.0290857007553174`}, \
{-0.4441327890047907, -1.0500823557956704`}, {-0.41906828906995636`, \
-1.0846301768483337`}, {-0.3924260746037539, -1.1190257270281065`}, \
{-0.36418127416491186`, -1.1532111398586158`}, {-0.3342829098178357, \
-1.1871510598837085`}, {-0.30268949689759383`, -1.2208019458216972`}, \
{-0.2693904038689091, -1.2540936524579065`}, {-0.25071254362348727`, \
-1.2716230509128714`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.24487919276180403`, -1.2770977214714072`}, \
{-0.23437499919650454`, -1.2869560345776607`}, {-0.19763265134510286`, \
-1.319318946966284}, {-0.1591527287794268, -1.3511122444091017`}, \
{-0.11892459996419935`, -1.3822657816914374`}, {-0.07693763336414337, \
-1.412709413598616}, {-0.03312639939694759, -1.4424511940275748`}, {
            0.009938930535334754, -1.4698090942183302`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.016770341372040625`, -1.473970523937401}, {
            0.060086121389563985`, -1.49965525474433}, {
            0.10944889159176027`, -1.5268919364810158`}, {
            0.16062365725517075`, -1.5530679867691666`}, {
            0.21359116007123596`, -1.5780706063332273`}, {
            0.26833214173139597`, -1.601786995897642}, {
            0.3032584904545461, -1.6155839888766435`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3106989843189556, -1.6185232151445046`}, {
            0.3248273439270912, -1.6241043561868562`}, {
            0.40216443464711804`, -1.6512158918415265`}, {
            0.4825707482036381, -1.6755188356930726`}, {
            0.523924863545583, -1.6866170856926739`}, {
            0.5660462845966512, -1.697013187741494}, {
            0.6089350113568426, -1.706707141839533}, {
            0.6174417572835463, -1.7084592710640716`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6252772789121781, -1.7100731486329235`}, {
            0.6525910438261572, -1.7156989479867906`}, {
            0.6969855793600362, -1.723886368928948}, {
            0.7420898153139207, -1.7311671674116862`}, {
            0.7879037516878107, -1.7375413434350047`}, {
            0.8344273884817058, -1.7430088969989035`}, {
            0.8816607256956069, -1.7475698281033833`}, {
            0.9296037633295132, -1.7512241367484436`}, {
            0.9422310386446252, -1.7519372680404002`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.9502183111677927, -1.752388352999864}, {
            0.9782565013834248, -1.753971822934084}, {
            1.027618939857342, -1.755812886660305}, {
            1.077640737145254, -1.7566403014108773`}, {
            1.1282715516411508`, -1.7563470406695714`}, {
            1.1795113833450315`, -1.7549331044363865`}, {
            1.2313602322568966`, -1.7523984927113234`}, {
            1.2699566143647834`, -1.7497090798057962`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.2779372633483765`, -1.7491529846694447`}, {
            1.2838180983767462`, -1.7487432054943821`}, {
            1.33688498170458, -1.743967242785562}, {
            1.3905608822403983`, -1.7380706045848635`}, {
            1.444845799984201, -1.7310532908922869`}, {
            1.4979571978845252`, -1.7242324029154852`}, {
            1.551593292372613, -1.7162354892890703`}, {
            1.5952864398981446`, -1.7088583080170427`}}]}, {
           Arrowheads[{{0.019118453214341483`, 1.}}], 
           
           ArrowBox[{{1.6031747926505913`, -1.7075264330781066`}, {
            1.6057697232365447`, -1.7070883032017976`}, {
            1.6604395711120794`, -1.6967135850874018`}, {
            1.7192476831889942`, -1.6816998045193121`}, {
            1.7785077641035716`, -1.6652206533076384`}, {
            1.8381328436105693`, -1.647190757840998}, {
            1.8981519117917347`, -1.6276385759898522`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.026770227753545147`, 
            0.345122767218881}, {-0.036601665832425155`, 
            0.38382313286847625`}, {-0.11344222506075763`, 
            0.41418659721713813`}, {-0.1568776131360152, 
            0.4251723226296621}, {-0.20363739823611027`, 
            0.43279022018820434`}, {-0.2534428773756855, 
            0.43656244340788436`}, {-0.2744377266936298, 
            0.43634228236002043`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.28243728686892655`, 
            0.4362583955207308}, {-0.30601534756938403`, 
            0.4360111458038217}, {-0.36127872691319973`, 
            0.43062318370004676`}, {-0.4189948366380458, 
            0.41991365117346113`}, {-0.47864182846094405`, 
            0.4034470583684914}, {-0.5396978540989165, 
            0.380787915429564}, {-0.5891519777205755, 
            0.35793938286263915`}, {-0.5897775950619526, 
            0.35759644730102697`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5967927793090768, 
            0.35375103575232375`}, {-0.6390594920016477, 
            0.33058230640920483`}, {-0.6890538430890799, 
            0.29854502503883884`}, {-0.7387684771298191, 
            0.261655877721119}, {-0.7879455880981117, 
            0.2196684728402804}, {-0.8362403717063643, 
            0.17239620324883273`}, {-0.8483976610500555, 
            0.15875571573838954`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{-0.8537204943480956, 
            0.15278349289582274`}, {-0.8831557767087642, 
            0.11975708461876483`}, {-0.9281947518594986, 
            0.061669132622065685`}, {-0.9709185982570941, \
-0.0020723361113214682`}, {-1.0108419351246059`, -0.07157384571781658}, \
{-1.0295762018411363`, -0.10846422381021578`}, {-1.031261301302917, \
-0.11208621580021087`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0346358915091665`, -0.11933963850538158`}, \
{-1.047397688403013, -0.14677014167497549`}, {-1.064235510552858, \
-0.18648344249679005`}, {-1.0800187840332944`, -0.227595969460354}, \
{-1.0947359941905217`, -0.2701767786020546}, {-1.1083540374239849`, \
-0.31426684855766357`}, {-1.1207696460561725`, -0.3598159064109521}, \
{-1.131879552409574, -0.40677367924569124`}, {-1.1350114671409175`, \
-0.4223724069368774}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1365862794372528`, -0.43021587340466516`}, \
{-1.1415804888066785`, -0.4550898941456521}, {-1.149769187569975, \
-0.5047142781946056}, {-1.1563423810219526`, -0.5555965584763227}, \
{-1.1611968014851006`, -0.6076864620745744}, {-1.1646247742386273`, \
-0.6735541781007778}, {-1.16513637082054, -0.7411834101189752}, \
{-1.1648895853375982`, -0.7483044907089491}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.1646125066925872`, -0.7562996909831435}, \
{-1.1627315912308382`, -0.8105741581291664}, {-1.1574104354695227`, \
-0.8817264221313521}, {-1.1488734656705173`, -0.9544513846950298}, \
{-1.1368212439677465`, -1.028560228389697}, {-1.1275238696616765`, \
-1.0736468068435439`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.1259081717744082`, -1.081481953321886}, \
{-1.1212537703612102`, -1.1040529532153545`}, {-1.1021710448509086`, \
-1.1809295591720017`}, {-1.079279065464979, -1.258926160929751}, \
{-1.0522838302315591`, -1.3377788731587148`}, {-1.0372474916720404`, \
-1.3775262706999019`}, {-1.033288395684709, -1.387376203190849}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.030304851205519, -1.3947990370392316`}, \
{-1.021185339150649, -1.4174876958588924`}, {-1.0040973726673847`, \
-1.4576631486356868`}, {-0.9859835922222482, -1.4980526290302847`}, \
{-0.9666793629609933, -1.5413104136413767`}, {-0.9461164452915862, \
-1.5847282492120962`}, {-0.92431703411827, -1.6283305331417623`}, \
{-0.9012145447283143, -1.6720440732324167`}, {-0.8938050915691366, \
-1.6839481208992102`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8895776523036852, -1.6907399363602573`}, \
{-0.8563755328350766, -1.7440825521109664`}, {-0.807748506331549, \
-1.8159805935155842`}, {-0.7829518820133202, -1.8518929134742645`}, \
{-0.7571890355621613, -1.8877318319456873`}, {-0.7304599669780725, \
-1.9234973489298537`}, {-0.7072005552907914, -1.953472755825382}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.10889718245693185`, 0.4679630644140419}, {
            0.044846446464437015`, 0.5234930989228378}, {0.007626494940282277,
             0.5493682508359802}, {-0.03318025064414169, 
            0.573603946855974}, {-0.07753345080181266, 
            0.5958262274662205}, {-0.12539276604570826`, 
            0.6156611331501204}, {-0.1643183826582844, 0.62860754788665}}]}, {
          
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1719095317673658, 
            0.6311323162331905}, {-0.17682848229952208`, 
            0.6327683281759582}, {-0.23182238515837494`, 
            0.6467805777841116}, {-0.2902013846423864, 
            0.657283573916122}, {-0.3517923907716766, 
            0.6638630085135311}, {-0.4165604839023677, 
            0.66610516425723}, {-0.4843602081217797, 
            0.6635958512366301}, {-0.4884902050301831, 
            0.6631461432166403}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.49644319606651, 
            0.6622801561635592}, {-0.55485266904683, 
            0.6559200525060536}, {-0.627698972294435, 
            0.6426627511198224}, {-0.6935042386172238, 
            0.6260442189739127}, {-0.7607719730782606, 
            0.6044738066343107}, {-0.8061111612632517, 
            0.5867245189812131}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.813560664826808, 
            0.5838082033850264}, {-0.8291654498727145, 
            0.577699275774447}, {-0.8983479431957542, 
            0.5454683880677521}, {-0.9680963299307895, 
            0.5074827155470324}, {-1.038096604810638, 
            0.46348078195759346`}, {-1.0730433724827668`, 
            0.4391622139002852}, {-1.0908927800745518`, 
            0.425891902985267}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.0973128792927622`, 
            0.4211188194925618}, {-1.1078757188045794`, 
            0.4132657765416144}, {-1.142534512647235, 
            0.3857668685368533}, {-1.1769606228818943`, 
            0.3566408885412744}, {-1.2111175021320915`, 
            0.3258364226088873}, {-1.2449603907477704`, 
            0.2933118068305245}, {-1.278417839189705, 
            0.25905706491669267`}, {-1.3114183979186695`, 
            0.22306222057789812`}, {-1.329581999417207, 
            0.20194928921751834`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.3347993835558996`, 
            0.19588472800096537`}, {-1.3438906173954377`, 
            0.1853172975246477}, {-1.3757630480807834`, 
            0.1458123194674481}, {-1.4069642404354805`, 
            0.10453731011680584`}, {-1.4374227449203034`, 
            0.06148229318322734}, {-1.4671458209179047`, 
            0.01658075662138485}, {-1.4961121063848002`, \
-0.030213253157382432`}, {-1.5170802053069308`, -0.06653364661719297}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5210799921326994`, -0.07346197291929561}, \
{-1.5242072196425565`, -0.07887887475756729}, {-1.551316779012741, \
-0.1293952467836623}, {-1.5773264028169205`, -0.18174150784016035`}, \
{-1.6021217093766627`, -0.2358967965315544}, {-1.6255883170135346`, \
-0.291840251462337}, {-1.6476118440491032`, -0.34955101123700094`}, \
{-1.6527184122605163`, -0.36467666842424545`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.6552773876977918`, -0.37225635474436586`}, \
{-1.6741921541832852`, -0.4282819010196381}, {-1.697897926177176, \
-0.5100831481168647}, {-1.7086728603715116`, -0.5521351556584491}, \
{-1.718729160030775, -0.594954752528681}, {-1.7280668251549651`, \
-0.6385419387275603}, {-1.7364083164480189`, -0.6814684569760711}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.7378011171557504`, -0.689346021832788}, \
{-1.7444835267967207`, -0.7279889038368959}, {-1.751357113311473, \
-0.7737883321986222}, {-1.7573066152883388`, -0.8202949993402655}, \
{-1.7623320327273193`, -0.867508905261826}, {-1.7664333656284137`, \
-0.9154300499633038}, {-1.7696106139916226`, -0.9640584334446989}, \
{-1.7715850016118033`, -1.0072899289675343`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.7719139433002231`, -1.0152829003614612`}, \
{-1.773192857104382, -1.0634369167472404`}, {-1.7734905512125239`, \
-1.114135140701633}, {-1.7726495594999616`, -1.1654368517024347`}, \
{-1.7706698819666948`, -1.2173420497496452`}, {-1.767551518612724, \
-1.2698507348432648`}, {-1.7632944694380488`, -1.3229629069832938`}, \
{-1.762095639492108, -1.3348975073396512`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.7612960637457977`, -1.342857449464184}, \
{-1.7578987344426698`, -1.3766785661697316`}, {-1.7513643136265864`, \
-1.4309977124025788`}, {-1.7436912069897987`, -1.4859203456818348`}, \
{-1.7362094688167782`, -1.5398082728814972`}, {-1.7275275117139186`, \
-1.5942170350737783`}, {-1.7176713361690081`, -1.6491627886344806`}, \
{-1.7156048913650517`, -1.6594749774383268`}}]}, {
           Arrowheads[{{0.018100012416363106`, 1.}}], 
           
           ArrowBox[{{-1.714033031630687, -1.6673190361438366`}, \
{-1.7065629407186822`, -1.704597064436197}, {-1.6906985851442786`, \
-1.7641872700408947`}, {-1.6733408204192843`, -1.8242214178556504`}, \
{-1.6544038185275654`, -1.884610267407734}, {-1.6339161888078335`, \
-1.9453835655213898`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.25118625370236497`, -0.29246312730816143`}, {
            0.2907794168049376, -0.28469342439595885`}, {
            0.331741363691493, -0.27294286870114365`}, {
            0.3737862013149094, -0.2568098386633245}, {
            0.41657242870980715`, -0.2359377493353968}, {
            0.45967284709733086`, -0.21014787762288292`}, {
            0.5026365819140688, -0.17916557964774052`}, {
            0.5338263315911673, -0.152244418840897}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5398823985391401, -0.1470171773961509}, {
            0.5449921532095237, -0.1426067371525115}, {
            0.5861977352070789, -0.10019732575310938`}, {
            0.6180344351531615, -0.06180450016738372}, {
            0.6484293033102098, -0.019460912453250684`}, {0.6769702296974349, 
            0.026779012778143124`}, {0.703430513523576, 
            0.07718387114747738}, {0.7198607465317093, 
            0.11458776366843901`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7230781465173415, 0.12191226619983689`}, {
            0.7273093361007854, 0.13154468957061963`}, {0.7483008780612361, 
            0.18999222313828917`}, {0.7659450787716753, 0.2523885075242118}, {
            0.7797818775988494, 0.31859557840211356`}, {0.789348830846917, 
            0.388606618492834}, {0.7922453486122287, 0.4327459207139074}}]}, {
          
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7927691994378518, 0.44072875105862186`}, {
            0.7941854012701071, 0.46230989287952196`}, {0.7938343879102724, 
            0.5394100607793665}, {0.787838589809266, 0.6196117814095566}, {
            0.7825990270525095, 0.6608777557825085}, {0.7758062819038753, 
            0.7029627168185746}, {0.7673933828593553, 0.7457782964952095}, {
            0.764453941395015, 0.7584259637381362}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7626429302614982, 0.7662182829483764}, {
            0.7572933584149404, 0.789236126789868}, {0.7454392370666223, 
            0.8332478396800048}, {0.7317640473103922, 0.8777250671430745}, {
            0.7162008176422417, 0.9225794411565319}, {0.6986825765581622, 
            0.9677225936978318}, {0.673357553765809, 1.025562379549925}, {
            0.6533047505496382, 1.0660870246976224`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.6497567293810295, 1.0732572091992307`}, {
            0.6446092305439505, 1.083659772946657}, {0.612437606892587, 
            1.1420147738880282`}, {0.5768426828117184, 1.2006273823740383`}, {
            0.5376331464821573, 1.2591746735756886`}, {0.49461768608471646`, 
            1.3173337226639799`}, {0.4754883144355312, 
            1.3409365966438247`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.4704511847565691, 1.3471516851063745`}, {
            0.4477963016193957, 1.3751045296389124`}, {0.3971689930861952, 
            1.432487094500486}, {0.34258695150806223`, 1.4890878396351603`}, {
            0.2839013679079443, 1.5445131874293947`}, {0.2474722068040844, 
            1.5759880672812339`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.24141871874532378`, 1.5812182950317666`}, {
            0.2211122422858414, 1.5987631378831901`}, {0.1542195746417534, 
            1.6518376909965453`}, {0.11216682298731728`, 
            1.6838521173676426`}, {0.06853976007971216, 
            1.7152694493626681`}, {0.020710084470987912`, 
            1.7458906674930401`}, {-0.01731216006257237, 
            1.7687541814451475`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.024168109421943595`, 
            1.7728767969234256`}, {-0.028793193068400717`, 
            1.7756579495296874`}, {-0.06931235633018254, 
            1.799348189385217}, {-0.11092277878883619`, 
            1.8223451849600376`}, {-0.15362446044436165`, 
            1.8446489362541492`}, {-0.197417401296759, 
            1.8662594432675519`}, {-0.24230160134602818`, 1.8871767060002458`}
            , {-0.28827706059216907`, 
            1.9074007244522304`}, {-0.3098604335011677, 
            1.9163569465149703`}}]}, {
           Arrowheads[{{0.0044563378640271704`, 1.}}], 
           
           ArrowBox[{{-0.31724951998172174`, 
            1.919423116924927}, {-0.3353437790351818, 
            1.9269314986235062`}, {-0.38350175667506653`, 
            1.9457690285140732`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.10764903550683011`, -0.4796743359800337}, \
{-0.04212240661833188, -0.5356364456897266}, {-0.0041263767836571975`, \
-0.561671510875674}, {0.0374793028834108, -0.5860272892244767}, {
            0.08265230226656455, -0.6083290884986746}, {
            0.13135029124949643`, -0.6282022164608084}, {
            0.1661209072149773, -0.6395746481467173}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.17372453938442226`, -0.6420615695028887}, {
            0.18364122559576235`, -0.6453050218651081}, {
            0.23950483236502768`, -0.6592694206724521}, {
            0.2987664383851485, -0.6696810714553527}, {
            0.361251370483981, -0.6761256327863224}, {
            0.42692242100004896`, -0.6781891088340612}, {
            0.49016717930556764`, -0.6756745226609059}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.4981473548070683, -0.6751775202753034}, {
            0.5670417052889163, -0.6675152320121832}, {
            0.6408106754918262, -0.6539483668567417}, {
            0.7076636004621912, -0.6369551013670159}, {
            0.7759910814281585, -0.6149413124836333}, {
            0.8084832799078088, -0.6021763362753892}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8159292775088761, -0.5992510807780183}, {
            0.8454526347390962, -0.5876524518681501}, {
            0.9157077767443715, -0.5548339711821232}, {
            0.9865303569268835, -0.516184734197396}, {
            1.0576027582627059`, -0.47144087499758247`}, {
            1.0930833657972117`, -0.44672138616989726`}, {
            1.0953527658764703`, -0.4450325116192723}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.1017706063487127`, -0.4402563914707787}, {
            1.1284472973409694`, -0.42040375071189495`}, {
            1.1636348424676202`, -0.3924631382647272}, {
            1.198586290750805, -0.3628747184695458}, {
            1.2332646944422696`, -0.3315866721590171}, {
            1.2676248284562666`, -0.2985569942779842}, {
            1.301594566360199, -0.26377557563586324`}, {
            1.3351017817214696`, -0.22723230704207}, {
            1.3373560795747732`, -0.22461273734819084`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.3425743467460851`, -0.21854893592261568`}, {
            1.3680743481074813`, -0.1889170793060207}, {
            1.400440139085637, -0.1488197832371312}, {
            1.432127028223339, -0.10693030964481752`}, {
            1.4630628890879904`, -0.06323854933849571}, {
            1.4932550535086309`, -0.017677534402103182`}, {
            1.5226819594009766`, 0.029799027180248672`}, {1.5290909297831217`,
             0.040883472830099424`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5330953164112529`, 0.047809141587154116`}, {
            1.5512281394624474`, 0.07917023074888274}, {1.5787781263904626`, 
            0.13041517164412206`}, {1.6052164528824413`, 
            0.1835129452062895}, {1.6304276516358025`, 
            0.23844264677570803`}, {1.6542962553479659`, 
            0.2951833716927008}, {1.6701300102360643`, 
            0.33653726028465036`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.6729905731800467`, 0.3440083498734262}, {
            1.6767067967163505`, 0.35371421529759045`}, {1.7037926275785726`, 
            0.43362652046849615`}, {1.7279696136677816`, 
            0.5166541265515969}, {1.7389672899225064`, 0.5593361674352207}, {
            1.7492377549839775`, 0.6027970335468931}, {1.7587810088521956`, 
            0.6470367248866145}, {1.7596961288570343`, 
            0.6517097223547783}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.7612335774862369`, 0.6595605982111756}, {
            1.7675970515271604`, 0.6920552414543847}, {1.7755819456371549`, 
            0.7378222233251981}, {1.7826317538104626`, 0.7843073105740495}, {
            1.7887464760470824`, 0.8315105032009381}, {1.7939261123470152`, 
            0.8794318012058646}, {1.798170662710261, 0.9280712045888291}, {
            1.801434808395717, 0.9767528275046636}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.8018269447251252`, 0.9847430921663182}, {
            1.8038545056266908`, 1.0275043274888709`}, {1.8052937981798747`, 
            1.0782980470059482`}, {1.8056894125570442`, 
            1.1297576235459517`}, {1.804932756518871, 1.1818308087537697`}, {
            1.8030238300653558`, 1.2345176026294022`}, {1.7999626331964982`, 
            1.287818005172849}, {1.7986593467063576`, 
            1.3044943901312458`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.7980360343484079`, 1.3124700707733243`}, {
            1.7957491659122988`, 1.3417320163841107`}, {1.7903834282127566`, 
            1.3962596362631863`}, {1.7838654200978725`, 
            1.4514008648100765`}, {1.776195141567646, 1.5071557020247812`}, {
            1.7687502271012545`, 1.5615943099981417`}, {1.7601025783821165`, 
            1.616557866114544}, {1.757755241370854, 1.6298194623222657`}}]}, {
          
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.7563608945061666`, 1.637697012501156}, {
            1.7502781276774058`, 1.6720624219509757`}, {1.7391990781855995`, 
            1.7280598227764743`}, {1.7233705822509497`, 
            1.7882143175847776`}, {1.7060483734832832`, 
            1.8488176257746993`}, {1.6871468998387489`, 
            1.9097814163477014`}, {1.6748266433344123`, 
            1.946740410672574}}]}, {
           Arrowheads[{{0.001107151164214051, 1.}}], 
           
           ArrowBox[{{1.67095187954669, 1.967100829840283}, {
            1.668039510966117, 1.967100829840283}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.16469892838407607`, -0.45355125072278885`}, {
            0.21406841159013645`, -0.46187077235111906`}, {
            0.2666565160988329, -0.46617468100042614`}, {
            0.3221768046312505, -0.46596350960179916`}, {
            0.38055240979253857`, -0.460703013382734}, {
            0.4415388082805948, -0.4498867697336012}, {
            0.48124843638091797`, -0.43928877026727975`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.48897789096312116`, -0.4372258762172476}, {
            0.5045980789556279, -0.4330570448298018}, {
            0.5691923006778463, -0.4097561048467365}, {
            0.6213805262468836, -0.3862648594202819}, {
            0.6740869457877379, -0.3580932780688069}, {
            0.7269370256929225, -0.32506033404003654`}, {
            0.7721806134176616, -0.29232200903001204`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7786618017612127, -0.28763221184298804`}, {
            0.7795562323549512, -0.2869850005816956}, {
            0.831681206600078, -0.24361201257883658`}, {
            0.8829596497075642, -0.19474549560665}, {
            0.9328836187494346, -0.14029350894806802`}, {
            0.9809451707977132, -0.08016411188602286}, {
            0.997691482549422, -0.055998857001278504`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.002248200590559, -0.049423423882952774`}, {
            1.0266979488726244`, -0.014141959649871213`}, {
            1.0696463272358332`, 0.05788956928817009}, {1.0898870396299811`, 
            0.09614130497439195}, {1.1092084598215226`, 0.1358743307808777}, {
            1.12753785705223, 0.17708162868922436`}, {1.1448025005638767`, 
            0.21975618068102887`}, {1.1498288993071941`, 
            0.23348286424635062`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.1525796951275555`, 0.24099506248353011`}, {
            1.160991932838526, 0.2639681951440224}, {1.1760730515435904`, 
            0.30975979813643284`}, {1.1899391586988661`, 
            0.35708184814560223`}, {1.2024835563241496`, 
            0.40588520365887293`}, {1.213599546439237, 0.4561207231635872}, {
            1.223180431063925, 0.5077392651470876}, {1.2296556892700692`, 
            0.5509282192067672}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           ArrowBox[{{1.2308418602174722`, 0.558839792911381}, {
            1.231119512218009, 0.5606916880967161}, {1.237310091921286, 
            0.6149288504998153}, {1.242351044278273, 0.6837780862459847}, {
            1.244402363993804, 0.754522361666104}, {1.2434640510678787`, 
            0.8271616767601729}, {1.240775603116398, 0.8781760632768923}}]}, {
          
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.240354588948178, 0.8861649772875798}, {
            1.2395361055004974`, 0.9016960315281918}, {1.2323054590530498`, 
            0.9779376375107772}, {1.2214590434869252`, 1.055698706248546}, {
            1.2069968588021243`, 1.1349792377414982`}, {1.1919836553763787`, 
            1.2020812318959981`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.1902369436799622`, 1.2098882158366504`}, {
            1.188918904998646, 1.2157792319896337`}, {1.1784466998886147`, 
            1.2566828479413925`}, {1.1669159229213375`, 
            1.2978339701709418`}, {1.1543265740968143`, 
            1.3392325986782818`}, {1.140678653415045, 1.3808787334634123`}, {
            1.1259721608760296`, 1.4227723745263332`}, {1.1102070964797683`, 
            1.4649135218670446`}, {1.093383460226261, 1.5073021754855465`}, {
            1.0907109448153656`, 1.513674195857892}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.087616759382942, 1.5210515948920895`}, {
            1.0755012521155078`, 1.549938335381839}, {1.0564858633107372`, 
            1.5955065649390245`}, {1.0361749901898165`, 1.641271908656512}, {
            1.0145919399204377`, 1.6872587856524104`}, {0.991666790999526, 
            1.733393938572393}, {0.9695864247775066, 1.7717718157292492`}, {
            0.9476447079938182, 1.8083278881611953`}}]}, {
           Arrowheads[{{0.01108710719831254, 1.}}], 
           
           ArrowBox[{{0.9434312090231232, 1.8151280135074497`}, {
            0.9224795636645363, 1.8485509005532037`}, {0.8974311946613026, 
            1.8869134481970689`}, {0.8723722652558751, 1.9252562290896826`}, {
            0.8462992351002743, 1.9635479233049244`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.6415666216482458, 0.13326319201233028`}, {
            0.6589475691213073, 0.18611137593072014`}, {0.6731922512815038, 
            0.24254252678684127`}, {0.683889342433332, 0.3023853047573961}, {
            0.6906275168812881, 0.3654683700190872}, {0.6929966520034745, 
            0.4317552557649191}, {0.6924544932447654, 
            0.44734915591485447`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6921765223059746, 0.4553443252162006}, {
            0.6905856627191087, 0.5011015967748547}, {0.6829817796443596, 
            0.5731742056060335}, {0.669772233395396, 0.6476398948155949}, {
            0.6530203475172145, 0.7154687274550621}, {0.6361509187884045, 
            0.7691268108955993}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6337515993113487, 0.776758538488158}, {
            0.63121755894795, 0.7848187847150337}, {0.6041058518744837, 
            0.8553504884371066}, {0.5714272104836963, 0.9267242604628771}, {
            0.5328781008494722, 0.9987149405621882}, {0.49300820511868826`, 
            1.0632135623759362`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4888017794464622, 1.0700184123422498`}, {
            0.4881914035360929, 1.0710058341622857`}, {0.46348289885049404`, 
            1.1071148361275356`}, {0.43716372446603496`, 
            1.1431200615908697`}, {0.4092084561230253, 1.1789619005932506`}, {
            0.37959166956177454`, 1.2145807431756406`}, {0.34826124829564503`,
             1.2499399689989337`}, {0.31517478210234345`, 
            1.2849945978622304`}, {0.2845063521626171, 
            1.3155086060238093`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.27878960057628, 1.3211038341775772`}, {
            0.24369025548152898`, 1.3539014657019255`}, {0.2052704653276686, 
            1.3876094051748697`}, {0.165051170793941, 1.4207241486809083`}, {
            0.12302150701717249`, 1.4531735464683146`}, {0.07917060913418908, 
            1.4848854487853618`}, {0.033431663266835, 1.5158679582288261`}, {
            0.028116064827359163`, 1.5192388349626509`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.02136000162083759, 
            1.523523179714125}, {-0.014241799366688302`, 
            1.5460999947233014`}, {-0.06383012598501912, 
            1.5754656345087854`}, {-0.11531366380679546`, 
            1.6038489538252763`}, {-0.16867276005065546`, 
            1.6311340289127716`}, {-0.22388776193523713`, 
            1.6572049360112686`}, {-0.26098177813520745`, 
            1.6732911064117921`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.2683213496461481, 
            1.676473980904415}, {-0.28093901667917853`, 
            1.6819457513607656`}, {-0.33980687150111777`, 
            1.7052405512012603`}, {-0.3797598119747752, 
            1.7197887181511413`}, {-0.42050992231660095`, 
            1.7336092214903185`}, {-0.4620572025265953, 
            1.746702061218792}, {-0.5044016526047581, 
            1.759067237336562}, {-0.5475432725510895, 
            1.7707047498436281`}, {-0.5718360148679824, 
            1.7767365533838366`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5796002569284788, 
            1.7786643877195663`}, {-0.5914820623655893, 
            1.7816145987399907`}, {-0.6362180220482577, 
            1.7917967840256497`}, {-0.6817511515990946, 
            1.801251305700605}, {-0.7280519231977418, 
            1.809872629797576}, {-0.7750908090238415, 
            1.8175552223492824`}, {-0.8228678090773934, 
            1.8242990833557235`}, {-0.8713829233583976, 
            1.8301042128168998`}, {-0.8947714891401359, 
            1.8324150880878858`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.9027327241015703, 
            1.8332016870256134`}, {-0.9206361518668541, 
            1.8349706107328114`}, {-0.9706274946027629, 
            1.8388982771034579`}, {-1.0213569515661243`, 
            1.8418872119288399`}, {-1.0728245227569377`, 
            1.8439374152089565`}, {-1.124978615712378, 
            1.8449383919255664`}, {-1.1777676379696198`, 
            1.844779647060428}, {-1.2223392832768467`, 1.843679649454388}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.2303368481151238`, 
            1.8434822750448139`}, {-1.2311915895286627`, 
            1.8434611806135404`}, {-1.2852504703895067`, 
            1.840982992584904}, {-1.3399442805521522`, 
            1.837345082974519}, {-1.3952730200165993`, 
            1.8325474517823859`}, {-1.4512366887828472`, 
            1.8265900990085033`}, {-1.5078352868508966`, 
            1.819473024652872}, {-1.5488698723227543`, 
            1.8143418631191148`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.5568080515588334`, 
            1.8133492350841083`}, {-1.5625237725923031`, 
            1.812634513890574}, {-1.6177466966416376`, 
            1.8046093648597175`}, {-1.6735195202469972`, 
            1.7954231822586917`}, {-1.7297958596640883`, 
            1.7849991519923278`}, {-1.790214390972282, 
            1.769932325478306}, {-1.851095760051585, 
            1.7533946954749786`}, {-1.8696269157959942`, 
            1.7479214588677263`}}]}, {
           Arrowheads[{{0.006329012352528142, 1.}}], 
           
           ArrowBox[{{-1.8772992686645193`, 
            1.7456554047066717`}, {-1.9123549515157818`, 
            1.735301595731123}, {-1.9740203038269444`, 
            1.7156812483304802`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5029294583149013, 0.26499814464632115`}, {
            0.5047450191386965, 0.32314975666718504`}, {0.5014314801388347, 
            0.38444611718260174`}, {0.4924599184910174, 
            0.44865434827999473`}, {0.4773399351278235, 0.5152416143931899}, {
            0.4569414815334544, 0.5793966507738196}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4542671241720952, 0.5869303948146679}, {
            0.4333221305469363, 0.6388194325709412}, {0.40630285008475114`, 
            0.6946825523405067}, {0.37432528092914397`, 0.750896008643323}, {
            0.3371914144139825, 0.8070913708580044}, {0.29482421490362987`, 
            0.8627644048746627}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           ArrowBox[{{0.2895845071316236, 0.8688088170168844}, {
            0.24644473986500742`, 0.9183146943787828}, {0.19250404411626046`, 
            0.9724931057416821}, {0.13269677188422688`, 
            1.0250444740903928`}, {0.06678822513392425, 
            1.0755322285254876`}, {0.05409067235948308, 
            1.0839680598469565`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.0474272050575507, 
            1.0883950456743654`}, {-0.005361538241912309, 
            1.1234661292175638`}, {-0.04376878842495497, 
            1.146292834267201}, {-0.08372663747704033, 
            1.1682620157097605`}, {-0.12523185030238784`, 
            1.1893006534881347`}, {-0.1682811918052173, 
            1.209335727545216}, {-0.21294459629746343`, 
            1.2283607096919675`}, {-0.23511509756520405`, 
            1.2369684712470268`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.24257273596765588`, 
            1.2398639210321682`}, {-0.25926539103370966`, 
            1.2463448928782361`}, {-0.3072004303321495, 
            1.2631789887552385`}, {-0.35670656851097654`, 
            1.2787537089741927`}, {-0.4077406598883839, 
            1.2929597651863156`}, {-0.4602595587825654, 
            1.3056878690428249`}, {-0.5142201195117143, 
            1.3168287321949372`}, {-0.550966913169487, 
            1.3230977853640566`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5588529750322937, 
            1.3244431582848433`}, {-0.5695791963940239, 
            1.3262730662938704`}, {-0.6407890102409999, 
            1.3354955840887994`}, {-0.7141313943910407, 
            1.3417369771213044`}, {-0.7896063488441464, 
            1.3449972453913845`}, {-0.8672138736003171, 
            1.3452763888990409`}, {-0.8777596267295624, 
            1.3448741030886109`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8857538123878105, 
            1.344569151188368}, {-0.9467788803544154, 
            1.3422412454785895`}, {-1.0281262808013039`, 
            1.3355586529643468`}, {-1.1112560749409826`, 
            1.3252286113563134`}, {-1.1961682627734513`, 
            1.3112511206544883`}, {-1.203513542924523, 
            1.3098114416453686`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2113641683350476`, 
            1.3082727146833553`}, {-1.2392292169832024`, 
            1.30281114959642}, {-1.2826086949335922`, 
            1.2932924516709354`}, {-1.32630669662462, 
            1.2826950268780344`}, {-1.370323222056286, 
            1.271018875217717}, {-1.414658271228591, 
            1.2582639966899838`}, {-1.4593118441415338`, 
            1.2444303912948338`}, {-1.5042839407951152`, 
            1.2295180590322676`}, {-1.5197757226801627`, 
            1.2240482730590068`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.5273193246293428`, 
            1.2213848035862462`}, {-1.549574561189335, 
            1.2135269999022853`}, {-1.5980866600177088`, 
            1.1964976195062806`}, {-1.6468809715262236`, 
            1.178136015352263}, {-1.6959813892958127`, 
            1.1584677809343087`}, {-1.7453162325836753`, 
            1.1374161357701895`}, {-1.7872318212741831`, 
            1.1164079822084005`}, {-1.822146086928875, 
            1.0980812385248402`}}]}, {
           Arrowheads[{{0.012133706355525086`, 1.}}], 
           
           ArrowBox[{{-1.829229541150826, 
            1.0943630835676705`}, {-1.8292363658778996`, 
            1.094359501220414}, {-1.8712686880106384`, 
            1.0712313676353247`}, {-1.9133491804671285`, 
            1.0470366898434347`}, {-1.9554087732250673`, 
            1.0228292952980784`}, {-1.9974747369096553`, 
            0.9975299230389888}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.1984633494216794`, -0.4689410235464743}, {
            1.235224459733949, -0.44069464584551243`}, {
            1.2717882273171401`, -0.41078973999107427`}, {
            1.308094471291041, -0.3792064221153629}, {
            1.3440830107754398`, -0.3459248083505817}, {
            1.3796936648901248`, -0.3109250148289338}, {
            1.414944901753912, -0.27415150536695004`}, {
            1.4339841988269961`, -0.25308822972783934`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.4393487234188544`, -0.24715342763313167`}, {
            1.4498265898496068`, -0.23556170825958803`}, {
            1.4842356488429824`, -0.19515518635669005`}, {
            1.5180689983998128`, -0.15293150250809856`}, {
            1.5512235581858713`, -0.10889021956365647`}, {
            1.583596247866932, -0.06303090037320619}, {
            1.6150839871087679`, -0.015353107786590074`}, {
            1.6301915056823166`, 0.009164253180496946}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.6343882964077519`, 0.01597504958083823}, {
            1.6455836955771526`, 0.03414359534634895}, {1.6862510877272674`, 
            0.1062712174067905}, {1.7246256240849613`, 0.1820076777786688}, {
            1.74295307134165, 0.2212292223313965}, {1.7607073046502337`, 
            0.26135297646198336`}, {1.7776203666434236`, 
            0.3017390940125777}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.7805789743179035`, 0.30917177339141255`}, {
            1.7944961294230843`, 0.3443071134567345}, {1.8104202626285226`, 
            0.3871262841408993}, {1.825550265368197, 0.43082524004292433`}, {
            1.8398861376421074`, 0.47540398116280974`}, {1.853427879450254, 
            0.5208625075005552}, {1.8661754907926373`, 0.567200819056161}, {
            1.8779456747187355`, 0.6136948645480538}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.8797682465100973`, 0.6214843492951292}, {
            1.8892883220801115`, 0.6625167978209533}, {1.899653542025203, 
            0.7114944650301398}, {1.9091052317595731`, 0.7613191602374717}, {
            1.9175239915382651`, 0.8119581262232343}, {1.9249098213612785`, 
            0.8634113629874275}, {1.931262721228613, 0.9156788705300511}, {
            1.933370367841549, 0.9367086192212714}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.9341681484017232`, 0.9446687414676824}, {
            1.9365826911402697`, 0.9687606488511059}, {1.9408697310962475`, 
            1.0226566979505909`}, {1.9441238410965467`, 
            1.0773670178285066`}, {1.9463450211411675`, 
            1.1328916084848528`}, {1.9482270110190996`, 
            1.1804644523042338`}, {1.9492621286292773`, 
            1.2286019474439887`}, {1.949414036092916, 
            1.2641880524849192`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.9494481856194124`, 1.2721879795977022`}, {
            1.9494700588177016`, 1.2773120328420842`}, {1.9487917470463705`, 
            1.3265708916846195`}, {1.9451428987118886`, 1.379384903118944}, {
            1.9404511316182473`, 1.4327431193041973`}, {1.9346491452106804`, 
            1.48659912977361}, {1.9277593730074432`, 1.5409684046827725`}, {
            1.9213752427645676`, 1.5906969388903198`}}]}, {
           Arrowheads[{{0.011251190426277551`, 1.}}], 
           
           ArrowBox[{{1.9203565660828932`, 1.5986318174538652`}, {
            1.9203118733788536`, 1.5989799467333619`}, {1.9115167265951958`, 
            1.6574934625067108`}, {1.9013739326564696`, 
            1.7165089520028198`}, {1.8898834915626748`, 
            1.7760264152216885`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6348355201159597, 
            0.025120429282109495`}, {-0.6695425580405209, \
-0.030753659946219744`}, {-0.7009627431527365, -0.09264915185970404}, \
{-0.7283755781139551, -0.1605943769670917}, {-0.7433811586800494, \
-0.20690437784460894`}, {-0.7562773788766097, -0.2556041328969979}, \
{-0.7588116266114868, -0.2678287731490134}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7604355510203381, -0.2756622187200464}, \
{-0.7668482976952853, -0.3065958642550365}, {-0.7749140894478301, \
-0.35993668798143186`}, {-0.7802415338132572, -0.4154547174722887}, \
{-0.7826353938244824, -0.47314097181074083`}, {-0.7818703883041623, \
-0.5328576143520671}, {-0.7777560294760404, -0.5939501743820998}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7768113642447424, -0.6018934756066198}, \
{-0.7699514332451283, -0.657886443571208}, {-0.758333454094466, \
-0.7229898282876789}, {-0.7426554847028842, -0.7895722546281396}, \
{-0.722705711150301, -0.8574290146197701}, {-0.7032807812985107, \
-0.9124237780772683}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7006163892577759, -0.9199670542258174}, \
{-0.698291736310393, -0.9265484802560543}, {-0.6692056296218295, \
-0.996764559557433}, {-0.6352122770120178, -1.0676408485915208`}, \
{-0.596076564408365, -1.1387409434259324`}, {-0.559370518642241, \
-1.1977551350566487`}, {-0.5549647414555339, -1.2041358468120062`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5504191824346173, -1.2107189990347156`}, \
{-0.5188094736177055, -1.2564980822893186`}, {-0.47439342933475903`, \
-1.3149697851239424`}, {-0.4261223857934012, -1.3731702435605198`}, \
{-0.37383321191134067`, -1.4306993877184697`}, {-0.3472537653712912, \
-1.4572728682583507`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.34159627621980887`, -1.4629290875345864`}, \
{-0.31736277660628587`, -1.4871571477172105`}, {-0.2567110798782368, \
-1.5425435235567435`}, {-0.1918781217271933, -1.5968585152370673`}, \
{-0.15786833475235001`, -1.6234955193859006`}, {-0.12276256269036087`, \
-1.6496272322316812`}, {-0.0965989568904252, -1.6681478689108569`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.09006935847823785, -1.672770026910705}, \
{-0.0865608055412258, -1.675253653774408}, {-0.04926306330494483, \
-1.7003747840140822`}, {-0.010869335981517974`, -1.7249906229507033`}, {
            0.028620376429054788`, -1.7491011705842712`}, {
            0.06920607392677347, -1.7727064269147863`}, {
            0.11088775651163804`, -1.7958063919422482`}, {
            0.15991170812457145`, -1.822329586263884}, {
            0.18533147236965253`, -1.8352441813726015`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.19246376694918105`, -1.8388677671699614`}, {
            0.2104365069239499, -1.8479988770233235`}, {
            0.2650575219237089, -1.8721923280911945`}, {
            0.3212362736266889, -1.8952654695100568`}, {
            0.36786014548451856`, -1.9137556515107328`}, {
            0.41551210024798146`, -1.9313507159299905`}, {
            0.4641921379170774, -1.9480506627678291`}, {
            0.4898762554287489, -1.9562169963000642`}}]}, {
           Arrowheads[{{0.0010755695152147987`, 1.}}], 
           
           ArrowBox[{{0.4984393728882711, -1.9635568687845746`}, {
            0.5129610518883477, -1.9635568687845746`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.44415273224584095`, 
            1.8907860692055978`}, {-0.4928249357925031, 
            1.9066253033894465`}, {-0.5593590476306515, 
            1.9275463127708978`}, {-0.627768775586777, 
            1.9468598974794806`}, {-0.7018002205390765, 
            1.9629681181960774`}, {-0.7531521421195672, 
            1.9724619669398795`}}]}, {
           Arrowheads[{{0.001061809004025903, 1.}}], 
           
           ArrowBox[{{-0.7614044776958707, 
            1.9769335930340923`}, {-0.7773390234070116, 
            1.9769335930340923`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.19995194010980738`, -0.6548724846651224}, \
{-0.16006351754121692`, -0.6975126123799678}, {-0.11541781771331604`, \
-0.7389428778473095}, {-0.06565346570001912, -0.7789671986257921}, \
{-0.01090098407074493, -0.8169686807999099}, {
            0.049059025855534066`, -0.8526297832229404}, {
            0.04944300069833988, -0.8528230168696012}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.0565891168214305, -0.8564192683006477}, {
            0.11416918078715643`, -0.8853961816154758}, {
            0.18437209743246077`, -0.9147135516981092}, {
            0.25976301671536406`, -0.9400533946713073}, {
            0.3403150801873203, -0.9608665513516373}, {
            0.35671089293211633`, -0.9641841977196807}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           ArrowBox[{{0.36455197907118436`, -0.9657708193379991}, {
            0.3824513746347072, -0.9693927114397092}, {
            0.42578775549797415`, -0.9765677068838426}, {
            0.4702941562333266, -0.9823183733271307}, {
            0.5159405102969702, -0.9865715464126663}, {
            0.5627982662874201, -0.989292926443555}, {
            0.6109019582059881, -0.9904340811192621}, {
            0.6601661476130745, -0.9899006471774181}, {
            0.6829124028816214, -0.9888602928369221}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.6909040483517735, -0.9884947758340388}, {
            0.7105053960690795, -0.9875982613556548}, {
            0.7618342651344032, -0.9834325603916033}, {
            0.8140673163694463, -0.9773091810228952}, {
            0.8671191113346085, -0.9691337599871613}, {
            0.9209042115902903, -0.9588119340220335}, {
            0.9864235499574255, -0.9433836465491553}, {
            1.0061803887317449`, -0.9377884507013875}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0138776656235533`, -0.9356085588575492}, {
            1.052841280135845, -0.9245739466595402}, {
            1.1201574021255492`, -0.902382834353188}, {
            1.1883719159265378`, -0.876810309630099}, {
            1.257210749705848, -0.8476141002658959}, {
            1.3122494878464765`, -0.8213137092380264}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.3194677089442415`, -0.8178644652362512}, {
            1.3263998316305166`, -0.8145519340362015}, {
            1.395939161700544, -0.7776238109410164}, {
            1.46582873991593, -0.7368297309803398}, {
            1.5357219779205926`, -0.6919540753931532}, {
            1.59255035883607, -0.6517757717788535}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.5990826256981043`, -0.647157385735746}, {
            1.6052722873584502`, -0.6427812254184382}, {
            1.639918843864827, -0.6165833525357575}, {
            1.6744796682295022`, -0.5893111810561945}, {
            1.7089547604524764`, -0.5609647109797494}, {
            1.7433441205337492`, -0.5315439423064222}, {
            1.7996686652255203`, -0.48241618885475224`}, {
            1.843757159589517, -0.4412362281767153}}]}, {
           Arrowheads[{{0.010956446726199354`, 1.}}], 
           
           ArrowBox[{{1.8496035707075271`, -0.43577550688377176`}, {
            1.855505929350578, -0.43026252894395367`}, {
            1.911788173820643, -0.36968036103489293`}, {
            1.9670046668870091`, -0.3056700925677812}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9101075773936818, 0.44691152458683536`}, {
            0.9136764880802004, 0.4895113117390279}, {0.9157729150623447, 
            0.5331405515783154}, {0.9163280810840954, 0.5777611487673652}, {
            0.9152732088894326, 0.6233350079688447}, {0.9125664840453235, 
            0.6699297214823551}, {0.908156287455831, 0.7175744497395216}, {
            0.9019784772870804, 0.7660217634703677}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9006958028898401, 0.7739181732787441}, {
            0.893891542039191, 0.8156309779276362}, {0.8838700247112918, 
            0.8658512915799909}, {0.871811098636505, 0.9167386474188148}, {
            0.8576312795644546, 0.9681973023048113}, {0.8412470832447649, 
            1.0201315130986834`}, {0.8186276810102674, 1.082554534029101}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8156297192046174, 1.0899701585057953`}, {
            0.7913931739920318, 1.148423625006472}, {0.7611402096691926, 
            1.213332499871011}, {0.727336572215372, 1.2787499206759803`}, {
            0.6897656952045883, 1.344362672131698}, {0.6705514771942589, 
            1.3746464466407018`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6662655704331583, 1.3814015190485411`}, {
            0.6482110122108603, 1.4098575389484829`}, {0.6026725232341883, 
            1.4752345211263354`}, {0.5531502282745718, 1.5404936186652547`}, {
            0.4994644014392725, 1.6052491468610184`}, {0.472169779389964, 
            1.6352893556025827`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{0.4667899791169158, 1.641210314057268}, {
            0.4414353168355516, 1.6691154210094028`}, {0.4107920528705331, 
            1.7007150878158281`}, {0.3790629744634092, 1.7320924411104088`}, {
            0.34624808161417986`, 1.7632474808931444`}, {0.3123473743228452, 
            1.7941802071640356`}, {0.2660548613573564, 1.8356046606247856`}, {
            0.23520014328213423`, 1.8616742857668684`}}]}, {
           Arrowheads[{{0.009407691314252755, 1.}}], 
           
           ArrowBox[{{0.22908932269404553`, 1.866837411926492}, {
            0.21772781631555096`, 1.876436923145964}, {0.1639388857972109, 
            1.916730405630353}, {0.1079480501475592, 
            1.9560917458337015`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7079539738495673, 
            0.184215634333539}, {-0.7514351265149525, 
            0.14001451578246404`}, {-0.7936420560999732, 
            0.09058664783376041}, {-0.8339493480926871, 
            0.03604410967523495}, {-0.8720423397155612, \
-0.023843137235593878`}, {-0.8978627248275614, -0.07150313347012383}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9016735096347753, -0.07853718771736327}, \
{-0.907360568663436, -0.08903452192503734}, {-0.9393435726311516, \
-0.15948947341940684`}, {-0.9674617983337442, -0.2353198675820864}, \
{-0.9911609652700932, -0.3165156228068016}, {-1.0011666663479906`, \
-0.3590556648242424}, {-1.0053499955070935`, -0.38017157161434545`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0069046810363056`, -0.3880190522868453}, \
{-1.009843520310804, -0.402853231915376}, {-1.0171168330173592`, \
-0.44788038568293015`}, {-1.0229119103264819`, -0.49410918772963286`}, \
{-1.0271965062956196`, -0.541612253680589}, {-1.029922939273631, \
-0.5904256340618572}, {-1.0309933615564564`, -0.6404665428275962}, \
{-1.0303099254400363`, -0.6916521939319646}, {-1.0295903142351743`, \
-0.7064829057625301}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0292025968573264`, -0.7144735049412473}, \
{-1.0277747832203123`, -0.7438998013291213}, {-1.023290087193225, \
-0.7971265789732246}, {-1.016757989654715, -0.8512497408184331}, \
{-1.0080806429007232`, -0.9061865008189054}, {-0.99465100988392, \
-0.9730907936206066}, {-0.9805406491553401, -1.0301222861787978`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.9786192747727865, -1.037888129370755}, \
{-0.9778458006550359, -1.041014370027459}, {-0.9576650152140708, \
-1.1099572300394631`}, {-0.9341086535610249, -1.1799193736566187`}, \
{-0.9069247424517592, -1.2506346429185577`}, {-0.8758613086421349, \
-1.321836879864913}, {-0.868115443869916, -1.3377283481366153`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.8646102741625113, -1.3449195778869636`}, \
{-0.8409183521321517, -1.3935260844956838`}, {-0.80209587292181, \
-1.4657022568108706`}, {-0.7591660123846221, -1.538026047618831}, \
{-0.7119009118941004, -1.6101581077279215`}, {-0.7040724318168051, \
-1.6213140337277734`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.6994771201884811, -1.6278625534871227`}, \
{-0.6866426466663397, -1.646152238770391}, {-0.6603005714502456, \
-1.6820984371381433`}, {-0.6328746862458179, -1.7179967028311782`}, \
{-0.6043649910530569, -1.7538470358494955`}, {-0.5546304303958897, \
-1.815179581917709}, {-0.5015603777975167, -1.8760972020336768`}, \
{-0.499902283563457, -1.8777702375076362`}}]}, {
           Arrowheads[{{0.01046041788345012, 1.}}], 
           
           ArrowBox[{{-0.49427085885951755`, -1.8834524074983932`}, \
{-0.4708244920812219, -1.907110051647789}, {-0.4391429970861797, \
-1.9379004968606595`}, {-0.40649883866682746`, -1.9684031310461323`}, \
{-0.37289770153835283`, -1.998639756412927}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.4095218142979939, 
            0.7313746807832759}, {-0.47951027125301093`, 
            0.7322540566476611}, {-0.5525593732953709, 
            0.7281017961458682}, {-0.6283215966591496, 
            0.718503313067167}, {-0.706449417578423, 
            0.7030440212008264}, {-0.7265717333900064, 
            0.6976661818318669}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7343004749116, 
            0.6956006178671361}, {-0.7781963622735188, 
            0.6838691137301001}, {-0.851448689843926, 
            0.6593305559761161}, {-0.9258453986683886, 
            0.6291640009937003}, {-1.0010254871256499`, 
            0.5931051018376787}, {-1.030659930818816, 0.5771641201538514}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0377052894810062`, 
            0.573374275655577}, {-1.0388289785932878`, 
            0.5727698199842418}, {-1.0767461095339086`, 
            0.550840075963034}, {-1.1147140313539374`, 
            0.5272902417458848}, {-1.1526698954597994`, 
            0.5020946893046235}, {-1.190550853257919, 
            0.4752277906110803}, {-1.2282940561547206`, 
            0.44666391763708496`}, {-1.2658366555566296`, 
            0.41637744235446705`}, {-1.2982035557331315`, 
            0.3885639274623692}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3042395366821344`, 
            0.3833144203068637}, {-1.340092200654573, 
            0.3505060425918547}, {-1.3767179874139919`, 
            0.3148238308865298}, {-1.4129174684712398`, 
            0.2772858173139078}, {-1.4486149491492308`, 
            0.23788171756881496`}, {-1.4837347347708778`, 
            0.19660124734607792`}, {-1.5182011306590937`, 
            0.15343412234052298`}, {-1.5215045653779173`, 
            0.14902161324072938`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.5262990394978702`, 
            0.14261747255574259`}, {-1.5519384421367923`, 
            0.10837005824697642`}, {-1.5848709745268863`, 
            0.06139877076026498}, {-1.6170059130938763`, 
            
            0.01245076198813907}, {-1.6483203049416857`, \
-0.0385219337481689}, {-1.6786932481523615`, -0.09149730243360887}, \
{-1.697710376201767, -0.1271535522613586}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.7014751532096706`, -0.13421233785668302`}, \
{-1.7080038408079514`, -0.14645333005313138`}, {-1.7361311809905033`, \
-0.20336800259168686`}, {-1.762954366782064, -0.2622193060342256}, \
{-1.788352496264681, -0.322985226365698}, {-1.8122046675204022`, \
-0.3856437495710544}, {-1.8270348154094904`, -0.4280608002665625}, \
{-1.8270736032348545`, -0.42818011696798347`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.829546862611376, -0.43578820398486545`}, \
{-1.8410923662322494`, -0.4713037657715421}, {-1.8543773199886793`, \
-0.5153726460859934}, {-1.8668896766787801`, -0.5602674412099166}, \
{-1.8786294363025524`, -0.6059881511433115}, {-1.889596598859995, \
-0.6525347758861778}, {-1.899791164351109, -0.6999073154385159}, \
{-1.9087197836031558`, -0.7455820224776228}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.9101453381308455`, -0.7534536135663233}, \
{-1.91775321312667, -0.7970982103848091}, {-1.9253021143957587`, \
-0.8468527086051678}, {-1.9318598365831596`, -0.8973692644614015}, \
{-1.9374263796888727`, -0.9486478779535105}, {-1.942001743712898, \
-1.0006885490814947`}, {-1.9455859286552357`, -1.0534912778453545`}, \
{-1.9464411545889595`, -1.0711580309979913`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.9468279718435817`, -1.0791486738013911`}, \
{-1.948178934515885, -1.1070560642450888`}, {-1.9497807612948472`, \
-1.1613829082806988`}, {-1.9502772550377214`, -1.2164171079128756`}, \
{-1.949554261790108, -1.272103961102311}, {-1.9476117815520066`, \
-1.328443467849005}, {-1.9444498143234172`, -1.3854356281529572`}, \
{-1.9434244854084075`, -1.3989254175007304`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.9428181720529707`, -1.406902408419305}, \
{-1.9400683601043407`, -1.4430804420141685`}, {-1.9344674188947761`, \
-1.5013779094326383`}, {-1.9276469906947231`, -1.5603280304083662`}, \
{-1.919607075504183, -1.619930804941353}, {-1.9119292494705962`, \
-1.6771103998607446`}, {-1.9046138995827744`, -1.7245223539547372`}}]}, {
           Arrowheads[{{0.017187716210955523`, 1.}}], 
           
           ArrowBox[{{-1.9033939881379836`, -1.732428795383526}, \
{-1.9030235146967993`, -1.734829893082996}, {-1.8929157101927134`, \
-1.7931052329727357`}, {-1.881528318928574, -1.8518885744360758`}, \
{-1.865344274238038, -1.9148504435533433`}, {-1.8476472864882723`, \
-1.9782766259468618`}, {-1.84107800874874, -2.}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5246428301814645, -0.7244543647477795}, \
{-0.49623221340290835`, -0.7882727689351414}, {-0.46241332135512236`, \
-0.8526518988572904}, {-0.4229618480655609, -0.9172083326859367}, \
{-0.3775883625630912, -0.9816765481945106}, {-0.36320993524789524`, \
-0.9995391257562541}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3581935994373143, -1.0057710095032029`}, \
{-0.3260555338754497, -1.045696703475067}, {-0.2979336920952388, \
-1.0773747268578533`}, {-0.2682172060283941, -1.1087438971772525`}, \
{-0.23688780617813524`, -1.1397386017644713`}, {-0.20392722304768215`, \
-1.1702932279507146`}, {-0.169284795195956, -1.2003628645699056`}, \
{-0.13292164007071433`, -1.2298950726367968`}, {-0.13177064256070117`, \
-1.2307690349212046`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.12539922337695858`, -1.2356069081714083`}, \
{-0.09483715650843029, -1.2588129477538392`}, {-0.05503074334557694, \
-1.2870395855234849`}, {-0.013501799418627653`, -1.3144980815481853`}, {
            0.029750276435944183`, -1.3411115314303912`}, {
            0.0747260853816655, -1.3668030307725545`}, {
            0.12142622858206321`, -1.3914956751771266`}, {
            0.1462566873985234, -1.403625520600759}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.15344484595449, -1.407136984195086}, {
            0.16992283568668154`, -1.415186592533825}, {
            0.22026202598651276`, -1.437845989900634}, {
            0.272405385107256, -1.459356581632405}, {
            0.3263144986746105, -1.4796010820839904`}, {
            0.3819509523142749, -1.4984622056102417`}, {
            0.4392763316519485, -1.5158226665660106`}, {
            0.4526316853463518, -1.51938762884679}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.46036105533536137`, -1.52145083983285}, {
            0.49825222231333033`, -1.5315651793061487`}, {
            0.558840209924119, -1.5455724581855077`}, {
            0.638023677338742, -1.5606249697166426`}, {
            0.7197598537083265, -1.5725271488679067`}, {
            0.7748600011426487, -1.5782482833397835`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.7828172227541684, -1.579074494102945}, {
            0.8040487390328718, -1.5812789956392994`}, {
            0.8908903333123783, -1.5868805100308205`}, {
            0.9352263347926928, -1.5884063250903784`}, {
            0.9801163904766494, -1.588957422067466}, {
            1.0255605003642478`, -1.5885338009620835`}, {
            1.071558664455488, -1.5871354617742304`}, {
            1.1024296736267163`, -1.5855617736571157`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.1104192995306754`, -1.5851544925321122`}, {
            1.1181108827503703`, -1.5847624045039075`}, {
            1.1652171552488944`, -1.5814146291511142`}, {
            1.2128774819510606`, -1.5770921357158507`}, {
            1.2610918628568686`, -1.571794924198117}, {
            1.3097970947005189`, -1.5654279418949926`}, {
            1.3589299742162118`, -1.5578961361035568`}, {
            1.4084905014039468`, -1.5491995068238096`}, {
            1.4276891750288068`, -1.545412074822301}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.4355379054544861`, -1.54386371094226}, {
            1.4584786762637247`, -1.539338054055751}, {
            1.5088944987955453`, -1.5283117777993815`}, {
            1.559737968999408, -1.5161206780547003`}, {
            1.6110090868753135`, -1.5027647548217078`}, {
            1.6627078524232615`, -1.488244008100404}, {
            1.7165835629580741`, -1.4731975736148997`}, {
            1.7454000977305426`, -1.4644804099891797`}}]}, {
           Arrowheads[{{0.016538589520995052`, 1.}}], 
           
           ArrowBox[{{1.7530574071666214`, -1.4621640308751012`}, {
            1.770844399985108, -1.4567833656413205`}, {
            1.8255126313863257`, -1.4390284825881614`}, {
            1.8805214535158388`, -1.4198516292299377`}, {
            1.929567659578057, -1.3993733453146926`}, {
            1.9787962540050201`, -1.377722948307429}, {
            2., -1.3678946800805172`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.36885036528033843`, -0.6799526884465279}, \
{-0.3357074039736851, -0.7339979569254138}, {-0.29739021237483365`, \
-0.7878888574069735}, {-0.25372969468729667`, -0.8412144680093726}, \
{-0.2044700633165373, -0.8936779160972936}, {-0.16816125937216345`, \
-0.9274590592264577}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.16230420886642222`, -0.9329083673819207}, \
{-0.14942488410645824`, -0.9448910896382056}, {-0.0885290914182317, \
-0.9943062076544548}, {-0.02171761961302992, -1.0413754891683873`}, {
            0.013964269003208789`, -1.0638751599020955`}, {
            0.0512107425212055, -1.085608972186449}, {
            0.09000951230982908, -1.1064997805516266`}, {
            0.10155779137591685`, -1.1122170272728875`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.10872728136206697`, -1.1157664516400903`}, {
            0.13034828973794826`, -1.126470439527806}, {
            0.17221478617443206`, -1.1454438036451662`}, {
            0.21559671298814947`, -1.163342727433885}, {
            0.26048178154796925`, -1.180090065424141}, {
            0.30685770322276024`, -1.1956086721461128`}, {
            0.3547982957262879, -1.2098822707219488`}, {
            0.40434606537417345`, -1.2228724502403547`}, {
            0.40915002731818556`, -1.2239627326124995`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.4169516257819634, -1.225733343075018}, {
            0.4554417564380694, -1.2344688641813428`}, {
            0.5080261131896284, -1.2445611660249254`}, {
            0.562039879900503, -1.2530390092511152`}, {
            0.6174238008423457, -1.259792047339925}, {
            0.6741186202868091, -1.2647099337713663`}, {
            0.7320650825055457, -1.2676823220254527`}, {
            0.7336524178503778, -1.2676995733982839`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7416519454269034, -1.2677865133339088`}, {
            0.8045201652108163, -1.2684697735550379`}, {
            0.8787503585317006, -1.266033810548022}, {
            0.9547556624681987, -1.2603744330044049`}, {
            1.032536077020311, -1.251491640924187}, {
            1.0605513318282074`, -1.2471075699123368`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.0684551401128342`, -1.2458707131704847`}, {
            1.1118790300152728`, -1.2390753647701769`}, {
            1.1925719492803202`, -1.2228155350051835`}, {
            1.2746148348154531`, -1.202712151629207}, {
            1.3580076866206714`, -1.1787652146422471`}, {
            1.3794357517913207`, -1.1719038704824003`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.3870546945014441`, -1.1694642574024514`}, {
            1.4001377307300562`, -1.165275021766599}, {
            1.44246002811795, -1.1506731569321058`}, {
            1.4849745787843522`, -1.1349596201387677`}, {
            1.5276813827292632`, -1.1181344113865843`}, {
            1.5705804399526833`, -1.1001975306755565`}, {
            1.6136717504546119`, -1.081148978005683}, {
            1.656955314235049, -1.060988753376965}, {
            1.6829190922153159`, -1.048285166933268}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.6901050545893115`, -1.0447692111941382`}, {
            1.700431131293995, -1.039716856789402}, {
            1.7452945505899378`, -1.0178431844217002`}, {
            1.790275809121237, -0.9947084079177254}, {
            1.8353987629896222`, -0.9703326856622541}, {
            1.880591843889905, -0.9446555425009574}, {
            1.9182881201099193`, -0.9202177566475669}, {
            1.9559607131490675`, -0.8948308960297726}, {
            1.9677451842462856`, -0.8865664256674045}}]}, {
           Arrowheads[{{0.001968565012714467, 1.}}], 
           
           ArrowBox[{{1.9742950314435141`, -0.881973006277347}, {
            1.9935536411410546`, -0.8684669093339459}, {
            2., -0.8637724963777066}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7322409946830741, 
            0.5314500135943555}, {-0.7966988213660416, 
            0.5028401807846444}, {-0.8617280417155504, 
            0.46878192067472557`}, {-0.9269434353498439, 
            0.42904914497787755`}, {-0.9920781327141943, 
            0.38335063611735853`}, {-1.007784971067574, 
            0.3707488933440055}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0140248861196313`, 
            0.36574255135178135`}, {-1.056770583592251, 
            0.33144727994844286`}, {-1.0887862036694846`, 
            0.30312255501749347`}, {-1.1204935466098238`, 
            0.2731911433324335}, {-1.1518267072414945`, 
            0.24163455325092587`}, {-1.1827197803927232`, 
            0.2084342931306334}, {-1.2131277123659263`, 
            0.17353942842358175`}, {-1.2401399580388823`, 
            0.14041536449359787`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.2451068072299578`, 
            0.13414530159412907`}, {-1.2722529659196031`, 
            0.0985476783539832}, {-1.3008157300937762`, 
            0.058449201967457426`}, {-1.328608880928638, 
            0.016614597330461205`}, {-1.3555551397210388`, \
-0.026956931068995122`}, {-1.3815772277678278`, -0.07226617874290092}, \
{-1.406597866365855, -0.11931394120324573`}, {-1.4149830372892402`, \
-0.13637255992182112`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.4185121325373682`, -0.14355207848016754`}, \
{-1.4306143525520747`, -0.16817258517770353`}, {-1.453596864912495, \
-0.21888845149733577`}, {-1.4754274470675437`, -0.2714232968292131}, \
{-1.49598814263765, -0.32573887784040634`}, {-1.5151609952432423`, \
-0.38179695119798623`}, {-1.5328280485047496`, -0.4395592735690235}, \
{-1.5334193350759298`, -0.44174954475496114`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5355043771051415`, -0.44947305430285583`}, \
{-1.5488713460426, -0.4989876016205888}, {-1.5631729314772225`, \
-0.5600436920197527}, {-1.5785995984036434`, -0.6399099283091405}, \
{-1.5908584229273957`, -0.72235898521926}, {-1.595663199730135, \
-0.7633848957115102}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.596457892507677, -0.7713451248666771}, \
{-1.5999494050484793`, -0.8073908627501111}, {-1.6033069552080201`, \
-0.8508753592483109}, {-1.6058725447668938`, -0.8950055609016935}, \
{-1.6075518297262865`, -0.9397394120271213}, {-1.608250466087384, \
-0.9850348569414564}, {-1.607968453850187, -1.030891895644699}, \
{-1.6067057930146948`, -1.0773105281368491`}, {-1.6060567965193264`, \
-1.0909020557918383`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.6056752306521325`, -1.098892951078913}, \
{-1.6044624835809076`, -1.1242907544179066`}, {-1.601238525548826, \
-1.1718325744878717`}, {-1.597033918918449, -1.219935988346744}, \
{-1.591848663689777, -1.2686009959945235`}, {-1.5855868530904043`, \
-1.3177642876407567`}, {-1.5781525803479244`, -1.3673625534949896`}, \
{-1.5696790875531517`, -1.4166212218288339`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5681735086884008`, -1.4244781118860919`}, \
{-1.5597666484336432`, -1.4678640078274539`}, {-1.5488149892618424`, \
-1.5187671963056855`}, {-1.5366908679469347`, -1.5701053589919172`}, \
{-1.5233942844889192`, -1.6218784958861479`}, {-1.5089252388877972`, \
-1.6740866069883784`}, {-1.4939693177714743`, -1.7283562526145062`}, \
{-1.4919469181761353`, -1.735127376662633}}]}, {
           Arrowheads[{{0.017152360877353147`, 1.}}], 
           
           ArrowBox[{{-1.4896574193604308`, -1.742792766096503}, \
{-1.4776432985087051`, -1.7830168161822073`}, {-1.459974327854901, \
-1.8380904575718229`}, {-1.4408809655438264`, -1.8935106971423272`}, \
{-1.415933587438491, -1.9529042902645508`}, {-1.3948932735805373`, -2.}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7419095926291199, 
            0.35153556385793727`}, {-0.7969840799911198, 
            0.31350036618276395`}, {-0.8515641955754385, 
            0.27007510231780146`}, {-0.905355303632187, 
            0.22099977370985457`}, {-0.9579708708187487, 
            0.16608211978892065`}, {-0.9800769320208265, 
            0.13965801194137514`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.9852101794850845, 
            0.13352207106236658`}, {-1.0088635430052344`, 
            0.10524842145558384`}, {-1.0574859660617555`, 
            0.038424959610428175`}, {-1.0807912713589896`, 
            0.0027069858149942876`}, {-1.10335073261588, \
-0.03459669152725903}, {-1.1250869385525715`, -0.07347508130156406}, \
{-1.1459224778892099`, -0.11391719239315314`}, {-1.1562745995226047`, \
-0.1358100061346773}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1596943901664782`, -0.14304222791999852`}, \
{-1.16577993934594, -0.1559120336872587}, {-1.1845819116429077`, \
-0.19944861406911324`}, {-1.2022509835002575`, -0.244515942423949}, \
{-1.218709743638135, -0.2911030276369987}, {-1.233943247352276, \
-0.33928375972837804`}, {-1.2479138348200196`, -0.38910116285097257`}, \
{-1.2605100220839165`, -0.4404979470891692}, {-1.2616064067007, \
-0.44572007653353485`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2632501675456338`, -0.4535493836730372}, \
{-1.2716203251865166`, -0.49341682252735464`}, {-1.2811332601703709`, \
-0.5478004992499158}, {-1.2889373430780293`, -0.6035916873412395}, \
{-1.2949210899520422`, -0.6607330968857125}, {-1.2989730168349605`, \
-0.7191674379677219}, {-1.3004705534712644`, -0.77083682193184}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.3007023205935238`, -0.7788334639771638}, \
{-1.3010985049679495`, -0.7925029810136921}, {-1.299999250241105, \
-0.8676917443140211}, {-1.2956752526544273`, -0.9447337278687089}, \
{-1.2881265122079162`, -1.023628931677756}, {-1.2779353172962975`, \
-1.0976397680851577`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2767834419976904`, -1.1055552960197634`}, \
{-1.2620878696728974`, -1.186144270069344}, {-1.253166828169717, \
-1.227670514204471}, {-1.243281234318766, -1.26955572215449}, \
{-1.2324310881200444`, -1.3117998939194002`}, {-1.2206163895735527`, \
-1.3544030294992029`}, {-1.2077597366704358`, -1.3972932990812685`}, \
{-1.2016004593726026`, -1.4162900796957945`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.1991330890060197`, -1.4239000786099933`}, \
{-1.1937837274018392`, -1.440398872852969}, {-1.1786883617677626`, \
-1.4837197508143039`}, {-1.1624736397682063`, -1.5272559329652728`}, \
{-1.1451395614031703`, -1.5710074193058772`}, {-1.1266861266726544`, \
-1.6149742098361155`}, {-1.1071133355766585`, -1.659156304555988}, \
{-1.0864211881151828`, -1.7035537034654955`}, {-1.078725746769397, \
-1.7201281866235647`}}]}, {
           Arrowheads[{{0.019603771299968233`, 1.}}], 
           
           ArrowBox[{{-1.0753568038822487`, -1.7273842340202632`}, \
{-1.0650079725530035`, -1.7496736028640922`}, {-1.0423060423821207`, \
-1.7959385575379054`}, {-1.0183366064499846`, -1.8423727103615122`}, \
{-0.9930360382142426, -1.8889036327111792`}, {-0.9688362551851417, \
-1.9277788125122846`}, {-0.9436637907173602, -1.9666475607403935`}, \
{-0.9211667277348056, -2.}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8176099746631297, -0.15004864841849483`}, {
            0.86280954231026, -0.09688958682113745}, {
            0.9061317047872006, -0.03815419487464617}, {0.9470124748254167, 
            0.02615706942244042}, {0.9848878651563733, 0.09604374807158371}, {
            0.993798304537681, 0.11565831506018598`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.997107105256963, 0.1229419843140771}, {
            1.0192359076653204`, 0.1716541587245564}, {1.0495010189144804`, 
            0.25301759851288236`}, {1.0629104721125537`, 
            0.29580077033939284`}, {1.0750687886507762`, 
            0.33995507865764935`}, {1.0858991672475138`, 
            0.38545814987028815`}, {1.0942417511208247`, 
            0.4269066592559992}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0957354291443562`, 0.4347649447821601}, {
            1.1033190080944812`, 0.4805175763658286}, {1.109836853861511, 
            0.5301870768156659}, {1.1147742139472305`, 0.581221107344872}, {
            1.1180269583766476`, 0.6335446635688615}, {1.1194909571747722`, 
            0.6870827411030495}, {1.1190620803666127`, 0.7417603355628498}, {
            1.1185580084569666`, 0.7533429376073616}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.1182101797141146`, 0.7613353724782659}, {
            1.116636197977179, 0.797502442563678}, {1.1121091800314795`, 
            0.8542340577209484}, {1.103692380384142, 0.9236688882641577}, {
            1.0919396784439264`, 0.9944028081633012}, {1.076851074210833, 
            1.0664358174183786`}, {1.0740138159714498`, 
            1.0777284998412189`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.0720644224886215`, 1.0854873570411618`}, {
            1.0584265676848614`, 1.1397679160293896`}, {1.0363924153073683`, 
            1.214152275428679}, {1.0104748735197093`, 1.2893420670485916`}, {
            0.9806739423218851, 1.3653372908891268`}, {0.9705149842562328, 
            1.388499837446614}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9673017065093878, 1.3958261493510875`}, {
            0.9469896217138953, 1.4421379469502849`}, {0.9286273322579163, 
            1.4807598986651465`}, {0.9091664792030515, 1.519422381638262}, {
            0.888607062549301, 1.5581253958696313`}, {0.8669490822966648, 
            1.5968689413592543`}, {0.8441925384451431, 1.6356530181071314`}, {
            0.8203374309947356, 1.6744776261132617`}, {0.8178333957700434, 
            1.6783776405655777`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.813511142637922, 1.6851095145886017`}, {
            0.7953837599454425, 1.7133427653776463`}, {0.7693315252972637, 
            1.7522484359002846`}, {0.7449822041685441, 1.7886413074971945`}, {
            0.7196196548008186, 1.8249916985161438`}, {0.6932560536003869, 
            1.8613189677616102`}, {0.6658548713483495, 1.8975650388201617`}, {
            0.6259518262148083, 1.943955415962597}}]}, {
           Arrowheads[{{0.004224200600773901, 1.}}], 
           
           ArrowBox[{{0.6207349618963762, 1.950020424345367}, {
            0.6123160766979199, 1.9598080297315776`}, {0.5752462210031791, 
            2.}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6735083506715045, -0.5747818117258724}, {
            0.7381465423665716, -0.5520041047398089}, {
            0.803821991541606, -0.5239845022629237}, {
            0.8701530102103159, -0.490490995985923}, {
            0.9367579103864104, -0.45129157759951294`}, {
            0.9603179955291645, -0.43530556801952586`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9669379572150737, -0.43081378582566404`}, {
            1.0033734822255962`, -0.40609152152394923`}, {
            1.069641733369981, -0.35464627599584836`}, {
            1.1024819068826577`, -0.3265327235668611}, {
            1.1350388020628757`, -0.2967990934304567}, {
            1.1672469361910491`, -0.26542579213854134`}, {
            1.1990408265475911`, -0.2323932262430208}, {
            1.2083796634380934`, -0.2220387805199238}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.2137376658274428`, -0.21609808944937253`}, {
            1.2303762979870445`, -0.19764998765434186`}, {
            1.2612014271551775`, -0.16115623724348202`}, {
            1.291439109019243, -0.12290973500314288`}, {
            1.3210122385464937`, -0.0829082409260259}, {
            1.3498437107041823`, -0.04114951500483293}, {1.3778564204595616`, 
            0.002368682767734178}, {1.4016884819855178`, 
            0.04216364043552635}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4057537291704005`, 0.04905298099889411}, {
            1.4311171326324035`, 0.09469245389618478}, {1.4562868318775948`, 
            0.1435722852413285}, {1.4804535598693074`, 
            0.19433473060739823`}, {1.503498807814854, 
            0.24694396928823953`}, {1.5253040669215476`, 
            0.30136418057769815`}, {1.539160033070576, 
            0.33944556823734223`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.5418954053203169`, 0.3469633962917305}, {
            1.5457508283967014`, 0.3575595437696191}, {1.5647205834476285`, 
            0.41549423815784814`}, {1.5820948232816414`, 
            0.47513244303623076`}, {1.5977550391060529`, 0.536438337698612}, {
            1.6150294938905536`, 0.6171162994914439}, {1.6216857539166276`, 
            0.6564210916109958}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.623021533337115, 0.6643087841341487}, {
            1.629146515224792, 0.7004764126354582}, {1.6350209883480629`, 
            0.7431622759641588}, {1.640106103108768, 0.7865186771306552}, {
            1.6444018595069076`, 0.8305456161349469}, {1.6479082575424817`, 
            0.8752430929770345}, {1.65052889621257, 0.9205704529630464}, {
            1.6521673745142524`, 0.966487041399111}, {1.652395354150014, 
            0.982641375536482}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.6525082436987288`, 0.990640578993689}, {
            1.6528236924475286`, 1.0129928582852288`}, {1.6524978500123992`, 
            1.0600879036213993`}, {1.6511898472088635`, 
            1.1077721774076228`}, {1.648899684036922, 1.1560456796438991`}, {
            1.6456273604965743`, 1.2049084103302283`}, {1.6413728765878208`, 
            1.2543603694666106`}, {1.636037810913641, 1.3043394373097699`}, {
            1.635314274407868, 1.3099424049041088`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.6342897056758472`, 1.3178765248246398`}, {
            1.6295237420770148`, 1.35478349411643}, {1.6218306700779421`, 
            1.4056925398865914`}, {1.6129585949164227`, 
            1.4570665746202536`}, {1.6029075165924571`, 
            1.5089055983174169`}, {1.591677435106045, 1.5612096109780813`}, {
            1.5792683504571863`, 1.6139786126022466`}, {1.5746542631088614`, 
            1.632055201882678}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.5726756850822943`, 1.6398066681306072`}, {
            1.565680262645881, 1.667212603189913}, {1.551741896910234, 
            1.7221310771953924`}, {1.5364441786043337`, 1.777467640743715}, {
            1.519814418895738, 1.833243693785442}, {1.5017706842817717`, 
            1.8893950364688883`}, {1.479556696054019, 
            1.9456283351478114`}}]}, {
           Arrowheads[{{0.003184709239284814, 1.}}], 
           
           ArrowBox[{{1.4719025727170518`, 1.9889843328175179`}, {
            1.4614056641982784`, 1.9889843328175179`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.34350825614315583`, -1.357909975991295}, \
{-0.29085707341443673`, -1.4100513222552096`}, {-0.2343597398342384, \
-1.4609925551212752`}, {-0.17401625540256094`, -1.5107336745894917`}, \
{-0.1098266201194043, -1.559274680659859}, {-0.10064477173801731`, \
-1.56559849471408}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.0940562217739764, -1.5701362264570697`}, \
{-0.04172183607345983, -1.606180485746173}, {
            0.030367094646581286`, -1.6510160022622289`}, {
            0.06790561500938802, -1.67265740230641}, {
            0.10644017204071898`, -1.6937812302080268`}, {
            0.14597076574057402`, -1.7143874859670791`}, {
            0.18154623090803584`, -1.7320219218370825`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.18873775867976747`, -1.7355255224163886`}, {
            0.22801801801673405`, -1.753923817382656}, {
            0.2705305863347943, -1.7726069656895123`}, {
            0.3140351010631339, -1.7905256145041362`}, {
            0.3585315622017527, -1.8076797638265267`}, {
            0.4040199697506509, -1.8240694136566855`}, {
            0.4505003237098284, -1.839694563994611}, {
            0.486823712299905, -1.8510651778298075`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4944583810517831, -1.8534551219816857`}, {
            0.4979726240792852, -1.854555214840304}, {
            0.5464368708590214, -1.8686513661937643`}, {
            0.6153441413221503, -1.8879524953033537`}, {
            0.6861935542655765, -1.9054799232952404`}, {
            0.7630076104646099, -1.9193970658911288`}, {
            0.8057800247413268, -1.9257094368539092`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8136943025733266, -1.9268774293187463`}, {
            0.8417696186469985, -1.931020796321782}, {
            0.8935676107798745, -1.9380573716118112`}, {
            0.9461445071580696, -1.9439933093903499`}, {
            0.999500307781584, -1.9488286096573975`}, {
            1.0536350126504175`, -1.9525632724129542`}, {
            1.1085486217645708`, -1.955197297657021}, {
            1.132161020137265, -1.9558474202644833`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.1401579895730494`, -1.9560676016513685`}, {
            1.1642411351240431`, -1.956730685389597}, {
            1.2207125527288345`, -1.9571634356106817`}, {
            1.2779628745789453`, -1.9564955483202762`}, {
            1.335926974469442, -1.954603260699378}, {
            1.3945397261953911`, -1.9513628099289853`}, {
            1.4538011297567919`, -1.9467741960090974`}, {
            1.4598160791831298`, -1.946178145586656}}]}, {
           Arrowheads[{{0.018446678555855942`, 1.}}], 
           
           ArrowBox[{{1.4677770869751512`, -1.9453892508310802`}, {
            1.5137111851536458`, -1.9408374189397155`}, {
            1.5742698923859517`, -1.9335524787208387`}, {
            1.63547725145371, -1.9249193753524676`}, {
            1.6973332623569202`, -1.9149381088346014`}, {
            1.7598379250955831`, -1.9036086791672409`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8084361648434476, -0.3547916798250654}, {
            0.8657299593291552, -0.31276224267604424`}, {
            0.9224532888150146, -0.2650186274567206}, {
            0.9782288496611342, -0.21135464337998083`}, {
            1.0325169804131367`, -0.15167376435607563`}, {
            1.042918480317238, -0.13857874335758197`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.0478942745602697`, -0.1323144419878351}, {
            1.0847780196166446`, -0.08587946429525575}, {
            1.1099975971604792`, -0.050624032784096745`}, {
            1.1345372566436775`, -0.013745820057374038`}, {
            1.1583197977604827`, 0.02474783008857133}, {1.1812680202051378`, 
            0.06484957385739834}, {1.2033047236718861`, 
            0.10655206745276596`}, {1.2183610207088234`, 
            0.13752301077796222`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.2218587460160837`, 0.14471786433275755`}, {
            1.2243527078549714`, 0.14984796707833317`}, {1.2443347724486367`, 
            0.19472992893775892`}, {1.2631737171471251`, 
            0.24119060923470223`}, {1.280858407869713, 0.2893033821515461}, {
            1.297353686453847, 0.3391122698784104}, {1.312546316471024, 
            0.390565900630559}, {1.326323061492743, 0.443612902623256}, {
            1.3269461286082078`, 0.446389981082366}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.3286974755600842`, 0.45419592649942814`}, {
            1.3385706850905015`, 0.49820190407176534`}, {1.3491759508357983`, 
            0.5542815331913512}, {1.358025622300131, 0.6118004181972773}, {
            1.3650064630549974`, 0.6707071873048076}, {1.3708464929281474`, 
            0.7454701419600324}, {1.371718845406453, 0.7707761849327887}}]}, {
          
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.3719944585068562`, 0.7787714358618644}, {
            1.3734943739084642`, 0.8222824300443101}, {1.372950105995948, 
            0.901144051557641}, {1.3692136891905988`, 0.9820550065000253}, {
            1.3619527091906365`, 1.0648190763743683`}, {1.3575759622412478`, 
            1.0980526273102647`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.3565314085636389`, 1.1059841408867892`}, {
            1.3508347516942805`, 1.1492400426835752`}, {1.343829406384955, 
            1.1920718620012527`}, {1.335859816701531, 1.2353179054276462`}, {
            1.326925982644009, 1.2789781729627558`}, {1.3170279042123882`, 
            1.3230526646065814`}, {1.3060833045042215`, 
            1.3674722808669624`}, {1.294009906617061, 1.4121679222517374`}, {
            1.2919782680717804`, 1.4190884505235273`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.2897248282263563`, 1.426764517801962}, {
            1.2808077105509068`, 1.457139588760907}, {1.2664767163057584`, 
            1.5023872803944707`}, {1.251016923881617, 1.5479109971524292`}, {
            1.2344283332784811`, 1.5937107390347818`}, {1.2167109444963518`, 
            1.6397865060415286`}, {1.1978647575352284`, 
            1.6861382981726698`}, {1.1810985765762831`, 
            1.727564204615573}}]}, {
           Arrowheads[{{0.018623364960036956`, 1.}}], 
           
           ArrowBox[{{1.1780963997644154`, 1.7349795113266955`}, {
            1.1570213175152249`, 1.7839613904060636`}, {1.1346125774690514`, 
            1.8332260910631724`}, {1.1108158736301161`, 
            1.8826611542913385`}, {1.0876016335409087`, 1.924335278046081}, {
            1.0633579129984942`, 1.9660525164423763`}, {1.0427548678569711`, 
            2.}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.013439388349230256`, 1.}}], 
           
           ArrowBox[{{1.791812363730024, -1.8351211011258506`}, {
            1.8505780831151906`, -1.822852736197449}, {
            1.9098238487203325`, -1.809243252103783}, {
            1.973281895293889, -1.7904954771882013`}, {
            2., -1.7819901096430557`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.291080393544972, 0.49760205825886905`}, {
            0.2616419143914215, 0.5485401854614496}, {0.226099628765921, 
            0.5994518016787876}, {0.19134694165776164`, 0.6417565418783272}, {
            0.1519491270337664, 0.6833138012707587}, {0.10788149432053275`, 
            0.7236491551545255}, {0.08647017237650109, 
            0.7406227688724213}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.08020108212750812, 0.7455925281673954}, {
            0.05878788380325004, 0.7625676293671586}, {0.004802195747724009, 
            0.7994610965784863}, {-0.05429028367723794, 
            0.8340153343356532}, {-0.11842852026708804`, 
            0.8656836462459596}, {-0.18755147981727852`, 
            0.8939193359167059}, {-0.19955984529118562`, 
            0.897848959763369}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.2071630946935962, 
            0.9003370511050892}, {-0.2617493475778218, 
            0.9181998852684838}, {-0.3409913332350821, 
            0.9379834335712515}, {-0.38242808979059983`, 
            0.9460089228390538}, {-0.4250349392390394, 
            0.9526942704563605}, {-0.46878156938664806`, 
            0.9579675126270898}, {-0.5136376680396734, 
            0.9617566855551611}, {-0.5201068045100441, 
            0.9620757590818816}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5280970914200857, 
            0.9624698594437416}, {-0.5596738108252206, 
            0.9640272999567073}, {-0.6069238868900834, 
            0.9647312394525109}, {-0.6553025543200408, 
            0.9637760996034646}, {-0.7047244712008729, 
            0.9610694759704614}, {-0.7551042956183591, 
            0.9565189641143945}, {-0.8063566856582793, 
            0.950032159596157}, {-0.8468178851940191, 0.9434112916580953}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.8547128835868759, 
            0.9421193936834903}, {-0.8583962994064128, 
            0.9415166579766415}, {-0.9111377949485394, 
            0.9308800548167412}, {-0.9754564490101795, 
            0.9150840749054145}, {-1.0406299162331218`, 
            0.8959380262827723}, {-1.1066581966173663`, 
            0.8734419089488143}, {-1.1612734669229359`, 
            0.8523364791249174}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1687356647879106`, 
            0.8494528003938575}, {-1.1735412901629125`, 
            0.8475957229035407}, {-1.2410047406714018`, 
            0.8181618341671932}, {-1.3087740919444752`, 
            0.7849026087600137}, {-1.3768493439821328`, 
            0.7478180466820024}, {-1.4452304967843743`, 
            0.7069081479331589}, {-1.4523715583860388`, 
            0.7022116874466414}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.4590555853293852`, 
            0.6978158048480475}, {-1.513571112358293, 
            0.6619625896155582}, {-1.581524752710982, 
            0.612771048831275}, {-1.6153564571793655`, 
            0.5865830350141275}, {-1.6490914178424414`, 
            0.5593335255803092}, {-1.6827296347002099`, 
            0.5310225205298204}, {-1.7133835598535239`, 
            0.5041786655921284}}]}, {
           Arrowheads[{{0.019147518774109328`, 1.}}], 
           
           ArrowBox[{{-1.719375591545921, 
            0.49887828039779397`}, {-1.770673544347786, 
            0.45307853727883857`}, {-1.8245690927772473`, 
            0.4015759658436159}, {-1.8787942896637628`, 
            0.34190488210902065`}, {-1.9319506743326325`, 
            0.2789222466148951}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.8469862168750995, 
            1.961597005923293}, {-0.8981920706436599, 
            1.9685988904086709`}, {-0.9501769515972532, 
            1.9746017514622287`}, {-1.0029408597358789`, 
            1.9796055890839668`}, {-1.0564837950595374`, 
            1.9836104032738846`}, {-1.1108057575682286`, 
            1.9866161940319833`}, {-1.1656585150769707`, 
            1.9886139207903712`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.1736573615181316`, 
            1.988746781666823}, {-1.2217322242038235`, 
            1.9895148039338375`}, {-1.2782276484569568`, 
            1.9891758204398289`}, {-1.3353930200213522`, 
            1.9876060108762352`}, {-1.3932283388970097`, 
            1.9848053752430566`}, {-1.45173360508393, 
            1.9807739135402933`}, {-1.4932582891516542`, 
            1.9770812384437024`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.5012268433272857`, 
            1.976372617000317}, {-1.510908818582112, 
            1.9755116257679455`}, {-1.5707539793915564`, 
            1.9690185119260124`}, {-1.6312690875122628`, 
            1.9612945720144945`}, {-1.688865917750415, 
            1.95397381252274}, {-1.7470098070257902`, 
            1.9454325931624212`}, {-1.8057163435303019`, 
            1.935696549853294}, {-1.8182427097051723`, 
            1.9333682521816231`}}]}, {
           Arrowheads[{{0.011193665532887682`, 1.}}], 
           
           ArrowBox[{{-1.8261079971557563`, 
            1.931906317395224}, {-1.8649387626882095`, 
            1.9246887748360912`}, {-1.92833350386406, 
            1.9089433916495133`}, {-1.9922024288042801`, 
            1.8916969864097306`}, {-2., 1.889411835218481}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.0414157541794744`, 
            0.8170646757122693}, {-1.0927990702290677`, 
            0.7974275332178378}, {-1.1570738213722906`, 
            0.7697189126064928}, {-1.2216547331993297`, 
            0.7383031569684979}, {-1.2865418057101856`, 
            0.703180266303853}, {-1.3289833023693352`, 
            0.6779015015472302}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3358565085392713`, 
            0.6738077212715496}, {-1.3517350389048581`, 
            0.6643502406125581}, {-1.416894313789582, 
            0.6216071574636852}, {-1.4816795113705914`, 
            0.5747450944263062}, {-1.5460906316478866`, 
            0.5237640515004212}, {-1.5926998721983219`, 
            0.48365960416124704`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5987640349794772`, 
            0.4784417569266443}, {-1.6101276746214679`, 
            0.4686640286860301}, {-1.6419024920763285`, 
            0.43952871079774614`}, {-1.673376940119187, 
            0.4092822698915384}, {-1.7045510187500421`, 
            0.37792470596740696`}, {-1.7354247279688946`, 
            0.3454560190253518}, {-1.765998067775745, 
            0.3118762090653729}, {-1.7962710381705924`, 
            0.2771852760874703}, {-1.8205166009304983`, 
            0.24822412599985155`}}]}, {
           Arrowheads[{{0.017642418395608633`, 1.}}], 
           
           ArrowBox[{{-1.8256519719601347`, 
            0.24208996229255036`}, {-1.8262436391534371`, 
            0.24138322009164387`}, {-1.8559158707242793`, 
            0.20447004107789374`}, {-1.8906345734414953`, 
            0.1604058178432303}, {-1.9247818644810561`, 
            0.11475592487018237`}, {-1.9581802790230445`, 
            0.06495660943321444}, {-1.990769610715526, 
            0.013477316467087157`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.011597598897624819`, 1.}}], 
           
           ArrowBox[{{1.9061714160586267`, 1.8193660554141313`}, {
            1.8944110080084835`, 1.8790358357360817`}, {1.8813166622692732`, 
            1.939200166206707}, {1.8641711119881832`, 2.}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.14339100821212997`, 
            1.1010322669299488`}, {-0.18499094594222426`, 
            1.1191738832360663`}, {-0.22809238465864776`, 
            1.1362273508674232`}, {-0.272678795699281, 
            1.1521143380806596`}, {-0.31873365040200435`, 
            1.1667565131324142`}, {-0.3662404201046981, 
            1.1800755442793276`}, {-0.41527405842848825`, 
            1.1920506733282974`}, {-0.447370663313168, 
            1.1987675372691156`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.4552010387031373, 
            1.200406201741228}, {-0.4658762527096841, 
            1.2026402062497645`}, {-0.5179805748589412, 
            1.2117344075456815`}, {-0.5715205967869155, 
            1.2192235417180022`}, {-0.6264298904042623, 
            1.2249978732686788`}, {-0.682642027621638, 
            1.2289476666996653`}, {-0.7400905803496975, 
            1.2309631865129136`}, {-0.7731841197692113, 
            1.2309471026620689`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7811841188243815, 
            1.2309432145680839`}, {-0.798709120499097, 
            1.2309346972103778`}, {-0.8712389901405638, 
            1.2279596287551282`}, {-0.9453766007716107, 
            1.2216694189383743`}, {-1.0211219523922377`, 
            1.2120640677601162`}, {-1.0984750450024447`, 
            1.199143575220354}, {-1.0991634878228111`, 
            1.1989989961314724`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.1069927018504415`, 
            1.1973547918529361`}, {-1.177207389710636, 
            1.1826090856060005`}, {-1.257090497625216, 
            1.162161743203968}, {-1.3381243687461846`, 
            1.1378015480142571`}, {-1.414887837879101, 
            1.1113934820361209`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.4224294297378592`, 
            1.1087265530689272`}, {-1.4617564288368667`, 
            1.0938530522700816`}, {-1.503338690196292, 
            1.077056183340954}, {-1.5450557871518162`, 
            1.0591378932494846`}, {-1.58690771970344, 
            1.0400981819956732`}, {-1.6288944878511635`, 
            1.01993704957952}, {-1.6710160915949865`, 
            0.9986544960010248}, {-1.713272530934909, 
            0.9762505212601879}, {-1.7133847970240146`, 
            0.9761882182462611}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.7203798276854545`, 
            0.9723062669269482}, {-1.755663805870931, 
            0.952725125357009}, {-1.7979634803523323`, 
            0.9293074374051642}, {-1.8403124180887422`, 
            0.9047053829593699}, {-1.8827331523877486`, 
            0.8789360213291175}, {-1.925158083326587, 
            0.8519481745859332}, {-1.9607944720443347`, 
            0.8263241343709404}, {-1.9916670973509634`, 
            0.8032998100145952}}]}, {
           Arrowheads[{{0.00015363512798318604`, 1.}}], 
           
           ArrowBox[{{-1.99836161253208, 
            0.7972173098900863}, {-1.9996949080879671`, 
            0.7972173098900863}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.11698731471118962`, 1.1369667706372213`}, {
            0.08100057949040285, 1.1640194890389388`}, {0.04333192476221583, 
            1.1904139773520583`}, {0.003986695884609131, 
            1.2160717450420837`}, {-0.037029761784436635`, 
            1.2409143015745203`}, {-0.0797121028869404, 
            1.2648631564148727`}, {-0.12405498206492159`, 
            1.2878398190286453`}, {-0.15580623256380327`, 
            1.3029747420819064`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.16302776715599301`, 
            1.3064170433664843`}, {-0.17005305396039957`, 
            1.309765798881343}, {-0.21770097321539325`, 
            1.3305626054384698`}, {-0.26707279503707215`, 
            1.3502210817835456`}, {-0.31821370169982405`, 
            1.3687068587753564`}, {-0.37107503844649475`, 
            1.385903627542308}, {-0.4256081505199312, 
            1.4016950792128064`}, {-0.4647113452002135, 
            1.4116315679378157`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.4724649302160297, 
            1.4136018266524293`}, {-0.48176438316298, 
            1.4159649049152578`}, {-0.5394950816184872, 
            1.428596795778068}, {-0.5987515911292994, 
            1.4394744429296424`}, {-0.6594852569382634, 
            1.4484815374983875`}, {-0.7371159130556332, 
            1.4568628334170768`}, {-0.7885915323899234, 
            1.4601760615001036`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           ArrowBox[{{-0.7965750122911471, 
            1.4606899181598407`}, {-0.8169674276610243, 
            1.4620024759135504`}, {-0.8990398007544367, 
            1.4639004649878082`}, {-0.9833330323358705, 
            1.4625568006398506`}, {-1.0262645428319492`, 
            1.4605822053562716`}, {-1.069655413494741, 
            1.4576229105645995`}, {-1.1135056443242455`, 
            1.4536789162648347`}, {-1.1161605976851294`, 
            1.4533835975337035`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.1241115610365007`, 
            1.4524991871170116`}, {-1.1578152353204627`, 
            1.4487502224569766`}, {-1.2025841864833933`, 
            1.4428368291410263`}, {-1.2478124978130367`, 
            1.4359387363169829`}, {-1.2935001693093926`, 
            1.4280559439848464`}, {-1.3396472009724618`, 
            1.4191884521446172`}, {-1.3861851015732194`, 
            1.4092493325274595`}, {-1.4330453798826408`, 
            1.398151656864538}, {-1.4389314918156078`, 
            1.3966226723222932`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.4466745216506707`, 
            1.3946113322283946`}, {-1.4802280359007256`, 
            1.385895425155852}, {-1.5277330696274742`, 
            1.3724806374014018`}, {-1.5755604810628867`, 
            1.357907293601188}, {-1.623710270206963, 
            1.34217539375521}, {-1.6721824370597032`, 
            1.325284937863468}, {-1.7209769816211071`, 
            1.3072359259259616`}, {-1.7509699810501318`, 
            1.2961949144213478`}}]}, {
           Arrowheads[{{0.016549047184329414`, 1.}}], 
           
           ArrowBox[{{-1.7584774598189319`, 
            1.2934312642017987`}, {-1.7722468363782293`, 
            1.2883624865571246`}, {-1.8237865253735601`, 
            1.26811556436479}, {-1.875620247329235, 
            1.2465202235448332`}, {-1.9276754060788468`, 
            1.2235012715096265`}, {-1.9721765650799297`, 
            1.2005662969627395`}, {-2., 1.185576371882921}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.2171465236583665, 1.260894696277094}, {
            0.1802693405004012, 1.2927676624559046`}, {0.14160835879957862`, 
            1.3240653976865815`}, {0.10116032557489574`, 
            1.3547102682484637`}, {0.058921987845348904`, 
            1.3846246404208908`}, {0.014890092629934943`, 
            1.413730880483201}, {-0.03093861305234926, 
            1.4419513547147333`}, {-0.04170833204722668, 
            1.44811466819707}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.04865172393389203, 
            1.452088244559516}, {-0.0785673821825073, 
            1.4692084293948273`}, {-0.12806844588210456`, 
            1.4955019045165443`}, {-0.17948895231250184`, 
            1.5208034223588647`}, {-0.2327945300143959, 
            1.5449931126300058`}, {-0.28795080752848357`, 
            1.567951105038186}, {-0.33834076043895317`, 
            1.5870611085938657`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.3458314428678387, 
            1.5898687078568186`}, {-0.40367797615602624`, 
            1.609692515098533}, {-0.4641801243508746, 
            1.628236192167135}, {-0.5263954865207028, 
            1.645068690205646}, {-0.6086400858651352, 
            1.6639111878565587`}, {-0.6546100776724446, 
            1.6723779206619342`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6624777465861915, 
            1.6738269844506135`}, {-0.6936678377751501, 
            1.6795715616821938`}, {-0.7372253959422508, 
            1.686208452160532}, {-0.7814787422507473, 
            1.6920498116825515`}, {-0.8264278767006396, 
            1.6970956402482518`}, {-0.872072799291927, 
            1.701345937857632}, {-0.9183735544209015, 
            1.7047019507681174`}, {-0.9652901864838543, 
            1.707064925237131}, {-0.9803995539676275, 
            1.7075003928214476`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9883962334282876, 
            1.707730865386962}, {-1.0128226954807853`, 
            1.7084348612646734`}, {-1.0609710814116942`, 
            1.7088117588507443`}, {-1.1097353442765812`, 
            1.7081956179953437`}, {-1.1591154840754465`, 
            1.706586438698472}, {-1.2091115008082902`, 
            1.7039842209601288`}, {-1.2597233944751116`, 
            1.7003889647803139`}, {-1.3079571438796966`, 
            1.695968287831534}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.3159123682826739`, 
            1.6951273480907867`}, {-1.3625479385131969`, 
            1.689814812540164}, {-1.4146988703600876`, 
            1.6827347853408026`}, {-1.4673422420922098`, 
            1.6744594574219165`}, {-1.5204780537095646`, 
            1.6649888287835064`}, {-1.574106305212151, 
            1.6543228994255714`}, {-1.6282269965999694`, 
            1.6424616693481124`}, {-1.6312290085717356`, 
            1.641743969028636}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.6390097405944268`, 
            1.6398838052748048`}, {-1.6828401278730196`, 
            1.6294051385511288`}, {-1.7386704297746507`, 
            1.6161320003087125`}, {-1.794940162689721, 
            1.6015040761224566`}, {-1.8516701250643584`, 
            1.5855487240170718`}, {-1.9087979215601794`, 
            1.5681838699184267`}, {-1.9469584485008726`, 
            1.5538368819134496`}}]}, {
           Arrowheads[{{0.0030588375487087573`, 1.}}], 
           
           ArrowBox[{{-1.9544467057469834`, 
            1.5510215660490985`}, {-1.9700373211783067`, 
            1.5451600544161215`}, {-2., 1.5331358880388881`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.23955658394446208`, 1.7516122592102845`}, {
            0.2036792490932028, 1.7804855530710302`}, {0.16667239784399984`, 
            1.8089507322509863`}, {0.12853603019685303`, 
            1.8370077967501526`}, {0.08927014615176244, 1.864656746568529}, {
            0.048874745708727976`, 1.8918975817061157`}, {
            0.006619241000769431, 1.919789385091995}, {-0.020930014754442564`,
             1.9371015158571772`}}]}, {
           Arrowheads[{{0.007426939280308862, 1.}}], 
           
           ArrowBox[{{-0.027703610512405566`, 
            1.9413580873070304`}, {-0.03686760971221398, 
            1.9471168037634303`}, {-0.08352521392361122, 
            1.973541014049032}, {-0.1314631139499159, 
            1.999230038243717}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.9838522792110163, -0.8697160248382193}, {
            1.0363135651360598`, -0.853190970244288}, {
            1.0891801576190678`, -0.8343944364268926}, {
            1.1545653516814076`, -0.8080118383510738}, {
            1.2203456871921672`, -0.7779292586136497}, {
            1.2791726100601735`, -0.7478981319029152}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.2862978521065338`, -0.7442606979473941}, {
            1.2865211641513463`, -0.7441466972146201}, {
            1.3530917825589452`, -0.7066641541539852}, {
            1.4197248113607208`, -0.6652687839672997}, {
            1.4860875195024295`, -0.6197477411901182}, {
            1.552179906984072, -0.570101025822441}, {
            1.553551094507953, -0.5689808539551948}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.559746535243545, -0.563919578020041}, {
            1.6180019738056475`, -0.5163286378642677}, {
            1.6507100385308024`, -0.48785230214655795`}, {
            1.683147326214725, -0.45825851924684957`}, {
            1.7153138368574148`, -0.42754728916514284`}, {
            1.7472095704588722`, -0.39571861190143737`}, {
            1.7788345270190973`, -0.3627724874557336}, {
            1.7939363635100936`, -0.34636566396640284`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.7993542842931882`, -0.3404795672641636}, {
            1.81018870653809, -0.3287089158280312}, {
            1.8412721090158497`, -0.29352789701833026`}, {
            1.8720847344523772`, -0.2572294310266309}, {
            1.9099011865801039`, -0.21179482590762325`}, {
            1.947137597849129, -0.1646043446781893}, {
            1.9836926814505929`, -0.11278905461869494`}, {
            1.9985363801161848`, -0.09046833025540374}}]}}}}}}, {{}, {{{}, \
{}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 120], 0.008333333333333333]], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwll3k4Vd/3x+/gojQRkahQMkSS0MA6SaXJPJdU6hMSCg2UocgQlSklFSoh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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 120], 0.008333333333333333]], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwlV3c819/3F+1ElF0qGkpUSFQ6KmRGkpRIQkRIslek7OwRsvfI297H3nvv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          "]]}}}, {{}, {}}}, {{}, {{{
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                DiskBox[{0, 0}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 72]], 
                  RGBColor[0.368417, 0.506779, 0.709798], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.272]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPg/AAAAAAAA8D+y
KteWmv70P8fSZxWaMfQ/pSAjPP1B8T9DQ+QJO9P3P/+tVbznyek/BIxNEDrE
+j843JgnDhDgP8aTb3Lx6Pw/GDUOY2GExj8KEy3t3yv+PxG5ULPnxMS/u2Z/
xwF+/j9J+FXtLxDgvxHG9bwR2P0/q9eNWQmj6r9SdwZ0Zzr8P15oDhHJSPK/
3B8HFzWt+T/Uv+D7p8P2v15WD8rDQPY/wsVJ3d6a+r9ejDGmiAzyP/acNAHD
q/2/77rsnxVe6j89Zl8YUtn/v/gYC7oeM98/qJ2ypH+GAMB0Be9oDHnAP4ga
2DgXnADArkz/vhnlzr9opjj2CyoAwKVkEYryjeO/5FXbPqRi/r9eTOgyxP7u
vzS8y7J8bvu/EzKSkBHW9L8m3opvdIr3v9sM1Ok8nfm/8t2jKtXR8r+uzs1D
Bav9vzVWHL/2zeq/Yepc/DxtAMAMkEIYzMrdv6Q+0V6ChgHAxQxrEjYxsr8T
vzpt4hUCwObE/cRAWNU/7FF+2+wTAsA/caBq/4jnPzjEtq7gfQHA+ihTUV3z
8T+rZj9dl1UAwMymh1yvrvc/U4C5lx1D/b/vZPf8T8X8P3AFa0UW2vi/w+eY
0xeFAEBkzFQk9I7zv/RPm0QaKwJAwTjkBkQR6795z9Hrv0QDQJGnXiIT09u/
cHoC6xnGA0AcJH41EllZvxB47PEeqANAEGxcGX4u3D/htIMXhugCQBb6f9Le
D+w/yDXdzjaKAUD86pcI7rT0P3yHpjifKv8/P5Js82ra+j/EEf9aci36Pw6a
9QKbIQBAmtRZbntA9D+2hktSsV8CQLJ9BM/YHus/0/8Bz7oSBEARmrMQhzTZ
P+CrTNP4KQVAHmyARizctL/vG1hRfJkFQA3POI2KCeK/6FsehT5aBUCc0n2A
P5nwv45tsg7eagRA8bbkc3TM979t3VEVhc8CQO7GhPxgYf6/BXSncNWRAECq
qzV+jA8CwP8BnnYbgvs/v2iLbxdpBMDkccarduL0P7og/BRuJwbAtCWQYPTr
6j/4tydmQzkHwHLCGvKp1dU/vu+YPQ==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 72], 0.013888888888888888`]], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 72]], 
                  RGBColor[0.880722, 0.611041, 0.142051], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.72]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPg/AAAAAAAA8D9Y
aHzN8yTDv7hb+kD40/o/461nw3ET979UOsNRWw/kP4Xz5UzhivK/3MR5Dlzj
7L9OjbTonHXMP1Qo9kJlqfW/D1dRsrpc8z85/A1ElhDbv+xPHzJTZ+w/O7zv
MbC06T+eeSKyccbQv2RVxs3SZPE/5NjG9Lwk8L+dRJDb31fRP6JVrQFsiuW/
VNQ6hoyZ5r8gEW0U3dHRP/pqKiNgxuu/MD5MwZzC6j8bZHNFKW7Ev3zFvkSC
JuA/CrRBWRyq4z8u5qYhHdPRvxsVaeu+CuY/tPqqMmAO5r/vMAzTRVi0P1QY
7t945Ne/id7T3Lj04L+fMe1fOyLRP6P2xQqaYOG/KO9YWocU4j8E+3NLaLmX
v/g6Qu1YYtE/LrhZVlIB3T+nxicxZQPQv1TouGtpN9s/mtuxYYt73b8EA/Mz
CP6Ov+Lhb3pQxci/dOXjCNWd2L9ENUU2Tk3NP3qiPBSeKNW//QZJfKro1z/E
5phe3HqkP8AAKDVZLME/wa8lYgHA1D8Ht3oQklzKv3GhnAJlUdA/sOPIZYBH
078htZSpLySsvxJNZ+117ba/NsQ6Gnxh0b9aJ8e7OWTHP3DV7nHg8ci/9h6u
1cLpzj+g5IteXxGwP0oW5AkQ6qw/EBmRj6bxzD/+i9YZ24PEv1Sm3dIl38I/
jHR/mzqkyL8KXJnlKsawv8RiXxspi6C/0J8CJmX2x79a81XrK87BP0jy7HYr
Nby/vgguvkOGwz8eAGL3kJiwP+qA0v8Tvo4/x5tT4ou6wz/0kxyW4aK+v3yP
MKMBybQ/BYb8rle+vr9Wmvprz6yvv95K4xOeE2i/e9NXwkMmwL8cpIoRRya6
PxZi4WHhGq6/t8ruwScKuD8MCbx/LnKtP2sUydXEQ3W/QIngWVtLuj8rVH4/
9yi2vypecYehU6U/wIqd1sqnsr9QB6jpJdOqv343FVFISIU/LqChrntKtb/y
vxuCoqeyP+NgEH/xV52/4F/SKsS1rD8ITobYiwqoP6a8csJBiYu/bWbncUgl
sT+WMVMLlTavv8SbIws1XpM/GKSgsg==
          "]]}}}, {{}, {}}}}, {
    Frame -> True, DisplayFunction -> Identity, 
     PlotRange -> {{-2, 2}, {-2, 2}}, DisplayFunction -> Identity, 
     AspectRatio -> 1, Frame -> True, FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, DisplayFunction -> 
     Identity, AspectRatio -> 1, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRange -> {{-2, 2}, {-2, 2}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"AdaptiveEG+\"", 
       InterpretationBox[
       "\"\\!\\(\\*FormBox[\\\"2\\\", TraditionalForm]\\)-step EG\"", 
        StringForm["`1`-step EG", 2], Editable -> False]}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.272}, {20, 6.272}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.08426020408163262] -> 
                    Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.72}, {20, 6.72}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.72}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.051309523809523805`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "72"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], ",", 
                    RowBox[{"Offset", "[", "6.72`", "]"}]}], "}"}]}], 
               "}"}]}]}], "]"}]& ), Editable -> True], TraditionalForm], 
    TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.904680643196373*^9, 3.904680780537944*^9, 3.9046808168819227`*^9, {
   3.904680939782234*^9, 3.9046809668294992`*^9}, {3.9046810088523493`*^9, 
   3.904681019535927*^9}, {3.904681059518063*^9, 3.904681089182433*^9}, 
   3.904681163068296*^9, 3.904681196244351*^9, 3.904681228567741*^9, {
   3.904681295917961*^9, 3.904681315647586*^9}, 3.904681460883649*^9, {
   3.904681497245674*^9, 3.9046815217818604`*^9}, 3.9046816212738323`*^9, {
   3.904681717294569*^9, 3.904681755225898*^9}, {3.904681823347838*^9, 
   3.904681903641996*^9}, {3.904681936073902*^9, 3.904682011996291*^9}, {
   3.904682145936627*^9, 3.9046821609628973`*^9}, 3.9046822562052717`*^9, 
   3.904682344759131*^9, 3.9046824403140163`*^9, 3.90468247155002*^9, 
   3.9046825501144238`*^9, {3.9046827513642807`*^9, 3.904682847009766*^9}, {
   3.904682895012501*^9, 3.904682902690345*^9}, 3.904683020411564*^9, 
   3.9046831476611853`*^9, {3.9046831840485773`*^9, 3.904683250506708*^9}, {
   3.904683284200385*^9, 3.904683351968749*^9}, {3.9046833986014214`*^9, 
   3.9046834127635937`*^9}, {3.9046834986151857`*^9, 3.904683561388508*^9}, {
   3.904683645359761*^9, 3.904683663822613*^9}, {3.904683725464981*^9, 
   3.904683745488326*^9}, 3.9046837849943857`*^9, {3.9046838650059137`*^9, 
   3.904683902610824*^9}, 3.904684020088187*^9, {3.904684056094061*^9, 
   3.904684091144416*^9}, {3.904684135562866*^9, 3.904684140839593*^9}, 
   3.904684291734256*^9, {3.904684405478045*^9, 3.904684421391037*^9}, {
   3.904684462615758*^9, 3.904684529111066*^9}, 3.9046846787736*^9, 
   3.904685301634338*^9, 3.904686800171452*^9, {3.904686928356135*^9, 
   3.9046869531162148`*^9}, 3.904687046697579*^9, {3.90476514619773*^9, 
   3.904765187141828*^9}, 3.9047653045355053`*^9, {3.90491894032127*^9, 
   3.904918957043838*^9}, 3.904977547622294*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"97248367-9c91-4cf3-99f2-a163c172c483"]
}, Open  ]]
},
WindowSize->{808, 647},
WindowMargins->{{Automatic, -17}, {23, Automatic}},
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) \
(2021\:5e746\:670819\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"3f4a9c5c-2e12-45a3-a804-7008ec4bbc55"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 487, 7, 44, "Input",ExpressionUUID->"98204e13-b355-4b54-98a9-c836aed98c0f"],
Cell[1048, 29, 11450, 300, 1523, "Input",ExpressionUUID->"4fc9de00-5343-4fd5-8bb7-8a6c47b7b7a2"],
Cell[12501, 331, 11805, 292, 1792, "Input",ExpressionUUID->"1f605237-06e1-4004-a2c0-dcfd70672f09"],
Cell[24309, 625, 4806, 114, 374, "Input",ExpressionUUID->"07fe36ad-9c3f-4298-a221-e9ceb5f6393c"],
Cell[CellGroupData[{
Cell[29140, 743, 2222, 48, 166, "Input",ExpressionUUID->"9f1bf222-de69-49af-9d91-79ef34383170"],
Cell[31365, 793, 199, 4, 24, "Print",ExpressionUUID->"0533ff87-d0fc-4661-8db6-0d4dc5a6b4d1"],
Cell[31567, 799, 239959, 4524, 411, "Output",ExpressionUUID->"97248367-9c91-4cf3-99f2-a163c172c483"]
}, Open  ]]
}
]
*)

