(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    418513,       8207]
NotebookOptionsPosition[    417200,       8179]
NotebookOutlinePosition[    417607,       8196]
CellTagsIndexPosition[    417564,       8193]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", ";"}]], "Input",
 CellChangeTimes->{{3.9046758395087547`*^9, 3.904675882652114*^9}, {
   3.90467597954259*^9, 3.90467597990091*^9}, 3.90467601385382*^9, {
   3.9046760554450207`*^9, 3.904676057119492*^9}, 3.904676232901587*^9, {
   3.9046768083586483`*^9, 3.904676808764234*^9}, {3.904677095062833*^9, 
   3.904677139175105*^9}, {3.9046784805202227`*^9, 3.904678508747361*^9}, {
   3.904746991905456*^9, 3.904746992407086*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"98204e13-b355-4b54-98a9-c836aed98c0f"],

Cell[BoxData[
 RowBox[{"<<", "MaTeX`"}]], "Input",
 CellChangeTimes->{{3.904747010749639*^9, 3.9047470107558107`*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"bab72329-97d8-4917-958e-7fcc6cff511d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SolveFlow", "[", 
    RowBox[{"W_", ",", "wstart_", ",", "horizon_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NDSolve", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"w1", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"W", "[", 
            RowBox[{
             RowBox[{"w1", "[", "t", "]"}], ",", 
             RowBox[{"w2", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
           "1", "\[RightDoubleBracket]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"w2", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"W", "[", 
            RowBox[{
             RowBox[{"w1", "[", "t", "]"}], ",", 
             RowBox[{"w2", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
           "2", "\[RightDoubleBracket]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"w1", "[", "0", "]"}], "\[Equal]", 
         RowBox[{
         "wstart", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"w2", "[", "0", "]"}], "\[Equal]", 
         RowBox[{
         "wstart", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"w1", ",", "w2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "horizon"}], "}"}]}], "]"}], "//", "Flatten"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"plotFlow", "[", 
     RowBox[{"W_", ",", 
      RowBox[{"side_", ":", 
       RowBox[{"7", "/", "4"}]}]}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"StreamPlot", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"-", 
          RowBox[{"W", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)\>\"", ",", 
           "\"\<\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}],
         ",", 
        RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"StreamColorFunction", "->", "None"}], ",", 
        RowBox[{"StreamStyle", "\[Rule]", "Gray"}]}], "]"}]}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotTrajectory", "[", 
    RowBox[{"W_", ",", 
     RowBox[{"p_", ":", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"k_", ":", "25"}], ",", 
     RowBox[{"T_", ":", "25"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sol", "=", 
       RowBox[{"SolveFlow", "[", 
        RowBox[{"W", ",", "p", ",", "T"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"plotFlow", "[", "W", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ParametricPlot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"w1", "[", "t", "]"}], ",", 
              RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "}"}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotMultipleTrajectories", "[", 
    RowBox[{"W_", ",", 
     RowBox[{"stableInits_", ":", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}]}], ",", 
     RowBox[{"unstableInits_", ":", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}]}], ",", 
     RowBox[{"k_", ":", "25"}], ",", 
     RowBox[{"T_", ":", "50"}], ",", 
     RowBox[{"sides_", ":", 
      RowBox[{"7", "/", "4"}]}], ",", 
     RowBox[{"withEq_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Wreverse", ",", "stable", ",", " ", "unstable", ",", "eq"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Wreverse", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
       RowBox[{"-", 
        RowBox[{"W", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"stable", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "p", "}"}], ",", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"sol", " ", "=", 
               RowBox[{"SolveFlow", "[", 
                RowBox[{"W", ",", "p", ",", "T"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w1", "[", "t", "]"}], ",", 
                   RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], "]"}], ",", "stableInits"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"unstable", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "p", "}"}], ",", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"sol", " ", "=", 
               RowBox[{"SolveFlow", "[", 
                RowBox[{"Wreverse", ",", "p", ",", "T"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w1", "[", "t", "]"}], ",", 
                   RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], "]"}], ",", "unstableInits"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"If", "[", 
        RowBox[{"withEq", ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"getEquilibria", "[", 
            RowBox[{"W", ",", 
             RowBox[{"side", "=", "sides"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], "]"}], 
         ",", 
         RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"plotFlow", "[", 
            RowBox[{"W", ",", "sides"}], "]"}], ",", "eq"}], "}"}], ",", 
         "stable", ",", "unstable"}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numTotalIterates", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotIterates", "[", 
    RowBox[{"W_", ",", "iterates_", ",", "legends_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"Length", "[", "iterates", "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"iteratesReduces", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArrayResample", "[", 
           RowBox[{"#", ",", "numTotalIterates"}], "]"}], "&"}], ",", 
         "iterates"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"legend", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "legends", "]"}], "\[NotEqual]", "0"}], ",", 
         
         RowBox[{
          RowBox[{"ListLinePlot", "[", 
           RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
            RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
            RowBox[{"PlotLegends", "\[Rule]", 
             RowBox[{"Placed", "[", 
              RowBox[{"legends", ",", "Below"}], "]"}]}]}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         StyleBox[
          RowBox[{"{", "}"}],
          FontWeight->"Plain"]}], 
        StyleBox["]",
         FontWeight->"Plain"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"lines", "=", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"iterates", ",", 
         RowBox[{"PlotLegends", "\[Rule]", "legend"}], ",", 
         RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"markers", "=", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
         RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Joined", "\[Rule]", "False"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"plotFlow", "[", 
         RowBox[{"W", ",", "side"}], "]"}], ",", "\[IndentingNewLine]", 
        "lines", ",", "\[IndentingNewLine]", "markers", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"getW", "[", "L_", "]"}], ":=", 
   RowBox[{"Evaluate", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"L", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"L", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "}"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.904677020568327*^9, 3.904677044927948*^9}, 
   3.904678514407029*^9, {3.90467893523694*^9, 3.904678935532865*^9}, {
   3.9046836370861807`*^9, 3.90468363729296*^9}, {3.904734861901731*^9, 
   3.9047348691212597`*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"4fc9de00-5343-4fd5-8bb7-8a6c47b7b7a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"threshold", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AEGPlus", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Gamma]1", "*", 
             RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]1", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGn", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_", ",", "nSteps_"}], "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "0"}], ",", 
            RowBox[{"i", "<", "nSteps"}], ",", 
            RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{"zbar", "=", 
             RowBox[{"zbar", "-", 
              RowBox[{"\[Gamma]2", "*", 
               RowBox[{"V", "[", "zbar", "]"}]}]}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]2", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MaxIter", " ", "=", " ", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEG", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]", ",", "\[Gamma]", ",", "dold", ",", "d", ",", 
      RowBox[{"evals", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Gamma]", "=", 
      RowBox[{"1", "/", "L"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"d", "=", 
      RowBox[{"-", "Infinity"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{"evals", "+=", "1"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "evals", "]"}], "]"}], "=", 
           RowBox[{"V", "[", 
            RowBox[{"z", "-", 
             RowBox[{"\[Gamma]", "*", "Fzbar"}]}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"dold", "=", "d"}], ";", "\[IndentingNewLine]", 
             RowBox[{"Fzbar", "=", 
              RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"zbar", "=", 
              RowBox[{"zbar", "-", 
               RowBox[{"\[Gamma]", "*", "Fzbar"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"evals", "+=", "1"}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Fzbars", "[", 
               RowBox[{"[", "evals", "]"}], "]"}], "=", "Fzbar"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"d", "=", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Sigma]3", "*", 
                  RowBox[{"Total", "[", 
                   RowBox[{
                    RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}]}], "-", 
                 RowBox[{"Fzbar", ".", 
                  RowBox[{"(", 
                   RowBox[{"zbar", "-", "z"}], ")"}]}]}], ")"}], "/", 
               RowBox[{"Norm", "[", "Fzbar", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"Print", "[", "d", "]"}], ";", "\[IndentingNewLine]", 
               RowBox[{"Print", "[", "zbar", "]"}], ";"}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"d", "-", "dold"}], "<", 
                RowBox[{"\[Epsilon]", "*", 
                 RowBox[{"Norm", "[", "Fzbar", "]"}]}]}], ",", 
               RowBox[{
                RowBox[{"d", "=", 
                 RowBox[{"-", "Infinity"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"(*", 
                 RowBox[{
                  RowBox[{"Print", "[", "i", "]"}], ";"}], "*)"}], 
                RowBox[{"Break", "[", "]"}]}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "MaxIter"}], "}"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]3", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"\[Alpha]", "<=", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", 
            RowBox[{"z", "=", "zbar"}]}], "]"}]}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Linesearch", "[", 
     RowBox[{
     "W_", ",", "z_", ",", "\[Gamma]0_", ",", "\[Nu]_", ",", "\[Tau]_"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"V", ",", "G", ",", "\[Gamma]", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Gamma]", "=", "\[Gamma]0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"i", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"V", "[", "vec_", "]"}], ":=", 
        RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"G", "[", "vec_", "]"}], ":=", 
        RowBox[{"Q", "[", 
         RowBox[{"z", "-", 
          RowBox[{"\[Gamma]", "*", 
           RowBox[{"V", "[", "z", "]"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Gamma]", "*", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"V", "[", 
              RowBox[{"G", "[", "z", "]"}], "]"}], "-", 
             RowBox[{"V", "[", "z", "]"}]}], "]"}]}], ">", 
          RowBox[{"\[Nu]", "*", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"G", "[", "z", "]"}], "-", "z"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Gamma]", "*=", "\[Tau]"}], ";", 
          RowBox[{"i", "++"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"\[Gamma]", ",", "i"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"requires", " ", "\[Lambda]", " ", "and", " ", "\[Tau]"}], ",", 
    " ", "\[Nu]"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CurvatureEGPlus", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
     "J", ",", "\[Alpha]", ",", "\[Sigma]", ",", "\[Gamma]", ",", "i", ",", 
      "\[Gamma]0", ",", "Lips", ",", "V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Q", "[", "zstart", "]"}], ",", 
         RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Q", "[", "zstart", "]"}], ",", 
         RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"linesearchSteps", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", 
       RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", 
       RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", "Hz", 
      ",", "Hzbar", ",", "Hzdiff", ",", "Fzbar"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"J", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"(", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"W", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Lips", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SingularValueList", "[", 
          RowBox[{
           RowBox[{"J", "[", 
            RowBox[{"x", ",", "y"}], "]"}], ",", "1"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", 
          RowBox[{
           RowBox[{"linesearchSteps", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "0"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Gamma]0", "=", 
           RowBox[{"\[Nu]", "/", 
            RowBox[{"Re", "[", 
             RowBox[{"Lips", "[", 
              RowBox[{
               RowBox[{"z", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"z", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Gamma]", ",", 
             RowBox[{"linesearchSteps", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "}"}], "=", 
           RowBox[{"Linesearch", "[", 
            RowBox[{
            "W", ",", "z", ",", "\[Gamma]0", ",", "\[Nu]", ",", "\[Tau]"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"linesearchSteps", "[", 
              RowBox[{"[", "n", "]"}], "]"}], "]"}], ";"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"\[Sigma]", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Gamma]"}], "/", "2"}], "*", "0.99"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Hz", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Gamma]", "*", 
             RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", 
           RowBox[{"Q", "[", "Hz", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Hzbar", "=", 
           RowBox[{"zbar", "-", 
            RowBox[{"\[Gamma]", "*", 
             RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Hzdiff", "=", 
           RowBox[{"Hzbar", "-", "Hz"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Sigma]", "/", "\[Gamma]"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}], ".", 
                 RowBox[{"(", "Hzdiff", ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Hzdiff", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "+", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", 
             RowBox[{"(", "Hzdiff", ")"}]}]}]}]}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "linesearchSteps", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGPlusAdaptive", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]", ",", "zold"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"zbar", "=", 
      RowBox[{"z", "-", 
       RowBox[{
        RowBox[{"1", "/", "L"}], "*", " ", 
        RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "=", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"z", "-", "zbar"}], "]"}], "/", 
       RowBox[{"Norm", "[", 
        RowBox[{
         RowBox[{"V", "[", "z", "]"}], "-", 
         RowBox[{"V", "[", "zbar", "]"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"zold", "=", "z"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Fz", "=", 
           RowBox[{"V", "[", "z", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"Min", "[", 
             RowBox[{"\[Alpha]", ",", 
              RowBox[{"\[Tau]2", "*", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"zold", "-", "zbar"}], "]"}], "/", 
                RowBox[{"Norm", "[", 
                 RowBox[{
                  RowBox[{"V", "[", "zold", "]"}], "-", "Fzbar"}], 
                 "]"}]}]}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", "\[Alpha]", "]"}], ";"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Alpha]", "*", "Fz"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"zold", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Gamma]0", "*", "\[Alpha]", "*", 
             RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.904678200286641*^9, 3.9046782475842943`*^9}, {
   3.90467909112251*^9, 3.904679097822371*^9}, {3.9046792688817797`*^9, 
   3.904679303409689*^9}, {3.904679333690419*^9, 3.904679368663969*^9}, {
   3.90467945796194*^9, 3.904679462049508*^9}, {3.904679569678234*^9, 
   3.904679581274199*^9}, {3.904680214037197*^9, 3.904680220218223*^9}, {
   3.9046803053581667`*^9, 3.904680319781455*^9}, {3.90468042553959*^9, 
   3.904680476590773*^9}, {3.904680510314959*^9, 3.904680512246313*^9}, {
   3.904680620594401*^9, 3.904680637294128*^9}, {3.904680750074663*^9, 
   3.904680774814436*^9}, {3.904681514370843*^9, 3.904681514562438*^9}, {
   3.9046815982774076`*^9, 3.904681599437152*^9}, {3.9046817061931458`*^9, 
   3.9046817093477182`*^9}, {3.904682237709672*^9, 3.904682247971066*^9}, {
   3.904682328935872*^9, 3.90468233339469*^9}, {3.904682737049563*^9, 
   3.904682784727713*^9}, {3.9046828287430973`*^9, 3.9046828389855213`*^9}, {
   3.904683087131117*^9, 3.904683088137315*^9}, {3.9046831417764053`*^9, 
   3.9046831540449533`*^9}, {3.9046832446362143`*^9, 
   3.9046832447937613`*^9}, {3.9046833751980467`*^9, 3.904683386176111*^9}, {
   3.904683425080777*^9, 3.904683468183568*^9}, {3.904683699290395*^9, 
   3.90468377238837*^9}, {3.904684501109694*^9, 3.904684513096389*^9}, {
   3.904734687310487*^9, 3.9047346889264917`*^9}, {3.904735638199567*^9, 
   3.904735642702927*^9}, {3.904735858303772*^9, 3.904735860482394*^9}, {
   3.904735913875009*^9, 3.9047359568155518`*^9}, {3.904736004679942*^9, 
   3.904736069425618*^9}, {3.904736100378529*^9, 3.904736135874916*^9}, {
   3.9047361673757353`*^9, 3.904736199601235*^9}, {3.9047362901436462`*^9, 
   3.904736295428629*^9}, {3.904736396354847*^9, 3.904736398197328*^9}, {
   3.904736500801519*^9, 3.9047365061250277`*^9}, {3.9047366743510437`*^9, 
   3.904736676121499*^9}, {3.9047368206499662`*^9, 3.904736829639427*^9}, {
   3.904739527353507*^9, 3.904739549079664*^9}, {3.9047395815001583`*^9, 
   3.904739586088181*^9}, {3.9047396277275457`*^9, 3.904739650762389*^9}, {
   3.9047396888822393`*^9, 3.9047397394239883`*^9}, {3.904740097634782*^9, 
   3.9047401338112297`*^9}, {3.90474062190948*^9, 3.904740623062583*^9}, {
   3.9047406865412693`*^9, 3.9047406874158907`*^9}, 3.904740776177493*^9, {
   3.9047408070910587`*^9, 3.9047408450710697`*^9}, {3.90474095167268*^9, 
   3.9047409532700663`*^9}, {3.904740985213286*^9, 3.9047409860956717`*^9}, {
   3.904741103924016*^9, 3.9047411395931664`*^9}, {3.904741263191353*^9, 
   3.90474128101466*^9}, {3.9047413120348*^9, 3.9047414055119333`*^9}, {
   3.9047414436890593`*^9, 3.90474144406164*^9}, {3.904741476898735*^9, 
   3.904741510553554*^9}, {3.904741625442421*^9, 3.904741630399645*^9}, {
   3.904741717509951*^9, 3.904741717679352*^9}, {3.9047417526176653`*^9, 
   3.904741761921954*^9}, {3.9047418656083307`*^9, 3.9047419315116262`*^9}, {
   3.904742010382399*^9, 3.904742038565516*^9}, 3.904742069438579*^9, {
   3.9047421109297733`*^9, 3.904742122505188*^9}, {3.90474220492393*^9, 
   3.904742212310892*^9}, {3.9047422684823093`*^9, 3.904742269026436*^9}, {
   3.904742557136195*^9, 3.9047425666712646`*^9}, {3.904742868289522*^9, 
   3.9047428828042383`*^9}, {3.904743738375304*^9, 3.904743745015914*^9}, {
   3.904743937547764*^9, 3.904743937699272*^9}, {3.904744032460966*^9, 
   3.904744032567647*^9}, {3.904745685730649*^9, 3.9047457891054487`*^9}, {
   3.904745822624514*^9, 3.904745886683846*^9}, {3.9047459252515497`*^9, 
   3.904745958212735*^9}, {3.9047462392773523`*^9, 3.904746239752275*^9}, {
   3.904746275860271*^9, 3.9047462801428823`*^9}, {3.9047463886602907`*^9, 
   3.904746418881925*^9}, {3.9047464589354343`*^9, 3.9047464919742117`*^9}, {
   3.9047465405281563`*^9, 3.904746542566366*^9}, {3.9047534739781313`*^9, 
   3.9047534918828278`*^9}, {3.904753543048904*^9, 3.904753543849313*^9}, {
   3.904753725468136*^9, 3.904753811511589*^9}, {3.904753974205056*^9, 
   3.9047541789348297`*^9}, {3.904754899423904*^9, 3.904754934771824*^9}, {
   3.904755038308757*^9, 3.904755091442843*^9}, {3.9047551415748987`*^9, 
   3.9047551443309*^9}, {3.9047553149116163`*^9, 3.9047553319981728`*^9}, {
   3.904755397928883*^9, 3.904755489015327*^9}, {3.904755763934249*^9, 
   3.904755796413554*^9}, {3.904755853548477*^9, 3.9047559043795567`*^9}, {
   3.904755998192665*^9, 3.90475601222373*^9}, {3.904756414014934*^9, 
   3.904756485836141*^9}, {3.9047565990501747`*^9, 3.904756599905182*^9}, 
   3.904756639367188*^9, {3.90475708028258*^9, 3.9047570824628153`*^9}, {
   3.9047571427515163`*^9, 3.904757164249547*^9}, {3.904757207577874*^9, 
   3.9047572099942493`*^9}, {3.904757249603448*^9, 3.904757292733881*^9}, 
   3.904757377047662*^9, {3.904757686331232*^9, 3.904757742961905*^9}, {
   3.90475792798885*^9, 3.904757928201045*^9}, {3.904758502975746*^9, 
   3.9047585802695704`*^9}, {3.90475864898275*^9, 3.9047586513397093`*^9}, {
   3.904758852990497*^9, 3.904758856546152*^9}, {3.90488661413291*^9, 
   3.904886638514804*^9}, {3.9048866915793247`*^9, 3.904886692760459*^9}, {
   3.904887828866548*^9, 3.90488785382589*^9}, {3.9049039412513523`*^9, 
   3.90490394340469*^9}, {3.904971605223482*^9, 3.9049717129583893`*^9}, 
   3.904977612085688*^9},
 CellLabel->
  "In[180]:=",ExpressionUUID->"1f605237-06e1-4004-a2c0-dcfd70672f09"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"boundary", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"side", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q", "[", "z_", "]"}], ":=", 
   RowBox[{"Clip", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "boundary"}], ",", "boundary"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{"1.5", ",", "1.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstep", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Nu]", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Tau]2", "=", "0.99"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"parameter", " ", "for", " ", "EG"}], "+", " ", "Adaptive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]0", "=", 
    RowBox[{"1", "/", "2"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"parameter", " ", "for", " ", "EG"}], "+", " ", "Adaptive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phi", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "2"], "/", "4"}], "-", 
   RowBox[{
    SuperscriptBox["z", "4"], "/", "2"}], "+", 
   RowBox[{
    SuperscriptBox["z", "6"], "/", "6"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Forsaken", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"y", "-", "0.45"}], ")"}]}], "+", 
   RowBox[{"phi", "[", "x", "]"}], "-", 
   RowBox[{"phi", "[", "y", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"Forsaken", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"Forsaken", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", 
   RowBox[{"-", "1.520566154622644"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", "12.402569242368003"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]1", "=", 
   RowBox[{"1", "/", "L"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]2", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"nstep", "*", "L"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Gamma]1"}], "/", "2"}], "*", "0.99"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]2", "=", 
   RowBox[{
    RowBox[{"-", "nstep"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"1", "/", "nstep"}]}], ")"}], "^", "nstep"}]}]}], ")"}], 
    "*", "\[Gamma]2", "*", "0.99"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]3", "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "/", "L"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Sigma]1", "=", "\[Rho]"}], ";", 
    RowBox[{"\[Sigma]2", "=", "\[Rho]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]3", "=", "\[Rho]"}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.904677921084033*^9, 3.904678026828352*^9}, {
   3.904678080679626*^9, 3.90467810349658*^9}, {3.904678141222587*^9, 
   3.9046781418313828`*^9}, {3.904678222000551*^9, 3.904678231162981*^9}, {
   3.904678781141758*^9, 3.9046787926355553`*^9}, {3.9046788538632708`*^9, 
   3.904678859075272*^9}, {3.904679059951167*^9, 3.904679113810698*^9}, {
   3.9046793825694733`*^9, 3.9046793852082663`*^9}, {3.904679681841154*^9, 
   3.9046796833506927`*^9}, {3.904680799914598*^9, 3.9046808123573112`*^9}, {
   3.90468092449886*^9, 3.904680958283567*^9}, {3.904681004662218*^9, 
   3.9046810407866917`*^9}, {3.904681072210801*^9, 3.9046810840092087`*^9}, {
   3.9046811546764708`*^9, 3.904681157595323*^9}, {3.904681188572945*^9, 
   3.9046811907325068`*^9}, {3.9046812217801857`*^9, 3.904681223984742*^9}, 
   3.904681414078163*^9, {3.904681453782587*^9, 3.904681454953491*^9}, {
   3.90468148519704*^9, 3.904681485730461*^9}, {3.904681727938191*^9, 
   3.9046817489492617`*^9}, {3.904681818881843*^9, 3.904681849158907*^9}, {
   3.904681879413641*^9, 3.904681899441991*^9}, {3.904681944777953*^9, 
   3.9046819512827177`*^9}, {3.904681987824791*^9, 3.904682008230101*^9}, {
   3.904682156534088*^9, 3.904682156917536*^9}, {3.904682434893135*^9, 
   3.904682443384974*^9}, {3.9046825441818533`*^9, 3.904682545710216*^9}, {
   3.90468280823776*^9, 3.904682809674079*^9}, 3.9046830139408712`*^9, {
   3.904683177403406*^9, 3.9046832204172287`*^9}, {3.904683277025416*^9, 
   3.904683296740877*^9}, {3.904683326754285*^9, 3.904683347022284*^9}, {
   3.904683390414177*^9, 3.904683394677227*^9}, {3.904683504772533*^9, 
   3.9046835528552647`*^9}, {3.904683654705864*^9, 3.904683655565941*^9}, {
   3.9046838602696533`*^9, 3.904684009107777*^9}, {3.904684051151514*^9, 
   3.9046840866250467`*^9}, {3.904684153323841*^9, 3.9046841696492167`*^9}, {
   3.904684285255888*^9, 3.904684285385824*^9}, 3.904684417527142*^9, {
   3.904684466829834*^9, 3.904684490148085*^9}, {3.904684524505808*^9, 
   3.9046845248*^9}, {3.904684669758772*^9, 3.90468467402182*^9}, 
   3.9046881223396187`*^9, {3.904734737560341*^9, 3.9047347392433023`*^9}, {
   3.904734785145533*^9, 3.904734796377079*^9}, {3.904734896558742*^9, 
   3.9047348978354797`*^9}, {3.904734982583982*^9, 3.9047349839834642`*^9}, {
   3.904735028556096*^9, 3.904735030025326*^9}, {3.904735144343172*^9, 
   3.9047351474329844`*^9}, {3.904735206027533*^9, 3.904735206976282*^9}, 
   3.9047352475543747`*^9, 3.9047354845742283`*^9, {3.904736280624053*^9, 
   3.9047362835441732`*^9}, 3.9047363306967087`*^9, {3.904736378535879*^9, 
   3.904736441000154*^9}, {3.904736530060334*^9, 3.9047365302282352`*^9}, {
   3.9047368622914743`*^9, 3.9047368655947247`*^9}, {3.904736950638896*^9, 
   3.904736950863553*^9}, {3.904737126470788*^9, 3.904737128731061*^9}, {
   3.904737246510984*^9, 3.904737278159433*^9}, 3.9047373233020153`*^9, 
   3.9047394907032223`*^9, {3.904746738433794*^9, 3.904746739110612*^9}, {
   3.904746807614609*^9, 3.9047468300837717`*^9}, {3.904747422594507*^9, 
   3.9047474551849003`*^9}, {3.904747501737113*^9, 3.9047475277086077`*^9}, 
   3.904747663650281*^9, {3.904747859349414*^9, 3.9047478615259113`*^9}, {
   3.9047514564507723`*^9, 3.9047514838064423`*^9}, {3.9047518108952703`*^9, 
   3.904751836858994*^9}, {3.90475330672198*^9, 3.9047533115162897`*^9}, {
   3.9047535808687696`*^9, 3.904753718909051*^9}, {3.904754100825182*^9, 
   3.904754106083592*^9}, {3.904754459197925*^9, 3.904754459573647*^9}, {
   3.90475483916545*^9, 3.904754840090962*^9}, {3.904755009743355*^9, 
   3.904755010456757*^9}, {3.904755614737412*^9, 3.9047556150253963`*^9}, {
   3.904757405912719*^9, 3.904757406012788*^9}, 3.9047586894128237`*^9, {
   3.904758766607869*^9, 3.9047587675008593`*^9}, 3.90476013358971*^9, {
   3.904760169708099*^9, 3.904760186235372*^9}, {3.90476181171515*^9, 
   3.9047618218265257`*^9}, {3.904886544962195*^9, 3.904886551518928*^9}, {
   3.904886677645721*^9, 3.904886682687286*^9}, {3.904886763716065*^9, 
   3.9048867705183163`*^9}, {3.904887818485471*^9, 3.904887818554552*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"07fe36ad-9c3f-4298-a221-e9ceb5f6393c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AEGPlusIterates", "=", 
   RowBox[{"AEGPlus", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGnIterates", "=", 
   RowBox[{"EGn", "[", 
    RowBox[{"W", ",", "init", ",", "T", ",", "nstep"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEGIterates", "=", 
   RowBox[{"MDEG", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CurvatureEGPlusIterates", "=", 
   RowBox[{"CurvatureEGPlus", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGPlusAdaptiveIterates", "=", 
   RowBox[{"EGPlusAdaptive", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legends", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<AdaptiveEG+\>\"", ",", 
     RowBox[{"StringForm", "[", 
      RowBox[{"\"\<`1`-step EG\>\"", ",", "nstep"}], "]"}], ",", 
     "\"\<MDEG\>\"", ",", "\"\<CurvatureEG+\>\"", ",", 
     "\"\<EG+ Adaptive\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iterates", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"First", ",", 
     RowBox[{"{", 
      RowBox[{
      "AEGPlusIterates", ",", "EGnIterates", ",", "MDEGIterates", ",", 
       "CurvatureEGPlusIterates", ",", "EGPlusAdaptiveIterates"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotIterates", "[", 
  RowBox[{"W", ",", "iterates", ",", "legends"}], "]"}]}], "Input",
 CellChangeTimes->{{3.904678811815544*^9, 3.904678842713599*^9}, 
   3.9046790092753677`*^9, {3.9046793515043993`*^9, 3.90467935634138*^9}, {
   3.904679638797206*^9, 3.9046796574539213`*^9}, {3.904680533522923*^9, 
   3.90468053374251*^9}, {3.904681293207996*^9, 3.904681313081657*^9}, {
   3.9046813595563927`*^9, 3.904681390103552*^9}, {3.904681933549253*^9, 
   3.904681963265789*^9}, {3.904682019067993*^9, 3.9046820192078247`*^9}, {
   3.904682118089205*^9, 3.9046821370254793`*^9}, {3.904682891951832*^9, 
   3.904682899899241*^9}, {3.904683304722539*^9, 3.904683323673231*^9}, {
   3.904683403268262*^9, 3.9046834102693453`*^9}, {3.9046835355936613`*^9, 
   3.904683540101819*^9}, 3.9046836857263613`*^9, {3.904684075378223*^9, 
   3.904684076310137*^9}, 3.904684132907564*^9, {3.9046844564707823`*^9, 
   3.904684460002019*^9}, {3.9046852761787577`*^9, 3.9046852981133204`*^9}, {
   3.90468692052129*^9, 3.904686958567831*^9}, {3.90468703457903*^9, 
   3.9046870435537558`*^9}, {3.9047355331083603`*^9, 
   3.9047355579555817`*^9}, {3.904735652948854*^9, 3.904735657562101*^9}, {
   3.904736044372192*^9, 3.904736050055399*^9}, {3.904736258431449*^9, 
   3.904736259594943*^9}, {3.904736308931514*^9, 3.9047363168086557`*^9}, {
   3.904736873678523*^9, 3.9047369176186657`*^9}, {3.9047397729742727`*^9, 
   3.9047397733411407`*^9}, {3.904741943407835*^9, 3.904741954887806*^9}, {
   3.904743753683152*^9, 3.904743753943836*^9}, {3.904754187944406*^9, 
   3.904754238639337*^9}, {3.904754331479926*^9, 3.9047543354660254`*^9}, {
   3.904755236535652*^9, 3.904755251788733*^9}, {3.904757311195786*^9, 
   3.9047573113772984`*^9}, {3.904760277842126*^9, 3.90476027834962*^9}, 
   3.904760557823412*^9},
 CellLabel->
  "In[212]:=",ExpressionUUID->"9f1bf222-de69-49af-9d91-79ef34383170"],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{{3.904737147040823*^9, 3.904737172303227*^9}, {
   3.904737256218267*^9, 3.904737282022172*^9}, 3.904737327525297*^9, 
   3.9047394938386908`*^9, 3.904739564280499*^9, 3.904739594389512*^9, {
   3.904739636109906*^9, 3.9047396602632103`*^9}, {3.9047396962767353`*^9, 
   3.904739775330353*^9}, 3.904740144574538*^9, 3.904740652908476*^9, 
   3.904740698988194*^9, 3.904740782494197*^9, 3.9047408128631277`*^9, 
   3.904741696460966*^9, 3.904741769730844*^9, 3.904742047744711*^9, 
   3.904742078093483*^9, 3.904742137038603*^9, 3.9047422232193193`*^9, 
   3.904742277703443*^9, 3.904742574193453*^9, 3.904742891835617*^9, 
   3.904743756423622*^9, 3.904743946053114*^9, 3.904744055402852*^9, 
   3.904746045464177*^9, 3.9047462513489513`*^9, 3.904746291692966*^9, 
   3.90474639590012*^9, 3.904746431748452*^9, 3.9047464663059187`*^9, 
   3.9047465007139473`*^9, 3.904746550799366*^9, 3.90474674306252*^9, {
   3.904746813558326*^9, 3.904746835678409*^9}, {3.9047475069256487`*^9, 
   3.904747531118286*^9}, 3.904747671728022*^9, 3.904747865666471*^9, {
   3.9047514617329693`*^9, 3.9047514887979193`*^9}, {3.904751817282382*^9, 
   3.904751840544046*^9}, 3.904753317997118*^9, {3.9047542462955008`*^9, 
   3.904754275046647*^9}, 3.904755124198184*^9, 3.9047551908844*^9, 
   3.904755252211651*^9, 3.904757172181535*^9, 3.904757317306972*^9, {
   3.904757382021841*^9, 3.9047574106819277`*^9}, {3.904758693707893*^9, 
   3.9047587035543547`*^9}, 3.904758772906743*^9, 3.904758898270492*^9, 
   3.904760138341383*^9, 3.904760194432006*^9, 3.904760280939166*^9, 
   3.90476053167564*^9, 3.904760592313108*^9, 3.904763764160033*^9, 
   3.9047643234970217`*^9, {3.904886557199256*^9, 3.904886582052844*^9}, {
   3.904886624675445*^9, 3.9048866484093924`*^9}, 3.9048867057684717`*^9, 
   3.904886775539568*^9, 3.9049775895764513`*^9, 3.904978181747085*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[212]:=",ExpressionUUID->"406ae73c-87e9-4dd6-\
ae01-465f190b2cc0"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{}}, {{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.12702486321737294`, 
            0.6825502504445621}, {-0.15859867017162593`, 
            0.6835370446319317}, {-0.21401826075772262`, 
            0.6657984934378398}, {-0.2380222408332284, 
            0.6414453595762437}, {-0.2547094630415601, 
            0.6057462889216412}, {-0.26181673868907707`, 
            0.5584941055939887}, {-0.2598446627503448, 
            0.5297250019187422}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.25943433527913057`, 
            0.5237390490817774}, {-0.25791901982696025`, 
            0.5016332738994}, {-0.2514094962393709, 
            0.47080569799478694`}, {-0.24162817456587132`, 
            0.4390232596947784}, {-0.22880215066296467`, 
            0.40688671154917094`}, {-0.2131585203871542, 
            0.37499680610776115`}, {-0.1947649412367179, 
            0.3442157824300341}, {-0.17381662139651394`, 
            0.31519669036772385`}, {-0.1664612117240181, 
            0.3066032351256413}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1625596473328543, 
            0.30204496842637907`}, {-0.15073198275291547`, 
            0.2882264986590003}, {-0.1259294471922968, 
            0.26359217604203433`}, {-0.09312421598638322, 
            0.23687348261877464`}, {-0.05925305727019924, 
            0.21533294264796027`}, {-0.024882565713048088`, 
            0.1987566945120675}, {0.00942066401576676, 0.1869308765935728}, {
            0.038719214347980216`, 0.18066747971693173`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.044621167813129824`, 0.17964728019157278`}, {
            0.07457469463138554, 0.17717818734714275`}, {0.1326605419020214, 
            0.18386087956002034`}, {0.18176527201549197`, 
            0.20350306303247265`}, {0.22064189215386734`, 
            0.2331402276330914}, {0.24746186662247488`, 0.2679445395556307}, {
            0.24970005873744622`, 0.273256332125808}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.25202985767052316`, 0.278785530705298}, {
            0.2640827492591745, 0.3073900725413197}, {0.2699164237139695, 
            0.3499818330252841}, {0.26481629075129015`, 0.3945048375436299}, {
            0.24879441673249453`, 0.4399353658958868}, {0.22242857105393876`, 
            0.4854271915566973}, {0.20967108126283834`, 
            0.5013500737350743}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.20591947206432798`, 0.5060325333901757}, {
            0.1864471706940415, 0.5303363083128266}, {0.14240874353709157`, 
            0.5739692566770221}, {0.11043817119415812`, 0.6014632342016905}, {
            0.0763428778598409, 0.6280441725908175}, {0.0405953006151685, 
            0.6535369780130068}, {0.025914832286674835`, 
            0.6631694278932763}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.020898292873663193`, 0.6664609825894192}, {
            0.0036678765411700814`, 
            0.6777665566368616}, {-0.034112768533399604`, 
            0.7004658123477601}, {-0.07242000877978581, 
            0.7213676490310804}, {-0.108990115518863, 
            0.7391070314723186}, {-0.14571321949913765`, 
            0.7544731640150639}, {-0.18246960303747548`, 
            0.7668806204092751}, {-0.19455150206311064`, 
            0.769800890586852}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.20038356016642647`, 
            0.7712105353220772}, {-0.21913954845074224`, 
            0.7757439744049112}, {-0.2555496205733007, 
            0.780231196769123}, {-0.2915263842395138, 
            0.7795102582690621}, {-0.35115222665010254`, 
            0.763975204086384}, {-0.37961611811050056`, 
            0.7474902559589645}, {-0.40647719011729805`, 
            0.7240181274109208}, {-0.41737440178173607`, 
            0.7098760365817244}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.42103660916071356`, 
            0.705123328184046}, {-0.43087071219660067`, 
            0.692360909444301}, {-0.4516989216323925, 
            0.6519047525547086}, {-0.46779267834338545`, 
            0.6017281589184296}, {-0.477659532494593, 
            0.5426930463374974}, {-0.4796383972500232, 
            0.47892844596632655`}, {-0.47950853699933327`, 
            0.4768909347121198}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.479126902893057, 
            0.4709030840619343}, {-0.47748131385732473`, 
            0.4450837424058853}, {-0.47301551239650086`, 
            0.4103790799920948}, {-0.4661308214838272, 
            0.37522717015072293`}, {-0.4567170697355791, 
            0.3400407243075375}, {-0.4445118816650327, 
            0.305198765389597}, {-0.4296966848202046, 
            0.2712108247685608}, {-0.41427939553951076`, 
            0.24214757119325292`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4114676740648869, 
            0.2368471728733963}, {-0.4099070271751887, 
            0.2339051851172469}, {-0.38693055698156814`, 
            0.19863028723400758`}, {-0.3608890042001242, 
            0.16579850923402806`}, {-0.33220394188972, 
            0.13570419882694174`}, {-0.2859200981409383, 
            0.09634687979356349}, {-0.24371150523839577`, 
            0.06892225244667696}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.23868024676819655`, 
            0.06565324063788083}, {-0.2359695645373219, 
            0.06389200092517092}, {-0.18382952089991417`, 
            0.03832230901691595}, {-0.13097714704975855`, 
            0.019620550863950557`}, {-0.07854983649523416, 
            0.007402771600997766}, {-0.027684982744720244`, 
            0.0012850163627805844`}, {-0.01374698247166773, 
            0.0004312801241994286}, {-0.010144885364869563`, 
            0.0003210699871842862}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.0041476917593835224`, 0.0001375792290590954}, {
            7.858835603125435*^-6, 0.000010435571665048216`}, {
            0.027784663601900825`, 0.001734115412072282}, {
            0.054512219780927226`, 0.005060506629221975}, {
            0.10585056831251305`, 0.014687366698048904`}, {0.152901256405968, 
            0.029816154122576204`}, {0.19563731280240637`, 
            0.04958662793466012}, {0.22276739769683374`, 
            0.06717883331732143}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.22780164720105006`, 0.07044323708053728}, {
            0.24751523587496224`, 0.08322629699834844}, {0.29165543283178064`,
             0.12240642112923242`}, {0.32824309171944716`, 
            0.16558267590259984`}, {0.3573911361416318, 
            0.21197258188845058`}, {0.3760074067150763, 
            0.2541499785204506}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3784301843176745, 0.25963907213309273`}, {
            0.3789528101601851, 0.2608231437419974}, {0.3924855460736807, 
            0.3117917727010221}, {0.39741037663042156`, 0.3646795885397622}, {
            0.3928640291468017, 0.4196366228601952}, {0.38403958862784504`, 
            0.4580732189388927}, {0.37149971571979173`, 
            0.49423381662901456`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3693244847405995, 0.49981822657350855`}, {
            0.35135551620272293`, 0.53873618758482}, {0.32701701059027577`, 
            0.5811505919594641}, {0.2973590530197779, 0.6251957241046834}, {
            0.2626619987199939, 0.6711490797112754}, {0.23874811937048504`, 
            0.7001019097700374}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.23492717980066005`, 0.7047279686546329}, {
            0.2229699337915496, 0.7192047545668148}, {0.2012645492480255, 
            0.7440816166465566}, {0.17832694433507099`, 0.7695568444588757}, {
            0.154257106632558, 0.7954883861631993}, {0.129184093510295, 
            0.8216830164377178}, {0.10315702041576495`, 0.8480882370340226}, {
            0.07622500279645088, 0.8746515497037053}, {0.07089792746720879, 
            0.8797641183527483}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.06656902561252838, 0.883918707229225}, {
            0.04843715609983576, 0.9013204561983577}, {0.01984259577340264, 
            0.9280424582695714}, {-0.009509562735365495, 
            0.9547650576689377}, {-0.03957020397898544, 
            0.9814357561480485}, {-0.07507834023038057, 
            1.0111080170875675`}, {-0.11133907169021579`, 
            1.0385780874480546`}, {-0.11471320695834421`, 
            1.040881507648177}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.11966860598620503`, 
            1.0442644088401536`}, {-0.14835239835849143`, 
            1.0638459672295093`}, {-0.1861183202352074, 
            1.086911656431932}, {-0.22464605080695024`, 
            1.1071237367553661`}, {-0.2639448035603067, 
            1.1238307898998559`}, {-0.3040145784952764, 
            1.1370328158654008`}, {-0.3357504291718867, 
            1.1445679896923058`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3415881349254546, 
            1.1459540602297462`}, {-0.34485537561185997`, 
            1.146729814652001}, {-0.3868413952778582, 
            1.153069722355517}, {-0.4303468378610722, 
            1.1562004750718096`}, {-0.475371703361502, 
            1.1561220728008779`}, {-0.5219159917791483, 
            1.1528345155427224`}, {-0.5619098502398333, 
            1.1478393873437205`}, {-0.5802350637267606, 
            1.1448204500925276`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.586155264373206, 
            1.1438451428046295`}, {-0.6039331499571183, 
            1.1409163735941097`}, {-0.6479858909310025, 
            1.13206547429389}, {-0.6940680731614851, 
            1.1212866894430618`}, {-0.7425460527256532, 
            1.108247617830295}, {-0.7937861857005939, 
            1.092615858244259}, {-0.8183747490453251, 
            1.0843178210086868`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.8240597449519063, 
            1.0823992742820845`}, {-0.8477884720863061, 
            1.074391410684955}, {-0.9045529118827895, 
            1.0535742751523827`}, {-0.9434425407039863, 
            1.0379540305662016`}, {-0.9824989640707504, 
            1.0206103037306546`}, {-1.0217221819830826`, 
            1.0015430946457413`}, {-1.044927717914088, 
            0.9892948341176769}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.0502339420114841`, 
            0.9864941224530795}, {-1.0611121944409831`, 
            0.9807524033114617}, {-1.091803193078534, 
            0.9628639277482298}, {-1.1211732493093378`, 
            0.9435930764373166}, {-1.1492223631333949`, 
            0.9229398493787231}, {-1.1759505345507038`, 
            0.9009042465724494}, {-1.2008123191506175`, 
            0.877391340047695}, {-1.2232622725224873`, 
            0.8523062018336595}, {-1.2350941737920498`, 
            0.8365658362176411}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2386993641893929`, 
            0.8317697334040115}, {-1.243300394666313, 
            0.8256488319303428}, {-1.2609266855820955`, 
            0.7974192303377442}, {-1.276113087850166, 
            0.7676135662421683}, {-1.2888315440508564`, 
            0.7362280088299192}, {-1.2990820541841677`, 
            0.7032625581009968}, {-1.306864618250099, 
            0.6687172140554005}, {-1.3126230593539194`, 
            0.6322981735562658}, {-1.3152622429984557`, 
            0.6074972539828246}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3158971467590541`, 
            0.6015309404464122}, {-1.3166321913884829`, 
            0.594623583781371}, {-1.3188920143537899`, 
            0.5556934447307162}, {-1.3194025282498396`, 
            0.5155077564043026}, {-1.3185807791559196`, 
            0.4744443882123609}, {-1.3168438131513167`, 
            0.43288120956512544`}, {-1.3141916302360308`, 
            0.3908182204625959}, {-1.3117651897935367`, 
            0.3618682559979823}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3112640571007375`, 
            0.35588922045500315`}, {-1.310624230410062, 
            0.34825542090477213`}, {-1.3063457497112008`, 
            0.30558743634821667`}, {-1.301560324177237, 
            0.2632088922494883}, {-1.2962679538081718`, 
            0.2211197886085884}, {-1.2904686386040043`, 
            0.179320125425517}, {-1.284229044831124, 
            0.1380334538038864}, {-1.2809400522772996`, 
            0.11786637135126758`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.2799742883475627`, 
            0.11194460640895358`}, {-1.2776158387559198`, 
            0.09748332484730884}, {-1.2706290203783928`, 
            0.05766973855578445}, {-1.2632685896985416`, 
            0.018592694929314355`}, {-1.2555614158730553`, \
-0.019725635002736}, {-1.247534368058621, -0.057263080211001086`}, \
{-1.2391874462552397`, -0.09401964069547977}, {-1.2321618896601816`, \
-0.1231825692054506}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2307566494003603`, -0.12901569013786554`}, \
{-1.2305206504629107`, -0.12999531645617196`}, {-1.2215263009203954`, \
-0.1652984780103835}, {-1.212196717866454, -0.2000374958754201}, \
{-1.2025319013010878`, -0.23421237005128184`}, {-1.192531851224296, \
-0.2678231005379676}, {-1.1770250402494917`, -0.3167806282224171}, \
{-1.1626397679407676`, -0.35905484901301904`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1607069018242617`, -0.3647349923717436}, \
{-1.160464940863989, -0.36544604676388504`}, {-1.142851553067789, \
-0.4138193561623707}, {-1.124184876860891, -0.46190055641787386`}, \
{-1.1040362131616843`, -0.5103060802808613}, {-1.0819768628885578`, \
-0.5596523605017997}, {-1.0691943989092314`, -0.586468849679451}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.06661270552024, -0.5918850161507883}, \
{-1.0580068260415114`, -0.6099393970806891}, {-1.0321261026205455`, \
-0.6611671900175284}, {-1.0035151981848374`, -0.7136535338749181}, \
{-0.9713546182935636, -0.7677162232154584}, {-0.9539432000520901, \
-0.79533869744191}, {-0.9499677455445682, -0.8014253444495987}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9466867220739432, -0.8064487780348278}, \
{-0.9356443629467251, -0.8233552580391488}, {-0.9164581069774691, \
-0.851765905007175}, {-0.8963844321443216, -0.8805706383459886}, \
{-0.8662364443963908, -0.9212539947673799}, {-0.8334711411961713, \
-0.9617740021490843}, {-0.8020453809459257, -0.9976175523965279}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.7980898887703323, -1.0021291022021734`}, \
{-0.7980885225436631, -1.0021306604911018`}, {-0.7600885884388654, \
-1.0423239697934332`}, {-0.7194033836014228, -1.0812955898806962`}, \
{-0.67596495275098, -1.1179871805775083`}, {-0.6297732958875359, \
-1.152398741883871}, {-0.6181662167447372, -1.160018603491648}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6131504676928355, -1.1633113624333788`}, \
{-0.5808284130110888, -1.184530273799785}, {-0.5296497638578531, \
-1.2136479968931089`}, {-0.4767568081640434, -1.2390181317317013`}, \
{-0.42214954592965814`, -1.2606406783155633`}, {-0.398265306570969, \
-1.2682208965613548`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.39254641735623547`, -1.27003591891648}, \
{-0.3658279771546955, -1.2785156366446953`}, {-0.3198759127445309, \
-1.2902367233315324`}, {-0.273763781049976, -1.2997258909908216`}, \
{-0.22749158207103104`, -1.3069831396225633`}, {-0.1810593158076963, \
-1.3120084692267568`}, {-0.15719201870802005`, -1.3136721707497463`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.15120654271503536`, -1.3140893962731794`}, \
{-0.13477609810288127`, -1.3152347021538777`}, {-0.08895104479950026, \
-1.3170946607544016`}, {-0.043584155897551526`, -1.317588345028328}, {
            0.001324568602964954, -1.316715754975657}, {
            0.04572315922159654, -1.3148042473220076`}, {
            0.08858689651094387, -1.3122393857795664`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.09457030220037646, -1.311795068618714}, {
            0.13283403037184713`, -1.3088465493886308`}, {
            0.17554631090346767`, -1.3048003591089028`}, {
            0.22586044353959586`, -1.2992543273464014`}, {
            0.27588381217998037`, -1.2930859408960527`}, {
            0.3256164168246228, -1.2862951997578564`}, {
            0.333037592946179, -1.2851825006955033`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.33897126704302744`, -1.2842928312555484`}, {
            0.37505825747352456`, -1.2788821039318121`}, {
            0.42467524428619324`, -1.2708879233811174`}, {
            0.47493328742213636`, -1.2623539280689702`}, {
            0.5258323868813556, -1.2532801179953696`}, {
            0.5755486645284549, -1.2440066954719375`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5814408906959706, -1.242874792593873}, {
            0.6300420003060615, -1.2334170161931646`}, {
            0.684329005344418, -1.2224356497232733`}, {
            0.7402335577789233, -1.2107223937506426`}, {
            0.7977556576095768, -1.198277248275271}, {
            0.8164260720849787, -1.194112865501307}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.8222821696294482, -1.1928066796226284`}, {
            0.8326240967182723, -1.1904999422400688`}, {
            0.8678278305451336, -1.18239509670622}, {
            0.903360551060283, -1.1739409145923483`}, {
            0.939215950233843, -1.1651155988170765`}, {
            0.9753877200359355, -1.1558973522990281`}, {
            1.0118695524366834`, -1.1462643779568267`}, {
            1.0486551394062082`, -1.1361948787090954`}, {
            1.055033220383182, -1.1343841504597365`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.0608051242276253`, -1.1327455150486392`}, {
            1.0857381729146331`, -1.1256670574744574`}, {
            1.1227586831027647`, -1.1146564995551533`}, {
            1.1590030382820944`, -1.1031361726370412`}, {
            1.194046707272853, -1.091095259333493}, {
            1.227577428489352, -1.0785378483772043`}, {
            1.2592515048521271`, -1.0654632112094018`}, {
            1.2867725067758637`, -1.0527842597341337`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.2920898721794871`, -1.050013496280193}, {
            1.3403004664001759`, -1.0231686287531958`}, {
            1.3814513738235554`, -0.9924773020912468}, {
            1.4121614257933512`, -0.9598483454732761}, {
            1.433334837492728, -0.9253186703041483}, {
            1.447230073669648, -0.8889127864731502}, {
            1.4492075879163826`, -0.8799240939831319}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.450496759793225, -0.8740642274426756}, {
            1.455652464719626, -0.8506292275536925}, {
            1.4606313314681285`, -0.8104343500455208}, {
            1.4633494771691506`, -0.7682849050521277}, {
            1.464255182720192, -0.7241119497439177}, {
            1.4639902823107245`, -0.6894393797225671}, {
            1.4627862676155088`, -0.6536123260161593}, {
            1.4618231971017928`, -0.6350749174408309}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4615119000532364`, -0.6290829983703193}, {
            1.4608686298691977`, -0.6167011820276722}, {
            1.4584628603064445`, -0.5787763411600836}, {
            1.4556943936170472`, -0.5399501767826131}, {
            1.4526886644908041`, -0.5003350622644803}, {
            1.4494796288843441`, -0.4601587509433629}, {
            1.4460880570888128`, -0.4194801446141478}, {
            1.443508762317786, -0.3897692098601136}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4429898362116402`, -0.38379169234057753`}, {
            1.4425267260668602`, -0.378457119708535}, {
            1.4388084127811362`, -0.33724755265821915`}, {
            1.4349499180651881`, -0.29600328458824043`}, {
            1.430968042752563, -0.2548761566236338}, {
            1.426972404031183, -0.21493570168370532`}, {
            1.4228665842265633`, -0.17514578107471618`}, {
            1.419653889083354, -0.14493253665116881`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.4190194617091572`, -0.1389661724394508}, {
            1.4186643234865264`, -0.13562633549688638`}, {
            1.414379361958896, -0.09649730565043621}, {
            1.4100254397914944`, -0.057878632235585654`}, {
            1.4056162971321453`, -0.019890255952554805`}, {1.40116567412867, 
            0.017347882498438688`}, {1.396687310928893, 
            0.05371584241716965}, {1.390883769529806, 
            0.09937432395986688}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.390119902915453, 0.10532549110051957`}, {
            1.3839749001930854`, 0.15221342566298188`}, {1.377523637371188, 
            0.20012890658070778`}, {1.3710233468455082`, 
            0.24729854332704457`}, {1.3644653978349914`, 
            0.2939470996607394}, {1.3578300802841752`, 
            0.34036647736036746`}, {1.3574360740740383`, 
            0.3430874779355068}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.3565762300004283`, 0.34902554733296903`}, {
            1.3511115332306074`, 0.38676465567971907`}, {1.3443038957118352`, 
            0.43334961387258464`}, {1.337350975809509, 
            0.48042147442974314`}, {1.3301678210590504`, 
            0.5283330131202606}, {1.3227054296786669`, 0.5773711891153455}, {
            1.3213082638461155`, 0.5864191729843011}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.3203926120720806`, 0.5923488931993456}, {
            1.3149147998865645`, 0.6278229615862082}, {1.3067284646278745`, 
            0.6799514741663552}, {1.2980684052631135`, 0.7340062616106046}, {
            1.2888697926335655`, 0.7902538697721349}, {1.2823483989182813`, 
            0.8293123771462461}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.28136028866363, 0.8352304543783082}, {
            1.2790677975805158`, 0.8489608445041247}, {1.268557186900479, 
            0.9099748285508031}, {1.2573276150883426`, 0.9722069627380749}, {
            1.2453203643286417`, 1.0353265904372007`}, {1.2380683722897203`, 
            1.0712806458097}}]}, {
           Arrowheads[{{0.01999999999999999, 1.}}], 
           
           ArrowBox[{{1.2368820536869904`, 1.0771621973203829`}, {
            1.2324767168059125`, 1.0990030550194405`}, {1.223235259643004, 
            1.141937639074281}, {1.215236948731389, 1.1761288391364895`}, {
            1.2069720427155735`, 1.2089312925176998`}, {1.1897385149115216`, 
            1.2688127731747936`}, {1.1754705117453528`, 
            1.3088965722577965`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.1734584525785159`, 1.3145491484765792`}, {
            1.171698527474471, 1.3194933921419398`}, {1.1530542197617244`, 
            1.3598711305934221`}, {1.1319601573689482`, 
            1.3932767228648306`}, {1.1105259252838013`, 
            1.4156941206752338`}, {1.067300436612837, 1.439792402508421}, {
            1.0233449985390128`, 1.4468419875441338`}, {0.9976020636562407, 
            1.4463566733951305`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9916050559989247, 1.4461779146239824`}, {
            0.9653325266093912, 1.4451315413776233`}, {0.934746585538384, 
            1.443351457939841}, {0.9022602645509294, 1.440909981184253}, {
            0.8678413596170131, 1.437993886423205}, {0.8311550412809476, 
            1.4347188686788122`}, {0.7985667354329702, 1.4317286675946783`}, {
            0.7640226801658898, 1.428496977819458}, {0.7523787815431557, 
            1.4273890775718043`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.7464057582589179, 1.4268207529762151`}, {
            0.7274236628141972, 1.4250146338295635`}, {0.6886704707123861, 
            1.4212724701014081`}, {0.6477858812334222, 1.4172565761883265`}, {
            0.6047926717502686, 1.4129530416436538`}, {0.562659742085417, 
            1.40863994234162}, {0.5189758369341929, 1.404052134939244}, {
            0.5076100228867757, 1.4028233954298734`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5016447807615342, 1.4021785028905738`}, {
            0.4740136156835526, 1.399191342966998}, {0.428045737720452, 
            1.3940592899553537`}, {0.38141465382542394`, 
            1.3886689757046347`}, {0.3344628147790006, 1.383033400015163}, {
            0.2831238972304674, 1.3766321744897687`}, {0.2633034942301193, 
            1.3740532892849546`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2573536462488289, 1.3732791387830918`}, {
            0.2320459160347847, 1.3699862828802485`}, {0.18173737157520864`, 
            1.363122292359576}, {0.1327067642349952, 1.3560667701007258`}, {
            0.08506348491812366, 1.348831800510986}, {0.03868886196898663, 
            1.3414211921315395`}, {0.019937013629275465`, 
            1.3382615983494532`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.014020413693803047`, 
            1.3372646804974877`}, {-0.006250698068539807, 
            1.3338490983362008`}, {-0.04958878865057961, 
            1.3261296724987852`}, {-0.09143104287933718, 
            1.3182983288110284`}, {-0.13203854508334856`, 
            1.3104026305034773`}, {-0.17147806555823514`, 
            1.3024749545081649`}, {-0.2098163745996183, 
            1.2945476777571236`}, {-0.22166008708204882`, 
            1.2920296869549792`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.22752891906948658`, 
            1.2907819645887346`}, {-0.24723607488228727`, 
            1.286592194096866}, {-0.2839859590119842, 
            1.2785450498964643`}, {-0.32023208218076, 
            1.2703863508717907`}, {-0.35614049958066557`, 
            1.262096202738718}, {-0.4032829777036802, 
            1.2508462340204076`}, {-0.45078469347535666`, 
            1.2390238323732785`}, {-0.46124765971472237`, 
            1.23631167404733}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.46705570347463266`, 
            1.2348061416886715`}, {-0.4991170726191883, 
            1.226495352255025}, {-0.5487515408586686, 
            1.2131271481233414`}, {-0.6002603554735157, 
            1.1986676089052257`}, {-0.6542733917755728, 
            1.182797714652992}, {-0.697943120894651, 1.1693965026216118`}}]}, {
           Arrowheads[{{0.0006685329578423794, 1.}}], 
           
           ArrowBox[{{-0.7040951482703488, 
            1.1654103792578474`}, {-0.7109324629872322, 
            1.1654103792578474`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2401777677988335, 
            0.8404026201439594}, {-0.289538956100676, 
            0.8556509246177583}, {-0.340749821462818, 
            0.8653053715950657}, {-0.39412647256497396`, 
            0.8676062200201089}, {-0.4337865776692153, 
            0.8636207712036138}, {-0.4748226934156379, 
            0.8539658359071206}, {-0.4755531760221527, 0.853687772815536}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4811606538425683, 
            0.8515532488654368}, {-0.5175627004427613, 
            0.8376965662731589}, {-0.5619481719551193, 
            0.8134434398048699}, {-0.6077443328211635, 
            0.7793249353646065}, {-0.6542964897135364, 
            0.7336341798175195}, {-0.6722896926546567, 
            0.7120068173836432}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6761270723605686, 
            0.7073943866803529}, {-0.6776833568003974, 
            0.7055237732192298}, {-0.7010519710508021, 
            0.6734097822526092}, {-0.7240722785462047, 
            0.6376366159432568}, {-0.7464142253680592, 
            0.598548683316772}, {-0.7622291259716748, 
            0.5677433745475933}, {-0.7774338606751305, 
            0.5351612509596884}, {-0.7920284294784263, 
            0.5008023125530572}, {-0.7928854209498213, 
            0.4985878431516057}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7950508966239467, 
            0.49299224531895447`}, {-0.8060128323815622, 
            0.46466655932770007`}, {-0.819170266557411, 
            0.4271514932015962}, {-0.8312839291788459, 
            0.38865461609272495`}, {-0.8423538202458666, 
            0.34917592800108627`}, {-0.8523799397584736, 
            0.30871542892667975`}, {-0.8611781463778647, 
            0.2677864976260007}, {-0.8620607432646538, 
            0.2629011289271878}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8631274428867677, 
            0.25699671092740306`}, {-0.8685642987652379, 
            0.22690251285554433`}, {-0.8745383969205933, 
            0.18606347461531028`}, {-0.8791004408439309, 
            0.14526938290529856`}, {-0.8829286886527592, 
            0.08614600049951479}, {-0.8830630002492006, 
            0.028789717039143195`}, {-0.8823924644814348, 
            0.018318237447941314`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8820090428811452, 
            0.01233050099111296}, {-0.8795033756332552, \
-0.026799467475816043`}, {-0.872249814804923, -0.08062155304536278}, \
{-0.8654494172584162, -0.1141078128646602}, {-0.8567086068256264, \
-0.1467371761649776}, {-0.846027383506554, -0.17850964294631488`}, \
{-0.8334057473011988, -0.2094252132086718}, {-0.8283400282962877, \
-0.2198817632371759}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8257241114308661, -0.22528148350337512`}, \
{-0.8188436982095608, -0.23948388695204867`}, {-0.80234123623164, \
-0.2686856641764453}, {-0.7838983613674365, -0.2970305448818618}, \
{-0.7635150736169501, -0.3245185290682983}, {-0.7282900643139865, \
-0.3648023751399303}, {-0.6876506607533855, -0.40323958820381095`}, \
{-0.6773098039018396, -0.4114262352844037}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6726055589329011, -0.4151504908170191}, \
{-0.6415257677269873, -0.43975573249032285`}, {-0.5898442900266315, \
-0.4742763722298487}, {-0.5620110555793207, -0.4907507378352269}, \
{-0.5329711222747229, -0.5066509471853291}, {-0.502724490112838, \
-0.5219770002801549}, {-0.4712711590936664, -0.5367288971197045}, \
{-0.4674818859391618, -0.5383183844297991}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4619489473856866, -0.5406392874789305}, \
{-0.4161280686607674, -0.5598597823603982}, {-0.3587648811599211, \
-0.581086669809918}, {-0.3096511012885669, -0.5974440875684539}, \
{-0.2598947808051622, -0.6123336413128231}, {-0.23530953167894086`, \
-0.6188882389640012}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.22951203582052238`, -0.6204338915030995}, \
{-0.20975053974500363`, -0.6257024431901439}, {-0.15947299814338758`, \
-0.6374976053475344}, {-0.10955848737581599`, -0.647719867494625}, \
{-0.06030996974562629, -0.6563270672910361}, {-0.01169201167986813, \
-0.663201963808872}, {0.006069527875833196, -0.665060621243352}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.01203694347877493, -0.6656850818279908}, {
            0.03633082039440905, -0.6682273161202368}, {
            0.0907587359982866, -0.6715619625676668}, {
            0.14420812295879243`, -0.6722211275981457}, {
            0.19667898127592648`, -0.6702048112116735}, {
            0.2481713109496888, -0.6655130134082504}, {
            0.25150873325937273`, -0.6650119727000368}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.25744223986881487`, -0.6641211869145043}, {
            0.2990665842340126, -0.657872205202135}, {
            0.34974627338283104`, -0.6470088576075859}, {
            0.4002103783961443, -0.6329229706246035}, {
            0.4504588992739523, -0.6156145442531873}, {
            0.4879498236725181, -0.6001919419232463}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.49349866508232565`, -0.5979093208401918}, {
            0.5010492717161897, -0.5948032356920657}, {
            0.5525389314227915, -0.5702087021399664}, {
            0.604927878393758, -0.54183094359689}, {
            0.6582161126290886, -0.5096699600628359}, {
            0.6875896534825758, -0.49105654694840095`}, {
            0.7027408283537716, -0.48101481746949937`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7077421087279355, -0.4777001237251237}, {
            0.7174097075307752, -0.47129273864020677`}, {
            0.7648037819629722, -0.43660263959316276`}, {
            0.8132562830774812, -0.39927757296069033`}, {
            0.862093561518327, -0.3607672742807272}, {
            0.8978334095207138, -0.33131423007926164`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.9024637046490985, -0.32749842518067784`}, {
            0.9117003946118464, -0.3198865115057827}, {
            0.9366626479978377, -0.29861060066270395`}, {
            0.9615577977359552, -0.276848862955903}, {
            0.9863858438261991, -0.2546012983853797}, {
            1.011146786268569, -0.2318679069511341}, {
            1.035609308489595, -0.208718956845249}, {
            1.0595420939158067`, -0.18522471625980685`}, {
            1.0791558972953255`, -0.16524510239268378`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0833512343291016`, -0.16095580892668926`}, {
            1.105818454383787, -0.13720036365025193`}, {
            1.139214021951984, -0.09995958954566693}, {
            1.170491304758827, -0.06217984352706323}, {
            1.1990813822072326`, -0.02402738807949925}, {1.2244153337001171`, 
            0.014331514311966826`}, {1.2316539883575217`, 
            0.02699820490921233}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.2346309911834725`, 0.03220756707499432}, {
            1.2464152813379639`, 0.05282852005034044}, {1.265283943048437, 
            0.09145123918894911}, {1.2808732919752248`, 
            0.13011733971821765`}, {1.2930353012620155`, 
            0.16874448962857122`}, {1.302128454208634, 
            0.20733551778713435`}, {1.3088006684898408`, 
            0.24594191641914603`}, {1.3102303907338326`, 
            0.25810858658244884`}}]}, {
           Arrowheads[{{0.0017189774753449312`, 1.}}], 
           ArrowBox[{{1.3115293998450215`, 0.2794590202080648}, {
            1.3127393097284055`, 0.2794590202080648}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5363362975390518, 
            0.7671532449214499}, {-0.5598938430140756, 
            0.7441481759033776}, {-0.5831210422301732, 
            0.7166755361695623}, {-0.605651259961414, 
            0.6847712814021416}, {-0.6271178609818672, 
            0.6484713672832527}, {-0.6471931195411303, 
            0.6071514691819212}, {-0.6633185979416878, 
            0.5662892663209084}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6655205824257021, 
            0.5607079538335618}, {-0.681679722687048, 
            0.5099917119483454}, {-0.6952644140805759, 
            0.4558084369318421}, {-0.7058144683118303, 
            0.3989296619061819}, {-0.7129076664681336, 
            0.3401708205652669}, {-0.7136676766191259, 
            0.32631461731611844`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7139962815613965, 
            0.32032362250791546`}, {-0.7161840358496054, 
            0.2804373551507765}, {-0.7152836037563651, 
            0.220634707904389}, {-0.7096198280422805, 
            0.1621277997403984}, {-0.6987874221182206, 
            0.10591396863500648`}, {-0.6918214338393984, 
            0.08272160132289388}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.690095464904364, 
            0.07697520843384632}, {-0.6826982966198064, 
            0.0523472824227538}, {-0.6612643621826586, 
            0.001781808938180844}, {-0.6338242235024997, \
-0.04520461523384482}, {-0.6001751300269708, -0.0882131685087173}, \
{-0.5644338821900439, -0.12366942582093701`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.5600945165301103, -0.1278047833242227}, \
{-0.5166495897437993, -0.1619544810304106}, {-0.46764885183447225`, \
-0.1924343671664884}, {-0.41444981422935234`, -0.21849606213788453`}, \
{-0.35804121064635736`, -0.24015215954138752`}, {-0.3509708590633651, \
-0.242233983086544}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.34521517500158, -0.24392871049262232`}, \
{-0.29941177480340603`, -0.2574152529737855}, {-0.24001987215184387`, \
-0.27007941817035763`}, {-0.18094816275627462`, -0.2781135451555904}, \
{-0.12262182225450313`, -0.2817924489600834}, {-0.1091546943808506, \
-0.28169784594961206`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.10315484241609589`, -0.28165569857687056`}, \
{-0.06546602628433434, -0.28139094461443587`}, {-0.017248350761360255`, \
-0.27790735316841825`}, {0.029072432683433975`, -0.2715518448311754}, {
            0.07349632405004901, -0.26232441960270725`}, {
            0.1160233233384845, -0.2502250774830138}, {
            0.13260896199382904`, -0.24426107784172332`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1382550271093296, -0.24223081955482298`}, {
            0.15668823477229435`, -0.2356024559340872}, {
            0.19552586257503246`, -0.21880519241791946`}, {
            0.23253620674669886`, -0.19983328693451058`}, {
            0.26771926728729345`, -0.17868673948386057`}, {
            0.3012826829738274, -0.15575987173486056`}, {
            0.33343409258331164`, -0.1314470053564016}, {
            0.3445604300181348, -0.12214512532908224`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.3491636615812935, -0.11829671537483633`}, {
            0.3641734961157462, -0.10574814034848376`}, {
            0.39350089357113094`, -0.07866327671110714}, {
            0.42943120468382623`, -0.04237721058142374}, {
            0.46371305540010216`, -0.0048616306918010995`}, {
            0.49634644571995884`, 0.03388346295776096}, {0.513483250969297, 
            0.05599218044681384}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5171590225636336, 0.06073440599883781}, {
            0.5273313756433963, 0.07385807036726237}, {0.5597472800143052, 
            0.11946351320223456`}, {0.5904991384076913, 
            0.16623157310412862`}, {0.612857884043522, 
            0.20246401644584763`}, {0.6342561057797592, 
            0.23954813837286348`}, {0.6465375385001354, 
            0.2625554284429288}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6493630161166398, 0.2678485065869422}, {
            0.6546055574253556, 0.2776695650367279}, {0.6738553712027647, 
            0.3170060755654285}, {0.689545975431128, 0.35151629283740116`}, {
            0.7044778483993099, 0.38708278027561094`}, {0.7182941713568951, 
            0.4241452733659697}, {0.7306381255534677, 0.4631435075943888}, {
            0.7374536744016673, 0.4904358951809058}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.7389073728702191, 0.49625712879265255`}, {
            0.7431161927615018, 0.5131110530052381}, {0.7529341179045372, 
            0.5665928239466158}, {0.7594831646059315, 0.6243024685692982}, {
            0.7621545964890418, 0.6869536350240609}, {0.7618307568776298, 
            0.7202804412072417}, {0.7611404834701331, 0.7344000808938168}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7608475085668999, 0.7403929237672847}, {
            0.7601266135694248, 0.75513893238598}, {0.7570421665644274, 
            0.7915291085602768}, {0.752577415862637, 0.8294509697301313}, {
            0.7483870774277146, 0.8608995897688372}, {0.7431297697776964, 
            0.8933494194634358}, {0.730426424775272, 0.9457492515581232}, {
            0.721259653877047, 0.9764235636370899}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.7195416752859114, 0.9821723504273961}, {
            0.7144882248333345, 0.9990824617391075}, {0.6968736747710691, 
            1.0519836020824467`}, {0.6759064244681475, 1.1040206027504946`}, {
            0.6515695177573306, 1.1536418216890518`}, {0.6238459984713788, 
            1.199295616843918}, {0.6227462218986365, 1.2007353938905292`}}]}, {
           Arrowheads[{{0.018574026191875984`, 1.}}], 
           
           ArrowBox[{{0.6191040908655837, 1.2055035047887859`}, {
            0.592912042300505, 1.239792933444005}, {0.5589438249349219, 
            1.273944716718225}, {0.5323002567847419, 1.2950494719476673`}, {
            0.5043409394682954, 1.3129025466170405`}, {0.4752134769209055, 
            1.327240502421}, {0.4450654730778952, 1.3377999010542}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.900699216705139, -0.20694155106117085`}, \
{-0.8826894928755489, -0.25920461821661755`}, {-0.8596270082485908, \
-0.30972348518930015`}, {-0.8308312682060317, -0.35874315117961353`}, \
{-0.7963022727478715, -0.4062636161875579}, {-0.7873509866841635, \
-0.4164952721522973}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7834003122325617, -0.4210110413423092}, \
{-0.75604002187411, -0.45228488021313323`}, {-0.7152722444003032, \
-0.4917460977581567}, {-0.6691415931657418, -0.5301725591418377}, \
{-0.6440642436772925, -0.548977877407947}, {-0.6176442833268834, \
-0.5674847489032648}, {-0.6025354988103825, -0.5773940315645636}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5975183193543724, -0.5806846105875001}, \
{-0.5898817121145145, -0.5856931736277914}, {-0.5607765300401855, \
-0.6036031515815266}, {-0.5304461702215739, -0.621176640889524}, \
{-0.4990080657763571, -0.6383755996768373}, {-0.4664622167045352, \
-0.6552000279434665}, {-0.4328086230061081, -0.6716499256894115}, \
{-0.38577707636746067`, -0.693138913832539}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3803197405157137, -0.695632402433122}, \
{-0.37877572293188705`, -0.6963378730783158}, {-0.323039583626028, \
-0.7199050696383861}, {-0.28313917086089385`, -0.7357532113697107}, \
{-0.24296775483362912`, -0.7509400872855976}, {-0.2025253355442337, \
-0.7654656973860469}, {-0.16181191299270747`, -0.7793300416710587}, \
{-0.1561695473001339, -0.7811495392508601}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.15045911217263425`, -0.7829909872285716}, \
{-0.12105863366476857`, -0.7924717799323259}, {-0.08049664404613519, \
-0.8048295719615416}, {-0.04012594413680713, -0.8164034177587058}, {
            0.000053466063215712456`, -0.8271933173238188}, {
            0.04819733120770663, -0.8390642565291317}, {
            0.08093061634980926, -0.8462848441383859}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.08678975861390394, -0.8475773037815081}, {
            0.09594650587592549, -0.8495971772996775}, {
            0.14330099006787236`, -0.8587920796354562}, {
            0.19026078378354747`, -0.8666489635364683}, {
            0.23706602779223945`, -0.8730376361657233}, {
            0.28395686286323707`, -0.8778279046862313}, {
            0.32426147943351813`, -0.8805664457343585}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.33024767719261333`, -0.8809731844576236}, {
            0.3309332889965407, -0.8810197690979926}, {
            0.37799530619214994`, -0.882613229401007}, {
            0.4255930855673228, -0.8824051553599866}, {
            0.47417679823931685`, -0.8801924167396438}, {
            0.5237464442081321, -0.8759750135399782}, {
            0.5696429297740603, -0.8703263581757883}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5755905397829213, -0.8695414833789109}, {
            0.629878543967934, -0.8606321117227457}, {
            0.6875244744072485, -0.8487071461232316}, {
            0.7474495027187535, -0.8337193084480035}, {
            0.8091958926186678, -0.8156056509020346}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8149059403957987, -0.813763912592552}, {
            0.8419486789339936, -0.8049369843765303}, {
            0.8745465582371518, -0.7934886195187356}, {
            0.9076569547389649, -0.7810647636092332}, {
            0.9412798684394325, -0.7676654166480228}, {
            0.9851342464084547, -0.7496894815387056}, {
            1.0293899743898358`, -0.7299567053628776}, {
            1.0377816338708985`, -0.7253083887597711}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.043030215449777, -0.72240108908312}, {
            1.085047969952079, -0.6991265715316083}, {
            1.138261902592112, -0.6651305181483669}, {
            1.1892290178827811`, -0.6296444522610569}, {
            1.2357024984747236`, -0.5911783613656102}, {
            1.2402110739150496`, -0.5866518431781655}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.2444452808139281`, -0.5824007854347929}, {
            1.2767341400349643`, -0.5499834264595834}, {
            1.3113757382305296`, -0.5063108285405337}, {
            1.339602204255896, -0.4605485569027954}, {
            1.3613884493055406`, -0.4130846008407028}, {
            1.3720380334153623`, -0.38236859789565514`}}]}, {
           Arrowheads[{{0.0002732148524960431, 1.}}], 
           
           ArrowBox[{{1.3742605142926965`, -0.37434322129968667`}, {
            1.37482052185387, -0.37434322129968667`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -0.7864170130565178}, {-1.4719548896370747`, \
-0.8043544247070954}, {-1.4337653581600596`, -0.8332637641713482}, \
{-1.4007232869599464`, -0.8621672120177644}, {-1.3709734539541414`, \
-0.891092415685836}, {-1.3433450532682465`, -0.9200505007581256}, \
{-1.3212862734805082`, -0.9451222904025511}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.3173487949321334`, -0.949648726252968}, \
{-1.2944525488561878`, -0.9780653151153587}, {-1.2724738275548944`, \
-1.006973121342217}, {-1.2511873034232524`, -1.0356159628571235`}, \
{-1.2305929764612618`, -1.063993839660078}, {-1.2106908466689223`, \
-1.0921067517510805`}, {-1.1786580249399268`, -1.1379387566242585`}, \
{-1.175123568634828, -1.1428879457334873`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.1716365829080644`, -1.1477706632699978`}, \
{-1.1472155064610585`, -1.1819667362028587`}, {-1.1106563205572146`, \
-1.2257837910438534`}, {-1.0734291388103492`, -1.2646102213257668`}, \
{-1.035583428816016, -1.3004976976144207`}, {-1.00784865627014, \
-1.321793747659603}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0030897306884141`, -1.3254478723574745`}, \
{-0.9965006623267477, -1.3305072659165553`}, {-0.9559486267628453, \
-1.3548243499165031`}, {-0.91369510954461, -1.373634373298597}, \
{-0.8695862862678658, -1.3875929017554844`}, {-0.8234683325284369, \
-1.3973555009798133`}, {-0.7790639202736509, -1.4029264457801267`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7731105901314916, -1.403673346187449}, \
{-0.7671235232562515, -1.404424479180413}, {-0.7078963671369601, \
-1.407770895430288}, {-0.6459615480113601, -1.4082252714148722`}, \
{-0.5814937497202487, -1.4066181288195985`}, {-0.5484224554218308, \
-1.405149001889673}, {-0.5333273677619419, -1.4043511893964276`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5273357303930853, -1.4040345166313815`}, \
{-0.5149428604004441, -1.4033795229850994`}, {-0.4810549646560886, \
-1.4013096921058774`}, {-0.4467587681887643, -1.398939509252007}, \
{-0.4136989030660905, -1.3964343633859766`}, {-0.3805366381594578, \
-1.393741699405961}, {-0.3472719734688664, -1.3908615173119603`}, \
{-0.3139049089943164, -1.387793817103974}, {-0.288087956309264, \
-1.3852926144687936`}}]}, {
           Arrowheads[{{0.011185344252578748`, 1.}}], 
           
           ArrowBox[{{-0.2821159180921659, -1.3847140303923449`}, \
{-0.2805579276396889, -1.3845630888822116`}, {-0.2473535123088652, \
-1.3811938227468814`}, {-0.21429166300184543`, -1.3776860186979838`}, \
{-0.18137237971862952`, -1.3740396767355183`}, {-0.14867268908376902`, \
-1.3702731509697579`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0084517815711058`, 1.5}, {-1.0249862448288551`, 
            1.4728759631187218`}, {-1.0499841031495685`, 
            1.4377043206924507`}, {-1.0744418761015866`, 
            1.4074108654424482`}, {-1.098259805305964, 
            1.38030840951045}, {-1.1213658343732886`, 
            1.355347787092379}, {-1.1612644040661206`, 
            1.3159747972469575`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.1655382636474483`, 
            1.3117637206599515`}, {-1.2026129502164624`, 
            1.2776795868749877`}, {-1.2367506606241023`, 
            1.246820488980939}, {-1.2538512253610647`, 
            1.2303008048168187`}, {-1.2696935564196146`, 
            1.2142522522472634`}, {-1.2987377213215727`, 
            1.1828418183861031`}, {-1.3225948317978322`, 
            1.152548618167309}, {-1.3312009449111708`, 
            1.1391160277333894`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.3344377361478357`, 
            1.1340639803770942`}, {-1.3415737613092542`, 
            1.1229259321017449`}, {-1.363945682607051, 
            1.0745728394771517`}, {-1.3764845017523255`, 
            1.0258426546449164`}, {-1.3824659263665875`, 
            0.9759366239668781}, {-1.3851656640713468`, 
            0.924055993804875}, {-1.384984309784923, 0.9030940923115809}}]}, {
          
           Arrowheads[{{0.01841037943510554, 1.}}], 
           
           ArrowBox[{{-1.3849324020418283`, 
            0.8970943168502651}, {-1.3846923797292743`, 
            0.8693512501096493}, {-1.3811547382030411`, 
            0.8109728788319432}, {-1.3773592582920275`, 
            0.7683209834002348}, {-1.3729831941278918`, 
            0.7236288158164638}, {-1.368099990752779, 
            0.676914701445323}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8229559166608298, 
            0.12431559072349987`}, {-0.8211573832231717, 
            0.0714596023750356}, {-0.8157407797229258, 
            0.020500901484284118`}, {-0.8067061061600918, \
-0.02856051194875455}, {-0.7940533625346701, -0.07572463792408003}, \
{-0.7811853361278919, -0.11057428837154162`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7791070258007213, -0.11620284290925165`}, \
{-0.7774102571500319, -0.12079809260003478`}, {-0.7564044983095486, \
-0.1635874921349612}, {-0.7310360860132203, -0.20409283652885893`}, \
{-0.7013050202610472, -0.24231412578172798`}, {-0.680278997248979, \
-0.26517970693271364`}, {-0.6573808922174426, -0.2870910318403226}, \
{-0.6356529623528437, -0.3054741678726178}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6309993416239255, -0.3092578999626046}, \
{-0.6059684360959658, -0.3280509129254092}, {-0.577562240177032, \
-0.3470510805415441}, {-0.5475002725806435, -0.3650002147916157}, \
{-0.5157825333068002, -0.38189831567562416`}, {-0.4824090223555021, \
-0.3977453831935695}, {-0.44770518664511416`, -0.41247457995873343`}, \
{-0.4206570115060063, -0.4227340842668969}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.41504701614648853`, -0.42486198277626924`}, \
{-0.4119964730940016, -0.4260190685843975}, {-0.37528288170216434`, \
-0.43837884907056185`}, {-0.3375644124696022, -0.4495539214172264}, \
{-0.2847646711966866, -0.4629187698089629}, {-0.23193459445192996`, \
-0.47378301679899637`}, {-0.1822926505130098, -0.4816374320033207}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1763493773566082, -0.4824487124074551}, \
{-0.12618343454689362`, -0.4880097065739541}, {-0.07612935698638329, \
-0.49119618941824417`}, {-0.027131309834313236`, -0.491935368345119}, {
            0.02067371890727468, -0.49020630902504847`}, {
            0.06303106941357599, -0.48636181109896337`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.06899384269656726, -0.4857136208274541}, {
            0.11228056172749261`, -0.4792747809881046}, {
            0.15605598495534806`, -0.4700605289364768}, {
            0.19851630047434393`, -0.45835231742363647`}, {
            0.23974682200967828`, -0.4441690671428832}, {
            0.2921546670869608, -0.42193689062020834`}, {
            0.298303665339583, -0.41874724835555377`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.30362974193812864`, -0.4159844765469483}, {
            0.3428681795412555, -0.395630497925378}, {
            0.3921651309009523, -0.3654665446405676}, {
            0.44032329269444104`, -0.33166168634795246`}, {
            0.4855963874619954, -0.2964009483074691}, {
            0.5022752327022959, -0.2823937063678925}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5068698672591458, -0.2785350364819084}, {
            0.5306213081381624, -0.2585880812813132}, {
            0.5753980547229424, -0.21822308526948497`}, {
            0.6199266272163352, -0.1753059602719842}, {
            0.6448395991701809, -0.15031881977013065`}, {
            0.6698908665230185, -0.12480861121603047`}, {
            0.6808888240143243, -0.11344228174470188`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6850610163689678, -0.10913034355453102`}, {
            0.6950804292748485, -0.09877533460968368}, {
            0.7204082874256705, -0.07221898995109027}, {
            0.7459044287863574, -0.045184987347084024`}, {
            0.7715988411677817, -0.01771873690449878}, {0.7974915245699437, 
            0.01017976137666548}, {0.823582478992843, 
            0.038510507496408795`}, {0.8488548696095287, 
            0.0662757213383233}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8528669977525744, 0.0707369368852049}, {
            0.8759968018844575, 0.09654801173426941}, {0.9022295705990737, 
            0.12627458697304594`}, {0.9284794108262291, 0.15647304429172}, {
            0.9487158993449737, 0.17992785937045658`}, {0.9688116434978763, 
            0.20372173939794605`}, {1.0069054188062836`, 
            0.2533514625520643}, {1.0074752200014, 0.2541686358804164}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0109070142322656`, 0.2590903010820528}, {
            1.0427505610323082`, 0.3047583294192075}, {1.063927188415667, 
            0.3365134429829871}, {1.0837946448546734`, 
            0.36916085649545466`}, {1.1023529303493276`, 
            0.4027005699566104}, {1.1196020448996293`, 0.4371325833664542}, {
            1.132169574845366, 0.4655774477732936}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.1345943753508052`, 0.4710656480710981}, {
            1.1353068219853675`, 0.47267817240998816`}, {1.1492320950863302`, 
            0.5095586127722143}, {1.1613778642025177`, 0.5477739044531327}, {
            1.1717441293339292`, 0.587324047452743}, {1.180304987042088, 
            0.6284967581009415}, {1.1870345338885164`, 0.6715797527276239}, {
            1.1905163414513296`, 0.7035622742338635}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.1911657004464073`, 0.7095270318060966}, {
            1.191932769873214, 0.7165730313327904}, {1.1949996949961812`, 
            0.7634765939164407}, {1.1963809759948447`, 0.8257087138690432}, {
            1.195103722272972, 0.8905595573673752}, {1.1934948959105527`, 
            0.923979058856157}, {1.191832386544011, 0.94926403487672}}]}, {
           Arrowheads[{{0.01021289470696273, 1.}}], 
           
           ArrowBox[{{1.1914387312808596`, 0.9552511072442292}, {
            1.1912535370904622`, 0.958067711323332}, {1.1883903462201868`, 
            0.9928303381328868}, {1.1849160237072147`, 1.028271762648809}, {
            1.1792852986023377`, 1.077189161538461}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6322381920236443, 
            0.4895484790190286}, {-0.6391550070435297, 
            0.4450960693791113}, {-0.6435710384630802, 
            0.3988875060859766}, {-0.6452456233482945, 
            0.35155532374369264`}, {-0.64382172725946, 
            0.3038900722936355}, {-0.6390354129614331, 
            0.25655588940733476`}, {-0.6379938944025617, 
            0.25067773399664467`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6369470917384112, 
            0.24476975598531733`}, {-0.6307856633270669, 
            0.20999569128408604`}, {-0.6189714612292139, 
            0.16465239412318533`}, {-0.6030919362999168, 
            0.1212033726389282}, {-0.5829661007638665, 
            0.08013843473361094}, {-0.558972761382888, 
            0.04161914638853052}, {-0.5465198952857205, 
            0.025391711865348894`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5428671203721831, 
            0.02063175016056261}, {-0.5314907249188062, 
            0.005807073584983967}, {-0.5088216241196124, \
-0.019045689380921292`}, {-0.48432929584799655`, -0.04215690855622294}, \
{-0.45801374010395907`, -0.06352658394092081}, {-0.42987495688749916`, \
-0.08315471553501527}, {-0.4002929572437665, -0.10100930091205956`}, \
{-0.3696477522179106, -0.11705833764560694`}, {-0.3544631585784915, \
-0.12387929069473542`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.34898999674766024`, -0.1263378470950508}, \
{-0.33793934180993085`, -0.1313018257356577}, {-0.3051677260198275, \
-0.1437397651822117}, {-0.2718042508284957, -0.15440297938696948`}, \
{-0.23832026221683028`, -0.16332229175163146`}, {-0.20471576018483176`, \
-0.1704977022761977}, {-0.17099074473249937`, -0.17592921096066824`}, \
{-0.12512499260569432`, -0.18073794823704076`}, {-0.11661586000285117`, \
-0.18109597816566408`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.11062116412053132`, -0.18134821075375987`}, \
{-0.08051418939937807, -0.18261499063763156`}, {-0.037158335113550364`, \
-0.1815603381624407}, {0.004942570251788805, -0.1775739908114682}, {
            0.045519903744391896`, -0.17098216242329822`}, {
            0.08430504241201138, -0.16211106683651483`}, {
            0.12129798625464724`, -0.15096070405111803`}, {
            0.1256664803007866, -0.14929405603185053`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.1312723559309997, -0.14715532780727814`}, {
            0.15649873527229974`, -0.13753107406710777`}, {
            0.18999472691302563`, -0.12218790388661925`}, {
            0.22187339862488176`, -0.10529692051178782`}, {
            0.25213475040786826`, -0.08685812394261337}, {
            0.28077878226198527`, -0.0668715141790959}, {
            0.31835921156256974`, -0.037072130997111256`}, {
            0.3345508470871873, -0.022542940351232253`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.33901654266454556`, -0.018535751435001444`}, {
            0.3534235829292505, -0.005607926180381438}, {0.38597189636202756`,
             0.02752110027109357}, {0.4160041518609009, 
            0.06231494835731377}, {0.4422182769018576, 0.09642376986269537}, {
            0.46646800550679635`, 0.13140501816078928`}, {0.4887526441793635, 
            0.16722679472999252`}, {0.4889792360921309, 
            0.16763528988060983`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.4918896593942188, 0.17288214000260338`}, {
            0.5090714994232052, 0.20385720104870203`}, {0.5273319920001199, 
            0.241367597807889}, {0.5434415426719059, 0.27982934569852447`}, {
            0.5572661425513347, 0.31936768897374357`}, {0.5685393187700297, 
            0.36022915391039884`}, {0.5756155898285044, 
            0.3964309386895818}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5767666118732346, 0.40231949948595175`}, {
            0.5768425360927865, 0.4027079233087574}, {0.5819109082608044, 
            0.44709161073631076`}, {0.583238928668991, 
            0.49382216297952236`}, {0.5803210907122534, 0.5433415268248556}, {
            0.5752510022926737, 0.5803624644958325}, {0.5671720833908256, 
            0.6193958193614293}, {0.5616042778119902, 0.6400072952116931}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5600395736334248, 0.6457996782129785}, {
            0.5560843340067098, 0.6604415914216462}, {0.5419877541403259, 
            0.703499780676483}, {0.5256927935817738, 0.7459263926634517}, {
            0.5060729631564651, 0.790548240940139}, {0.48296421098063447`, 
            0.8372497667501642}, {0.4669533943121178, 0.8663651055390694}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.46406224500306104`, 0.8716226007290568}, {
            0.45620248517051676`, 0.8859154113371466}, {0.42577093638482244`, 
            0.935941503452566}, {0.391652715282262, 0.986724371847902}, {
            0.37383451685485264`, 1.0120737029162272`}, {0.35515094133691116`,
             1.0372785096092139`}, {0.32772170154292274`, 
            1.0685471606892858`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3237650258428236, 1.0730576725675813`}, {
            0.3185277711825093, 1.0790280126069265`}, {0.27996393726424423`, 
            1.1177739248064473`}, {0.24070805787060992`, 
            1.1543446168220564`}, {0.20006808752623723`, 
            1.1865648684698424`}, {0.1584792078406083, 1.2140161960213083`}, {
            0.13899032712729523`, 1.2243219443437765`}}]}, {
           Arrowheads[{{0.009094684054452294, 1.}}], 
           
           ArrowBox[{{0.1336862616206253, 1.2271267418589198`}, {
            0.11637660042320544`, 1.2362801157479573`}, {0.07412458453441809, 
            1.2536007417080526`}, {0.032087479434635705`, 
            1.2662221879598574`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.23154267397474584`, 
            0.8975789783991693}, {-0.26528976028608126`, 
            0.9138180206111961}, {-0.30015729362302085`, 
            0.9283125536425801}, {-0.33627648180684866`, 
            0.9407000205593665}, {-0.37379582982631493`, 
            0.9506888640880191}, {-0.4129898102843834, 
            0.9577769488995972}, {-0.4540804989517315, 
            0.9613967062670192}, {-0.4607790804662902, 
            0.9613698194214644}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.4667790321348186, 
            0.9613457367446324}, {-0.4974125533147598, 
            0.9612227795557149}, {-0.5433986248877261, 
            0.9566769971238883}, {-0.5924513651848881, 
            0.9471811873297435}, {-0.6477024097847639, 
            0.9308875610251067}, {-0.6993401150028465, 
            0.9103035603843873}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7049136167933066, 
            0.9080818318249682}, {-0.7073182166079239, 
            0.9071233019306648}, {-0.7481173575446765, 
            0.8873229059679777}, {-0.7909187002525233, 
            0.8633411775589126}, {-0.8354960103531208, 
            0.8346143235594867}, {-0.8816230534681255, 
            0.8005785508257169}, {-0.9050817487556436, 
            0.7814310755812147}, {-0.9068512353011425, 
            0.7798667724488518}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.9113464901604514, 
            0.7758927714737816}, {-0.9285559249959895, 
            0.7606788819486499}, {-0.9520455821891631, 
            0.738321969928022}, {-0.9755507203351648, 
            0.7143603395193316}, {-0.9971324524742213, 
            0.6916302519412492}, {-1.0184354566689249`, 
            0.6674655400283508}, {-1.0468976094963547`, 
            0.6278216856305644}, {-1.0674160424525934`, 
            0.5950381876999661}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0705992424571678`, 
            0.5899522032592822}, {-1.0735244599951497`, 
            0.5852784124630984}, {-1.0989563520713443`, 
            0.5414740458195918}, {-1.1219983273023386`, 
            0.4951474922240039}, {-1.1423774683481938`, 
            0.4466689837732581}, {-1.1598208578689713`, 
            0.3964087525642779}, {-1.1669191493156843`, 
            0.37107955776481893`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1685382226200316`, 
            0.3653021360530906}, {-1.1742731203098877`, 
            0.34483800861738195`}, {-1.185678880116159, 
            0.29242796195288895`}, {-1.193182370464287, 
            0.24660917538440363`}, {-1.198659161079715, 
            0.2006652421426449}, {-1.2021675686713829`, 
            0.15496563856131865`}, {-1.2031092065869187`, 
            0.12840404181393586`}}]}, {
           Arrowheads[{{0.00838556703362347, 1.}}], 
           
           ArrowBox[{{-1.20332177967101, 
            0.12240780860600274`}, {-1.2037659099482285`, 
            0.10987984097413078`}, {-1.2036196174526672`, 
            0.06551334515985761}, {-1.2019553327748147`, 
            0.021820800865886485`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5846294015164732, 
            0.8486035374250658}, {-0.6266336896127064, 
            0.8242199347129415}, {-0.6704506158747122, 
            0.7923935467654214}, {-0.7157906082508635, 
            0.7519641968479013}, {-0.7389897228242132, 
            0.7279522355115271}, {-0.7625191662370621, 
            0.7011041229160159}, {-0.7671622324207709, 
            0.6952901973908151}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7709064311672391, 
            0.6906018100617919}, {-0.7861303892439248, 
            0.6715387696151173}, {-0.8095748425993143, 
            0.6393750861625803}, {-0.8282897436689818, 
            0.6113842329650933}, {-0.8466862754323703, 
            0.5816110576344409}, {-0.8647644378894802, 
            0.5500555601706231}, {-0.8825242310403114, 
            0.5167177405736396}, {-0.8971284677327486, 
            0.48713305232145426`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8997813044571116, 
            0.48175143300908646`}, {-0.9161758811666101, 
            0.4456962719269345}, {-0.9318395310779457, 
            0.4082629071139019}, {-0.9467283975547387, 
            0.3695477886410829}, {-0.9606322388887906, 
            0.32998160100709095`}, {-0.9733408133719023, 
            0.28999502871053917`}, {-0.9827780631533247, 
            0.25687417778627775`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9844222257076176, 
            0.25110384595049384`}, {-0.984854121004074, 
            0.24958807175142794`}, {-0.9951721617853058, 
            0.20876073012975743`}, {-1.0068318150939397`, 
            0.15458470964547263`}, {-1.0159771513485474`, 
            0.10112082315335752`}, {-1.0226081705491294`, 
            0.04836907065341197}, {-1.0252491452594057`, 
            0.014984261279618799`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0257223095204784`, 
            0.009002947412077359}, {-1.0267248726956857`, \
-0.003670547854364027}, {-1.028307473765435, -0.05488088053523729}, \
{-1.0273353137938834`, -0.10488505436659684`}, {-1.0249533154941561`, \
-0.1414800348135067}, {-1.0211641465190282`, -0.1774892685332085}, \
{-1.0159678068685, -0.21291275552570219`}, {-1.0127356259223697`, \
-0.2299645771681359}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.011618219768501, -0.23585960927044855`}, \
{-1.0093642965425718`, -0.24775049579098762`}, {-1.001303157207988, \
-0.2821382168238824}, {-0.991733930531493, -0.316211646119204}, \
{-0.9806566165130872, -0.34997078367695245`}, {-0.9680712151527703, \
-0.3834156294971275}, {-0.9504674245652729, -0.4238479616696202}, \
{-0.9316262632197635, -0.4611865069634947}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.928805892740982, -0.4664799440090692}, \
{-0.9068057405146817, -0.5048287238269121}, {-0.8807478470515883, \
-0.5453771538117115}, {-0.85131082560587, -0.5861487241691382}, \
{-0.8179335824867673, -0.6273278760010502}, {-0.7883507228932809, \
-0.6602951340716631}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7843435001337786, -0.6647607992803108}, \
{-0.7806161176942803, -0.668914609307448}, {-0.739358431228409, \
-0.7109089240883313}, {-0.7164029320229601, -0.7327555570579904}, \
{-0.6922121828611286, -0.7546838896826714}, {-0.6667861837429144, \
-0.7766939219623742}, {-0.6401249346683173, -0.7987856538970985}, \
{-0.6122523523575241, -0.8208875685633042}, {-0.6063700988719332, \
-0.825348968651143}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6015895602980462, -0.8289747721405201}, \
{-0.583192353530721, -0.8429281490374505}, {-0.552944938187908, \
-0.8649073953195374}, {-0.5215101063290851, -0.8868253074095649}, \
{-0.4890207933230072, -0.9085484520860463}, {-0.4556099345384289, \
-0.9299433961274947}, {-0.4212775299753505, -0.9510101395339103}, \
{-0.4021761152590141, -0.9622467669827627}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.39700456926399724`, -0.9652889885429757}, \
{-0.3860235796337718, -0.971748682305293}, {-0.35035506972193636`, \
-0.992296502313674}, {-0.31401353251419867`, -1.0123097933997736`}, \
{-0.2575334643861135, -1.0397572450706216`}, {-0.20055075777546874`, \
-1.0651829975429088`}, {-0.1827301543481852, -1.0728861876877736`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.17722267253402085`, -1.0752668691168288`}, \
{-0.1630487764539416, -1.0813937220622933`}, {-0.1255528585198566, \
-1.0965563314626263`}, {-0.08806300397321373, -1.1106708257439077`}, \
{-0.05057921281401302, -1.1237372049061376`}, {-0.013189944386252666`, \
-1.1356986960352535`}, {0.02401634196606918, -1.1464985262171932`}, {
            0.0495263044562307, -1.1531394606355228`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.05533277668316517, -1.154651042680216}, {
            0.061039646242952474`, -1.1561366954519565`}, {
            0.09787996844439717, -1.1646132037395431`}, {
            0.1345595248625548, -1.1719621140329626`}, {
            0.17110053178957677`, -1.178217489285223}, {
            0.20750298922546306`, -1.1833793294963253`}, {
            0.24376689717021366`, -1.1874476346662686`}, {
            0.2921807711535197, -1.1912239715541209`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.2981626014932373, -1.191690561081258}, {
            0.29902119943196465`, -1.1917575326908625`}, {
            0.35469707561232466`, -1.1939763674820427`}, {
            0.4107945257112936, -1.1941041390398093`}, {
            0.4673135497288715, -1.1921408473641621`}, {
            0.5249518166028998, -1.1882703566735346`}, {
            0.5378945968570277, -1.1870526384581992`}}]}, {
           Arrowheads[{{0.01384655936461266, 1.}}], 
           
           ArrowBox[{{0.5438682160501117, -1.18649061200329}, {
            0.5844069952712202, -1.1826765311863603`}, {
            0.6456790857338326, -1.1753593709026386`}, {
            0.7087680879907369, -1.1663188758223701`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.746853820286886, 
            0.07299985600578097}, {-0.7381359897819839, 
            
            0.034516451406241516`}, {-0.7268524426821487, \
-0.002555720565451492}, {-0.7129042200906762, -0.03806968147104997}, \
{-0.6962593635894406, -0.07197370462026427}, {-0.676885914760316, \
-0.10421606332280475`}, {-0.6545519230565822, -0.13474314548441071`}, \
{-0.647655378202664, -0.14256222343610203`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.643686503190487, -0.1470620046683085}, \
{-0.6291854316343943, -0.16350284733399834`}, {-0.60099447262994, \
-0.19044570466604313`}, {-0.5701870781794065, -0.21552225327502073`}, \
{-0.5367138887983194, -0.2387969646420759}, {-0.5007069076964668, \
-0.26012632743087893`}, {-0.46242818957126675`, -0.2794653560599928}, \
{-0.44969985016725, -0.2849321275676324}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.44418682730196357`, -0.2872999491164044}, \
{-0.42213978912013717`, -0.2967690649479807}, {-0.3802093171777355, \
-0.3119965714850602}, {-0.3370043845787199, -0.3251069930614483}, \
{-0.2928328173398004, -0.33607451371493935`}, {-0.2482125694949863, \
-0.3448629213358809}, {-0.21331748797676847`, -0.3498879583862833}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.20737874842675078`, -0.3507431616118711}, \
{-0.2003927400811565, -0.351749175905109}, {-0.13759818255400796`, \
-0.35705563823453534`}, {-0.07657260602841583, -0.35788609230447277`}, \
{-0.017477649506106974`, -0.3544028491405807}, {
            0.031777341757417935`, -0.3478059051467101}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.037724239751812216`, -0.34700941017229453`}, {
            0.039525048011191714`, -0.3467682197685187}, {
            0.09392151384561712, -0.3349353807753143}, {
            0.14547964226021506`, -0.3190248162989007}, {
            0.19446059466462198`, -0.2994497986912957}, {
            0.24112553246847432`, -0.27662360030451716`}, {
            0.2618642717634356, -0.2648229811294119}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2670791475738006, -0.2618556472617}, {
            0.2803781172170235, -0.2542883562152723}, {
            0.318148202271359, -0.22993787165084467`}, {
            0.3544357876314806, -0.20357214661123438`}, {
            0.38924087329738816`, -0.17519118109644155`}, {
            0.42282952329643647`, -0.14520516789274757`}, {
            0.4553452382994563, -0.11414139027179407`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4595460850629724, -0.1098574933418413}, {
            0.48715570837601957`, -0.08164857677750041}, {
            0.5178932434565542, -0.04807799886594731}, {
            0.5478930590144521, -0.013536054981558845`}, {0.5773678071665809, 
            0.02175376594588053}, {0.6063174879129405, 0.05779146391637094}, {
            0.6167457299112974, 0.07128712254480772}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6204143661301044, 0.07603487025230622}, {
            0.6347421012535313, 0.09457703892991251}, {0.6687532238318123, 
            0.14053352316261958`}, {0.7022483773004576, 
            0.18774642945733447`}, {0.7333793617567304, 
            0.23336441132255908`}, {0.7585555038298997, 
            0.272195524966618}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7618195911630208, 0.277229979642326}, {
            0.7640140540034763, 0.2806146696276994}, {0.7941862853780959, 
            0.3297072954467247}, {0.823512897380779, 0.38133551525803644`}, {
            0.8510066836578652, 0.4359973931411739}, {0.8743148070957658, 
            0.48886747022020816`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8767351783171916, 0.49435762533190525`}, {
            0.8767822490901768, 0.4944643964927208}, {0.8888575369321139, 
            0.5253690353923662}, {0.9001669454480006, 0.557713386005551}, {
            0.9107104746378369, 0.591497448332275}, {0.9204881245016233, 
            0.6267212223725385}, {0.9292816883304925, 0.6636688747585267}, {
            0.9368729594155777, 0.7026245721224252}, {0.9403902076499374, 
            0.7251758538341034}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{0.9413148292331406, 0.7311041820071953}, {
            0.9432619377568788, 0.7435883144642341}, {0.9484486233543958, 
            0.7865601017839531}, {0.9523590527635104, 0.8333179185214983}, {
            0.9545815040490462, 0.8824006092008}, {0.9549864522200036, 
            0.9335113606886491}, {0.9539096293773434, 0.9704105320436976}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.9537346068122449, 0.9764079787589013}, {
            0.9534443722853828, 0.9863533598518365}, {0.9498588531314439, 
            1.0400888804748547`}, {0.9441334836444468, 1.0938801963421965`}, {
            0.9388566547131711, 1.135673054088629}, {0.9322381119513728, 
            1.1763850140286845`}, {0.9223364012870119, 
            1.2138269721141994`}}]}, {
           Arrowheads[{{0.013937741304701282`, 1.}}], 
           
           ArrowBox[{{0.9207339442232495, 1.2196068946205467`}, {
            0.908166990912534, 1.2565533055265514`}, {0.8944413479717406, 
            1.2918228869851531`}, {0.8790628127541815, 1.3217852406509822`}, {
            0.8436960041026224, 1.3661069707370228`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.1264375557841444`, -1.457846184651967}, {
            1.1725144575096142`, -1.4165103341755527`}, {
            1.2163156359192082`, -1.3808732921477886`}, {
            1.2589789526708641`, -1.3480856543443496`}, {
            1.298418848706972, -1.3187436392053804`}, {
            1.3132214957453991`, -1.3073703002095787`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{1.3179769205512544`, -1.3037116676415814`}, {
            1.3358574547896622`, -1.289531084195522}, {
            1.369303433548406, -1.2617358875166325`}, {
            1.3973907681201128`, -1.2354873144877294`}, {
            1.4203702807337066`, -1.2104188124885797`}, {
            1.4494401043775051`, -1.1697323680051988`}, {
            1.4673145049481013`, -1.1306441516908172`}, {
            1.4697128536936077`, -1.122745399070932}}]}, {
           Arrowheads[{{0.013163694034236768`, 1.}}], 
           
           ArrowBox[{{1.4714560848073581`, -1.1170042192893843`}, {
            1.4730840118049688`, -1.1116427835676392`}, {
            1.477813391934388, -1.092847761267316}, {
            1.4813052335968038`, -1.074144465632522}, {
            1.4854761436476487`, -1.036728893128709}, {
            1.486913793790767, -0.9989673919498262}, {
            1.4866348776194012`, -0.9604507766277056}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -0.4681793116971807}, {-1.4726320759063738`, \
-0.48481951587611066`}, {-1.4210443654571445`, -0.52145091623009}, \
{-1.3791798673147255`, -0.5576048460902437}, {-1.3418773703106002`, \
-0.5938108388505056}, {-1.3170832939696475`, -0.6218121441888372}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.3131057190083892`, -0.6263042369558637}, \
{-1.3098866607342745`, -0.6299396953772968}, {-1.2869435652397645`, \
-0.6623734010609909}, {-1.265396393967094, -0.69517734832955}, \
{-1.2443240268629303`, -0.7285439386028699}, {-1.2240335039450512`, \
-0.7624090380743186}, {-1.2058476989992128`, -0.7922691862144946}, \
{-1.1877829780163085`, -0.8225340105253882}, {-1.1842390338835316`, \
-0.8285913664653262}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.1812091209732858`, -0.8337701334765293}, \
{-1.1698393409963384`, -0.8532035110069999}, {-1.1520167879393028`, \
-0.8842776876593292}, {-1.1340816378769074`, -0.9156321397614027}, \
{-1.1158002098408584`, -0.9471424665922468}, {-1.0971725038311553`, \
-0.9788086681518611}, {-1.0781985198477984`, -1.0106307444402458`}, \
{-1.059663890676731, -1.0407005328934327`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.0564317980058404`, -1.0457551647365575`}, \
{-1.0385392052300897`, -1.0732992347143884`}, {-1.0176857464132296`, \
-1.1037848270779118`}, {-0.9961497532576987, -1.1337046509257362`}, \
{-0.9687335449062984, -1.1693102653770184`}, {-0.9400588219990753, \
-1.203004406259912}, {-0.9099451296018986, -1.2342116490486856`}, \
{-0.909342694667942, -1.2347459641371996`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9048538658689177, -1.2387272222314518`}, \
{-0.8782120127806367, -1.2623565692176084`}, {-0.8448326756711192, \
-1.2872828072342388`}, {-0.8098681275920105, -1.3090734692765866`}, \
{-0.7732696213834316, -1.3275123293845974`}, {-0.7349884098855027, \
-1.342383161598217}, {-0.6970823796563694, -1.353425827467039}}]}, {
           Arrowheads[{{0.003195458095458553, 1.}}], 
           
           ArrowBox[{{-0.6901018885545583, -1.3627347654908224`}, \
{-0.6549369441681304, -1.3627347654908224`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.5, -1.1855648815248698`}, {-1.466253635437186, \
-1.2053454756786033`}, {-1.4210770246915807`, -1.2347686230312545`}, \
{-1.380125556385398, -1.2631865124575643`}, {-1.344121697828816, \
-1.2893457058694224`}, {-1.3066626620967425`, -1.3160949342316524`}, \
{-1.3011904079395946`, -1.3197694677526022`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.2962092099510392`, -1.3231142646969338`}, \
{-1.2719304776023734`, -1.3394170557039655`}, {-1.23806778987883, \
-1.3610045955094585`}, {-1.2059440956969372`, -1.3791229719813114`}, \
{-1.175113574630021, -1.3940742667081758`}, {-1.1451304062514058`, \
-1.4061605612787031`}, {-1.0866293943405565`, -1.4231483223754504`}, \
{-1.0805151061477958`, -1.4242135022458833`}}]}, {
           Arrowheads[{{0.016248425309508773`, 1.}}], 
           
           ArrowBox[{{-1.074604133761835, -1.4252432621462532`}, \
{-1.0365137153641473`, -1.4318790545156124`}, {-0.9858412983438434, \
-1.4362570643797332`}, {-0.9340070017436928, -1.4374450239220868`}, \
{-0.8804056840277434, -1.4366056050969482`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.719792732572761, 1.5}, {-0.7270777619246823, 
            1.4863778131249157`}, {-0.7590335063067363, 
            1.4362819180656095`}, {-0.7909061191826788, 
            1.3963913455672166`}, {-0.8248553289250289, 
            1.3592885104051644`}, {-0.8589960064784378, 
            1.328430927680104}, {-0.8737531925370288, 1.318546297340325}}]}, {
          
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.8787382316759456, 
            1.3152072278915912`}, {-0.9121387187212561, 
            1.2928349770911565`}, {-0.9659323211875844, 
            1.2605162504054879`}, {-1.0194225336579867`, 
            1.2289629589090034`}, {-1.0723059661365375`, 
            1.1989405377908882`}, {-1.084562528953781, 
            1.1919112823896185`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0897673158027872`, 
            1.1889262876063045`}, {-1.1233565617872747`, 
            1.1696625354205077`}, {-1.1713482637742376`, 
            1.140342500167229}, {-1.215065813105316, 
            1.110594800873704}, {-1.2532939507884007`, 
            1.080033806382587}, {-1.2793443300384986`, 
            1.0556260788910596`}, {-1.2843737518379694`, 
            1.0500352001092768`}}]}, {
           Arrowheads[{{0.004350573624299521, 1.}}], 
           
           ArrowBox[{{-1.2883864958087923`, 
            1.04557449547608}, {-1.3019171854037872`, 
            1.0305333141284536`}, {-1.3205808924707445`, 
            1.0045701425079483`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5203024102113547, 1.5}, {-0.5371532318262523, 
            1.4670464237822791`}, {-0.5566382998562841, 
            1.4335591759601263`}, {-0.5758033955911095, 
            1.4060510591425828`}, {-0.6034250858196193, 
            1.372260729212061}, {-0.6378231569715482, 
            1.3429881613054493`}, {-0.6716797518071003, 
            1.3182907585554142`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6766039121777954, 
            1.314863251000504}, {-0.7079849696766631, 
            1.2933014780595298`}, {-0.7439791815231569, 
            1.2715277107267586`}, {-0.7808403028214697, 
            1.251477587025092}, {-0.818704598628271, 
            1.2324190911534836`}, {-0.8575739453279722, 
            1.2139710121663956`}, {-0.8871176129538122, 
            1.2004729523887725`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8925749917034393, 
            1.1979795576781183`}, {-0.897450219304984, 
            1.1957521391182908`}, {-0.936523117504173, 
            1.178075239785398}, {-0.9758095158401744, 
            1.1599855152223282`}, {-1.0153094143129882`, 
            1.1414829654290815`}, {-1.0550228129226145`, 
            1.1225675904056573`}, {-1.093904543178901, 
            1.1029652009908553`}, {-1.1090730485348568`, 
            1.0945360733459266`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.1143176721382075`, 
            1.0916216397372855`}, {-1.130909436591695, 
            1.0824016080234737`}, {-1.166037493160997, 
            1.060876811503513}, {-1.1992887128868066`, 
            1.0383908114309728`}, {-1.2297271795848164`, 
            1.0147410861492479`}, {-1.2564169770707192`, 
            0.9897251140017331}, {-1.2793581053445142`, 
            0.9633428949884284}, {-1.296191040925255, 0.9390058292114016}}]}, {
           Arrowheads[{{0.005389957066686643, 1.}}], 
           
           ArrowBox[{{-1.299429405359324, 
            0.9339641084509052}, {-1.3143084676026928`, 
            0.9063622511782871}, {-1.3269459282808975`, 
            0.8755288960091285}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4487582451926093, 
            0.7626629198444598}, {-0.48180905526533163`, 
            0.7309281766801881}, {-0.5125309011423447, 
            0.6886363913170155}, {-0.5368291218660506, 
            0.6408414959579133}, {-0.5569160749384542, 
            0.5834668452574588}, {-0.5635427373913258, 
            0.5567755486349608}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.5649662895181248, 
            0.5509475348351663}, {-0.5712497025623454, 
            0.5169216518963441}, {-0.5757907309298333, 
            0.48067996710494426`}, {-0.5783423655819636, 
            0.44298307425201644`}, {-0.5786527292292868, 
            0.40420598538135766`}, {-0.5765281243624816, 
            0.36473821330914613`}, {-0.5718766680874519, 
            0.32499464720323296`}, {-0.5695705525287917, 
            0.31243204850258416`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5684872344094751, 
            0.3065306569842759}, {-0.5646064775101016, 
            0.2853901762314688}, {-0.5543816300440313, 
            0.24646817830723503`}, {-0.5410614348566842, 
            0.20866924034748915`}, {-0.5248468566847285, 
            0.17225406502544227`}, {-0.5059388602648319, 
            0.13748335501430559`}, {-0.4880282129161194, 
            0.1097873798366543}, {-0.4724790352218261, 
            0.08924648447893944}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4688576808004885, 
            0.0844625747645888}, {-0.46827402242230665`, 
            0.0836915458454655}, {-0.44667628878339377`, 
            0.05919585304073944}, {-0.4232350119993811, 
            0.03630030142247636}, {-0.3982557046625149, 
            0.0151044910695551}, {-0.37204387936504185`, \
-0.004291977939144907}, {-0.34459953610696237`, -0.021889105603623518`}, \
{-0.31592267488827575`, -0.037686891923881055`}, {-0.2766918991389227, \
-0.055042391675474284`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2712048643851578, -0.0574698285152243}, \
{-0.25656091103286355`, -0.0639482405250168}, {-0.195648100262586, \
-0.08313982373583667}, {-0.15339969993027466`, -0.09246592819429691}, \
{-0.11196919373429909`, -0.09879109364785074}, {-0.07135658167465919, \
-0.1021153200964982}, {-0.037159768954690385`, -0.10239313083986461`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.031160691329977157`, -0.10241426832054086`}, {
            0.0070218168315645, -0.10009772708974826`}, {
            0.04400131687005073, -0.09542944985569962}, {
            0.0793766363641036, -0.08843377583809331}, {
            0.11314777531372307`, -0.07911070503692935}, {
            0.14531443754268134`, -0.06782291889128736}, {
            0.1758763268747506, -0.05493309884024693}, {
            0.19882970165831243`, -0.04246546027083248}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.20410212526072474`, -0.03960162554153582}, {
            0.23218578684822233`, -0.02434735702197066}, {
            0.2634574954621292, -0.003089455907677271}, {0.2926645323693795, 
            0.019571280318038935`}, {0.3198068975699731, 
            0.04363485165517784}, {0.3448845910639098, 0.0691012581037393}, {
            0.3725946212228108, 0.10128113448097859`}, {0.3838747564908597, 
            0.11629604135798234`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.38747863111993947`, 0.12109313294121017`}, {
            0.39759922308171675`, 0.1345645800679717}, {0.41989839664062795`, 
            0.1689515948647187}, {0.4394921418995441, 0.20444217887121954`}, {
            0.46459336267340046`, 0.2622837526027903}, {0.482108552670069, 
            0.3225673173412101}, {0.48431802156250253`, 
            0.3382082561028287}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.48515726090716604`, 0.344149272625476}, {
            0.4910316057442269, 0.3857340481232207}, {0.49190128867946015`, 
            0.4185925472534}, {0.4900728344046804, 0.45248407820755043`}, {
            0.4862609255960796, 0.4814800594463545}, {0.480147362714766, 
            0.5114575084037969}, {0.47173214576073963`, 0.5424164250798774}, {
            0.46101527473400056`, 0.574356809474596}, {0.4589405246144612, 
            0.579535656504232}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.45670920359108635`, 0.5851053249405616}, {
            0.4477321183517418, 0.6075133011053686}, {0.4316180453311563, 
            0.6421205394896103}, {0.4126730556722442, 0.6781785246273218}, {
            0.3908971493750053, 0.7156872565185024}, {0.36507278047223296`, 
            0.7564757015774636}, {0.3395234739137329, 0.7938905143386383}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.33613990930909066`, 0.7988454604096075}, {
            0.3359793642173911, 0.7990805652071451}, {0.30369331018983764`, 
            0.8433280514558283}, {0.2682910279689307, 0.8890443643717948}, {
            0.22999566081173178`, 0.9355852938123774}, {0.1890303519753029, 
            0.9823066296349098}, {0.18587159196463574`, 
            0.9858022665102706}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.18184888522103704`, 0.9902539887000535}, {
            0.17137738337141, 1.0018422600097923`}, {0.1533198896210548, 
            1.0211855510354226`}, {0.10718207513838739`, 
            1.0642016652757937`}, {0.059872340225361954`, 
            1.1029877675338686`}, {0.012955768134153743`, 1.13838617197609}, {
            0.00033662084906110716`, 1.1462905646969963`}}]}, {
           Arrowheads[{{0.019710794300020155`, 1.}}], 
           
           ArrowBox[{{-0.004748210694996154, 
            1.149475606010474}, {-0.0345810045108475, 
            1.1681622979837807`}, {-0.08240043731110001, 
            1.1920631312765324`}, {-0.13016498986806194`, 
            1.209835657573937}, {-0.17774116192261447`, 
            1.2220229691194446`}, {-0.22499545321563877`, 
            1.2291681581565053`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.344603374670276, 1.5}, {-0.3577593085868611, 
            1.4736885121404444`}, {-0.3763035728211805, 
            1.4411217433113717`}, {-0.39428707142560687`, 
            1.4147768920926278`}, {-0.40676295443344973`, 
            1.400421734439113}, {-0.4191177325456081, 
            1.3873414919189042`}, {-0.44363559713710043`, 
            1.3632779216723883`}, {-0.46785241275642064`, 
            1.3428052598804758`}, {-0.49191660465156106`, 
            1.3249278995509846`}, {-0.4987417136985288, 
            1.3204655072063352`}}]}, {
           Arrowheads[{{0.013049909238543883`, 1.}}], 
           
           ArrowBox[{{-0.5037635916924581, 
            1.3171821032692466`}, {-0.5286488296285048, 
            1.3009116386515527`}, {-0.5656502976389481, 
            1.279981895290464}, {-0.6032391890045609, 
            1.2611881095268664`}, {-0.6417336840470129, 
            1.243579721419908}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -1.4004968513051532`}, {-1.4826776370242547`, \
-1.4049878506754643`}, {-1.4448726097074123`, -1.4149203348861021`}, \
{-1.4116030399002724`, -1.423448127191742}, {-1.3873069082148208`, \
-1.4290849171447886`}, {-1.3646064292035078`, -1.4340228778351198`}, \
{-1.3217405936772413`, -1.4426129540807922`}, {-1.2832059636094173`, \
-1.4488904887090388`}, {-1.2656048517651515`, -1.4510925449048548`}}]}, {
           Arrowheads[{{0.008410430244038057, 1.}}], 
           
           ArrowBox[{{-1.2596512643544087`, -1.4518373918305012`}, \
{-1.2477708863633896`, -1.4533237331591191`}, {-1.2019804871247144`, \
-1.4572215998704223`}, {-1.1590176510139623`, -1.4589142744694907`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.5, -1.0045132003632002`}, {-1.485708505139748, \
-1.0134207713935037`}, {-1.4446829087510467`, -1.0418114651588648`}, \
{-1.4094301020351137`, -1.0697260819321435`}, {-1.3696665273293638`, \
-1.1081943780813022`}, {-1.3338086136392948`, -1.1451978370211113`}, \
{-1.318943400304309, -1.1606603800070228`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.3147851283218068`, -1.1649857440517637`}, \
{-1.2992124396372136`, -1.1811841909065441`}, {-1.2671397450111082`, \
-1.2151363346832247`}, {-1.2369434473534553`, -1.246757792618781}, \
{-1.2079764642567317`, -1.2757520889808414`}, {-1.1798981927385364`, \
-1.3019590788606783`}, {-1.1523680298164678`, -1.3252186173495644`}, \
{-1.142812425781902, -1.3319136307335162`}}]}, {
           Arrowheads[{{0.0038959327082200984`, 1.}}], 
           
           ArrowBox[{{-1.132332807026095, -1.3582833944855848`}, \
{-1.1051756046959544`, -1.3582833944855848`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.18382426614257283`, 1.5}, {-0.19093924176723548`, 
            1.4863182496522065`}, {-0.2094378294878327, 
            1.4551172724355659`}, {-0.22724347466743025`, 
            1.4300542965654337`}, {-0.23876217368153035`, 
            1.4172357247488803`}, {-0.2501028744661154, 
            1.4055621942023704`}, {-0.27246616430927934`, 
            1.384128132163851}, {-0.29425798236621137`, 
            1.3659997395149812`}, {-0.3155942295511686, 
            1.3503129825437135`}, {-0.3466168541863597, 
            1.3301063091735927`}, {-0.3476828827517881, 
            1.3295023807871185`}}]}, {
           Arrowheads[{{0.002314893300286628, 1.}}], 
           
           ArrowBox[{{-0.3557973202159357, 
            1.3144917735821475`}, {-0.3741789647762479, 
            1.3144917735821475`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.017229442696263676`, 1.}}], 
           
           ArrowBox[{{-0.036442678479282245`, 1.5}, {-0.05512714776299952, 
            1.4705463315041292`}, {-0.07362434010704055, 
            1.4463261641902971`}, {-0.08422138144148031, 
            1.4353215567110011`}, {-0.0946521189201091, 
            1.4252377914358796`}, {-0.11520328369413584`, 
            1.4066402477486195`}, {-0.13517504996132246`, 
            1.3907937305587192`}, {-0.1546414743563694, 
            1.3770425754720201`}, {-0.18391089903206467`, 
            1.3586528437601797`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.33668070509341286`, -0.6527031086760361}, \
{-0.30087713230902197`, -0.6657329076263802}, {-0.2645504122638044, \
-0.6781584705107706}, {-0.21361232972363506`, -0.6943378563616147}, \
{-0.16252287928478357`, -0.7091926553038942}, {-0.13023577055160385`, \
-0.7178848030676183}, {-0.10752998681288096`, -0.7236178814156441}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.10171256188569198`, -0.7250867473783923}, \
{-0.09810857060216133, -0.7259967342183905}, {-0.06614127943645601, \
-0.733528448756211}, {-0.03433389705448793, -0.7404799466810799}, {
            0.02861017406462035, -0.7525341476589157}, {
            0.09053267546154742, -0.7620511921188515}, {
            0.13437595127147425`, -0.7672010542964529}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.14035088817814667`, -0.76774252309018}, {
            0.18038349536513285`, -0.7710774901505955}, {
            0.22471518288605646`, -0.77322943590034}, {
            0.2686510554530672, -0.7738072461393327}, {
            0.3124753227735517, -0.7726449753541841}, {
            0.35647219455489665`, -0.7695766780315041}, {
            0.37988593730675324`, -0.7669398448802855}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.38584824631547987`, -0.7662683753839884}, {
            0.4006416707971018, -0.7646023541712929}, {
            0.4449837515001672, -0.7577220037735504}, {
            0.49924075550857827`, -0.7464635162400141}, {
            0.5549901574703155, -0.7315575045725506}, {
            0.6122319573853788, -0.7130039687711599}, {
            0.6187295320344065, -0.7105479372009237}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6243419669237595, -0.708426481424158}, {
            0.6709661552537682, -0.6908029088358421}, {
            0.7231541127232641, -0.668432097200005}, {
            0.777073003181424, -0.6427791607421769}, {
            0.8046613989013512, -0.6286859506313727}, {
            0.8326422291086406, -0.6137003191677834}, {
            0.8421930128429104, -0.6083555747331014}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8474289121427188, -0.6054254964880257}, {
            0.8610154938032925, -0.5978222663514093}, {
            0.8897811929853068, -0.5810517921822502}, {
            0.9187950819935058, -0.5633822294357146}, {
            0.9479129161667122, -0.5448069108872108}, {
            0.977134695504926, -0.5253258365367391}, {
            1.006460420008147, -0.5049390063842992}, {
            1.0436215822474944`, -0.4785779281236677}, {
            1.048590966075311, -0.47482612521985107`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0533794872017306`, -0.4712108706753089}, {
            1.0803780851704547`, -0.4508273740955043}, {
            1.1269710009934495`, -0.4088930204317732}, {
            1.1701086271686385`, -0.365026542155797}, {
            1.2108542243552316`, -0.3204459737440454}, {
            1.2241357878545565`, -0.3034537055988043}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.2278307497178256`, -0.29872641707059}, {
            1.2468157635646335`, -0.27443722506074303`}, {
            1.2776306565936852`, -0.22739158828223482`}, {
            1.302936315239228, -0.17970035558486558`}, {
            1.3230213983377095`, -0.13170258625661602`}, {
            1.3371534918937529`, -0.08696940402626066}}]}, {
           Arrowheads[{{0.00300524880222464, 1.}}], 
           
           ArrowBox[{{1.3408154676640418`, -0.05469988453525978}, {
            1.3450635805290925`, -0.05469988453525978}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5900148211420025, -0.6526475896914085}, \
{-0.5605863750002631, -0.6716326184270798}, {-0.5298765196740409, \
-0.6904281437017958}, {-0.4980256798396333, -0.7089891167056189}, \
{-0.4651742801733375, -0.7272704886286111}, {-0.43132232067515347`, \
-0.7452722594707729}, {-0.39646980134508164`, -0.7629944292321041}, \
{-0.3810786248832844, -0.7703851258196766}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.37566988854768524`, -0.7729823495782251}, \
{-0.3432306002479557, -0.7885593873657637}, {-0.2887110164052373, \
-0.8132544719590796}, {-0.24795007260159474`, -0.8309085410403205}, \
{-0.20686254290440853`, -0.8479846306182538}, {-0.15551390920749236`, \
-0.868373152547334}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.14990869418034142`, -0.8705130746893028}, \
{-0.1012208118114685, -0.8888330739019946}, {-0.048511016191548226`, \
-0.907518931481702}, {0.0040192488842387825`, -0.9249404419129329}, {
            0.04021465470945114, -0.9362699358791401}, {
            0.07601438633679566, -0.9469359741907284}, {
            0.07739097664754188, -0.9473224869831546}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.08316759617195382, -0.9489444200490309}, {
            0.11152193011837871`, -0.9569056215085101}, {
            0.14684077240630677`, -0.9661459424932969}, {
            0.18207439955268642`, -0.9746240018059015}, {
            0.21732629790962402`, -0.9823068641071353}, {
            0.2526999538292261, -0.9891615940578106}, {
            0.28829885366359953`, -0.9951552563187395}, {
            0.31759945070889994`, -0.9992929375890314}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.32354050589581057`, -1.0001319031819387`}, {
            0.32595460486543787`, -1.0004728099585418`}, {
            0.3639425064363514, -1.0047795131115125`}, {
            0.40226255837634023`, -1.0080753657776513`}, {
            0.4409147606854044, -1.0103603679569584`}, {
            0.48015330938559736`, -1.0115729540373488`}, {
            0.5202324004989722, -1.0116515584067374`}, {
            0.5611520340255292, -1.0105961810651243`}, {
            0.5630292558057859, -1.0104977640348822`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.569021027006831, -1.0101836336888048`}, {
            0.6029122099652682, -1.0084068220125098`}, {
            0.6457697732518994, -1.0049866785790509`}, {
            0.6899815688191329, -1.0002389480949045`}, {
            0.735547596666969, -0.994163630560071}, {
            0.7824678567954072, -0.9867607259745501}, {
            0.8071821466228716, -0.9821946801630896}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8130822944123836, -0.9811046085774048}, {
            0.8368214370380938, -0.9767187243982312}, {
            0.8929591872585759, -0.9647137917356335}, {
            0.9504876146754652, -0.9506205787045541}, {
            1.009013226507373, -0.9343137360227894}, {
            1.04566881209939, -0.9226464178960319}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.051386178496456, -0.9208266043117052}, {
            1.0675622245625944`, -0.9156778371473409}, {
            1.1251608106494249`, -0.8945974555352099}, {
            1.1744942655353214`, -0.8753362451049548}, {
            1.2215538349220898`, -0.8541530008569168}, {
            1.259892806382444, -0.8301422382225709}, {
            1.2693814637717322`, -0.822986277934123}}]}, {
           Arrowheads[{{0.017871810852133487`, 1.}}], 
           
           ArrowBox[{{1.2741718826731343`, -0.8193735384266179}, {
            1.2940318433884406`, -0.8043959621080441}, {
            1.3257747528516566`, -0.7778052159667153}, {
            1.3527254072293118`, -0.749525529771782}, {
            1.3750499542648484`, -0.7196360195385103}, {
            1.392914541701709, -0.6882158012821659}, {
            1.4068069315197291`, -0.6553697394769059}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.015190292999712014`, 1.}}], 
           
           ArrowBox[{{0.013823115102344876`, 0.4635058809487205}, {
            0.013310444957492087`, 0.4624492932724729}, {
            0.010001688019841143`, 0.4397932099057668}, {
            0.017845869281084187`, 0.4126631963516861}, {
            0.018744110157493707`, 0.4107700482602931}, {
            0.019688042121585616`, 0.40888294519421703`}, {
            0.02808565531183254, 0.3971147467059466}, {0.03767067165808521, 
            0.38674575325110316`}, {0.0583137152515523, 
            0.36945093194680334`}, {0.08023637068460406, 
            0.3598721505307402}, {0.10027194480670604`, 0.3587776410537689}, {
            0.12261629223420971`, 0.3725893732032201}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.5, 1.2521043105247822`}, {1.4980465521849602`, 
            1.2533580827671362`}, {1.4573966829438034`, 
            1.2838263381374158`}, {1.423432489874233, 1.3113396391602754`}, {
            1.3928111348904555`, 1.3373754630094248`}, {1.3663771930473645`, 
            1.3602390969196279`}, {1.3478720214224678`, 
            1.3754119272568823`}, {1.330760097016622, 1.3887499596505926`}, {
            1.3126183401979508`, 1.4018859804642698`}}]}, {
           Arrowheads[{{0.013173559964671568`, 1.}}], 
           
           ArrowBox[{{1.3077585457848406`, 1.405404843670236}, {
            1.2987786143778097`, 1.411907001484784}, {1.2706732784877428`, 
            1.4287163008147592`}, {1.2454428232808707`, 
            1.4405205281640359`}, {1.2004741240981012`, 
            1.4538211261892486`}, {1.1612139117572573`, 
            1.458146183895918}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7881380909415538, -1.5}, {
            0.8133346480770638, -1.4730943384800552`}, {
            0.8550695413006528, -1.4342388457216386`}, {
            0.8970617924177086, -1.4018601090998144`}, {
            0.9499417264918821, -1.3669334120503687`}, {
            0.9763462514902288, -1.3532988019771686`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.9816774430820027, -1.3505459132740425`}, {
            0.9895158889077267, -1.3464983436843476`}, {
            1.0291479506458656`, -1.3274027821865768`}, {
            1.068103215275049, -1.3089800272968932`}, {
            1.1066265816056933`, -1.2914523124353514`}, {
            1.1393023194069694`, -1.2762324974493242`}, {
            1.1709832285003048`, -1.2613580673614289`}, {
            1.1987528161888035`, -1.2482099041108592`}}]}, {
           Arrowheads[{{0.01975731475094166, 1.}}], 
           
           ArrowBox[{{1.2041715750422932`, -1.245633677040719}, {
            1.2313605605631541`, -1.2326453618800346`}, {
            1.286191143685775, -1.2048223467281831`}, {
            1.3339075437597017`, -1.17739717264289}, {
            1.3739890136830473`, -1.1501625680258385`}, {
            1.4059148063539244`, -1.122911261278712}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.338479769916578, 1.5}, {-1.3426429253132137`, 
            1.4857509913478502`}, {-1.3552381748510562`, 
            1.4441285756266082`}, {-1.3668187113981762`, 
            1.4067224982393454`}, {-1.3765871667768395`, 
            1.3744632795757343`}, {-1.3829413722882713`, 
            1.3510605342460524`}, {-1.3884011801702196`, 
            1.329407436964031}, {-1.3976906999891878`, 
            1.2888401902297089`}, {-1.4013071714336625`, 
            1.2685527237921856`}}]}, {
           Arrowheads[{{0.012958668780858136`, 1.}}], 
           
           ArrowBox[{{-1.4023601403016486`, 
            1.2626458416566548`}, {-1.4040957679355386`, 
            1.2529094209738982`}, {-1.4082860749604533`, 
            1.2202327914195394`}, {-1.4114011364160115`, 
            1.1803505405768007`}, {-1.4122465209390809`, 
            1.1431254510876925`}, {-1.4114817094392373`, 
            1.1077022036567494`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.5, -0.2332009363539466}, {-1.4542681044556411`, \
-0.2635829724166127}, {-1.4144997509056003`, -0.29566473872312626`}, \
{-1.3774205103883521`, -0.3293878708271265}, {-1.3467673680191004`, \
-0.3622062283080844}, {-1.3238287573873673`, -0.3937122116124905}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.320297193334532, -0.39856278429421804`}, \
{-1.3141315832544591`, -0.4070311964122356}, {-1.2848899499832707`, \
-0.45148260457631006`}, {-1.2566161562985405`, -0.4959752835584309}, \
{-1.2302780417867272`, -0.5405505041766444}, {-1.2051405609603, \
-0.5855115644649652}, {-1.1954814222315844`, -0.6033837886206315}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.1926286681242912`, -0.6086622158488237}, \
{-1.1804686683317294`, -0.6311617624574078}, {-1.1558091047329724`, \
-0.677729196761275}, {-1.1307086109959872`, -0.7254419659838691}, \
{-1.1086774662477432`, -0.7669114179030396}, {-1.085591756380092, \
-0.8093068148248688}, {-1.079464856817961, -0.8203019468608699}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0765442654548238`, -0.8255431438701005}, \
{-1.0614514813930342`, -0.8526281567493569}, {-1.0362566412865692`, \
-0.8968754436765038}, {-1.0095556649258293`, -0.9415023794536855}, \
{-0.980896981175946, -0.9859626679282776}, {-0.950661717591746, \
-1.0297049205621087`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9471152664166859, -1.034544262483364}, \
{-0.9177064915087499, -1.0743833029696936`}, {-0.8907976198704056, \
-1.1079017356262801`}, {-0.8623137169218653, -1.1398800344134503`}, \
{-0.8322547826631292, -1.1703181993312046`}, {-0.8006208170941971, \
-1.1992162303795426`}, {-0.7857989914148419, -1.2111820268030966`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.7811304702305262, -1.2149509669660066`}, \
{-0.7673881417217092, -1.2260452753784408`}, {-0.7325330780523056, \
-1.2502764821478747`}, {-0.6960556260859866, -1.2719098506878448`}, \
{-0.657955785822752, -1.2909453809983507`}, {-0.6184281608254606, \
-1.3073888411886951`}, {-0.5776673546569708, -1.3212459993681804`}, \
{-0.5689515918343868, -1.3235852416120424`}}]}, {
           Arrowheads[{{0.006045574602856668, 1.}}], 
           
           ArrowBox[{{-0.5631566790834638, -1.3251405506518121`}, \
{-0.5356733673172829, -1.3325168555368068`}, {-0.49244619880639706`, \
-1.341201409694574}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5420870949162806, -1.5}, {
            0.5427086850225513, -1.499228072744046}, {
            0.5755927212685042, -1.4635666826176157`}, {
            0.6083734868805037, -1.4341211176610351`}, {
            0.6537737304466092, -1.3995136521196254`}, {
            0.6824172974682967, -1.3834331901717176`}, {
            0.7113445646906034, -1.368522851831127}, {
            0.733046457954183, -1.358374671173699}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7384815751664924, -1.3558331163565727`}, {
            0.7702881680528834, -1.3409598033793104`}, {
            0.7999363506672807, -1.3274387956207807`}, {
            0.8299372951481923, -1.3144388207970077`}, {
            0.8602910014956187, -1.3019598789079918`}, {
            0.8909974697095592, -1.2900019699537322`}, {
            0.921977125110231, -1.278386552066756}, {
            0.9531503930178502, -1.2669350833795887`}, {
            0.9602434867901667, -1.264382600215101}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.9658890726345183, -1.262351009588509}, {
            0.9845172734324171, -1.255647563892231}, {
            1.0160777663539315`, -1.2445239936046821`}, {
            1.0475844651107673`, -1.2334738199932067`}, {
            1.0787899630312976`, -1.2224064905340681`}, {
            1.1096942601155229`, -1.2113220052272669`}, {
            1.1402973563634426`, -1.2002203640728024`}, {
            1.1799066506151892`, -1.18529385337189}, {
            1.191525195232924, -1.1806136545370756`}}]}, {
           Arrowheads[{{0.00812785892517593, 1.}}], 
           
           ArrowBox[{{1.1970906242747772`, -1.1783717804148068`}, {
            1.2174658626740489`, -1.170164197610522}, {
            1.2529749925400213`, -1.154831396788698}, {
            1.2864340402131065`, -1.1392954509064188`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.42647362384570026`, -0.4957078902889241}, \
{-0.3879910594759338, -0.5098088301498016}, {-0.34860871336367605`, \
-0.5228253504204553}, {-0.30875797546490985`, -0.5346798991363197}, \
{-0.26843884577963534`, -0.545372476297395}, {-0.22765132430785245`, \
-0.5549030819036812}, {-0.19590297426322706`, -0.5611752055150311}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1900167415816058, -0.5623380747328771}, \
{-0.17174509450791742`, -0.5659477750438555}, {-0.11656938525019839`, \
-0.5745285945967009}, {-0.06212419653469518, -0.5806455405622178}, \
{-0.00840952836140756, -0.584298612940406}, {
            0.04218278879508778, -0.5854010200229613}, {
            0.048485812072785184`, -0.5852264316800925}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.054483511668863685`, -0.5850603005415308}, {
            0.09157436456778889, -0.5840329157044595}, {
            0.1427919327983409, -0.5797836187974501}, {
            0.19271391158690895`, -0.5726012507612364}, {
            0.24147837277852496`, -0.5624201009532653}, {
            0.28922338821822124`, -0.5491744587309845}, {
            0.29083087909326566`, -0.5486178215469985}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.29650057958928755`, -0.5466545344346766}, {
            0.3331406611252717, -0.5339669154106216}, {
            0.37663403086954833`, -0.5159565524885357}, {
            0.419703497451051, -0.4951433699647267}, {
            0.4623490608697798, -0.47152736783919474`}, {
            0.5049292186958276, -0.4451773052496255}, {
            0.5111353953120902, -0.4409771460857451}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5161044033509464, -0.43761426649976803`}, {
            0.5478024684992875, -0.41616194133370477`}, {
            0.5909688102801594, -0.38448127609143246`}, {
            0.6344282440384434, -0.35013530952280864`}, {
            0.6604734439964405, -0.3285450631139619}, {
            0.6867889062712496, -0.3061738036153833}, {
            0.7052031510331535, -0.2901376932296676}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.709727896502137, -0.2861973025839431}, {
            0.7133746308628702, -0.28302153102707295`}, {
            0.7402306177713028, -0.2590882453490308}, {
            0.7673638434222487, -0.23445485245636338`}, {
            0.7947812842414095, -0.2092022582241771}, {
            0.8224829402287853, -0.1833304626524721}, {
            0.8504688113843757, -0.15683946574124832`}, {
            0.8786168628277728, -0.12980373627254346`}, {
            0.8856315820244374, -0.12295878553467442`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8899258690879811, -0.11876842771989522`}, {
            0.9068050596785686, -0.1022977430283953}, {
            0.935033401936763, -0.0743214860088038}, {
            0.963301889602356, -0.045874965213768965`}, {
            0.9874777758886151, -0.02136313553038204}, {1.0114540325397277`, 
            0.003449346134826366}, {1.048419467634194, 
            0.044723321478528644`}, {1.0562721182232961`, 
            0.054099161437439466`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0601246351603113`, 0.05869895635134722}, {
            1.083500629386755, 0.08660922413426891}, {1.107294033674691, 
            0.11601480460085907`}, {1.129666512874634, 
            0.14571771524149751`}, {1.1506180669865844`, 
            0.1757179560561843}, {1.1701486960105414`, 
            0.20601552704491927`}, {1.188055992369851, 0.236635512221475}, {
            1.1974902416768298`, 0.25480259483806644`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.2002554428876906`, 0.2601274105403658}, {
            1.2041375484878576`, 0.26760299559962375`}, {1.2183933643645621`, 
            0.2989179771793657}, {1.2308234399999634`, 0.3305804569607007}, {
            1.2414955868964594`, 0.36268245648888675`}, {1.2504776165564468`, 
            0.39531599730918154`}, {1.257769528979926, 0.4284810794215852}, {
            1.263371324166897, 0.46217770282609766`}, {1.2663874815577334`, 
            0.48937239015310563`}}]}, {
           Arrowheads[{{0.006712480287058741, 1.}}], 
           
           ArrowBox[{{1.2670488848484942`, 0.49533582420463756`}, {
            1.2695229813505102`, 0.5176431086300395}, {1.2727979618338394`, 
            0.5756564398190958}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7063808538244111, 
            0.8355245592596027}, {-0.753694264255323, 
            0.8021104549898412}, {-0.8030180760320702, 
            0.7607360862328466}, {-0.8283737246941405, 
            0.7365669555014389}, {-0.8541597844154799, 
            0.7098115420439853}, {-0.8800518215562046, 
            0.6805828013659267}, {-0.8841275550333314, 
            0.6755679651693779}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.8879117701623261, 
            0.6709118169911636}, {-0.9057254024764314, 
            0.6489936889727039}, {-0.927493033700723, 
            0.6197668729502348}, {-0.948754542932067, 
            0.5887149301292945}, {-0.969509930170463, 
            0.555837860509883}, {-0.9897591954159116, 
            0.5211356640920004}, {-1.0091687201907502`, 
            0.4848786135826971}, {-1.01681348242543, 0.4691408289815661}}]}, {
          
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.019435099160431, 
            0.46374387375711196`}, {-1.0274048860173166`, 
            0.4473369816890238}, {-1.044467692895611, 
            0.40851076841098044`}, {-1.0603571408256334`, 
            0.36839997374856703`}, {-1.0748490720991006`, 
            0.32745809655975217`}, {-1.087719329007729, 
            0.2861386357025044}, {-1.0989679115515192`, 
            0.24444159117682404`}, {-1.1003753536058858`, 
            0.2382903326375863}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1017136036995405`, 
            0.23244147918696603`}, {-1.1085948197304707`, 
            0.20236696298271067`}, {-1.1192804172506756`, 
            0.14428998145236513`}, {-1.1269218284773133`, 
            0.08710409206512332}, {-1.1315190534103838`, 
            0.030809294820985204`}, {-1.13252554582747, \
-0.005096707543836884}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.132693667671569, -0.011094351668452537`}, \
{-1.1330720920498871`, -0.02459441028004924}, {-1.1330883323964873`, \
-0.05343672212287899}, {-1.1323619499365305`, -0.08191540067223556}, \
{-1.1279877987947131`, -0.12917752095469642`}, {-1.1218147085349446`, \
-0.17542497649720673`}, {-1.1146827100387444`, -0.22188753250697363`}, \
{-1.1093341373269991`, -0.249408514705806}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.1081894822162004`, -0.2552983164577602}, \
{-1.1057723063711933`, -0.26773585016760526`}, {-1.0950834975322914`, \
-0.3129699294791016}, {-1.0826162835220385`, -0.3575897704414628}, \
{-1.0682414829293148`, -0.40201312759061997`}, {-1.0518299143429994`, \
-0.4466577554625044}, {-1.0365176284493447`, -0.48389685629854895`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0342358643587108`, -0.48944605017105813`}, \
{-1.033381577763093, -0.4915236540571163}, {-1.0128964731895953`, \
-0.5366108233744553}, {-0.9898589337720162, -0.5823368729459313}, \
{-0.9637532926598646, -0.6291194123029535}, {-0.9345795498531414, \
-0.6769584414455224}, {-0.9194832453579724, -0.699852343875902}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.9161802759453659, -0.7048613750256739}, \
{-0.902337705351846, -0.7258539603736376}, {-0.8662099859015879, \
-0.7757057508888925}, {-0.8253786182479768, -0.8264135947928801}, \
{-0.8031990663449138, -0.852088536765649}, {-0.7798436023910124, \
-0.8779774920856008}, {-0.7665655536211161, -0.8921061936690069}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7624565750809564, -0.896478412254177}, \
{-0.7553122263862727, -0.904080460752736}, {-0.7296049383306946, \
-0.9303974427670545}, {-0.6908139905158274, -0.967595259554873}, \
{-0.6493526416915036, -1.0039104398120182`}, {-0.6052208918577233, \
-1.0393429835384902`}, {-0.583239392959402, -1.0555699887781713`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5784122176895765, -1.0591334672633577`}, \
{-0.5584187410144863, -1.0738928907342888`}, {-0.5093969407907006, \
-1.106709376838633}, {-0.45860624281527396`, -1.1369416572907407`}, \
{-0.4060466470882065, -1.1645897320906127`}, {-0.3718489611933602, \
-1.1803664685605149`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3664007921053683, -1.182879923073461}, \
{-0.35171815360949754`, -1.1896536012382488`}, {-0.3067413058549785, \
-1.207861033167503}, {-0.2614931959769165, -1.223870826910078}, \
{-0.2159738239753111, -1.237682982465974}, {-0.17018318985016184`, \
-1.249297499835191}, {-0.13837292521652683`, -1.2559644096069846`}}]}, {
           Arrowheads[{{0.0006876429688754903, 1.}}], 
           
           ArrowBox[{{-0.1322674873168278, -1.2588389813153}, \
{-0.12465729235514632`, -1.2588389813153}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, -0.02015331944299528}, {-1.496637457549265, \
-0.02235725607485742}, {-1.463280664708475, -0.04694929109326817}, \
{-1.435705670395895, -0.07079384791821686}, {-1.4030865915635071`, \
-0.10315952363622609`}, {-1.3758871835258184`, -0.13869286683354423`}, \
{-1.3521083179179578`, -0.1732395880496091}, {-1.3380676217064615`, \
-0.19445818656092226`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.334756588136587, -0.19946189085865657`}, \
{-1.3295199408098295`, -0.20737562358943343`}, {-1.3093125407011659`, \
-0.24069028777677687`}, {-1.2909149360847763`, -0.27331946143062774`}, \
{-1.2737559454534704`, -0.30539902536997443`}, {-1.2575440308282366`, \
-0.33703995298905565`}, {-1.2419876542300636`, -0.3683532176821098}, \
{-1.226853994875908, -0.3994596647671188}, {-1.2213862406181482`, \
-0.4108094211518128}}]}, {
           Arrowheads[{{0.015770934901141103`, 1.}}], 
           
           ArrowBox[{{-1.2187821651400252`, -0.41621486201304125`}, \
{-1.2118844953524757`, -0.43053278268397205`}, {-1.1970791556597669`, \
-0.46157257143266966`}, {-1.1824379757977814`, -0.49257903101321154`}, \
{-1.1677271684079884`, -0.523738024539489}, {-1.1527129461318562`, \
-0.5552354151253931}, {-1.137395308969385, -0.5870712027709238}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5, 1.0096393731201319`}, {1.484500909522698, 
            1.0233620477105165`}, {1.4493657350004936`, 
            1.0588947525798431`}, {1.4202349087116197`, 
            1.0938871464388515`}, {1.3841274897084392`, 
            1.1437216193125095`}, {1.3560682330046845`, 
            1.1915746778627783`}, {1.3527143889160047`, 
            1.1974718489113256`}}]}, {
           Arrowheads[{{0.016595606725969613`, 1.}}], 
           
           ArrowBox[{{1.3497482075011025`, 1.202687380314154}, {
            1.330972604882352, 1.2357011213392797`}, {1.3069045670577537`, 
            1.277367146298007}, {1.2848917098286243`, 1.3141123342211865`}, {
            1.2645093860045986`, 1.3457490902670977`}, {1.2453329483953126`, 
            1.3720898195940212`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6493768941287086, 0.41400890409198504`}, {
            0.6591593867569089, 0.4601923677122772}, {0.6659871777141888, 
            0.5090938645527738}, {0.6693141011972384, 0.5664448389451802}, {
            0.6675884789907279, 0.6285312374755179}, {0.6654100122932204, 
            0.6522898011805891}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6648621593714148, 0.658264736927195}, {
            0.6645599947023814, 0.6615601733673601}, {0.659726436888632, 
            0.6961928704435831}, {0.6530878055494799, 0.7324293287041872}, {
            0.6446441006849252, 0.7702695481491724}, {0.6327633969895312, 
            0.8145096180988498}, {0.6180106577101866, 0.8608625771034872}, {
            0.6070169236511191, 0.8905529323514483}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.6049334864493024, 0.896179591166952}, {
            0.6001849727597267, 0.9090037196737745}, {0.5790854320509873, 
            0.9586083403204015}, {0.5546120194452001, 1.0088076012647473`}, {
            0.5266647188035974, 1.0587326647281916`}, {0.5088965302971664, 
            1.0885343980280229`}, {0.4954121440684034, 
            1.1091817579361203`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.4921313431063795, 1.1142053368443872`}, {
            0.4898934804802749, 1.1176319633353653`}, {0.459535451637628, 
            1.153962229139144}, {0.4272427827808488, 1.1868265556531215`}, {
            0.39417076159764647`, 1.2175583537336965`}, {0.35954003576159776`,
             1.2440250949474667`}, {0.32367697144521845`, 
            1.2661645944113404`}, {0.3132224841518797, 1.271211447086948}}]}, {
           Arrowheads[{{0.008496060503542483, 1.}}], 
           
           ArrowBox[{{0.30781914576396113`, 1.27381988230095}, {
            0.2869079348210244, 1.283914667242226}, {0.24955258200781125`, 
            1.2976312125029792`}, {0.21193056912437463`, 
            1.3076701292564559`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.37633019678829, -1.5}, {
            1.3868936435133947`, -1.479301431659906}, {
            1.4049096033418638`, -1.4450837049199934`}, {
            1.4207385461295077`, -1.41512527287607}, {
            1.4317803914400635`, -1.3929972665805528`}, {
            1.4415560627225223`, -1.3724517909460006`}, {
            1.4587212905427198`, -1.3339006009082088`}, {
            1.4715703236036886`, -1.2997163871152428`}, {
            1.4767915273616703`, -1.282483934723455}}]}, {
           Arrowheads[{{0.006882116107992646, 1.}}], 
           
           ArrowBox[{{1.4785313423736455`, -1.2767417187989092`}, {
            1.480962082350897, -1.268719122310356}, {
            1.4895351441567597`, -1.2307717703985077`}, {
            1.4943256013303754`, -1.195799413382414}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.5, 0.800467519066341}, {1.4872274707718425`, 
            0.8115453102031752}, {1.4522319368770327`, 0.8467258694769543}, {
            1.4238628097928117`, 0.8820980216397848}, {1.3951312062874521`, 
            0.9328779765521037}, {1.370132465052463, 0.9840687772556418}, {
            1.3647218258541844`, 0.9956844717076634}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.3621883657116112`, 1.001123366789019}, {
            1.34638097396483, 1.035059067523311}, {1.3251239831719086`, 
            1.0856483369192422`}, {1.30569531180163, 1.1350606706663964`}, {
            1.2874287789819254`, 1.1825201539877346`}, {1.2715552142961442`, 
            1.2232796555205008`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.14124974124168843`, 0.4984254268667703}, {
            0.10081701313255512`, 0.5319656722808478}, {0.05642037773507419, 
            0.5593862864203641}, {0.011319770118619229`, 
            0.5787683079884278}, {-0.010600846288473654`, 
            0.5848691761550393}, {-0.03152943457355817, 
            0.5881602695108276}, {-0.06077188389469293, 
            0.587072572462926}, {-0.07293889016940477, 
            0.5825122911800693}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.07855722132096057, 
            0.5804065003377828}, {-0.08538352180928847, 
            0.5778479539176352}, {-0.11221614510445532`, 
            0.5428700344799412}, {-0.11346539773935244`, 
            0.5393714875519076}, {-0.11458747069735058`, 
            0.5357420358152981}, {-0.11624657515431534`, 
            0.5174131021403587}, {-0.11522841227143486`, 
            0.49727779654214943`}, {-0.10785456894870514`, 
            0.45456528262373924`}, {-0.09005352004810824, 
            0.4090992400422999}, {-0.06354792405446026, 
            0.36626036082842095`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.05980439982528157, 
            0.3615845624958017}, {-0.040126115357160076`, 
            0.3383795051305284}, {-0.014892891221609608`, 
            0.31539491820253096`}, {0.038953501948185254`, 
            0.28335658963731025`}, {0.09143732116364209, 
            0.27121858929072545`}, {0.14746621829010892`, 
            0.2817213757985828}, {0.14890966154702567`, 
            0.28297450309493566`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.15344046502754546`, 0.28690792651746594`}, {
            0.1846777957657932, 0.31402665919069417`}, {0.19962703175894195`, 
            0.3597730358809179}, {0.1909519434086748, 0.4116055683226428}, {
            0.1615542727848969, 0.46217066577141325`}, {0.13363458651142868`, 
            0.4900602498739562}}]}, {
           Arrowheads[{{0.001546583614558306, 1.}}], 
           
           ArrowBox[{{0.12697802275455028`, 0.5050076833052989}, {
            0.11867101980988783`, 0.5050076833052989}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3290330216221029, -1.5}, {
            0.348411882874775, -1.4786212043240028`}, {
            0.37863806366887093`, -1.4508810259285667`}, {
            0.4200447821740625, -1.4185443921380378`}, {
            0.4497115413378315, -1.4015967342421873`}, {
            0.4793754090992888, -1.3861910344922808`}, {
            0.5092212474915343, -1.3717418748840333`}, {
            0.5246049049850174, -1.3649153850576665`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5300891879110735, -1.3624817374276736`}, {
            0.5391874358368682, -1.3584443947522071`}, {
            0.5697657110262127, -1.3446934273161384`}, {
            0.6006511918936419, -1.3316683737854822`}, {
            0.6318438784391561, -1.319369234160239}, {
            0.6633437706627551, -1.3077960084404086`}, {
            0.6952539802303608, -1.2966946521068445`}, {
            0.7276776188078948, -1.2858111206403995`}, {
            0.7542420825987485, -1.2772089955116437`}}]}, {
           Arrowheads[{{0.00005819928511634982, 1.}}], 
           
           ArrowBox[{{0.7599893780351146, -1.2751580804880884`}, {
            0.7605755707851989, -1.2751580804880884`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, 0.17535835801672214`}, {-1.4797009911027752`, 
            0.15922523643254333`}, {-1.4529290160112522`, 
            0.13386834054777977`}, {-1.4222341492366017`, 
            0.10002403719330473`}, {-1.3925219002458749`, 
            0.05509796601530073}, {-1.3673543714530438`, 
            0.011663808108625572`}, {-1.3541059156683912`, \
-0.01237132864562198}}]}, {
           Arrowheads[{{0.01001612453856499, 1.}}], 
           
           ArrowBox[{{-1.3512095149181873`, -0.017625932597797437`}, \
{-1.3412099708297678`, -0.03576694567523903}, {-1.3187236999759278`, \
-0.08150591186046512}, {-1.2988413096339433`, -0.12575592806571023`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7838650660042819, 0.44815665027068347`}, {
            0.8051998605582155, 0.508459941769591}, {0.8185318872943572, 
            0.5556158401919236}, {0.8299365201070701, 0.6059948081761867}, {
            0.8390088134478484, 0.6601196473510801}, {0.8412194153537568, 
            0.6804960702979441}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8418665475545767, 0.6864610698716794}, {
            0.8453438217681867, 0.7185131593453037}, {0.8473592202321147, 
            0.7493975890917868}, {0.8484390498137809, 0.7815230299273473}, {
            0.848583310513185, 0.8148894818519854}, {0.8477920023303273, 
            0.849496944865701}, {0.8444796266584191, 0.9045468768187938}, {
            0.842210182307347, 0.9259603229236674}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8415778304881711, 0.9319269074723673}, {
            0.8383922754469892, 0.9619843579475164}, {0.8293062651791085, 
            1.0207604653287339`}, {0.816997912337848, 1.0798262760393116`}, {
            0.8013368888945263, 1.1372700720843842`}, {0.7911555629698342, 
            1.1659409503260076`}}]}, {
           Arrowheads[{{0.017984123634941725`, 1.}}], 
           
           ArrowBox[{{0.7891477397818726, 1.1715950325721272`}, {
            0.7821928668204617, 1.1911801354690865`}, {0.7683497718163237, 
            1.2257410744653368`}, {0.7529500261915394, 1.257424185039428}, {
            0.7402717849986231, 1.2757361751254737`}, {0.7268893802409471, 
            1.2923167454056959`}, {0.6987653601477396, 1.3218828766392048`}, {
            0.6680300392916987, 1.3445381523655566`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.05821909050508289, -0.4112699757291056}, \
{-0.02584519719356217, -0.40975709606779714`}, {
            0.03733257999963881, -0.40324286365269824`}, {
            0.08443138702900597, -0.39508939856554126`}, {
            0.12982921259895616`, -0.38419974088175457`}, {
            0.17352605670948867`, -0.37057389060133855`}, {
            0.17708644049723543`, -0.36918672652096685`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.1826771040175358, -0.3670085434701691}, {
            0.215521919360604, -0.354211847724293}, {
            0.25601045796278593`, -0.33535579499658835`}, {
            0.29518532992651836`, -0.31424791516419515`}, {
            0.3330465352518015, -0.2908882082271133}, {
            0.3695940739386352, -0.2652766741853428}, {
            0.39051629448981173`, -0.24906017447291812`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.395258589579716, -0.24538449259328413`}, {
            0.4050872756123412, -0.23776642529341446`}, {
            0.4397854698982413, -0.208710573805859}, {
            0.47368865679633554`, -0.17810911972267643`}, {
            0.5067968363066239, -0.14596206304386672`}, {
            0.5463560039499044, -0.10528911951029757`}, {
            0.5693746646104157, -0.08060627126638181}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5734668004720125, -0.07621828492977656}, {
            0.585541137386755, -0.0632710057588485}, {
            0.6243522366171754, -0.01990772178951964}, {0.6627893016411657, 
            0.024800732397688877`}, {0.6983277765087379, 
            0.06751726835208366}, {0.7296248861222444, 
            0.10596351277662927`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7334127805764273, 0.11061666822255735`}, {
            0.7339138052131882, 0.11123214089353246`}, {0.7545735001268581, 
            0.13695634199601975`}, {0.7752915865639727, 
            0.16306460013367385`}, {0.7960287506096592, 
            0.18962043603372208`}, {0.8167456783490445, 
            0.21668737042339176`}, {0.8375206381992367, 
            0.24423676120898602`}, {0.8583378327117591, 
            0.27231369655354737`}, {0.8790168491733621, 0.3010922925694121}, {
            0.8791356220729423, 0.3012652818720411}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8825317412432572, 0.3062116314938349}, {
            0.8993772748707959, 0.3307466653689163}, {0.918473185254973, 
            0.3602225579545202}, {0.9370515607021387, 0.39070380287682555`}, {
            0.9551124012122922, 0.4221904001358321}, {0.9726557067854341, 
            0.45468234973154004`}, {0.9894158027370409, 
            0.48845423303616853`}, {1.0009950569506572`, 
            0.5144899937775247}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0034332600532883`, 0.5199722529496471}, {
            1.0051270143825888`, 0.5237806314219364}, {1.0197893417220785`, 
            0.5606615448888441}, {1.0334027847555092`, 0.5990969734368914}, {
            1.0457032612191357`, 0.6394310074483879}, {1.0564266888492122`, 
            0.6820077373056432}, {1.0655730676457387`, 0.7268271630086572}, {
            1.0693128404011576`, 0.7500791074794603}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.070265617547436, 0.756002975785688}, {
            1.073142397608715, 0.7738892845574303}, {1.0788359394737306`, 
            0.8217779417673465}, {1.08276560678835, 0.8719950167268554}, {
            1.0848761270144067`, 0.9242833171474295}, {1.0851122276137344`, 
            0.978385650740541}, {1.0846074544842366`, 0.9952316651847257}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.0844277514400567`, 1.00122897348228}, {
            1.0834601543723885`, 1.0335210136594248`}, {1.0799061530764258`, 
            1.088908402057317}, {1.0762451381893896`, 1.1340220429868404`}, {
            1.0713293371387762`, 1.1781031044024104`}, {1.0626687995710482`, 
            1.2238226554923475`}, {1.0588701607607052`, 
            1.2394097810629099`}}]}, {
           Arrowheads[{{0.012395795032864981`, 1.}}], 
           
           ArrowBox[{{1.0574495176637093`, 1.245239169812252}, {
            1.0526647571413752`, 1.2648726929794518`}, {1.0420499436699966`, 
            1.3030083735616662`}, {1.0302135881152072`, 
            1.3353153403341016`}, {1.0033965878880107`, 
            1.382817383792084}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2811740296422659, 
            0.9772574802070795}, {-0.31862989133662556`, 
            0.9935540335773919}, {-0.3575338656478725, 
            1.0074094145311465`}, {-0.3981444341081596, 
            1.018340671748536}, {-0.43404510509642874`, 
            1.0249960795416113`}, {-0.471546053966137, 
            1.0291143483084215`}, {-0.5109116795832838, 
            1.0305011465499414`}, {-0.513080237654703, 
            1.0304207165437924`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.5190761150892068, 
            1.030198334461762}, {-0.552406380813868, 
            1.0289621427671451`}, {-0.6040320202589962, 
            1.0230808895974177`}, {-0.6595993097695196, 
            1.0124419087848928`}, {-0.6889929658849008, 
            1.0051631669616663`}, {-0.7196358196878228, 
            0.9963447861259104}, {-0.7515278711782858, 
            0.9859867662776252}, {-0.7537968438421276, 0.985172208486701}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7594439685073932, 
            0.9831448991824876}, {-0.7846691203562897, 
            0.9740891074168105}, {-0.8277379715194703, 
            0.9567252044230461}, {-0.8727128865331885, 
            0.9362335446254159}, {-0.9191706758122237, 
            0.9122386876270453}, {-0.9666881497713555, 
            0.8843651930310605}, {-0.974941415959327, 0.8787894415036108}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9799131676407866, 
            0.8754306195050667}, {-1.0142823204794302`, 
            0.8522114657697234}, {-1.0609702000052947`, 
            0.8153759107752961}, {-1.086447650236644, 
            0.7937878869952987}, {-1.1111302124084428`, 
            0.7706553659244938}, {-1.1396207373253213`, 
            0.7356318288617151}, {-1.154643007477303, 0.7135791135856189}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1580209294345705`, 
            0.7086203190495838}, {-1.165368489196889, 
            0.6978340902191073}, {-1.1895039528430755`, 
            0.658727859213432}, {-1.2104148400384998`, 
            0.6170046434816223}, {-1.228020425527128, 
            0.5728821110799359}, {-1.2422399840529263`, 
            0.5265779300646307}, {-1.2507871919595939`, 
            0.4891609768723749}}]}, {
           Arrowheads[{{0.004603781193380102, 1.}}], 
           
           ArrowBox[{{-1.252123362485805, 
            0.4833116479942142}, {-1.2532358631471756`, 
            0.4784414745261763}, {-1.2611704103411567`, 
            0.4288221185550423}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.5, 0.621117793476326}, {1.4678333849204643`, 
            0.6498811266788176}, {1.4411859883457863`, 0.6795547608522283}, {
            1.4147972659599397`, 0.7222453111076079}, {1.3922129980963749`, 
            0.7658126608718192}, {1.3709406979517467`, 0.8098596996018284}, {
            1.3675757705095397`, 0.8179806972807931}}]}, {
           Arrowheads[{{0.01514145268079489, 1.}}], 
           
           ArrowBox[{{1.365279029038642, 0.8235237089726317}, {
            1.3522923332449923`, 0.854866116263434}, {1.3355619458861892`, 
            0.9007905087792275}, {1.320043577785416, 0.947591475071801}, {
            1.3054065423482544`, 0.9949693864312124}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.13042977732910924`, -1.5}, {
            0.14377402800038416`, -1.4865141417330499`}, {
            0.17528021045220513`, -1.4600969153323264`}, {
            0.2144305650782714, -1.4321690299736838`}, {
            0.26546376783859127`, -1.4056960989892577`}, {
            0.3157833293614746, -1.3829911903682794`}, {
            0.33339012548583014`, -1.3755215847613285`}}]}, {
           Arrowheads[{{0.008309827719670681, 1.}}], 
           
           ArrowBox[{{0.3389136098905818, -1.3731782708620686`}, {
            0.37394677512465085`, -1.3583156050134162`}, {
            0.43178049583888917`, -1.3369259892420697`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, 0.35748105860004387`}, {-1.4937127230661966`, 
            0.352365323348215}, {-1.467883460047756, 
            0.32684900917949267`}, {-1.4364936902389869`, 
            0.2900218735305622}, {-1.4108494575662398`, 
            0.24682145158680113`}, {-1.3890904487052576`, 
            0.20450926989741833`}, {-1.368688482997969, 
            0.16268366444740479`}, {-1.3675587010767185`, 
            0.16007428647946456`}}]}, {
           Arrowheads[{{0.006544454941708323, 1.}}], 
           
           ArrowBox[{{-1.365174741643785, 
            0.15456822278367185`}, {-1.3510006035980688`, 
            0.12183121147612991`}, {-1.335331606147514, 
            0.08193841505516312}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.5, 0.6349471744178549}, {-1.4988591359966321`, 
            0.6340128694190136}, {-1.4763583365462936`, 
            0.6111818317896011}, {-1.4466657337545334`, 
            0.5744238465037212}, {-1.4373521701012268`, 
            0.5580118077708184}, {-1.4287680870021342`, 
            0.5415361637975347}, {-1.4128398459783595`, 
            0.5084747071295551}, {-1.3990674137212926`, 
            0.4752092924092397}, {-1.386902300160522, 
            0.44178196726827074`}, {-1.3827491837261672`, 
            0.4289418558258632}}]}, {
           Arrowheads[{{0.002613230702604953, 1.}}], 
           
           ArrowBox[{{-1.3785805514384961`, 
            0.400575498840293}, {-1.3735741244669102`, 
            0.400575498840293}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{-0.2931650392349731, 
            0.7097451692210799}, {-0.31771098487825883`, 
            0.6861195953922119}, {-0.34652919300075447`, 
            0.6305662914258755}, {-0.3549783971167785, 
            0.5938549044047072}, {-0.35841388307968886`, 
            0.5513674559261862}, {-0.3561269910515861, 
            0.5041631886696942}, {-0.353459207326018, 
            0.48859889758447955`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.35244556486719725`, 
            0.4826851399832859}, {-0.3474090611945704, 
            0.45330134531461386`}, {-0.331984839768914, 
            0.4006817009952761}, {-0.30957907303488935`, 
            0.34820403084601254`}, {-0.28068726644893216`, 
            0.2978343384058333}, {-0.2564805812808417, 
            0.2657073172848748}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.252869953885725, 
            0.26091530624423304`}, {-0.24580492546747848`, 
            0.2515386272137484}, {-0.20615094223047065`, 
            0.21051331004187598`}, {-0.16294420887785105`, 
            0.17595479966233396`}, {-0.10822544981418383`, 
            0.14322694439162678`}, {-0.05992813630319767, 
            0.12364563215715497`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.05436775361898168, 
            0.12139127096048061`}, {-0.05278232030857229, 
            0.12074848438662704`}, {0.00167241760271895, 
            0.10783202004269482`}, {0.05342600188342554, 
            0.10379015175519002`}, {0.11500449043045687`, 
            0.10971585780783757`}, {0.1692774149552153, 
            0.12646945035887555`}, {0.17959275360937246`, 
            0.13209481739687823`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.18486038062264923`, 0.13496746524320344`}, {
            0.21591926950322193`, 0.1519051204771738}, {0.25460454811999783`, 
            0.18387705923160225`}, {0.2905281968318265, 
            0.22913795991166178`}, {0.3142748766559399, 
            0.27960582395748323`}, {0.3222849448719208, 
            0.3196888934004745}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3234607178039454, 0.3255725621549438}, {
            0.3251429281817727, 0.3339904873927895}, {0.32243069199875957`, 
            0.39100178624130333`}, {0.30888179774518665`, 
            0.4416586454910329}, {0.2844950069022215, 0.4935284199117793}, {
            0.2494557158681803, 0.5464831388249817}, {0.24877889568716946`, 
            0.5473351649005506}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.24504688855490717`, 0.5520332626820728}, {
            0.2281074926917576, 0.5733576962387542}, {0.20439340370113973`, 
            0.6005122684488378}, {0.16494694592347, 0.6416603700411773}, {
            0.12119377990778256`, 0.6835817158582119}, {0.09812101214179013, 
            0.7046769479693549}, {0.07734877294380382, 
            0.7232357171831764}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.07286107932406785, 0.7272181394782532}, {
            0.04957819377662929, 0.7475660134802744}, {0.02410814317746087, 
            0.7693598468800509}, {-0.0020990315136045247`, 
            0.7912988547086695}, {-0.02898136011073849, 
            0.8132953442987605}, {-0.05653884261394105, 
            0.8353493156503244}, {-0.0847714790232122, 
            0.8574607687633611}, {-0.09597844190764535, 
            0.866145489776671}, {-0.10729637935669188`, 
            0.8748056689469853}, {-0.11307938619443092`, 
            0.8788526890121557}}]}, {
           Arrowheads[{{0.008493939754460002, 1.}}], 
           
           ArrowBox[{{-0.11799521086278, 
            0.8822928442165107}, {-0.15427938623325566`, 
            0.9076849611364152}, {-0.2031308369606485, 
            0.9382788487329107}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.06717993992097789, -1.5}, {-0.05414840211098085, \
-1.489279126581949}, {-0.01688537803302395, -1.4627255060199318`}, {
            0.019532900150011002`, -1.4410027292828083`}, {
            0.06315266143183546, -1.4211677762723753`}, {
            0.10589393245486012`, -1.4038376999027893`}, {
            0.14412730065536317`, -1.3892396363673207`}}]}, {
           Arrowheads[{{0.011678875234102415`, 1.}}], 
           
           ArrowBox[{{0.14973261740154845`, -1.3870994438117465`}, {
            0.16623430577202541`, -1.3807988559584494`}, {
            0.22515412092417908`, -1.361190092293083}, {
            0.2830380256283961, -1.343988375056906}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.5, -0.6381256004021497}, {-1.4884312769549604`, \
-0.6445794885408005}, {-1.4498552921895382`, -0.6687335344072601}, \
{-1.4171968434091793`, -0.6927310267411314}, {-1.381572483246184, \
-0.7272707050840774}, {-1.349893243304104, -0.762090760698457}, \
{-1.3210421924872375`, -0.7953349176713915}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.3172490566794823`, -0.799981587392265}, \
{-1.2917752161570122`, -0.8324242016950436}, {-1.2659711520660324`, \
-0.8681229437648178}, {-1.2414365342031168`, -0.9041923992097269}, \
{-1.2178021883215362`, -0.9405446495249875}, {-1.1946989401745618`, \
-0.9770917762058166}, {-1.1816696103459452`, -0.9978203978268279}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.178476596792002, -1.0029002270015477`}, \
{-1.1726232753359718`, -1.0122123932667466`}, {-1.1504478720230515`, \
-1.0468906185986993`}, {-1.1281727302358011`, -1.0811264522016744`}, \
{-1.1057978499742203`, -1.1149198940756722`}, {-1.0830754341362612`, \
-1.1476795570765612`}, {-1.0597576856198756`, -1.1788140540602101`}, \
{-1.0423192978321936`, -1.2003334539466175`}}]}, {
           Arrowheads[{{0.012236189020808455`, 1.}}], 
           
           ArrowBox[{{-1.0385417637088892`, -1.2049950240627125`}, \
{-1.0358446044250633`, -1.208323385026619}, {-1.0113361905518243`, \
-1.2362075499757879`}, {-0.9860820969002768, -1.262052816332909}, \
{-0.9599319763705387, -1.2854454515231748`}, {-0.9328858289626101, \
-1.3063854555465857`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.5, 0.46593387348385007`}, {1.4740452263933643`, 
            0.488535573632802}, {1.4486225895280551`, 0.516149916185219}, {
            1.4237892820502702`, 0.5553946662182302}, {1.402850526706217, 
            0.5950708578840257}, {1.383277715926995, 0.63509765908482}, {
            1.370977869426221, 0.6648435606474142}}]}, {
           Arrowheads[{{0.0004903292621222988, 1.}}], 
           
           ArrowBox[{{1.3681566289172957`, 0.6745474826444857}, {
            1.3669653250167564`, 0.6745474826444857}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1884764321460901`, 1.5}, {-1.2094249128322434`, 
            1.4607126843974483`}, {-1.2309699289796783`, 
            1.423376621977486}, {-1.2510172763348302`, 
            1.3913672120139826`}, {-1.2741375205818521`, 
            1.3570362093131378`}, {-1.2946781312782027`, 
            1.3262946583868878`}, {-1.3139066309635414`, 
            1.2967985098646293`}, {-1.3144451260717305`, 
            1.2959226966687785`}}]}, {
           Arrowheads[{{0.0020561224624824513`, 1.}}], 
           
           ArrowBox[{{-1.3204241335170994`, 
            1.2744063109972987`}, {-1.327674509329362, 
            1.2744063109972987`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.8717861399184023, 1.5}, {-0.8759699999178078, 
            1.4922703603850047`}, {-0.8970354162278419, 
            1.4574575289734963`}, {-0.9179417152726923, 
            1.4279634996961017`}, {-0.9496145162282856, 
            1.3942199094744507`}, {-0.981144040991115, 
            1.3646316594393813`}, {-1.012504305430817, 
            1.336466939629974}, {-1.0300902687985867`, 1.322114573335111}}]}, {
           Arrowheads[{{0.01301067978342059, 1.}}], 
           
           ArrowBox[{{-1.0347386920418058`, 
            1.3183208731160767`}, {-1.0435260492242635`, 
            1.31114928027189}, {-1.074046974727306, 
            1.2880023014884114`}, {-1.1039047842957959`, 
            1.2663496234028189`}, {-1.132876356921293, 
            1.245853954949709}, {-1.1607385715953573`, 
            1.2261780050636786`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.0131257994351593, 1.}}], 
           
           ArrowBox[{{1.5, 1.4414804993522745`}, {1.489448283390373, 
            1.4436930749546726`}, {1.457098249512828, 1.450439013703689}, {
            1.4293289256356871`, 1.4558877440097608`}, {1.4054736472559817`, 
            1.4598064630973533`}, {1.3839986561676372`, 
            1.4629338641338976`}, {1.3447950935378727`, 
            1.4678220120335808`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.012976768783036224`, 1.}}], 
           
           ArrowBox[{{0.09906610939362091, 1.5}, {0.08773492875454121, 
            1.483334108419489}, {0.06812557147849253, 1.4596337106929222`}, {
            0.05737213868401216, 1.4494280961425487`}, {0.04677046039907908, 
            1.4400694725667988`}, {0.025856622369061423`, 
            1.4228062631659761`}, {0.005492423210364998, 
            1.4081001112488967`}, {-0.014374601119207644`, 
            1.3953565785537143`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.014656890565628258`, 1.}}], 
           
           ArrowBox[{{1.5, 0.32811911627001067`}, {1.4903064698500328`, 
            0.33617289966103236`}, {1.4657910013768511`, 0.361398473865483}, {
            1.4554790279707177`, 0.3752215712068444}, {1.4459917901636492`, 
            0.388986027237799}, {1.4284283459061218`, 0.41643098079699103`}, {
            1.4133385820302449`, 0.44376056674502384`}, {1.4001308839796844`, 
            0.4710734754542437}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8798102077044276, -0.4385709210142021}, \
{-0.8586999258290859, -0.47130346835323544`}, {-0.8351866545713531, \
-0.5039077109227321}, {-0.8091062366244852, -0.536425887009502}, \
{-0.7802945146817382, -0.568900234900355}, {-0.7486004644167111, \
-0.601345258149182}, {-0.7263836210041755, -0.6220924682135597}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7219984207823419, -0.6261875895810445}, \
{-0.713873061503004, -0.6337754603098738}, {-0.6760365107858799, \
-0.666181396312081}, {-0.6350000873940103, -0.698533298171401}, \
{-0.6020142090450328, -0.7227886079503226}, {-0.5673313656532812, \
-0.7469005873123715}, {-0.5309515572187558, -0.7708692362575477}, \
{-0.5309011045147016, -0.7709008054172986}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5258147564743332, -0.774083424403643}, \
{-0.49287478374145616`, -0.7946945547858513}, {-0.4533687164417203, \
-0.81825270990815}, {-0.41270102653988594`, -0.8414198686353115}, \
{-0.370871714035953, -0.8641960309673359}, {-0.3278807789299215, \
-0.8865811969042232}, {-0.31691455280083874`, -0.8920284310178315}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3115409756459988, -0.894697638495901}, \
{-0.27795827587236566`, -0.911379113570435}, {-0.2275614305696748, \
-0.9351666291136163}, {-0.17669024302184863`, -0.9579437435337671}, \
{-0.12534471322888757`, -0.9797104568308874}, {-0.0925893988329616, \
-0.9927825494511651}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.08701677853249945, -0.9950064880714685}, \
{-0.07748566760561437, -0.9988101934276252}, {-0.029804925333105435`, \
-1.0165825390009335`}, {0.017697513588638945`, -1.033027493550812}, {
            0.06502164915961893, -1.0481450570772608`}, {
            0.11218537222282471`, -1.0618059475038315`}, {
            0.14105057927720668`, -1.069218465597813}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.14686202040402388`, -1.0707108301744288`}, {
            0.1592065736212464, -1.0738808827540756`}, {
            0.20608525335488403`, -1.0843698628279932`}, {
            0.25282141142373754`, -1.0932728877255842`}, {
            0.29968704382273526`, -1.1005715159308331`}, {
            0.3469541465468053, -1.1062473059277245`}, {
            0.38342587643464343`, -1.1093482622480961`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.38940430629509465`, -1.1098565696390172`}, {
            0.39462271959594775`, -1.1103002577162584`}, {
            0.4426927629701626, -1.1127303712964345`}, {
            0.47689851975586073`, -1.1134645003212473`}, {
            0.5118449727032544, -1.1133976391745513`}, {
            0.5475321218123435, -1.112529787856346}, {
            0.583959967083128, -1.1108609463666317`}, {
            0.6211285085156082, -1.1083911147054084`}, {
            0.6291556017043473, -1.107698534391972}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.6351333927351536, -1.1071827685613747`}, {
            0.6590377461097838, -1.105120292872676}, {
            0.6976876798656549, -1.1010484808684344`}, {
            0.7370783097832216, -1.096175678692684}, {
            0.7820628137049752, -1.0902096116268736`}, {
            0.8283835039090935, -1.0831661150797587`}, {
            0.8701324199250404, -1.074942606798249}, {
            0.8727431421798827, -1.0743857104775079`}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.8786111256874624, -1.0731340038206698`}, {
            0.9127603890772857, -1.0658495831579418`}, {
            0.9557229053939541, -1.0557919811356153`}, {
            0.9992014708656708, -1.0448014884056773`}, {
            1.042175914684498, -1.03375984120846}, {
            1.084505004220669, -1.0217202883142928`}, {
            1.110974502446406, -1.0134414000393612`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.1167009405225365`, -1.0116503369583276`}, {
            1.126188739474184, -1.0086828297231762`}, {
            1.1672271204450433`, -0.99464746543511}, {
            1.2066186068044134`, -0.9795994760991865}, {
            1.243361658223461, -0.9635241423644986}, {
            1.2774562747021867`, -0.9464214642310461}, {
            1.3089024562405898`, -0.9282914416988293}, {
            1.333737312366278, -0.9115132374493214}}]}, {
           Arrowheads[{{0.0050073369268384274`, 1.}}], 
           
           ArrowBox[{{1.3386152814805616`, -0.9080280591187109}, {
            1.3620045391892368`, -0.8890032909121193}, {
            1.3831991967726824`, -0.8678586445261305}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.30406779469572626`, -0.7181862975851201}, {
            0.35695493194902445`, -0.7108909005578681}, {
            0.4096141258476511, -0.7006425990630744}, {
            0.4626723591098955, -0.6870219218574225}, {
            0.5167566144540465, -0.6696093976975956}, {
            0.5366994570559871, -0.6619361386368506}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.5422992545242491, -0.659781546259057}, {
            0.5718668918801041, -0.6484050265835941}, {
            0.6280031913880681, -0.6234088085154176}, {
            0.6808073981151241, -0.5968842179566735}, {
            0.7352291852585281, -0.566676205093103}, {
            0.7571902569977698, -0.5536494198404668}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7623506848491636, -0.5505883768171561}, {
            0.7630526982408473, -0.5501719591756802}, {
            0.7912926598362267, -0.5327089454393953}, {
            0.8199490700446662, -0.5142871638842482}, {
            0.849021928866166, -0.4949066145102391}, {
            0.8784007672074672, -0.4745884094109106}, {
            0.9079751159753103, -0.4533536606798053}, {
            0.937744975169696, -0.4312023683169235}, {
            0.9597243353783352, -0.4142822941454935}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.9644787331759872, -0.4106222802682408}, {
            0.9677103447906238, -0.40813453232226493`}, {
            1.0016216257999693`, -0.38159702308396853`}, {
            1.0353892382010523`, -0.35398895604274316`}, {
            1.0623917872679844`, -0.3291407609735937}, {
            1.0888030037699874`, -0.3036775424102485}, {
            1.1140849759877511`, -0.277791829348668}, {
            1.1384170078277127`, -0.2514194454568653}, {
            1.1409816265033683`, -0.24862154178876755`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.1450358657331463`, -0.24419851745379836`}, {
            1.162318998057308, -0.22534326236850646`}, {
            1.1848018347712856`, -0.19896110922602664`}, {
            1.2058655179696456`, -0.17227298602942595`}, {
            1.225510047652387, -0.14527889277870418`}, {
            1.259958715372517, -0.0908434959053907}, {
            1.2815595389197443`, -0.04802878100235882}}]}, {
           Arrowheads[{{0.013688996674990501`, 1.}}], 
           
           ArrowBox[{{1.2842621677315493`, -0.04267193514816426}, {
            1.287564906833176, -0.03612561839657922}, {1.3087241210299225`, 
            0.01856221645663799}, {1.3238318569583154`, 
            0.07290748536316856}, {1.3319820529733009`, 
            0.1139980611955959}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.37397867707840293`, -0.8237593677219612}, {
            0.41939733219235836`, -0.8208796480747531}, {
            0.4653715920032176, -0.8160839947212379}, {
            0.5119014565109807, -0.8093724076614158}, {
            0.5594300885463632, -0.8004482025049265}, {
            0.6084006509400802, -0.7890146948614097}, {
            0.6109145094524069, -0.7883194256926183}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6166974077346755, -0.7867200234739957}, {
            0.6588131436921316, -0.7750718847308653}, {
            0.7106675668025179, -0.7586197721132937}, {
            0.7627739071104347, -0.7399141867490687}, {
            0.8166524338792788, -0.7182981675758062}, {
            0.8426752953022364, -0.7067104033585702}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.8481564397009413, -0.7042696952480937}, {
            0.8721224851644984, -0.693597814107219}, {
            0.9290033990215417, -0.6656392258570195}, {
            0.9577975157857945, -0.6504135949496213}, {
            0.9865935209355976, -0.6343244078684319}, {
            1.0153914144709513`, -0.6173716646134515}, {
            1.044191196391855, -0.5995553651846801}, {
            1.0590112569764007`, -0.590165406984799}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.064079565384923, -0.586954137784607}, {
            1.0844852564936764`, -0.5740251362155657}, {
            1.1239940342822967`, -0.5468159671993233}, {
            1.1669893602515107`, -0.5099914595078053}, {
            1.2063943078194428`, -0.47116731261496636`}, {
            1.2434915179015529`, -0.431530430856072}, {
            1.2445153271439826`, -0.4302298606532425}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.2482265865425395`, -0.42551535604760005`}, {
            1.2759732530120185`, -0.39026807936506686`}, {
            1.3036568299157854`, -0.3477015697435778}, {
            1.326359565377798, -0.3041522135932318}, {
            1.3444099406606558`, -0.25994120084906913`}, {
            1.358136437026958, -0.21538972144613008`}, {
            1.3583354531278744`, -0.21453112004568797`}}]}, {
           Arrowheads[{{0.002535341042339143, 1.}}], 
           
           ArrowBox[{{1.361373942443571, -0.18631147404968912`}, {
            1.3648765138720964`, -0.18631147404968912`}}]}}}}}}, {{}, {{{}, \
{}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 180], 0.005555555555555556]], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwl23c41f/7B3BFUVkNkmQ0KTIaErpVhMxQacheFYoWQpHZIMnHKLLKqJTK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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 180], 0.005555555555555556]], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwlmnk4Vd/bhytjI4pCSRqkZCgZi6coiRKSCklRImNJs1DJUIYmFUmkyKwS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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 180], 0.005555555555555556]], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJztx/8r3HEAx/HPqIma5iff1ewMrfkBE9G9pOgoX/KD1nw5JzSrbSJb0ibM
yuYXceHIDyI2zuFzrnU2H19+WJu0az9ovU1bk83N7TNnrbFbYvkrVq/nL88e
FyruFFZ5SZK04y1J/37aAU6/h86j0KGcQDd6y58WmLRuTCUEP2hscqG5+Mdr
4XDDkrpgl9VthNy7FesbvY+lCX2JOf+TsnjDVbSusyHi77ux26trimut/5mz
cAtpF5Pvx2nn0Z/1pL7d9BGSxlMX8yFL2R4I/ZM3uQlntH9PV58dSkDD8MqL
DWheWZ6LS2bMadq+r+8L3PVy9DiDbFDV7ty8QQG/zZu6zvlZ5Bo8UYZmgZaz
iZb0Viuq95avPq4VSDr3vghmGZ8HfjZeqxSYshtdHSFWKI9mYq+UC3zJyLTF
7MhoOfr60FsvoBvd/a09Y0WKKXw8okzAv7VmwvBLRtPLt0p7qYBzRO+j98i4
bpRTsk/8LUBNmzyQcT4xPuzyiaeNu2/UQxm9NY7sSJqmaZqmaZqmaZqmaZqm
aZqmaZqmaZqmaZqmaZqmaZqmaZqmaZqmaZqmaZqm6f/Yx3kpEKI=
          "]]}, {
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 180], 0.005555555555555556]], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJzt1vlfTdv/B/AmruImlQZyJSLzkFBcr5JUhlQKhSKaJxSRVDKVDCU3HYlm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          "]]}, {
         Hue[0.6142719099991583, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[1, 180], 0.005555555555555556]], 
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwlm3c4Vf8fwI2MUJoiqWhZLZVReItQSUXJSKFJJMloGVESDZKshJAV2UL1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          "]]}}}, {{}, {}}}, {{}, {{{
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                DiskBox[{0, 0}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.368417, 0.506779, 0.709798], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.272]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPg/AAAAAAAA8D8s
RkIGsH7rP1K4S0X7v/Y/4eyK6euWxz8w67IC2r71P5O9GpkHtd+/JMKS9FaW
8z88PHY8Bznzv8tNsPJYKew/0dEuBjhi87/LfPK7tDa9vybhVqzy9ue/QB3K
O6i27r9gN3xeSuPiP/tVIe9XJ/O/zHVaB8JJ9j8QSLfJgUPZv9Lnl2SstvQ/
ImiK/qm/5j+iQ1fDSq7rP3VjxHYQlvY/Ehmmpyshyj8Q1PtaOcX1Pw5CwVhF
zt6/9kyT+jOl8z+U4b1z6QXzv7R1ZFE6xOw/ua/qJBZ587+spGLPfPO2v5PN
r17zr+i/3PiAWkcP7r+ADHfG9unhP88dczCUO/O/H/xX8nRJ9j8dYK6/0A/b
v2NzzndXx/Q/Myq8Mtzn5T82dLosFwHsPwQJlwwdlfY/s4X89efGzD/Mg94K
RdD1P4s23cXc592/BTO3mFu08z8R7COur8fyvwAzEPR/WO0/YIGJI8mP8784
pJFlA6mwv+zgllemXem/mixm3Y1m7b9qTrvs0vHgP5N6qZuGTvO/3c36FuVI
9j9t4TY0uNncv2o126L/1vQ/0jDVVY8W5T9+2Fv0W1PsPwXZgOj+k/Y/Uj21
54huzz+6Vm3JE9v1P2KV0HXDAd2/1tskqT3D8z8NdZjR0Yjyv7UwJet97O0/
cDX/aUml878S5wh602Gkv0pG7IcoBeq/TTdCYbe97L/mt6Em+vTfP6etSCCi
YPO/vE0RWQVH9j/3fSFdDpbevwyLp56d5vQ/KCiqH3tF5D9wFn9/IKTsPxfd
NmJrkvY/oI0DyOYK0T/HWkegneX1PxMo46DIG9y/YjvhcgbS8z/eo+fRkz/y
v5SBdHgMde4/qXMjxYO68798wClGw32Nv4gQ4+EPo+q/7q+sdKgU7L8+3llf
JgbePwAXRfxgcfO/MUlQV/BE9j+St+F+Iijgv/wa/p9y9fQ/fas6DQ154z9W
sopPefTsPyRlQHufkPY/LK8Zlmxe0j/nB5+K6O/1P9IFG4OGNdu/fUzU7I/g
8z+HTpV/Lvbxv2vdhcKP/e4/FlC0CQ==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.880722, 0.611041, 0.142051], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.72]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPg/AAAAAAAA8D9k
nL+n0GLtP5S2qlN68/Y/kfnGRYQc1z9NtsP5DCb2P84rWij8ptO/37slrwpY
9D9kZdTwlyDsv2rmIJRxoPE/9M8JIhGT9L/YCVS131TcP1SuKpPQn/G/TiBe
1t0Z3b+FNXhkG0DYv5ixtIsqtPK/AEYzYkZr6z+WtGfxLFPyv3o3YL6Ug/Y/
hHu6PvVh0b/KGot5iL70P9WMFcHfAOc/gBGLBIJz7T8RgwjVxcD2P1ghfqSk
z9c//PPjnDQn9j/RZ2enkSHTv/tE5dVaX/Q/k4snq4PH67+Ft0WY97HxP8L2
3/O3k/S/XNxvEldE3T8gSfCbhLPxv6pPS05rY9y/EqobUByI2b/xB83Qz5fy
v3iImfbLw+o/x18dV0Vn8r9xKoXCTYb2P1cvb3/9eNK/Iv7Zp2zI9D8Cz/fZ
cYTmP6E6+nBZoe0/+XN9ep+/9j8NUCLRyYrYP46GgBCYLPY/YGlxMtKa0r/m
y+/E82b0PyDcZlpib+u/IU+Q6yfD8T/H4IsrBZT0vyp1/ZH1Md4/zDGX3vXG
8b/+O6CCn6zbv4qIOj2Zzdq/74bu0Ux68r/XIbY+OCHqP9PtYK6+efK/lbE3
gc6I9j8c4I8Pf4/Tv27qsTAq0vQ/vgs/YBUJ5j+STnsJ9s7tP75Buk1WvvY/
AhFv2zNF2T8g5c476DH2P4hkRo9HE9K/zcR4UYVu9D+ftYPB/hfrvzbcFNj0
0/E/1CB70O+T9L8aVmripB3fP16HTLEE2vG/UsIfziv12r9k1aERWBDcvzMN
FmShW/K/+1A0spuA6T+V3eKzmIvyv/ujUpcVi/Y/nTnc3Val1L8odLgRw9v0
P9iouyq8juU/zOpR0Sj87T/BU6dst7z2PzR/xAbU/tk/amm65SQ39j/nT028
K4vRv2r9tE8SdvQ/afJnPlnB6r+6tcxpYuTxP6ev1O92k/S/d7PyR6sD4D+f
Me4clezxv4V9A+S1PNq/ibGcGx9Q3b9iBQFY0Dvyv1Imayzd4eg/Mi5v3dyc
8r+40hC1IY32P16L9PVhutW/W628iA==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.560181, 0.691569, 0.194885], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[8.16]], CompressedData["
1:eJxTTMoPSmVmYGAwAmJGIGZigIEf9hD6g/2Gqa9Pvfu52X5G5gVPpdhbcP50
ND66/DQC6mnNp9R+QvoplScUnqTyCZlHa//QOj6onR5ITc8weQBxudaX
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[
                 
                 NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                   1, 1 - 3^Rational[1, 2]}}, {{0, 
                   1}, {-1, -0.7320508075688772}, {
                   1, -0.7320508075688772}}]]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.922526, 0.385626, 0.209179], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[7.6]], CompressedData["
1:eJxTTMoPSmVmYGAwAmJGIGZigIEf9hD6g/31t+9eKq96aW+QaKCW+/6b/aU/
KdGrlh+y/3nCyy7Y7pv99OUXXeukPu63StJf+SjxrX1QjJKrtdpt+zP3D1/M
Orxrv8/u1jPhHuftV/Kw64e0XrG/1W8su2fOSnuWe71Tnljdsde6e8Q1ZNsm
e48IEW+b4zfta7a2ZJ+ZscXe5SP7KuPUW/Zq98JYFa9tthfTLj4pDeSnZH49
lfZ6s/2lQtVjGtG37Cfu01vz4M9meyN9Md4bMbfsBRcsfHrjx2b7ABfGF2Gx
t+wFoPxAND5MXhBNnlx+EA55dPuEcKhH56O7D50fhMM8Yv2Hy72k8tHtQw9v
dPfj8j8h9+LyP7HhS634BgC+SpYw
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[
                 
                 NCache[{{0, -1}, {-1, -1 + 3^Rational[1, 2]}, {
                   1, -1 + 3^Rational[1, 2]}}, {{
                   0, -1}, {-1, 0.7320508075688772}, {
                   1, 0.7320508075688772}}]]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.528488, 0.470624, 0.701351], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[7.68]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPg/AAAAAAAA8D9I
rVpwb4HWP1hYBDqxqPM/WyftEuzY8b8wpx433pHrPy1OaGnX0s+/jE9JFqe0
8L+7csOtzlnzPxjtIRlIhNc/5dyybrWuyD/Cy6U1fbHzPzowSg5MxvK/6jVR
woiM5T9+0QivNHuPP+YDP0c5ivG/+rz6d5BG8z9qaFb5BO/iPwkiHVMshak/
PKn4qgex8z/CbEJltArzv3mb5Mhg49w/Ey9SXsFa0T+aE+utsr7xv9eTcrHT
5PI/RtKGoTGD6z8zRHYfOG+0vyNdtFxxpfM/E+D0+Jrv8r9eSPguQMPNPwL5
UUYxYeE/6VuJJ+5u8b9eWFYQGg7yP8evrQ+zjfE/pGuO5bV6yb+SGThgiYnz
P1mAdhLzmfK/iQHZVOq2oT9UBCLWc27rP/RlkY18Y/C/oZ9DeI/g8D94NeWk
FdTyP32xNYFRGdS/f4FveH9a8z+3bKUehQnyv1ZeSU/1PcK/BwR3Ybqk8T9U
yhn+hHbsv4S1x1pWKe8/SalYFGYp8z+Qehf5qJHbv8iX1A6OEPM/cTGHX/83
8b96jOoBqcvTv0Ic58y9evI/XjPUNmnP5b/o8wzRmDDsP4h5NLkMU/M/HgoG
Rv7T4b/fZElXIKLyP357Zxfm7++/+2BWEWRe3r8nI+YFpsHyP7cn5GqM+Nu/
0lmYg6qC6D/3wumwpnHzP3pEEDgJfOa/K2Eu4Db78T92N5/jRhLsv/qPDy8Z
sOS/ctEwMI358j+GTVKDuATJvzpWVjlo/+M/cMhuOxmL8z9/iKVr2unrvxfW
mZU38/A/4gahurv95b/ddxxgFlzqvxVofhOiK/M/Vb5oPkGKmT+ksLDJU5Pd
P1J0lyvUnvM/RAztsNKg8L+qTlqzsajuP5qIMwffmNu/pL3my58477+MuuOP
tk/zP1FMy8VCec0/TYX6Wl790j/yNE+8iqzzPyB5URKlQfK/fcYremG26T9S
lljU1z7EvzSqhGDYE/G/Nnx4uhtZ8z8h92cZZhzcP3i+sigfWsI/8QsmAVGy
8z+DJeK3Vu7yvxjCjU2fQOM/BjijWA==
          "]]}}}, {{}, {}}}}, {
    Frame -> True, DisplayFunction -> Identity, 
     PlotRange -> {{-1.5, 1.5}, {-1.5, 1.5}}, DisplayFunction -> Identity, 
     AspectRatio -> 1, Frame -> True, FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, DisplayFunction -> 
     Identity, AspectRatio -> 1, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, 
     PlotRange -> {{-1.5, 1.5}, {-1.5, 1.5}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"AdaptiveEG+\"", 
       InterpretationBox[
       "\"\\!\\(\\*FormBox[\\\"2\\\", TraditionalForm]\\)-step EG\"", 
        StringForm["`1`-step EG", 2], Editable -> False], "\"MDEG\"", 
       "\"CurvatureEG+\"", "\"EG+ Adaptive\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.272}, {20, 6.272}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.08426020408163262] -> 
                    Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.72}, {20, 6.72}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.72}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.051309523809523805`] -> 
                    Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 8.16}, {20, 8.16}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 8.16}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.03009803921568628] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 7.6}, {20, 7.6}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                    1, 1 - 3^Rational[1, 2]}}, {{0, 
                    1}, {-1, -0.7320508075688772}, {
                    1, -0.7320508075688772}}]]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 7.6}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.002105263157894735] -> 
                    Baseline)], #4, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 7.68}, {20, 7.68}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, -1}, {-1, -1 + 3^Rational[1, 2]}, {
                    1, -1 + 3^Rational[1, 2]}}, {{
                    0, -1}, {-1, 0.7320508075688772}, {
                    1, 0.7320508075688772}}]]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 7.68}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.006354166666666661] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], ",", 
                    RowBox[{"Offset", "[", "6.72`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], ",", 
                    RowBox[{"Offset", "[", "8.16`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                    1, 1 - 3^Rational[1, 2]}}, {{0, 
                    1}, {-1, -0.7320508075688772}, {
                    1, -0.7320508075688772}}]]}], ",", 
                    RowBox[{"Offset", "[", "7.6`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, -1}, {-1, -1 + 3^Rational[1, 2]}, {
                    1, -1 + 3^Rational[1, 2]}}, {{
                    0, -1}, {-1, 0.7320508075688772}, {
                    1, 0.7320508075688772}}]]}], ",", 
                    RowBox[{"Offset", "[", "7.68`", "]"}]}], "}"}]}], 
               "}"}]}]}], "]"}]& ), Editable -> True], TraditionalForm], 
    TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.904680643196373*^9, 3.904680780537944*^9, 3.9046808168819227`*^9, {
   3.904680939782234*^9, 3.9046809668294992`*^9}, {3.9046810088523493`*^9, 
   3.904681019535927*^9}, {3.904681059518063*^9, 3.904681089182433*^9}, 
   3.904681163068296*^9, 3.904681196244351*^9, 3.904681228567741*^9, {
   3.904681295917961*^9, 3.904681315647586*^9}, 3.904681460883649*^9, {
   3.904681497245674*^9, 3.9046815217818604`*^9}, 3.9046816212738323`*^9, {
   3.904681717294569*^9, 3.904681755225898*^9}, {3.904681823347838*^9, 
   3.904681903641996*^9}, {3.904681936073902*^9, 3.904682011996291*^9}, {
   3.904682145936627*^9, 3.9046821609628973`*^9}, 3.9046822562052717`*^9, 
   3.904682344759131*^9, 3.9046824403140163`*^9, 3.90468247155002*^9, 
   3.9046825501144238`*^9, {3.9046827513642807`*^9, 3.904682847009766*^9}, {
   3.904682895012501*^9, 3.904682902690345*^9}, 3.904683020411564*^9, 
   3.9046831476611853`*^9, {3.9046831840485773`*^9, 3.904683250506708*^9}, {
   3.904683284200385*^9, 3.904683351968749*^9}, {3.9046833986014214`*^9, 
   3.9046834127635937`*^9}, {3.9046834986151857`*^9, 3.904683561388508*^9}, {
   3.904683645359761*^9, 3.904683663822613*^9}, {3.904683725464981*^9, 
   3.904683745488326*^9}, 3.9046837849943857`*^9, {3.9046838650059137`*^9, 
   3.904683902610824*^9}, 3.904684020088187*^9, {3.904684056094061*^9, 
   3.904684091144416*^9}, {3.904684135562866*^9, 3.904684140839593*^9}, 
   3.904684291734256*^9, {3.904684405478045*^9, 3.904684421391037*^9}, {
   3.904684462615758*^9, 3.904684529111066*^9}, 3.9046846787736*^9, 
   3.904685301634338*^9, 3.904686800171452*^9, {3.904686928356135*^9, 
   3.9046869531162148`*^9}, 3.904687046697579*^9, 3.904734699584383*^9, {
   3.904734807395198*^9, 3.904734827118947*^9}, 3.904735523969082*^9, 
   3.904735604143405*^9, 3.90473570903111*^9, 3.904735753895398*^9, 
   3.904735962968754*^9, 3.9047360166159153`*^9, {3.9047360537048903`*^9, 
   3.904736080722252*^9}, 3.9047361433217373`*^9, 3.904736211320139*^9, {
   3.904736301949736*^9, 3.904736335821913*^9}, {3.9047364065377827`*^9, 
   3.9047364476816072`*^9}, {3.904736520769437*^9, 3.904736535314979*^9}, {
   3.904736920940432*^9, 3.9047369556262493`*^9}, {3.904737132276061*^9, 
   3.904737173358301*^9}, {3.904737256850163*^9, 3.904737282861266*^9}, 
   3.904737328109385*^9, 3.904739494825601*^9, {3.904739565153618*^9, 
   3.904739595114736*^9}, {3.904739636728263*^9, 3.904739660812203*^9}, {
   3.9047396969065533`*^9, 3.904739776029087*^9}, 3.904740145471875*^9, 
   3.904740654209096*^9, 3.904740699766966*^9, 3.9047407831828003`*^9, 
   3.9047408135413933`*^9, 3.904741697115147*^9, 3.904741774122334*^9, {
   3.904742049913468*^9, 3.9047420788271713`*^9}, 3.904742138396843*^9, 
   3.904742224087797*^9, 3.904742278650795*^9, 3.904742575205922*^9, 
   3.90474289256909*^9, 3.904743757728841*^9, 3.9047439470376797`*^9, 
   3.904744056273604*^9, 3.904746046568783*^9, 3.904746252258511*^9, 
   3.904746292534446*^9, 3.904746396804057*^9, 3.9047464329903183`*^9, 
   3.904746467338516*^9, 3.9047465016188*^9, 3.904746551648592*^9, 
   3.904746743991631*^9, {3.904746814781958*^9, 3.90474683727043*^9}, {
   3.904747507973131*^9, 3.904747531833601*^9}, 3.904747672908682*^9, 
   3.904747866409636*^9, {3.904751462773683*^9, 3.904751489846736*^9}, {
   3.9047518182187653`*^9, 3.90475184181327*^9}, 3.904753318950343*^9, 
   3.9047542461447477`*^9, 3.9047542763350687`*^9, 3.904755125737275*^9, 
   3.904755192202413*^9, 3.904755252965486*^9, 3.904757174462379*^9, 
   3.904757318141162*^9, {3.904757382861109*^9, 3.904757411424984*^9}, {
   3.9047586949327087`*^9, 3.904758704725155*^9}, 3.904758774366029*^9, 
   3.9047588994096622`*^9, 3.904760139053491*^9, 3.904760195416094*^9, 
   3.9047602819736147`*^9, 3.9047605327174873`*^9, 3.904760593869646*^9, 
   3.904763765244562*^9, 3.904764324471496*^9, {3.904886557886676*^9, 
   3.904886583165193*^9}, {3.904886625345655*^9, 3.9048866490419188`*^9}, 
   3.904886706524103*^9, 3.9048867762411747`*^9, 3.904977590586953*^9, 
   3.904978182395061*^9},
 CellLabel->
  "Out[220]=",ExpressionUUID->"1663d25f-d090-49fe-9d6d-8c8695d67782"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Fzbars", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Last", ",", 
     RowBox[{"{", 
      RowBox[{
      "AEGPlusIterates", ",", "EGnIterates", ",", "MDEGIterates", ",", 
       "CurvatureEGPlusIterates", ",", "EGPlusAdaptiveIterates"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEGSteps", "=", 
   RowBox[{"MDEGIterates", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CurvatureEGPlusSteps", "=", 
   RowBox[{"Indexed", "[", 
    RowBox[{"CurvatureEGPlusIterates", ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"norms", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Norm", "[", "p", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "orbit"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"orbit", ",", "Fzbars"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xrange", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"nstep", "+", "1"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"norms", "[", 
     RowBox[{"[", "3", "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"CurvatureEGPlusSteps", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "+", "2"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"norms", ",", "\[IndentingNewLine]", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<operator evaluations\>\"", ",", 
      RowBox[{"MaTeX", "[", "\"\<\\\\|F\\\\bar{z}^k\\\\|\>\"", "]"}]}], 
     "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"legends", ",", 
        RowBox[{"LegendLayout", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<Row\>\"", ",", "1"}], "}"}]}]}], "]"}], ",", "Below"}],
      "]"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.904740231058855*^9, 3.904740299384026*^9}, {
   3.904740355165204*^9, 3.9047403561533623`*^9}, {3.904740473003118*^9, 
   3.904740534628036*^9}, {3.904742499448928*^9, 3.90474254779138*^9}, {
   3.904742594648654*^9, 3.904742689421267*^9}, {3.904742910367407*^9, 
   3.904742912286078*^9}, 3.904743412212469*^9, {3.904743556709174*^9, 
   3.904743576319222*^9}, {3.90474368786519*^9, 3.9047437081510468`*^9}, {
   3.904743806178113*^9, 3.904743835996441*^9}, {3.904743970726638*^9, 
   3.904743999787327*^9}, {3.9047445492692413`*^9, 3.904744667096581*^9}, {
   3.904744760934309*^9, 3.904744773053116*^9}, {3.9047448398014183`*^9, 
   3.904744842886072*^9}, {3.904744882453095*^9, 3.9047450030862017`*^9}, {
   3.904745083898131*^9, 3.904745108469357*^9}, {3.904745227491988*^9, 
   3.904745284049883*^9}, {3.904745605600359*^9, 3.9047456066306047`*^9}, {
   3.904746066550438*^9, 3.904746068680234*^9}, {3.9047463119321823`*^9, 
   3.9047463311927967`*^9}, {3.9047473888833857`*^9, 3.904747405332632*^9}, {
   3.9047575007049723`*^9, 3.904757534153143*^9}, {3.904760254114449*^9, 
   3.9047602968033323`*^9}, {3.9047603367417583`*^9, 3.904760337473563*^9}, 
   3.90476375172865*^9},
 CellLabel->
  "In[221]:=",ExpressionUUID->"6b1d677a-4be2-4b1f-af06-9176ad8927ad"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd23l8TNf/P/BYUgnaTpEmthpSGkpMEFLryxJizYiQBGEQSUgwkW0i22Sf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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd2nd4U/X3B/CLrDANQygyDIJQUCCMQkGqpwxpZRigQNmXslKkkA5KoOt2
Jh1pI8uyL9MgCBGRBgG5rYyqjDCtDA2rVEEJFKH9gfLj+/TcP/LmH54X9/k8
h3PPZ9zcezpGLB439zVBECpqC8L//q754/3Q+sLvZtvB9z7kfyBfa8BaGvTA
f93x1rfZLcF+4Hb0Zje/y+FHy9g68NvgzrRutv8TTeFRdhewP7g7fXPsr8qn
4ceP1fg9cE+wnkI6tWvXqX0Zuze4D7gvjauKu+D+zsPuBw4A96cjU8d/8+EX
t9kDwIHggTQsWNlwYtFd9iDw++DBNGDQuZILS8vZQeAPwB/S9dpvbN3yUjX5
WgILwTRsVWWmt/s9vg4WhsD1IdT8g70Bq7Tq9aG+lsDCMLJH/3VLPKbGBwvD
4fpwKrs29I/oYPX6R76WwMIIaht3Oq7+Jr5fElgIgesh1KP5i66br97h66G+
lsDCx1T3wuzoTc+5fhJYGAnXR9Lu4LaNj9ZRr4/ytQQWRtOI0IQZodU3+TpY
GAPXx1Bjx7z5E66r8+8TX0tgwUBjza1O7Jr1e40JLIGVV+6ZfGx25XUeP9bX
BJbGUp7xjQYHY6/yeLAwztc0jvzMfW6uq/iFx4MVsDCeLuzK8PQPv8zjwRJY
GU+pl58G3iy9wOPDfE1gKYx6Pto/vGuwm8eDhQm+pgm0O3DHZ2sKfubxYAUs
TKSSnfdTEk6d5PFgCaxMpH7GTT/qAkt4/CRfE1iaRPO11YLl98M8HiyE+5rC
6Uyi5r5Q/Q2PBytgYTJty/r3YQfnLh4PlsDKZPptxZdFf0xex+On+JrA0hQa
N+Ltxi9ccTweLEz1NU0l6fFPHx3Zaak5DySwAham0fQ1W9rERhXWmMASWJlG
Hezz9rw7WObx031NYGk6Pfwlc/0Pj7fweLAww9c0g6pHtjxWLbIlsAIWZtLA
kgOah/038niwBFZm0q2n3w9Lzl7J40Vf68AkUocjoe88n2musQiWwLJID5+0
tU8Yn8n1AnvAwizqXvdAo5f9N9VYByawOIs6zm20IkD4kucHWAYrs6h9bLOH
gdf3c3ywEOFrXQS5mp364eQLF8cHi2ApgoIuLqibHHSM44MVsCeCnqzYOav2
9+r6ne1rHZhmU5/Dk+uNOn2C44MlsDyb7l/adqPH4VKOD/aAhTm00z/CczaJ
9yMdmMDiHKL/2t+p0Jzl+GAZrMyhbhcz1s/oxvujByzM9bVuLv1V70C7lG7n
OT5YBEtz6Vroo68m1+L9WgYrYM9cauTYJDXZq+7/83ytA9M8qizuEf1Rj4sc
HyyB5XnUvvy3yF5JbAXsAQvzaXDY4HXzNrB1YAKLrxwy2luZrcYHy2BlPm0N
btluyHA1Plgw+lpnpJK80WPfPKvmDxbBkpGW/FRUubWzev/BCthjpA4dXp8+
K5TrJ0T6WgemSOqWkvrsgyCeHyJYAsuRtLSg7z+daqvzD+wBCwvo0HdH54bp
1fkPJrC4gLIPvnH4eD1ePxJYBisLqKrr1pVRefx7wwMWPvW17lNyS6s+PF6q
cHywCJY+pVU5u1Lr5hzi+GAF7PmUBn1mt9dq8zXHX+hrHZgW0qkuF+qmHZA5
PlgCywtp9+AnH1gaRfB5A/aAhSj6et/ZfiOeb+XzB0xgMYqa19fM2P3+fj5/
wDJYiaJJkbVoXP53HB8sLPK1bhFdlRvVv9+qmOODRbC0iBq2Gb3tecRxjg9W
wJ5FtGtHv8Njn5/k+It9rQPTYhpsnv9H/T2lHB8sgeXFZJlc68CvQ37k+GAP
WDDRmuG3ax1dx+O1YB1Yb6JGonjN7lT/f2ADWDSRbde4jB3KDzU2gSWw3UQB
WafPXxYVzgfsBCsmiqqzvW7mA66fG+wBe02U17fdn2tPF3H+0b7WgnXR9HRP
X9uuUS7OH0xgQzT5hQ1/aelyhPMHm8BSNG1+p3e9hF48n+xgGeyMpql3pulr
VarzC+wGe6LJefVAyLuPuH5esBDja20MDXqnX2f3tdOcP1gPphia8/VXxXuD
3Jw/WASbYqjx+loDtlw8z/mD7WA5hozpa8q26C5y/mAF7I6h/r0t8Y42lzh/
sBcsxNKski1NzUVsLVgH1sfS+fO2J4eesglsAIux9Pjq3/X1ZWwTWALbY2mG
ybr3uMiWwU6wEkspUr/NYWvV/MEesDeWnhZm3Hwn/wLnH+drLVgXR+XzG01q
NYbroQcT2BBHmY1cC9+/eI7zB5vAUhz1X7Fqj+02zyc7WAY746jLd52C0/9W
9zewG+yJo7X/Ru8KbXGK8wcLS3ytXULXd/yz8GIUrx8dWA+mJdQj5Y+p1KqE
8weLYNMSes1dMnO7jvcvCWwHy0toWO0hc7oO4vebTrACdi+hvZP6DD3Y6zDn
D/aChXjqPO/fnI19eX/UgnVgfTwNnD8zIWgsm8AGsBhPAf6SdXQ+xzOBJbA9
nm7S7eGz73M+MtgJVuLJP1u+9N5+vl9usAfsjae9Tc9e/LiK6yEs9bUWrFtK
fl8cfX1V8QnOH0xgw1JaMW1Tyvy6PP9EsAksLaWfIz5Y/cClzn+wDHYupTF1
CtYkzuf9VAG7wZ6ldPCTpV8+W8/r2QsWzL7Wmmnm/g5TT3vV/Q+sB5OZmsb0
/yhj6i+cP1gEm8y03hN1NcT9K+cPtoNlM63O3D3zcfB1zh+sgN1mujei3Bq4
9TfOH+wFC8vorQE5QxpGezh/sA6sX0aLiuLf6L3sJucPNoDFZSRvaJ0sRtzi
/MES2L6M+tpWuEd14e8lMtgJVpbRgztVybUVthvsAXuXUWjLby51fe8O57/c
11qwbjnt/Ptgxh0jWw8msGE5ZRn7dilawhbBJrC0nA5GzI81jmfbwTLYuZyu
z5jQLbIOWwG7wZ7lFCMferLIpuYPFhJ8rU2gvelHr5T/w/XQgfVgSqDKDq0m
3xrBNoBFsCmBviq5m7G4gOeHBLaD5QS6fihZLPiV558TrIDdCXSn2ZOq1n3Z
HrAXLCRS/5075bRPfuf8wTqwPpG6ziw7X53G64fABrCYSA1S3jrdR8s2gSWw
PZEWRe+LDX6NLYOdYCWRTIe6XnXOZLvBHrA3kQo2pi5f253zEZJ8rQXrkuiX
H16cGa9X1z+YwIYkKm5vTFz+L1sEm8BSEm3pfDf57FO1/mAZ7Ewid+03As0t
1PUPdoM9r/KJ6lSuHcHrwQsWkn2tTaY2X4xqvka6y/mD9WB65QZtik45yjl/
sAg2JZP2tqHnjs38/VgC28FyMp387uZ5Z2AF5w9WwO5kOtM9dv3zALYH7AUL
KURZQyuEYRxPC9aB9SnUJDRZ01FQ8wcbwGIKvRO+/MeO3bl+JrAEtqfQ5cGt
jpgS+Pu3DHaClRQaavxpxJ5e6vkP9oC9KfTmhQfTNsvq73/J1xqwVqLpbf9x
3A/5qcZ+YB3YXyLX2IDI7WVn+H6BA8Ek0YOBj2fp2vHvhxCwARwu0fORI8SZ
Y/j3jAg2gk0SnW1iqFg46XKNzWAJbJXoVs8Ji/96i59X7OBCsCzRhgadj+4o
5Ho4wE6wS6LyM4+6uA7y840CLgW7JTpQekNbFnO1xmVgD7ji1f21Jl3J/5Ht
BVeBhVQqnfjlwhOH2RqwFuyXSocbj7nQ5RO2DuwP1qfSyj7tStrncz6BYAKH
pJLlpN0bZuH7ZQCHg8VUurTt0oLjo7geRrAJbE6lZvt+7Rr7WK0/2Aq2p5Km
WWTzt238vFsIlsGOVFrWZkrrFr3V9xVgF1hJpT7XU3u8/ojndynYDS5LpS5T
Cq8euqGub3AF2JtK05yfu3vWZVeBhTRfa9Log+rF+769e5brD/YD69KoXuqj
0OoZbH+wHhyYRplTNgYvSWMTOARsSCOjrbx7wiR+XxAOFsHGNIo4GfTzUJP6
vglsBktpdOPqtobbbHx/rWA7uDCNPul7ZF9vgesngx1gZxptWf/o7YJinh8u
sAIuTSO/RlHThpRe4fqDy8CeNLo7N7Fpx/q8firAXnBVGkXHjv96wcJrXP90
X2vA2nSqLnozON5zg+sP1oH90+l5p7ZnfuuoPi+BA8GUTi8/O7G/OoDPvxCw
ARyeTn6Lw+Ivva4+X4ONYFM6PfqmWVKlhW0GS2BrOi06cuyKPF/9PQYuBMvp
FNltauXa2fz/c4CdYFc6rdj/68EJvdXnV3Ap2J1Oy8Kjio52VesP9oAr0qmd
d1mLm8/5fboXXAUWMujsDZf1dr+iYzX1B2vBfhkUL51YsanvlRrrwP5gfQYN
WXl25KAg7k8KBBM4JIPOTWh+aM0S7q8ygMPBYgYN7v7fhrZF3L9lBJvA5gxq
bxz/uOUTtd8LbAXbM+jZhPyW8Q52IVgGOzJo3epPC1o2ZTvBLrCSQaPe/KVj
fDDnUwp2g8sy6IfW9xf9M5b7wzzgCrA3gxLX9U7ZE3KrxlVgIdPXmkzyb/zN
gM/f5XpowX5gXSYVGVpP0P/H/WH+YD04MJPOv/hocartBtcfHAI2ZNLEBs/W
L290jesPFsHGTJr1+OTEzsncr2kCm8FSJn3eI5QS73N/mBVsBxdmUp37x60b
Jqvf28EOsDOTTA9aONxn+fu0C6yASzMp4OSznYO2neb6g8vAnkz6tWqPPun8
Ka4/2AuuyqTVK5omDer/A9c/y9casDaL1m7WB//9/VGuP1gH9s+isB3l+XMO
fsv1BweCKYvK/9z7WeT1PVx/sAEcnkU0N2PiYUH9Hg02gk1Z9OJh8cuXnTO4
/mAJbM2isRN3NTpeP4X3f3AhWM4i57frGx4btJr3f7AT7Mqij+t12e1+dxPv
/+BSsPuVqyq1p4j7vcrAHnBFFpVFjh5Y1JHtBVeBBQt9O6yRsfdq7g/TgLVg
PwspjoUP0g6u4vMf7A/WW+jznzbfvldL4vMfTOAQC1lX9zB2GSBx/cHhYNFC
eVVNzhW0X8/1B5vAZgs1Cy7ov/t9B9cfbAXbLdRv959x793lfohCsAx2WGhS
denGxlV8XjrBLrBioeLueVJl7+95/YPd4DILUWKgubna3+kBV4C9FurcWqr3
Xij3h1WBBauvNVYKa3C4w8og7l/Rgv3AOisVrqrzpKOG+2P8wXpwoJUiSzp8
/dHGM7z+wSFgg5X02/P3VT8+x/UHi2CjldIvfzs9TOD+IRPYDJas9HGnFv9n
+51tBdvBhVZq2zrg/95dpfY7gR1g5//cq47Sls8DF1gBl1pJdyd34PQ4thtc
BvZYKXfVuuZ5an9YBdgLrrLSkDvpRlqp9n9l+1oD1mZTyFdbX5yfxPYD68D+
2VRW1vvAsz84fz04EEzZdKQw6tsToewQsAEcnk2jRwxbtXep2g8INoJN2VQ0
5fBJSxyfr2awBLZmU+7kfyZ0Suf+MDu4ECxn08AX+2vXL+b57QA7wa5surW2
X/GAL9T+MHAp2J1ND9/IzFr4Pq/PMrAHXJFN2+tdfe9MRjHXH1wFFnJI8zRN
s9iP+781YC3YL4fuVyf+2O2Q2i8L9gfrc2jRZ0caN26ynesPJnBIDo0yCP2m
NI/h+oPDwWIOLS3uVlInaHPN+WEEm8DmHNprHjPSss5ZYwlsBdtzaJ0l4L81
9Q7x+Q+WwY4c+rPL681fzFP7lcAusJJDN6c3PDD3HP8eKwW7wWU5tHhqptli
4/4qD7gC7H1VvwCx1cMo7u+pAgu5vtbkUsvXtkyfHaS+/wX7gXW5NGr45cA2
F3m8P1gPDsyl1vHXq1M7cb8FgUPAhlzqqChx9mncbxEOFsHGXNJu3DNy4mvc
L2UCm8FSLh1r07Dt1hvcf2AF28GFubSv/pmkMB33e8lgB9iZS0G2kruX/uZ+
MhdYAZfm0ltPfzyVM4DjucFlYE8u5TUoaFCSzfOpAuwFV+WS/Vb/tQ0H8P0S
8nytAWvz6Jbj4IZ7eq6fH1gH9s+j3IMRX1Z2UvvFwIFgyqN3U6TVdS7z+7sQ
sAEcnkeTh/2buCqP38eJYCPYlEel2x+OGVDB/Q1msAS25tGapKCZjkf8/s4O
LgTLefRF6F/Nnsjq+1+wE+zKo0c7r42o81h9/wcuBbvzKD8ioN/FO+wysAdc
kUfnZw3smpmk9ruBq8CCjbrGXNIHH+d8NGAt2M9GEVk3M4qOq/1hYH+w3kbJ
m1vcm6q+Pw0EEzjERsW2K9Ojeqr9hOBwsGijBSuDlOvR/D3JCDaBzTb6osdn
GjGBv1dJYCvYbqM5rZ5Ri7W8HxWCZbDDRu7l4y6tuMfrxwl2gRUbdXz9/cZH
U7jfqBTsBpfZqGiS5YkxXu1vAleAvTbaHiS3OufifqkqsJDva00+TW8e6fdp
Eu8vWrAfWJdPg9tm7csfzf1e/mA9ODCfHDHPOh4OUPvHwCFgQz65F/Up3DOY
44WDRbAxnzZ37zymfDbnYwKbwVI+5TSJaaoN4/tlBdvBhflU3M15uVTieshg
B9iZTxcGGGY16cP9YS6wAi7Np13T9+h3zOT91A0uA3vyqdfdI7c7vfyZ6w/2
gqvyaf3kkDUVtdTvPwW+1oC1BdQkZc3vQ3vxevYD68D+BTT5nfAxpclqvxg4
EEwFtKZJb3Nw+ZUP/x/nqK+o
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd1nl0jAfbBvCpFrFP0TZUGaUkpQwRDYIr1kQ0xpaFhMmCSSLJJJkko5YO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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd2Hl4E/XWB/Bhk3DBGhYhWpYBChS13oAsBYo97AEpBpASEGGQLW1ZBlpo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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxd23dck1fbB3B89LFUq6au4mwctWgdURyoiD+tKMVBFBSsWoPIcCBBVthh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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 1, Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0., -12.771371805470848`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         GraphicsBox[{
           Thickness[0.029205607476635514`], 
           StyleBox[{
             
             FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgAmJ+KJ0GBhwOdiWOtafnsDrA+Cmxd9yYd2jD+WdAgEcH
zj9/NeyNfrWOAwMINLDB+V/2fdyaPo0FO/+3Npwvs/yFh958BD9KNULm3B9W
OL9wecmGf/0saHwmuH0wPsw96PwW8VrWTDcWB3T/QfSLwu2D8WHugfFh7kXh
A/1Tef/HLeNuETjffc3R5QwzhDH4sPCC8WHhCePD3APjw9wL48P8A7MP1f+i
OPgsGP4DAAO7wKE=
              "]], 
             FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGJ1IAaxQYAJSjNCxZjR2DA5fGoGm15c5tDCTGq5gVpu
AwBUHQK3
              "], CompressedData["
1:eJx11X0slHEcAPDj9KKWq8TZvNxzznPXc+o5nCFpfatFrRZTK+tNeelKSlvZ
JIYiKyNUXnpR9Ee1MtYy0uhtolCs8oe1WKshbMeahNL9nud8f4v5bc8fn7t7
nuf79vudMiIuNFoqkUgsTFeE6bI0XRMj8d03luigKFeW6LNQDSGdjkkH83WQ
atVwydNXiz6wI1Rze7MWml6tLz9SojN/Pru3Ns1bc/2TFoKeJTv7GaiLik3r
N49uIeuhCm0sq2Ba/ajPdI126sddZ/hGmerJhIFap71v2+amBcMh01Kr0OVL
V9gYcqiTx/1PvJvPznDScGXI0TEOLeRfTV0NZ782FnHgcPWj9WFLFibJSuHg
dW1N9lyjG1zOzNj9IYCDoIcNdyU1Shg4fyzL66kD3B/pS2hJVUJOWFawxWI5
2J7OP9V6SgkZzDy25Yo9eOtN67ICnUDyeeCC7t4Yvu6a50yTMhY/sUMLz9Hb
iXHdoq7Z7h822UOdTeJoU6CzAjbXHopgIJG8d4udWL8OaglZRhVa6EO8G3qq
PlPPs7K+qIjMoU5fFFxxpYH6+8HSDm+ZeoaZ2tv10Tb26Kl8H/uOvoz6waK3
teft/RvJ/l+PNBW6Li5psDheBUkkvn7qHYMfhopK5WhhLr7I8X4hT3DAeflZ
P1RlKHCAI3HGjDfLWNhlbZ+pD3eFt2S+92vQUpIvz6G9SFrbOZDtC+ny+qVE
R5O6Biqnfc/AJrI/gjjoInGUMuJcazhxrh0ZeMQfv2PhxIFQLikDK5WKn7H2
nNjHSsWsFuZvjwLj0wy79V3jFOIch1GHk319gbqRzHMuvT+F9PeeOT8ZI/Zj
gTv0xriPFN5k0cJcVLEQte9zoHRUK+6nThYq2G/nSlqpdSS+Amqnkv1cc64W
fALqQgtemO9PMH+/e+p5HNwj+yhXBT3kvcmcOOcylfj+GA3a5W7vJn4tix44
WWU33qzG/Tk22P98lVQjnldLteZ50+B5INTDejn6/aedA7rV7ugVJH4fHr2V
zOMdXnzuBg79h5yreRq0cM7FUgt971GDcP7m8WLfg9TQS+LN4qGJ9MFDDc4k
nxQevobJq9u7WbTw+0bqNHJeFbJifW7y4EHiS2dBTs6rl9TlpB+D1ML+nKPD
fk7/P/gHVTB/gw==
              "]], 
             
             FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
              0}}}, {{{21.918800000000005`, 12.332799999999997`}, {
              21.918800000000005`, 12.678099999999999`}, {17.710899999999995`,
               12.678099999999999`}, {17.710899999999995`, 
              12.332799999999997`}, {21.918800000000005`, 
              12.332799999999997`}}}], 
             FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGI5IIaxWZDYzKNsmrABTqYCqw==
              
              "], CompressedData["
1:eJx1lAtIU1EYgKdZ0UOttbnVrrknaQXtvjIM6TfToCJDoba0pHKtB5XRJCyl
FyVppUlm2igswwJ7QGlFtB5mLx9p7zRaRREthTQxw8p27rm7Bwf9cLj345zz
///5X7qVm5JtQ2QyWYB3pXpXoHftCqovpOfyMIDErQEfuxPS48rHUrCw9XDa
33geSsu8YqVgwcPhscdNhGOzLWf5YMKjE01ZgSN5mNRt/FoeRcGBeZ4gLoCH
QktBUsAlDVhVV1tlLg7Oy6eG2N+pxfMcoOtl11VwZ1/VksfF7GBOJjwf2Vey
cAjpG6PG/IKBVJOFas5RA+z++OBYKgMyJDAeRiH9MYRVJc9HrJETPu12hTh/
0IP3nxJ+Je+Oe1JLi/aIPvtqJBowTz43rqWSEeNHwSwUj1gWbGh7WATczg2f
Ye9h8f4trRhPDr6fuqhtsujgUd3s82s3cvA2Krx64LJOirfwXqsBHDXK/oYL
PLS8WNwx7YZRYs8W7883wkfy9i59Rpkgs7qgfU3R//loUei26dsJC/47ePwN
MuH82njI6b60aH2bEfsxngcWyTMDjksLhznFANSJ5VENO/0YCH9aUfGSi+Bg
TtEe+ep8A7RrclYwn1nRvhHzGRbbrTHietnMSv7t6I/JbFYT9sXfx0L+LtPw
HtVrl34wbya8ZERYHpuul/IZj/yJ0Uv59rHp054TTR7CX9ZN6S3tpMX3iPd7
adhaV5tQliuen8yI9gw4/zcZaETiNOB++unH0azEQn04WOm+wFdYyHb3tbEz
DRCcdPGILVLsjzd6iOwMdpmthFGayrcSFvrxoN/5MsKCvrMcjodbL9Ujjp8O
5+uk6F+jVuo3RXaxo6kyAscrmQEn0veLggZUvxMZSEP9R1HwuzfrvfMDDXna
4aZGTpwnk3z9pMZ9U2vG/ZSplLhj34YCRkNY8KdVge3Xm8X+V8CqZW8Th7wm
fCW6726Gh7Dw/k4z9veeAs+PQBoSq+urZBYlrgeWhkg0n/aH4forofF7F6ih
53pb/p+hzGBOICz0SQYDPa6uGnuvCr+3ggFhHNwPw/OnnRH9UUJhisNYGspK
/vnq28dp2riuVU5OYt/8vZYSYxl4MAH85/M/ciNdvQ==
              "]], 
             FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIVIIaxWZDYzEOMzQDlM9BI/UDZhYsNABB5AsM=
              
              "], CompressedData["
1:eJx1lX1MTWEYwK+0qIUNV20+qrnndO+x7vFV52PiyR+Ra2P5isYtlUUoS76W
EiUrqRGFOyPMR0ysKERlTT7TJI2stBrL/SMt1ajlPue997wz693O3vs793mf
9/k+PpvjQ2NGazSaUbYnxvY42Z5v22b1FQTK0JVYpv1TzIKDY+O7M140srBg
f9h1fz8Z2sM8HjS0sdARealpvhfljxN7gupdKHucbnSNdZIh5Y+c8LaOhVJh
oCb6twQzrn1fakxlYRhXqwQaXFUMFORNOBBQLEHdw/IclxIdwOH254Umyltw
TaGs6HOT4CDqH8uofMi5NnfOXsrEHwbCvYN+RrlLkJ+ZseF9C6PqS+4pWRkn
szBuxZ38GE+JnFvGwtQLmwyvvCWw4vlsyuVoWDnlGNTjoifxWCFCp7LrAdWe
+yaQ++P0UHP02rqXc0U4ghfV6iFqY0vw6H0iPEd/Vhog4Vb259g8EWZzNya9
SzeQ+AyLZDdzJB7hEqSjf/0cyUcl5QjU10w5HvV12/3psrNGBmFBZeiZag6q
0Z6TNnm05yplT8xbu2FEVuJ9zADNU5Mj55ZJ8AP9MxkA0zr8lXIqynnKKvdX
fMoaWiMDj/5doazE18TR/328erc3cUQ/IxM9sbMgd9VuXcFTSeWzuEIon8D/
W0VYXjcm8HwZB4swXnEi3GE6jlx4YyDvfwnE30498adGgAdKPvXEzyIBTmF9
WPTq+cnHl3U59xpJP+wQodS48/KoQSNcbn0y3pJov8+fH5EjVof6XgzhVX3O
rlleUTt5mIdrFWWl/k2U7+I97iL4Y74ieQjEfH8RoBD9Xs9DIcrHCar+l88W
3966UCDyQTzJOydAp9LHlB3+OLj+w1or/8gIzdi/wZSVejZTnob1XvU/K31e
RLkO7UihPNiX1GbZRdmM9m41kv67L0AbzgtvI4nb6QCyaxn4jnbnBEC0Utc6
lUswLo9HZj+snz06cAtmkpxuBpD3gTpy/zvKv7DetMK/zAj2eaSDF+iHUSD9
PqADNFNzwi4/5GvfHfXkC714PkMk9hZSJvOKVfke2muhbCmaWTGYyZL+SRNh
Ov4wsyT/yaI9T6w6LxQ/uhmVHfPMwa9xWXWQbUvz/AZR9S8N58ISSWVFzkJZ
yVODpMZT2a10viry02QSn4uM+n3QYj3l0++F4/vxF7da0HM=
              "]], 
             FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgAmJ+KD1jJhBE2jrYlTjWnp7D6gDjp8TecWPeoQ3nnwEB
Hh04//zVsDf61ToQcRkEvze4RGX6fRvs/N/acL7M8hceevMR/CjVCJlzf1jh
/MLlJRv+9bOg8Zng9sH4MPeg81vEa1kz3Vgc0P0H1r/GHm4fjA9zD4wPcy8K
H+iffpB78hH8A23Lw08ZYfJh4QXjw8ITxoe5B8aHuRfGh/kHZh+K/9fg4rNg
+A8AfdjnsQ==
              "]]}, {
             Thickness[0.029205607476635514`]}, StripOnInput -> False]}, {
          ImageSize -> {34.241693648816934`, 16.76741220423412}, 
           BaselinePosition -> Scaled[0.3160991284166821], 
           ImageSize -> {35., 17.}, PlotRange -> {{0., 34.24}, {0., 16.77}}, 
           AspectRatio -> Automatic}], TraditionalForm], None}, {
        FormBox["\"operator evaluations\"", TraditionalForm], None}}, 
     FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Identity, Identity}]}, {
       Automatic, Automatic}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0., 1000.}, {-12.771371805470848`, 1.0756289486697677`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"AdaptiveEG+\"", 
       InterpretationBox[
       "\"\\!\\(\\*FormBox[\\\"2\\\", TraditionalForm]\\)-step EG\"", 
        StringForm["`1`-step EG", 2], Editable -> False], "\"MDEG\"", 
       "\"CurvatureEG+\"", "\"EG+ Adaptive\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Row\"", ",", "1"}], "}"}]}]}], "]"}]& ), Editable -> 
      True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.904743711879725*^9, 3.904743761132394*^9, 3.904743838092605*^9, 
   3.904743951260365*^9, 3.904744003307961*^9, 3.9047440593952913`*^9, {
   3.9047445533116302`*^9, 3.904744662708219*^9}, 3.904744775897482*^9, {
   3.9047448956495047`*^9, 3.904745005992625*^9}, {3.904745099573841*^9, 
   3.904745111396048*^9}, {3.904745258535687*^9, 3.904745286247486*^9}, 
   3.904745608983367*^9, 3.9047460710664377`*^9, 3.90474625542658*^9, {
   3.9047462967839603`*^9, 3.904746313940508*^9}, 3.9047464006970043`*^9, 
   3.904746438641596*^9, 3.904746471193988*^9, 3.904746507967057*^9, 
   3.904746555858864*^9, {3.9047467497557297`*^9, 3.904746754794518*^9}, {
   3.904746819463627*^9, 3.9047468386613607`*^9}, 3.904747378024078*^9, 
   3.9047474084717283`*^9, 3.904747707576429*^9, 3.904747877262314*^9, {
   3.904751826841715*^9, 3.9047518482186527`*^9}, 3.904753333508724*^9, {
   3.904757443729352*^9, 3.904757469735804*^9}, {3.904757526561977*^9, 
   3.9047575364826813`*^9}, 3.9047587129576674`*^9, {3.9047602568642807`*^9, 
   3.904760286105589*^9}, 3.904760340087598*^9, 3.9047605361298227`*^9, 
   3.904760598115803*^9, 3.904763773479649*^9, 3.9047643278703413`*^9, 
   3.904886630374518*^9, 3.904886720154244*^9, 3.904886783853525*^9, 
   3.9049775930717916`*^9, 3.9049781842558403`*^9},
 CellLabel->
  "Out[231]=",ExpressionUUID->"59e79651-5e84-4cf7-b3a4-b67ed1a08c1d"]
}, Open  ]]
},
WindowSize->{808, 647},
WindowMargins->{{Automatic, -4}, {Automatic, 42}},
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) \
(2021\:5e746\:670819\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"3f4a9c5c-2e12-45a3-a804-7008ec4bbc55"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 541, 9, 44, "Input",ExpressionUUID->"98204e13-b355-4b54-98a9-c836aed98c0f"],
Cell[1102, 31, 201, 4, 30, "Input",ExpressionUUID->"bab72329-97d8-4917-958e-7fcc6cff511d"],
Cell[1306, 37, 11506, 302, 1523, "Input",ExpressionUUID->"4fc9de00-5343-4fd5-8bb7-8a6c47b7b7a2"],
Cell[12815, 341, 29172, 680, 3505, "Input",ExpressionUUID->"1f605237-06e1-4004-a2c0-dcfd70672f09"],
Cell[41990, 1023, 8157, 185, 581, "Input",ExpressionUUID->"07fe36ad-9c3f-4298-a221-e9ceb5f6393c"],
Cell[CellGroupData[{
Cell[50172, 1212, 3433, 72, 271, "Input",ExpressionUUID->"9f1bf222-de69-49af-9d91-79ef34383170"],
Cell[53608, 1286, 2007, 29, 24, "Print",ExpressionUUID->"406ae73c-87e9-4dd6-ae01-465f190b2cc0"],
Cell[55618, 1317, 287291, 5442, 429, "Output",ExpressionUUID->"1663d25f-d090-49fe-9d6d-8c8695d67782"]
}, Open  ]],
Cell[CellGroupData[{
Cell[342946, 6764, 5935, 160, 602, "Input",ExpressionUUID->"6b1d677a-4be2-4b1f-af06-9176ad8927ad"],
Cell[348884, 6926, 68300, 1250, 390, "Output",ExpressionUUID->"59e79651-5e84-4cf7-b3a4-b67ed1a08c1d"]
}, Open  ]]
}
]
*)

