clear;
close all;

x=0:0.001:0.8;
y=0:0.001:0.8;

Z=zeros(801,801);

for i=0:800
    for j=0:800
        Z(i+1,j+1)=f(0.001*j,0.001*i);
    end
end

zmin = floor(min(Z(:))); 
zmax = ceil(max(Z(:)));
zinc = (zmax - zmin) / 300;
zlevs = zmin:zinc:zmax;

zmin = min(Z(:)); 
zmax = max(Z(:));
zinc = (zmax - zmin) / 20;
zlevs = zmin;
znow = zmin;
for i=1:100
    k=0.001+0.002*i;
    znow = (znow+zmax*k)/(1+k);
    zlevs = [zlevs znow];
end

contour(x,y,Z,zlevs,'LineWidth',1);

colorbar
axis square
xlabel("\delta_1");
ylabel("\delta_2");
hold on

xl=0.2:0.01:0.8;
yl=1-xl;
plot(xl,yl,'--m','LineWidth',1);

d1=0.52212;
d2=0.644793;
plot(d1,d2,'ro','MarkerSize',10,'MarkerFaceColor','r');

d3=0.5;
d4=0.5;
plot(d3,d4,'bs','MarkerSize',10,'MarkerFaceColor','b');

function v=f(x,y)
if x+y<1
    v=1-1./((1+x).*(1+y));
else
    v=x.*(1-x.^2-y.^2)./(2*(1-x.^2).*(1-y.^2))+y./(1+y);
end
end