close;
clear all;
k1=0.27; k2=0.5; k3=0.53;

hold on

xmin=1/((1+k1)*(1+k2));
xmax=1/((1-k1)*(1-k2));
gap=(xmax-xmin)/30;
prange1=xmin:gap/4:xmin+2*gap;
prange2=xmin+2*gap:gap:xmax-gap;
prange3=xmax-1*gap:gap/4:xmax;
prange=cat(2,cat(2,prange1,prange2),prange3);

for p=prange
    costheta=p/2*(1-k1^2)*(1-k2^2)+1/(2*p)-k1*k2;
    theta=acos(costheta);
    
    x1=real(p*costheta);
    y1=real(p*sin(theta));
    
    c1=[x1,y1]/(1-k3^2);
    c2=[x1,-y1]/(1-k3^2);
    r=k3/(1-k3^2)*p;
    viscircles(c1,r,'Color',"#EDB120",'LineWidth',1);
    viscircles(c2,r,'Color',"#EDB120",'LineWidth',1);
end

quiver(0,0,1,0,1,'Color',"#77AC30",'LineWidth',2)
fimplicit(@(x,y) (x-1/(1-k1^2)).^2+y.^2-(k1/(1-k1^2))^2,'Color','b','LineWidth',2);
fimplicit(@(x,y) sqrt((x-1/(1-k1^2)).^2+y.^2)-k1/(1-k1^2)-k2*sqrt(x.^2+y.^2),'Color','r','LineWidth',2);
fimplicit(@(x,y) (x-x1/(1-k3^2))^2+(y+y1/(1-k3^2))^2-(k3/(1-k3^2)*p)^2,'Color',"#EDB120",'LineWidth',1);
legend({'Fz^k_3','Fz^k_2','Fz^k_1','Fz^k'},'Location','northwest','FontSize',14)
axis off
axis equal