(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    358060,       7187]
NotebookOptionsPosition[    355957,       7149]
NotebookOutlinePosition[    356364,       7166]
CellTagsIndexPosition[    356321,       7163]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", ";"}]], "Input",
 CellChangeTimes->{{3.9046758395087547`*^9, 3.904675882652114*^9}, {
   3.90467597954259*^9, 3.90467597990091*^9}, 3.90467601385382*^9, {
   3.9046760554450207`*^9, 3.904676057119492*^9}, 3.904676232901587*^9, {
   3.9046768083586483`*^9, 3.904676808764234*^9}, {3.904677095062833*^9, 
   3.904677139175105*^9}, {3.9046784805202227`*^9, 3.904678508747361*^9}, {
   3.904746991905456*^9, 3.904746992407086*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"98204e13-b355-4b54-98a9-c836aed98c0f"],

Cell[BoxData[
 RowBox[{"<<", "MaTeX`"}]], "Input",
 CellChangeTimes->{{3.904747010749639*^9, 3.9047470107558107`*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"bab72329-97d8-4917-958e-7fcc6cff511d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SolveFlow", "[", 
    RowBox[{"W_", ",", "wstart_", ",", "horizon_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NDSolve", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"w1", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"W", "[", 
            RowBox[{
             RowBox[{"w1", "[", "t", "]"}], ",", 
             RowBox[{"w2", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
           "1", "\[RightDoubleBracket]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"w2", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"W", "[", 
            RowBox[{
             RowBox[{"w1", "[", "t", "]"}], ",", 
             RowBox[{"w2", "[", "t", "]"}]}], "]"}], "\[LeftDoubleBracket]", 
           "2", "\[RightDoubleBracket]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"w1", "[", "0", "]"}], "\[Equal]", 
         RowBox[{
         "wstart", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"w2", "[", "0", "]"}], "\[Equal]", 
         RowBox[{
         "wstart", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"w1", ",", "w2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "horizon"}], "}"}]}], "]"}], "//", "Flatten"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"plotFlow", "[", 
     RowBox[{"W_", ",", 
      RowBox[{"side_", ":", 
       RowBox[{"7", "/", "4"}]}]}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"StreamPlot", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"-", 
          RowBox[{"W", "[", 
           RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)\>\"", ",", 
           "\"\<\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}],
         ",", 
        RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
        RowBox[{"StreamColorFunction", "->", "None"}], ",", 
        RowBox[{"StreamStyle", "\[Rule]", "Gray"}]}], "]"}]}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotTrajectory", "[", 
    RowBox[{"W_", ",", 
     RowBox[{"p_", ":", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"k_", ":", "25"}], ",", 
     RowBox[{"T_", ":", "25"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sol", "=", 
       RowBox[{"SolveFlow", "[", 
        RowBox[{"W", ",", "p", ",", "T"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"plotFlow", "[", "W", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ParametricPlot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"w1", "[", "t", "]"}], ",", 
              RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "}"}], 
       "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotMultipleTrajectories", "[", 
    RowBox[{"W_", ",", 
     RowBox[{"stableInits_", ":", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}]}], ",", 
     RowBox[{"unstableInits_", ":", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "}"}]}], ",", 
     RowBox[{"k_", ":", "25"}], ",", 
     RowBox[{"T_", ":", "50"}], ",", 
     RowBox[{"sides_", ":", 
      RowBox[{"7", "/", "4"}]}], ",", 
     RowBox[{"withEq_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Wreverse", ",", "stable", ",", " ", "unstable", ",", "eq"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Wreverse", "[", 
        RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
       RowBox[{"-", 
        RowBox[{"W", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"stable", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "p", "}"}], ",", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"sol", " ", "=", 
               RowBox[{"SolveFlow", "[", 
                RowBox[{"W", ",", "p", ",", "T"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w1", "[", "t", "]"}], ",", 
                   RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], "]"}], ",", "stableInits"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"unstable", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "p", "}"}], ",", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"sol", " ", "=", 
               RowBox[{"SolveFlow", "[", 
                RowBox[{"Wreverse", ",", "p", ",", "T"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"w1", "[", "t", "]"}], ",", 
                   RowBox[{"w2", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"T", "-", "k"}], ",", "T"}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}]}], "]"}], ",", "unstableInits"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"eq", "=", 
       RowBox[{"If", "[", 
        RowBox[{"withEq", ",", 
         RowBox[{"ListPlot", "[", 
          RowBox[{
           RowBox[{"getEquilibria", "[", 
            RowBox[{"W", ",", 
             RowBox[{"side", "=", "sides"}]}], "]"}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], "]"}], 
         ",", 
         RowBox[{"{", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"plotFlow", "[", 
            RowBox[{"W", ",", "sides"}], "]"}], ",", "eq"}], "}"}], ",", 
         "stable", ",", "unstable"}], "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numTotalIterates", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotIterates", "[", 
    RowBox[{"W_", ",", "iterates_", ",", "legends_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"Length", "[", "iterates", "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"iteratesReduces", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArrayResample", "[", 
           RowBox[{"#", ",", "numTotalIterates"}], "]"}], "&"}], ",", 
         "iterates"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"legend", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "legends", "]"}], "\[NotEqual]", "0"}], ",", 
         
         RowBox[{
          RowBox[{"ListLinePlot", "[", 
           RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
            RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
            RowBox[{"PlotLegends", "\[Rule]", 
             RowBox[{"Placed", "[", 
              RowBox[{"legends", ",", "Below"}], "]"}]}]}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         StyleBox[
          RowBox[{"{", "}"}],
          FontWeight->"Plain"]}], 
        StyleBox["]",
         FontWeight->"Plain"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"lines", "=", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"iterates", ",", 
         RowBox[{"PlotLegends", "\[Rule]", "legend"}], ",", 
         RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"markers", "=", 
       RowBox[{"ListLinePlot", "[", 
        RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
         RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Joined", "\[Rule]", "False"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"plotFlow", "[", 
         RowBox[{"W", ",", "side"}], "]"}], ",", "\[IndentingNewLine]", 
        "lines", ",", "\[IndentingNewLine]", "markers", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"getW", "[", "L_", "]"}], ":=", 
   RowBox[{"Evaluate", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"L", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"L", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "}"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.904677020568327*^9, 3.904677044927948*^9}, 
   3.904678514407029*^9, {3.90467893523694*^9, 3.904678935532865*^9}, {
   3.9046836370861807`*^9, 3.90468363729296*^9}, {3.904734861901731*^9, 
   3.9047348691212597`*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"4fc9de00-5343-4fd5-8bb7-8a6c47b7b7a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"threshold", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AEGPlus", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Gamma]1", "*", 
             RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]1", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGn", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_", ",", "nSteps_"}], "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "0"}], ",", 
            RowBox[{"i", "<", "nSteps"}], ",", 
            RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{"zbar", "=", 
             RowBox[{"zbar", "-", 
              RowBox[{"\[Gamma]2", "*", 
               RowBox[{"V", "[", "zbar", "]"}]}]}]}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]2", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}]}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MaxIter", " ", "=", " ", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEG", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]", ",", "\[Gamma]", ",", "dold", ",", "d", ",", 
      RowBox[{"evals", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Gamma]", "=", 
      RowBox[{"1", "/", "L"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"d", "=", 
      RowBox[{"-", "Infinity"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{"evals", "+=", "1"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "evals", "]"}], "]"}], "=", 
           RowBox[{"V", "[", 
            RowBox[{"z", "-", 
             RowBox[{"\[Gamma]", "*", "Fzbar"}]}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"dold", "=", "d"}], ";", "\[IndentingNewLine]", 
             RowBox[{"Fzbar", "=", 
              RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"zbar", "=", 
              RowBox[{"zbar", "-", 
               RowBox[{"\[Gamma]", "*", "Fzbar"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"evals", "+=", "1"}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Fzbars", "[", 
               RowBox[{"[", "evals", "]"}], "]"}], "=", "Fzbar"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"d", "=", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"\[Sigma]3", "*", 
                  RowBox[{"Total", "[", 
                   RowBox[{
                    RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}]}], "-", 
                 RowBox[{"Fzbar", ".", 
                  RowBox[{"(", 
                   RowBox[{"zbar", "-", "z"}], ")"}]}]}], ")"}], "/", 
               RowBox[{"Norm", "[", "Fzbar", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"Print", "[", "d", "]"}], ";", "\[IndentingNewLine]", 
               RowBox[{"Print", "[", "zbar", "]"}], ";"}], "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"d", "-", "dold"}], "<", 
                RowBox[{"\[Epsilon]", "*", 
                 RowBox[{"Norm", "[", "Fzbar", "]"}]}]}], ",", 
               RowBox[{
                RowBox[{"d", "=", 
                 RowBox[{"-", "Infinity"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"Print", "[", "i", "]"}], ";", 
                RowBox[{"Break", "[", "]"}]}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "MaxIter"}], "}"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]3", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", "Fzbar", ")"}], ".", 
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Fzbar", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", "Fzbar"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"\[Alpha]", "<=", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", 
            RowBox[{"z", "=", "zbar"}]}], "]"}]}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Linesearch", "[", 
     RowBox[{
     "W_", ",", "z_", ",", "\[Gamma]0_", ",", "\[Nu]_", ",", "\[Tau]_"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"V", ",", "G", ",", "\[Gamma]", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Gamma]", "=", "\[Gamma]0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"i", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"V", "[", "vec_", "]"}], ":=", 
        RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"G", "[", "vec_", "]"}], ":=", 
        RowBox[{"Q", "[", 
         RowBox[{"z", "-", 
          RowBox[{"\[Gamma]", "*", 
           RowBox[{"V", "[", "z", "]"}]}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Gamma]", "*", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"V", "[", 
              RowBox[{"G", "[", "z", "]"}], "]"}], "-", 
             RowBox[{"V", "[", "z", "]"}]}], "]"}]}], ">", 
          RowBox[{"\[Nu]", "*", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"G", "[", "z", "]"}], "-", "z"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Gamma]", "*=", "\[Tau]"}], ";", 
          RowBox[{"i", "++"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"\[Gamma]", ",", "i"}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"requires", " ", "\[Lambda]", " ", "and", " ", "\[Tau]"}], ",", 
    " ", "\[Nu]"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CurvatureEGPlus", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
     "J", ",", "\[Alpha]", ",", "\[Sigma]", ",", "\[Gamma]", ",", "i", ",", 
      "\[Gamma]0", ",", "Lips", ",", "V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Q", "[", "zstart", "]"}], ",", 
         RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Q", "[", "zstart", "]"}], ",", 
         RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"linesearchSteps", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "nIterations", "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", 
       RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", 
       RowBox[{"Q", "[", "zstart", "]"}]}], ",", "\[IndentingNewLine]", "Hz", 
      ",", "Hzbar", ",", "Hzdiff", ",", "Fzbar"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"J", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"(", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"W", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Lips", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Evaluate", "@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SingularValueList", "[", 
          RowBox[{
           RowBox[{"J", "[", 
            RowBox[{"x", ",", "y"}], "]"}], ",", "1"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", 
          RowBox[{
           RowBox[{"linesearchSteps", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "0"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Gamma]0", "=", 
           RowBox[{"\[Nu]", "/", 
            RowBox[{"Re", "[", 
             RowBox[{"Lips", "[", 
              RowBox[{
               RowBox[{"z", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"z", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Gamma]", ",", 
             RowBox[{"linesearchSteps", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "}"}], "=", 
           RowBox[{"Linesearch", "[", 
            RowBox[{
            "W", ",", "z", ",", "\[Gamma]0", ",", "\[Nu]", ",", "\[Tau]"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"linesearchSteps", "[", 
              RowBox[{"[", "n", "]"}], "]"}], "]"}], ";"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"\[Sigma]", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Gamma]"}], "/", "2"}], "*", "0.99"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "zbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Hz", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Gamma]", "*", 
             RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", 
           RowBox[{"Q", "[", "Hz", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Hzbar", "=", 
           RowBox[{"zbar", "-", 
            RowBox[{"\[Gamma]", "*", 
             RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Hzdiff", "=", 
           RowBox[{"Hzbar", "-", "Hz"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Sigma]", "/", "\[Gamma]"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"zbar", "-", "z"}], ")"}], ".", 
                 RowBox[{"(", "Hzdiff", ")"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"Total", "[", 
                 RowBox[{
                  RowBox[{"(", "Hzdiff", ")"}], "^", "2"}], "]"}], ")"}]}]}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "+", 
            RowBox[{"\[Lambda]", "*", "\[Alpha]", "*", 
             RowBox[{"(", "Hzdiff", ")"}]}]}]}]}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "linesearchSteps", ",", "Fzbars"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGPlusAdaptive", "[", 
   RowBox[{"W_", ",", "zstart_", ",", "nIterations_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"V", ",", "\[IndentingNewLine]", 
      RowBox[{"iterates", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Fzbars", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"zstart", ",", "nIterations"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"z", "=", "zstart"}], ",", "\[IndentingNewLine]", 
      RowBox[{"zbar", "=", "zstart"}], ",", "\[IndentingNewLine]", "Fz", ",", 
      "Fzbar", ",", "\[Alpha]", ",", "zold"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"V", "[", "vec_", "]"}], ":=", 
      RowBox[{"W", "@@", "vec"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"zbar", "=", 
      RowBox[{"z", "-", 
       RowBox[{
        RowBox[{"1", "/", "L"}], "*", " ", 
        RowBox[{"V", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "=", 
      RowBox[{"1", "/", "L"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"zold", "=", "z"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"V", "[", "z", "]"}], "]"}], "<", "threshold"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Fzbar", "=", 
           RowBox[{"V", "[", "zbar", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Fz", "=", 
           RowBox[{"V", "[", "z", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"iterates", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "z"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Fzbars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "=", "Fzbar"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"\[Alpha]", "=", 
           RowBox[{"Evaluate", "@", 
            RowBox[{"Min", "[", 
             RowBox[{"\[Alpha]", ",", 
              RowBox[{"\[Tau]2", "*", 
               RowBox[{
                RowBox[{"Norm", "[", 
                 RowBox[{"zold", "-", "zbar"}], "]"}], "/", 
                RowBox[{"Norm", "[", 
                 RowBox[{
                  RowBox[{"V", "[", "zold", "]"}], "-", "Fzbar"}], 
                 "]"}]}]}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", "\[Alpha]", "]"}], ";"}], "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"zbar", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Alpha]", "*", "Fz"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"zold", "=", "z"}], ";", "\[IndentingNewLine]", 
          RowBox[{"z", "=", 
           RowBox[{"z", "-", 
            RowBox[{"\[Gamma]0", "*", "\[Alpha]", "*", 
             RowBox[{"V", "[", "zbar", "]"}]}]}]}], ";"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nIterations"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"iterates", ",", "Fzbars"}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.904678200286641*^9, 3.9046782475842943`*^9}, {
   3.90467909112251*^9, 3.904679097822371*^9}, {3.9046792688817797`*^9, 
   3.904679303409689*^9}, {3.904679333690419*^9, 3.904679368663969*^9}, {
   3.90467945796194*^9, 3.904679462049508*^9}, {3.904679569678234*^9, 
   3.904679581274199*^9}, {3.904680214037197*^9, 3.904680220218223*^9}, {
   3.9046803053581667`*^9, 3.904680319781455*^9}, {3.90468042553959*^9, 
   3.904680476590773*^9}, {3.904680510314959*^9, 3.904680512246313*^9}, {
   3.904680620594401*^9, 3.904680637294128*^9}, {3.904680750074663*^9, 
   3.904680774814436*^9}, {3.904681514370843*^9, 3.904681514562438*^9}, {
   3.9046815982774076`*^9, 3.904681599437152*^9}, {3.9046817061931458`*^9, 
   3.9046817093477182`*^9}, {3.904682237709672*^9, 3.904682247971066*^9}, {
   3.904682328935872*^9, 3.90468233339469*^9}, {3.904682737049563*^9, 
   3.904682784727713*^9}, {3.9046828287430973`*^9, 3.9046828389855213`*^9}, {
   3.904683087131117*^9, 3.904683088137315*^9}, {3.9046831417764053`*^9, 
   3.9046831540449533`*^9}, {3.9046832446362143`*^9, 
   3.9046832447937613`*^9}, {3.9046833751980467`*^9, 3.904683386176111*^9}, {
   3.904683425080777*^9, 3.904683468183568*^9}, {3.904683699290395*^9, 
   3.90468377238837*^9}, {3.904684501109694*^9, 3.904684513096389*^9}, {
   3.904734687310487*^9, 3.9047346889264917`*^9}, {3.904735638199567*^9, 
   3.904735642702927*^9}, {3.904735858303772*^9, 3.904735860482394*^9}, {
   3.904735913875009*^9, 3.9047359568155518`*^9}, {3.904736004679942*^9, 
   3.904736069425618*^9}, {3.904736100378529*^9, 3.904736135874916*^9}, {
   3.9047361673757353`*^9, 3.904736199601235*^9}, {3.9047362901436462`*^9, 
   3.904736295428629*^9}, {3.904736396354847*^9, 3.904736398197328*^9}, {
   3.904736500801519*^9, 3.9047365061250277`*^9}, {3.9047366743510437`*^9, 
   3.904736676121499*^9}, {3.9047368206499662`*^9, 3.904736829639427*^9}, {
   3.904739527353507*^9, 3.904739549079664*^9}, {3.9047395815001583`*^9, 
   3.904739586088181*^9}, {3.9047396277275457`*^9, 3.904739650762389*^9}, {
   3.9047396888822393`*^9, 3.9047397394239883`*^9}, {3.904740097634782*^9, 
   3.9047401338112297`*^9}, {3.90474062190948*^9, 3.904740623062583*^9}, {
   3.9047406865412693`*^9, 3.9047406874158907`*^9}, 3.904740776177493*^9, {
   3.9047408070910587`*^9, 3.9047408450710697`*^9}, {3.90474095167268*^9, 
   3.9047409532700663`*^9}, {3.904740985213286*^9, 3.9047409860956717`*^9}, {
   3.904741103924016*^9, 3.9047411395931664`*^9}, {3.904741263191353*^9, 
   3.90474128101466*^9}, {3.9047413120348*^9, 3.9047414055119333`*^9}, {
   3.9047414436890593`*^9, 3.90474144406164*^9}, {3.904741476898735*^9, 
   3.904741510553554*^9}, {3.904741625442421*^9, 3.904741630399645*^9}, {
   3.904741717509951*^9, 3.904741717679352*^9}, {3.9047417526176653`*^9, 
   3.904741761921954*^9}, {3.9047418656083307`*^9, 3.9047419315116262`*^9}, {
   3.904742010382399*^9, 3.904742038565516*^9}, 3.904742069438579*^9, {
   3.9047421109297733`*^9, 3.904742122505188*^9}, {3.90474220492393*^9, 
   3.904742212310892*^9}, {3.9047422684823093`*^9, 3.904742269026436*^9}, {
   3.904742557136195*^9, 3.9047425666712646`*^9}, {3.904742868289522*^9, 
   3.9047428828042383`*^9}, {3.904743738375304*^9, 3.904743745015914*^9}, {
   3.904743937547764*^9, 3.904743937699272*^9}, {3.904744032460966*^9, 
   3.904744032567647*^9}, {3.904745685730649*^9, 3.9047457891054487`*^9}, {
   3.904745822624514*^9, 3.904745886683846*^9}, {3.9047459252515497`*^9, 
   3.904745958212735*^9}, {3.9047462392773523`*^9, 3.904746239752275*^9}, {
   3.904746275860271*^9, 3.9047462801428823`*^9}, {3.9047463886602907`*^9, 
   3.904746418881925*^9}, {3.9047464589354343`*^9, 3.9047464919742117`*^9}, {
   3.9047465405281563`*^9, 3.904746542566366*^9}, {3.9047534739781313`*^9, 
   3.9047534918828278`*^9}, {3.904753543048904*^9, 3.904753543849313*^9}, {
   3.904753725468136*^9, 3.904753811511589*^9}, {3.904753974205056*^9, 
   3.9047541789348297`*^9}, {3.904754899423904*^9, 3.904754934771824*^9}, {
   3.904755038308757*^9, 3.904755091442843*^9}, {3.9047551415748987`*^9, 
   3.9047551443309*^9}, {3.9047553149116163`*^9, 3.9047553319981728`*^9}, {
   3.904755397928883*^9, 3.904755489015327*^9}, {3.904755763934249*^9, 
   3.904755796413554*^9}, {3.904755853548477*^9, 3.9047559043795567`*^9}, {
   3.904755998192665*^9, 3.90475601222373*^9}, {3.904756414014934*^9, 
   3.904756485836141*^9}, {3.9047565990501747`*^9, 3.904756599905182*^9}, 
   3.904756639367188*^9, {3.90475708028258*^9, 3.9047570824628153`*^9}, {
   3.9047571427515163`*^9, 3.904757164249547*^9}, {3.904757207577874*^9, 
   3.9047572099942493`*^9}, {3.904757249603448*^9, 3.904757292733881*^9}, 
   3.904757377047662*^9, {3.904757686331232*^9, 3.904757742961905*^9}, {
   3.90475792798885*^9, 3.904757928201045*^9}, {3.904758502975746*^9, 
   3.9047585802695704`*^9}, {3.90475864898275*^9, 3.9047586513397093`*^9}, {
   3.904758852990497*^9, 3.904758856546152*^9}, {3.904759371670745*^9, 
   3.9047593880525084`*^9}, {3.904759485233685*^9, 3.904759488601843*^9}, {
   3.904759539597684*^9, 3.904759551594534*^9}, {3.904759628031661*^9, 
   3.904759628426388*^9}, {3.904759804894205*^9, 3.904759818381653*^9}, {
   3.904761360901622*^9, 3.904761373745466*^9}, {3.904871828795972*^9, 
   3.904871830185938*^9}, {3.904887189944378*^9, 3.904887203859048*^9}, {
   3.904887691663862*^9, 3.904887693026312*^9}, {3.9048877626148977`*^9, 
   3.904887764023386*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"1f605237-06e1-4004-a2c0-dcfd70672f09"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"boundary", "=", 
   RowBox[{"11", "/", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"side", "=", 
   RowBox[{"11", "/", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q", "[", "z_", "]"}], ":=", 
   RowBox[{"Clip", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "boundary"}], ",", "boundary"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{"1.0", ",", "0.5"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstep", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Nu]", "=", "0.99"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Tau]2", "=", "0.99"}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"parameter", " ", "for", " ", "EG"}], "+", " ", "Adaptive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]0", "=", 
    RowBox[{"1", "/", "2"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"parameter", " ", "for", " ", "EG"}], "+", " ", "Adaptive"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "b"}], " ", "y"}], "+", 
      RowBox[{
       FractionBox["1", "16"], " ", "a", " ", "x", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "9"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["y", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{
       FractionBox["1", "16"], " ", "a", " ", "y", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "9"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["y", "2"]}]}], ")"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"N", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"70246989617", "+", 
       RowBox[{"2538096", " ", 
        SqrtBox["704424929"]}]}]], "20000"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", 
   RowBox[{"-", 
    FractionBox["50176", "1050977"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]1", "=", 
   RowBox[{"1", "/", "L"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]2", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"nstep", "*", "L"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Gamma]1"}], "/", "2"}], "*", "0.99"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]2", "=", 
   RowBox[{
    RowBox[{"-", "nstep"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"1", "/", "nstep"}]}], ")"}], "^", "nstep"}]}]}], ")"}], 
    "*", "\[Gamma]2", "*", "0.99"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]3", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "L"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Sigma]1", "=", "\[Rho]"}], ";", 
    RowBox[{"\[Sigma]2", "=", "\[Rho]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"\[Sigma]3", "=", "\[Rho]"}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.904677921084033*^9, 3.904678026828352*^9}, {
   3.904678080679626*^9, 3.90467810349658*^9}, {3.904678141222587*^9, 
   3.9046781418313828`*^9}, {3.904678222000551*^9, 3.904678231162981*^9}, {
   3.904678781141758*^9, 3.9046787926355553`*^9}, {3.9046788538632708`*^9, 
   3.904678859075272*^9}, {3.904679059951167*^9, 3.904679113810698*^9}, {
   3.9046793825694733`*^9, 3.9046793852082663`*^9}, {3.904679681841154*^9, 
   3.9046796833506927`*^9}, {3.904680799914598*^9, 3.9046808123573112`*^9}, {
   3.90468092449886*^9, 3.904680958283567*^9}, {3.904681004662218*^9, 
   3.9046810407866917`*^9}, {3.904681072210801*^9, 3.9046810840092087`*^9}, {
   3.9046811546764708`*^9, 3.904681157595323*^9}, {3.904681188572945*^9, 
   3.9046811907325068`*^9}, {3.9046812217801857`*^9, 3.904681223984742*^9}, 
   3.904681414078163*^9, {3.904681453782587*^9, 3.904681454953491*^9}, {
   3.90468148519704*^9, 3.904681485730461*^9}, {3.904681727938191*^9, 
   3.9046817489492617`*^9}, {3.904681818881843*^9, 3.904681849158907*^9}, {
   3.904681879413641*^9, 3.904681899441991*^9}, {3.904681944777953*^9, 
   3.9046819512827177`*^9}, {3.904681987824791*^9, 3.904682008230101*^9}, {
   3.904682156534088*^9, 3.904682156917536*^9}, {3.904682434893135*^9, 
   3.904682443384974*^9}, {3.9046825441818533`*^9, 3.904682545710216*^9}, {
   3.90468280823776*^9, 3.904682809674079*^9}, 3.9046830139408712`*^9, {
   3.904683177403406*^9, 3.9046832204172287`*^9}, {3.904683277025416*^9, 
   3.904683296740877*^9}, {3.904683326754285*^9, 3.904683347022284*^9}, {
   3.904683390414177*^9, 3.904683394677227*^9}, {3.904683504772533*^9, 
   3.9046835528552647`*^9}, {3.904683654705864*^9, 3.904683655565941*^9}, {
   3.9046838602696533`*^9, 3.904684009107777*^9}, {3.904684051151514*^9, 
   3.9046840866250467`*^9}, {3.904684153323841*^9, 3.9046841696492167`*^9}, {
   3.904684285255888*^9, 3.904684285385824*^9}, 3.904684417527142*^9, {
   3.904684466829834*^9, 3.904684490148085*^9}, {3.904684524505808*^9, 
   3.9046845248*^9}, {3.904684669758772*^9, 3.90468467402182*^9}, 
   3.9046881223396187`*^9, {3.904734737560341*^9, 3.9047347392433023`*^9}, {
   3.904734785145533*^9, 3.904734796377079*^9}, {3.904734896558742*^9, 
   3.9047348978354797`*^9}, {3.904734982583982*^9, 3.9047349839834642`*^9}, {
   3.904735028556096*^9, 3.904735030025326*^9}, {3.904735144343172*^9, 
   3.9047351474329844`*^9}, {3.904735206027533*^9, 3.904735206976282*^9}, 
   3.9047352475543747`*^9, 3.9047354845742283`*^9, {3.904736280624053*^9, 
   3.9047362835441732`*^9}, 3.9047363306967087`*^9, {3.904736378535879*^9, 
   3.904736441000154*^9}, {3.904736530060334*^9, 3.9047365302282352`*^9}, {
   3.9047368622914743`*^9, 3.9047368655947247`*^9}, {3.904736950638896*^9, 
   3.904736950863553*^9}, {3.904737126470788*^9, 3.904737128731061*^9}, {
   3.904737246510984*^9, 3.904737278159433*^9}, 3.9047373233020153`*^9, 
   3.9047394907032223`*^9, {3.904746738433794*^9, 3.904746739110612*^9}, {
   3.904746807614609*^9, 3.9047468300837717`*^9}, {3.904747422594507*^9, 
   3.9047474551849003`*^9}, {3.904747501737113*^9, 3.9047475277086077`*^9}, 
   3.904747663650281*^9, {3.904747859349414*^9, 3.9047478615259113`*^9}, {
   3.9047514564507723`*^9, 3.9047514838064423`*^9}, {3.9047518108952703`*^9, 
   3.904751836858994*^9}, {3.90475330672198*^9, 3.9047533115162897`*^9}, {
   3.9047535808687696`*^9, 3.904753718909051*^9}, {3.904754100825182*^9, 
   3.904754106083592*^9}, {3.904754459197925*^9, 3.904754459573647*^9}, {
   3.90475483916545*^9, 3.904754840090962*^9}, {3.904755009743355*^9, 
   3.904755010456757*^9}, {3.904755614737412*^9, 3.9047556150253963`*^9}, {
   3.904757405912719*^9, 3.904757406012788*^9}, 3.9047586894128237`*^9, {
   3.904758766607869*^9, 3.9047587675008593`*^9}, {3.904759075710082*^9, 
   3.904759099061563*^9}, 3.904759148208099*^9, {3.904759184566906*^9, 
   3.904759206680098*^9}, {3.904759277311679*^9, 3.904759278279283*^9}, {
   3.904759790848497*^9, 3.904759797950946*^9}, 3.904760453713122*^9, {
   3.904761412300699*^9, 3.904761413602048*^9}, {3.904761449792253*^9, 
   3.904761450005559*^9}, {3.904761838998028*^9, 3.904761846723752*^9}, {
   3.904886812635098*^9, 3.9048868550032787`*^9}, 3.904886973488185*^9},
 CellLabel->
  "In[125]:=",ExpressionUUID->"07fe36ad-9c3f-4298-a221-e9ceb5f6393c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AEGPlusIterates", "=", 
   RowBox[{"AEGPlus", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGnIterates", "=", 
   RowBox[{"EGn", "[", 
    RowBox[{"W", ",", "init", ",", "T", ",", "nstep"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEGIterates", "=", 
   RowBox[{"MDEG", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CurvatureEGPlusIterates", "=", 
   RowBox[{"CurvatureEGPlus", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EGPlusAdaptiveIterates", "=", 
   RowBox[{"EGPlusAdaptive", "[", 
    RowBox[{"W", ",", "init", ",", "T"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legends", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<AdaptiveEG+\>\"", ",", 
     RowBox[{"StringForm", "[", 
      RowBox[{"\"\<`1`-step EG\>\"", ",", "nstep"}], "]"}], ",", 
     "\"\<MDEG\>\"", ",", "\"\<CurvatureEG+\>\"", ",", 
     "\"\<EG+ Adaptive\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iterates", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"First", ",", 
     RowBox[{"{", 
      RowBox[{
      "AEGPlusIterates", ",", "EGnIterates", ",", "MDEGIterates", ",", 
       "CurvatureEGPlusIterates", ",", "EGPlusAdaptiveIterates"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotIterates", "[", 
  RowBox[{"W", ",", "iterates", ",", "legends"}], "]"}]}], "Input",
 CellChangeTimes->{{3.904678811815544*^9, 3.904678842713599*^9}, 
   3.9046790092753677`*^9, {3.9046793515043993`*^9, 3.90467935634138*^9}, {
   3.904679638797206*^9, 3.9046796574539213`*^9}, {3.904680533522923*^9, 
   3.90468053374251*^9}, {3.904681293207996*^9, 3.904681313081657*^9}, {
   3.9046813595563927`*^9, 3.904681390103552*^9}, {3.904681933549253*^9, 
   3.904681963265789*^9}, {3.904682019067993*^9, 3.9046820192078247`*^9}, {
   3.904682118089205*^9, 3.9046821370254793`*^9}, {3.904682891951832*^9, 
   3.904682899899241*^9}, {3.904683304722539*^9, 3.904683323673231*^9}, {
   3.904683403268262*^9, 3.9046834102693453`*^9}, {3.9046835355936613`*^9, 
   3.904683540101819*^9}, 3.9046836857263613`*^9, {3.904684075378223*^9, 
   3.904684076310137*^9}, 3.904684132907564*^9, {3.9046844564707823`*^9, 
   3.904684460002019*^9}, {3.9046852761787577`*^9, 3.9046852981133204`*^9}, {
   3.90468692052129*^9, 3.904686958567831*^9}, {3.90468703457903*^9, 
   3.9046870435537558`*^9}, {3.9047355331083603`*^9, 
   3.9047355579555817`*^9}, {3.904735652948854*^9, 3.904735657562101*^9}, {
   3.904736044372192*^9, 3.904736050055399*^9}, {3.904736258431449*^9, 
   3.904736259594943*^9}, {3.904736308931514*^9, 3.9047363168086557`*^9}, {
   3.904736873678523*^9, 3.9047369176186657`*^9}, {3.9047397729742727`*^9, 
   3.9047397733411407`*^9}, {3.904741943407835*^9, 3.904741954887806*^9}, {
   3.904743753683152*^9, 3.904743753943836*^9}, {3.904754187944406*^9, 
   3.904754238639337*^9}, {3.904754331479926*^9, 3.9047543354660254`*^9}, {
   3.904755236535652*^9, 3.904755251788733*^9}, {3.904757311195786*^9, 
   3.9047573113772984`*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"9f1bf222-de69-49af-9d91-79ef34383170"],

Cell[CellGroupData[{

Cell[BoxData["30"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624930784*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"625dcef4-637b-4a16-\
9069-285a1469e9b1"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624935068*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"5929cd9d-70fa-4e6e-\
839e-def76cf5b53f"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624940384*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"4992b1fe-cbd9-4b5d-\
af40-1d9fb0f19f76"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624943162*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"63ead6fa-fe29-4621-\
91af-d967a6907394"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624945549*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"e2b704d9-e422-4e93-\
8184-6465d9007344"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624948148*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"95e5eb05-baf8-4ec9-\
8f7b-77637cf09f40"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624950385*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"0b8d1ba2-5c86-4825-\
9b67-79365c24db6f"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977624952826*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"80f0a376-9e77-46e6-\
a5e7-74ba00381895"],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{{3.9047614038350573`*^9, 3.904761417814042*^9}, 
   3.904761633435195*^9, 3.904761852942102*^9, 3.904871753690818*^9, 
   3.904871837632312*^9, 3.9048868292512503`*^9, 3.9048876244595127`*^9, 
   3.904887703499774*^9, 3.9048877717162123`*^9, 3.904977625231641*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[146]:=",ExpressionUUID->"430be25d-59ed-4324-\
84bd-c1d606f1a5de"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{}}, {{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.6358164180398627, -0.40994636939731427`}, {
            0.612539894482517, -0.44376544633785026`}, {
            0.5874868622517452, -0.47630102464843854`}, {
            0.5607422555029874, -0.5074691590494622}, {
            0.5323910083916841, -0.537185904261305}, {
            0.5238332484104997, -0.5452226185390128}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5206258692560695, -0.5482347139823422}, {
            0.5024677363229759, -0.5652872752274303}, {
            0.47102535242938515`, -0.5916383922647266}, {
            0.4381762374574238, -0.6161989681537168}, {
            0.40403277215360384`, -0.6389287156749235}, {
            0.37989412957396484`, -0.6531818752618753}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.37610532546791114`, -0.65541905282433}, {
            0.36870733726443733`, -0.6597873476088695}, {
            0.33231231353643603`, -0.6787345767360774}, {
            0.29496008171611193`, -0.6957301158370697}, {
            0.2567630225499764, -0.7107336776923696}, {
            0.21782166002160464`, -0.7236111351940733}, {
            0.2146480360508863, -0.7244651692863475}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2103991912571552, -0.7256085493276216}, {
            0.178240829664731, -0.7342624848300682}, {
            0.1381393795511052, -0.7426986247745644}, {
            0.09763615775247779, -0.7489304532017715}, {
            0.05685001234059922, -0.7529688682858994}, {
            0.03711730172651942, -0.7538631720308823}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.03272181353743009, -0.7540623794091998}, {
            0.015899791387219885`, -0.7548247682011576}, \
{-0.025095657035909717`, -0.7545090511217557}, {-0.06601748485703982, \
-0.7520326152219035}, {-0.10671793553748621`, -0.7473162931049941}, \
{-0.1423792256058832, -0.7411261268996122}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.14671439919691728`, -0.7403736178062448}, \
{-0.14705976470835858`, -0.7403136684910818}, {-0.1869398925525978, \
-0.7310847662293667}, {-0.22625523925314425`, -0.7196896111690491}, \
{-0.26490272499293827`, -0.7061882281593298}, {-0.30277926995492, \
-0.6906406420494088}, {-0.31353363680832746`, -0.6855446509654555}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.3175098233144387, -0.6836605222892185}, \
{-0.33978179432202993`, -0.6731068776884869}, {-0.3758072182772082, \
-0.653646959925764}, {-0.41068818102353416`, -0.6322514551510502}, \
{-0.4442806966658548, -0.6089361873757513}, {-0.4668326064987525, \
-0.5913505950526011}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.47030238202275726`, -0.5886449236362947}, \
{-0.4765167477397617, -0.5837990678814626}, {-0.5073283167808473, \
-0.5569380079497795}, {-0.5366473863247029, -0.5284509188622977}, \
{-0.5644059389069196, -0.49843571190061314`}, {-0.5905359570630898, \
-0.4669902983463207}, {-0.5932824667462162, -0.46330583156578964`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5959121360492221, -0.45977810717791173`}, \
{-0.6149694233288053, -0.43421258948101593`}, {-0.6375505803853826, \
-0.40016506707517396`}, {-0.6581555763156927, -0.364923096357859}, \
{-0.6767642517576594, -0.32860391379855036`}, {-0.6855576745423569, \
-0.30884695065625}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6873468158661558, -0.30482712810749546`}, \
{-0.6933564473492062, -0.29132475586672735`}, {-0.7079120037282574, \
-0.25320285903186934`}, {-0.7204107615327364, -0.21435545976345546`}, \
{-0.7308325614005672, -0.17489979453096507`}, {-0.7387476174566578, \
-0.13691872733762545`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7395158645344095, -0.1325879899782179}, \
{-0.7452702524329238, -0.09463768623743034}, {-0.7490913563268433, \
-0.05407401932840727}, {-0.7506518858048404, -0.013376567808599001`}, \
{-0.7499831710203234, 0.027340199590202188`}, {-0.7488974812514321, 
            0.04272498532460853}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7485877476930702, 
            0.04711407009513011}, {-0.7471165421267009, 
            0.06796181413620427}, {-0.742083329277381, 
            0.1083738070976151}, {-0.7349148626257719, 
            0.1484617097426425}, {-0.725642472325282, 
            0.18811105333949502`}, {-0.7163929886324848, 
            0.21971876010444455`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7151572251643779, 
            0.22394166060657486`}, {-0.7142145465452631, 
            0.2271630198041452}, {-0.7006096341765421, 
            0.2654749180897419}, {-0.6849043064547401, 
            0.30295647002025783`}, {-0.667175134615478, 
            0.33951739741966536`}, {-0.647498689894377, 
            0.37506742211193667`}, {-0.6421512752843819, 
            0.3836166864804964}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.6398179859722486, 
            0.3873470699709548}, {-0.6259515435270581, 
            0.40951626592104384`}, {-0.6026102667491425, 
            0.4427736506709593}, {-0.5775514307962512, 
            0.47474929818565503`}, {-0.5535342169295892, 
            0.5023197000022673}, {-0.5312987518554168, 
            0.5253756722334504}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5282443474759931, 
            0.5285427866751714}, {-0.5281681377607859, 
            0.5286218085922622}, {-0.5015306094805244, 
            0.5536157492502848}, {-0.47369904827948817`, 
            0.5772616472709807}, {-0.4447508703483585, 
            0.5995196279489968}, {-0.41476349187781847`, 
            0.6203498165789784}, {-0.3894879861313543, 
            0.6361627655694172}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3857578391564166, 
            0.6384964329718897}, {-0.38381432905855134`, 
            0.6397123384555711}, {-0.35198079808123867`, 
            0.6575673188734213}, {-0.31932342596444263`, 
            0.673814437165455}, {-0.2859088812438602, 
            0.6883753530143137}, {-0.251823792385876, 
            0.7012431622392185}, {-0.2253147887393684, 
            0.7097824097043752}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.22112671522149366`, 
            0.7111314983630171}, {-0.21715478785687423`, 
            0.7124109606593899}, {-0.18198849612324045`, 
            0.721871844094048}, {-0.1464115456513603, 
            0.7296189083624132}, {-0.1105105649076181, 
            0.7356452492837059}, {-0.0743721823583981, 
            0.7399439626771467}, {-0.04823097387025113, 
            0.7417468333719881}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.043841400756328086`, 
            0.7420495673765596}, {-0.03809053446862529, 
            0.7424461851650889}, {-0.0017570275219363067`, 
            0.7431055839869285}, {0.03454580528721455, 0.7419490508874496}, {
            0.07073543076437207, 0.7390034776114365}, {0.10672931571508203`, 
            0.7342957559036736}, {0.13129773627528094`, 
            0.7298636939170132}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.1356278430892602, 0.7290825569382892}, {
            0.14244492694489014`, 0.7278527775089448}, {0.17779973125934123`, 
            0.7197014341720348}, {0.21271119546398104`, 0.7098686176377276}, {
            0.24706533867422198`, 0.698326380758144}, {0.2807596155291612, 
            0.6850667178009187}, {0.3026886466197538, 0.6751426347617372}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.30669726009643355`, 0.6733285184494293}, {
            0.31372864611987117`, 0.670146432634107}, {0.3459070505374245, 
            0.6536223291257641}, {0.37722944887289367`, 0.6355512111439455}, {
            0.407630461217351, 0.615989882556706}, {0.4370447076618696, 
            0.5949951472321009}, {0.4556201503448574, 0.5803432878475938}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4590748067800606, 0.5776183385059162}, {
            0.46540680829752124`, 0.5726238090381858}, {0.4907495473395962, 
            0.5505968411172959}, {0.5150090440662499, 0.5274224157660762}, {
            0.5381519513769514, 0.5031617567209605}, {0.5601449221711694, 
            0.4778760877183826}, {0.5809546093483726, 0.451626632494776}, {
            0.5811126758202698, 0.451407584300184}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.5836873888479716, 0.44783955223404687`}, {
            0.60054766580803, 0.42447461478657456`}, {0.6188907444496103, 
            0.3964812583302119}, {0.6359504981725825, 0.3677077868621218}, {
            0.6516455444802481, 0.3381983027629957}, {0.6659119682926969, 
            0.3080031343610675}, {0.671082258876799, 
            0.29558770052088257`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6727737840844386, 0.2915258361125203}, {
            0.6787426236345799, 0.2771928443140851}, {0.6901303645305479, 
            0.24583799527979605`}, {0.7000680450052518, 
            0.21400914991594813`}, {0.7085485190833424, 0.181776870880289}, {
            0.7155646407894708, 0.14921172083056627`}, {0.7200828380462951, 
            0.1224613136486577}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7208156278733855, 0.11812276330674475`}, {
            0.7211092641482879, 0.11638426242452772`}, {0.725131563599533, 
            0.08337186231045603}, {0.7275965970683681, 
            0.050249412958257515`}, {0.7285210438075774, 
            0.01708376575811536}, {
            0.7279215830699456, -0.016058227899787343`}, {
            0.7258148941082568, -0.04910971662526745}, {
            0.7249102336151121, -0.05738218083134172}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7244319099070422, -0.061756104290925616`}, {
            0.7222176561752958, -0.08200384902814183}, {
            0.7171465485238467, -0.11467377371822733`}, {
            0.7106182504066941, -0.14705263930534085`}, {
            0.7025754078189405, -0.17907639055852584`}, {
            0.6929875879402997, -0.2106799554616525}, {
            0.6851083189363977, -0.23281514066312936`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6836327834080279, -0.23696035415636693`}, {
            0.6819118518004734, -0.24179495744677762`}, {
            0.669405260429164, -0.2723530199459582}, {
            0.6555248748560735, -0.3022857663912512}, {
            0.6403277561109032, -0.33152482021471325`}, {
            0.6238709652233557, -0.36000180484840155`}, {
            0.6062115632231325, -0.3876483437243726}, {
            0.602617440382909, -0.3927093527011768}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.6000698038914062, -0.3962967679694672}, {
            0.5838395444122672, -0.4191511590327046}, {
            0.5598933371282269, -0.44926929639680024`}, {
            0.5343729413710119, -0.47800275581665974`}, {
            0.5072783571406217, -0.5053515372922832}, {
            0.48314383345142425`, -0.5272120403836331}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.479882723890046, -0.5301658793143615}, {
            0.4787810603798277, -0.5311637410861907}, {
            0.44905252703140064`, -0.5552874674609022}, {
            0.4180927570953405, -0.5777227164164181}, {
            0.3859017505716472, -0.5984694879527382}, {
            0.35267999526615523`, -0.6174177593798377}, {
            0.3334962271833093, -0.6270173843525516}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3295613828548152, -0.6289863942840953}, {
            0.31862797898469875`, -0.6344575080076911}, {
            0.2837457017272781, -0.6495887338362991}, {
            0.2480331634938928, -0.6628114368656612}, {
            0.223231664676626, -0.6705492586923909}, {
            0.19818559685418766`, -0.6773435118880677}, {
            0.17294341065863342`, -0.6831842604385385}, {
            0.16329124447590926`, -0.6850385293990916}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1589702570517624, -0.6858686304052135}, {
            0.14752933140605956`, -0.6880665363367124}, {
            0.10570383912916273`, -0.694181713332715}, {
            0.06361176212900449, -0.6976615370532107}, {
            0.02147966522150813, -0.6985600566813209}, \
{-0.016194292804512674`, -0.6970971863245481}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.020590473744643928`, -0.6969190792238228}, \
{-0.06074265261313189, -0.6929736420307466}, {-0.10047970535367001`, \
-0.6866800237459862}, {-0.1396770449990175, -0.678050466545886}, \
{-0.17833467154917435`, -0.6670849704304461}, {-0.19259600776282662`, \
-0.6621126706172695}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1967507227020538, -0.6606641045077106}, \
{-0.2161844560134104, -0.653888417638981}, {-0.2529582694009956, \
-0.6385656904108052}, {-0.28865611171192984`, -0.6211167887459187}, \
{-0.32327798294621324`, -0.6015417126443214}, {-0.3535726833907589, \
-0.5819572082688936}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.3572404115850745, -0.5795287388831044}, \
{-0.3883476735733419, -0.5566845037287471}, {-0.41855895831331585`, \
-0.5315702375642082}, {-0.4472212026708962, -0.5046655302618347}, \
{-0.4616171407220599, -0.49031491358640383`}, {-0.4755449094351093, \
-0.4755449232888805}, {-0.486663954212676, -0.46116225301202324`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.48935510559743417`, -0.45768120371270066`}, \
{-0.5015770881883609, -0.44187186493843444`}, {-0.5251550145755371, \
-0.40674633375483443`}, {-0.5474847028378975, -0.3710033772313681}, \
{-0.5673179148506261, -0.33402557002816924`}, {-0.5795578767121681, \
-0.3070676100343782}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5813769274876535, -0.30306123333264307`}, \
{-0.5845878499630695, -0.29598932243826337`}, {-0.5992277075245738, \
-0.2570710447546763}, {-0.6111973093981484, -0.21745688296803217`}, \
{-0.6204564774468028, -0.1773329830689552}, {-0.6253151094286052, \
-0.14913348247350358`}, {-0.627248140257037, -0.13377852814864366`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6277977172149832, -0.12941298520792088`}, \
{-0.628880722947026, -0.12081017178948739`}, {-0.6311466306889761, \
-0.0924379617876721}, {-0.632106145341367, -0.0640917632388233}, \
{-0.6317525795911096, -0.035846486913706496`}, {-0.6300792461251156, \
-0.007777043583087053}, {-0.6270794576302955, 
            0.020041655982269382`}, {-0.6230072619907567, 
            0.045880300148224494`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6221943577966823, 
            0.05020335432465317}, {-0.6171340058028982, 
            0.07466022385151207}, {-0.6103139820773926, 
            0.1013865239616688}, {-0.6023075711506056, 
            0.12765394124086246`}, {-0.593135888556098, 
            0.15340281558788782`}, {-0.5828200498274312, 
            0.17857348690153957`}, {-0.571381170498166, 
            0.20310629508061276`}, {-0.5646867694703789, 
            0.21582979757531712`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.5626380074478206, 
            0.21972371259428233`}, {-0.5588403661018635, 
            0.22694158002390205`}, {-0.5452187521720852, 
            0.2500196816302021}, {-0.5305817401859629, 
            0.2723080328722408}, {-0.5150083711417283, 
            0.29378240305318654`}, {-0.49854020485459055`, 
            0.3143956365674952}, {-0.4812188011397588, 
            0.3341005778096231}, {-0.4630857198124428, 
            0.35285007117402634`}, {-0.45641425478045006`, 
            0.35911344249484106`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4532064206132795, 
            0.36212505335216194`}, {-0.4441825206878517, 
            0.3705969610551608}, {-0.4245507635811948, 
            0.3872940918474829}, {-0.4042320083076817, 
            0.40289430794544856`}, {-0.3833020396664672, 
            0.41739782839420064`}, {-0.36184717322099696`, 
            0.43081944905447817`}, {-0.3399247649329169, 
            0.4431338795441311}, {-0.31759217076387275`, 
            0.45431582948100924`}, {-0.3072173831102039, 
            0.4589002149499583}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3031927874315951, 
            0.46067859331906974`}, {-0.29490674667551015`, 
            0.464340008482963}, {-0.271925848629475, 
            0.47318112616784214`}, {-0.24870683258741308`, 
            0.4808138921534967}, {-0.22530705451097, 
            0.48721301605777667`}, {-0.18049979105938746`, 
            0.4961076637917291}, {-0.13572848249726482`, 
            0.5008126566462809}, {-0.1328103263474328, 
            0.5008471258311998}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1284106332653284, 
            0.5008990948920201}, {-0.09141803975192883, 
            0.5013360504492191}, {-0.04799337375070554, 
            0.497685901028331}, {-0.005819950600615004, 
            0.49006902543890346`}, {0.03477073206006928, 
            0.47880581858050986`}, {0.04453210504415563, 
            0.47508381275818296`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.04864337624517818, 0.4735161874484732}, {
            0.07340471600714099, 0.464074703047366}, {0.1097080430163938, 
            0.4460541014336875}, {0.14345109542110873`, 0.4250726721571975}, {
            0.17448673587313143`, 0.4015449226776232}, {0.1968036329238512, 
            0.3810649435777923}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.20004545918952352`, 0.3780899540881979}, {
            0.20256472662610223`, 0.37577804915218654`}, {0.2274348299336614, 
            0.34807924773810917`}, {0.24903781788413956`, 
            0.3188191509863914}, {0.2674236110428334, 0.2884046408159068}, {
            0.2825056943788323, 0.2571972874356869}, {0.2924830259658225, 
            0.23019823789752022`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.29400820884357204`, 0.22607103337273354`}, {
            0.2941975528612255, 0.2255586610547635}, {0.30321159386750673`, 
            0.19098444775461434`}, {0.30860099814998665`, 
            0.1566758359229794}, {0.31045791657816424`, 
            0.12306040213171773`}, {0.3088745000215382, 
            0.09056572295268833}, {0.3041270267796254, 
            0.059466445425392096`}, {0.302313852286332, 
            0.052359072013321725`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3012261961352718, 0.048095622225056256`}, {
            0.29659699082623814`, 0.02994982828512542}, {0.28653436654231934`,
             0.0023123656474406287`}, {
            0.2741891283088117, -0.023149448372110026`}, {
            0.25988195134716147`, -0.046336191966611276`}, {
            0.24397391135910232`, -0.06726105607694033}, {
            0.2267755834460091, -0.08579646570923329}, {
            0.21120914456934844`, -0.09951351801871199}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.20782644946115436`, -0.10231502978589561`}, {
            0.17039935766882572`, -0.1265928060384181}, {
            0.1315734260459252, -0.1421795131107185}, {
            0.08784703534848556, -0.14977361474009207`}, {
            0.04787670482806551, -0.1477611079227952}, {
            0.04292274287648162, -0.1463584582774076}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.03868916728440467, -0.14515977662401908`}, {
            0.01334626568983418, -0.13798426492608354`}, \
{-0.01493680705175553, -0.12266365629525548`}, {-0.03649021526163662, \
-0.1037397832238808}, {-0.05159501577948562, -0.08306222669282229}, \
{-0.06446423100278663, -0.04227837385225146}, {-0.06118723558118664, \
-0.022103100135077436`}}]}, {
           Arrowheads[{{0.004780704305575081, 1.}}], 
           
           ArrowBox[{{-0.060481804652592105`, -0.017760017450510833`}, \
{-0.05838151341268593, -0.004829285118208439}, {-0.04058940417403038, 
            0.018033392336122153`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.4719364993433751, 1.1}, {0.479291627864313, 
            1.0928835202776934`}, {0.5042065458270512, 1.0690575114939573`}, {
            0.5286852403046496, 1.0456955776765335`}, {0.5527226344393937, 
            1.0226793884843708`}, {0.576313651373569, 0.999890613576418}, {
            0.5986792139701738, 0.9778877908438635}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6017829125916377, 0.9747690773664917}, {
            0.622036966024001, 0.9542813400987542}, {0.6441393668362047, 
            0.931282349900446}, {0.6657355966397331, 0.9081537907291535}, {
            0.6868256554345868, 0.884895662584877}, {0.7074095432207657, 
            0.8615079654676162}, {0.7211078644235214, 0.8454629605357905}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7239647836629389, 0.8421166173884959}, {
            0.7274872599982695, 0.8379906993773714}, {0.7470588057670984, 
            0.8143438643141422}, {0.7674668449993165, 0.7892948875631537}, {
            0.7872432135886654, 0.763945392052278}, {0.8094950359430247, 
            0.7316503032841595}, {0.8292702711226645, 0.7013298805512582}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8316352366572507, 0.6976199823112549}, {
            0.8510424963471932, 0.6659435116681471}, {0.8702846571017742, 
            0.6324928096025879}, {0.8864039343273467, 0.6045427309448104}, {
            0.9017288013080953, 0.5763180585965159}, {0.9162592580440196, 
            0.5478187925577039}, {0.9179347797769577, 0.5443089596994475}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.9198303347782417, 0.540338207725689}, {
            0.9299953045351201, 0.519044932828375}, {0.9429369407813968, 
            0.489996479408529}, {0.9550841667828492, 0.4606734322981657}, {
            0.9664369825394777, 0.43107579149728537`}, {0.9769953880512823, 
            0.40120355700588783`}, {0.9848408792633903, 
            0.37696052903531785`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.9861956259448865, 0.37277428233582977`}, {
            0.9867284255408295, 0.37112790033654575`}, {0.9956051372306862, 
            0.3409199930018318}, {1.0036255231208524`, 
            0.31057983500174596`}, {1.0107895832113276`, 
            0.28010742633628816`}, {1.0170973175021127`, 
            0.24950276700545845`}, {1.0225487259932071`, 
            0.2187658570092569}, {1.0251451081474172`, 
            0.2013237034638838}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.025792939706066, 0.19697165632815347`}, {
            1.027143808684611, 0.18789669634768336`}, {1.030882565576324, 
            0.1568952850207379}, {1.0337535984230606`, 
            0.12584972871907207`}, {1.0357455089795344`, 
            0.09484813313333741}, {1.0368582972457454`, 
            0.06389049826353399}, {1.0370919632216933`, 
            0.032976824109661636`}, {1.0368523295476473`, 
            0.02151605955624049}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0367603498412883`, 0.017117021055202096`}, {
            1.0364465069073787`, 0.0021071106717204394`}, {
            1.0349219283028013`, -0.028718642050289508`}, {
            1.032518227407961, -0.05950043405636837}, {
            1.029235404222858, -0.0902382653465161}, {
            1.0250856160322848`, -0.1208373702923308}, {
            1.0200810201210342`, -0.15120298326541062`}, {
            1.0188057846464256`, -0.1577609116892959}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.0179659056477368`, -0.16208000919543783`}, {
            1.0142216164891058`, -0.18133510426575544`}, {
            1.0075074051365, -0.21123373329336548`}, {
            0.9999383860632168, -0.24089887034824062`}, {
            0.991514559269256, -0.2703305154303808}, {
            0.9822359247546176, -0.2995286685397862}, {
            0.9721024825193018, -0.3284933296764566}, {
            0.9709633401333001, -0.3314718298893077}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9693915692502821, -0.3355815179907695}, {
            0.9611494991815447, -0.3571319472924422}, {
            0.9494122413595825, -0.38535196983979336`}, {
            0.9368907090534152, -0.41315339731850964`}, {
            0.9235849022630429, -0.4405362297285912}, {
            0.9094948209884655, -0.46750046707003834`}, {
            0.8946204652296831, -0.4940461093428506}, {
            0.8943246132067627, -0.4945397502072394}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8920627013284351, -0.49831384011802327`}, {
            0.8789618349866956, -0.5201731565470281}, {
            0.862518930259503, -0.5458816086825713}, {
            0.8453486607075688, -0.5710878472426489}, {
            0.8275079359903565, -0.5957082537204303}, {
            0.8089967561078663, -0.6197428281159156}, {
            0.7907882739460499, -0.6420019319443142}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7879380052972385, -0.6453533744869484}, {
            0.769963030847051, -0.6660544806599977}, {
            0.7494404854687262, -0.6883315588085945}, {
            0.728247484925123, -0.7100228048748952}, {
            0.706384029216242, -0.7311282188588997}, {
            0.6719737971288615, -0.7620181773457207}, {
            0.6632151811897249, -0.7692200966513665}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.659816583414127, -0.7720146508483183}, {
            0.6362194351489667, -0.7914178029935871}, {
            0.5992012222696339, -0.8192406690653938}, {
            0.5609994374839384, -0.8454003488240359}, {
            0.521694359784956, -0.8698104155324089}, {
            0.5159585282642982, -0.8730211009371212}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.5121191079903447, -0.8751702523882651}, {
            0.4813662681657626, -0.8923844424534074}, {
            0.44009544161943376`, -0.9130360028499266}, {
            0.3979621591390451, -0.9316786699848618}, {
            0.35505431584661873`, -0.9483393390714432}, {
            0.3526810467933982, -0.949141846051449}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.34851289492357446`, -0.9505512821053674}, {
            0.3114621502884673, -0.963079773615312}, {
            0.26726945659410284`, -0.9758658493179794}, {
            0.22256002889303822`, -0.9866634418809571}, {
            0.17849642262589424`, -0.9952287323227785}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1741520336618924, -0.9959206996856349}, {
            0.1319261479888578, -1.0021566803938882`}, {
            0.08616928304476631, -1.0067840777468642`}, {
            0.04023086061202444, -1.0092864947661957`}, \
{-0.0010868264497104485`, -1.0096566249342744`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.005486649913618562, -1.0096960392266519`}, \
{-0.005780743399648203, -1.009698673761137}, {-0.05174958945585118, \
-1.0080765467664023`}, {-0.09758053799005256, -1.004417774071692}, \
{-0.14317844943572172`, -0.9987200159667063}, {-0.18041736226546493`, \
-0.9923538411492081}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.18475444184386206`, -0.9916123961204631}, \
{-0.18844818422632667`, -0.9909809327411458}, {-0.23329460279533545`, \
-0.9811981846847111}, {-0.2776225655762174, -0.9693694320871021}, \
{-0.32133693300244065`, -0.9554923352380199}, {-0.3538101572520051, \
-0.94352426224216}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.3579386915148197, -0.9420026825233264}, \
{-0.3643617858020021, -0.939635438029909}, {-0.4066271186396783, \
-0.92188909469452}, {-0.44804666285410427`, -0.9022836810305116}, \
{-0.4885341497839156, -0.8808495728365443}, {-0.5158342237724125, \
-0.8647801414581586}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5196260929076078, -0.8625481628602429}, \
{-0.5280033107677485, -0.8576171459112764}, {-0.5663678771442384, \
-0.8326167760533675}, {-0.6035415802520203, -0.8058788390614772}, \
{-0.6394381514297311, -0.7774337107342644}, {-0.6612502855640521, \
-0.7584802508455134}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6645715760439235, -0.7555942450332678}, \
{-0.6733993076831934, -0.7479234661675586}, {-0.7060332477183975, \
-0.716965233423003}, {-0.7372721926801047, -0.6846159713113268}, \
{-0.7670483637130752, -0.6509326386432586}, {-0.7855216036015064, \
-0.6280677584849351}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7882867807389854, -0.6246452162429221}, \
{-0.7952939819620697, -0.6159721942295278}, {-0.8219412685718487, \
-0.5797915968808632}, {-0.8469224446871727, -0.542447805407994}, \
{-0.8701697314528024, -0.5039977786216487}, {-0.8845492958455854, \
-0.4776059909103242}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.886654444663735, -0.4737422688119528}, \
{-0.8916679327510825, -0.4645406748220167}, {-0.9114180317682293, \
-0.42418863676758256`}, {-0.9293765186048119, -0.3830180999565179}, \
{-0.9454998833613986, -0.34110549988699485`}, {-0.95526273183728, \
-0.3119238512610196}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9566587187109907, -0.30775117578257327`}, \
{-0.9597446161385583, -0.29852727205718543`}, {-0.9720672070368596, \
-0.2553598519652617}, {-0.9824241461568708, -0.21167967510939567`}, \
{-0.9907719235991608, -0.1675631769877594}, {-0.9952452007783945, \
-0.13629027460652027`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.9958682354381021, -0.13193460843326926`}, \
{-0.9971304809357552, -0.12311018762328377`}, {-1.0015392832683587`, \
-0.07842773535420991}, {-1.0039841059920582`, -0.033603053151675416`}, \
{-1.0044507245019414`, 0.011276626013182495`}, {-1.0033486022432303`, 
            0.0436708004803483}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.0031989909669006`, 
            0.04806825616130689}, {-1.0029249141930954`, 
            0.056124069169225764`}, {-0.9993924504606071, 
            0.1008520433453164}, {-0.9938391086995642, 
            0.1453733155703171}, {-0.9862506643050536, 
            0.18960065287309036`}, {-0.9791429922946625, 
            0.2221664046058332}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.978204752599778, 
            0.22646520749442242`}, {-0.9766806938059286, 
            0.23344810150445022`}, {-0.9652036356183556, 
            0.27683010132196245`}, {-0.9518365579683903, 
            0.3196600097646212}, {-0.9365965290820896, 
            0.3618511842714204}, {-0.9235410323811997, 
            0.3935170347035767}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.921863908214954, 
            0.39758486637794505`}, {-0.9195006171855089, 
            0.4033169822813533}, {-0.9005658905047051, 
            0.4439707612334138}, {-0.879809417265734, 
            0.4837258785665951}, {-0.8572482656946521, 
            0.522495691719891}, {-0.8429587054377301, 
            0.5451345072779702}, {-0.8382502723262831, 
            0.5521841290359523}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{-0.8358064715059588, 
            0.5558430684383723}, {-0.8280903124277925, 
            0.5673959569764394}, {-0.81265271164632, 
            0.5892641555366859}, {-0.7966555280747938, 
            0.6107232176800973}, {-0.7801083866946945, 
            0.6317572581280608}, {-0.7630209124875029, 
            0.6523503916019641}, {-0.7454027304347001, 
            0.6724867328231942}, {-0.7272634655177661, 
            0.6921503965131395}, {-0.726187474213694, 0.6932566400632338}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7231196305799156, 
            0.6964107382606091}, {-0.7086127427181826, 
            0.7113254973931866}, {-0.689460187017431, 
            0.7299961501847222}, {-0.6698154233969913, 
            0.7481464696091344}, {-0.6496880768383447, 
            0.7657605703878109}, {-0.6290877723229719, 
            0.7828225672421386}, {-0.6080241348323538, 
            0.7993165748935054}, {-0.5907748462035848, 
            0.8120708655827124}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5872369434414343, 
            0.8146868250712305}, {-0.5865067893479713, 
            0.8152267080632982}, {-0.5645453608513051, 
            0.8305370814729048}, {-0.5421738051526593, 
            0.8452540859488663}, {-0.5194299709949496, 
            0.8593876764945483}, {-0.496329322758574, 
            0.872927314096575}, {-0.47288732482393125`, 
            0.8858624597415711}, {-0.44911944157141964`, 
            0.8981825744161605}, {-0.4361274961811672, 
            0.9044926070824163}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4321696194814994, 
            0.9064149005122097}, {-0.4250411373814376, 
            0.9098771191069676}, {-0.40066787663438347`, 
            0.9209355548006167}, {-0.3760151237106549, 
            0.9313473424837326}, {-0.351098342990651, 
            0.9411019431429393}, {-0.32593299885477106`, 
            0.9501888177648603}, {-0.3005345556834126, 
            0.9585974273361206}, {-0.27491847785697415`, 
            0.9663172328433447}, {-0.2676548853508454, 
            0.9682923389037953}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2634090541856379, 
            0.9694468594608028}, {-0.24910022975585397`, 
            0.9733376952731564}, {-0.22309527576045055`, 
            0.9796482756121804}, {-0.19691908025116223`, 
            0.9852384348470408}, {-0.1705871076083874, 
            0.9900976339643619}, {-0.1441272494944497, 
            0.9942459345311191}, {-0.11756938593678065`, 
            0.9977082942071435}, {-0.09093196386344073, 
            1.000481518118344}, {-0.09041170622200122, 1.000522067185183}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.08602500997904805, 
            1.000863967860907}, {-0.0642334302024895, 
            1.0025624113906288`}, {-0.03749223188198822, 
            1.0039477791499065`}, {-0.01072681582999827, 1.004634426522086}, {
            0.016044371025420816`, 1.004619158633075}, {0.04280288175620854, 
            1.0038987806087825`}, {0.0695302694343046, 1.0024700975751173`}, {
            0.08975141227243157, 1.0008478905056346`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.09413732153388252, 1.000496038334519}, {
            0.09620808713164844, 1.0003299146579876`}, {0.12281788792017974`, 
            0.997475036983302}, {0.14934122487183793`, 0.993902269676969}, {
            0.17575965105856264`, 0.989608417864897}, {0.20205471955229343`, 
            0.9845902866729946}, {0.22820798342496987`, 0.9788446812271706}, {
            0.2542009957485324, 0.9723684066533329}, {0.2670129629143277, 
            0.9688065771932233}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2712521899306705, 0.9676280381383298}, {
            0.2800164900143422, 0.9651914925375414}, {0.3056373885808682, 
            0.9573492843794804}, {0.3310455278207122, 0.9488465611754943}, {
            0.3562227441064752, 0.9396881019219275}, {0.38115087381075813`, 
            0.9298786856151253}, {0.40581175330616204`, 0.9194230912514323}, {
            0.4301872189652879, 0.9083260978271934}, {0.4357313191924043, 
            0.905623678778136}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.43968646804469214`, 0.9036957789995566}, {
            0.4542591071607364, 0.8965924843387529}, {0.47800925426510904`, 
            0.8842270297824562}, {0.5014194966510063, 0.8712345131546476}, {
            0.5244716706910294, 0.8576197134516722}, {0.5471476127577793, 
            0.8433874096698749}, {0.569429159223857, 0.8285423808056}, {
            0.590597067442612, 0.8135847994646377}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.5941328219777012, 0.8109663817190952}, {
            0.6127364108443992, 0.7970332638149974}, {0.6337257887440666, 
            0.7803787336813587}, {0.6542632046103765, 0.7631600847839676}, {
            0.6743479969851457, 0.7454163049058508}, {0.6939656233794347, 
            0.7271592507233554}, {0.7131015413043028, 0.7084007789128293}, {
            0.7261571455624172, 0.694919062799437}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7292180629209993, 0.6917582425065494}, {
            0.7317412082708098, 0.6891527461506202}, {0.7498700817900154, 
            0.6694270091130761}, {0.767473619372979, 0.6492354244765447}, {
            0.7845372785307598, 0.6285898489173735}, {0.8010465167744182, 
            0.6075021391119106}, {0.8169867916150131, 0.5859841517365039}, {
            0.8323435605636044, 0.5640477434675008}, {0.8387765850099489, 
            0.554308898724879}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8412017051180214, 0.5506375512254692}, {
            0.8471022811312517, 0.5417047709812496}, {0.8612484108290144, 
            0.5189670909540977}, {0.8747674071679521, 0.4958465600623929}, {
            0.8876447276591245, 0.4723550349824832}, {0.8998658298135916, 
            0.4485043723907156}, {0.9114420553754369, 0.4243271095876313}, {
            0.9223888875660273, 0.39985909277364245`}, {0.9241321882181318, 
            0.39567515594069785`}}]}, {
           Arrowheads[{{0.01725551926285832, 1.}}], 
           
           ArrowBox[{{0.9258244906484561, 0.39161361528667027`}, {
            0.9326979961123493, 0.3751171419749024}, {0.9423610507413878, 
            0.3501180772175651}, {0.9513697211801284, 0.3248787185277847}, {
            0.9597156771555564, 0.2994158859317152}, {0.9673905883946573, 
            0.2737463994555106}, {0.9743861246244166, 
            0.2478870791253251}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.09131837091988737, 
            0.6978465015790559}, {-0.054796910701256814`, 
            0.7001304564672279}, {-0.018271684218558508`, 
            0.7004793273239999}, {0.018156382482784415`, 
            0.6989182712418377}, {0.05438636335734933, 0.6954724453132075}, {
            0.08408963110612158, 0.6910865667774925}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.08844243611468726, 0.6904438471205614}, {
            0.09031733235971272, 0.6901670066305756}, {0.1258103905485283, 
            0.6829522021088786}, {0.16074044730824025`, 0.6738055187276091}, {
            0.1950272890821107, 0.6627929736760678}, {0.22859070231340267`, 
            0.6499805841435551}, {0.2558633697267403, 0.6378707885051775}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.2598847635985745, 0.6360851817938399}, {
            0.2613504734453793, 0.6354343673193714}, {0.29322638892130276`, 
            0.6192203403928173}, {0.324138235184436, 0.6014045205531933}, {
            0.35400579867804205`, 0.5820529249897993}, {0.38268061537240455`, 
            0.5611798571599701}, {0.4073793287285264, 0.5409923424837209}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.4107513610523125, 0.5381675707461049}, {
            0.43603808530966, 0.5150628547327993}, {0.4606347665005105, 
            0.49000736949438517`}, {0.48378609713814735`, 
            0.4637461944787037}, {0.505449091196549, 0.43637355436521924`}, {
            0.525580762649694, 0.40798367383339523`}, {0.5266058419272945, 
            0.4063644759537191}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5289593947415976, 0.4026468437569726}, {
            0.5441381254715613, 0.3786707775626955}, {0.558130432893897, 
            0.35394947113554925`}, {0.5709281541007449, 
            0.32869868716403866`}, {0.582527867735621, 0.3029764404370956}, {
            0.5929261524420407, 0.27684074574365086`}, {0.6021195868635199, 
            0.2503496178726365}, {0.6039826304267519, 
            0.24409949748660575`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6052395364107986, 0.2398828415429381}, {
            0.6101047496435738, 0.22356107161298416`}, {0.6168782194257184, 
            0.19653312175362497`}, {0.6224365748534693, 0.1693237830834907}, {
            0.6267337995438094, 0.14199680501035755`}, {0.6297393662142792, 
            0.11461385162605826`}, {0.6314730871592301, 
            0.08722980974560907}, {0.6318375876617293, 
            0.06654858545277413}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6319151243274291, 0.06214926868019772}, {
            0.631954774673014, 0.05989956618402624}, {0.6312042410499824, 
            0.03267800775632606}, {0.6292412985844869, 
            0.005620021277524773}, {
            0.626085759570879, -0.02121950643736105}, {
            0.6217574363035105, -0.04778568857331571}, {
            0.6162429375211311, -0.07400198384323377}, {
            0.6095409459827092, -0.0997997253134967}, {
            0.6059876606650664, -0.11126578110713406`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6046852246846435, -0.11546859689145056`}, {
            0.6016893850129249, -0.12513583769931907`}, {
            0.5927261779364581, -0.14996724571591458`}, {
            0.5826892480779887, -0.17425087407849732`}, {
            0.5716165187621968, -0.1979436475022813}, {
            0.5595459133137624, -0.2210024907024805}, {
            0.5465153550573653, -0.24338432839430899`}, {
            0.5325160763100049, -0.2650159588725463}, {
            0.5270548928086232, -0.2726161562177019}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5244873463011376, -0.27618934875825984`}, {
            0.5175562879369277, -0.2858351354939481}, {
            0.5016993810851852, -0.30581521556669267`}, {
            0.48500874690182855`, -0.3249295563989585}, {
            0.46754777653390933`, -0.34315151529892374`}, {
            0.4493798611284786, -0.36045444957476663`}, {
            0.430568391832588, -0.3768117165346655}, {
            0.4111767597932887, -0.3921966734867985}, {
            0.4003368826110622, -0.39978180186987994`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3967318269781437, -0.4023044143814565}, {
            0.37840127672954893`, -0.4151310889489592}, {
            0.34433078939277073`, -0.4352701529115129}, {
            0.309207206420558, -0.4525497979545886}, {
            0.2732724364505141, -0.4669059566583156}, {
            0.23871290613883356`, -0.4777120155132476}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.23446548655203342`, -0.478848043557315}, {
            0.19995860561785406`, -0.4867666401970522}, {
            0.16301315625451815`, -0.49225902459704785`}, {
            0.12624527325213852`, -0.4948244169612203}, {
            0.0960988695649791, -0.49482834718383767`}, {
            0.0664906395926161, -0.49296137508991666`}, {
            0.059970300502707734`, -0.49212297944266564`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.05560622870713234, -0.49156184009895204`}, {
            0.03742058333504953, -0.48922350067945736`}, {
            0.008888700792279387, -0.4836147239524597}, \
{-0.018879342418054796`, -0.4762798628277807}, {-0.04565788067831349, \
-0.4673637352242773}, {-0.07144691398849669, -0.4568663411419497}, \
{-0.09624644234860441, -0.44478768058079765`}, {-0.11033305037496147`, \
-0.4367587195128598}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.11415571770530764`, -0.4345799091765744}, \
{-0.12023887553806076`, -0.4311126843259993}, {-0.14286610219449528`, \
-0.4162183865165896}, {-0.164128122317908, -0.40010478715256886`}, \
{-0.1840249359082989, -0.3827718862339369}, {-0.2024587710776477, \
-0.3644609510768806}, {-0.21933185593793408`, -0.34541324899758696`}, \
{-0.23464419048915805`, -0.32562877999605605`}, {-0.24154489100581922`, \
-0.3153309916941452}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.243994290544637, -0.31167579786901917`}, \
{-0.24839577473131966`, -0.30510754407228774`}, {-0.2551668913193483, \
-0.29420292852110536`}, {-0.2614987893016027, -0.28316971970638527`}, \
{-0.27298639260986857`, -0.2564080642697511}, {-0.2820548420583647, \
-0.22952460560932442`}, {-0.2899580840965607, -0.20270113552991276`}, \
{-0.29553091131415665`, -0.17599764261253112`}, {-0.2988560017899856, \
-0.14960723184276176`}, {-0.2989992824189337, -0.14641015758905998`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2991962758444128, -0.1420145696203898}, \
{-0.30001603360288054`, -0.1237230082061869}, {-0.2991260800888865, \
-0.09850806267685794}, {-0.29630121458404857`, -0.07412548622882628}, \
{-0.29063572187547076`, -0.04664689497809806}, {-0.28270099080058503`, \
-0.020587327583749784`}, {-0.2727508341544089, 
            0.0037863729800620303`}, {-0.26103906473196004`, 
            0.02620736373918086}, {-0.2604616365214175, 
            0.02701688060931251}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2579065275655633, 
            0.030598977512484415`}, {-0.23328836610334036`, 
            0.06511204190982411}, {-0.20136425200491892`, 
            0.0959683590611491}, {-0.16711706929082823`, 
            0.11865408879658446`}, {-0.1323033682616534, 
            0.13357722517157372`}, {-0.12230715572804637`, 
            0.13584834036756205`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.11801650148360757`, 
            0.13682316658524357`}, {-0.09837492885163568, 
            0.14128568415653453`}, {-0.06643186235189878, 
            0.1427324138628661}, {-0.03118698661790844, 
            0.13731503962129657`}, {-0.0012892059077243842`, 
            0.12576526042048655`}, {0.022569450896339667`, 
            0.10986627258762775`}, {0.04040204213827968, 
            0.09140925749687362}, {0.0411997954125808, 
            0.08975458263751515}}]}, {
           Arrowheads[{{0.014181910318999034`, 1.}}], 
           
           ArrowBox[{{0.04311064110531002, 0.085791166341114}, {
            0.059087445609010115`, 0.05265257876425022}, {0.05970503201609725,
             0.018555878036412583`}, {
            0.046665443578427265`, -0.009084112456803836}, {
            0.02786481888842027, -0.022928767661378212`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.1, 0.8504411073411725}, {-1.093116200446292, 
            0.8503915197900499}, {-1.0636504332402075`, 
            0.8513981340718975}, {-1.0360385489701576`, 
            0.8532472682393668}, {-1.0102805476361427`, 
            0.8559389222924587}, {-0.9863764292381626, 
            0.8594730962311725}, {-0.940172224955491, 
            0.8674269747970925}, {-0.9255449926109937, 
            0.8708097213257434}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.921258136168543, 
            0.8718011152140739}, {-0.8982526367096783, 
            0.8771214500253023}, {-0.8702170850430082, 
            0.885607859847882}, {-0.8431936130957719, 
            0.8943275100406742}, {-0.8167525000870108, 
            0.903072089972133}, {-0.7910369862770449, 
            0.9119110365194403}, {-0.7651777462228688, 
            0.9206721107926978}, {-0.7534881017299668, 
            0.9246725822140958}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.7493251310068095, 
            0.9260972487568824}, {-0.7397566528790677, 
            0.9293718071337043}, {-0.7147737062456417, 
            0.9380101255424602}, {-0.6902289063225905, 
            0.9465870660189648}, {-0.6659986619083648, 
            0.9550292114766087}, {-0.6419593818014144, 
            0.9632631448287815}, {-0.6181110660017402, 
            0.9712888660754838}, {-0.5944537145093414, 
            0.9791063752167152}, {-0.5827406959913447, 
            0.9828772516223804}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5785523934716239, 
            0.9842256291671727}, {-0.5709344518324047, 
            0.9866781409892047}, {-0.5475004024791162, 
            0.9939666321296815}, {-0.5241515664494761, 
            1.0009718486381454`}, {-0.5008879437434842, 
            1.0076937905145964`}, {-0.4776501990983926, 
            1.0141111674998984`}, {-0.45444425862166804`, 
            1.020184195756028}, {-0.4312701223133103, 
            1.0259128752829856`}, {-0.40896916701474223`, 
            1.0311014500432027`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           ArrowBox[{{-0.4046676652644787, 
            1.032026519591639}, {-0.3619385383984389, 
            1.0410328214888251`}, {-0.3158765032970259, 
            1.0493910419801906`}, {-0.2699294991185749, 
            1.0562769771544631`}, {-0.23113205249687246`, 
            1.0607781893174109`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.22676136938693184`, 
            1.061285268357088}, {-0.2240853401125803, 
            1.0615957366112379`}, {-0.17834402627904208`, 
            1.0653473203505153`}, {-0.13270555761796005`, 
            1.0675317283722952`}, {-0.08724105795767165, 
            1.0681106307600368`}, {-0.050998889846004966`, 
            1.0672571147716614`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.046600109501161766`, 
            1.0671535219252812`}, {-0.04202165112651431, 
            1.0670456975971994`}, {0.0029526628755120804`, 
            1.0643369288837827`}, {0.04768188404840766, 
            1.0599843246197869`}, {0.07910377415253095, 
            1.0559161844223621`}, {0.1102755720003567, 1.0510308620453317`}, {
            0.12816148767154026`, 1.0477323856623704`}}]}, {
           Arrowheads[{{0.018777447592304094`, 1.}}], 
           
           ArrowBox[{{0.13248852203057987`, 1.0469344046753222`}, {
            0.14119727759188513`, 1.0453283574886953`}, {0.17186889092711607`,
             1.0388086707524529`}, {0.20229041200604966`, 
            1.0314718018366047`}, {0.23246184082868576`, 
            1.0233177507411506`}, {0.26238317739502437`, 
            1.0143465174660906`}, {0.29205442170506546`, 
            1.0045581020114247`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.0655018631672513`, -0.8844241499364109}, {
            1.0176533962286591`, -0.8849232134269476}, {
            0.9735399881383378, -0.8874697616108153}, {
            0.9340481390786374, -0.8922805484953276}, {
            0.8905283027812434, -0.8998795866343934}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8862613502847135, -0.9009521877545392}, {
            0.8634566069655593, -0.9067298094967746}, {
            0.8374999320387125, -0.9138672547156466}, {
            0.8121443521710183, -0.9210994479177343}, {
            0.7875254521022694, -0.9284967850048645}, {
            0.7627700809761877, -0.9358166926426559}, {
            0.7384784475343857, -0.9431468852668117}, {
            0.7171733405631047, -0.9497101866302171}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.7129714771765426, -0.951015628382587}, {
            0.6912863937036208, -0.957838125474217}, {
            0.6682634009068238, -0.9651237190936413}, {
            0.6454590009786383, -0.9722686897717798}, {
            0.6228731939190643, -0.9792730375086325}, {
            0.6005059797281018, -0.9861367623041996}, {
            0.5562087487394557, -0.9992895570934897}, {
            0.5446833538119256, -1.0025176990523585`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5404464105846957, -1.0037044223095803`}, {
            0.512348726800144, -1.0115742881616634`}, {
            0.46910848926758547`, -1.0227951238162898`}, {
            0.42605482296133085`, -1.032923447940647}, {
            0.3831877278813801, -1.0419592605347354`}, {
            0.36931538693846927`, -1.0445410512584703`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.36498966463852933`, -1.045346114351527}, {
            0.3405072040277333, -1.0499025615985549`}, {
            0.2979737283156528, -1.0566597022675128`}, {
            0.2555477776604008, -1.062137033677017}, {
            0.21322935206197746`, -1.066334555827067}, {
            0.19055732567327133`, -1.0679016975558977`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.18616779950745255`, -1.0682051115298545`}, {
            0.17101845152038267`, -1.0692522687176629`}, {
            0.1289551020078279, -1.0708486876011716`}, {
            0.08707932949652451, -1.0710823277299597`}, {
            0.045391133986472654`, -1.0699531891040275`}, {
            0.010313349671757926`, -1.0678469327746165`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.005921260252909771, -1.0675832084169208`}, {
            0.0038905154776721212`, -1.0674612717233745`}, \
{-0.032416729468876825`, -1.0641362882752015`}, {-0.06841601495609703, \
-1.0597499159815797`}, {-0.10410734098398845`, -1.0543021548425096`}, \
{-0.139490707552551, -1.0477930048579907`}, {-0.16799345806427518`, \
-1.0416410825484965`}}]}, {
           Arrowheads[{{0.016531149628889002`, 1.}}], 
           
           ArrowBox[{{-0.17229441781190707`, -1.0407127802005247`}, \
{-0.1745661146617847, -1.0402224660280233`}, {-0.20933356231168948`, \
-1.0315905383526072`}, {-0.24379305050226538`, -1.0218972218317426`}, \
{-0.27794457923351257`, -1.0111425164654293`}, {-0.31167061448192085`, \
-0.9993588184567563}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.879023874591249, -1.1}, {-0.8781111452358012, \
-1.0681220885580092`}, {-0.8784824625528352, -1.0387039964253362`}, \
{-0.8797317140912639, -1.011099155938385}, {-0.8818588998510878, \
-0.9853075670971563}, {-0.8848640198323062, -0.9613292299016493}, \
{-0.89032829555289, -0.9247244086757941}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.8909779183527795, -0.9203726285552154}, \
{-0.8917353689446906, -0.9152985171958856}, {-0.9004023779768554, \
-0.873405071963462}, {-0.9081806802092848, -0.8452480113222077}, \
{-0.9162105268678871, -0.8180817376486846}, {-0.9242756245060377, \
-0.7914884456313063}, {-0.9324480709392784, -0.7656074037072682}, \
{-0.9370862870968709, -0.7506927823889477}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.9383928949319517, -0.7464912617159882}, \
{-0.9405400645194351, -0.7395868354849885}, {-0.948578501188514, \
-0.7139994647595658}, {-0.9565633809465148, -0.6888452915310002}, \
{-0.9644947037934379, -0.6641243157992914}, {-0.9722969766531812, \
-0.6397167998314546}, {-0.9798947064496426, -0.6155030058945046}, \
{-0.9872878931828223, -0.5914829339884411}, {-0.9911762838518702, \
-0.5785950846546287}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9924472208081245, -0.5743826365240012}, \
{-0.9944765368527202, -0.5676565841132644}, {-1.0014221449894603`, \
-0.5439727634487743}, {-1.0080862251231668`, -0.5203802791747708}, \
{-1.0144687772538394`, -0.496879131291254}, {-1.0205698013814783`, \
-0.4734693197982237}, {-1.026379937643594, -0.45003738513713154`}, \
{-1.031844912280219, -0.426645929651849}, {-1.0367858629950304`, \
-0.4041107271284522}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0376800558147572`, -0.39980261248466153`}, \
{-1.0417393766769973`, -0.3799844562087129}, {-1.0502531945718139`, \
-0.3334848994688153}, {-1.057386365964668, -0.28714725943215635`}, \
{-1.063043900620899, -0.24096282193807544`}, {-1.0643777058347736`, \
-0.22593720136961393`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0647667583973557`, -0.22155443533621125`}, \
{-1.0671308083058448`, -0.19492287282591206`}, {-1.0696470890195058`, \
-0.1490274120956662}, {-1.0705927427618822`, -0.10327643974733773`}, \
{-1.0699315316057143`, -0.05774290424394661}, {-1.0693211288707605`, \
-0.045758190861446}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0690973191555806`, -0.041363886683149845`}, \
{-1.0676272176237427`, -0.012499754048512824`}, {-1.0636798008159676`, 
            0.0324530108389638}, {-1.0580892811823885`, 
            0.07711539041848323}, {-1.0532138054725897`, 
            0.10807711925783933`}, {-1.048561232573259, 
            0.133269653060351}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0477621506831662`, 
            0.1375964842487527}, {-1.0475448578680806`, 
            0.13877307120559007`}, {-1.0410824383688617`, 
            0.1692032462617355}, {-1.0338265469749326`, 
            0.19936764442627564`}, {-1.0257771836862934`, 
            0.2292662656992105}, {-1.016934348502944, 
            0.25889911008053984`}, {-1.0072980414248849`, 
            0.28826617757026385`}, {-1.0005925986866597`, 
            0.3069757818891676}}]}, {
           Arrowheads[{{0.0007544230842079255, 1.}}], 
           
           ArrowBox[{{-0.9985737034919747, 
            0.3158763414302443}, {-0.9974026759430475, 
            0.3158763414302443}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.923588983634248, 1.0595397683884245`}, {
            0.9206687484350854, 1.0143521349495723`}, {0.9198275684284082, 
            0.9727649561850302}, {0.9213958085773192, 0.9355426969998263}, {
            0.9276514887675397, 0.8916469386318128}, {0.9290133600273139, 
            0.8842432857819065}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9298093669460731, 0.8799158878356473}, {
            0.935180811658675, 0.850714660723211}, {0.9430850072036667, 
            0.8108165568018258}, {0.9517389480563717, 0.7729868008548744}, {
            0.9608569393985997, 0.7367661645688848}, {0.968409868357121, 
            0.708272515971592}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.9695372591777663, 0.7040194006501453}, {
            0.9701532864121608, 0.7016954196303855}, {0.9794814407065533, 
            0.6675443127794582}, {0.9886948538912753, 0.6340825907561847}, {
            0.9976620362023253, 0.6012138749451081}, {1.0062893465740894`, 
            0.5687048895453959}, {1.0145767850065686`, 0.5365556345570481}, {
            1.0152030600083213`, 0.5340505929726562}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.0162702401826649`, 0.529781971828131}, {
            1.0225243514997617`, 0.5047661099800648}, {1.0300408254863846`, 
            0.4732291208646853}, {1.0370349863991524`, 0.4418374722611493}, {
            1.0435068342380651`, 0.4105911641694567}, {1.0494563690031222`, 
            0.37949019658960736`}, {1.053230505277346, 
            0.3577574162188371}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{1.0539833458444754`, 0.3534223001788118}, {
            1.0548376131429062`, 0.34850313398401256`}, {1.0596045891059989`, 
            0.3175985408150833}, {1.0637572968924005`, 
            0.28677641708281976`}, {1.0672957365021112`, 
            0.2560367627872216}, {1.0703459405850202`, 
            0.22347591970576247`}, {1.0726296274816125`, 
            0.19103134282206186`}, {1.073213996964635, 0.178579421277238}}]}, {
           Arrowheads[{{0.00906986786454653, 1.}}], 
           
           ArrowBox[{{1.0734202622314855`, 0.17418425863636894`}, {
            1.074146797191888, 0.1587030321361196}, {1.074897449715847, 
            0.12649098764793593`}, {1.0748815850534892`, 
            0.09439520935751067}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.5637468080826243, -0.3794421198655047}, {
            0.5415427518918804, -0.406961619963528}, {
            0.5179344881858452, -0.4331298079068358}, {
            0.4930160277373531, -0.4579030286859124}, {
            0.46688138131923757`, -0.48123762729124236`}, {
            0.4396245597043327, -0.50308994871331}, {
            0.4393911178200707, -0.5032577066395614}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.43581804398431084`, -0.505825418337593}, {
            0.41133957366547197`, -0.5234163379425996}, {
            0.38212043397548934`, -0.5421731399695957}, {
            0.35747909470458344`, -0.5563260663523419}, {
            0.33230042530794746`, -0.5692880387288157}, {
            0.30664238217192885`, -0.5810552331192635}, {
            0.2823868335171253, -0.5908846928919044}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2782704660197156, -0.5924358205961096}, {
            0.2541200002271365, -0.600989992023066}, {
            0.22737157419105772`, -0.6091499085769138}, {
            0.20037559996098797`, -0.6160997512257206}, {
            0.17319003392327484`, -0.6218356959897332}, {
            0.1458782450897131, -0.6263113370866156}, {
            0.11850163424466295`, -0.6294957530258796}, {
            0.10701324213739952`, -0.6302980708903345}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.10262393298222494`, -0.6306046082294967}, {
            0.09111520543331886, -0.631408346265544}, {
            0.06377396270087524, -0.6320685192636274}, {
            0.03653291009252735, -0.6314956744781484}, {
            0.00944705165346961, -0.6297092143671253}, \
{-0.017428608571103572`, -0.6267285413885771}, {-0.04403906653599691, \
-0.6225730580005224}, {-0.07030794027745463, -0.6172288423721939}, \
{-0.07219061176797918, -0.616753072138455}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.07645650459450293, -0.6156750376340845}, \
{-0.09616662162028872, -0.6106940905960193}, {-0.12157176720215558`, \
-0.6030063820148095}, {-0.1464800336607124, -0.5942032959713752}, \
{-0.17084807763361642`, -0.5843224118085272}, {-0.19463255575852403`, \
-0.5734013088690766}, {-0.21779012467309247`, -0.561477566495834}, \
{-0.23878175959411507`, -0.5494460269477286}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.24253390509105058`, -0.5471501267971439}, \
{-0.2620214636433519, -0.5347255871647706}, {-0.2829599506095582, \
-0.5198957738216609}, {-0.3030657573395209, -0.5041624817020619}, \
{-0.322311739259163, -0.48758886850575484`}, {-0.3406707517944076, \
-0.47023809193252086`}, {-0.3581156503711777, -0.4521733096821407}, \
{-0.3746192904153965, -0.4334576794543957}, {-0.37523076618001705`, \
-0.4326978897767017}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.37798943707774185`, -0.4292701011487308}, \
{-0.39015452735298684`, -0.41415435894906677`}, {-0.4133387875129437, \
-0.3815104950938421}, {-0.4337370090084575, -0.3475501855544443}, \
{-0.4512831774507684, -0.3125146603745061}, {-0.46554164102046053`, \
-0.27755153613423966`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4669557091055162, -0.27338733463662934`}, \
{-0.4775989472616871, -0.2401886724249043}, {-0.48632381913466627`, \
-0.2033922480572347}, {-0.4920924410657996, -0.1664421605578871}, \
{-0.4949310654032744, -0.12964636261057852`}, {-0.4951481226425497, \
-0.10062965586998943`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.4949780971974437, -0.0962346649327321}, \
{-0.4935046284138292, -0.06977179014255248}, {-0.4899740450702714, \
-0.040620378576592314`}, {-0.4845652184941567, -0.011992883456000622`}, \
{-0.47742112837418205`, 0.015883424503287714`}, {-0.468684754399044, 
            0.042781274585337835`}, {-0.4583560965687429, 
            0.06870066679014984}, {-0.4557523026407266, 
            0.07414831137013916}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.4538548481958297, 
            0.07811815603077026}, {-0.4464351548832784, 
            0.09364160111772366}, {-0.4329106132768785, 
            0.1177820030299304}, {-0.4181533983504695, 
            0.1405648429189409}, {-0.4021635101040517, 
            0.16199012078475525`}, {-0.3849409485376249, 
            0.1820578366273734}, {-0.36672642215344103`, 
            0.20066783942360894`}, {-0.3483145242859935, 
            0.21722198019535105`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.34488668605621997`, 
            0.21997842188813774`}, {-0.32804360043855724`, 
            0.23321425280737254`}, {-0.30757530510785747`, 
            0.2471506633949007}, {-0.2966942412781157, 
            0.2540192053970903}, {-0.2856806281691266, 
            0.2604485989538941}, {-0.25898197713490484`, 
            0.2721473440232592}, {-0.2321407810770797, 
            0.28142991419123614`}, {-0.20534936581854044`, 
            0.28954755046113007`}, {-0.18712166111558126`, 
            0.29349998238931935`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.18282159050330984`, 
            0.2944323947066338}, {-0.17865751215857306`, 
            0.2953353189348581}, {-0.15225867546458646`, 
            0.2988737965501145}, {-0.12634631110398953`, 
            0.3002435602445934}, {-0.10108435404013758`, 
            0.29955779640945723`}, {-0.07663673923638586, 
            0.29692969143586795`}, {-0.04901302527079206, 
            0.2914732476879398}, {-0.02279229951006554, 
            0.28372642129214565`}, {-0.009975759856147954, 
            0.2786173777120135}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.005888532912187614, 0.2769880907794677}, {
            0.0017551528111776642`, 0.2739410964636837}, {0.02435904645832143,
             0.2623691574177523}, {0.04496601875000979, 
            0.24925234888869807`}, {0.0636466627496069, 
            0.23482662162180928`}, {0.08031662683957677, 
            0.21933516884869714`}, {0.09489155940238335, 
            0.2030211838009727}, {0.11795263623912064`, 0.1688097368944463}, {
            0.12134653052411608`, 0.16106412033331685`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.12311239838325141`, 0.15703401975094017`}, {
            0.13322250584504636`, 0.133960520927749}, {0.14123767546103347`, 
            0.09993723746236792}, {0.14294540336497924`, 
            0.06785472313891615}, {0.13776129675717563`, 
            0.03231894307479633}, {0.12634578280199366`, 
            0.0021302926806481106`}, {
            0.11781385232681689`, -0.010857274217357642`}}]}, {
           Arrowheads[{{0.008870452386837802, 1.}}], 
           
           ArrowBox[{{0.11539801473208443`, -0.014534736483088902`}, {
            0.11049647091139854`, -0.02199601719322571}, {
            0.09202579062465936, -0.04005957319382828}, {
            0.05312417278267359, -0.05906849740491255}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.6298100782766074, -1.0691120894280366`}, \
{-0.647592231107495, -1.0400875080527077`}, {-0.6653754036155815, \
-1.012651276748287}, {-0.6862394689638357, -0.9813944429738599}, \
{-0.7068528334576618, -0.9511971981976794}, {-0.726693259497142, \
-0.922214360090084}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7291787273164149, -0.918583595746401}, \
{-0.7296904993984239, -0.9178360005399604}, {-0.752004674105719, \
-0.8850797170581657}, {-0.773644607042304, -0.8524222146082878}, \
{-0.79466054838726, -0.8200322042383295}, {-0.815793604157293, \
-0.7871785160203618}, {-0.8255794939284046, -0.771350767034501}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8278933614547329, -0.7676083056692224}, \
{-0.8361393760363236, -0.7542711588196378}, {-0.8556978640243523, \
-0.7213101326361574}, {-0.8744690681213786, -0.6882954374699208}, \
{-0.8923971558140015, -0.6551566721114459}, {-0.9094262945888194, \
-0.6218234353512505}, {-0.9132872768185034, -0.6137981184416107}}]}, {
           Arrowheads[{{0.015265088094359714`, 1.}}], 
           
           ArrowBox[{{-0.9151948384448513, -0.6098331205044504}, \
{-0.9255564844458324, -0.5882957271893346}, {-0.9407877253850406, \
-0.5545735476256984}, {-0.9550804395901209, -0.5206549150899648}, \
{-0.9683950492447502, -0.4865378480117568}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.45804298571933283`, -0.5570065227685995}, \
{-0.48577809613177336`, -0.5316474435539532}, {-0.5121397121123544, \
-0.504920793838867}, {-0.537063887964561, -0.4769096472603323}, \
{-0.560411561208352, -0.4476619377955252}, {-0.5754679898302707, \
-0.4265131677229742}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5780198418428399, -0.4229287498754086}, \
{-0.5820709845576962, -0.4172383774797357}, {-0.6020191851070932, \
-0.3857412070371266}, {-0.620233189951043, -0.35327266719185907`}, \
{-0.636690026184046, -0.31993499866809477`}, {-0.6513667209006019, \
-0.2858304421899952}, {-0.6583795138467623, -0.26689016132569726`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6599072897344677, -0.2627639159576967}, \
{-0.6642403011952113, -0.2510612384817218}, {-0.6752877941623733, \
-0.21572962826743708`}, {-0.6844024511787571, -0.1799385059745668}, \
{-0.6915079875184245, -0.14379052832025832`}, {-0.6966271261219651, \
-0.10738757946325769`}, {-0.69800036189965, -0.09147864833808311}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6983787564229368, -0.0870949492625595}, \
{-0.699782589929969, -0.07083154356230888}, {-0.7009971018830262, \
-0.0342243047761563}, {-0.7002933849217263, 
            0.002332252736455047}, {-0.6976941619866596, 
            0.03873624481678018}, {-0.6932221560184157, 
            0.07488578730607504}, {-0.6908331017242811, 
            0.08823736721472648}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.6900581002711026, 
            0.09256857637009766}, {-0.6868240079466863, 
            0.11064277510530877`}, {-0.6784740248869442, 
            0.1458822743664636}, {-0.668236429058451, 
            0.18052215780731495`}, {-0.6561754426804685, 
            0.2144802981456374}, {-0.6423552879722585, 
            0.24767456809920566`}, {-0.6365993979411125, 
            0.2596753343300667}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6346965844215392, 
            0.263642613083788}, {-0.6268401871530822, 
            0.280022840385795}, {-0.6096943624422019, 
            0.31144298772318024`}, {-0.5909820360588789, 
            0.34185288282913573`}, {-0.5707138668978844, 
            0.3711032729466118}, {-0.5489199914265316, 
            0.3990693145821305}, {-0.5388700262373944, 
            0.4105948045044082}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.5359782876981822, 
            0.4139111048859833}, {-0.5256938482228954, 
            0.42570549434882576`}, {-0.5011288758650503, 
            0.45096629885983214`}, {-0.4753185129310708, 
            0.47480621472828355`}, {-0.4483561979990322, 
            0.49717972856731407`}, {-0.42033536964700846`, 
            0.518041326990058}, {-0.40368075042436924`, 
            0.5291330494826253}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.40001857694626536`, 
            0.531572001187}, {-0.3913494664530746, 
            0.5373454966096494}, {-0.36690369492430897`, 
            0.5519398525735911}, {-0.34189874116019414`, 
            0.5653522960716628}, {-0.3163924365023291, 
            0.5775778878459567}, {-0.29044261229231294`, 
            0.5886116886385642}, {-0.2641070998717444, 
            0.5984487591915779}, {-0.24113908827715225`, 
            0.6058873536697663}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.23694662262916327`, 
            0.6072212729935185}, {-0.2105103357653445, 
            0.6145129525471911}, {-0.1833647467627113, 
            0.6207301968339745}, {-0.15606930931512122`, 
            0.6256883940153906}, {-0.1286847275636645, 
            0.6293555213027143}, {-0.10126637045037586`, 
            0.6317498538930237}, {-0.07386960691729029, 
            0.6328896669833968}, {-0.0634558956802228, 
            0.6328529095121157}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.059055923089577696`, 
            0.6328373788465868}, {-0.04654980590644321, 
            0.6327932357709115}, {-0.019362336359869746`, 
            0.631478835452646}, {0.007637432780394913, 0.6289647412256781}, {
            0.034394132572315356`, 0.6252692282870862}, {0.06083178180682315, 
            0.6203768988652114}, {0.08688189464468027, 0.6142845999042995}, {
            0.11250034519859686`, 0.6070289736752849}, {0.11428543753185512`, 
            0.6064338418122747}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.11845957312663866`, 0.6050422269099539}, {
            0.13764300758128334`, 0.5986466624491016}, {0.16226575590545014`, 
            0.5891743084966844}, {0.18632446428380753`, 0.5786485540889672}, {
            0.20977500682906608`, 0.5671060414968845}, {0.23257325765393635`, 
            0.5545834129913705}, {0.254646611628387, 0.5410698302334416}, {
            0.275397042825148, 0.5269366400433513}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.2789294911863138, 0.5243143732566867}, {
            0.2964032901458595, 0.5111516247578245}, {0.3160294311791114, 
            0.4948720836110062}, {0.3347826510555271, 0.4777956379054283}, {
            0.3526343580202213, 0.45998482842652566`}, {0.3695559603183092, 
            0.4415021959597335}, {0.38551886619490566`, 0.4224102812904866}, {
            0.4022175799839247, 0.3998117458496463}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4048324397102385, 0.3962730301770184}, {
            0.40939413468728225`, 0.3900996429981319}, {0.43051011483217044`, 
            0.35641329853281034`}, {0.4487953259396966, 0.3215902303372537}, {
            0.4641782873199874, 0.28586942085419353`}, {0.47663069904555266`, 
            0.24949673403050307`}, {0.47960423049853684`, 
            0.23797707257518033`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.48070394190628596`, 0.2337167163905795}, {
            0.4861242611889023, 0.21271803381305554`}, {0.49266085144583216`, 
            0.17571936341390568`}, {0.49625890762409053`, 
            0.138808706148478}, {0.4971020317136314, 0.10839773886201635`}, {
            0.49604163529222567`, 0.07847094555481539}, {0.49410976876764146`,
             0.059280390632418065`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.49366905890013324`, 0.05490251731165136}, {
            0.49307771835987374`, 0.049028326226875196`}, {0.4882102809165753,
             0.020069880878195633`}, {
            0.4815771631770559, -0.008171859872715879}, {
            0.4733162053560406, -0.03546436540735197}, {
            0.4634274074535296, -0.061807635725712726`}, {
            0.4519107694695227, -0.08720167082779809}, {
            0.43910338074959804`, -0.11117982731584164`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.43682401861534786`, -0.11494201996988124`}, {
            0.4243814576877214, -0.13502602080337503`}, {
            0.408709710587725, -0.1569341083570675}, {
            0.39176656934833143`, -0.17750613762136264`}, {
            0.37379087684809637`, -0.19663494169285073`}, {
            0.35502147596557526`, -0.214213353668122}, {
            0.3354583667007684, -0.23024137354717653`}, {
            0.3179122393788089, -0.242720057828847}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.31430794222599384`, -0.2452429733512202}, {
            0.30426144826146606`, -0.2518760838097122}, {
            0.29327702494716323`, -0.25859349025338313`}, {
            0.2667136591282449, -0.2708987350159333}, {
            0.23994752208600195`, -0.2807951241189151}, {
            0.21320154909966949`, -0.28952666754607814`}, {
            0.18649590422515816`, -0.29592851962160366`}, {
            0.1600250596924405, -0.30007497161007674`}, {
            0.14917342585762197`, -0.30089393846926776`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.14478590298795158`, -0.3012250624160299}, {
            0.133983487731489, -0.30204031477608245`}, {
            0.10853767664413531`, -0.3019320900615544}, {
            0.0838541147322109, -0.2998578384084259}, {
            0.05574419938815204, -0.29498758997749547`}, {
            0.028991692151976445`, -0.2877606026237439}, {
            0.0038775396989002278`, -0.2784229658303969}, \
{-0.019317311295860524`, -0.26722076908067965`}, {-0.02458724393090605, \
-0.2640352535721507}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.028352766885019004`, -0.2617591083917968}, \
{-0.04053113951983549, -0.2543976490367251}, {-0.059827495296409045`, \
-0.24019584074861278`}, {-0.07711333940414716, -0.22485933128148866`}, \
{-0.09229563262161575, -0.20863210770049873`}, {-0.11652246751869888`, \
-0.17440887559116103`}, {-0.13285380225356705`, -0.13933285920907948`}, \
{-0.13583364553543356`, -0.12785584269908784`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.13693938120125565`, -0.12359704608063692`}, \
{-0.14179201004009406`, -0.10490690165622116`}, {-0.14426856404946398`, \
-0.0722936789148686}, {-0.13975496917988733`, -0.03576597287515155}, \
{-0.12869453518410046`, -0.004597314759809392}, {-0.11293110850813783`, 
            0.020423960933162327`}, {-0.09569848462313052, 
            0.037883829345821525`}}]}, {
           Arrowheads[{{0.012276959467954752`, 1.}}], 
           
           ArrowBox[{{-0.0921400215598342, 
            0.04037543587933863}, {-0.05484417597607792, 
            0.05932694126585351}, {-0.01980061473549064, 
            0.06055952009965514}, {0.008555964835029567, 
            0.04769723247463499}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.0893407133284403`, 
            0.6071790872302381}, {-1.0610372176278373`, 
            0.6247496763801694}, {-1.0343713861276465`, 
            0.6423322302015613}, {-1.0029741617465766`, 
            0.663697619959726}, {-0.9727688684562412, 
            0.6848282186306501}, {-0.9434625139174109, 
            0.7055728319195131}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.9398711940171629, 
            0.7081149612187588}, {-0.9398307510992576, 
            0.708143588890314}, {-0.9075552132349476, 
            0.7309537239063155}, {-0.8754068913772477, 
            0.7531146145200484}, {-0.8435642400215126, 
            0.7746742637843812}, {-0.8116551134819997, 
            0.7960939310898925}, {-0.7944505084180756, 
            0.8072320371003645}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7907569593728434, 
            0.8096232074101636}, {-0.7797121997630541, 
            0.8167734850792492}, {-0.7477354988646756, 
            0.836712925752451}, {-0.7157250107868643, 
            0.8559122531094984}, {-0.6836020954210348, 
            0.8743175601074245}, {-0.6512881126586014, 
            0.8918749397032628}, {-0.6388066290992351, 
            0.8982911350889615}}]}, {
           Arrowheads[{{0.018450145007449827`, 1.}}], 
           
           ArrowBox[{{-0.634893398996675, 
            0.9003027588520984}, {-0.6187830624995642, 
            0.9085843918970137}, {-0.5860869449439231, 
            0.9244459166886766}, {-0.5531916206654054, 
            0.9394208311425036}, {-0.5200889503377383, 
            0.9534704523227463}, {-0.48677893396092187`, 
            0.9665947802294047}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.058942725890494, -0.6860614039696}, {
            1.0212878907578455`, -0.7042195841843281}, {
            0.9861556232054757, -0.7226505034786926}, {
            0.9506214507303541, -0.7430513283653659}, {
            0.9163437486609063, -0.7632208708624002}, {
            0.9044441126992079, -0.7701633114360039}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9006436226371605, -0.7723805789634527}, {
            0.8825559374978047, -0.7829332277670139}, {
            0.8495135437408255, -0.8022637001468013}, {
            0.820088751551168, -0.8192906422122399}, {
            0.790874345636301, -0.835868082483771}, {
            0.7618703259962251, -0.8519960209613949}, {
            0.7478140571589116, -0.8596498074140908}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{0.7439497841418012, -0.8617539447787209}, {
            0.7330766926309396, -0.8676744576451112}, {
            0.7043801618025572, -0.8828460160349745}, {
            0.6756674497731903, -0.8974533196310387}, {
            0.6469385565428388, -0.9114963684333044}, {
            0.6181934821115026, -0.924975162441771}, {
            0.5893973728473487, -0.9378550592050883}, {
            0.5860154606612588, -0.9392890356421881}}]}, {
           Arrowheads[{{0.013619456252555699`, 1.}}], 
           
           ArrowBox[{{0.5819645674912889, -0.9410066690505415}, {
            0.560515375118544, -0.9501014162719055}, {
            0.5315474889250884, -0.9617142336422224}, {
            0.502493714266982, -0.9726935113160392}, {
            0.47015970681587715`, -0.9840957131083435}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.691706532062056, -0.37421604189554736`}, \
{-0.7101277770749634, -0.3394648826799693}, {-0.7268466542785665, \
-0.3038162634357965}, {-0.7418305467098183, -0.26735938987867686`}, \
{-0.7550468374056714, -0.23018346772425818`}, {-0.7603705894904635, \
-0.21254689780995056`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7616421012489868, -0.20833462314559908`}, \
{-0.7658133600367273, -0.19451604255263605`}, {-0.7748605812869914, \
-0.1583452813878181}, {-0.7821886222394211, -0.12175153100513945`}, \
{-0.787797603976974, -0.08481513817993516}, {-0.7916876475826076, \
-0.047616449687539704`}, {-0.7923950170735239, -0.0354381155770922}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7926501577732566, -0.03104551916684235}, \
{-0.7938588741392794, -0.01023581230328771}, {-0.794311404729947, 
            0.027246427197486024`}, {-0.793045360437568, 
            0.06474992203944713}, {-0.7900022762955248, 
            0.10218600082413136`}, {-0.7851449913552268, 
            0.13946901928875777`}, {-0.7842652925314871, 
            0.14437856708385635`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.7834892543984838, 
            0.14870959061370756`}, {-0.7785055827266727, 
            0.17652317136151696`}, {-0.7701161275198611, 
            0.21327265097059922`}, {-0.7600087028447908, 
            0.24964165204419483`}, {-0.7482153858114604, 
            0.2855543685104945}, {-0.7359578124832469, 
            0.31780515670109444`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7343500630883222, 
            0.321900005111656}, {-0.7196993831100135, 
            0.35570772333396516`}, {-0.7030008577942575, 
            0.389767850272003}, {-0.6846793040495572, 
            0.4230211785919377}, {-0.6647886138228042, 
            0.4554076654631486}, {-0.6505855837202171, 
            0.4762813945292905}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6481103597918938, 
            0.47991915022541076`}, {-0.6433826790608901, 
            0.48686726805501496`}, {-0.6205153917107064, 
            0.5173399435369169}, {-0.5962406437191445, 
            0.5467656490782339}, {-0.5706123270330962, 
            0.5750843418483458}, {-0.5436843335994523, 
            0.6022359790166323}, {-0.5326866068686422, 
            0.6123142231810532}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5294426871285958, 
            0.6152869298130869}, {-0.5154316322171547, 
            0.628126568026957}, {-0.48585789101167165`, 
            0.6526744616779163}, {-0.45506005091968593`, 
            0.67583813517099}, {-0.42313505287788006`, 
            0.697576063707657}, {-0.3901798378229367, 
            0.7178467224893971}, {-0.38780787400055833`, 
            0.7191599253409885}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{-0.3839584480353699, 
            0.7212911033576105}, {-0.35629134669153845`, 
            0.7366085867176888}, {-0.32156652042036826`, 
            0.7538201315940117}, {-0.28610229994610853`, 
            0.7694398323198453}, {-0.24515148716618282`, 
            0.7851264295564068}, {-0.22325327713607077`, 
            0.7922099550768379}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2190668546592693, 
            0.7935641584757893}, {-0.20346042434794298`, 
            0.7986124499681577}, {-0.16102911149138893`, 
            0.8098978935550987}, {-0.11785754859652058`, 
            0.8189827603172294}, {-0.07417981578921351, 
            0.8258039314921911}, {-0.04695513546585539, 
            0.8285879570151657}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.0425779627147859, 
            0.8290355714779513}, {-0.030229993195343315`, 
            0.8302982883176251}, {0.013991919185089984`, 
            0.8324658307935314}, {0.058485921352086384`, 0.83230655891991}, {
            0.10300780228820866`, 0.8298064741760868}, {0.13305427815357515`, 
            0.8265140531620068}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.13742809772954923`, 0.8260347804663251}, {
            0.1473133509760196, 0.8249515780413879}, {0.19140256741551917`, 
            0.8177418705158129}, {0.23527545160670738`, 0.8081773515993621}, {
            0.26522521166262747`, 0.8000463629109773}, {0.294905002665056, 
            0.7908117784667901}, {0.30845168705565784`, 
            0.7860466915061938}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3126023900138218, 0.7845866692621547}, {
            0.3242610909701386, 0.7804856861505249}, {0.3532666097558694, 
            0.769074129904074}, {0.38594149191577964`, 0.7549048386629292}, {
            0.4180736931641433, 0.7392820669522239}, {0.4496009508940664, 
            0.7222566847690398}, {0.47133616347468016`, 
            0.7093133924919506}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.47511661897420177`, 0.707062135905922}, {
            0.4804610024986552, 0.7038795621104599}, {0.5105915853710159, 
            0.6842015689735663}, {0.5399304369042545, 0.6632735753554417}, {
            0.5684152944914773, 0.6411464512531683}, {0.5959838955257903, 
            0.6178710666638286}, {0.6147754888414639, 0.6004786868088995}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.6180046562716955, 0.5974899617115492}, {
            0.6279224311968172, 0.5883106597803215}, {0.658321493438675, 
            0.55718055783775}, {0.6871810822513639, 0.5244807608361145}, {
            0.7145011976348837, 0.49021126877541465`}, {0.7328994886612012, 
            0.4645995465552788}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.735466554827709, 0.46102600891076295`}, {
            0.7401308465217045, 0.4545329850179774}, {0.7639190358442953, 
            0.4176068129261291}, {0.7858657656026568, 0.3794327524998701}, {
            0.8059710357967884, 0.34001080373920006`}, {0.8206129241465923, 
            0.30734830291169535`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.822412778070933, 0.3033332654459878}, {
            0.8241164953215643, 0.2995326855768398}, {0.8401837930718583, 
            0.25819011694550986`}, {0.8541729290476704, 
            0.21598309784521025`}, {0.8660839032490006, 
            0.17291162827594095`}, {0.8720208563351682, 0.1491550122327968}, {
            0.8750038288788501, 0.13564048205977092`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8759521850026414, 0.13134389961991624`}, {
            0.8773077413842727, 0.12520247278727692`}, {0.8810195418411633, 
            0.10000961733416588`}, {0.8840088311207983, 
            0.07468523910591462}, {0.8862682229437814, 0.04929292232074202}, {
            0.8878001794032448, 0.023811472239241814`}, {
            0.8899615240917979, -0.0193851954671577}, {
            0.889989378180231, -0.04386010424508837}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8899943856722242, -0.04826010139565835}, {
            0.8900107399652115, -0.0626303375622816}, {
            0.8879478270234863, -0.10592395404612993`}, {
            0.8837727852666214, -0.14926604491870266`}, {
            0.87748857073522, -0.1924489673420791}, {
            0.8715065797602424, -0.22297488219688671`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8706604305017787, -0.22729275568187923`}, {
            0.8690981394698846, -0.23526507847833886`}, {
            0.8586014914706149, -0.27771437832748175`}, {
            0.8459986267374111, -0.3197968668895078}, {
            0.8313349306269753, -0.3613073011180596}, {
            0.8176194197528025, -0.3948027757054828}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8159521006301607, -0.3988746360841393}, {
            0.8146557884960095, -0.4020404379667795}, {
            0.7959612003445136, -0.44199627743566766`}, {
            0.7752511661724877, -0.48117481952472396`}, {
            0.7542250587654904, -0.5168641965182844}, {
            0.73157215596062, -0.5517067672737883}, {
            0.730892162385001, -0.5526575356079221}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7283325380098248, -0.5562364073656139}, {
            0.7073304261227558, -0.585601600873485}, {
            0.6815378376167776, -0.618447766399624}, {
            0.6542323588075647, -0.6501443329344545}, {
            0.625451958059997, -0.6805903695602262}, {
            0.615076953497694, -0.6905798727260377}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6119073549867492, -0.6936316992740933}, {
            0.595234603738954, -0.7096849453591886}, {
            0.5636182642093153, -0.7373271294135908}, {
            0.5306942699765697, -0.763502704100527}, {
            0.49657037066639337`, -0.7882241328108892}, {
            0.47430066670783533`, -0.8028804393616512}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4706252245569187, -0.8052993492391095}, {
            0.4613091633239473, -0.8114305061476246}, {
            0.4249732449943921, -0.8330609147136796}, {
            0.38762521272288875`, -0.8530544491120013}, {
            0.3493276635545982, -0.8713501999455368}, {
            0.31454409034643865`, -0.8860299436683705}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.31049031445145353`, -0.8877407624762043}, {
            0.310143194534681, -0.8878872578172325}, {
            0.27013440270829775`, -0.9026047133300357}, {
            0.22940726370309497`, -0.915492478035028}, {
            0.18808110040286863`, -0.9265561006981018}, {
            0.1462385307370034, -0.9357581277444204}, {
            0.14165464551237264`, -0.936549965399954}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1373188607850001, -0.9372989452380559}, {
            0.10396217263488396`, -0.9430611055991464}, {
            0.061334644025895405`, -0.948427580687443}, {
            0.018438562839422863`, -0.9518200994344731}, \
{-0.024643452995148994`, -0.9532012082653997}, {-0.037693003508576586`, \
-0.9529994291507969}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.042092477604991775`, -0.9529314021343125}, \
{-0.06782878554843551, -0.9525334536053859}, {-0.11101533300875738`, \
-0.9498568125949971}, {-0.15409499852372946`, -0.9452350872103074}, \
{-0.1969761716029082, -0.9386665611297427}, {-0.21686538360571767`, \
-0.9346892655322107}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.2211799613884587, -0.9338264685939468}, \
{-0.23956724175585006`, -0.9301495180317283}, {-0.2817765984921111, \
-0.9196822415946901}, {-0.32351263132124713`, -0.9072630154970541}, \
{-0.3646837297528153, -0.8928901234172457}, {-0.389363218244824, \
-0.8829437356504378}}]}, {
           Arrowheads[{{0.004229318445524019, 1.}}], 
           
           ArrowBox[{{-0.3934442485065827, -0.881298988860622}, \
{-0.40519828329637136`, -0.8765618490336906}, {-0.42761604968192435`, \
-0.8665661177734213}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-1.1, 1.0347658525849395`}, {-1.0820421507479376`, 
            1.028553696311218}, {-1.0479424194741973`, 
            1.0184569131929173`}, {-1.0161160572960444`, 
            1.0099962223969667`}, {-0.9874278402764389, 
            1.0037581691933055`}, {-0.9667800525787936, 
            1.0008024678243186`}, {-0.9472149072306345, 
            0.9985683702971021}, {-0.9286921079064834, 
            0.9969429615942115}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.9243089515187334, 
            0.996558331797489}, {-0.9098980298997061, 
            0.9952937477027025}, {-0.8757552631969221, 
            0.994075692232152}, {-0.8440260283566657, 
            0.9943607408115214}, {-0.8008278959579203, 
            0.9965340987503598}, {-0.7606059819255115, 
            1.0003588216115806`}, {-0.7487256099755175, 
            1.001920510845896}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7443631390333061, 
            1.0024939629174423`}, {-0.7226838114728935, 
            1.0053437366956373`}, {-0.6863849098135203, 
            1.0109976713029831`}, {-0.6513848655210683, 
            1.0170840054805166`}, {-0.6173592671692143, 
            1.0233661192751362`}, {-0.5880724882973429, 
            1.0289294812274863`}, {-0.5709164256889876, 
            1.032179060373241}}]}, {
           Arrowheads[{{0.0008537875958367753, 1.}}], 
           
           ArrowBox[{{-0.5664152936380469, 
            1.0343624616438554`}, {-0.5593892194823773, 
            1.0343624616438554`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7534504132509109, 1.0866363053352748`}, {
            0.7591103872287337, 1.0621137413697774`}, {0.7651804075293612, 
            1.0389042773582078`}, {0.7785505870990291, 0.996424649196851}, {
            0.7892837896411833, 0.9695611049103988}, {0.8001926747326773, 
            0.9437968303300078}, {0.8103111598244607, 0.9204975011352156}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.8120943632609121, 0.9164751561168326}, {
            0.8220839873795409, 0.8943200226328601}, {0.8329961012548315, 
            0.8698180288417805}, {0.843841130233839, 0.8457888551656887}, {
            0.854619074316564, 0.8222325016045852}, {0.8653299335030059, 
            0.7991489681584697}, {0.875910273156033, 0.7763990249417252}, {
            0.8851411261469977, 0.7563528529623272}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.8869757455981421, 0.7523535900249724}, {
            0.8964890899504447, 0.731482219539496}, {0.9064875670918295, 
            0.7093153573540116}, {0.9162593681778128, 0.6872821122813983}, {
            0.9257717713235407, 0.665321741090774}, {0.9350247765290131, 
            0.6434342437821385}, {0.9440183837942295, 0.6216196203554918}, {
            0.9562126919130108, 0.590577442756395}}]}, {
           Arrowheads[{{0.0009766082356094633, 1.}}], 
           
           ArrowBox[{{0.9585644234857248, 0.5803742962833108}, {
            0.960220797062099, 0.5803742962833108}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.0617907134588143`, -0.5073187063553002}, {
            1.0378315263261961`, -0.5329252207687485}, {
            1.014185006888218, -0.558044779882725}, {
            0.9875875273873158, -0.5851339966693256}, {
            0.9610775057564191, -0.6115889985444214}, {
            0.938748317690847, -0.6331187217577952}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.9355808614713346, -0.6361727717078569}, {
            0.9343519243010112, -0.6373577085289357}, {
            0.9075117889192647, -0.6624574856158943}, {
            0.87446980398519, -0.6930394619003734}, {
            0.8409403089747609, -0.722491952639325}, {
            0.8069233038879781, -0.7508149578327494}, {
            0.8040723856178646, -0.7530618087630214}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.8006166188050198, -0.7557853497917633}, {
            0.7724187887248408, -0.7780084774806464}, {
            0.7373865560865293, -0.8040090383801447}, {
            0.701786398574223, -0.8287531673283731}, {
            0.6656183161879219, -0.8522408643253315}, {
            0.6570709630364521, -0.8574134044983296}}]}, {
           Arrowheads[{{0.003244141971900703, 1.}}], 
           
           ArrowBox[{{0.6501863370064332, -0.8725838650927585}, {
            0.6320025672706854, -0.8725838650927585}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.0409524095105025`, -1.1}, {-1.0328780512243918`, \
-1.0767956254390572`}, {-1.0224619544238345`, -1.0415119867469549`}, \
{-1.0180090573506537`, -1.024919391652618}, {-1.014183325559652, \
-1.0092046649046702`}, {-1.0102771879968604`, -0.9885792957618884}, \
{-1.0071543683922686`, -0.9690946248382104}, {-1.0022085485855392`, \
-0.9320371340325265}, {-1.0019549019440108`, -0.9288701452249171}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.001603627290504, -0.924484189671357}, \
{-0.9995086186315566, -0.8983262680258955}, {-0.9984631870143623, \
-0.8671616048187142}, {-0.9988932820373709, -0.8255699515299882}, \
{-1.001150798307386, -0.7870504930937118}, {-1.0047350692692025`, \
-0.7509203068669168}, {-1.0050005601282916`, -0.7488480914839631}}]}, {
           Arrowheads[{{0.01385119609006961, 1.}}], 
           
           ArrowBox[{{-1.0055597147465427`, -0.7444837649479569}, \
{-1.0091454283676151`, -0.7164964702066352}, {-1.014139906696009, \
-0.6834477909944066}, {-1.0194765353477693`, -0.6514430771117704}, \
{-1.0243128643602932`, -0.6240630024892412}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{1.1, -1.0457117900380584`}, {
            1.0943243349921166`, -1.0435564577613436`}, {
            1.0614809070448914`, -1.0326143605694649`}, {
            1.030783614536939, -1.0232523506561535`}, {
            1.0030942162761423`, -1.0160747839756485`}, {
            0.9825058984968355, -1.012226737712295}, {
            0.9630457934284317, -1.009156096514453}, {
            0.9293663855948128, -1.0047435437243943`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.9249980891903866, -1.0042254477544208`}, {
            0.8922987930299128, -1.0016817937986415`}, {
            0.8611006661941605, -1.000699983872774}, {
            0.8193242303647339, -1.00120635377254}, {
            0.7806024625351288, -1.0035293033734214`}, {
            0.7493411920046539, -1.0066581532492511`}}]}, {
           Arrowheads[{{0.014777692958966838`, 1.}}], 
           
           ArrowBox[{{0.7449630661394566, -1.0070963471657888`}, {
            0.7442549186365106, -1.0071672235949634`}, {
            0.7096011546000448, -1.0116185053567124`}, {
            0.6763115710778911, -1.0166408095741823`}, {
            0.6440565687222093, -1.0219917971628885`}, {
            0.6164459127408243, -1.0268302216633443`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-0.45520364908712696`, -1.0603307863049758`}, \
{-0.48194587000053435`, -1.0397808928417906`}, {-0.5081803492503998, \
-1.0191985667101702`}, {-0.5361434910369125, -0.9957055259249348}, \
{-0.5634760870379788, -0.9720504998384077}, {-0.5901439432665159, \
-0.9480357898437113}, {-0.5904162253057404, -0.9477813639373935}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5936311246050641, -0.944777296279166}, \
{-0.616158457718218, -0.9237272954764715}, {-0.6345962126016664, \
-0.9065390441274243}, {-0.6526710992296613, -0.8891314042732484}, \
{-0.6703831176022025, -0.871504375913944}, {-0.6877322677192901, \
-0.853657959049511}, {-0.7047185495809242, -0.8355921536799495}, \
{-0.7183012783319329, -0.8206516105133411}}]}, {
           Arrowheads[{{0.019429858204129645`, 1.}}], 
           
           ArrowBox[{{-0.7212610883505614, -0.8173959193956786}, \
{-0.7213419631871045, -0.8173069598052594}, {-0.7376025085378313, \
-0.7988023774254406}, {-0.7535001856331045, -0.7800784065404932}, \
{-0.7690129758317744, -0.7611352469012966}, {-0.7841188604926915, \
-0.7419730982587307}, {-0.7988178396158555, -0.7225919606127947}, \
{-0.8131099132012668, -0.7029918339634894}, {-0.8269950812489251, \
-0.6831727183108142}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-1.061057947989386, 
            0.4415726537192223}, {-1.041263042382042, 
            0.4685460643023994}, {-1.0213751156695143`, 
            0.49501414751023715`}, {-0.9986495448453279, 
            0.5231109722658824}, {-0.9757166301500138, 
            0.5505860561723509}, {-0.9523982952426625, 
            0.5774080739417184}, {-0.9510785555160278, 
            0.5788693075036574}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.948129399524804, 
            0.5821346526522486}, {-0.9287538989035776, 
            0.6035874673366266}, {-0.9114413254705164, 
            0.6227962483353403}, {-0.893882945762336, 
            0.6416225999796427}, {-0.8760787597790366, 
            0.6600665222695337}, {-0.858028767520618, 
            0.6781280152050132}, {-0.8397329689870806, 
            0.6958070787860815}, {-0.8259287223824429, 
            0.7086844433270147}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8227113121114067, 
            0.711685821535077}, {-0.8211913641784241, 
            0.7131037130127386}, {-0.8024039530946482, 
            0.7300179178849838}, {-0.7833707357357533, 
            0.7465496934028181}, {-0.7640946033075122, 
            0.7626750319514135}, {-0.7445784470156979, 
            0.7783699259159428}, {-0.7248222668603101, 
            0.7936343752964061}, {-0.7048260628413491, 
            0.8084683800928032}, {-0.6857687255296954, 
            0.8220328401813367}}]}, {
           Arrowheads[{{0.002481435616031391, 1.}}], 
           
           ArrowBox[{{-0.6795852049648375, 
            0.8350943666518844}, {-0.6666790493128371, 
            0.8350943666518844}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.0414293854440108, 0.7788351042077912}, {
            0.07644026859332288, 0.7766942969937617}, {0.11135069203778754`, 
            0.7730077403451153}, {0.14609277620935135`, 0.7677879111914752}, {
            0.18059864153995983`, 0.7610472864624641}, {0.2147850400368938, 
            0.7527560470658164}, {0.21512258705015863`, 
            0.7526575849807838}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.21934655047553564`, 0.7514254595890004}, {
            0.24857431222549436`, 0.7428997542808617}, {0.2819069613147975, 
            0.7315139555946176}, {0.31472349051384, 0.7186341984941005}, {
            0.3469644030316591, 0.7042960304663273}, {0.37857020207729053`, 
            0.6885349989983147}, {0.382482454822402, 0.6863646305357833}}]}, {
          
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.38633004262099185`, 0.6842301357168291}, {
            0.40948139085977137`, 0.6713866515770799}, {0.4396384725881385, 
            0.6528865356896392}, {0.4696852771321057, 0.6325157900417954}, {
            0.4987637737243843, 0.610742788042913}, {0.5268266291324333, 
            0.5876254062367373}, {0.5306539662968811, 0.5841660614968682}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5339182016642159, 0.5812156772055189}, {
            0.5538265101237119, 0.5632215211670131}, {0.5797160834656793, 
            0.5375890093774858}, {0.6044480159257947, 0.5107857474119002}, {
            0.6279749742715172, 0.4828696118140014}, {0.6502496252703059, 
            0.45389847912753467`}, {0.6520864978854183, 
            0.4512658129371598}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.654604215613399, 0.4476573371589105}, {
            0.6711788605036033, 0.4239020114706109}, {0.6906862170750393, 
            0.39292013075248083`}, {0.7087493300353551, 
            0.36102610320359885`}, {0.7253458344352919, 0.3282931950544196}, {
            0.740453365325591, 0.2947946725353978}, {0.7405719038899721, 
            0.2944965790255248}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7421977564615798, 0.29040798471752644`}, {
            0.7540495577569934, 0.26060380187698784`}, {0.7661120467802405, 
            0.22579384930964436`}, {0.7766184674460733, 
            0.19043808106382154`}, {0.7855015031472339, 
            0.15460659840906468`}, {0.791995892405191, 
            0.12196118687583749`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7928208324789353, 0.11763987642223697`}, {
            0.7982466621430497, 0.08180523893878201}, {0.80211309371155, 
            0.04498534726879362}, {0.8043116321763418, 
            0.007985971072599128}, {
            0.8048444316743477, -0.029117897077032637`}, {
            0.8039750571046603, -0.0576669103231377}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.803841130384202, -0.06206487162737257}, {
            0.8037136463424903, -0.06625126460733274}, {
            0.8009214303176919, -0.1033391389455323}, {
            0.7963939158406271, -0.14033118596638738`}, {
            0.7900848794778783, -0.1771681048364632}, {
            0.782037941855231, -0.2137614529207044}, {
            0.7761979831460928, -0.23550048920861824`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.775056443665085, -0.2397498288765314}, {
            0.7722967235984701, -0.25002278758405583`}, {
            0.7609048453333809, -0.2858636661914621}, {
            0.7479059276857485, -0.32119564610786816`}, {
            0.733343591281358, -0.3559302846982185}, {
            0.7172614567459946, -0.3899791393274583}, {
            0.7102987387845598, -0.40302564863552276`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.7082270897724989, -0.40690743564292375`}, {
            0.6963879907167407, -0.4290911456374356}, {
            0.6734617941232017, -0.46698805727742704`}, {
            0.6484828669653774, -0.503669874247433}, {
            0.6214512092432677, -0.5391365965474536}, {
            0.6100578953659176, -0.5525380446145107}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6072079398312387, -0.5558903204758254}, {
            0.5925095074865018, -0.573179432305417}, {
            0.5618004482247088, -0.6055895896492511}, {
            0.5293240314578886, -0.6363670685789563}, {
            0.4950802571860413, -0.6655118690945327}, {
            0.48001607495516513`, -0.6770059409833227}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.47651803441065405`, -0.6796749693362925}, {
            0.45925368305780245`, -0.6928477849941036}, {
            0.4220288667218076, -0.7181986100757919}, {
            0.383405808178057, -0.7415643443395981}, {
            0.3433845074265504, -0.7629449877855221}, {
            0.3264512067110415, -0.7709534751531422}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3224736204650922, -0.7728346470368452}, {
            0.3177452922047199, -0.7750708771599228}, {
            0.29167644617461863`, -0.7863449605451951}, {
            0.2652154893708426, -0.7967474097876102}, {
            0.238381181810768, -0.8062683108102744}, {
            0.21111565386424377`, -0.8150644983452316}, {
            0.18348727999001868`, -0.8229269563652728}, {
            0.15622487567995352`, -0.8296830832431722}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.15192598531979837`, -0.8306193252656465}, {
            0.12732345169574463`, -0.8358377646124139}, {
            0.09887872589433526, -0.8408796552154175}, {
            0.07025261140250405, -0.8449748970553118}, {
            0.041490472529570846`, -0.848120260320049}, {
            0.0126376735848555, -0.8503125151975806}, \
{-0.022519579714500457`, -0.8514253638326533}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.026917377098466394`, -0.8515645693267345}, \
{-0.03469485152338667, -0.8518107532855435}, {-0.08201238585163668, \
-0.8506848382596514}, {-0.12931492939989447`, -0.8469347701199047}, \
{-0.17660248216816002`, -0.840560548866303}, {-0.2018665283310427, \
-0.8357310500384384}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.20618827313576132`, -0.8349049012365342}, \
{-0.22358756332688204`, -0.8315788365578229}, {-0.2699826920465093, \
-0.8200062952534404}, {-0.2929590242416624, -0.8132484637277858}, \
{-0.31578786832704175`, -0.8058429249531556}, {-0.3384692243026474, \
-0.7977896789295498}, {-0.3610030921684795, -0.7890887256569684}, \
{-0.37419257097566183`, -0.7835751403375719}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3782521431408542, -0.7818781212346756}, \
{-0.3833186172067416, -0.7797601878849841}, {-0.40534494469963767`, \
-0.7698241883631697}, {-0.42708207464716763`, -0.7592807270915248}, \
{-0.44853000704933155`, -0.7481298040700499}, {-0.4696887419061294, \
-0.7363714192987447}, {-0.4905582792175611, -0.7240055727776092}, \
{-0.5111386189836268, -0.7110322645066436}, {-0.5314297612043264, \
-0.6974514944858478}, {-0.5320910961960625, -0.6969957187192097}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.5357140447366096, -0.6944988719332519}, \
{-0.5527417996496157, -0.6827637631811421}, {-0.5736517804363721, \
-0.6674282327537233}, {-0.5937437848571934, -0.6502481220574443}, \
{-0.613338470479454, -0.6324455452365292}, {-0.6323823053841262, \
-0.6140697022527246}, {-0.6508931335442195, -0.595104193118782}, \
{-0.6673165693710282, -0.5782765317180547}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6703585119898526, -0.5750980486001819}, \
{-0.6873129406794736, -0.5566503614545737}, {-0.7046717022999672, \
-0.5365890859626238}, {-0.7214630359557049, -0.5159715706974431}, \
{-0.7376530090082992, -0.49483154479078617`}, {-0.7532076888193618, \
-0.473202737374407}, {-0.7681270753888931, -0.45108514844830566`}, \
{-0.7776768849444297, -0.43597137626503046`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7800272051584125, -0.43225169954631637`}, \
{-0.7824111687168928, -0.4284787780124821}, {-0.796030551568077, \
-0.40542209003601565`}, {-0.8089558067071616, -0.3819535484879858}, \
{-0.8211869341341469, -0.35807315336839246`}, {-0.8327239338490326, \
-0.33378090467723565`}, {-0.8479683192967244, -0.29846677662400245`}, \
{-0.8571839747175204, -0.2743915602451187}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8587569319687703, -0.27028232607246067`}, \
{-0.8617567052132412, -0.26244564092630707`}, {-0.874046104186235, \
-0.22578824456159372`}, {-0.8847935288033578, -0.18856533450730645`}, \
{-0.8939559916522626, -0.1508476577408893}, {-0.9014905053206012, \
-0.11270596123978624`}, {-0.9033742248608927, -0.10033915427841966`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9040367932915282, -0.09598932634219906}, \
{-0.9073540823960256, -0.07421099198144146}, {-0.9115037354661886, \
-0.035433496943298906`}, {-0.9139626098811756, 
            0.0035555027828178746`}, {-0.9147741995333595, 
            0.04268490176219947}, {-0.9139788397985471, 
            0.07944359948892993}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.9138003242828263, 
            0.08383899079397793}, {-0.91140566615365, 
            0.12108140351366506`}, {-0.907200613923923, 
            0.1602067593022029}, {-0.901298418535725, 
            0.1991890203769136}, {-0.8936866153901392, 
            0.23795731324602398`}, {-0.8888793440704863, 
            0.2577776323687377}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8878422260407943, 
            0.26205365694683447`}, {-0.8843527398882486, 
            0.27644076441776083`}, {-0.8733365565647997, 
            0.31456280664589575`}, {-0.8606939004572044, 
            0.35224512075975245`}, {-0.8464364127205443, 
            0.38941420538088584`}, {-0.8305757345099006, 
            0.4259965591308509}, {-0.8296646470057062, 
            0.4278718610639548}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8277418827048966, 
            0.4318295090325761}, {-0.8131235069803552, 
            0.4619186806312032}, {-0.7940913712869895, 
            0.49710706850349773`}, {-0.7734909685848849, 
            0.5314882213692894}, {-0.751333940029123, 
            0.5649886378501339}, {-0.7382334697863444, 0.583031106036782}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.7356482674574742, 
            0.5865915454645498}, {-0.7276897219765659, 
            0.5975523583964697}, {-0.702645533923085, 
            0.6291288209445459}, {-0.6762396917322758, 
            0.6596526203446336}, {-0.648510511267734, 
            0.6890583514470031}, {-0.6194963083930554, 
            0.7172806091019251}, {-0.6188262258390103, 
            0.7178778942158209}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.6155416590399798, 
            0.7208056272881326}, {-0.5892353989718351, 
            0.7442539881596708}, {-0.557766098867669, 
            0.7699130834705105}, {-0.525126723944153, 
            0.7941924898847146}, {-0.4925062989171774, 
            0.8163446679723403}, {-0.47547303290277376`, 
            0.8269127593802998}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.4717341952273063, 
            0.829232477646923}, {-0.4589578380908379, 
            0.8371594195478337}, {-0.4245354687541874, 
            0.8565924864152662}, {-0.38929331819627866`, 
            0.8745996103787093}, {-0.3532855137061646, 
            0.8911365332422344}, {-0.31656618257289804`, 
            0.9061589968099131}, {-0.3141556720874996, 
            0.9070273044619074}}]}, {
           Arrowheads[{{0.008244831939897255, 1.}}], 
           
           ArrowBox[{{-0.3100160542722787, 
            0.9085184665402561}, {-0.27918945208553153`, 
            0.9196227428858167}, {-0.24120944953311751`, 
            0.9314835132740171}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0794419888010771`, 1.089864564664516}, {
            1.0647494993224784`, 1.0520174470924242`}, {1.0534370105701194`, 
            1.0185514521050918`}, {1.0438145221808797`, 0.9872760184101389}, {
            1.0364988580499432`, 0.9590363596789646}, {1.0327607610895229`, 
            0.9387888943866871}, {1.0300545043567788`, 
            0.9214072502096453}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.029443108216474, 0.9170502981446806}, {
            1.0250317817081533`, 0.8829237876671219}, {1.0224387293471215`, 
            0.8493332691009432}, {1.0214257289087834`, 0.8180864876326044}, {
            1.0218259835112877`, 0.7752829680400615}, {1.0236808274133904`, 
            0.7415033415682013}}]}, {
           Arrowheads[{{0.012568887479110627`, 1.}}], 
           
           ArrowBox[{{1.0239220686019879`, 0.737109959876506}, {
            1.0240146780647261`, 0.7354233958182003}, {1.0274778536827047`, 
            0.6978461008837925}, {1.0317015514788301`, 0.6618894131536102}, {
            1.036437872713359, 0.6272349252764835}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.33406032559471033`, 1.0664965572490228`}, {
            0.36223369053181564`, 1.0520811135805759`}, {0.3899723543195147, 
            1.0372447708914436`}, {0.41825351524263693`, 
            1.0203319658200665`}, {0.44603113581468323`, 
            1.0029760587985284`}, {0.4732827990217062, 0.98510538625722}, {
            0.4853180368755861, 0.9768390431165046}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.4889449299959385, 0.9743479296518988}, {
            0.5000159772016884, 0.966743836052678}, {0.5260786531211793, 
            0.9488047104732088}, {0.5515846072608868, 0.9303451967390606}, {
            0.5765338396208106, 0.911365294850233}, {0.600926350200951, 
            0.8918650048067263}, {0.624762139001308, 0.8718443266085406}, {
            0.6290652260302312, 0.8680473532974905}}]}, {
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{0.6323644624544241, 0.8651361612706261}, {
            0.6480412060218814, 0.8513032602556757}, {0.6707635512626714, 
            0.8302418057481314}, {0.6929291747236778, 0.8086599630859082}, {
            0.7144870701945647, 0.7865906326299243}, {0.735386231464996, 
            0.7640667147410983}, {0.755626658534972, 0.7410882094194304}, {
            0.7562516836265649, 0.7403402520777038}}]}, {
           Arrowheads[{{0.0028594311511529165`, 1.}}], 
           
           ArrowBox[{{0.7622902660160222, 0.7215050539930636}, {
            0.7719911793855705, 0.7215050539930636}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.4948305277094597, -0.37526284911742885`}, \
{-0.5077188163916484, -0.3524684523567966}, {-0.5195154963522555, \
-0.32922260970617356`}, {-0.5302149745319967, -0.3055794694482881}, \
{-0.5398116578715879, -0.2815931798658677}, {-0.5482999533117451, \
-0.2573178892416401}, {-0.5556742677931841, -0.2328077458583335}, \
{-0.5607047852933092, -0.21278172937886214`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5617767574610184, -0.20851430911930754`}, \
{-0.561879880532569, -0.20810378588184061`}, {-0.5668799353734917, \
-0.18325181352053999`}, {-0.57069563619706, -0.15831312912088752`}, \
{-0.5733481868843819, -0.13334903302933904`}, {-0.5748587913165654, \
-0.10842082559235039`}, {-0.5752486533747182, -0.08358980715637748}, \
{-0.5745389769399482, -0.05891727806787613}, {-0.5727509658933634, \
-0.03446453867330219}, {-0.5726359469383723, -0.03358759588483337}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5720637479530105, -0.029224960406002837`}, \
{-0.5678197227589893, 0.00313289998548346}, {-0.5602759884984345, 
            0.03992134868015499}, {-0.5502130803958961, 
            0.0757149659004202}, {-0.537724315735571, 
            0.11032791013598718`}, {-0.5247896632353851, 
            0.13941430505445981`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.5230018038348478, 
            0.1434346979163466}, {-0.522931266581262, 
            0.14359331635733158`}, {-0.5059555049967717, 
            0.1753443195349291}, {-0.48674136996051026`, 
            0.20531520203431392`}, {-0.4656534691447446, 
            0.23345552905380534`}, {-0.4428774806729082, 
            0.2598150142619702}, {-0.41860340652650896`, 
            0.28393481829489686`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.41527379661783503`, 
            0.28681043131347833`}, {-0.3926711350371434, 
            0.30619889746215306`}, {-0.36578127177641, 
            0.32613596098823094`}, {-0.3421499551505493, 
            0.3413881588375372}, {-0.3180293578024073, 
            0.3549420058867441}, {-0.29341947973198423`, 
            0.3667975021358519}, {-0.26832032093928, 
            0.3769546475848603}, {-0.265892642605871, 
            0.37776510535497376`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.26171907175562137`, 
            0.3791584130589454}, {-0.24296875723497213`, 
            0.3854180306887621}, {-0.21760166442973825`, 
            0.3921922399025497}, {-0.19221904252357835`, 
            0.3972772752262233}, {-0.16682089151649238`, 
            0.4006731366597826}, {-0.14162461334662846`, 
            0.40245193001475815`}, {-0.11684760995213461`, 
            0.4026857611026803}, {-0.09248988133301092, 
            0.401374629923549}, {-0.08848313086455842, 
            0.40089658510795073`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.0841141170922478, 
            0.40037531871026133`}, {-0.0685514274892573, 
            0.3985185364773643}, {-0.0557224658374819, 
            0.39655675114264655`}, {-0.043076931119976965`, 
            0.3941771641209391}, {-0.015104660000329315`, 
            0.38553234341903375`}, {0.011433826835148066`, 
            0.37497731879621987`}, {0.03719202485283141, 
            0.36357491201880193`}, {0.06138964523492667, 0.350477740932176}, {
            0.07897729571157272, 0.3390772704503004}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.08266946657728062, 0.33668397266305833`}, {
            0.08393190091571494, 0.3358656515672566}, {0.1047240048294773, 
            0.3199184899549582}, {0.12371257526617065`, 0.3028227457018964}, {
            0.14084423051575187`, 0.28476490841468644`}, {
            0.15845207691557348`, 0.26267915258360475`}, {
            0.17357730209797184`, 0.23974997513886895`}, {
            0.18617271617047612`, 0.21632473121087425`}, {
            0.19225047830924896`, 0.20202337511145646`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.19397142176976026`, 0.1979738870443394}, {
            0.1961911292406155, 0.19275077593001597`}, {0.20373694337536, 
            0.16924101238890119`}, {0.2090011846185029, 
            0.14593151394425816`}, {0.21206659904280836`, 
            0.12305439112266385`}, {0.2130159327210406, 
            0.10084175445069521`}, {0.20924067718391343`, 
            0.058961743450805584`}, {0.2002202735977891, 
            0.02579359481191082}}]}, {
           Arrowheads[{{0.01981665800839003, 1.}}], 
           
           ArrowBox[{{0.19906559018171588`, 0.02154780793447037}, {
            0.19902405669637754`, 0.02139508873493117}, {
            0.18364957094190654`, -0.011060780023604451`}, {
            0.1645072481249769, -0.03810293037406431}, {
            0.1362083381042565, -0.06484643352350299}, {
            0.10613240057179028`, -0.0827097975002491}, {
            0.07637031512459992, -0.09229065754169455}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{1.0824619407600635`, -0.35095857956131676`}, {
            1.0661317639078607`, -0.3790663412347649}, {
            1.0495544167105904`, -0.4067047598543209}, {
            1.0311240536542488`, -0.4348525663608659}, {
            1.0123834646639525`, -0.4624739615595791}, {
            0.9932129970923156, -0.4895524805026257}, {
            0.9866498024625234, -0.49845792501764036`}}]}, {
           Arrowheads[{{0.017654682053951556`, 1.}}], 
           
           ArrowBox[{{0.9840393946517045, -0.5019999260144239}, {
            0.9736525351551336, -0.5160936115059506}, {
            0.9571567123235669, -0.5384803787004006}, {
            0.940314756434647, -0.5604457680923652}, {
            0.9231266674883739, -0.5819897796818444}, {
            0.9055924454847478, -0.6031124134688384}, {
            0.8877120904237685, -0.6238136694533469}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7611519214117137, -1.1}, {-0.7671868006933947, \
-1.0685908388277934`}, {-0.7786885553690513, -1.0223681983760085`}, \
{-0.7871109469672679, -0.9981535460412474}, {-0.7957777248479875, \
-0.9749920820841258}, {-0.8128374493654849, -0.9322544741460232}}]}, {
           Arrowheads[{{0.019857824154555295`, 1.}}], 
           
           ArrowBox[{{-0.8144926995251167, -0.9281777408947526}, \
{-0.8311637761624544, -0.8875205283238556}, {-0.8490160052074611, \
-0.8463277275161321}, {-0.8667625681179116, -0.8066424737309199}, \
{-0.8841704360490313, -0.767937933132801}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-1.1, 0.7397727556756948}, {-1.0902610649009765`, 
            0.7418035468005861}, {-1.0664037631250727`, 
            0.7478062572605932}, {-1.0437699312919646`, 
            0.7541673309872378}, {-1.0198279707610576`, 
            0.7629847323785729}, {-0.9969564395534904, 
            0.7720312085571372}, {-0.9533285825825857, 
            0.7904283664471826}, {-0.9345345087803956, 0.798571103600322}}]}, {
           Arrowheads[{{0.017196417608452492`, 1.}}], 
           
           ArrowBox[{{-0.930497157333103, 
            0.8003203300839554}, {-0.9107367816033238, 
            0.80888172807081}, {-0.8702170926073477, 
            0.8274474971616018}, {-0.8312319368481489, 
            0.8459030871356588}, {-0.7932437355792189, 
            0.8640259114090819}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.46157593974628963`, -0.4297639074127898}, {
            0.4412063472578071, -0.4468219194487644}, {
            0.4201938112350449, -0.46291267127594465`}, {
            0.3985784558769166, -0.47797539286416924`}, {
            0.3764036610969904, -0.49196229457455715`}, {
            0.35372338788146246`, -0.5048677730398884}, {
            0.33059159721652887`, -0.5166862248929431}, {
            0.31391179610113823`, -0.5242896902451998}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.3099081514908814, -0.5261147463634498}, {
            0.30706225008838567`, -0.5274120467665012}, {
            0.2831893074832289, -0.5370396352933426}, {
            0.2590267303872547, -0.5455633871062475}, {
            0.23462847978665918`, -0.5529776988379956}, {
            0.2100354700512171, -0.5592279459833082}, {
            0.18529335977485645`, -0.564277329905291}, {
            0.16046322628000306`, -0.5681469860393019}, {
            0.14033009513638178`, -0.5703428273845854}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1359560338441392, -0.5708198890280921}, {
            0.13560614688908285`, -0.5708580498206984}, {
            0.11078319892452167`, -0.5724316566848382}, {
            0.08605545970874538, -0.5728889420670792}, {
            0.06148400656417982, -0.5722510414027785}, {
            0.037129916813250737`, -0.5705390901272942}, \
{-0.00038292955051443586`, -0.5657245930195245}, {-0.03709061995125218, \
-0.5582989435948704}, {-0.038803104290478826`, -0.5578221969836216}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.04304190800900356, -0.5566421363767793}, \
{-0.07280714063667083, -0.5483556525455273}, {-0.10734647785447901`, \
-0.5359882305636905}, {-0.14054173304069248`, -0.5213185141927605}, \
{-0.17222600763132673`, -0.5044683399761378}, {-0.20213400305543044`, \
-0.4853825293350984}, {-0.2027420075404053, -0.48492878367416503`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.20626828274055925`, -0.48229717139026396`}, \
{-0.23021522634017003`, -0.4644258858661304}, {-0.2563525261077847, \
-0.44194017325777835`}, {-0.2804256974854239, -0.4178370493992485}, \
{-0.30239217477835495`, -0.392381877285595}, {-0.32220939229184536`, \
-0.3658400199118721}, {-0.32811328803317835`, -0.3567623921610691}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.33051221865385527`, -0.3530738786559862}, \
{-0.3375066421889724, -0.34231949274453827`}, {-0.3511057550420681, \
-0.3183073307131457}, {-0.36300673085113255`, -0.29380353381769453`}, \
{-0.3732095696161657, -0.2688081020581847}, {-0.3817192258049964, \
-0.24355867628944936`}, {-0.38854065388545345`, -0.21829289736632176`}, \
{-0.39367385385753684`, -0.19301076528880193`}, {-0.39404136133466805`, \
-0.19031193846215588`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.39463504367711594`, -0.18595217456071975`}, \
{-0.39711882572124657`, -0.16771228005688982`}, {-0.3989483850061275, \
-0.14261514561183936`}, {-0.3992353472417244, -0.11793706589490444`}, \
{-0.3979797124280375, -0.09367804090608513}, {-0.3951814805650665, \
-0.06983807064538136}, {-0.39325485539409455`, -0.05708373011815614}, \
{-0.3909127300265611, -0.04451212782321672}, {-0.382348012367258, \
-0.01663824359955046}, {-0.3806520002537012, -0.012355676299102884`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.3790319022831342, -0.008264798329062144}, \
{-0.3718772145389531, 0.009801364956697138}, {-0.360561341216581, 
            0.03546070430740473}, {-0.3475553169060745, 
            0.05955950524703231}, {-0.3330396692969992, 
            0.08200361102902874}, {-0.3171949260789208, 
            0.10269886490684285`}, {-0.3002079290233141, 
            0.12159274930888639`}, {-0.2835742100921477, 
            0.13738987692222748`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.28023693180835424`, 
            0.14025131419569148`}, {-0.26035853872527326`, 
            0.15611186358039678`}, {-0.2376188807228566, 
            0.17112273732334454`}, {-0.21439248726303758`, 
            0.18362006170237774`}, {-0.1910252997144499, 
            0.1935585305274596}, {-0.16772812778418028`, 
            0.20104285354513407`}, {-0.14463456308700276`, 
            0.20626346389427672`}, {-0.12197471985308221`, 
            0.2093036404733485}, {-0.12143008378482342`, 
            0.20932699033054825`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.11703412191351738`, 
            0.20951545578102526`}, {-0.09997871231258333, 
            0.21024666218081037`}, {-0.058522607732303125`, 
            0.20651276285804743`}, {-0.021355056187066516`, 
            0.19640480968027416`}, {0.010738746298768266`, 
            0.18119862154824695`}, {0.03746524126749273, 
            0.16227199565084208`}, {0.0446897922964256, 
            0.15461928340858042`}}]}, {
           Arrowheads[{{0.010126270645879953`, 1.}}], 
           ArrowBox[{{0.047710270514001826`, 0.15141979730341484`}, {
            0.06391745313212206, 0.13425210005308766`}, {0.08155251081476289, 
            0.10448648222183134`}, {0.09097230980806012, 
            0.07505277168999452}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.6372324755354232, 1.1}, {0.6412938721972808, 
            1.0911964928042537`}, {0.6606901301609918, 1.0540492885490784`}, {
            0.6772883996215784, 1.0262731823798248`}, {0.6938222857624751, 
            0.9995873823166556}, {0.7101680332334092, 0.9734556322241696}, {
            0.7262058452808443, 0.9483091996504758}}]}, {
           Arrowheads[{{0.01622040731872685, 1.}}], 
           
           ArrowBox[{{0.7285556157978658, 0.9445891792752283}, {
            0.742512710830629, 0.9224775106988772}, {0.758405553813771, 
            0.8972706885221595}, {0.7740454227672313, 0.8724362176173485}, {
            0.7894323176910095, 0.8479740979844438}, {0.8045160104763825, 
            0.8237400881496205}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.458911893039023, 0.42673444095251695`}, {
            0.47420569049429034`, 0.40537497216826135`}, {0.4884988475254994, 
            0.3834584206238911}, {0.5017349451059546, 0.3610289854712427}, {
            0.5138705509977317, 0.3381330196850776}, {0.5249044400264119, 
            0.3148238761646641}, {0.5348353870175768, 0.29115490780927067`}, {
            0.5417971854772219, 0.2722451595814213}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5433173371582679, 0.2681160992928553}, {
            0.5436621667968077, 0.26717946751816574`}, {0.551383554189686, 
            0.2429509081906177}, {0.5579983240217933, 0.21852258272589495`}, {
            0.5635052511187109, 0.19394784402326584`}, {0.5678539189251226, 
            0.1692711912666654}, {0.571011798660584, 0.14454034317287703`}, {
            0.5730044968129845, 0.11981348194044202`}, {0.5738439810898309, 
            0.0955431013702984}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5738150542339533, 0.09114356335183312}, {
            0.5735967743201595, 0.07060444885379658}, {0.5722475666507126, 
            0.04623864139666857}, {0.5698356033497619, 0.02210954959505859}, {
            0.5663864909051964, -0.0017246443524921579`}, {
            0.5588765405082072, -0.03853669337949148}, {
            0.5488306533145932, -0.07434514417162308}, {
            0.5461318137982463, -0.08183745600250485}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.5446406620145778, -0.08597707752603358}, {
            0.5363576880243233, -0.10897163635258801`}, {
            0.5215665033373657, -0.14223780954608733`}, {
            0.5045928188908881, -0.17398704808946855`}, {
            0.4855723543220583, -0.20406273632007912`}, {
            0.4644727585369979, -0.2321970668429118}, {
            0.4589546958321975, -0.2385283599322412}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.4560637552624291, -0.24184535595606563`}, {
            0.4416624387026679, -0.25836908192473607`}, {
            0.4179140126733817, -0.2820997286602076}, {
            0.39277388663518475`, -0.3037290518768576}, {
            0.3664977253796263, -0.3232378508991358}, {
            0.33934119369825594`, -0.3406069250514923}, {
            0.3197496461408093, -0.3514289689854139}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.31589817865868197`, -0.3535564553506148}, {
            0.31494411600786354`, -0.354083463637867}, {
            0.2901885846076103, -0.3658285695840776}, {
            0.2650745994974964, -0.3758422428901242}, {
            0.23960216067752169`, -0.3841244835560067}, {
            0.21400947151045516`, -0.39070058664662377`}, {
            0.18853473535906562`, -0.3955958472268738}, {
            0.16317795222335324`, -0.398810265296757}, {
            0.14744376631664707`, -0.39976631448131306`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.1430518664848575, -0.4000331774939742}, {
            0.13793912210331782`, -0.40034384085627317`}, {
            0.11302980764145126`, -0.40028861037916674`}, {
            0.08866157148024525, -0.39873661033918195`}, {
            0.041548334059814916`, -0.3911423015705775}, {
            0.029196437773329677`, -0.38830117777419815`}, {
            0.017057326061926406`, -0.38506770661841694`}, \
{-0.009322027916663422, -0.3747396049477695}, {-0.027558395270314083`, \
-0.36590532679171883`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.03151822468799738, -0.36398705908807316`}, \
{-0.03418000402727948, -0.36269760825517255`}, {-0.05822612763775913, \
-0.3499055871068989}, {-0.08064854624796602, -0.33561351704727177`}, \
{-0.101372617247146, -0.3200000810333746}, {-0.1203236980245449, \
-0.30324396202229076`}, {-0.13746670353183105`, -0.28552610201060946`}, \
{-0.15276654872067275`, -0.2670274429949199}, {-0.163752107100038, \
-0.25114454683998966`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.16625504547739223`, -0.2475258040363122}, \
{-0.16851320698268965`, -0.24426095909615245`}, {-0.18174928551090946`, \
-0.22085049409135368`}, {-0.19245778296479726`, -0.19714430844745343`}, \
{-0.20062169800381813`, -0.17349066263138144`}, {-0.20987923327871857`, \
-0.12706172296455337`}, {-0.21064879621852947`, -0.08300514005453126}, \
{-0.21021314680587608`, -0.08034512653751781}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.20950200177148348`, -0.07600297583307897}, \
{-0.2040468064198829, -0.04269432683289881}, {-0.19149492709492363`, \
-0.007098489506217058}, {-0.1743201495041441, 
            0.023109580647334805`}, {-0.15390741476414077`, 
            0.04775561064047075}, {-0.12479856957206903`, 
            0.07130860586368308}, {-0.12452181297448697`, 
            0.0714450476733146}}]}, {
           Arrowheads[{{0.006686755125647187, 1.}}], 
           
           ArrowBox[{{-0.12057534984252359`, 
            0.07339066550527794}, {-0.09467638331859107, 
            0.08615893152308712}, {-0.06551382317125355, 
            0.09306056842646324}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.36204179459459324`, 
            0.5050134027493933}, {-0.3391124927256393, 
            0.517249810956799}, {-0.31577025447274054`, 
            0.5283965411229008}, {-0.2920647358536815, 
            0.5384148984314022}, {-0.2680486826561315, 
            0.5473084636376411}, {-0.24377484066776023`, 
            0.5550808174969555}, {-0.2192959556762376, 
            0.5617355407646825}, {-0.19788867447880998`, 
            0.5665510121932942}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.19358639946890974`, 
            0.5674693915300119}, {-0.16993403983441688`, 
            0.5717064185467259}, {-0.14515650055945814`, 
            0.5750297345717176}, {-0.12038061007435051`, 
            0.5772003181076982}, {-0.09565638330278786, 
            0.5781902976889671}, {-0.07103890677299059, 
            0.5780302131174662}, {-0.04658326701317907, 
            0.5767506041951376}, {-0.022344550551573705`, 
            0.574382010723923}, {-0.01848815168762537, 
            0.5738305780013389}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.014132455957415751`, 0.5732077500107718}, {
            0.0016221560836051521`, 0.5709549725057649}, {0.02526176636413724,
             0.5665000293426048}, {0.04851919376180191, 0.5610477210363849}, {
            0.08448404444645265, 0.5503963161596325}, {0.11921870685691971`, 
            0.5372996842906477}, {0.15255402699449908`, 0.5218838231229774}, {
            0.15323930937425403`, 0.5215039550867021}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.15708761272527322`, 0.5193707506148958}, {
            0.18432085086048666`, 0.5042747303501683}, {0.21437462837928115`, 
            0.4846234768471786}, {0.2425708094752809, 0.4630811334889662}, {
            0.2686389625082714, 0.43964110877101176`}, {0.2925918211103292, 
            0.4146749152520909}, {0.2950390431992476, 
            0.41174785234623823`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.2978612977870766, 0.4083722221767027}, {
            0.3135677084495646, 0.3895861658386053}, {0.3324209434902849, 
            0.36335387115595486`}, {0.3491557295621815, 0.336220787104862}, {
            0.363776269994946, 0.308429669586049}, {0.3751480514332945, 
            0.28299230594486974`}, {0.38475110048269817`, 
            0.2573484580920731}, {0.3849486340473663, 0.2566966707745767}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.38622479827979583`, 0.25248580330434356`}, {
            0.3925854171431571, 0.23149812602765912`}, {0.39865100141467114`, 
            0.20544130975162775`}, {0.4029957834503286, 
            0.17941637749126013`}, {0.4056676934032175, 
            0.15366169747383715`}, {0.40666673127333813`, 
            0.12817726969935894`}, {0.40599289706069025`, 
            0.10296309416782551`}, {0.4038069713293043, 
            0.0787506001939231}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.40317415322936057`, 0.07439724072647255}, {
            0.40007945641683407`, 0.05416359269167228}, {0.388380215501394, 
            0.00808128590345695}, {
            0.38448545906978504`, -0.0038558215019490055`}, {
            0.38022260579815975`, -0.01554634922361369}, {
            0.3678658463442765, -0.04038268398935214}, {
            0.35398968191903063`, -0.06359785108852456}, {
            0.3394603854589519, -0.08596309443562195}, {
            0.3385297243242553, -0.08717760659059282}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.33585346750909184`, -0.09067011993477507}, {
            0.32362482492920747`, -0.10662849027856923`}, {
            0.3066606136319575, -0.12553871115586746`}, {
            0.2887453648693621, -0.1426384296060176}, {
            0.2507659746233245, -0.171335698222916}, {
            0.22687559252819253`, -0.18508636219809768`}, {
            0.20255907337445767`, -0.19627257444908286`}, {
            0.19898515070198824`, -0.19753801724269165`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.19483747351325229`, -0.19900661314968562`}, {
            0.17816739402499138`, -0.20490910010604996`}, {
            0.15405153134266536`, -0.2110107042991775}, {
            0.10731865039430101`, -0.21624062546787204`}, {
            0.06370321935909878, -0.21322529230308254`}, {
            0.02447797768035399, -0.20321021438703868`}, {
            0.022465037437585322`, -0.2022924806367171}}]}, {
           Arrowheads[{{0.010991416447948543`, 1.}}], 
           
           ArrowBox[{{
            0.018461496119214587`, -0.20046719794296844`}, \
{-0.009520641103386358, -0.18770966486290555`}, {-0.037745201215989205`, \
-0.16811301581834984`}, {-0.060155417596109644`, -0.1458191200660075}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{
            0.005201265650222263, -0.8090532138919754}, \
{-0.03245568360048992, -0.809536855448895}, {-0.07014686024260205, \
-0.8083192426707526}, {-0.10778757754036591`, -0.8053426710913477}, \
{-0.14529547414451396`, -0.8005699718065823}, {-0.1699795646486488, \
-0.7962425081947166}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.17431346752211185`, -0.7954827148784861}, \
{-0.18259574621183997`, -0.7940307164891947}, {-0.21961358989913876`, \
-0.7857544768119228}, {-0.2562742013632053, -0.7757708244475049}, \
{-0.29250277676083314`, -0.7641093310686787}, {-0.32822451224881727`, \
-0.7507995683481825}, {-0.34247583691854105`, -0.7447452205840265}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.34652554509081485`, -0.7430247951368133}, \
{-0.3633646039839525, -0.7358711079587542}, {-0.3978224347931953, \
-0.7193138529524984}, {-0.43150677416889865`, -0.7011321313344768}, \
{-0.4643568982659503, -0.681377152206864}, {-0.49631208323923726`, \
-0.6601001246718351}, {-0.49991882827013756`, -0.6574534465818292}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.50346619784716, -0.6548503389997236}, \
{-0.5273116052436473, -0.6373522578315645}, {-0.5572947404340683, \
-0.6131847607882266}, {-0.5862007649653872, -0.5876488426439965}, \
{-0.6139689549924919, -0.5607957125010488}, {-0.6350195137558894, \
-0.5384296674075113}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.6380351308427554, -0.5352255991208792}, \
{-0.6405089439864805, -0.5325971930558702}, {-0.6657411445761924, \
-0.5030539747888342}, {-0.6896210016531281, -0.4722605684779446}, \
{-0.712103960108787, -0.4403114849012066}, {-0.7331454648346696, \
-0.40730123483662406`}, {-0.7413052796685953, -0.3931238771596579}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.7435001360905237, -0.38931040036188924`}, \
{-0.7527009607222755, -0.3733243290622015}, {-0.770725892663105, \
-0.3384752783559434}, {-0.787175705548658, -0.3028485934958538}, \
{-0.8037397321913844, -0.2618764018272618}, {-0.8151135377148613, \
-0.22889671729232763`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.8165480658613051, -0.224737134501102}, \
{-0.8181424577483696, -0.22011400802404837`}, {-0.8303838822196139, \
-0.17756141208621362`}, {-0.840464005605117, -0.1342186140137575}, \
{-0.8483124280696929, -0.09031242153751842}, {-0.85300551881586, \
-0.052875830527490744`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.8535528236900405, -0.04851000215538331}, \
{-0.8538587497781553, -0.04606964238833456}, {-0.8571029707305043, \
-0.0014902765662062872`}, {-0.8580450909267401, 
            0.04342567592886662}, {-0.8566617891466537, 
            0.08843876891622733}, {-0.8534388868980699, 
            0.12718807718762082`}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.8530741843040748, 
            0.13157293659448135`}, {-0.8529297441700365, 
            0.133309556215219}, {-0.8468489559968888, 
            0.17803803782584157`}, {-0.8384194246272103, 
            0.22262421374809507`}, {-0.8312566162600726, 
            0.252414089761671}, {-0.8230377591869109, 
            0.2819831993696469}, {-0.8162795852878245, 
            0.30335242919915606`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           ArrowBox[{{-0.8149528229187256, 
            0.3075476290294315}, {-0.8137718940620312, 
            0.31128170579747877`}, {-0.803463541212614, 
            0.34028469065781247`}, {-0.7897022444886127, 
            0.37514810660893894`}, {-0.7743478939917401, 
            0.40948131080699196`}, {-0.7574548014592869, 
            0.44321335675363227`}, {-0.7436143833249598, 
            0.46811134838587676`}}]}, {
           Arrowheads[{{0.019999999999999993`, 1.}}], 
           
           ArrowBox[{{-0.7414765865744367, 
            0.4719571025451351}, {-0.7390772786285444, 
            0.476273297950521}, {-0.7192696372368037, 
            0.5085901878993189}, {-0.6980861890213561, 
            0.540093080101687}, {-0.6755812457194923, 
            0.5707110280592861}, {-0.6518091190685036, 
            0.6003730852737773}, {-0.6391366854991882, 
            0.6147746975216448}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.6362300501162695, 
            0.6180779490638022}, {-0.6224643596326216, 
            0.6337219952989065}, {-0.5914841278855392, 
            0.6655487516562415}, {-0.5588684238272563, 
            0.6958533543457822}, {-0.524617247457773, 
            0.7246358033675284}, {-0.5074990422199017, 
            0.7376213414097664}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.5039935329249998, 
            0.7402805526806805}, {-0.48889037346109104`, 
            0.7517375161328234}, {-0.4518475765212118, 
            0.7769999100530093}, {-0.41348885663813567`, 
            0.8004229851280871}, {-0.37381421381186236`, 
            0.822006741358056}, {-0.35390141237946493`, 
            0.8315825129479433}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{-0.3499360813136293, 
            0.8334893819886272}, {-0.3330162616183717, 
            0.8416258729436499}, {-0.2912876136336434, 
            0.8591550740856021}, {-0.24862826985767741`, 
            0.8745943447839128}, {-0.20503823029047374`, 
            0.887943685038582}, {-0.18480369836594857`, 
            0.8935950544567629}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-0.1805648204862771, 
            0.8947746400107193}, {-0.15615941075248976`, 
            0.9008617494956038}, {-0.1303057090202458, 
            0.905382975959736}, {-0.10429907179866864`, 
            0.9091615673535773}, {-0.07820461258990413, 
            0.9121887598310009}, {-0.052000626893237034`, 
            0.9144674746740492}, {-0.007532071621512163, 
            0.9178785883175911}, {-0.006382867987312779, 
            0.9179100526748802}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.0019845162345061883`, 0.9180304763377676}, {
            0.037034179296832365`, 0.9190987797616512}, {0.08169812586179653, 
            0.9181280490062304}, {0.1264597680733803, 0.914966396051328}, {
            0.17110079705352155`, 0.909614457002706}, {0.17352425793458748`, 
            0.9092019089930912}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.17786185804481594`, 0.9084635152744382}, {
            0.21540290392415806`, 0.902072867966126}, {0.2593660886852899, 
            0.8923416289415878}, {0.302990351336917, 0.8804207399290914}, {
            0.34606052332281245`, 0.8663559544351407}, {0.34826451702598116`, 
            0.8655138214823833}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.35237469991376186`, 0.8639433449212738}, {
            0.3883614360867491, 0.8501930259662391}, {0.4298930896287272, 
            0.8319319545223871}, {0.4706554839487466, 0.811572740103584}, {
            0.5074130651932037, 0.791041350992928}, {0.5111907035317609, 
            0.7887084622634596}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.514934373542201, 0.7863965507485154}, {
            0.5433430548679854, 0.7688527081292944}, {0.5783431187562172, 
            0.7450445771515759}, {0.6123109226410253, 0.7196547236986657}, {
            0.6451441323055347, 0.6927209134094561}, {0.656594347021695, 
            0.6824145067406892}}]}, {
           Arrowheads[{{0.020000000000000004`, 1.}}], 
           
           ArrowBox[{{0.6598646689325216, 0.6794708704520884}, {
            0.6767404135328717, 0.6642809119228407}, {0.7069974321061615, 
            0.6343724848777118}, {0.73581285380853, 0.6030333979129624}, {
            0.7631734415301775, 0.5703544001723552}, {0.7786932516152354, 
            0.5500493471252821}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.7813652081787038, 0.5465535427653475}, {
            0.7890933726557883, 0.5364425434165354}, {0.813511434710215, 
            0.5013600472097204}, {0.8363664152183099, 0.4651691311161273}, {
            0.8575971017049252, 0.4279320146999738}, {0.8734697745342964, 
            0.3968925987958402}}]}, {
           Arrowheads[{{0.010198369270205518`, 1.}}], 
           
           ArrowBox[{{0.875473071960121, 0.3929750996670995}, {
            0.8771422816949136, 0.3897109175254767}, {0.8949407427131271, 
            0.3505680591568536}, {0.9109312722844182, 
            0.3105656591583219}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.0183323256468225, 1.}}], 
           
           ArrowBox[{{-0.3129288375842825, -1.0935885531633533`}, \
{-0.34138051286456983`, -1.0783953740076186`}, {-0.3693790723408337, \
-1.0629386322804717`}, {-0.39727959495087134`, -1.0460927435885155`}, \
{-0.42469704307329986`, -1.028935248629791}, {-0.45162038496016466`, \
-1.0113575323747068`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.014621651998234841`, 1.}}], 
           
           ArrowBox[{{-1.0990580919247468`, 
            0.3022979323237224}, {-1.0839936131210537`, 
            0.33084592824287046`}, {-1.0686850043770255`, 
            0.3589416409388197}, {-1.0521682294136867`, 
            0.38672679911231334`}, {-1.035356928973037, 
            0.41404006200153803`}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{1.1, -0.8009103458669569}, {
            1.0755766383909708`, -0.8032446218645519}, {
            1.034334537987771, -0.8115571914470291}, {
            0.9964337270713813, -0.8210342363613102}, {
            0.9597190460156384, -0.8308800663911917}, {
            0.9288379827136232, -0.8403967702435552}}]}, {
           Arrowheads[{{0.0038119529550538272`, 1.}}], 
           
           ArrowBox[{{0.9226219424157533, -0.8518534984609509}, {
            0.894908750062922, -0.8518534984609509}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.013693995914687476`, 1.}}], 
           
           ArrowBox[{{1.0973214514038605`, -0.2132352625880385}, {
            1.0864057806437009`, -0.24207464527712924`}, {
            1.0750498215325093`, -0.2705480099467181}, {
            1.06288234961083, -0.29751896775805575`}, {
            1.050313720577872, -0.3241281901223371}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{-0.9752833470780162, 1.1}, {-0.9508318465617083, 
            1.0912025379067247`}, {-0.9189194959806453, 
            1.0807853839096315`}, {-0.8900373546597928, 
            1.0728701101391132`}, {-0.85380037677558, 
            1.0665293030696608`}, {-0.820344745496237, 
            1.0622994272800714`}, {-0.8044474031976769, 
            1.0606009168911947`}}]}, {
           Arrowheads[{{0.014195888213204418`, 1.}}], 
           
           ArrowBox[{{-0.8000723038747916, 
            1.0601334707286396`}, {-0.7879286520839116, 
            1.0588360136859252`}, {-0.7575916344056213, 
            1.0569055244826646`}, {-0.7289400649288851, 
            1.0561709082342288`}, {-0.701580316121222, 
            1.0562951135045562`}, {-0.6753009625906544, 
            1.057099270561819}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.8349541538169711, 0.46063392278328114`}, {
            0.8574081119232027, 0.420578322645375}, {0.8779632485311921, 
            0.3793141759488675}, {0.8965132238768141, 0.33703780870863664`}, {
            0.9099904187005814, 0.30170832520645974`}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9115586620173959, 0.29759728970439137`}, {
            0.9129516981959429, 0.29394554693956026`}, {0.9272786714885787, 
            0.25003739064163855`}, {0.9394941437547213, 
            0.20531333981487132`}, {0.9457999154583969, 
            0.17981162186926805`}, {0.9513985713086073, 0.1541157891512358}, {
            0.9551928855879745, 0.1283022718595557}, {0.9552976285558838, 
            0.1274249653819719}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9558192468072777, 0.12305599360364547`}, {
            0.9582880260826038, 0.10237798444274053`}, {0.960679169203156, 
            0.07639885375795034}, {0.9623679228127444, 
            0.050346237519465174`}, {0.9648734298704152, 
            0.0038490827677919613`}, {
            0.9650987721861203, -0.042656505086709554`}, {
            0.9646614917376298, -0.05255501100399777}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9644673049276509, -0.05695072385663388}, {
            0.9630439497598601, -0.08917052604403934}, {
            0.9587089625916342, -0.1356929801041974}, {
            0.9521108703361635, -0.18199855734874695`}, {
            0.9432667326481687, -0.2278619478592512}, {
            0.9424263150625908, -0.2313039810517628}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{0.9413826561759348, -0.2355784138946443}, {
            0.9321765495276501, -0.2732831516357102}, {
            0.9188403209746071, -0.3182621686781239}, {
            0.90331943399909, -0.3625824838931493}, {
            0.887021428540441, -0.40271295844363014`}}]}, {
           Arrowheads[{{0.019999999999999997`, 1.}}], 
           
           ArrowBox[{{0.885328891311143, -0.4067735334168042}, {
            0.8659078458107823, -0.4485974635610057}, {
            0.8440171445979918, -0.4902921280138368}, {
            0.8220422959438327, -0.5278431681853596}, {
            0.8007404368102943, -0.5608533577344471}}]}}}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          GrayLevel[0.5]], {{
           Arrowheads[{{0.020000000000000007`, 1.}}], 
           
           ArrowBox[{{-1.1, -0.873559946641139}, {-1.097445233026861, \
-0.8653289031187493}, {-1.0883466377986333`, -0.826267344745599}, \
{-1.0821480277036266`, -0.7907329590812711}, {-1.0781148452082823`, \
-0.7579029214900458}, {-1.0754999433562071`, -0.7269419420792024}, \
{-1.0739698956288606`, -0.6999299076754033}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0737752414487802`, -0.6955347057994942}, \
{-1.0730809262745402`, -0.6690322353056378}, {-1.0732768110449484`, \
-0.6420835079429167}, {-1.0742612809254446`, -0.6031403037280252}, \
{-1.0762183756795698`, -0.5659114691607837}, {-1.078994157533836, \
-0.5321680392857413}, {-1.080111488453735, -0.5197725924731432}}]}, {
           Arrowheads[{{0.02, 1.}}], 
           
           ArrowBox[{{-1.0805065047849127`, -0.5153903599259017}, \
{-1.081962422385915, -0.49923869987126}, {-1.084804696325679, \
-0.4667718855725354}, {-1.0876271373231707`, -0.43488478483783577`}, \
{-1.090361062464227, -0.4025153184918204}, {-1.0928319740471695`, \
-0.3705123181767565}, {-1.0949621516021102`, -0.3399894251399051}}]}, {
           Arrowheads[{{0.003187141162706196, 1.}}], 
           
           ArrowBox[{{-1.0956783407467254`, -0.3145937686710041}, \
{-1.0965501250667398`, -0.3145937686710041}}]}}}}}}, {{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[0.006944444444444445], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwll3k4Ve/XxkVJyZRoMDWamgwpqSxSRBFpEkWSVPomRMrQoEijSqaSeRZC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          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[0.006944444444444445], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwll3k4Vd/3xyWkiUgpEQ2UUjSJpiVFVIaoEEqmUKE+iWSolDKFkCEZM8uU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          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[0.006944444444444445], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJztx78LAWEAh/EXGUhKZPTjZJDNQgavSeoMstwgiShJGAwSMSilGLDYLC6D
YjTda1Q2i0UysJhuIEpJ8kdYvs/y9LGnS7GskhByUxDy/S+Z/n6iRGwQuVll
G+97POKmVCtsws5rjRUqN2P/3KYzh6X+SOWYz6eyHt1J2po0hPsiypYRiZ+I
HM0fZP9s62FFS8hU7JjZSsMP4i4Dq3bXCtGtZ6bA8L1fXKTy6zRPRJ4SUYdt
vWAloJMzj93rCMMwDMMwDMMwDMMwDMMwDMMwDMMwDMN/8QeLNfrK
          "]]}, {
         Hue[0.37820393249936934`, 0.6, 0.6], 
         Directive[
          PointSize[0.006944444444444445], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJztx/831XccwPGrqzJMadJ1xfGl2uRoYkRfvG6+lW8dV82WY6srV2tLTqlW
abgu4nayXN+uL4tulHZ966pZrM+rcd20Wt24VxldV75cqYQsbomdTv/Fzvv5
y/M8bKPiwrjzaDTapB6N9v4fGoMP10BR4fvG4ebZvFwz3nnMnX9qaf7jMRhW
iAv4NRXIuJSLtTfG4MtnexNy2V0YGBcddDZnFOjKhPFjyk58ZCQ2kStGQJ/r
ZHa5oReFsqo1RvpDcH2fbHB7Rz8K1OZtfVEacE/1MzQKG0JfyTrr2nYlMJss
q75gaNGw0GOzxLUFcgda3cX0IUw2073UZgpAKsnYeWZnP0augAfteAUbe5/a
2g72ou9FWVbbZ03oktK46lVsF/6bWTkzfxuF9/kSm+t6Sjxqfa/IrZXC3Raj
Nzir76PGzuCCvzGFGX7JU6GvbiGT1zFoXfoHft+/8dDM4mYUCVs4FpJGLFn8
rlSU14iTFW9LBsN+x+b40r0TI1J03ufmUdd0DdNSuyf6rl5GdlqfYpNhPZou
E9jxA8tQeeVJe/W3dVgHqxauDBIiK6uhcFe5BBn08iD3uUTMKp7QX/LiItJs
ULdozxpMorePc6vF6IvnbLKPxkOrWemzid5f0GHto+p9a5OBlygRQmwB2nkr
y1cr+HCsemYqV5eN+/9eYH8pPA0aUrVa3pAAocLpq/JdafBYKGpoS+djTOIW
7gtuKmRbzjF3eSdgx4YtAQ/aUoCpE86m0A+h+XVTVZIiGdSHagxyHnHRYzpQ
zzX6JzhgyLnzdUI4NpsHaGtXHQfW6Xxaa/RGbN/x2jzd8giUjYrPCfSdILzH
ylYTdRBSZOq7C77zg6TKvxZ4We2HBG/fiNLXIaAYLmFtDY6BMUeeTZwjG+QB
p59TYRxYeZCz58ZDNqiNC65qgyOAxa6JnDrCBpaFsule7HZwZZhL2VGhIOzL
sP3hZhCE1FZU9shDYODUyeOCCW/IX5vOY0QGgrRI9PilhwfY8HurGhT+wNCU
5myod4QTncYP/9npA9Nl8k/t5Qzw1DH74pgsKDOM93PiaL2cqnwYz7ethxnZ
do7e5EJUFbhbmyxzA+nFtN9GTizFYz/G1xzIcYb1zbrb5QNMnB2cbUtPcgBF
j1I+GWCFdx1dVty1tQe71MNd0gwr3Jph8TRUbQlmFhaCrNDlmCVWnR/N/ARS
W9rz7zgwkT2yO6/q3UegUpnEViYsw9k/3dZ198x5OVcU790kNEP/c5KoEfmY
1/l7yT6NF0xRVJg96+ny0GtK11U2evljrJNv5mk8KconBOc1nDBAQdolqeeb
bipCFE5nKeko2mZcr79hgPpm7oz4LX+OsgtO1FQkaak194tiDmdOU0Ult5qb
i4ap6B0+ar2qCUpZmR/2q8swFWPXyLCUPKO65DUn1beHqOCIJSbVqn7K4Nqb
5TmyAeqaai4737Ob+tl1wEoR+4SK7ByXFgseUNx1HfM+n+6lkoMYtLoIGTEx
MTExMTExMTExMTExMTExMTExMTExMTHx/8r/AZduHAc=
          "]]}, {
         Hue[0.6142719099991583, 0.6, 0.6], 
         Directive[
          PointSize[0.006944444444444445], 
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwll3c0l//7x5USUVZkJLSsUopE5SIZ+VDS0kBJKSOUomhoSVkhRSoiREIZ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          "]]}}}, {{}, {}}}, {{}, {{{
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                DiskBox[{0, 0}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.368417, 0.506779, 0.709798], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.272]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPA/AAAAAAAA4D+6
iS7BG9TwP3mpkefPSMk/kuVlZjOU8D/pleBFAje4v8/1Jmczd+4/btnqRIBx
179Lw7dQDbzpP+qLyNebS+O/3BP3vStI4z/lAhVmfknpv4JE++agHdc/RGa4
Y1hQ7b+K5UKtx+e4P+hdGYaAHu+/JjVGsmTIxb+CNioIlpnuv4b29FxDAdu/
LzANQa7Q678qCt8/3Hnkvw/8LahQ/Oa/YRQLUAPd6b/KX5KJrXrgv+zdU1ZN
Ru2/X1H8odyR0b/MsFP0u3juv0voBxUNxo6/+jCAFXZg7b/yPNPyf0HPP6px
ZBv0FOq/sJ7VACj33j/QvFJjTNfkv0C7vE7X9OU/em61RSca3L8olaNy48Dq
Pxgf+Lwj6Mi/jSEzR1SF7T/AA1qeIVewP6w9n5vsDu4/BQGG0pdF1D9QDGs7
21TsPwl5JPlpcuE/7cUr7Z156D+0IMAxhG3nP0dTiZBDyOI/4gOjMRqh6z89
HzxNAl7XP/Px3KSrve0/YIogx1W9vT+0Q6s6dJvtPyTRpRBtEMK/Y5HoTdg9
6z+uksOxccvYv/l9liId0+Y/eEkAooRV479kbde0eLDgP/696ul2zei/1jXA
HpGa0j/xaoAcvmTsvyYdKE7yhqM/wkjeZszW7b8D1oq1gMjLv8vuutdECO2/
bwnJ4tcp3b8JizBqKgnqv7yNiLuKHOW/9BSfvGkT5b/v3Ws0tgrqv64cwfn/
Dd2/KcXrMPUA7b+2QYFpg4zLv3Gyin9yxu2/7GbDBCdKpD+kYLgDlkzsv0g5
rvq5pdI/LCVyhBqw6L/i9JTnHazgPy0kg7tKNuO/lrpMh+/B5j95t5MSwpPY
v0xncwg5H+s/RA/aHgHDwb+O6r6S/m/tP1pxdmYe7L0/bLjmh72H7T9m2Nru
70XXP8dVCFHUZOs/JEeXfeSm4j/LQgwQRTDnP8WWoy2AQeg/OkUnzoA74T9u
WzYw8QbsP6UDJXdh9NM/5iRS2IWu7T+a29Fe+YevP55AGvJlGO0/9pTJjb27
yL9drTB490/qP7Qz7ilMvdu/wiSscg==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.880722, 0.611041, 0.142051], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[6.72]], CompressedData["
1:eJwBNQPK/CFib1JlAwAAADIAAAABAAAAAgAAAAAAAAAAAPA/AAAAAAAA4D+4
4h7BCMrwP8POP54Bgc0/CFaTAWW68D/4EbNCI1Ggv4R05VAelO8/9pjLSh70
0b/wx4tk6ATsPw422yoYK+C/cSb8dTv25j+DgaYi+EDmv/0jkpIDr+A/ibGB
NBvt6r+Uy8eHChTTP3poyOk+8u2/Ns5c/v76rj+Un2cRwSnvv0hK872pwca/
AqinkyWG7r8KnIBpAszZvw7vNuK8FOy/6+6U1LZG47+J6XGUJ/3nv4aQ6On6
c+i/HoaW/w1/4r/0B24ALiLsvyNPl7S739e/FsvmJtcb7r+LgZKqctDCvyI2
c7IuRe6/Bf7WKl4utj/HQTGFy53sv1YOH4MSGNQ/N/M1hDpA6b/Gvtv2xq/g
P/L9vCHGYeS/HD7KeTxM5j+4Em6yrpzcv/9q+qO2jOo/tW+FXBiPzb8adh0D
QjHtP/RX74t0D1m/Lfz0wYwS7j8Lt8dIahrNP8rwwPcLJO0//BC6JPVJ3D9N
TjcTtHTqP9t81Fx5JeQ/ngqWPVgv5j8rXZkSY+zoP0Sf67VZluA/RBIwPecw
7D/P0UO9ogDUP5TaJJRuwe0/gnTr1v+Wtj8i1itA7IXtP1avUDY5DcK/NYBU
HQ+D6z+ozuTYGyLXv7xPIlWV2Oc/2YXCd+/p4b+70Oxvbr/iP3GdjPd9LOe/
4cNoU/kM2T8x5uV7Dwjrv1oFUL0qN8Y/A5C7e1NB7b+xtjwHlu6rv6e+Maoa
tu2/FAAuOMTd0b9KO/AnTWDsv0NWMBnYJt+/1N7u+uFU6b/t1Ew1SEblv4Tp
AZkYw+S/swn9Rc6v6b/n01GnP+Pdv5QMRvt7i+y/NCttp0J00L/+gXEO+K3t
v8B5X5XQTKC/8Toqhx8G7b+ubkL1efzIP7qlRMBOnuq/6tw/RThD2j+41Pqs
05vmv3SdOtuPOOM/UsSt6nc84b+h9xZA2yXoP5wfuu3GptW/ZCpL+2Gd6z/w
n253WB++v4e0I3wlau0/VDRugNcnvD9lFwbpj3DtP5fx2e3YLdU/hb2XfWaw
6z/YOOQl3gThP2a+BH7LROg/5Q+w6w==
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.560181, 0.691569, 0.194885], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[8.16]], CompressedData["
1:eJxTTMoPSmVmYGAwAmJGIGZigIEP9hD6gT0Dq4dCr0OJHc+HlO+Xft/bRy8+
Lxqfe4Dtp7b51PYPrcOH1uFByD/0th8XHwC0iHwr
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[
                 
                 NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                   1, 1 - 3^Rational[1, 2]}}, {{0, 
                   1}, {-1, -0.7320508075688772}, {
                   1, -0.7320508075688772}}]]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.922526, 0.385626, 0.209179], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[7.6]], CompressedData["
1:eJxTTMoPSmVmYGAwAmJGIGZigIEP9hD6gX3E9k7F+FWJ+38222lN3vlof7qR
GLcy/6b9SlpWzgGhs/eXvMv/pqdVtr8h8Xb3202N9o9lPhgVrw6wP5SSnr5n
k5/9MVNj9WvLlO3zJV6tmNwsu/+YvlFV55zn+5Ljf72y+/B9X6r5ZSb9H/f3
NXhLMGyIOrIvDY1PqXwKiXyY/kYc5pPqHnTzSZWntnmE3ItLfSOF4Umt+CTk
XlLTA6n2AQDfSHyP
          "]]}, {
         Directive[
          PointSize[
           NCache[
            Rational[1, 90], 0.011111111111111112`]], 
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         GeometricTransformationBox[
          InsetBox[
           BoxData[
            FormBox[
             StyleBox[
              GraphicsBox[{
                EdgeForm[], 
                PolygonBox[
                 
                 NCache[{{0, -1}, {-1, -1 + 3^Rational[1, 2]}, {
                   1, -1 + 3^Rational[1, 2]}}, {{
                   0, -1}, {-1, 0.7320508075688772}, {
                   1, 0.7320508075688772}}]]}], 
              GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                  PointSize[
                   Rational[1, 90]], 
                  RGBColor[0.528488, 0.470624, 0.701351], 
                  AbsoluteThickness[1.6]]}, StripOnInput -> False], 
             TraditionalForm]], {0., 0.}, Automatic, 
           Offset[7.68]], CompressedData["
1:eJw1kHlM0gEYQClXtNw8IjOoNDuxtjJInWR9mE6cS9ZcOvOIKVnOZjYprUTX
QrtNTTfUrOzyQC1Fabasr0TLIszQPKkAMc4f0rpMs3Jrve3t/f+8ktIjkx1I
JBJj1jmzziX9xw7/qoH9w7kShsoO5pmiNXHUVyBRNTmWV9jBfnK0eMVrGWr4
vq7Hr9nAesX3TnfnAI5517GZv01AWzDPueinDutaFdzp22NQEvWqg0I2YXMI
rXzlzCAc3ui0snIdgSe4Tyb48nZQM19MdlAmkOFzIO25So4LWQ0VLs02pBZO
Nrm5j6DQlxnDW2jFxvANcuMSPSYHHW5ZFGXAnlW/c6SlJqRd3JVzwapB7KWe
dPIk8Gzin+MRYhVGdGuK4zNtOO3KTnHgVmELN6pZJSJQt/2oJIiuBN2Gu2H6
ODOa2MElIfM/AGdPVZcycBxTO3kTDSXjoIxE772U99jhtuJMQ64ZAs850y+5
KrCVKvBKOEgA4zGrUNdXA9LeJN4Ddxv4ZZMLAgL6QO7mX2kSWaFjX1OjeUYD
vRWZoacURpAFcMVlFAO45HGThvzGoKz55c6qFAs8Ck4XjPKHoFtd/2tCQsDq
SodjtMXPoL/6DGjvE+BUUSte3Ybocjq1eDTLAp7SjGn6i0G8nkdScDYZwNb+
JW+9UYdft6aY+9dq4b3HFHjmGLEuP+ZnT00f6GRdmOZvRaL219XSxAZ4EB58
afDN7H9hzpaCqpd4waErejGdQPWyHd8XMNTYJ/XI94swI2tSICC36VFJYqxL
yxzHKb9Dse5dJvzGyFv+dO4HFByrb9v70Yq7Zek+XveUKKx3jGYpCFyy5YjH
Y1cxjDax9/tnWbGGR9mWePUt0N9mU31mjNh5dlWa2l8DmuKbw+9ujKGd2y0L
P/gJAp3rqy8WDqM4lOKo15thpI4fVDouR/bTmwJGLAGXN/ccGbz9EJZW04UW
MQHa0Eg+cgaAN5WsLSi3wE6ONzNkmw7iCWyMzTdAav8tUcxnA4g4W3OjJVo4
mkGWeg1Z4BPFzj//tR9oYQpO4h0CXstaBkSkVtgVkeWdySSAnEGGotrnKHQb
zv5RYIaEQ2WeLOUI/gXiKacF
          "]]}}}, {{}, {}}}}, {
    Frame -> True, DisplayFunction -> Identity, PlotRange -> NCache[{{
         Rational[-11, 10], 
         Rational[11, 10]}, {
         Rational[-11, 10], 
         Rational[11, 10]}}, {{-1.1, 1.1}, {-1.1, 1.1}}], DisplayFunction -> 
     Identity, AspectRatio -> 1, Frame -> True, FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, DisplayFunction -> 
     Identity, AspectRatio -> 1, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*StyleBox[\\\"y\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
        TraditionalForm]}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Medium, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRange -> NCache[{{
         Rational[-11, 10], 
         Rational[11, 10]}, {
         Rational[-11, 10], 
         Rational[11, 10]}}, {{-1.1, 1.1}, {-1.1, 1.1}}], PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"AdaptiveEG+\"", 
       InterpretationBox[
       "\"\\!\\(\\*FormBox[\\\"2\\\", TraditionalForm]\\)-step EG\"", 
        StringForm["`1`-step EG", 2], Editable -> False], "\"MDEG\"", 
       "\"CurvatureEG+\"", "\"EG+ Adaptive\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.272}, {20, 6.272}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.08426020408163262] -> 
                    Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 6.72}, {20, 6.72}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.72}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.051309523809523805`] -> 
                    Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 8.16}, {20, 8.16}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 8.16}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.03009803921568628] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
              
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 7.6}, {20, 7.6}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                    1, 1 - 3^Rational[1, 2]}}, {{0, 
                    1}, {-1, -0.7320508075688772}, {
                    1, -0.7320508075688772}}]]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 7.6}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.002105263157894735] -> 
                    Baseline)], #4, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 7.68}, {20, 7.68}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, -1}, {-1, -1 + 3^Rational[1, 2]}, {
                    1, -1 + 3^Rational[1, 2]}}, {{
                    0, -1}, {-1, 0.7320508075688772}, {
                    1, 0.7320508075688772}}]]}, {
                    DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 7.68}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.006354166666666661] -> 
                    Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "90"], "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}}]}], ",", 
                    RowBox[{"Offset", "[", "6.72`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[{{0, 1}, {1, 0}, {0, -1}, {-1, 0}}]}], ",", 
                    RowBox[{"Offset", "[", "8.16`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, 1}, {-1, 1 - 3^Rational[1, 2]}, {
                    1, 1 - 3^Rational[1, 2]}}, {{0, 
                    1}, {-1, -0.7320508075688772}, {
                    1, -0.7320508075688772}}]]}], ",", 
                    RowBox[{"Offset", "[", "7.6`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    PolygonBox[
                    
                    NCache[{{0, -1}, {-1, -1 + 3^Rational[1, 2]}, {
                    1, -1 + 3^Rational[1, 2]}}, {{
                    0, -1}, {-1, 0.7320508075688772}, {
                    1, 0.7320508075688772}}]]}], ",", 
                    RowBox[{"Offset", "[", "7.68`", "]"}]}], "}"}]}], 
               "}"}]}]}], "]"}]& ), Editable -> True], TraditionalForm], 
    TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.904680643196373*^9, 3.904680780537944*^9, 3.9046808168819227`*^9, {
   3.904680939782234*^9, 3.9046809668294992`*^9}, {3.9046810088523493`*^9, 
   3.904681019535927*^9}, {3.904681059518063*^9, 3.904681089182433*^9}, 
   3.904681163068296*^9, 3.904681196244351*^9, 3.904681228567741*^9, {
   3.904681295917961*^9, 3.904681315647586*^9}, 3.904681460883649*^9, {
   3.904681497245674*^9, 3.9046815217818604`*^9}, 3.9046816212738323`*^9, {
   3.904681717294569*^9, 3.904681755225898*^9}, {3.904681823347838*^9, 
   3.904681903641996*^9}, {3.904681936073902*^9, 3.904682011996291*^9}, {
   3.904682145936627*^9, 3.9046821609628973`*^9}, 3.9046822562052717`*^9, 
   3.904682344759131*^9, 3.9046824403140163`*^9, 3.90468247155002*^9, 
   3.9046825501144238`*^9, {3.9046827513642807`*^9, 3.904682847009766*^9}, {
   3.904682895012501*^9, 3.904682902690345*^9}, 3.904683020411564*^9, 
   3.9046831476611853`*^9, {3.9046831840485773`*^9, 3.904683250506708*^9}, {
   3.904683284200385*^9, 3.904683351968749*^9}, {3.9046833986014214`*^9, 
   3.9046834127635937`*^9}, {3.9046834986151857`*^9, 3.904683561388508*^9}, {
   3.904683645359761*^9, 3.904683663822613*^9}, {3.904683725464981*^9, 
   3.904683745488326*^9}, 3.9046837849943857`*^9, {3.9046838650059137`*^9, 
   3.904683902610824*^9}, 3.904684020088187*^9, {3.904684056094061*^9, 
   3.904684091144416*^9}, {3.904684135562866*^9, 3.904684140839593*^9}, 
   3.904684291734256*^9, {3.904684405478045*^9, 3.904684421391037*^9}, {
   3.904684462615758*^9, 3.904684529111066*^9}, 3.9046846787736*^9, 
   3.904685301634338*^9, 3.904686800171452*^9, {3.904686928356135*^9, 
   3.9046869531162148`*^9}, 3.904687046697579*^9, 3.904734699584383*^9, {
   3.904734807395198*^9, 3.904734827118947*^9}, 3.904735523969082*^9, 
   3.904735604143405*^9, 3.90473570903111*^9, 3.904735753895398*^9, 
   3.904735962968754*^9, 3.9047360166159153`*^9, {3.9047360537048903`*^9, 
   3.904736080722252*^9}, 3.9047361433217373`*^9, 3.904736211320139*^9, {
   3.904736301949736*^9, 3.904736335821913*^9}, {3.9047364065377827`*^9, 
   3.9047364476816072`*^9}, {3.904736520769437*^9, 3.904736535314979*^9}, {
   3.904736920940432*^9, 3.9047369556262493`*^9}, {3.904737132276061*^9, 
   3.904737173358301*^9}, {3.904737256850163*^9, 3.904737282861266*^9}, 
   3.904737328109385*^9, 3.904739494825601*^9, {3.904739565153618*^9, 
   3.904739595114736*^9}, {3.904739636728263*^9, 3.904739660812203*^9}, {
   3.9047396969065533`*^9, 3.904739776029087*^9}, 3.904740145471875*^9, 
   3.904740654209096*^9, 3.904740699766966*^9, 3.9047407831828003`*^9, 
   3.9047408135413933`*^9, 3.904741697115147*^9, 3.904741774122334*^9, {
   3.904742049913468*^9, 3.9047420788271713`*^9}, 3.904742138396843*^9, 
   3.904742224087797*^9, 3.904742278650795*^9, 3.904742575205922*^9, 
   3.90474289256909*^9, 3.904743757728841*^9, 3.9047439470376797`*^9, 
   3.904744056273604*^9, 3.904746046568783*^9, 3.904746252258511*^9, 
   3.904746292534446*^9, 3.904746396804057*^9, 3.9047464329903183`*^9, 
   3.904746467338516*^9, 3.9047465016188*^9, 3.904746551648592*^9, 
   3.904746743991631*^9, {3.904746814781958*^9, 3.90474683727043*^9}, {
   3.904747507973131*^9, 3.904747531833601*^9}, 3.904747672908682*^9, 
   3.904747866409636*^9, {3.904751462773683*^9, 3.904751489846736*^9}, {
   3.9047518182187653`*^9, 3.90475184181327*^9}, 3.904753318950343*^9, 
   3.9047542461447477`*^9, 3.9047542763350687`*^9, 3.904755125737275*^9, 
   3.904755192202413*^9, 3.904755252965486*^9, 3.904757174462379*^9, 
   3.904757318141162*^9, {3.904757382861109*^9, 3.904757411424984*^9}, {
   3.9047586949327087`*^9, 3.904758704725155*^9}, 3.904758774366029*^9, 
   3.9047588994096622`*^9, 3.904759219298182*^9, 3.904759286730081*^9, 
   3.9047594211952457`*^9, 3.904759885219304*^9, 3.904760407170834*^9, {
   3.904760444176717*^9, 3.904760458491859*^9}, 3.904760493815995*^9, {
   3.9047613827246513`*^9, 3.904761418723529*^9}, 3.904761634776657*^9, 
   3.904761853832629*^9, 3.904871754455896*^9, 3.904871838659329*^9, 
   3.9048868299982758`*^9, 3.904887625502769*^9, 3.9048877044282827`*^9, 
   3.904887772519225*^9, 3.904977626483691*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"9ec73576-d57f-4e76-91dc-4959fdee7b95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Fzbars", "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Last", ",", 
     RowBox[{"{", 
      RowBox[{
      "AEGPlusIterates", ",", "EGnIterates", ",", "MDEGIterates", ",", 
       "CurvatureEGPlusIterates", ",", "EGPlusAdaptiveIterates"}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MDEGSteps", "=", 
   RowBox[{"MDEGIterates", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CurvatureEGPlusSteps", "=", 
   RowBox[{"Indexed", "[", 
    RowBox[{"CurvatureEGPlusIterates", ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"norms", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Norm", "[", "p", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "orbit"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"orbit", ",", "Fzbars"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xrange", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"nstep", "+", "1"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"norms", "[", 
     RowBox[{"[", "3", "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"CurvatureEGPlusSteps", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "+", "2"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norms", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sequence", "@@", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"norms", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "T"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "xrange"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p", "=", 
  RowBox[{"ListLogPlot", "[", 
   RowBox[{"norms", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<operator evaluations\>\"", ",", 
       RowBox[{"MaTeX", "[", "\"\<\\\\|F\\\\bar{z}^k\\\\|\>\"", "]"}]}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{"legends", ",", 
         RowBox[{"LegendLayout", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Row\>\"", ",", "1"}], "}"}]}]}], "]"}], ",", 
       "Below"}], "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.904740231058855*^9, 3.904740299384026*^9}, {
   3.904740355165204*^9, 3.9047403561533623`*^9}, {3.904740473003118*^9, 
   3.904740534628036*^9}, {3.904742499448928*^9, 3.90474254779138*^9}, {
   3.904742594648654*^9, 3.904742689421267*^9}, {3.904742910367407*^9, 
   3.904742912286078*^9}, 3.904743412212469*^9, {3.904743556709174*^9, 
   3.904743576319222*^9}, {3.90474368786519*^9, 3.9047437081510468`*^9}, {
   3.904743806178113*^9, 3.904743835996441*^9}, {3.904743970726638*^9, 
   3.904743999787327*^9}, {3.9047445492692413`*^9, 3.904744667096581*^9}, {
   3.904744760934309*^9, 3.904744773053116*^9}, {3.9047448398014183`*^9, 
   3.904744842886072*^9}, {3.904744882453095*^9, 3.9047450030862017`*^9}, {
   3.904745083898131*^9, 3.904745108469357*^9}, {3.904745227491988*^9, 
   3.904745284049883*^9}, {3.904745605600359*^9, 3.9047456066306047`*^9}, {
   3.904746066550438*^9, 3.904746068680234*^9}, {3.9047463119321823`*^9, 
   3.9047463311927967`*^9}, {3.9047473888833857`*^9, 3.904747405332632*^9}, {
   3.9047575007049723`*^9, 3.904757534153143*^9}, {3.9047599353263397`*^9, 
   3.90475996295566*^9}, {3.904760365447863*^9, 3.904760368517179*^9}, {
   3.90476309376094*^9, 3.90476309398536*^9}, {3.904763708178728*^9, 
   3.904763712701501*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"6b1d677a-4be2-4b1f-af06-9176ad8927ad"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxdz3lUU4fWBfCAtSI4pFKHp7VGHGgpagCrOKAbUXGiRkARBQwgg0yGeYYL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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxdz3twFfUZxvEfUApiwSOIpfbiQqVVRDwStECxvBBAKLdjwlUElkDCNXAI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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxdz3lYVXUeBvDjGmgOGIY2LhwU0ByXq5KpubwgpiLmZXEBEQ6XTTHwBma4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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxdz3lsFlUYxeGL1KIVZGlRFKjD7oojLuz2hcq+jZW12nJbKGVR+AQXFis3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         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJxdz3tcjHn/x/EpIaw1cvazDNK2Dtuwbqeit5xyqpFyjqujzqZzTalL7qxT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         
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 1, Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0., -12.704257352250186`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         GraphicsBox[{
           Thickness[0.029205607476635514`], 
           StyleBox[{
             
             FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgAmJ+KJ0GBhwOdiWOtafnsDrA+Cmxd9yYd2jD+WdAgEcH
zj9/NeyNfrWOAwMINLDB+V/2fdyaPo0FO/+3Npwvs/yFh958BD9KNULm3B9W
OL9wecmGf/0saHwmuH0wPsw96PwW8VrWTDcWB3T/QfSLwu2D8WHugfFh7kXh
A/1Tef/HLeNuETjffc3R5QwzhDH4sPCC8WHhCePD3APjw9wL48P8A7MP1f+i
OPgsGP4DAAO7wKE=
              "]], 
             FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGJ1IAaxQYAJSjNCxZjR2DA5fGoGm15c5tDCTGq5gVpu
AwBUHQK3
              "], CompressedData["
1:eJx11X0slHEcAPDj9KKWq8TZvNxzznPXc+o5nCFpfatFrRZTK+tNeelKSlvZ
JIYiKyNUXnpR9Ee1MtYy0uhtolCs8oe1WKshbMeahNL9nud8f4v5bc8fn7t7
nuf79vudMiIuNFoqkUgsTFeE6bI0XRMj8d03luigKFeW6LNQDSGdjkkH83WQ
atVwydNXiz6wI1Rze7MWml6tLz9SojN/Pru3Ns1bc/2TFoKeJTv7GaiLik3r
N49uIeuhCm0sq2Ba/ajPdI126sddZ/hGmerJhIFap71v2+amBcMh01Kr0OVL
V9gYcqiTx/1PvJvPznDScGXI0TEOLeRfTV0NZ782FnHgcPWj9WFLFibJSuHg
dW1N9lyjG1zOzNj9IYCDoIcNdyU1Shg4fyzL66kD3B/pS2hJVUJOWFawxWI5
2J7OP9V6SgkZzDy25Yo9eOtN67ICnUDyeeCC7t4Yvu6a50yTMhY/sUMLz9Hb
iXHdoq7Z7h822UOdTeJoU6CzAjbXHopgIJG8d4udWL8OaglZRhVa6EO8G3qq
PlPPs7K+qIjMoU5fFFxxpYH6+8HSDm+ZeoaZ2tv10Tb26Kl8H/uOvoz6waK3
teft/RvJ/l+PNBW6Li5psDheBUkkvn7qHYMfhopK5WhhLr7I8X4hT3DAeflZ
P1RlKHCAI3HGjDfLWNhlbZ+pD3eFt2S+92vQUpIvz6G9SFrbOZDtC+ny+qVE
R5O6Biqnfc/AJrI/gjjoInGUMuJcazhxrh0ZeMQfv2PhxIFQLikDK5WKn7H2
nNjHSsWsFuZvjwLj0wy79V3jFOIch1GHk319gbqRzHMuvT+F9PeeOT8ZI/Zj
gTv0xriPFN5k0cJcVLEQte9zoHRUK+6nThYq2G/nSlqpdSS+Amqnkv1cc64W
fALqQgtemO9PMH+/e+p5HNwj+yhXBT3kvcmcOOcylfj+GA3a5W7vJn4tix44
WWU33qzG/Tk22P98lVQjnldLteZ50+B5INTDejn6/aedA7rV7ugVJH4fHr2V
zOMdXnzuBg79h5yreRq0cM7FUgt971GDcP7m8WLfg9TQS+LN4qGJ9MFDDc4k
nxQevobJq9u7WbTw+0bqNHJeFbJifW7y4EHiS2dBTs6rl9TlpB+D1ML+nKPD
fk7/P/gHVTB/gw==
              "]], 
             
             FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
              0}}}, {{{21.918800000000005`, 12.332799999999997`}, {
              21.918800000000005`, 12.678099999999999`}, {17.710899999999995`,
               12.678099999999999`}, {17.710899999999995`, 
              12.332799999999997`}, {21.918800000000005`, 
              12.332799999999997`}}}], 
             FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGI5IIaxWZDYzKNsmrABTqYCqw==
              
              "], CompressedData["
1:eJx1lAtIU1EYgKdZ0UOttbnVrrknaQXtvjIM6TfToCJDoba0pHKtB5XRJCyl
FyVppUlm2igswwJ7QGlFtB5mLx9p7zRaRREthTQxw8p27rm7Bwf9cLj345zz
///5X7qVm5JtQ2QyWYB3pXpXoHftCqovpOfyMIDErQEfuxPS48rHUrCw9XDa
33geSsu8YqVgwcPhscdNhGOzLWf5YMKjE01ZgSN5mNRt/FoeRcGBeZ4gLoCH
QktBUsAlDVhVV1tlLg7Oy6eG2N+pxfMcoOtl11VwZ1/VksfF7GBOJjwf2Vey
cAjpG6PG/IKBVJOFas5RA+z++OBYKgMyJDAeRiH9MYRVJc9HrJETPu12hTh/
0IP3nxJ+Je+Oe1JLi/aIPvtqJBowTz43rqWSEeNHwSwUj1gWbGh7WATczg2f
Ye9h8f4trRhPDr6fuqhtsujgUd3s82s3cvA2Krx64LJOirfwXqsBHDXK/oYL
PLS8WNwx7YZRYs8W7883wkfy9i59Rpkgs7qgfU3R//loUei26dsJC/47ePwN
MuH82njI6b60aH2bEfsxngcWyTMDjksLhznFANSJ5VENO/0YCH9aUfGSi+Bg
TtEe+ep8A7RrclYwn1nRvhHzGRbbrTHietnMSv7t6I/JbFYT9sXfx0L+LtPw
HtVrl34wbya8ZERYHpuul/IZj/yJ0Uv59rHp054TTR7CX9ZN6S3tpMX3iPd7
adhaV5tQliuen8yI9gw4/zcZaETiNOB++unH0azEQn04WOm+wFdYyHb3tbEz
DRCcdPGILVLsjzd6iOwMdpmthFGayrcSFvrxoN/5MsKCvrMcjodbL9Ujjp8O
5+uk6F+jVuo3RXaxo6kyAscrmQEn0veLggZUvxMZSEP9R1HwuzfrvfMDDXna
4aZGTpwnk3z9pMZ9U2vG/ZSplLhj34YCRkNY8KdVge3Xm8X+V8CqZW8Th7wm
fCW6726Gh7Dw/k4z9veeAs+PQBoSq+urZBYlrgeWhkg0n/aH4forofF7F6ih
53pb/p+hzGBOICz0SQYDPa6uGnuvCr+3ggFhHNwPw/OnnRH9UUJhisNYGspK
/vnq28dp2riuVU5OYt/8vZYSYxl4MAH85/M/ciNdvQ==
              "]], 
             FilledCurveBox[CompressedData["
1:eJxTTMoPymNmYGBgBGIVIIaxWZDYzEOMzQDlM9BI/UDZhYsNABB5AsM=
              
              "], CompressedData["
1:eJx1lX1MTWEYwK+0qIUNV20+qrnndO+x7vFV52PiyR+Ra2P5isYtlUUoS76W
EiUrqRGFOyPMR0ysKERlTT7TJI2stBrL/SMt1ajlPue997wz693O3vs793mf
9/k+PpvjQ2NGazSaUbYnxvY42Z5v22b1FQTK0JVYpv1TzIKDY+O7M140srBg
f9h1fz8Z2sM8HjS0sdARealpvhfljxN7gupdKHucbnSNdZIh5Y+c8LaOhVJh
oCb6twQzrn1fakxlYRhXqwQaXFUMFORNOBBQLEHdw/IclxIdwOH254Umyltw
TaGs6HOT4CDqH8uofMi5NnfOXsrEHwbCvYN+RrlLkJ+ZseF9C6PqS+4pWRkn
szBuxZ38GE+JnFvGwtQLmwyvvCWw4vlsyuVoWDnlGNTjoifxWCFCp7LrAdWe
+yaQ++P0UHP02rqXc0U4ghfV6iFqY0vw6H0iPEd/Vhog4Vb259g8EWZzNya9
SzeQ+AyLZDdzJB7hEqSjf/0cyUcl5QjU10w5HvV12/3psrNGBmFBZeiZag6q
0Z6TNnm05yplT8xbu2FEVuJ9zADNU5Mj55ZJ8AP9MxkA0zr8lXIqynnKKvdX
fMoaWiMDj/5doazE18TR/328erc3cUQ/IxM9sbMgd9VuXcFTSeWzuEIon8D/
W0VYXjcm8HwZB4swXnEi3GE6jlx4YyDvfwnE30498adGgAdKPvXEzyIBTmF9
WPTq+cnHl3U59xpJP+wQodS48/KoQSNcbn0y3pJov8+fH5EjVof6XgzhVX3O
rlleUTt5mIdrFWWl/k2U7+I97iL4Y74ieQjEfH8RoBD9Xs9DIcrHCar+l88W
3966UCDyQTzJOydAp9LHlB3+OLj+w1or/8gIzdi/wZSVejZTnob1XvU/K31e
RLkO7UihPNiX1GbZRdmM9m41kv67L0AbzgtvI4nb6QCyaxn4jnbnBEC0Utc6
lUswLo9HZj+snz06cAtmkpxuBpD3gTpy/zvKv7DetMK/zAj2eaSDF+iHUSD9
PqADNFNzwi4/5GvfHfXkC714PkMk9hZSJvOKVfke2muhbCmaWTGYyZL+SRNh
Ov4wsyT/yaI9T6w6LxQ/uhmVHfPMwa9xWXWQbUvz/AZR9S8N58ISSWVFzkJZ
yVODpMZT2a10viry02QSn4uM+n3QYj3l0++F4/vxF7da0HM=
              "]], 
             
             FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 
              3, 3}, {1, 3, 3}}, {{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
              0}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgAmJ+KD1jJhBE2jrYlTjWnp7D6gDjp8TecWPeoQ3nnwEB
Hh04//zVsDf61ToQcRkEvze4RGX6fRvs/N/acL7M8hceevMR/CjVCJlzf1jh
/MLlJRv+9bOg8Zng9sH4MPeg81vEa1kz3Vgc0P0H1r/GHm4fjA9zD4wPcy8K
H+iffpB78hH8A23Lw08ZYfJh4QXjw8ITxoe5B8aHuRfGh/kHZh+K/9fg4rNg
+A8AfdjnsQ==
              "]]}, {
             Thickness[0.029205607476635514`]}, StripOnInput -> False]}, {
          ImageSize -> {34.241693648816934`, 16.76741220423412}, 
           BaselinePosition -> Scaled[0.3160991284166821], 
           ImageSize -> {35., 17.}, PlotRange -> {{0., 34.24}, {0., 16.77}}, 
           AspectRatio -> Automatic}], TraditionalForm], None}, {
        FormBox["\"operator evaluations\"", TraditionalForm], None}}, 
     FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Identity, Identity}]}, {
       Automatic, Automatic}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
       "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Identity[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Identity[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0., 500.}, {-12.704257352250186`, 0.12683447907675108`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"AdaptiveEG+\"", 
       InterpretationBox[
       "\"\\!\\(\\*FormBox[\\\"2\\\", TraditionalForm]\\)-step EG\"", 
        StringForm["`1`-step EG", 2], Editable -> False], "\"MDEG\"", 
       "\"CurvatureEG+\"", "\"EG+ Adaptive\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.528488`", ",", "0.470624`", ",", "0.701351`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"\"Row\"", ",", "1"}], "}"}]}]}], "]"}]& ), Editable -> 
      True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Below"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.904743711879725*^9, 3.904743761132394*^9, 3.904743838092605*^9, 
   3.904743951260365*^9, 3.904744003307961*^9, 3.9047440593952913`*^9, {
   3.9047445533116302`*^9, 3.904744662708219*^9}, 3.904744775897482*^9, {
   3.9047448956495047`*^9, 3.904745005992625*^9}, {3.904745099573841*^9, 
   3.904745111396048*^9}, {3.904745258535687*^9, 3.904745286247486*^9}, 
   3.904745608983367*^9, 3.9047460710664377`*^9, 3.90474625542658*^9, {
   3.9047462967839603`*^9, 3.904746313940508*^9}, 3.9047464006970043`*^9, 
   3.904746438641596*^9, 3.904746471193988*^9, 3.904746507967057*^9, 
   3.904746555858864*^9, {3.9047467497557297`*^9, 3.904746754794518*^9}, {
   3.904746819463627*^9, 3.9047468386613607`*^9}, 3.904747378024078*^9, 
   3.9047474084717283`*^9, 3.904747707576429*^9, 3.904747877262314*^9, {
   3.904751826841715*^9, 3.9047518482186527`*^9}, 3.904753333508724*^9, {
   3.904757443729352*^9, 3.904757469735804*^9}, {3.904757526561977*^9, 
   3.9047575364826813`*^9}, 3.9047587129576674`*^9, 3.904759242178173*^9, 
   3.904759293391716*^9, 3.904759904082448*^9, 3.904759965258925*^9, {
   3.9047603940500517`*^9, 3.904760462297534*^9}, 3.9047604951199713`*^9, 
   3.90476186767023*^9, 3.904763097654921*^9, 3.904763716648655*^9, 
   3.904871761157076*^9, 3.904886837830727*^9, 3.904887629305881*^9, 
   3.904887708049693*^9, 3.904887775326461*^9, 3.9049776282894163`*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"aac3a9c6-590a-4d1b-882e-6d524e2a0946"]
}, Open  ]]
},
WindowSize->{808, 647},
WindowMargins->{{Automatic, 200}, {Automatic, 8}},
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) \
(2021\:5e746\:670819\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"3f4a9c5c-2e12-45a3-a804-7008ec4bbc55"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 541, 9, 44, "Input",ExpressionUUID->"98204e13-b355-4b54-98a9-c836aed98c0f"],
Cell[1102, 31, 201, 4, 30, "Input",ExpressionUUID->"bab72329-97d8-4917-958e-7fcc6cff511d"],
Cell[1306, 37, 11506, 302, 1523, "Input",ExpressionUUID->"4fc9de00-5343-4fd5-8bb7-8a6c47b7b7a2"],
Cell[12815, 341, 29112, 674, 3490, "Input",ExpressionUUID->"1f605237-06e1-4004-a2c0-dcfd70672f09"],
Cell[41930, 1017, 8634, 200, 654, "Input",ExpressionUUID->"07fe36ad-9c3f-4298-a221-e9ceb5f6393c"],
Cell[CellGroupData[{
Cell[50589, 1221, 3361, 71, 271, "Input",ExpressionUUID->"9f1bf222-de69-49af-9d91-79ef34383170"],
Cell[CellGroupData[{
Cell[53975, 1296, 421, 7, 24, "Print",ExpressionUUID->"625dcef4-637b-4a16-9069-285a1469e9b1"],
Cell[54399, 1305, 421, 7, 24, "Print",ExpressionUUID->"5929cd9d-70fa-4e6e-839e-def76cf5b53f"],
Cell[54823, 1314, 421, 7, 24, "Print",ExpressionUUID->"4992b1fe-cbd9-4b5d-af40-1d9fb0f19f76"],
Cell[55247, 1323, 421, 7, 24, "Print",ExpressionUUID->"63ead6fa-fe29-4621-91af-d967a6907394"],
Cell[55671, 1332, 421, 7, 24, "Print",ExpressionUUID->"e2b704d9-e422-4e93-8184-6465d9007344"],
Cell[56095, 1341, 421, 7, 24, "Print",ExpressionUUID->"95e5eb05-baf8-4ec9-8f7b-77637cf09f40"],
Cell[56519, 1350, 421, 7, 24, "Print",ExpressionUUID->"0b8d1ba2-5c86-4825-9b67-79365c24db6f"],
Cell[56943, 1359, 421, 7, 24, "Print",ExpressionUUID->"80f0a376-9e77-46e6-a5e7-74ba00381895"],
Cell[57367, 1368, 420, 7, 24, "Print",ExpressionUUID->"430be25d-59ed-4324-84bd-c1d606f1a5de"]
}, Open  ]],
Cell[57802, 1378, 244303, 4691, 429, "Output",ExpressionUUID->"9ec73576-d57f-4e76-91dc-4959fdee7b95"]
}, Open  ]],
Cell[CellGroupData[{
Cell[302142, 6074, 6046, 162, 602, "Input",ExpressionUUID->"6b1d677a-4be2-4b1f-af06-9176ad8927ad"],
Cell[308191, 6238, 47750, 908, 391, "Output",ExpressionUUID->"aac3a9c6-590a-4d1b-882e-6d524e2a0946"]
}, Open  ]]
}
]
*)

