(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    587616,      10757]
NotebookOptionsPosition[    585838,      10721]
NotebookOutlinePosition[    586245,      10738]
CellTagsIndexPosition[    586202,      10735]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", ";"}]], "Input",
 CellChangeTimes->{{3.904978257435008*^9, 
  3.9049782582180023`*^9}},ExpressionUUID->"11449d5e-9556-41cf-921b-\
74f9222ed9e4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"boundary", "=", 
   RowBox[{"5", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"side", "=", 
   RowBox[{"5", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"W", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "y"}], "+", 
      RowBox[{"b", " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", "x"}], "+", 
      RowBox[{"b", " ", "y"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", 
   RowBox[{"b", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"star", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Fz0", "=", 
  RowBox[{"W", "@@", "init"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", "L"}], ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.904770387474039*^9, 3.904770414116432*^9}, {
   3.9047705240900097`*^9, 3.9047706474924917`*^9}, {3.904770837648411*^9, 
   3.904770841145523*^9}, {3.904771019208428*^9, 3.904771055356333*^9}, {
   3.904771106188208*^9, 3.904771139907111*^9}, {3.904771314777027*^9, 
   3.904771315267153*^9}, {3.904771367885522*^9, 3.904771413113118*^9}, {
   3.904771620842895*^9, 3.904771635195174*^9}, {3.904771685701295*^9, 
   3.9047716887925577`*^9}, {3.904771760506145*^9, 3.904771763214046*^9}, {
   3.904771886017877*^9, 3.9047719695542517`*^9}, 3.904772015351798*^9, 
   3.904772091649585*^9, {3.904772152062714*^9, 3.9047721532637672`*^9}, {
   3.904772269487878*^9, 3.904772270154896*^9}, {3.90477287561826*^9, 
   3.904772876217616*^9}, {3.9047732286401443`*^9, 3.904773236409905*^9}, 
   3.9047732671138487`*^9, {3.904773974702134*^9, 3.904773979344844*^9}, {
   3.9047741525331793`*^9, 3.9047741559190617`*^9}, {3.904878124793112*^9, 
   3.90487812879851*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"c03cad2f-1a9e-4811-a10a-4fa17e0682bc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.904770608039817*^9, 3.904770650250087*^9}, 
   3.904770843413739*^9, 3.9047710570276833`*^9, 3.9047711528540154`*^9, 
   3.904771241054028*^9, 3.904771317430068*^9, 3.90477165671518*^9, 
   3.904771691313818*^9, 3.90477176536646*^9, {3.904771926813916*^9, 
   3.904771937736525*^9}, {3.904771971930634*^9, 3.904771980190344*^9}, 
   3.9047720175755444`*^9, 3.904772156716284*^9, 3.904772272183693*^9, 
   3.9047728779131327`*^9, 3.904773269916876*^9, 3.904773981747995*^9, 
   3.904774157971881*^9, 3.904878197771837*^9, 3.9048788227967157`*^9, {
   3.904879361067819*^9, 3.904879378440317*^9}},
 CellLabel->
  "Out[137]=",ExpressionUUID->"17c85c44-7c45-494a-9c42-6870b2230c60"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Fz0", ".", 
        RowBox[{"(", 
         RowBox[{"init", "-", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], ")"}]}], ")"}], ">=", 
      RowBox[{"\[Rho]", " ", 
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{"(", "Fz0", ")"}], "^", "2"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"StreamPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"-", 
       RowBox[{"W", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
     ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"StreamColorFunction", "->", "None"}], ",", 
     RowBox[{"StreamStyle", "\[Rule]", "Gray"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Blue", ",", 
      RowBox[{"Point", "[", "init", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", "star", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Purple", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"init", ",", 
         RowBox[{"init", "-", 
          RowBox[{"\[Gamma]", " ", "Fz0"}]}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pic1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5"}], "}"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.904770634721746*^9, 3.9047707341613703`*^9}, {
   3.904770857981759*^9, 3.9047708858710737`*^9}, {3.904770945383561*^9, 
   3.9047709693866262`*^9}, {3.904771029546075*^9, 3.904771054084504*^9}, {
   3.904771169830144*^9, 3.9047712601292877`*^9}, {3.904771327858869*^9, 
   3.9047713400964327`*^9}, 3.904771378709752*^9, {3.904771564661426*^9, 
   3.9047715815095263`*^9}, {3.9047716399390182`*^9, 3.904771653527923*^9}, {
   3.9047717009476957`*^9, 3.904771727509817*^9}, 3.90477194764509*^9, {
   3.904771985486721*^9, 3.904771999582747*^9}, {3.904772199177979*^9, 
   3.90477224131181*^9}, {3.904878186017768*^9, 3.904878261386894*^9}, 
   3.904878338626288*^9, {3.9048788133977222`*^9, 3.904878814245741*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"ffa3c8c6-cc51-453e-a6b9-d6e302e90377"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJx1mH1UlFUex4fBdc0VK992pXNcNE3yLTVIwpU7OuqS5u60x3Q1mXxZN9bJ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     "], {{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[0.3], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHv819Mdx89B6U5UdL+n6EIpcukiVFQuqySkiy7oxipToihKN12kmwyx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           "]], PolygonBox[CompressedData["
1:eJwtk1lLV1EUR/f+I0hggvTUo99AKjKstDlDpTIKo0iSxAbSaCCVzObUokGL
Zps1X/sazaUhElkUkUQhSrMNa/M7D4u97r3nnnP2Pvvk1zRU1mfMbC5kwT03
Wwcv8DziGrgLk+Ax79qIx2EJ/glO4qXwBB+CWfge+II3QwG+Dd7jk+Ewvgge
4oNQiPdADuzguYJ4AV6Z9nDaNSa+/YJl+CnXWk/hCn4N/uADcAyfDrPxH9CI
L4cJfAx24WWuuT7DxRgLN0xj1uN9MAX6eZ4Ra8OIKecD+CH4bsqhHT8BP001
aMDr4aPpn92uNWOtqMkq/DZkwQOezxPL4bkp5258hSuXl6Zc7kB2yqnJlVPk
Mg6d+Dn4bZpjK74F3plqvhbvhVx4xvM84k7X2a00zb0aHpnWiL1Ng6mmPW52
1SRq8Rbm4M2utftMtYueyUs1vEWsc43NpL0shG+mPV3GL7n+/QoL8H0uvw8l
+Hb4YNrDdXwDvMb/QSu+39VLMWY+vhdG8SNwFj/j6r14d9W1p0zqkZvETfAG
d2K160ziLGKNqFWRa67c1JtVrl7LSXdhpqt2cSe6XHN6OoOOqIPH5OqJFmIl
/DXV4KArp8gleqgm3bG4W8NQ6zqzOKvYY8y10fXNUm8tdfV29Nhi/KjrLsUZ
Ru8Wu2oZPfwfap+J6Q==
           "]]}]}, {}, {}, {}, {}}, 
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJwt0kszFQAYx+GjXErtszVjj1BSyb2S3BJFIrnfDtHlVLodJUKiRHJNxdLW
shT5AH0c02OmxTPzW74z/ze+IVjeHREIBFY5JvZ7j3IxQC5ttNNBEk94Sidd
nCOZWo7zhSvUcZNFnvOCZ+QRpoKX5DNIAVdZJYVXnGf/wCA9pDLEa3q5QxZp
1HOCr1TSwC2WGOENw1xglCrGucgYhVzjGyd5yyX66Ocu6UzwjnvcJ5tT3CaD
71yniUaWmeI9kxTxgWo+cplpiqlhjdPMUMIDQjzkDLN84hGPyeEszWSyzg1a
aWGFz8wzRykLlPHX1j/Z4he/2WaHP+zyg002WGORacYIEyJIEzWUkk8GiSQQ
x1GOEMthDhFDNFFEcpAD/3/xHw+1Rwk=
        "]]}}], {}}, {{}, {
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.08053395042374835, 
        0.05877555787340594}, {-0.10825854645466215`, 
        0.015374076842259958`}, {-0.11272381043934837`, \
-0.04093496887871566}, {-0.08803193398516472, -0.0977723952998116}, \
{-0.03684999380370615, -0.13917432851429626`}, {
        0.033666388023755725`, -0.15390764668802362`}, {
        0.10968336185455071`, -0.1330187299607751}, {
        0.11951506211752265`, -0.12400353934873642`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.12688555834261508`, -0.11724515304756228`}, {
        0.17327830342518144`, -0.07470526383732816}, {0.20584902741009745`, 
        0.01183901334730142}, {0.1953066889744705, 0.11233036907181589`}, {
        0.17162433258799892`, 0.16123599539912886`}, {0.13582443016953089`, 
        0.20536816957834508`}, {0.11016753920608098`, 
        0.22511846934664195`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.10224342370798617`, 0.2312183376708645}, {
        0.0887539660788878, 0.24160232504743195`}, {0.03217730132733977, 
        0.26727400321326444`}, {-0.02525173462340204, 
        0.2792224682947744}, {-0.0863578723919625, 
        0.2789921719228537}, {-0.1485294100982113, 
        0.26542417832325443`}, {-0.20895471837347804`, 
        0.23816524186668767`}, {-0.2645467322253788, 
        0.19722704802085309`}, {-0.26595595996055704`, 0.1956439139392192}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.27260486123007255`, 
        0.18817450218806805`}, {-0.3123694029318763, 
        0.1435028003493917}, {-0.3493643957780324, 
        0.07836347702044173}, {-0.3730199805754065, 
        0.003987543185027896}, {-0.38096249355339884`, -0.0684106646219723}, \
{-0.3750591874663361, -0.14375075441048665`}, {-0.36478325588723465`, \
-0.1811977528418923}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3621369569700817, -0.19084125334954383`}, \
{-0.35430220923931455`, -0.21939222060015984`}, {-0.31846531903111513`, \
-0.2925167580103652}, {-0.2677536118729831, -0.3600514254276449}, \
{-0.2030727395186048, -0.4190769545036568}, {-0.12545024644439423`, \
-0.46673279363437614`}, {-0.10128361478339044`, -0.4759246992433453}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09193688203034728, -0.4794797782640128}, \
{-0.03707100512619312, -0.5003483034573726}, {
        0.035100132075154424`, -0.5149236410295126}, {
        0.11071805641780638`, -0.5192584422513159}, {
        0.1883578516989877, -0.5126663527193198}, {
        0.2274929332529781, -0.5047547827509514}, {
        0.26649158034571624`, -0.4939262862495361}, {
        0.29780993055389715`, -0.48173062121848603`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.30712833735638195`, -0.4781019445088017}, {
        0.34635611752289336`, -0.4628262718235441}, {
        0.42300475847247376`, -0.41903875022635867`}, {
        0.49447244353982106`, -0.3627940092963286}, {
        0.558770543170338, -0.2946422852585897}, {
        0.5970696564849124, -0.24245971987750178`}, {
        0.6073800607953709, -0.2250215663479385}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.61246956394468, -0.2164136073742228}, {
        0.6306882195940825, -0.18560010047864334`}, {
        0.6590400615896861, -0.12449296616677075`}, {
        0.6815969550675887, -0.0596152064776323}, {0.6979272204503256, 
        0.00856466657455189}, {0.70761615381186, 0.07947165067658801}, {
        0.7102620876609865, 0.15241856669054218`}, {0.7094067030190767, 
        0.16587456764052697`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7087722934698549, 0.17585442357755612`}, {
        0.7055402062501889, 0.22669818037117162`}, {0.6932230878905588, 
        0.30163431321651557`}, {0.6731383626292087, 0.37647649153096374`}, {
        0.6451666160946882, 0.4503947310323393}, {0.609275347201237, 
        0.5225640262171608}, {0.5901394382767056, 0.5530410204425188}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5848219180649035, 0.5615100214932376}, {
        0.5655104377021095, 0.5922666413026828}, {0.5140137353551719, 
        0.6586812656320755}, {0.4550239243766438, 0.7208725758231971}, {
        0.3888624240904714, 0.7779603289584983}, {0.3158906098195595, 
        0.8292165743350434}, {0.300760254490825, 0.8377362922903202}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2920466884132313, 0.8426427947321221}, {
        0.23659799023241596`, 0.8738652782246717}, {0.15160657255833163`, 
        0.9110724043076697}, {0.06160014610145757, 
        0.9401066106472941}, {-0.03275818276768201, 
        0.9605179616944891}, {-0.08488704914793258, 0.9665092406951489}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09482164944252498, 
        0.9676510449632634}, {-0.13065601171714353`, 
        0.9717695627271428}, {-0.23112322765677928`, 
        0.973219323931238}, {-0.3331683264461468, 
        0.9644153822862018}, {-0.4181235708458057, 
        0.9490940572870644}, {-0.49028973696980177`, 0.9297950213476631}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4999502601050498, 
        0.9272115560869448}, {-0.5029210006996729, 
        0.9264171058260877}, {-0.5869277491644136, 
        0.8965191946769938}, {-0.6694986107525744, 
        0.8589486437625197}, {-0.7500066220238256, 
        0.8141206564962981}, {-0.8278118426879888, 
        0.7618337611555807}, {-0.8521553487469629, 0.7423977594024173}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8599701095291714, 
        0.7361584073593879}, {-0.9022845969303801, 
        0.7023742659410683}, {-0.9727952089363158, 
        0.6360284790534616}, {-1.0386365037876655`, 
        0.5629244760266161}, {-1.099163305849056, 
        0.48331691852786385`}, {-1.1264194104784524`, 
        0.44062743580284097`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1318008169014786`, 
        0.43219888522102606`}, {-1.1538389382299397`, 
        0.3976819939581188}, {-1.2021267240397686`, 
        0.3064958897182956}, {-1.243403048264287, 
        0.20987125628737627`}, {-1.277113846388205, 
        0.10821157368188868`}, {-1.288296826623905, 0.06597672842843649}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2908564298991376`, 
        0.05630985555902219}, {-1.2909970634305334`, 
        0.055778723847192124`}, {-1.3028267672694251`, 
        0.002429273609066054}, {-1.3125489140121178`, \
-0.051722723069085375`}, {-1.3201094597658491`, -0.10656321222385778`}, \
{-1.3262317503474492`, -0.17356886349563033`}, {-1.3289814401120654`, \
-0.24130320761004753`}, {-1.3283585290596975`, -0.30976624456710944`}, \
{-1.3265778799028938`, -0.3406023925637448}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.3260013851557029`, -0.35058576142432796`}, \
{-1.3243630171903458`, -0.378957974366816}, {-1.3168869717276026`, \
-0.44854242140950984`}, {-1.3058224598950607`, -0.5181836100955336}, \
{-1.29116948169272, -0.5878815404248872}, {-1.2729280371205804`, \
-0.6576362123975708}, {-1.251058310048759, -0.7270809597021168}, \
{-1.2458530488095827`, -0.7410976666368959}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2423717384450998`, -0.7504721254557368}, \
{-1.225520484347371, -0.7958491160270577}, {-1.196314560016418, \
-0.8639406813723939}, {-1.163440537055899, -0.9313556557381248}, \
{-1.124435002853534, -1.0067375920013464`}, {-1.080783885079794, \
-1.0807839165656377`}, {-1.0616542955017225`, -1.1060241967707638`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0556140806901662`, -1.1139938771301168`}, \
{-1.0239935512513096`, -1.1557151602770417`}, {-0.9621605187836746, \
-1.227814544345588}, {-0.9091480881478889, -1.2865340247072512`}, \
{-0.8528265184908987, -1.3429224979795882`}, {-0.7931958098127043, \
-1.3969799641626002`}, {-0.7828634543443891, -1.405471503020873}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7751377495334164, -1.4118207931523534`}, \
{-0.7302559621133053, -1.448706423256286}, {-0.6642105840904254, \
-1.4977403420926636`}, {-0.5952632844417882, -1.5437201875037498`}, \
{-0.5234140631673937, -1.5866459594895443`}, {-0.44866292026724175`, \
-1.6265176580500478`}, {-0.44110170530631965`, -1.6300840787152189`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43205730161524786`, -1.63435007940356}, \
{-0.37129364800443543`, -1.6630106519502865`}, {-0.29159003864207755`, \
-1.6958003099552874`}, {-0.20955209218016813`, -1.7248866320650504`}, \
{-0.12517980861870728`, -1.7502696182795758`}, {-0.06119665240090115, \
-1.7666588565504842`}, {-0.05588878895582322, -1.7678193274569916`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.04611954899960154, -1.7699551998028404`}, {
        0.003851029826180065, -1.7808803872174532`}, {
        0.06987323707445227, -1.792854895742205}, {
        0.13677996835583134`, -1.8025030675864617`}, {
        0.2044812226822327, -1.809745588211945}, {
        0.2728869990655717, -1.8145031430803766`}, {
        0.34190729651776414`, -1.816696417653479}, {
        0.35034434446056445`, -1.816641785636856}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3603441348226757, -1.8165770344683203`}, {
        0.411452114050726, -1.8162460973929735`}, {
        0.4814289804349386, -1.8131716805894285`}, {
        0.5517446643665959, -1.8075230694807491`}, {
        0.6223080247461822, -1.7992665554496625`}, {
        0.6930279204741826, -1.7883684298788978`}, {
        0.7575571915660763, -1.7759946081526499`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7673507630913646, -1.7739809581114447`}, {
        0.8345727535773633, -1.7585125096492427`}, {
        0.9052154087535126, -1.7394872977558076`}, {
        0.9756500348800132, -1.7176856398536051`}, {
        1.0457603988003121`, -1.6931273678127137`}, {
        1.1154225467249201`, -1.6658487874993195`}, {
        1.1475545415609405`, -1.6518971688490038`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.156727204884504, -1.6479144251273274`}, {
        1.1845337566049197`, -1.6358409012903128`}, {
        1.2529913063913936`, -1.6030947115625829`}, {
        1.3206924740354231`, -1.5676012206930192`}, {
        1.3875345374880903`, -1.5293514310585123`}, {
        1.4534147747004778`, -1.4883363450359517`}, {
        1.505403252257749, -1.4532130093289444`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5136894387172943`, -1.4476148744647555`}, {
        1.5182304636236674`, -1.4445469650022265`}, {
        1.5818697986437271`, -1.3980464376132837`}, {
        1.6442181792036419`, -1.3489201077647792`}, {
        1.7051686908398727`, -1.2971922751931677`}, {
        1.7646144190888797`, -1.242887239634903}, {
        1.8187148716092199`, -1.1896998653894943`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8257205906642757`, -1.1825664174133537`}, {
        1.8785638675710594`, -1.1266427585042336`}, {
        1.9328537588771526`, -1.0647519124047375`}, {
        1.9852112089418608`, -1.000381062264406}, {
        2.0350129280543623`, -0.9343528917100311}, {
        2.078025828206587, -0.8728489406007649}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.0837040778547715`, -0.8646185932841548}, {
        2.128305552016987, -0.7956863310917494}, {
        2.171600776410988, -0.723158187371794}, {
        2.2125314887760323`, -0.6485736322739303}, {
        2.2509998488840584`, -0.5719877889701344}, {
        2.277050752689313, -0.5150138487701635}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.281209099426934, -0.505919446513296}, {
        2.2869080165070046`, -0.4934557806323819}, {
        2.320158151416809, -0.4130327304326482}, {
        2.3506851139985763`, -0.3308402292310362}, {
        2.378433826364538, -0.24702031948399486`}, {
        2.4033215408773243`, -0.16165880175802025`}, {
        2.4117469839336128`, -0.1283250676230679}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.414197518750787, -0.11862997200157879`}, {
        2.4252655098995644`, -0.07484147661960802}, {2.4441829857938906`, 
        0.013345855364745888`}, {2.459991220922931, 0.10281739362854576`}, {
        2.472607467649317, 0.19348733760529555`}, {2.4809347319270953`, 
        0.2753046761812702}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.481947288184834, 0.2852532805972129}, {
        2.4819489783356783`, 0.28526988672850034`}, {2.4879867717071797`, 
        0.37802196948648364`}, {2.49070840998515, 0.47158289253828295`}, {
        2.490055960776466, 0.5658404225734739}, {2.4859714916880042`, 
        0.6606823262816315}, {2.4840508586973495`, 0.684850944421721}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.4832586756316037`, 0.6948195173381593}, {
        2.4783970703266425`, 0.7559963703523308}, {2.4672747642992565`, 
        0.8516703214751467}, {2.452546641212724, 0.9475919463396543}, {
        2.434154768673921, 1.0436490116354284`}, {2.4237023270207225`, 
        1.0899481225928842`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.4215001585870737`, 1.0997026320213403`}, {
        2.412527892564225, 1.139445302099252}, {2.386681543186237, 
        1.2354092287986997`}, {2.357271652055331, 1.3310120112352253`}, {
        2.324250652662824, 1.4261353674945108`}, {2.3028515608648084`, 
        1.4812868913959343`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.2992342535154764`, 1.4906097175522277`}, {
        2.2875751248538103`, 1.5206585962206804`}, {2.24720579482716, 
        1.6144585766163009`}, {2.203107535135521, 1.7074097684423823`}, {
        2.155249364685315, 1.7993842120183783`}, {2.126376843167879, 
        1.8509379535629213`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{2.121490496893639, 1.8596628386675071`}, {2.12065533854911, 
        1.8611540675307932`}, {2.0843733714590322`, 1.9223640831778877`}, {
        2.0464077358242774`, 1.982970857842905}, {2.006764192966777, 
        2.042930389544664}, {1.9654499931212028`, 2.1021980754375535`}, {
        1.922473875434965, 2.1607287118115317`}, {1.8986997886637487`, 
        2.191492060152295}}]}, 
      {Arrowheads[{{0.00487273592909976, 1.}}], 
       ArrowBox[{{1.8925849257808414`, 2.199404610431645}, {
        1.8778460679682123`, 2.2184764940921284`}, {1.8315782876938322`, 
        2.2753950168404447`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.14547891007220048`, 
        0.11916598653100989`}, {-0.20018808890752074`, 
        0.04587817735195573}, {-0.21809499430669954`, \
-0.052384544834700904`}, {-0.2093502195933019, -0.10535270435621343`}, \
{-0.18788041833393657`, -0.15720883573738362`}, {-0.15360600838843486`, \
-0.20480024767999808`}, {-0.12332991323839783`, -0.2312526134122412}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.11579931417703056`, -0.2378321329826152}, \
{-0.10742852137849343`, -0.24514573374514484`}, {-0.054780795232938675`, \
-0.2735614427777287}, {0.005157862004517218, -0.29084447824351456`}, {
        0.07004484914972275, -0.29501462846205223`}, {
        0.13708011979011378`, -0.284882615864117}, {
        0.2030522933466684, -0.25955535337563435`}, {
        0.2558853264903374, -0.22488580217924484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2642459599760206, -0.21939947301321103`}, {
        0.26465776711645184`, -0.21912924115468047`}, {
        0.31832259232672183`, -0.16418240008929064`}, {
        0.36082906809652665`, -0.096308484071882}, {
        0.3885847380749037, -0.01908584924205449}, {0.4000456856539895, 
        0.06565244887021149}, {0.394164714977549, 0.14046929216935236`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.39338108314904147`, 0.1504385409453309}, {
        0.39306575857587844`, 0.15445005375106807`}, {0.3666069983991692, 
        0.24341472569769934`}, {0.32010062255986266`, 0.3281935146590073}, {
        0.25425588437216456`, 0.4044831249025242}, {0.21450821167510306`, 
        0.4380175709659093}, {0.17043784712386428`, 0.4677174219028052}, {
        0.16996086668192925`, 0.46797079637645456`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.16112954543700334`, 0.47266203982237803`}, {
        0.12252653658173288`, 0.49316815745333437`}, {0.07125602591199372, 
        0.5139552573576198}, {-0.01996522215690985, 
        0.5366825108632076}, {-0.11702795438727706`, 
        0.5434818841616339}, {-0.21721722303568305`, 
        0.5328056759298602}, {-0.22576610481923012`, 0.5303397931214757}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.23537438286674986`, 
        0.5275683326830877}, {-0.3174788920905576, 
        0.5038856917351823}, {-0.3665717420108557, 
        0.482474711568773}, {-0.41440453032129443`, 
        0.4563713009120596}, {-0.4605587565934912, 
        0.4257126024934353}, {-0.5046159203990634, 
        0.3906357590412935}, {-0.5461911457042167, 
        0.35103857787511794`}, {-0.570848451717243, 
        0.32297302843309883`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5774486373544233, 
        0.315460535534283}, {-0.5848726569594866, 
        0.30701033464151917`}, {-0.6202016044629868, 
        0.25897537455958114`}, {-0.6517191385128303, 
        0.20735804284838796`}, {-0.6843489226250916, 
        0.1398791931643146}, {-0.7101497284399011, 
        0.06779199637184315}, {-0.7285478783612251, -0.008199320690083278}, \
{-0.7336285472449531, -0.04680528939490585}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.7349333286966131, -0.05671980125194672}, \
{-0.7389696947930304, -0.08739053118252152}, {-0.7409871442374973, \
-0.1689395100171172}, {-0.734172193196806, -0.252004132105516}, \
{-0.7231780968853831, -0.3119641559013571}, {-0.7073964490523483, \
-0.37177130546142895`}, {-0.6815879730457203, -0.4461190915784071}, \
{-0.6804913318367958, -0.44851324745633364`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6763269195519824, -0.4576048738412054}, \
{-0.6481674334486417, -0.5190818625090168}, {-0.607157790347405, \
-0.5898437910725429}, {-0.5586594598082746, -0.6576107487209791}, \
{-0.5028292409574694, -0.7216731350728813}, {-0.443098831101584, \
-0.7782679702411217}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4354886283053369, -0.784737859807511}, \
{-0.37030158051751605`, -0.8356144931478727}, {-0.29438844864156155`, \
-0.8839340036069614}, {-0.2121012932887889, -0.9258331533266222}, \
{-0.12447660508806352`, -0.9603200400389009}, {-0.08523535767771111, \
-0.9715456489487521}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07562101337676386, -0.9742959914115815}, \
{-0.03220240048087697, -0.9867166049226817}, {
        0.06398392504300879, -1.0044273195395952`}, {
        0.1633700438727946, -1.0129780167687295`}, {
        0.2651152444470397, -1.0119358515330443`}, {
        0.3203329689302647, -1.0060297712032846`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3302762530457047, -1.0049662388814258`}, {
        0.3682428346284351, -1.0009053384590967`}, {
        0.4717632070324956, -0.9795925417895168}, {
        0.5233772528930066, -0.9650207495101828}, {
        0.5747412635346618, -0.9478209290994664}, {
        0.6257144895202278, -0.9279817448511882}, {
        0.6761574382250481, -0.9054986932280239}, {
        0.7104394978198866, -0.8881941734750485}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.719366675523292, -0.8836880112218868}, {
        0.7259318738370407, -0.8803741028615043}, {
        0.7749008173566987, -0.8526171345520158}, {
        0.8229285465970906, -0.8222437812687997}, {
        0.8698805961838584, -0.7892768681499539}, {
        0.9156590318247232, -0.7537395461981284}, {
        0.9601489901943709, -0.7156651529461578}, {
        1.003195319529314, -0.6751015210763552}, {
        1.0354704200881217`, -0.6416224417598404}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0424108511757042`, -0.6344231073240388}, {
        1.0446478874673881`, -0.6321026214340959}, {
        1.0843615810477507`, -0.5867285630278185}, {
        1.1221963067108809`, -0.5390455930290248}, {
        1.1580169902985804`, -0.4891260967722792}, {
        1.1916935770539712`, -0.43704859775521115`}, {
        1.2231345169907226`, -0.38287963392994007`}, {
        1.2522360159556924`, -0.32670122519028977`}, {
        1.2631738386890639`, -0.3028410089903315}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2673409809396914`, -0.29375063356007375`}, {
        1.2788598608733075`, -0.2686228752943552}, {
        1.3028764298420346`, -0.20875829296771162`}, {
        1.3241646921343795`, -0.1472253919034172}, {
        1.3426122081968872`, -0.08414629076201202}, {
        1.3581151296501417`, -0.01964731317151891}, {1.3705781992887656`, 
        0.04614101227255685}, {1.3766544291652045`, 0.08944521086776755}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3780439673005531`, 0.0993481994959753}, {
        1.3799759929023492`, 0.11311739882722877`}, {1.3862601038935094`, 
        0.18115911108816132`}, {1.389318587583144, 0.2500998157622025}, {
        1.3890546229270881`, 0.3197725422495182}, {1.3853865125161153`, 
        0.3900096826435927}, {1.3782476825759373`, 0.46064299173122786`}, {
        1.3726303666649142`, 0.49797967345288113`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.3711426071341462`, 0.507868382750793}, {
        1.3675866829672036`, 0.5315035869925432}, {1.353367187185502, 
        0.6024219486009768}, {1.3389637642846015`, 0.6606594882483303}, {
        1.322085454136531, 0.7187414688485818}, {1.3027537473980226`, 
        0.7765671150057446}, {1.2809947711310472`, 0.8340360414747908}, {
        1.257248129658711, 0.8900832994875366}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.253033530906833, 0.899151009535055}, {1.2303227002857684`,
         0.9475041451232241}, {1.2014850418575984`, 1.0033045025673564`}, {
        1.1695797063738769`, 1.0582839150890209`}, {1.1356943645126123`, 
        1.1124313257567426`}, {1.0993364454997308`, 1.165602701186843}, {
        1.060557576626015, 1.2176998019645742`}, {1.0436096412841431`, 
        1.2386743958069906`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0373247179175737`, 1.2464525535757909`}, {
        1.0194093851822454`, 1.2686243886751898`}, {0.9759434984592045, 
        1.318278221903942}, {0.930211543747674, 1.366563062236083}, {
        0.882265148338435, 1.4133806702568663`}, {0.8321559395222693, 
        1.4586328065515441`}, {0.7798828050388837, 1.5021920316786117`}, {
        0.7509828081255685, 1.524363705813906}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7430487346535213, 1.5304506162075422`}, {
        0.725463810646558, 1.5439415243881127`}, {0.6689793506639327, 
        1.5837989725526218`}, {0.6105098194096483, 1.6216820640447138`}, {
        0.5501356112023459, 1.6575084867369636`}, {0.48793712036066567`, 
        1.691195928501946}, {0.42399474120324854`, 1.7226620772122359`}, {
        0.3994766731630144, 1.7335606323578407`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3903387839876425, 1.737622526179523}, {
        0.35838886804873527`, 1.7518246207404082`}, {0.2910770022688201, 
        1.7785684808804598`}, {0.2220613335795418, 1.8027904943640523`}, {
        0.151489288816057, 1.8244262214702573`}, {0.07950829481352238, 
        1.8434112224781471`}, {0.00999642241294614, 1.8588523455184298`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.00018659713990841313`, 
        1.8607839797767523`}, {-0.06809083356806767, 
        1.8731712873152677`}, {-0.14341411427680922`, 
        1.8838174717026424`}, {-0.21955663688397295`, 
        1.8915551711079885`}, {-0.3109977393126927, 
        1.8968215374577784`}, {-0.39740241473695476`, 1.8976607646625359`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.4073992476663572, 
        1.897562608385838}, {-0.4963105316193033, 
        1.8942432131189566`}, {-0.5901822214971941, 
        1.886398522430345}, {-0.6844512307053616, 
        1.874061888216544}, {-0.7787046827576921, 
        1.8571117192984978`}, {-0.8040394998892202, 1.8513145557630724`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8137875540932025, 
        1.8490839865002553`}, {-0.8729425776541857, 
        1.8355480156762067`}, {-0.9671649153948421, 
        1.8093707773496703`}, {-1.0609249780295422`, 
        1.7785371580501284`}, {-1.1537760476081667`, 
        1.7430043115088196`}, {-1.193542786971388, 1.7256031557737626`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2027040889742628`, 
        1.7215943472709625`}, {-1.245718124130716, 
        1.7027722377257453`}, {-1.3367512075971895`, 
        1.6578409367009042`}, {-1.4302286263662656`, 
        1.6090468672910196`}, {-1.5222452072387163`, 
        1.555240327724995}, {-1.554475424122574, 1.532420890667627}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5626368989681576`, 
        1.526642454171056}, {-1.5687541366156896`, 
        1.5223113657404121`}, {-1.6146415334374957`, 
        1.4880284283385103`}, {-1.6597946936157246`, 
        1.4524304499251783`}, {-1.704251185179846, 
        1.41550445236512}, {-1.7856720026269841`, 
        1.3462796227348228`}, {-1.8642431065735035`, 
        1.2727044762288422`}, {-1.8680218462679385`, 
        1.2688157462417993`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-1.874990762209026, 
        1.2616439814237048`}, {-1.939964497019404, 
        1.1947790128471776`}, {-1.9767565496796224`, 
        1.1541849123279637`}, {-2.0128361739646863`, 
        1.112503232589829}, {-2.048090648997865, 
        1.0697920311445586`}, {-2.0824072539024274`, 
        1.0261093655039377`}, {-2.115785988678374, 
        0.9814552356679662}, {-2.133268660243372, 0.9568671957350299}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.139063423295993, 
        0.9487173048668048}, {-2.148226853325704, 
        0.9358296416366441}, {-2.179729847844419, 
        0.8892325834099719}, {-2.2102949722345175`, 
        0.8416640609879489}, {-2.239922226496, 
        0.7931240743705754}, {-2.268611610628867, 
        0.7436126235578515}, {-2.2962600922152574`, 
        0.6932113008490698}, {-2.3227646388373104`, 
        0.6420016985435231}, {-2.341239717978965, 0.6041069309449646}}]}, 
      {Arrowheads[{{0.014966800843425932`, 1.}}], 
       ArrowBox[{{-2.3456220049174075`, 
        0.5951182958322705}, {-2.3481252504950265`, 
        0.5899838166412114}, {-2.3723419271884056`, 
        0.5371576551421345}, {-2.3954146689174483`, 
        0.48352321404629267`}, {-2.4173434756821535`, 
        0.42908049335368587`}, {-2.4381283474825217`, 
        0.3738294930643138}, {-2.457769284318553, 0.317770213178177}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.005412115972872655, 
        0.434639744761163}, {-0.0992735320248458, 
        0.44167364455746383`}, {-0.19637867343681703`, 
        0.4284910286897749}, {-0.292510312353987, 
        0.3942131295900522}, {-0.3387511527179627, 
        0.36905131777866124`}, {-0.3825003968831305, 0.33882404703443814`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.39013555583711673`, 
        0.33237083906670234`}, {-0.424692290548228, 
        0.30279296452015914`}, {-0.4632831487065725, 
        0.2622772322061808}, {-0.4981035208248903, 
        0.21702445462295633`}, {-0.5285764767165013, 
        0.16728506015674866`}, {-0.5542805599236785, 
        0.11358931045594399`}, {-0.5747943139886946, 
        0.05646746716892838}, {-0.5876911686376989, -0.005101175214466895}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.589741383234593, -0.014888749996131769`}, \
{-0.5957798350245687, -0.04371587792186095}, {-0.5995868863631374, \
-0.14951363987404345`}, {-0.5945774115543174, -0.20361798760553948`}, \
{-0.5847080301112333, -0.2580460120712426}, {-0.5699900724924049, \
-0.3123567402094278}, {-0.5504348691563521, -0.3661091989583698}, \
{-0.5329287641387913, -0.4038033112115108}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5287166085045741, -0.412872916765951}, \
{-0.5259381861137769, -0.4188554106091157}, {-0.4964882409336352, \
-0.47015300117049474`}, {-0.4622350414118289, -0.5195694031574555}, \
{-0.42332859534425943`, -0.5666720490849461}, {-0.3796744905013567, \
-0.6110616423021615}, {-0.3313738506739279, -0.6523122694908995}, \
{-0.2788699876884405, -0.6899514381650126}, {-0.2594124219845771, \
-0.7015557583605792}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.25082384884571934`, -0.7066779074640797}, \
{-0.22260621337136208`, -0.7235066558383536}, {-0.14957979061056267`, \
-0.7580931697685621}, {-0.0717632496062046, -0.7854784596838134}, {
        0.010121227841374272`, -0.8050788661779351}, {
        0.09535145993183615, -0.816310729844755}, {
        0.12902155699853582`, -0.817241354437818}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13901773947631912`, -0.8175176439071398}, {
        0.1830676674992265, -0.8187351618210195}, {
        0.2724100713775927, -0.8119132732434754}, {
        0.33354929891127233`, -0.8013751901653294}, {
        0.3946096132208077, -0.7863412526061471}, {
        0.48808157792872836`, -0.7551354471564}, {
        0.5270258553613951, -0.7372314255716031}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5361116760864388, -0.7330543617999609}, {
        0.579585278471498, -0.7130680540088684}, {
        0.6678929059288734, -0.6601914634783541}, {
        0.7517697584162523, -0.5966679538893054}, {
        0.8207193516425308, -0.5324289568589449}, {
        0.853743511640356, -0.4951936741933058}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8603788548615364, -0.4877122157568019}, {
        0.8844823823085548, -0.46053509277205906`}, {
        0.942183961300501, -0.38141038182623943`}, {
        0.9930092621393032, -0.29555076228404914`}, {
        1.0362640212491345`, -0.2034801397799959}, {
        1.057934719818556, -0.14300108600946154`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0613078883861595`, -0.13358717429251138`}, {
        1.071249833322373, -0.10584097956534255`}, {
        1.0972579778228175`, -0.003398791272700319}, {1.1136694296335872`, 
        0.10303052427040114`}, {1.1181187805031256`, 0.15749446548671547`}, {
        1.1199942471494762`, 0.21266032448246852`}, {1.119350633692318, 
        0.25995989208118697`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.119140150483491, 0.2699561792101718}, {
        1.1157903845763841`, 0.3245690496497532}, {1.1096115130629183`, 
        0.38104576473628887`}, {1.1006596727382183`, 0.43769209543227355`}, {
        1.0889021217593646`, 0.49437318819148485`}, {1.0743129300050742`, 
        0.5509534782662108}, {1.0568772263022872`, 0.6073174148983237}, {
        1.037871787110824, 0.6597850085055192}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.034190103872587, 0.6690797355630174}, {
        1.0134270959530278`, 0.7188633191756706}, {0.9874030546654159, 
        0.7737426506704743}, {0.9585187274736218, 0.8278269767783417}, {
        0.926787468954924, 0.8809687281379531}, {0.8922298984457404, 
        0.9330218348735466}, {0.8548739000416281, 0.9838417265949186}, {
        0.831844502363403, 1.0122395336379555`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8255457981795712, 1.020006535994372}, {0.8147472350639777,
         1.0333223645706715`}, {0.7718887382771573, 1.0813401174123132`}, {
        0.7263532100772334, 1.127729237546196}, {0.6782019276158595, 
        1.1723294269827107`}, {0.6275026448002757, 1.2149858373162854`}, {
        0.5743295922933089, 1.2555490697253862`}, {0.5292843005309958, 
        1.2866185551448255`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5210524944163194, 1.2922963512040704`}, {
        0.5187634775133729, 1.2938751749725168`}, {0.46089148463446683`, 
        1.3298256534042197`}, {0.40078771683718284`, 1.3633027983768036`}, {
        0.3385428371638475, 1.3941961313311284`}, {0.2742770200945249, 
        1.422358996590677}, {0.2081148307049731, 1.447653958028381}, {
        0.16079550870485054`, 1.4631871857453596`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.1512943252298204, 1.466306081795858}, {0.1401852246666439,
         1.4699527990666208`}, {0.0706215482466831, 
        1.4891365226772266`}, {-0.0004384616920700135, 
        1.5050953513814767`}, {-0.07285267769108147, 
        1.5177287272500986`}, {-0.14651021008115578`, 
        1.527009721361598}, {-0.22127741018556513`, 
        1.5328874176898575`}, {-0.24183894839374673`, 1.5335276066443668`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2518341048911094, 
        1.533838808497235}, {-0.29697427641173946`, 
        1.5352442597295104`}, {-0.3734202169324854, 
        1.5339787808668612`}, {-0.45043404968598566`, 
        1.5290056043798852`}, {-0.5278340023757991, 
        1.5202554434382276`}, {-0.6054377124708609, 
        1.5076751011032052`}, {-0.6491644237807317, 1.4984099764823813`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6589472297485056, 
        1.496337126416195}, {-0.6830622272054818, 
        1.4912274703278054`}, {-0.7465162101455016, 
        1.4748316925138893`}, {-0.8097756524920166, 
        1.455771484811578}, {-0.8727335514231203, 
        1.4340702822333202`}, {-0.9352833275524565, 
        1.409756368061827}, {-0.9973188249292202, 
        1.3828628738500683`}, {-1.035578299967601, 1.3645259472554754`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0445960687985532`, 
        1.3602039285938419`}, {-1.058734311038155, 
        1.3534277794212755`}, {-1.1194244767995551`, 
        1.3214939128689402`}, {-1.1792121702353935`, 
        1.2862815124323494`}, {-1.2380877610571228`, 
        1.2489289132726151`}, {-1.2958972980262276`, 
        1.2089219984370505`}, {-1.3525365306518773`, 
        1.1663157166947977`}, {-1.3800118835443682`, 
        1.1439091668505954`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.387761577257726, 
        1.1375891789274153`}, {-1.4079012084432412`, 
        1.121165016815}, {-1.4618870809094882`, 
        1.0735248475668009`}, {-1.5143898975597878`, 
        1.0234501577193422`}, {-1.56530540790331, 
        0.9709958960417678}, {-1.6145293614492224`, 
        0.9162170113032206}, {-1.6619268970927663`, 
        0.8591130203086064}, {-1.667090845465837, 0.8523626390390251}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.6731667512237463`, 
        0.8444201350748457}, {-1.7073742848615192`, 
        0.7997035969407351}, {-1.7507839709631574`, 
        0.7380739255856067}, {-1.792068401605357, 
        0.6743091906292207}, {-1.831140022995794, 
        0.6084945764575765}, {-1.8679112813421448`, 
        0.540715267456674}, {-1.8850421381122138`, 0.5060090636304687}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8894682774868785`, 
        0.49704194089036735`}, {-1.9022946228520856`, 
        0.4710564480125124}, {-1.9342024937332927`, 
        0.39960330251109144`}, {-1.9635141693256861`, 
        0.3263116886380093}, {-1.9901209871029155`, 
        0.2511844919699191}, {-2.013953486473252, 
        0.17437743872940273`}, {-2.0278553313349295`, 
        0.12249490645400007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0304435152263984`, 
        0.11283564643348401`}, {-2.0349422068449643`, 
        0.09604625513904291}, {-2.0530176876263244`, 
        0.016346667421421525`}, {-2.0681104682256017`, -0.06456559820087951}, \
{-2.0801510880510676`, -0.14653481550527753`}, {-2.0890700865109912`, \
-0.22940525826919062`}, {-2.0924276935686574`, -0.2816865676379874}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0930685926375303`, -0.29166600892412753`}, \
{-2.0954396789355716`, -0.32858620064369465`}, {-2.0971544426509148`, \
-0.42866782732487374`}, {-2.09421437765702, -0.529650138312728}, \
{-2.0866194839538883`, -0.6315331336072576}, {-2.0794479726673916`, \
-0.6908175948349481}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.078247049363996, -0.7007452221053164}, \
{-2.0742381999459187`, -0.7338850260321633}, {-2.0569389640375118`, \
-0.8362740284111461}, {-2.0347217762286673`, -0.9387001407442059}, \
{-2.007586636519385, -1.041163363031343}, {-1.9919869680040287`, \
-1.0907421940718827`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.9889855940689332`, -1.1002811538947213`}, \
{-1.9754826555476377`, -1.1431961624309015`}, {-1.9383589439513975`, \
-1.2443310061012258`}, {-1.917914689169093, -1.2945616945379255`}, \
{-1.8962155017306648`, -1.344567894042316}, {-1.8732613816361139`, \
-1.3943496046143984`}, {-1.8490523288854397`, -1.443906826254172}, \
{-1.836531665736055, -1.469577615987888}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8321479026720746`, -1.4785655312856019`}, \
{-1.8246222972872492`, -1.4939950841094287`}, {-1.798909927668124, \
-1.5437311968014658`}, {-1.7719145480035619`, -1.5931467636891077`}, \
{-1.7436381743670684`, -1.6421469866958815`}, {-1.7099607881400833`, \
-1.6918855438167304`}, {-1.674903572937542, -1.7410260173770444`}, \
{-1.638501350743205, -1.7894586395766288`}, {-1.6180710261971891`, \
-1.8153010695294982`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.6118692726899702`, -1.8231457016710138`}, \
{-1.6007425142291518`, -1.8372199996822154`}, {-1.5648821746755486`, \
-1.8826028237307277`}, {-1.5278412959134235`, -1.9272539913960276`}, \
{-1.4896198779427767`, -1.971173502678115}, {-1.4502179207636074`, \
-2.0143613575769894`}, {-1.4096354243759166`, -2.056817556092651}, \
{-1.367872388779704, -2.098542098225101}, {-1.3449041859838369`, \
-2.1204669826195053`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.3376707392061844`, -2.127371853922786}, \
{-1.324928813974969, -2.1395349839743374`}, {-1.2808046999617122`, \
-2.179796213340362}, {-1.235558039726796, -2.219205553722463}, \
{-1.189246826257083, -2.2576427725199317`}, {-1.1418710595525732`, \
-2.295107869732767}, {-1.0934307396132663`, -2.331600845360969}, \
{-1.0439258664391626`, -2.3671216994045383`}, {-1.0270090653732915`, \
-2.37867915764739}}]}, 
      {Arrowheads[{{0.007715843167073457, 1.}}], 
       ArrowBox[{{-1.0187520833666874`, -2.384320278825189}, \
{-0.993356440030262, -2.401670431863474}, {-0.9417224603865645, \
-2.4352470427377773`}, {-0.88902392750807, -2.467851532027447}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.48892307970544124`, -0.2255960376955776}, \
{-0.47234150955369236`, -0.28040013109869155`}, {-0.4497896989994949, \
-0.3342914501283743}, {-0.42137907044760137`, -0.3866246696979429}, \
{-0.3869891971479279, -0.43671018388136307`}, {-0.34668513167425963`, \
-0.4838938114240816}, {-0.30085651541715247`, -0.5275833642466368}, \
{-0.270339106115216, -0.551298164114163}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.26244295611178625`, -0.5574341901182911}, \
{-0.24989298976716226`, -0.5671866542695669}, {-0.19397346852061423`, \
-0.6019659754417034}, {-0.13344544754921822`, -0.6313000360892431}, \
{-0.06895144135660704, -0.6547712696987723}, {-0.0011339644464142538`, \
-0.6719621097568779}, {0.055434360027338696`, -0.6808303612870098}, {
        0.11043092748202081`, -0.6847764161768118}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.12042257758643235`, -0.6849228954630304}, {
        0.17270890806693165`, -0.6843536612130827}, {
        0.23258827891210598`, -0.6787857093381425}, {
        0.29278627488733044`, -0.6680518012192428}, {
        0.35289782877765363`, -0.6520142590866653}, {
        0.4124593593504511, -0.6307186486106343}, {
        0.47100728537309855`, -0.6042105354613739}, {
        0.5030553906427077, -0.5863522199496523}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5117907293757424, -0.5814845863131567}, {
        0.5280628197234573, -0.5724172133430517}, {
        0.5831593399910003, -0.5353605935326805}, {
        0.6358515120105207, -0.49322816805975256`}, {
        0.6856940016168118, -0.4462074289537593}, {
        0.7322642943443182, -0.3942318668820284}, {
        0.7751216199677619, -0.3374381736016198}, {
        0.7954657901328375, -0.3052847373228198}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8008126202312452, -0.29683421024465706`}, {
        0.8137932606823548, -0.27631864277662344`}, {
        0.8478064986833074, -0.21136556807112983`}, {
        0.8822599427192419, -0.1274721126911481}, {
        0.908598141528878, -0.03876019951943066}, {0.9262396039195075, 
        0.053975006578883405`}, {0.9283904040025739, 
        0.07865420697662007}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9292586162741077, 0.08861644605483729}, {
        0.9346028386984222, 0.14993834073865492`}, {0.9332616664573384, 
        0.24819920715608954`}, {0.9217899077879729, 0.34782701002739524`}, {
        0.9083955110163023, 0.41242932454452597`}, {0.8905863600123586, 
        0.47681972429540115`}, {0.8883240859454332, 0.483555393477431}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8851402190432355, 0.4930350027282962}, {
        0.8708863664150545, 0.5354742620897043}, {0.8474433201847803, 
        0.5935413842855224}, {0.8202535457196413, 0.650784897323016}, {
        0.7893277714405684, 0.7069692856210272}, {0.7546958645379219, 
        0.761863662046896}, {0.7163970715958388, 0.8152336251113281}, {
        0.6946404465391068, 0.8420195307957925}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.6883357288434453, 0.8497816525919261}, {
        0.6744795354548243, 0.8668408558592295}, {0.6290081220377702, 
        0.9164496482381802}, {0.5906117597057441, 0.9540937770824589}, {
        0.5500874860588226, 0.9902448401385171}, {0.5074958404919542, 
        1.0247776613529285`}, {0.4629020890326495, 1.0575715513071615`}, {
        0.41637622434098276`, 1.08851030721758}, {0.3849836859218514, 
        1.107308166002837}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.37640421875165786`, 1.1124455527972659`}, {
        0.3679929657095911, 1.117482212935443}, {0.3178317590636746, 
        1.1443800389469043`}, {0.2659767769609969, 1.1691010423730126`}, {
        0.21250181911470198`, 1.191565135589607}, {0.15749319648984317`, 
        1.211687350674498}, {0.10105973051272016`, 1.229365807743626}, {
        0.04331335863129562, 1.2445050515339477`}, {0.0037730192033273158`, 
        1.2528975477820967`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.006009063271857058, 
        1.2549738094343676`}, {-0.015630865684804207`, 
        1.257016051403438}, {-0.0756547729442894, 
        1.2668162013310886`}, {-0.1366370776342064, 
        1.2738293199169082`}, {-0.19845337821993775`, 
        1.2779856503819227`}, {-0.26100191481429885`, 
        1.279232865547126}, {-0.32416453199904005`, 
        1.2775193891764918`}, {-0.38778962152398055`, 
        1.272787108235359}, {-0.4041258427868641, 1.2707937165327077`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.41405221613917037`, 
        1.269582472514921}, {-0.45172520660197873`, 
        1.2649855081745047`}, {-0.5158189419089344, 
        1.2540716729301442`}, {-0.5799181135837871, 
        1.2400102849239318`}, {-0.6438696392285148, 
        1.2227736250629604`}, {-0.7075200679081368, 
        1.2023415727397608`}, {-0.7707386281756257, 
        1.1787049166637287`}, {-0.799078161952956, 1.1665606269529414`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8082697560746255, 
        1.1626217695675451`}, {-0.8333822975097055, 
        1.1518603371121627`}, {-0.8952805394005738, 
        1.1218082134241214`}, {-0.9562649072574587, 
        1.0885568765794538`}, {-1.0161690444086193`, 
        1.0521226091987999`}, {-1.0748286841013455`, 
        1.01252964554359}, {-1.1320816495019577`, 
        0.9698101715160445}, {-1.1491425404473465`, 0.9557763803966897}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1568654744102358`, 
        0.9494237202448438}, {-1.1877678536958063`, 
        0.9240043246591763}, {-1.241769399051258, 
        0.875150209763368}, {-1.2939498044058326`, 
        0.8232990307692895}, {-1.3441274503762795`, 
        0.7685217026550945}, {-1.3921270847638694`, 
        0.7108960270377618}, {-1.4309149337238063`, 0.6595875510758291}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.4369453868629378`, 
        0.6516104817557882}, {-1.4377798225543965`, 
        0.6505066921730969}, {-1.4809231459181769`, 
        0.5874452729557303}, {-1.5214009042100485`, 
        0.5218102309191195}, {-1.5590633139693721`, 
        0.4537069142355479}, {-1.5938049638495435`, 
        0.3832244098885922}, {-1.6255072160359314`, 
        0.3104706254917394}, {-1.6288271462024042`, 
        0.30174937724352346`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.6323848065517754`, 
        0.29240362672050435`}, {-1.6540130385370013`, 
        0.23558761829417238`}, {-1.6791758204048892`, 
        0.15872186308229685`}, {-1.7008593717354012`, 
        0.08002425217974052}, {-1.718937923668014, -0.0003499045526464406}, \
{-1.7332961283858743`, -0.08224087971679017}, {-1.734698846209352, \
-0.09332681132135293}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7359541507234764`, -0.10324770899126261`}, \
{-1.743829059115799, -0.16548452837739408`}, {-1.7505118592399884`, \
-0.24995434755341484`}, {-1.7532941851978299`, -0.3354977327220909}, \
{-1.7520540832963638`, -0.4219081250890366}, {-1.7471002921716492`, \
-0.5022808812124216}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7463295984520784`, -0.5122486457321929}, \
{-1.7371080325549344`, -0.5965040402828665}, {-1.7232474277403165`, \
-0.6842767895636506}, {-1.7050550831170816`, -0.7720909989505056}, \
{-1.6824982964035349`, -0.8597404536917197}, {-1.6690412335588627`, \
-0.9039337602013046}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.6661282452738435`, -0.913500081294146}, \
{-1.660635306665499, -0.9315390190890313}, {-1.635751721866957, \
-1.0029871892369975`}, {-1.607878956561032, -1.0739650539691754`}, \
{-1.5770538486130814`, -1.144353394594205}, {-1.5433186592006938`, \
-1.2140336838958117`}, {-1.5081310158286114`, -1.2802354307785966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5032098763922002`, -1.2889390647785037`}, \
{-1.4673141972541315`, -1.350799457039071}, {-1.424230985015206, \
-1.4175333320759713`}, {-1.3787499864922808`, -1.4831288115348522`}, \
{-1.3303013064946478`, -1.5473893179493636`}, {-1.2789516111049455`, \
-1.610199435741108}, {-1.2739028913633146`, -1.6159060118522917`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2672767146736377`, -1.6233955901099228`}, \
{-1.2247675664058117`, -1.6714437493316847`}, {-1.1678158384798845`, \
-1.7310068431426957`}, {-1.1081630934098008`, -1.7887733015957419`}, \
{-1.0458759972781995`, -1.8446277091124248`}, {-0.981021216167718, \
-1.8984546501143444`}, {-0.9790728876541528, -1.8999472417252203`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.971134607532255, -1.9060286649719844`}, \
{-0.9136043471088339, -1.950101922372699}, {-0.8436531940600828, \
-1.9994307006224679`}, {-0.7712677334961905, -2.046345634730928}, \
{-0.6965479418918818, -2.090751374565354}, {-0.6361311367133808, \
-2.1235695501423115`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6273438517303672, -2.1283427694571246`}, \
{-0.6195937957218829, -2.1325525699930226`}, {-0.5405052714609195, \
-2.1716538708812085`}, {-0.459382345583717, -2.207959927097188}, \
{-0.3763249945650006, -2.241375388508237}, {-0.29128928278403277`, \
-2.271762660718575}, {-0.2586052958623222, -2.2819942788202194`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.24906198294688614`, -2.28498178256048}, \
{-0.20428360629115366`, -2.2989995108826244`}, {-0.11548643906770485`, \
-2.3230136311929637`}, {-0.02507625509502797, -2.343732713842172}, {
        0.06676847164553412, -2.361084451022828}, {
        0.14081476658579262`, -2.3721492143495797`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.15070495508386741`, -2.373627108619326}, {
        0.15986926717263988`, -2.37499653492751}, {
        0.25404765750494757`, -2.3853966577487973`}, {
        0.3491251686611144, -2.392212511679267}, {
        0.40555702553956163`, -2.394503185698135}, {
        0.46219705184428916`, -2.395475460846618}, {
        0.5190452475752971, -2.395129337124715}, {
        0.5497177881236338, -2.3942345178251534`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5597135354301302, -2.393942908866668}, {
        0.5761016127325852, -2.393464814532427}, {
        0.6333661473161538, -2.3904818930697544`}, {
        0.6908388513260028, -2.386180572736696}, {
        0.7485197247621321, -2.3805608535332525`}, {
        0.8064087676245419, -2.373622735459424}, {
        0.8643845424460292, -2.36533363199506}, {
        0.9223256117593912, -2.3556609566200106`}, {
        0.9567672158826616, -2.349084910964907}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.966589775481324, -2.3472094582380363`}, {
        0.9802319755646276, -2.3446047093342752`}, {
        1.0381036338617387`, -2.3321648901378547`}, {
        1.0959405866507244`, -2.318341499030748}, {
        1.1537428339315847`, -2.3031345360129554`}, {
        1.2115103757043197`, -2.286544001084478}, {
        1.2692432119689294`, -2.2685698942453145`}, {
        1.326810788274566, -2.2492021341052544`}, {
        1.3516060219070432`, -2.240209324207568}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3610068312184174`, -2.2367998104165445`}, {
        1.3840825501703824`, -2.2284306392740856`}, {
        1.4410584976563785`, -2.2062554097518086`}, {
        1.497738630732554, -2.182676445538423}, {
        1.5541229493989093`, -2.1576937466339294`}, {
        1.610211453655444, -2.1313073130383273`}, {
        1.6660041435021584`, -2.103517144751617}, {
        1.7215010189390525`, -2.074323241773798}, {
        1.7252462487005833`, -2.072354505898756}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.734097804268787, -2.0677015537151417`}, {
        1.7760965803821458`, -2.04562427074267}, {
        1.8302762837672781`, -2.0155701983468823`}, {
        1.8840725256995305`, -1.9841593086763576`}, {
        1.937388116363659, -1.9513967494613293`}, {
        1.9912472165545176`, -1.9129433965137452`}, {
        2.0444385572523616`, -1.873047175462322}, {
        2.070400735403507, -1.8525889809846636`}}]}, 
      {Arrowheads[{{0.017718733406797076`, 1.}}], 
       ArrowBox[{{2.078255189572044, -1.8463996716763194`}, {
        2.0968516306228935`, -1.8317456774931002`}, {
        2.1485232726108783`, -1.7890263722107334`}, {
        2.199064445643444, -1.7472331574141997`}, {
        2.248758030826877, -1.7041349017314662`}, {
        2.297604028161178, -1.659731605162533}, {
        2.3456024376463462`, -1.6140232677074}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2152303616974011, -0.28042702973985895`}, \
{-0.15754067421779439`, -0.33291996871865415`}, {-0.08727224031167283, \
-0.3737875580006568}, {-0.006697413648318003, -0.3998654288555584}, {
        0.08110950542760084, -0.408808280089126}, {
        0.14844231091897536`, -0.40118359594850517`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15837880591860834`, -0.4000583994668768}, {
        0.17286788412808113`, -0.3984176740577724}, {
        0.2640826120709046, -0.3676725750419981}, {
        0.35011926326192977`, -0.31612699026035673`}, {
        0.4264617591248018, -0.24470332749055243`}, {
        0.4595110576247032, -0.20205095594377892`}, {
        0.4753905003686917, -0.17617116078048423`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4806203418056172, -0.16764773667132382`}, {
        0.4883528478723934, -0.15504555180039317`}, {
        0.5125722337087619, -0.10421603232839388`}, {
        0.5317543189746988, -0.050091314795779676`}, {0.5452825451588141, 
        0.0069487838614680705`}, {0.5527016836315417, 0.06640516644175322}, {
        0.5538388330565057, 0.127569995278656}, {0.5485210920973299, 
        0.18973543270575477`}, {0.5431599457064132, 
        0.21862101328873998`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5413351156974537, 0.22845310337368127`}, {
        0.5387303303242247, 0.24248755278309628`}, {0.5239075497126736, 
        0.2950856877094599}, {0.5041023536773369, 0.34705896303243766`}, {
        0.47936434563287394`, 0.3979365042996232}, {0.44958408954146667`, 
        0.4472331102134053}, {0.41477938092727934`, 0.49447504095233596`}, {
        0.37519067054794536`, 0.5392086142782517}, {0.3440489124337388, 
        0.5686845340901876}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33678626604295386`, 0.5755586862126256}, {
        0.33105840916109813`, 0.5809801479529891}, {0.2824949245300712, 
        0.6192645439893916}, {0.22971504281363792`, 0.6535938369994969}, {
        0.17311296236259194`, 0.6836000436439332}, {0.11308288152772678`, 
        0.7089151805833288}, {0.049815151304472595`, 
        0.7290727605175513}, {-0.01633679942744882, 
        0.7436850993150766}, {-0.020254998902972457`, 
        0.7441902067777206}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.030172927423173318`, 
        0.7454687582503592}, {-0.08473415549080944, 
        0.7525024183894458}, {-0.15473810170837873`, 
        0.7552749391541987}, {-0.2509833633499199, 
        0.7489039864963659}, {-0.3480718337999697, 
        0.7304949081085088}, {-0.4239620170955642, 0.7062983599409237}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43348947146750094`, 
        0.7032606612740605}, {-0.4445279605718439, 
        0.6997411898258198}, {-0.4919934871049713, 
        0.6792945758639449}, {-0.5386695709461518, 
        0.6557230579743114}, {-0.5894801873197745, 
        0.6263639451188037}, {-0.6388663547753407, 
        0.5932093245201218}, {-0.6865453344856598, 
        0.5563111708500834}, {-0.7322401069338265, 
        0.51574120065281}, {-0.7637201703685159, 0.483752072602511}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7707342979616889, 
        0.4766245194384378}, {-0.7756877783178507, 
        0.4715909362712168}, {-0.8166222530635595, 
        0.42397157408016883`}, {-0.8547733760282061, 
        0.37301397796336894`}, {-0.8898808288020043, 
        0.3188687849877587}, {-0.9360548413670351, 
        0.23260672925337209`}, {-0.9741422771352948, 
        0.14028236985269524`}, {-0.975357669895924, 
        0.13622003193285484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9782239893551652, 
        0.12663962417756724`}, {-1.0033422584464526`, 
        0.04268413232695828}, {-1.022953881092223, -0.059340394900142424`}, \
{-1.0324251330829455`, -0.1649768414745168}, {-1.031315634105116, \
-0.2673858130726401}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.030896799459371, -0.27737016730631997`}, \
{-1.0265250379423716`, -0.328027023170868}, {-1.0189737837244246`, \
-0.3830325855649804}, {-1.0085600535212644`, -0.4381258756081202}, \
{-0.9952533472741129, -0.49316157480336903`}, {-0.9790355592938721, \
-0.548020368434877}, {-0.9598939331773839, -0.6025682173267198}, \
{-0.9378179834570557, -0.6566385616319617}, {-0.9346274804180396, \
-0.6634536725811652}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9303875876266182, -0.6725103446585484}, \
{-0.9128054663609809, -0.7100668383156166}, {-0.8848623798129401, \
-0.7626904811546478}, {-0.8540029634324002, -0.8143489207379685}, \
{-0.8202496985345138, -0.8648835844664433}, {-0.7836333081301199, \
-0.914137896552887}, {-0.7441824268579312, -0.961999061192125}, \
{-0.7073930219619015, -1.0023526134050271`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.700587098607199, -1.009676606945184}, \
{-0.6569664081631666, -1.0529653714970382`}, {-0.6093336311188752, \
-1.0957178608143137`}, {-0.5591178155651455, -1.13642555814824}, \
{-0.5064029912455846, -1.1749282695331764`}, {-0.4512803277255876, \
-1.2110722546869042`}, {-0.39384813439233607`, -1.244710227010628}, \
{-0.3830737565188886, -1.2503136863481568`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3742018523742462, -1.2549277211170198`}, \
{-0.3341858136884074, -1.2757389687137524`}, {-0.2723933364332817, \
-1.3040423230025537`}, {-0.20860849057086192`, -1.3294662845086633`}, \
{-0.14297342554508918`, -1.3518673138271116`}, {-0.07563465229994126, \
-1.3711123375163288`}, {-0.006743043279434091, -1.387078748098145}, {
        0.0012891203419983094`, -1.3885158068599466`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.011132813639236818`, -1.3902769718919359`}, {
        0.06354616757237669, -1.3996544040577894`}, {
        0.13507338481139763`, -1.4087376298438898`}, {
        0.20771379648447086`, -1.4142872903961565`}, {
        0.28131804772083163`, -1.4162469004167608`}, {
        0.3556863180491983, -1.4145114639053362`}, {
        0.4093227818922205, -1.4105604875667799`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4192957612560741, -1.4098258566334876`}, {
        0.43061860096395366`, -1.408991792107869}, {
        0.5059147039251473, -1.3996145035166974`}, {
        0.5813742483584943, -1.386322023870512}, {
        0.6567966696553744, -1.3690725861543553`}, {
        0.7319812171728336, -1.3478402305996224`}, {
        0.8081737552966216, -1.3213918297950122`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.817620773965762, -1.318112525255188}, {
        0.8303893067964545, -1.3136802372344856`}, {
        0.9276042846762083, -1.272501820345682}, {
        1.0231452202959228`, -1.2244406571364284`}, {
        1.1164945317742552`, -1.1693179763709753`}, {
        1.162206832435481, -1.139234999665231}, {
        1.1710461220115491`, -1.1329831009829054`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1792104010923126`, -1.1272086272327348`}, {
        1.2071888243775075`, -1.1074199025660105`}, {
        1.25138157613598, -1.0738998100827353`}, {
        1.294726156246543, -1.038701847224826}, {
        1.3371636332448442`, -1.0018531390017025`}, {
        1.3786350756665282`, -0.9633808104227848}, {
        1.4190815520472413`, -0.9233119864974939}, {
        1.4584441309226284`, -0.88167379223525}, {
        1.4766090342700653`, -0.8611285420906798}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.483232780192732, -0.8536368139888361}, {
        1.4966521571245488`, -0.8384589487079096}, {
        1.533639238649874, -0.7936726875100787}, {
        1.5693528387817708`, -0.7473608994353044}, {
        1.603740420803404, -0.6995694752771328}, {
        1.6367494479979408`, -0.6503443058291102}, {
        1.6683273836485468`, -0.5997312818847821}, {
        1.6984216910383882`, -0.5477762942376954}, {
        1.7103930003143533`, -0.5254539419645545}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7151191730376294`, -0.5166412640860796}, {
        1.7269798334506303`, -0.4945252336813965}, {
        1.753929924518954, -0.4400060663339747}, {
        1.779207114113216, -0.3842532763773225}, {
        1.8027694198708468`, -0.3273225317006892}, {
        1.8245748594292777`, -0.2692695001933249}, {
        1.8445814504259406`, -0.21014984974447937`}, {
        1.8627472104982656`, -0.15001924824340213`}, {
        1.8637819814943366`, -0.146137278809202}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.8663576299879914`, -0.13647466866301822`}, {
        1.8790301572836845`, -0.08893336357934331}, {
        1.893388308419628, -0.026947863641552106`}, {1.908113662453539, 
        0.049518391926908045`}, {1.9197833556664363`, 0.12730061167259465`}, {
        1.9283588499757809`, 0.2062241792517488}, {1.931843004719376, 
        0.2573655673270223}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.9325227080319014`, 0.26734244075545377`}, {
        1.9338016072990336`, 0.2861144783206123}, {1.9360730895536558`, 
        0.3667968925354268}, {1.9351347586571077`, 0.4480968055524339}, {
        1.9309480765268507`, 0.5298396010278754}, {1.9234745050803457`, 
        0.6118506626179925}, {1.9160453744963752`, 0.6663101836034845}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.9146937365619245`, 0.6762184162861657}, {
        1.909994140052624, 0.7106689851419401}, {1.8915410692069747`, 
        0.8094286664126026}, {1.868115292543398, 0.9081297064299799}, {
        1.839716810061894, 1.0067721051940723`}, {1.8201534219555722`, 
        1.064201077934058}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8169288491289424`, 1.073666918102039}, {
        1.8063017471293152`, 1.1048631274562064`}, {1.7678262291125135`, 
        1.2019100379677081`}, {1.7242902560114903`, 1.2979128367285782`}, {
        1.6756938278262448`, 1.3928715237388165`}, {1.650526048162849, 
        1.4367261399919788`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.6455485657834348`, 1.4453993556103422`}, {
        1.6220918021518098`, 1.4862725427315}, {1.5635390365832187`, 
        1.5776023374397061`}, {1.5324061263386148`, 1.6224905256871305`}, {
        1.5000355311204714`, 1.6668609078634349`}, {1.4664272509287892`, 
        1.7107134839686202`}, {1.4315812857635681`, 1.7540482540026863`}, {
        1.4163405730820744`, 1.7725597575436798`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.4099845082899278`, 1.78027988969009}, {
        1.3636568185333073`, 1.836549908743534}, {1.291284928602848, 
        1.9166718685907946`}, {1.2494219676084475`, 1.9559437543940135`}, {
        1.2064098593770232`, 1.9943759361946614`}, {1.162303003075748, 
        2.031875215527047}, {1.126414203307418, 2.0609209017537564`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1186409971355598`, 2.0672119482334597`}, {
        1.1170832656488976`, 2.0684726585464017`}, {1.0732733393700171`, 
        2.1039295805270464`}, {1.0284889906977888`, 2.138427658683751}, {
        0.9827302196322122, 2.1719668930165157`}, {0.9359970261732875, 
        2.2045472835253395`}, {0.8882894103210149, 2.236168830210224}, {
        0.8396073720753943, 2.266831533071168}, {0.7910071409999961, 
        2.295903569105418}}]}, 
      {Arrowheads[{{0.014230264992898903`, 1.}}], 
       ArrowBox[{{0.7823249990003422, 2.3008649031863957`}, {
        0.7393200284041086, 2.325280407321235}, {0.68779746510388, 
        2.3529627961509783`}, {0.6354659636611758, 2.3794787760380207`}, {
        0.5823255240759962, 2.4048283469823617`}, {0.5283761463483412, 
        2.429011508984002}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.6372851535830713, -0.9366181491302348}, \
{-0.5980603152221183, -0.974766884407405}, {-0.5566797130249603, \
-1.0113900280599104`}, {-0.5132052237606559, -1.0463608759209544`}, \
{-0.4677034973010914, -1.0795572829877884`}, {-0.42024595662097775`, \
-1.1108616634217165`}, {-0.3709087977978522, -1.1401609905480923`}, \
{-0.3197729900120796, -1.167346796856319}, {-0.314566046820035, \
-1.169806817363903}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3055243558536245, -1.1740785646022038`}, \
{-0.2669242755468488, -1.1923151739998508`}, {-0.2124378361314413, \
-1.2149850894252685`}, {-0.15640153194988188`, -1.2352706265033235`}, \
{-0.09892605592917464, -1.2530688548501279`}, {-0.04012523850909802, \
-1.2682833570196124`}, {0.019883952357793055`, -1.2808242285035258`}, {
        0.07566162859180131, -1.2897561936759396`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.08556520076337659, -1.2911213846222274`}, {
        0.1430438950579348, -1.2975580260707276`}, {
        0.20594502342220536`, -1.301603707826606}, {
        0.26958132637836907`, -1.3026923480654473`}, {
        0.33383276725911615`, -1.3007719735580727`}, {
        0.3985454930310065, -1.2957840767989501`}, {
        0.46356529161001847`, -1.287677844854856}, {
        0.4840389049929258, -1.2841381472294586`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.4938927182284156, -1.2824345144286218`}, {
        0.5287375918615465, -1.2764101593648776`}, {
        0.5939074636003985, -1.2619455965404105`}, {
        0.6589196175908014, -1.2442564271651604`}, {
        0.7236184055463978, -1.223322616595142}, {
        0.7878711498081731, -1.1991351055949786`}, {
        0.8515327859214652, -1.1716908380482214`}, {
        0.8735731424538011, -1.1609329688091858`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.8825597862227919, -1.1565465997219726`}, {
        0.9144304132048016, -1.140990588314647}, {
        0.9763932604251024, -1.1070431752822139`}, {
        1.0372526857976856`, -1.0698654623670616`}, {
        1.0968421769862637`, -1.0294823575135101`}, {
        1.1549973511029425`, -0.9859268131940623}, {
        1.211555954708226, -0.9392398264094005}, {
        1.214951736514307, -0.9361575337792243}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.2223563248077838`, -0.9294365165791194}, {
        1.2663983419524778`, -0.8894603365371352}, {
        1.3193861277037449`, -0.836640535703261}, {
        1.3703353820229658`, -0.7808525586512074}, {
        1.4190686220878967`, -0.7221755070897842}, {
        1.4654148121931112`, -0.6606954496931845}, {
        1.4862021081280807`, -0.6302273423100171}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.4918379906969637`, -0.6219667837532509}, {
        1.5092093637500021`, -0.59650542210098}, {
        1.5502941352867807`, -0.5297054269181232}, {
        1.5885174324484752`, -0.4604024337149499}, {
        1.62377243814008, -0.38868699050826255`}, {
        1.6559389695096074`, -0.3146686703611058}, {
        1.674036372751666, -0.2669974137978723}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.6775855213678275`, -0.2576484275372984}, {
        1.6848580286532926`, -0.23849155977973654`}, {
        1.710381163999459, -0.16030421746043888`}, {
        1.7323704703085165`, -0.08025967428952896}, {1.7506985886729625`, 
        0.0014845666566467575`}, {1.7652487065173819`, 0.08476653011171281}, {
        1.7709907757889374`, 0.13034046095674662`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7722408387262243`, 0.14026202044368322`}, {
        1.7759145575984463`, 0.1694197686192621}, {1.782670772521941, 
        0.2553157475682215}, {1.7854662586258496`, 0.342299608317033}, {
        1.7841776123046342`, 0.4301620998813466}, {1.7786994803399938`, 
        0.5186940201572225}, {1.7764277700346847`, 0.5394183806961363}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7753381421305456`, 0.5493588389869055}, {
        1.7689445599008635`, 0.607686215921128}, {1.754843598543416, 
        0.6969295828299383}, {1.7363453942110603`, 0.786215065420939}, {
        1.7134167952344417`, 0.8753336571118225}, {1.693685896523078, 
        0.9401680647325019}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.690716308565931, 0.9497159004683567}, {1.665976251686228, 
        1.0208146472289037`}, {1.6376992376322033`, 1.0929027752871503`}, {
        1.6064319704925805`, 1.1643951686038267`}, {1.5722169567191269`, 
        1.2351720686864336`}, {1.5351021628644153`, 1.305114404293296}, {
        1.5293579637853123`, 1.3150312560612543`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.5243457296034812`, 1.3236844351595096`}, {
        1.4951410155818237`, 1.3741037914335648`}, {1.4514605444214157`, 
        1.4419052425597498`}, {1.4053479313143875`, 1.5085556637319988`}, {
        1.3562293738340974`, 1.573857723020941}, {1.3041719488859378`, 
        1.6376947545627898`}, {1.2936210286583365`, 1.6496528919245874`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.287004945364141, 1.6571513878967319`}, {
        1.2492427333752991`, 1.6999500924937574`}, {1.1915088042075739`, 
        1.7605070709500577`}, {1.1310372382881528`, 1.819249024067903}, {
        1.0678951125224279`, 1.8760592859835068`}, {1.00214950381579, 
        1.930821190833082}, {0.9986237661887555, 1.9335326752685014`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{0.9906968511367716, 1.9396289050672075`}, {
        0.933805876060161, 1.9833811662261924`}, {0.8628920978796325, 
        2.0335990603275476`}, {0.7895088532778529, 2.081378338106078}, {
        0.7137568262584698, 2.1266224645307146`}, {0.6562416349812311, 
        2.1580356752383247`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.647465329090993, 2.162829051388907}, {0.6357367008251317, 
        2.169234904570387}, {0.5555491609814869, 2.209119123194025}, {
        0.47329489073118336`, 2.2461785853705605`}, {0.38907457407786916`, 
        2.280316756068923}, {0.3028437462698598, 2.311395152818424}, {
        0.27965192238949665`, 2.318727385651538}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.2701170996318654, 2.3217418764842583`}, {
        0.21461072392104627`, 2.33929054676278}, {0.12455536308344001`, 
        2.363929283292534}, {0.03285751980905194, 
        2.3852377077982254`}, {-0.060302949850106154`, 
        2.403142165670397}, {-0.11903573214898792`, 2.4121139910236598`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.12892106209683465`, 
        2.4136240412950762`}, {-0.15474618984202249`, 
        2.4175690022995875`}, {-0.2502923441146861, 
        2.4284445630763396`}, {-0.34676155661608554`, 
        2.435695193391194}, {-0.40398849370346135`, 
        2.4382213806592627`}, {-0.4614309419158406, 
        2.4394157439614763`}, {-0.5190889012532234, 
        2.4392782832978344`}, {-0.5276613588129198, 2.4390606467878957`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5376581376481309, 
        2.4388068497826407`}, {-0.5769623717156096, 
        2.437808998668338}, {-0.6350513533029993, 
        2.4350078900729852`}, {-0.6933558460153926, 
        2.430874957511778}, {-0.7518758498527893, 
        2.4254102009847154`}, {-0.8106113648151896, 
        2.4186136204917976`}, {-0.869440190915206, 
        2.4104518844370366`}, {-0.9282401281654513, 
        2.400891661224444}, {-0.9353273999994172, 2.3995701370818825`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.945157960905591, 
        2.397737087090746}, {-0.9870111765659256, 
        2.3899329508540204`}, {-1.0457533361166287`, 
        2.3775757533257655`}, {-1.1044666068175606`, 
        2.363820068639679}, {-1.1631509886687217`, 
        2.348665896795761}, {-1.2218064816701113`, 
        2.3321132377940126`}, {-1.28043308582173, 
        2.314162091634432}, {-1.3319095438863877`, 2.2971162677950945`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3413826098650694`, 
        2.2939146319113464`}, {-1.3970738206050315`, 
        2.2740212081343425`}, {-1.4549564994940587`, 
        2.2518206883669745`}, {-1.5125473860480034`, 
        2.2282001165880576`}, {-1.5698464802668657`, 
        2.203159492797592}, {-1.6268537821506457`, 
        2.176698816995577}, {-1.6835692916993432`, 
        2.1488180891820137`}, {-1.7084565738130093`, 
        2.1358941485118654`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.717331286930609, 
        2.1312855188803694`}, {-1.7399930089129583`, 
        2.1195173093569015`}, {-1.7953072094395397`, 
        2.090810716524266}, {-1.8502113577429942`, 
        2.060742086644723}, {-1.904737749101474, 
        2.0293098709072286`}, {-1.9587894976805227`, 
        1.996518715744915}, {-2.013404235026105, 
        1.958035137190397}, {-2.058880556193029, 1.9243766633439632`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0669184683918322`, 
        1.9184275484951538`}, {-2.0673589270263233`, 
        1.9181015510299009`}, {-2.1205434231810205`, 
        1.8767545759667181`}, {-2.1729944403235817`, 
        1.8339820057664182`}, {-2.224540234418875, 
        1.7919343829652947`}, {-2.275237791302834, 
        1.7485607516741775`}, {-2.3250871109754585`, 
        1.7038611118930669`}, {-2.3718895575201966`, 1.6599005943963983`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.487159513781295, -1.1310976383068756`}, \
{-2.471972006446341, -1.192485426955094}, {-2.455322969902396, \
-1.2538248300408745`}, {-2.43721240414946, -1.3151158475642173`}, \
{-2.417640309187534, -1.376358479525122}, {-2.396597101120562, \
-1.4374156062056047`}, {-2.374073196052488, -1.4981501078876815`}, \
{-2.3682980128666205`, -1.5126843898326539`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.364605353636635, -1.5219776275790589`}, \
{-2.3500685939833135`, -1.5585619845713523`}, {-2.3245832949130376`, \
-1.6186512362566168`}, {-2.2976172988416605`, -1.6784178629434756`}, \
{-2.2691706057691823`, -1.7378618646319282`}, {-2.239243215695603, \
-1.7969832413219748`}, {-2.207835128620922, -1.8557819930136152`}, \
{-2.193248085710886, -1.8830999819201746`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.1885378173267744`, -1.8919211707147554`}, \
{-2.1773479046042827`, -1.9128771597732415`}, {-2.145468814801469, \
-1.9695356133316808`}, {-2.1121958912495025`, -2.025790035286129}, \
{-2.0775350378373196`, -2.0815423808449993`}, {-2.037058657384927, \
-2.137780569036707}, {-1.9951058042931895`, -2.19332897178127}, \
{-1.969436896798332, -2.225715949802381}}]}, 
      {Arrowheads[{{0.0044355913101495215`, 1.}}], 
       ArrowBox[{{-1.9632255222821975`, -2.23355296623852}, \
{-1.951714375054836, -2.2480768127374415`}, {-1.9068717375056239`, \
-2.302061017352304}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{1.6956016088787649`, -2.4920063141281146`}, {
        1.7588781190773355`, -2.4642852943988105`}, {
        1.8218347776461206`, -2.435016061227807}, {
        1.8844715845851197`, -2.4041986146151024`}, {
        1.9467885398943334`, -2.3718329545606984`}, {
        2.0065904297151334`, -2.3407745476310517`}, {
        2.054030861682845, -2.3148213731582823`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.0628038576838685`, -2.3100219418205064`}, {
        2.0659640156573658`, -2.308293118370848}, {
        2.124941892208798, -2.2743870517484837`}, {
        2.1834262759061285`, -2.2390611928587703`}, {
        2.2424334109732356`, -2.1978654003084186`}, {
        2.3007627819945125`, -2.1551618967709865`}, {
        2.358304088494215, -2.110986378503709}, {
        2.392006775881207, -2.083889260772134}}]}, 
      {Arrowheads[{{0.0009812021400578618, 1.}}], 
       ArrowBox[{{2.4022654614737142`, -2.0673090153189744`}, {
        2.412628852178875, -2.0673090153189744`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6887833911683741, -0.2967896813885488}, {
        0.7250200114667311, -0.23862691375485273`}, {
        0.7564476053368271, -0.17634939179657136`}, {
        0.7827157578631752, -0.11042378838370964`}, {
        0.8034740541302889, -0.041316776386271924`}, {0.8182457394341451, 
        0.030708017663463802`}, {0.823299599997432, 0.07549081381405}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8244210088523902, 0.0854277369887566}, {0.82665513090155, 
        0.10522453016303868`}, {0.8285034213632619, 0.18152243263717702`}, {
        0.8235918036500399, 0.25889139661060323`}, {0.8065596755261463, 
        0.36065707028434024`}, {0.7772003183830122, 0.4620891769381855}, {
        0.7704406320627316, 0.478182962638404}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7665681629162953, 0.48740272308593724`}, {
        0.7353513182114847, 0.5617252855706661}, {0.7093440203599873, 
        0.610317761846529}, {0.6802307028526737, 0.65784486207625}, {
        0.649201034920911, 0.703238189174807}, {0.6152676838552481, 
        0.7473001341309962}, {0.5784786486306752, 0.7898485645554936}, {
        0.5494676640465628, 0.8197900558481754}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.5425090728291919, 0.826971838932447}, {0.5388922869151038,
         0.8307046306837986}, {0.4965806998853342, 0.8696958601336258}, {
        0.4516227553614911, 0.9066497789151787}, {0.4041037424176379, 
        0.9413935956395807}, {0.3541209666898043, 0.9737593173423175}, {
        0.2664873675777471, 1.0215816319258253`}, {0.21061098687062474`, 
        1.045607586299419}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.20142424193368938`, 1.049557740405741}, {
        0.17300072131560867`, 1.0617794018817472`}, {0.07434993077139634, 
        1.093642357971044}, {-0.028725990957929305`, 
        1.1165395142795642`}, {-0.08169569980893304, 
        1.1244628444789193`}, {-0.1354970425107005, 
        1.129962483440698}, {-0.18757993411442933`, 1.1328389306430966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1975759612602702, 
        1.1330367827192214`}, {-0.2451203706199489, 
        1.1334361942376614`}, {-0.30070192152099023`, 
        1.1312987223259372`}, {-0.35663423725991406`, 
        1.1265144716828184`}, {-0.4127937955003478, 
        1.1190433733948733`}, {-0.4690557518726557, 
        1.1088516397326793`}, {-0.5253975762272556, 
        1.095895643540885}, {-0.5816243335870999, 
        1.0801683808856597`}, {-0.5917501330038012, 1.076818219383219}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6012440037988913, 
        1.0736771340093179`}, {-0.6375894515382434, 
        1.061652096301726}, {-0.6931476814119797, 
        1.0403357764273762`}, {-0.7481550982848406, 
        1.0162151500044718`}, {-0.8024691009785972, 
        0.989292687878444}, {-0.8559484120602594, 
        0.959577602998293}, {-0.9084530778420762, 
        0.9270858504165875}, {-0.9567854249417501, 0.8939495404383341}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9648620655767992, 
        0.8880574425878481}, {-1.0100570681856211`, 
        0.8538630069023335}, {-1.0588788003185765`, 
        0.8131979482009242}, {-1.1061835220627578`, 
        0.7698870601933988}, {-1.1518280089208175`, 
        0.7239809542731646}, {-1.195672557815266, 
        0.6755367737543112}, {-1.2375809870884742`, 
        0.6246181938716105}, {-1.2493291823503916`, 0.6088940008216172}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.255314516050482, 
        0.6008830220737635}, {-1.2774206365026712`, 
        0.5712954217805164}, {-1.3150953685156155`, 
        0.5156280210299681}, {-1.3504955530139118`, 
        0.45769094202805405`}, {-1.3834762131349023`, 
        0.3975858960577989}, {-1.4138994135718592`, 
        0.33541929426667616`}, {-1.4416342605739856`, 
        0.27130224766660677`}, {-1.4488183073587473`, 
        0.2522914232760456}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.4523532516492226`, 
        0.2429370569766517}, {-1.4665569019464146`, 
        0.2053505671339601}, {-1.4885505270502102`, 
        0.13768476340955327`}, {-1.5075053668023675`, 
        0.0684300470986504}, {-1.523347286587774, -0.002311853858601512}, \
{-1.5359944521126367`, -0.07441998199791965}, {-1.5449914426060096`, \
-0.14501319343441457`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.545916358628699, -0.15496811727086887`}, \
{-1.5512807365105719`, -0.22209782575169612`}, {-1.5537331921149145`, \
-0.297344760010722}, {-1.5526175669212539`, -0.3733123587409503}, \
{-1.5478657579615753`, -0.44983499694476237`}, {-1.5394197537344039`, \
-0.5267453558965787}, {-1.5351720164720308`, -0.5537643568784644}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5336189622514704`, -0.5636430218990023}, \
{-1.5272857552526664`, -0.6039272757380868}, {-1.5114521525889324`, \
-0.6812356544339186}, {-1.4918536847148292`, -0.7584614476085884}, \
{-1.4684409549802961`, -0.8353995547688062}, {-1.4411804311135852`, \
-0.9118488193034808}, {-1.4263416425974305`, -0.9479676507589652}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.422541518731724, -0.9572174647357589}, \
{-1.410054445221259, -0.9876120284837169}, {-1.3750611937881927`, \
-1.0624959134628154`}, {-1.3362147376775744`, -1.1363111492762739`}, \
{-1.3003594911354173`, -1.1977292054087987`}, {-1.2617382404552249`, \
-1.2581414798506332`}, {-1.2284315434484232`, -1.3059299888460232`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2227136683217055`, -1.3141340064005669`}, \
{-1.2204093065328394`, -1.3174403088553968`}, {-1.176436178431811, \
-1.3755200342436689`}, {-1.1298875133833992`, -1.43227700340299}, \
{-1.080837136786573, -1.4876095692878608`}, {-1.0293640422080084`, \
-1.5414180904197448`}, {-0.9746703574264746, -1.5932626474590519`}, \
{-0.9552520571063271, -1.6104764208404787`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.947768989067409, -1.6171099487649636`}, \
{-0.9180028665704909, -1.6434967734951442`}, {-0.8588468699411993, \
-1.6917904375448374`}, {-0.7972942815245476, -1.7380490120469965`}, \
{-0.733437015306484, -1.782177869440487}, {-0.6673669852729575, \
-1.824082382164174}, {-0.6232608202510999, -1.8496864861874582`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6146124261410386, -1.854706972151691}, \
{-0.599176105409917, -1.863667922656922}, {-0.5289562897033107, \
-1.9008398633575965`}, {-0.45679945213908646`, -1.9355035767050632`}, \
{-0.3827472373089276, -1.9675133738492283`}, {-0.30685956958425026`, \
-1.9967421336814384`}, {-0.24943488216935564`, -2.0162633151835}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23996699332319762`, -2.019481867776949}, \
{-0.2292557826206017, -2.0231230802527174`}, {-0.15005521007353037`, \
-2.0465894376140894`}, {-0.06937718559858434, -2.067074429816579}, {
        0.012658957148688353`, -2.08451128091121}, {
        0.09593388451273986, -2.098833214949006}, {
        0.14994390208166825`, -2.1059626544424828`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15985790149267232`, -2.107271323873092}, {
        0.18032826283802153`, -2.1099734559809926`}, {
        0.2658531554461584, -2.117785864491934}, {
        0.3524722085761669, -2.1221531604452357`}, {
        0.4399949629485864, -2.1230518571098806`}, {
        0.5282309592839565, -2.120458467754853}, {
        0.5590984797972454, -2.118333962267085}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5690748781346858, -2.117647321012342}, {
        0.6169897383028164, -2.1143495056491353`}, {
        0.7060808407257059, -2.104701484061712}, {
        0.795313807273164, -2.0914909162615656`}, {
        0.8844981786657306, -2.07469431551768}, {
        0.9382838108511147, -2.0627753319121225`}, {
        0.9638250343013456, -2.056455378002018}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.973532275320545, -2.054053405521915}, {
        0.9919256066780664, -2.0495021354287126`}, {
        1.0454235661465858`, -2.03487472606745}, {
        1.0987776892566732`, -2.018893103828335}, {
        1.1519879760083278`, -2.001557268711367}, {
        1.2050544264015504`, -1.9828672207165465`}, {
        1.2579770404363408`, -1.9628229598438742`}, {
        1.3107558181126988`, -1.941424486093349}, {
        1.351243748034018, -1.923878362422681}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.360419192334713, -1.9199020297046046`}, {
        1.3632566293308082`, -1.91867237878054}, {
        1.4153453439908528`, -1.894567217221016}, {
        1.4670219620928326`, -1.869109001414777}, {
        1.5182864836367476`, -1.842297731361823}, {
        1.569138908622598, -1.8141334070621542`}, {
        1.6195792370503834`, -1.7846160285157704`}, {
        1.6696074689201037`, -1.7537455957226713`}, {
        1.7104437545031204`, -1.7272242330455312`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.7188302754957911`, -1.7217775583132295`}, {
        1.7192236042317592`, -1.7215221086828574`}, {
        1.768290360981491, -1.6879729563109}, {
        1.8166704571654402`, -1.653125527521371}, {
        1.8643638927836066`, -1.61697982231427}, {
        1.91137066783599, -1.579535840689597}, {
        1.9576907823225915`, -1.5407935826473527`}, {
        2.00332423624341, -1.500753048187536}, {
        2.0323468933584867`, -1.4740601065095278`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.0397072020283638`, -1.4672906267448682`}, {
        2.048271029598445, -1.4594142373101475`}, {
        2.092531162387698, -1.4167771500151873`}, {
        2.169608895516802, -1.3408061332941805`}, {
        2.207217572411441, -1.301359223198548}, {
        2.244143866400323, -1.2609600071650873`}, {
        2.2801345314749364`, -1.2161118269075195`}, {
        2.3117549160308326`, -1.1748990813535514`}}]}, 
      {Arrowheads[{{0.0055985707247047534`, 1.}}], 
       ArrowBox[{{2.31776799452296, -1.1669096523362146`}, {
        2.3495441947443156`, -1.123540194911666}, {
        2.382915029445379, -1.0758493598757939`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.09588846559184347, 0.8329915145533373}, {
        0.02264095506440067, 0.8529471663006506}, {-0.05356629185049227, 
        0.8665725212974629}, {-0.1320275410691691, 
        0.8736187226763111}, {-0.21203705850796367`, 
        0.8738369135697325}, {-0.2994848982871876, 0.8651300871450203}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.30943569691757006`, 
        0.8641393265192491}, {-0.3188386886592803, 
        0.8632031088016385}, {-0.3725216790967594, 
        0.8531080429836588}, {-0.4261476714466911, 
        0.8397683290585168}, {-0.4795248265276543, 
        0.8231610392167386}, {-0.5324613051582301, 
        0.8032632456488493}, {-0.5847009743553716, 
        0.7796573230574761}, {-0.6360526185479716, 
        0.7527580318283927}, {-0.6812274419860039, 0.72520038032918}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6897643932967431, 
        0.7199926493148063}, {-0.7117496235626016, 
        0.7065811677043126}, {-0.7844127447940255, 
        0.6530365134196151}, {-0.8533043169578355, 
        0.5922986729960933}, {-0.9177156967068955, 
        0.5246045144283649}, {-0.9770132581094895, 
        0.45023218645281216`}, {-0.9789945260087808, 0.4472457638291048}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.984522813809974, 
        0.4389128151320841}, {-1.0305435856433418`, 
        0.36954436969731796`}, {-1.0776287807794795`, 
        0.28299041782729123`}, {-1.1176424953236614`, 
        0.19107167098003836`}, {-1.1363917220315298`, 
        0.13856168111177974`}, {-1.1527738475621716`, 
        0.08467934078313086}, {-1.154217159091869, 0.07896195517556695}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.156664798595856, 
        0.06926612819389477}, {-1.1666936516023634`, 
        0.029538863040131036`}, {-1.1780625873389134`, \
-0.026742833603274258`}, {-1.1867987814586631`, -0.08404612516523347}, \
{-1.1928270341484861`, -0.1422486821959889}, {-1.1960788190952885`, \
-0.20122546977787692`}, {-1.1964922834860081`, -0.2608487475253282}, \
{-1.1940221626818384`, -0.3210145242607444}, {-1.1934701494986275`, \
-0.3272110796052861}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.192582824633492, -0.3371716345388083}, \
{-1.188624753978628, -0.3816024644835012}, {-1.1802513508892851`, \
-0.44245836949570266`}, {-1.1688609779920007`, -0.5034281569636394}, \
{-1.1544203909302482`, -0.5643578609177897}, {-1.1369040764127845`, \
-0.6250936317528195}, {-1.1162942522136485`, -0.6854817362275825}, \
{-1.1007202939304903`, -0.7248128926201706}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.097038710836692, -0.7341105238197535}, \
{-1.0925808671721626`, -0.7453685574651189}, {-1.065762522863047, \
-0.804626562462596}, {-1.0358450767541565`, -0.8631149468873553}, \
{-1.002841031856048, -0.9206624388147766}, {-0.9667707205560401, \
-0.9771006525521542}, {-0.9276623046182138, -1.0322640886386965`}, \
{-0.8929860115954009, -1.0765052822677939`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8868171108930811, -1.084375775525838}, \
{-0.8855517751834112, -1.085990133845526}, {-0.8404829527692366, \
-1.1381190611756802`}, {-0.7925074872700554, -1.188494029864111}, \
{-0.7416718757613803, -1.2369988261421578`}, {-0.6880371377385591, \
-1.283500665012279}, {-0.6316874122152022, -1.3278251974751338`}, \
{-0.5937805845498194, -1.3548085653021007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5856338135390537, -1.3606077136963177`}, \
{-0.5727132828141499, -1.3698049864448387`}, {-0.5112117777674723, \
-1.4092795067489683`}, {-0.4472863699164687, -1.4460951451285555`}, \
{-0.381046976711668, -1.4801052002380921`}, {-0.31260996021282866`, \
-1.5111698826455275`}, {-0.2420709448397877, -1.539190793327598}, \
{-0.23093443457383486`, -1.5430093610192144`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.22147506257218888`, -1.5462528593365372`}, \
{-0.16954601358117402`, -1.5640586695946836`}, {-0.0951897086838456, \
-1.5856305526650154`}, {-0.019160117563980394`, -1.6037740733764498`}, {
        0.05838112719292354, -1.6183674521864706`}, {
        0.13726884783204796`, -1.6292994991721874`}, {
        0.1681175954776956, -1.6320621015014027`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.17807773623674972`, -1.6329540634175346`}, {
        0.21733432142925463`, -1.6364696140303374`}, {
        0.298405279891086, -1.6397877860772838`}, {
        0.38034577426357224`, -1.6392208071273227`}, {
        0.4629957581575503, -1.634722233308228}, {
        0.5461446887174931, -1.626201781866284}, {
        0.5769429209372391, -1.621544623713043}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5868305149611452, -1.6200494700692945`}, {
        0.629582730111494, -1.6135846890410868`}, {
        0.7131007535312647, -1.5968117100655457`}, {
        0.7964903371921368, -1.5758391191658827`}, {
        0.8795437663330624, -1.550638709561632}, {
        0.9620540332166126, -1.5211977934656413`}, {
        0.9724346229845245, -1.517014642169293}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9817098340593646, -1.5132769343801307`}, {
        1.0167336059709768`, -1.4991631180989062`}, {
        1.071025871845557, -1.475207707922983}, {
        1.1248675157056849`, -1.449349894642751}, {
        1.178195578659701, -1.4216100845040915`}, {
        1.2309474580589561`, -1.3920107582938868`}, {
        1.28306090749781, -1.3605764713400206`}, {
        1.334474036813631, -1.3273338535113788`}, {
        1.3348707618940423`, -1.3270564363735842`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3430658985095114`, -1.3213258399077878`}, {
        1.3850645132799164`, -1.2919575542202357`}, {
        1.434850942810624, -1.25494296316264}, {
        1.483730511827456, -1.2160783973099125`}, {
        1.531642220775304, -1.1753956728834445`}, {
        1.578525070099058, -1.1329266061046253`}, {
        1.6243180602436111`, -1.088703013194845}, {
        1.6483544616412897`, -1.0639644144223883`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6553230075264393`, -1.0567922900337177`}, {
        1.6689601916538523`, -1.0427567103754927`}, {
        1.7123904647746733`, -0.9951195138679598}, {
        1.7545478800509657`, -0.9458232398936349}, {
        1.7953579735654837`, -0.8948650233360486}, {
        1.8347511775326684`, -0.842254610474317}, {
        1.8726738365949391`, -0.7880427346232075}, {
        1.902154100327097, -0.7428788356149192}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.907620100947434, -0.7345048976393623}, {
        1.9090722953947168`, -0.7322801290974876}, {
        1.9438928985744206`, -0.6750175272119255}, {
        1.9770819907764703`, -0.6163056622812898}, {
        2.008585916643286, -0.5561952676203478}, {
        2.0383510208172875`, -0.4947370765438668}, {
        2.0663033242240205`, -0.43196498237477365`}, {
        2.0881777460910413`, -0.3782322545452991}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.091948247577174, -0.36897032609906966`}, {
        2.0923762382315307`, -0.3679190020693912}, {
        2.1165271931459873`, -0.30265905439258284`}, {
        2.138713619273559, -0.23624505810921195`}, {
        2.158892946920417, -0.1687369319841421}, {
        2.1770226063927285`, -0.10019459478223666`}, {
        2.193060027996665, -0.030677965268358774`}, {2.2020759122615647`, 
        0.01499673808977818}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2040124783026487`, 0.024807431845498048`}, {
        2.2069626420383943`, 0.03975303779262757}, {2.2210832840928645`, 
        0.12818853251798118`}, {2.231694869355575, 0.21800360935358848`}, {
        2.238759518154512, 0.3090018910838745}, {2.242239350817663, 
        0.40098700049326363`}, {2.2422063243258017`, 0.4224344583424254}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2421909255531656`, 0.4324344464863084}, {
        2.2420964876730136`, 0.4937625603661805}, {2.2382930490485506`, 
        0.5871321934870499}, {2.23079115527226, 0.6808995226402962}, {
        2.2195529266721277`, 0.7748681706103441}, {2.2110573239833333`, 
        0.830745540063971}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2093273334644734`, 0.8405946027452809}, {
        2.200994226128366, 0.887663892009499}, {2.1896132181452406`, 
        0.9439816530482973}, {2.176831105021285, 1.0002460143132426`}, {
        2.1626478867565004`, 1.056456975804335}, {2.147063563350886, 
        1.1126145375215744`}, {2.130078134804442, 1.168718699464961}, {
        2.111691601117168, 1.2247694616344944`}, {2.110628181720461, 
        1.2277701575966442`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{2.107287832239936, 1.2371957644921154`}, {2.091895186873653,
         1.2806298498026065`}, {2.070680116658485, 1.3361628897417286`}, {
        2.0480463904716637`, 1.3913685814518606`}, {2.0239940083131893`, 
        1.4462469249330023`}, {1.998522970183062, 1.5007979201851542`}, {
        1.9716332760812818`, 1.5550215672083163`}, {1.9464494057976565`, 
        1.6029691654992433`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.9417330642876187`, 1.611786448249494}, {
        1.9135979199627617`, 1.6624868165676698`}, {1.8824705036353255`, 
        1.7155863850064161`}, {1.8499609227148432`, 1.768074537421282}, {
        1.8160691772013149`, 1.8199512738122672`}, {1.7807952670947398`, 
        1.8712165941793715`}, {1.7441391923951188`, 1.9218704985225954`}, {
        1.724771959400744, 1.947349714935376}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7187205269180015`, 1.9553108809873314`}, {
        1.7061009531024516`, 1.971912986841939}, {1.6666805492167382`, 
        2.0213440591374017`}, {1.6258779807379784`, 2.0701637154089836`}, {
        1.5884429395216253`, 2.1149118975600274`}, {1.5498746340763871`, 
        2.15902604394857}, {1.510165476027, 2.202533918424032}, {
        1.4693382304992535`, 2.2453522294381507`}, {1.4565991885686693`, 
        2.257041380473121}}]}, 
      {Arrowheads[{{0.0111884516294618, 1.}}], 
       ArrowBox[{{1.449231017741095, 2.2638023019085236`}, {
        1.4233835149082767`, 2.287519577205676}, {1.376269339464789, 
        2.3288210818497306`}, {1.3280477856140218`, 2.369168425209289}, {
        1.278701492874232, 2.4085910466713605`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7624958873600631`, 
        2.490665420589773}, {-1.8262331874620434`, 
        2.4613313993883748`}, {-1.8896156099242813`, 
        2.430425954414734}, {-1.9526431547467773`, 
        2.3979490856688503`}, {-2.0153158219295313`, 
        2.363900793150725}, {-2.0753384157560295`, 
        2.3312916847080363`}, {-2.1176923850485387`, 2.307082070286456}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.1263741677231542`, 
        2.3021195457685577`}, {-2.1348993709914272`, 
        2.2972465223556853`}, {-2.1940317801827147`, 
        2.261763048397995}, {-2.252636365688921, 
        2.2248480359219966`}, {-2.311662704147965, 
        2.181962949696726}, {-2.3699721792747495`, 
        2.1375603253873487`}, {-2.4274533468278205`, 
        2.091678579885938}, {-2.4521292619542625`, 2.071057861041371}}]}, 
      {Arrowheads[{{0.0015860385100881342`, 1.}}], 
       ArrowBox[{{-2.4638296535709174`, 
        2.0476700950447246`}, {-2.4801163817574294`, 2.0476700950447246`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000014`, 1.}}], 
       ArrowBox[{{2.4037345148372182`, 2.0271102687954095`}, {
        2.3712048301831965`, 2.0877523623545287`}, {2.337232862882375, 
        2.1479393335498655`}, {2.3018165297713864`, 2.2077042142423515`}, {
        2.264962080340331, 2.2669479088491933`}, {2.222134957202308, 
        2.3266375784021758`}, {2.1924664497439403`, 2.3660921423381716`}}]}, 
      {Arrowheads[{{0.008068443753518293, 1.}}], 
       ArrowBox[{{2.186456395884165, 2.374084592062918}, {2.177783440820425, 
        2.3856182919147404`}, {2.1319450949474277`, 2.4437787601084087`}, {
        2.085561192218366, 2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.564381622781802, 
        0.4619339823233991}, {-0.6135969059878413, 
        0.4173491986775392}, {-0.6594985245055178, 
        0.3677433022012669}, {-0.7016170303347863, 
        0.3134262025896493}, {-0.73939314643691, 
        0.2545767487226082}, {-0.7723394590041053, 
        0.19147863813218166`}, {-0.7938663563167657, 0.139606275430481}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7976993695133316, 
        0.13037004189970933`}, {-0.8000943148827584, 
        0.12459905349161225`}, {-0.822296060919255, 
        0.05440517747414151}, {-0.8384589969229637, -0.01884271966119042}, \
{-0.8481966603328666, -0.09471883772398072}, {-0.8512962544397704, \
-0.17250769914394398`}, {-0.8475449825344812, -0.2514938263507938}, \
{-0.8458031711733942, -0.26305975952267924`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8443139795557509, -0.2729482532566076}, \
{-0.8318758568709811, -0.35553957110516105`}, {-0.8036846916360186, \
-0.45945441290959943`}, {-0.7848289315187789, -0.5109032034529961}, \
{-0.7627823539148944, -0.5617624353683388}, {-0.7371496536995916, \
-0.611762417585823}, {-0.7156584514600576, -0.6483024909568125}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7105887687047335, -0.6569221380934631}, \
{-0.7083448792633562, -0.6607372752789245}, {-0.6771100685681256, \
-0.7082189809416406}, {-0.6428208020762122, -0.7543644744149538}, \
{-0.6055244233451589, -0.7989807952463104}, {-0.5652793590432571, \
-0.8418783277458888}, {-0.5221585449796224, -0.8828742186188677}, \
{-0.4762423642871011, -0.9217853324580959}, {-0.4406300935850602, \
-0.9486223544635444}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43264387334394744`, -0.9546406836553085}, \
{-0.42761829782736327`, -0.9584279030061061}, {-0.3763865876283746, \
-0.9926231827104987}, {-0.2876718024784652, -1.0426407168785043`}, \
{-0.19290402192960313`, -1.084997466672748}, {-0.09276922166227014, \
-1.1189655870609294`}, {-0.072606103866161, -1.1237637889312533`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.0628777656053801, -1.1260788342188939`}, {
        0.01199488727992068, -1.1438962227171987`}, {
        0.06588499043664017, -1.1528040884844326`}, {
        0.12065718468256856`, -1.1592640157197072`}, {
        0.17619309984442835`, -1.1632082572387383`}, {
        0.23237291778443048`, -1.1645753651944322`}, {
        0.2890753724002727, -1.1633101910768853`}, {
        0.33364360479423416`, -1.1602301116986589`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.34361980951948895`, -1.159540663165551}, {
        0.34617774962514114`, -1.1593638857133848`}, {
        0.40355588742771165`, -1.1526938992684084`}, {
        0.4610841758121489, -1.143263981243624}, {
        0.518998619387628, -1.130968576472626}, {
        0.576842984128467, -1.1158329829852585`}, {
        0.6344674274634163, -1.0978364871156587`}, {
        0.6917233475392416, -1.0769653057845028`}, {
        0.7296056927479534, -1.0611068611992711`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.738830040296775, -1.0572453314119266`}, {
        0.7484633832207206, -1.0532125864990063`}, {
        0.8045414140906456, -1.0265784073529238`}, {
        0.8598125604498239, -0.9970697770265483}, {
        0.9141331833170762, -0.9647006347867122}, {
        0.9673820374898937, -0.9294901811650352}, {
        1.0194282129058432`, -0.8914654079077794}, {
        1.070117126615732, -0.8506622034378077}, {
        1.076272397972157, -0.8452130118478762}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0837598615325001`, -0.8385844456807076}, {
        1.1192976927148532`, -0.807123208703535}, {
        1.1668223223429817`, -0.7608978171789293}, {
        1.2125469236843767`, -0.7120421748635111}, {
        1.2563309019677829`, -0.6606191802823511}, {
        1.2980371594664277`, -0.6066984844860741}, {
        1.3375662023463533`, -0.5503394515775313}, {
        1.3454809359443005`, -0.5378583944277895}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3508363160810535`, -0.529413283203485}, {
        1.3748044498429461`, -0.4916169829802631}, {
        1.4096016479480442`, -0.43063280135638815`}, {
        1.4418146777617915`, -0.367493564349756}, {
        1.4713075554926376`, -0.30231086458594714`}, {
        1.4979514324573384`, -0.23520122967227292`}, {
        1.5208227948743092`, -0.16862024832585604`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.523733356592806, -0.15905534522701567`}, {
        1.5422124648968552`, -0.09569193973322715}, {
        1.5596373668814885`, -0.023521620306213353`}, {1.5738134138892368`, 
        0.05010232411888055}, {1.5846267933996065`, 0.12501900415547815`}, {
        1.5919740032894525`, 0.20106562418459623`}, {1.5935795763479188`, 
        0.23370900029632946`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.5940708351185622`, 0.24369692624821088`}, {
        1.5957618518329777`, 0.27807748235484525`}, {1.5959074577017347`, 
        0.3558879705824303}, {1.5923382499646241`, 0.4343285745511492}, {
        1.5849919680878959`, 0.5132288737123933}, {1.573872949921001, 
        0.5924697362955953}, {1.564653526329308, 0.6415989428602219}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.562809153417956, 0.651427385695375}, {1.5589668241269214`,
         0.6719026993146173}, {1.5402032350270958`, 0.7513147416497244}, {
        1.5175281413921342`, 0.830496610083223}, {1.4909038164418207`, 
        0.9092428192994615}, {1.460308847845112, 0.9873516518848294}, {
        1.4406285697627128`, 1.0313416101385444`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.436544812352316, 1.0404697493472237`}, {
        1.4257381377201381`, 1.0646251583277575`}, {1.3872029026342014`, 
        1.140869157018719}, {1.3515519032253913`, 1.204315306540885}, {
        1.313055676925873, 1.2667796710546595`}, {1.271771982037057, 
        1.328151237659783}, {1.2316324495300384`, 1.38303169224597}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2256224742846356`, 1.3910220696073383`}, {
        1.1810997737605855`, 1.4471817206886097`}, {1.1318533310391634`, 
        1.5046284064573614`}, {1.0801035610609107`, 1.5605578330075598`}, {
        1.0250283974928056`, 1.6145344416158482`}, {0.9679068642694146, 
        1.6668977144518065`}, {0.95120398488836, 1.6810049544901093`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.9435642688880106, 1.6874574531870488`}, {
        0.9082078833359545, 1.7173194312622413`}, {0.8460237332762728, 
        1.7657013128361316`}, {0.7814466926742176, 1.8119450799624535`}, {
        0.7145690401136361, 1.8559524534301848`}, {0.6454830541783753, 
        1.8976251540283033`}, {0.615035633245718, 1.914404857646624}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6062775611370249, 1.9192314685630882`}, {
        0.5742810134522837, 1.9368649025457862`}, {0.5010551965192082, 
        1.9735734197716106`}, {0.4258456479139233, 2.0076011512854945`}, {
        0.3487114063708665, 2.0388171881977954`}, {0.26977324177337964`, 
        2.067151219593451}, {0.239321999067341, 2.0767380730964073`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.22978353806731178`, 2.0797410319291125`}, {
        0.1891519240048043, 2.092532934557398}, {0.10696822294848282`, 
        2.1148920221745744`}, {0.023342908487757375`, 
        2.1341581715299163`}, {-0.06160324949403034, 
        2.150261071708362}, {-0.14774948111353844`, 
        2.163130411794848}, {-0.1605286263385311, 2.1645181531232565`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17047017924566568`, 
        2.165597748322692}, {-0.23510946302628927`, 
        2.172617201029565}, {-0.323647982237309, 
        2.1786010595053367`}, {-0.4131709343875117, 
        2.1810545925860545`}, {-0.5034842151178114, 
        2.1799504056356085`}, {-0.5697597052361542, 2.17653177781233}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5797464281687555, 
        2.1760166418424594`}, {-0.594393720069122, 
        2.17526110401789}, {-0.6857053448823567, 
        2.166959293096789}, {-0.77722498519843, 
        2.155017578236197}, {-0.8687585366582558, 
        2.1394085648000045`}, {-0.9238970020613204, 
        2.128186431652593}, {-0.9748038544413787, 2.116523499662592}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.984518305003845, 
        2.1141538819017347`}, {-1.0338067447765296`, 
        2.1015954623126647`}, {-1.0885780220886738`, 
        2.0862266261201476`}, {-1.1432269033705111`, 
        2.0694755555792614`}, {-1.197753388622042, 
        2.051342250690007}, {-1.252157477843266, 
        2.0318267114523842`}, {-1.306439171034183, 
        2.010928937866392}, {-1.3604621295491208`, 
        1.9886471029699575`}, {-1.3634147640646663`, 
        1.9873440096989632`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3725634151902093`, 
        1.9833064135597858`}, {-1.4140900147424071`, 
        1.964979379801007}, {-1.4673228266140417`, 
        1.9399257683595401`}, {-1.5201605651640244`, 
        1.913486268645557}, {-1.5726032303923563`, 
        1.8856608806590582`}, {-1.6246508222990361`, 
        1.856449604400043}, {-1.6763033408840642`, 
        1.8258524398685112`}, {-1.725174859473526, 1.7953581311562983`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-1.7335669488943006`, 
        1.7899210826972387`}, {-1.7782831397293086`, 
        1.760525753432841}, {-1.8283303832698115`, 
        1.7258468464185857`}, {-1.877702516768949, 
        1.6898326660216971`}, {-1.9263995402267204`, 
        1.6524832122421753`}, {-1.9744214536431275`, 
        1.613798485080021}, {-2.0217682570181688`, 
        1.5737784845352334`}, {-2.051299676483258, 1.5476110186857972`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-2.0587841661227753`, 
        1.5409790947691682`}, {-2.0684399503518445`, 
        1.5324232106078128`}, {-2.1144365336441546`, 
        1.4897326632977592`}, {-2.155192561428974, 
        1.4518432200294389`}, {-2.195307882524382, 
        1.4129365737198567`}, {-2.234807042178689, 
        1.3730045845864645`}, {-2.273616404646967, 
        1.332071671976908}, {-2.311547713275963, 
        1.2864919643175234`}, {-2.3370386881432017`, 1.254454668027102}}]}, 
      {Arrowheads[{{0.0064206579243808225`, 1.}}], 
       ArrowBox[{{-2.343264935305781, 
        1.2466294621978298`}, {-2.3486316538636705`, 
        1.2398845199803632`}, {-2.3847917501640477`, 
        1.1922992407202326`}, {-2.420053494259109, 1.1437194926188634`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{-2.4430241610635117`, -2.044841800999949}, \
{-2.4104430890983592`, -2.1061146468366765`}, {-2.376412746194564, \
-2.166936044577026}, {-2.3409311659591037`, -2.227338998046736}, \
{-2.304004247571042, -2.287224495768588}, {-2.2610948646973754`, \
-2.3475708556553103`}, {-2.2333387950894106`, -2.3848208344683868`}}]}, 
      {Arrowheads[{{0.006821092744302866, 1.}}], 
       ArrowBox[{{-2.2273638180539623`, -2.3928395406873393`}, \
{-2.216653803342051, -2.407212894938906}, {-2.1707180076381913`, \
-2.466039419610322}, {-2.1429619356060385`, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0184081091662867`, -0.5067873791627169}, {
        1.0759191924708684`, -0.42509227429628504`}, {
        1.1271838568917605`, -0.33743822175845617`}, {
        1.1714694730002704`, -0.24413908630295406`}, {
        1.204727118262335, -0.15486110550109775`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2082039045868656`, -0.1454856256896159}, {
        1.236827818752079, -0.04269082252046425}, {1.2570615971948413`, 
        0.06403685755707506}, {1.2638259048826783`, 0.11862654650847065`}, {
        1.2682292821237293`, 0.1739498297280969}, {1.2702507739316728`, 
        0.22989828288002445`}, {1.2701280270155555`, 0.24807306785523997`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2700604916268332`, 0.25807283980120305`}, {
        1.2698694253201892`, 0.28636348162832626`}, {1.2670642813029585`, 
        0.343237001637073}, {1.2618143868936593`, 0.40041041857033527`}, {
        1.2540987871059723`, 0.4577753080921861}, {1.2438965269535767`, 
        0.5152232458666962}, {1.2298773706762682`, 0.5776234279538769}, {
        1.2127243746694811`, 0.6398814368110328}, {1.2088119188749304`, 
        0.6518486180829356}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2057044527647323`, 0.6613535459823975}, {
        1.1924654467939686`, 0.7018482103649564}, {1.169128494910485, 
        0.7633746865424406}, {1.142741426879784, 0.824311803270278}, {
        1.1133321505626186`, 0.8845104984752609}, {1.0809285738197432`, 
        0.943821710084182}, {1.0455586045119112`, 1.0020963760238348`}, {
        1.0330306354171268`, 1.020707506451819}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0274464893003394`, 1.0290031265097994`}, {
        1.0071432883411775`, 1.0591648804459457`}, {0.965642529976396, 
        1.1148650816022667`}, {0.9211425257285202, 1.1690591285696261`}, {
        0.8737294719085029, 1.2216091704248513`}, {0.8234895648272981, 
        1.2723773562447702`}, {0.7705090007958589, 1.3212258351062112`}, {
        0.76301525296278, 1.3275283282708201`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7553621012256132, 1.3339648854629764`}, {
        0.7148739761251386, 1.3680167560860017`}, {0.6566706871260901, 
        1.4126122682609699`}, {0.5958868935415962, 1.4548137568739183`}, {
        0.5325461502302017, 1.4944447031072954`}, {0.4667883461763527, 
        1.5314003999473969`}, {0.42244218546843815`, 
        1.5536766315396637`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4135062431827847, 1.5581653881010593`}, {
        0.3987533703644961, 1.5655761403805188`}, {0.3285811117790784, 
        1.5968672173929581`}, {0.2564114594045464, 1.6251689239710105`}, {
        0.18238430222534668`, 1.6503765531009726`}, {0.10663952922592544`, 
        1.6723853977691403`}, {0.036577283886393974`, 1.689227800456937}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.026829589397323553`, 
        1.6914504556223147`}, {-0.049713479558559016`, 
        1.7060250582452203`}, {-0.1300486916562981, 
        1.7174373888402237`}, {-0.21158248932588633`, 
        1.7251776798056089`}, {-0.2941344578934623, 
        1.7291956512406803`}, {-0.3705239868860921, 1.7294204253584164`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3805212427382143, 
        1.7293134518164013`}, {-0.4615712490271312, 
        1.725863515917101}, {-0.5460952422455015, 
        1.7184128493570592`}, {-0.6073669110617305, 
        1.71054669756839}, {-0.6687571905394636, 
        1.7005339505031911`}, {-0.7301910424513285, 
        1.6883733427783727`}, {-0.776376425445919, 1.6776099087104022`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7861154510414511, 
        1.6753402434378186`}, {-0.7915934285699527, 
        1.6740636090108452`}, {-0.8528893106679645, 
        1.657603483817519}, {-0.9140036505179907, 
        1.6389917018153042`}, {-0.9748614098926598, 
        1.618226997621111}, {-1.0353875505646002`, 
        1.5953081058518497`}, {-1.0955116787354866`, 
        1.5701927653120424`}, {-1.1551617117237043`, 
        1.5428536223743539`}, {-1.1616231235377632`, 
        1.5396237182905832`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1705678393983652`, 
        1.535152470346989}, {-1.214260077976946, 
        1.5133117730079049`}, {-1.2727292059429054`, 
        1.481588313181817}, {-1.330491524069274, 
        1.4477043388652124`}, {-1.387469460803745, 
        1.4116809460272124`}, {-1.4435854445940108`, 
        1.3735392306369387`}, {-1.4987619038877642`, 
        1.3333002886635132`}, {-1.5098782823539032`, 
        1.3246059302245987`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.517755194621837, 1.318445227900734}, {-1.552911542693924,
         1.2909486927231102`}, {-1.6059506011809626`, 
        1.2464822966511577`}, {-1.6578068120359046`, 
        1.1999421182456573`}, {-1.7084079079457735`, 
        1.1513691753046116`}, {-1.7576816215975934`, 
        1.1008044856260222`}, {-1.8055556856783883`, 
        1.0482890670078906`}, {-1.8085864321172536`, 1.044734301158277}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.8150743370121278`, 
        1.037124630332606}, {-1.8519578328751822`, 
        0.9938639372482194}, {-1.896815795874999, 
        0.9375701141450103}, {-1.9400655920040801`, 
        0.8793649966145819}, {-1.981640225992588, 
        0.8192363904393196}, {-2.0214629116334275`, 
        0.7572709237163249}, {-2.0480411929933386`, 0.7126992555620061}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.053162792347552, 
        0.7041103545813847}, {-2.059456862719505, 
        0.6935552245427}, {-2.0955452930437253`, 
        0.6281759210155471}, {-2.1296514163989935`, 
        0.5612196412319675}, {-2.161698446578216, 
        0.4927730132890638}, {-2.1916095973742973`, 
        0.42292266528393746`}, {-2.222571578513575, 0.3423385018646443}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.226067301162115, 
        0.33297106457213094`}, {-2.255550018792895, 
        0.24547848487758112`}, {-2.282270798158668, 
        0.15387751028273183`}, {-2.305491956628756, 
        0.06035727942676852}, {-2.325017914052913, -0.03480596835191291}, \
{-2.3280156480650516`, -0.0533136804495548}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.3296145320543222`, -0.06318503142036191}, \
{-2.3406530902808895`, -0.13133599371491653`}, {-2.3523974853126877`, \
-0.22923279666224225`}, {-2.3602510991483063`, -0.32849637719389}, \
{-2.3640610377600857`, -0.42881079620834495`}, {-2.3639370651265774`, \
-0.46121213440746434`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.363898803828446, -0.4712120612108497}, \
{-2.3636744071203655`, -0.5298601146040919}, {-2.359091207229146, \
-0.6316443323811308}, {-2.350311438086427, -0.7341634495394618}, \
{-2.3416166087327386`, -0.8164006916582516}, {-2.3342032938177177`, \
-0.8697623742984085}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.3328272513403485`, -0.8796672471951436}, \
{-2.330156251816281, -0.8988933330378628}, {-2.312614791789152, \
-0.983386542488778}, {-2.292094195414128, -1.0677568644121198`}, \
{-2.264581981304155, -1.1712605619128256`}, {-2.2347443487580243`, \
-1.2670894353087963`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.2316707946371857`, -1.2766036644713885`}, \
{-2.1959483552597128`, -1.3765463613489828`}, {-2.1759546992018324`, \
-1.427509145465261}, {-2.154826943325244, -1.4783284632844345`}, \
{-2.132566230022787, -1.5289064770021181`}, {-2.1091737016873005`, \
-1.5791453488139267`}, {-2.084649358318784, -1.6290450787198598`}, \
{-2.076463626336561, -1.6448576444165794`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.0718663762071476`, -1.6537382576413298`}, \
{-2.058993199917239, -1.678605666719918}, {-2.0322052264826636`, \
-1.7278271128141012`}, {-2.0042854380150597`, -1.7767094170024091`}, \
{-1.9752338345144254`, -1.825252579284842}, {-1.9450504159807618`, \
-1.8734565996613994`}, {-1.9137532796186734`, -1.9212222077079029`}, \
{-1.881360522632764, -1.968450133000173}, {-1.862800896455759, \
-1.9943263775205375`}}]}, 
      {Arrowheads[{{0.015330622926136378`, 1.}}], 
       ArrowBox[{{-1.856972598660174, -2.00245232022314}, \
{-1.8478721450230344`, -2.01514037553821}, {-1.8132881467894835`, \
-2.061292935322014}, {-1.7776085279321123`, -2.1069078123515848`}, \
{-1.7408332884509201`, -2.1519850066269215`}, {-1.7029624283459077`, \
-2.1965245181480255`}, {-1.6639959476170743`, -2.2405263469148964`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019446325424658885`, 1.}}], 
       ArrowBox[{{-1.5710748870367848`, -2.2389630246087853`}, \
{-1.531047294468045, -2.281835877098858}, {-1.4899345536022617`, \
-2.324084268513528}, {-1.447760695529135, -2.36563088539739}, \
{-1.4007129660924766`, -2.406347994896082}, {-1.3525732280068818`, \
-2.446199690014484}, {-1.3033919431219068`, -2.485105219299348}, \
{-1.2836924992271268`, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1157586894501688`, -1.2987569874677507`}, \
{-1.0728584922672275`, -1.351329990030476}, {-1.0276508074725494`, \
-1.402602995238057}, {-0.9801147542111261, -1.4524574332995595`}, \
{-0.9302504855706829, -1.5007816587180534`}, {-0.8781265149528307, \
-1.5474865299521239`}, {-0.8354050624917712, -1.5828783164392308`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8277043165942344, -1.5892578550292522`}, \
{-0.8238113557591806, -1.5924829054603553`}, {-0.7673735213913431, \
-1.6356816437013335`}, {-0.7088815252509286, -1.6769936031336432`}, \
{-0.6484038807395481, -1.7163296422158696`}, {-0.5860091012588117, \
-1.7536006194065983`}, {-0.5217050443668458, -1.7886766904712736`}, \
{-0.491064953830502, -1.8038460022682559`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.48210311641083603`, -1.8082828333517518`}, \
{-0.45552162429213544`, -1.821442812154664}, {-0.3875604394418276, \
-1.8518320443843403`}, {-0.3179230882230699, -1.8797774470878732`}, \
{-0.24671116904301013`, -1.9052120801928338`}, {-0.1740262803087954, \
-1.9280690036267925`}, {-0.10741679715925005`, -1.9462488186209952`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09774834967437668, -1.9487974435904183`}, \
{-0.02464398780649371, -1.9657819611919871`}, {
        0.051884917014010434`, -1.9804492979724255`}, {
        0.12953717608742563`, -1.9921814639096995`}, {
        0.20819226489748852`, -2.0009414192255273`}, {
        0.28772965892793567`, -2.0066921241416296`}, {
        0.297331025374967, -2.007015490813965}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3073253587410286, -2.0073520923113275`}, {
        0.3680288336625037, -2.009396538879725}, {
        0.44896926458492925`, -2.009017623661533}, {
        0.5304304271789486, -2.0055183387087725`}, {
        0.6122917969282988, -1.9988616442431633`}, {
        0.6945340167900809, -1.988917001278761}, {
        0.7061946924909228, -1.9870345686781201`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7160668802157693, -1.9854408593177308`}, {
        0.7771009415492629, -1.9755878705414993`}, {
        0.8598168644313833, -1.9588882118209137`}, {
        0.9425060786619794, -1.9388319849065396`}, {
        1.0249928774665893`, -1.915433149587913}, {
        1.1038814015487506`, -1.8897538688208397`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1133074310664073`, -1.886419620934467}, {
        1.1886564017000014`, -1.8586634928960455`}, {
        1.269481713579879, -1.8253205911018753`}, {
        1.3649634476623471`, -1.7810436508034948`}, {
        1.4589249922937526`, -1.7319761480086175`}, {
        1.4770859608858629`, -1.7213952274857598`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.485726436005152, -1.7163611248136894`}, {
        1.5513663474740953`, -1.6781180827172435`}, {
        1.6422875132033758`, -1.6194694549293736`}, {
        1.6870607333261327`, -1.5883727987457472`}, {
        1.7312193226906545`, -1.556126739230986}, {
        1.7747632812969407`, -1.52273127638509}, {
        1.8150955695849567`, -1.4902762259250777`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.8227883098636344`, -1.4838879671777785`}, {
        1.8600073062348075`, -1.4524921406998945`}, {
        1.9017073725663884`, -1.415648467860595}, {
        1.9427928081397334`, -1.3776553916901606`}, {
        1.9832636129548433`, -1.3385129121885915`}, {
        2.02300428193529, -1.2982682799734873`}, {
        2.0618993100046454`, -1.2569687456624474`}, {
        2.0999486971629095`, -1.2146143092554713`}, {
        2.108521456257213, -1.2046116122432906`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.1150289406149954`, -1.19701867820346}, {
        2.1371524434100824`, -1.1712049707525596`}, {
        2.173510548746164, -1.1267407301537118`}, {
        2.209023013171154, -1.0812215874589284`}, {
        2.243689836685053, -1.034647542668209}, {
        2.2775110192878607`, -0.9870185957815538}, {
        2.327440473856665, -0.9150263623818344}, {
        2.3527453660129147`, -0.8757220148797549}}]}, 
      {Arrowheads[{{0.0107802564769792, 1.}}], 
       ArrowBox[{{2.358158664139325, -0.8673139114435093}, {
        2.375223925555277, -0.8408076153184432}, {
        2.419358000171919, -0.7603789313246376}, {
        2.46086042381678, -0.6778929401290636}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.590233331341948, 1.116707293350296}, {0.5440711940330103, 
        1.1523319494581412`}, {0.49591512880009897`, 1.1861412562360063`}, {
        0.44585422963022264`, 1.2180444124812657`}, {0.3939775905103896, 
        1.247950616991294}, {0.3403743054276093, 1.2757690685634642`}, {
        0.28513346836889164`, 1.3014089659951507`}, {0.2457224119915884, 
        1.3168155623031015`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2364087720642189, 1.320456456603038}, {0.1862767543182927,
         1.3400540982424867`}, {0.08307398357211947, 1.3713268526864173`}, {
        0.03003451235916329, 1.3840962589009362`}, {-0.02386145052252265, 
        1.3948997754672015`}, {-0.07853723090454949, 
        1.403696470652745}, {-0.1339161546185282, 
        1.4104454127250994`}, {-0.15150264392482504`, 1.4118940572571679`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.16146888939123372`, 
        1.4127150026288513`}, {-0.18994766344847125`, 
        1.415060872779482}, {-0.24657170246842736`, 
        1.4174734117919507`}, {-0.30369735244506235`, 
        1.4176665328513025`}, {-0.36123369414504175`, 
        1.415623739046332}, {-0.419089808335033, 
        1.4113285334658348`}, {-0.47717477578170236`, 
        1.404764419198606}, {-0.5353976772517169, 
        1.3959148993334418`}, {-0.5596467833599197, 1.3912742195149705`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5694685421647088, 
        1.389394577532957}, {-0.5936675935117427, 
        1.3847634769591368`}, {-0.651905581964305, 
        1.3712401366176608`}, {-0.7100283448716171, 
        1.3552943241407378`}, {-0.767938430289877, 
        1.3369387345517958`}, {-0.8255383862752824, 
        1.3161860628742628`}, {-0.8827307608840316, 
        1.2930490041315663`}, {-0.9394181021723225, 
        1.267540253347135}, {-0.9479010975008977, 1.2633251765654943`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9568564984663602, 
        1.2588753683058282`}, {-0.9955029581963529, 
        1.2396725055443962`}, {-1.0508878770123211`, 
        1.2094584557467782`}, {-1.1054698767668143`, 
        1.1768519408579656`}, {-1.1591479864826422`, 
        1.1418282007342775`}, {-1.2118277705303355`, 
        1.1044320348280925`}, {-1.2634147932804254`, 
        1.064708242591789}, {-1.2913525375418884`, 1.0414230394599788`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2990342432758462`, 
        1.0350205870379081`}, {-1.313814619103443, 
        1.022701623477746}, {-1.362932812369919, 
        0.9784569769383421}, {-1.4106749374503844`, 
        0.9320191024259562}, {-1.4569465587153705`, 
        0.8834327993929668}, {-1.5011674882220853`, 
        0.8332346312379151}, {-1.5437273991565774`, 
        0.7809324690304578}, {-1.5717339081625856`, 0.7436538626848366}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.57774043346606, 
        0.7356587608231514}, {-1.5845471137370724`, 
        0.7265985971915778}, {-1.6235474541817954`, 
        0.6703053001422565}, {-1.6606492427089714`, 
        0.612124862303477}, {-1.6957733015368253`, 
        0.5521295680962217}, {-1.7288404528835828`, 
        0.49039170194147247`}, {-1.7597715189674685`, 
        0.42698354826021184`}, {-1.7763362015007584`, 
        0.3893975484266951}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7803690620721964`, 
        0.380246808805695}, {-1.7884443678725621`, 
        0.361923581550469}, {-1.8147524873680865`, 
        0.29524984355498346`}, {-1.8386401291999832`, 
        0.2270639695618027}, {-1.8600515451141928`, 
        0.15746759485897469`}, {-1.8789309868566562`, 
        0.08656235473454711}, {-1.895222706173315, 
        0.014449884476567788`}, {-1.8981417990885676`, \
-0.0012100247762499364`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8999742889865192`, -0.011040690103373286`}, \
{-1.9088709548101095`, -0.05876818062691504}, {-1.919819984512981, \
-0.13299020528785466`}, {-1.9279597318089314`, -0.20814319616407861`}, \
{-1.9331998842136677`, -0.2841437446603692}, {-1.9355143199561888`, \
-0.36087459260911003`}, {-1.9351196984764065`, -0.4087588586578548}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.935037289762155, -0.4187585190922803}, \
{-1.934876917265493, -0.4382184818426845}, {-1.9312615543705791`, \
-0.5160581541934764}, {-1.924642109500446, -0.5942763514938697}, \
{-1.9149924608840923`, -0.6727558155762474}, {-1.9022864867505167`, \
-0.7513792882729936}, {-1.8893536687477337`, -0.8154918642785607}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.8873762938797127`, -0.8252944143871457}, \
{-1.8864033409561896`, -0.8301176878798832}, {-1.8672566225839549`, \
-0.9089098685241854}, {-1.844871877702372, -0.9875904757855247}, \
{-1.8192746523800016`, -1.0659941552435255`}, {-1.7904904926854028`, \
-1.1439555524778127`}, {-1.7650649022066096`, -1.2055217224764507`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.7612478026992089`, -1.2147645440884154`}, \
{-1.7585449446871353`, -1.2213093130680108`}, {-1.723463554453759, \
-1.2978900825937443`}, {-1.685271868053834, -1.3735325066346376`}, \
{-1.6361828261843436`, -1.4613347908201704`}, {-1.5827364658432084`, \
-1.5473903891416796`}, {-1.5702659524845914`, -1.5655791176213472`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.564611211030251, -1.5738267778401343`}, \
{-1.5249327870304294`, -1.631699301599166}, {-1.4627717897460057`, \
-1.7142615281926292`}, {-1.3963721114209777`, -1.7946561836505752`}, \
{-1.3258523894863847`, -1.872462382701509}, {-1.313732671494635, \
-1.8846759503912551`}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.3066889280799876`, -1.8917742374176167`}, \
{-1.2512126239422265`, -1.947680125345431}, {-1.1724528147885034`, \
-2.020309411582341}, {-1.1315780016313726`, -2.0555511891973244`}, \
{-1.0897733931184852`, -2.0899414640088714`}, {-1.0470389892498415`, \
-2.123480236016981}, {-1.0056686389330485`, -2.154450316813538}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9975680696140309, -2.160312937724738}, \
{-0.9587807954452852, -2.188003271622889}, {-0.9132570055093725, \
-2.218987535220688}, {-0.8668034202177034, -2.24912029601505}, \
{-0.8194200395702781, -2.278401554005975}, {-0.751582506025026, \
-2.319311832593269}, {-0.6819971413679345, -2.358308274177863}, \
{-0.657440783898358, -2.370046573521433}}]}, 
      {Arrowheads[{{0.006416668167683784, 1.}}], 
       ArrowBox[{{-0.6484185773121611, -2.374359320710405}, \
{-0.6075405183771753, -2.3938996329475692`}, {-0.5314939573396571, \
-2.427217591490897}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{2.163584822582592, -2.5}, {
        2.215405182751581, -2.471559170594909}, {
        2.2773454582091284`, -2.435870988564526}, {
        2.338776102229582, -2.3987202289154466`}, {
        2.400698781224708, -2.3555617496962653`}, {
        2.4619270063016034`, -2.3108543397862635`}, {
        2.4987165330384586`, -2.282711985939136}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.0250290075413586`, -1.386237025932758}, {
        1.086836676756269, -1.3555045924695788`}, {
        1.147871066219764, -1.322132671798602}, {
        1.2080229877988455`, -1.2861491139987058`}, {
        1.2671832533605156`, -1.2475817691487694`}, {
        1.325242674771775, -1.2064584873276716`}, {
        1.3645177696526718`, -1.1762500415288804`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3724443182932387`, -1.1701533353157907`}, {
        1.3820782681037307`, -1.1627433812071863`}, {
        1.437572066080541, -1.1164237406980348`}, {
        1.4916224055487872`, -1.0675621817375172`}, {
        1.544127623355051, -1.016221320262931}, {
        1.594986056345913, -0.9624637722115769}, {
        1.6440960413679544`, -0.9063521535207535}, {
        1.6571134039208513`, -0.8902654838404263}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6634038740268915`, -0.8824918112305838}, {
        1.6913559152677573`, -0.8479490801277595}, {
        1.736664014891902, -0.7873171679698943}, {
        1.7798817059897387`, -0.7244497402400704}, {
        1.820883798345975, -0.6593653174927938}, {
        1.8595887948602272`, -0.5921643117077576}, {
        1.8824111038195512`, -0.5486781517833507}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8870581777451747`, -0.5398235087115046}, {
        1.8959151984321105`, -0.5229471348646543}, {
        1.9297815119612423`, -0.4518141989431748}, {
        1.9611062383472382`, -0.378865915923012}, {
        1.9898078804897141`, -0.3042026977838585}, {
        2.015804941288287, -0.2279249565054053}, {
        2.033539091573298, -0.1683153630544642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.036390623058706, -0.1587305433802227}, {
        2.0389611047575493`, -0.15009041309043633`}, {
        2.0591599890521013`, -0.07077231253333757}, {2.076349998281574, 
        0.009905647198794125}, {2.090479536555595, 0.09181976813886111}, {
        2.1014970079837934`, 0.17484635231976656`}, {2.107059984932449, 
        0.23435575351325816`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.1079907334512793`, 0.24431234465655088`}, {
        2.109350816675798, 0.25886170177441364`}, {2.113989366741239, 
        0.3437421185357047}, {2.1153610622897436`, 0.4293639046365429}, {
        2.1133241529620412`, 0.5157209999614283}, {2.107769671842096, 
        0.6027645669942797}, {2.1035273149906457`, 0.6436909236449984}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.1024962565022873`, 0.6536376275409422}, {
        2.098695198204392, 0.6903067416671298}, {2.086098311323413, 
        0.7781596599120093}, {2.0699765904736442`, 0.8661354576609507}, {
        2.050327614929569, 0.9540462708459857}, {2.0271489639656717`, 
        1.0417042353991457`}, {2.02592153036865, 1.04571211225586}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.022993226086215, 1.0552737561537193`}, {2.000438216856436,
         1.1289214872524629`}, {1.9825748129835725`, 1.1812978347168277`}, {
        1.9633934807279065`, 1.2333860474029534`}, {1.9428942200894386`, 
        1.2851861253108408`}, {1.921077031068168, 1.336698068440489}, {
        1.8979419136640958`, 1.387921876791899}, {1.8787811395605527`, 
        1.4278337529505396`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.8744532646643937`, 1.4368487126777485`}, {
        1.8734888678772206`, 1.4388575503650696`}, {1.8477178937075436`, 
        1.4895050891600017`}, {1.8206289911550642`, 1.539864493176695}, {
        1.792236871597378, 1.5898055367553618`}, {1.7625562464120805`, 
        1.6391979942362145`}, {1.7315871155991722`, 1.6880418656192526`}, {
        1.6993294791586524`, 1.736337150904477}, {1.6689882995338021`, 
        1.7795221816480025`}}]}, 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{1.6631556398590366`, 1.7876441660215932`}, {
        1.6309486893947789`, 1.8312819631814827`}, {1.5948255360714254`, 
        1.8779314901732642`}, {1.5574138771204606`, 1.9240324310672317`}, {
        1.5187543574321842`, 1.9694542715196903`}, {1.4788876218968956`, 
        2.014066497186945}, {1.4378136705145945`, 2.057869108068997}, {
        1.4042494100247658`, 2.0919984430612524`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.397237612474079, 2.0991282884388314`}, {
        1.3955325032852812`, 2.100862104165845}, {1.3520441202089561`, 
        2.14304548547749}, {1.3073485212856182`, 2.184419252003931}, {
        1.2614457065152682`, 2.2249834037451692`}, {1.2143356758979063`, 
        2.264737940701204}, {1.138010604139863, 2.3276836942516512`}, {
        1.0948995705242555`, 2.3606050791168873`}}]}, 
      {Arrowheads[{{0.012242891089517541`, 1.}}], 
       ArrowBox[{{1.0869519130084482`, 2.3666742421573264`}, {
        1.0587328693509175`, 2.388223481849927}, {0.9712250066777357, 
        2.4449900255925154`}, {0.880928475195002, 2.498663202063696}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.01627850610150782, 1.}}], 
       ArrowBox[{{1.780147885761933, 2.2640882282906345`}, {
        1.7397943227504709`, 2.3123434677046935`}, {1.6982197169317073`, 
        2.3599831169700094`}, {1.6554459776350743`, 2.4069197958438}, {
        1.607265043441111, 2.4532672812037717`}, {1.55783907842309, 
        2.498730203213594}, {1.5563941937603583`, 2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.4920920618923503`, 1.578933636002447}, {
        2.4706645053973837`, 1.6363729912984055`}, {2.4479763038621476`, 
        1.6935961683240297`}, {2.4240293280532317`, 1.7506296704851083`}, {
        2.398817965670865, 1.8073939875642753`}, {2.368735358623721, 
        1.865124115852994}, {2.337304322195692, 1.9224477294017965`}, {
        2.325968034470024, 1.9421099177344285`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.3209732175328153`, 1.950773162147682}, {2.304541342871922,
         1.9792733750973899`}, {2.270440925157364, 2.035631537310872}, {
        2.234762631760958, 2.094490796698635}, {2.19765419008175, 
        2.152699767193571}, {2.159115600119738, 2.2102584487956793`}, {
        2.1191468618749223`, 2.2671668415049604`}, {2.1045905006142593`, 
        2.286947887607393}}]}, 
      {Arrowheads[{{0.012350614826359735`, 1.}}], 
       ArrowBox[{{2.098663564019866, 2.2950021673769343`}, {
        2.0777479753473043`, 2.3234249453214155`}, {2.034918940536883, 
        2.3790327602450434`}, {1.9906597574436582`, 2.433990286275843}, {
        1.9449704260676304`, 2.4882975234138165`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2199832209368062`, -2.481154255856171}, {
        1.2832420794870314`, -2.4635307570556098`}, {
        1.3462556215892196`, -2.4443485107062624`}, {
        1.4090238472433716`, -2.423607516808128}, {
        1.4715467564494868`, -2.4013077753612064`}, {
        1.5338243492075658`, -2.3774492863654992`}, {
        1.595856625517608, -2.3520320498210046`}, {
        1.5979166174464694`, -2.3511326640990116`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6070812280234499`, -2.347131425169343}, {
        1.6576435853796139`, -2.3250560657277233`}, {
        1.7191852287935827`, -2.2965213340856554`}, {
        1.7803299814450055`, -2.266436216421469}, {
        1.840926269019372, -2.234809074261832}, {
        1.9009740915166824`, -2.2016399076067446`}, {
        1.9604734489369364`, -2.1669287164562068`}, {
        1.9630380107318763`, -2.1653515798244465`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.971556157968746, -2.160113148031342}, {
        2.0194243412801343`, -2.1306755008102187`}, {
        2.077826768546276, -2.09288026066878}, {
        2.135680730735361, -2.0535429960318914`}, {
        2.19298622784739, -2.0126637068995517`}, {
        2.246582001937316, -1.9744104612470812`}, {
        2.299563570413034, -1.9348295843118508`}, {
        2.30106558742602, -1.9336567700300915`}}]}, 
      {Arrowheads[{{0.012724483589402416`, 1.}}], 
       ArrowBox[{{2.3089474513132786`, -1.927502403965034}, {
        2.3519627110124857`, -1.8939149608983747`}, {
        2.4036840905218453`, -1.851684936593112}, {
        2.45511444233224, -1.8036442674170963`}, {
        2.5, -1.7597719195081778`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3012172369354242`, 1.10687774929806}, {
        1.2669103548234468`, 1.1655111349775642`}, {1.2300804399285483`, 
        1.2232155189853609`}, {1.190761524513057, 1.2798869353688656`}, {
        1.1489876408393018`, 1.335421418175495}, {1.1047928211696112`, 
        1.3897150014526651`}, {1.0683403505535751`, 1.431082679207209}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.0617290733950053`, 1.4385854129978066`}, {
        1.0581506142693033`, 1.4426463872326976`}, {1.0090565629026096`, 
        1.4941005800988574`}, {0.9575776903302278, 1.5439830679249762`}, {
        0.9037810198128557, 1.5921993385848847`}, {0.8477335746111917, 
        1.6386548799524145`}, {0.7895023779859335, 1.6832551799013968`}, {
        0.7622273553650217, 1.7025316442049208`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7540609940170662, 1.7083031728009357`}, {
        0.7291544531977792, 1.725905726305663}, {0.6667568235074267, 
        1.766512007039044}, {0.6023122106437019, 1.8049397965846248`}, {
        0.5358467187106565, 1.8410693106584881`}, {0.4674624445318283, 
        1.874827698983964}, {0.4052614685768344, 1.9025735733653337`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.39611016695251666`, 1.9066031406350583`}, {
        0.325345936730972, 1.9349396972830701`}, {0.25181789675601884`, 
        1.9611476067033597`}, {0.1767794618294323, 1.9846929892685798`}, {
        0.10033272877474907`, 2.0055029947020597`}, {0.022541898761888654`, 
        2.023449484093373}, {0.014676168949400886`, 2.0249394079250034`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.004850880331669907, 
        2.026800510710528}, {-0.05651504680155148, 
        2.0384244234898237`}, {-0.13671534073551447`, 
        2.050385120051335}, {-0.21793621585994372`, 
        2.05928888093783}, {-0.30005490499478216`, 
        2.065093013309232}, {-0.38294864095997244`, 
        2.0677548243254646`}, {-0.39243659673590053`, 2.0676954064275823`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4024364006499432, 
        2.067632783103672}, {-0.46649465657545824`, 
        2.0672316211464516`}, {-0.5505701846611825, 
        2.063480710932116}, {-0.6351605675573233, 
        2.056366313764348}, {-0.7202118350512464, 
        2.0457864995715953`}, {-0.8003206715549505, 2.032608318227648}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8101548517429319, 
        2.0308051873349147`}, {-0.8909700797953345, 
        2.014262947830174}, {-0.9763135850269479, 
        1.9933353741410256`}, {-1.0613910308192394`, 
        1.9689747111459315`}, {-1.1460206811629328`, 
        1.941189040774652}, {-1.194828672760761, 1.923058875547492}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2042028325329754`, 
        1.9195767600173868`}, {-1.2300208000487531`, 
        1.9099864449569466`}, {-1.2801158707487543`, 
        1.8895762692745541`}, {-1.3298602625452325`, 
        1.867910978587504}, {-1.379253975438187, 
        1.8449905728957954`}, {-1.4282970094276184`, 
        1.820815052199429}, {-1.4769893645135264`, 
        1.7953844164984043`}, {-1.525331040695911, 
        1.7686986657927213`}, {-1.5640692364413908`, 
        1.7461448789044027`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5727112454671879`, 
        1.741113409934207}, {-1.5733220379747728`, 
        1.7407578000823811`}, {-1.620962356350111, 
        1.7115618193673823`}, {-1.6681286484487656`, 
        1.6811317248664448`}, {-1.7146975668975755`, 
        1.6494885177982883`}, {-1.7606691116965414`, 
        1.616632198162912}, {-1.806043282845663, 
        1.5825627659603163`}, {-1.8508200803449397`, 
        1.547280221190501}, {-1.894999504194373, 
        1.510784563853467}, {-1.89759117724983, 1.508542154364521}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.9051534192029043`, 
        1.501999028456886}, {-1.9385815543939613`, 
        1.473075793949213}, {-1.9815662309437054`, 
        1.4341539114777397`}, {-2.023831253726745, 
        1.3940643342958154`}, {-2.0652543426262184`, 
        1.3528524802602082`}, {-2.105835497642126, 
        1.3105183493709176`}, {-2.1455747187744683`, 
        1.267061941627944}, {-2.1844720060232445`, 
        1.2224832570312878`}, {-2.1873064086238836`, 
        1.2190794015278734`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.193705396056377, 
        1.2113948091614044`}, {-2.222527359388456, 
        1.1767822955809484`}, {-2.259740778870101, 
        1.1299590572769262`}, {-2.2961122644681806`, 
        1.0820135421192207`}, {-2.351108956758073, 
        1.0078086182151684`}, {-2.403850481131214, 
        0.9311116933250648}, {-2.4288871232843006`, 0.8883827740129644}}]}, 
      {Arrowheads[{{0.006750075349843567, 1.}}], 
       ArrowBox[{{-2.433942613237696, 
        0.8797547950299628}, {-2.452857482417045, 
        0.8474736323236576}, {-2.4990542374767566`, 0.7615138665784038}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.018848246097497655`, 1.}}], 
       ArrowBox[{{-2.184840558412888, 2.5}, {-2.2079206355386907`, 
        2.487476726964421}, {-2.2700298971192145`, 
        2.4520910329240366`}, {-2.331637754455099, 
        2.415243513692862}, {-2.3937611947702946`, 
        2.37240831450241}, {-2.4551997819590965`, 2.328024668122555}, {-2.5, 
        2.294117978872983}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9065805888456094, -1.83885784758262}, \
{-0.8515127115686021, -1.879730314313156}, {-0.7947286092296787, \
-1.9190169687017076`}, {-0.7362863173757067, -1.9566614121565407`}, \
{-0.6762438715535545, -1.9926072460859208`}, {-0.6146593073100892, \
-2.0267980718981153`}, {-0.5680122597608632, -2.0507466481170242`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.559116177870114, -2.055313893128307}, \
{-0.5515906601921776, -2.05917749100139}, {-0.4870959657466883, \
-2.0896891048040107`}, {-0.4212332595204879, -2.1182765147142435`}, \
{-0.3540415991998354, -2.1448593653313655`}, {-0.2855669435112114, \
-2.1693660128215595`}, {-0.21587767956181467`, -2.1917531259434493`}, \
{-0.18682881693956566`, -2.2000468700572435`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17721305903902465`, -2.202792266203191}, \
{-0.14504219445884503`, -2.2119773734556576`}, {-0.07312887530950225, \
-2.2299954241168094`}, {-0.00020610922098569882`, -2.245763946685529}, {
        0.07365771669950491, -2.259239609920438}, {
        0.14839421534477007`, -2.2703790825801624`}, {
        0.2151336799242295, -2.277830381669521}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.22507193071433396`, -2.278939963227131}, {
        0.23971162356846606`, -2.280574449369923}, {
        0.3322673265292539, -2.2871248118325065`}, {
        0.425860020895385, -2.2900008333654682`}, {
        0.5202884033351107, -2.2891731773663655`}, {
        0.6153511705166818, -2.284612507232754}, {
        0.6245574257801849, -2.283810128324897}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6345196600976171, -2.282941861427809}, {
        0.7108470191083489, -2.2762894863621903`}, {
        0.8065746457783636, -2.264174778152231}, {
        0.9023327471949769, -2.2482390460004313`}, {
        0.959925734759786, -2.236764867478752}, {
        1.0173982380363227`, -2.2238551908475586`}, {
        1.0292216669133885`, -2.2208978554953274`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.0389228064806024`, -2.2184713577934043`}, {
        1.0747502570245868`, -2.2095100161068517`}, {
        1.1319817917245785`, -2.19372934325663}, {
        1.189092842136298, -2.176513172296896}, {
        1.2460834082597452`, -2.157861503227647}, {
        1.3029534900949196`, -2.1377743360488846`}, {
        1.3597030876418215`, -2.116251670760608}, {
        1.4161914175951162`, -2.0932909074972654`}, {
        1.4181200378281535`, -2.0924518225660798`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4272897742788646`, -2.0884623447275024`}, {
        1.472277696649469, -2.068889446393304}, {
        1.5279619248048797`, -2.0430472874487235`}, {
        1.5832441020613488`, -2.0157644306635247`}, {
        1.6381242284188755`, -1.9870408760377065`}, {
        1.69260230387746, -1.9568766235712698`}, {
        1.7466783284371021`, -1.9252716732642137`}, {
        1.7816374765059757`, -1.903748249007807}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.7901529611148221`, -1.898505490013108}, {
        1.8003523020978027`, -1.8922260251165393`}, {
        1.853479508052472, -1.8577649236109885`}, {
        1.905915229494021, -1.8219136132303044`}, {
        1.9576594664224496`, -1.7846720939744871`}, {
        2.0087122188377573`, -1.746040365843536}, {
        2.0590734867399454`, -1.7060184288374516`}, {
        2.1087432701290125`, -1.664606282956234}, {
        2.1120613963145733`, -1.6617065576211334`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.119591249867652, -1.655126184875674}, {
        2.1577215690049596`, -1.6218039281998828`}, {
        2.206008383367786, -1.5776113645683982`}, {
        2.2485710627592055`, -1.5385886666284443`}, {
        2.290483185916556, -1.4985168276626997`}, {
        2.331769748521188, -1.4573877400130713`}, {
        2.3723557635290473`, -1.4152257266538382`}, {
        2.405544837232568, -1.3760095126631486`}}]}, 
      {Arrowheads[{{0.007128332313076867, 1.}}], 
       ArrowBox[{{2.41200495420781, -1.368376237568788}, {
        2.412063170893118, -1.3683074487255302`}, {
        2.4509109725822524`, -1.3203285983509758`}, {
        2.4888212168793267`, -1.2713390099061095`}, {
        2.5, -1.2562268858833323`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.012672718726592267`, 1.}}], 
       ArrowBox[{{-0.47265408473015547`, -2.387718125255608}, \
{-0.4150877735253208, -2.4115720757583334`}, {-0.3566336091371818, \
-2.434100695406883}, {-0.29573850518112094`, -2.454099124419209}, \
{-0.23405875921866198`, -2.472623454161556}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.365886243396122, 
        2.485220930569832}, {-1.4200207415608026`, 
        2.4687554270684062`}, {-1.4740334841311096`, 
        2.4511631548535435`}, {-1.5279468778843366`, 
        2.4324470633573956`}, {-1.581693702488602, 
        2.4125983042835086`}, {-1.6364993910533778`, 
        2.388543779068006}, {-1.691027777962068, 
        2.363281191153415}, {-1.7380196800064236`, 2.3403268820599896`}}]}, 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{-1.7469867958041467`, 
        2.335901470906833}, {-1.7990452581519063`, 
        2.309154254632514}, {-1.8569565419568397`, 
        2.279320187043721}, {-1.91435639915761, 
        2.2481122780247897`}, {-1.9712448297542182`, 
        2.2155305275757207`}, {-2.027621833746663, 
        2.181574935696513}, {-2.083487411134946, 
        2.1462455023871683`}, {-2.09475734452487, 2.138772829504528}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.1030916844248417`, 
        2.1332466392769174`}, {-2.1388415619190657`, 
        2.1095422276476845`}, {-2.193684286099023, 
        2.0714651114780636`}, {-2.2480155836748175`, 
        2.032014153878304}, {-2.3017073623912254`, 
        1.9912215158723925`}, {-2.354631529993023, 
        1.9491193584843147`}, {-2.4067880864802107`, 
        1.9057076817140703`}, {-2.4220854190191963`, 1.892395188061502}}]}, 
      {Arrowheads[{{0.0018922328009902348`, 1.}}], 
       ArrowBox[{{-2.4344763151378923`, 
        1.865204929493287}, {-2.453329635016154, 1.865204929493287}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.33230646789875, -1.3196195467023213`}, \
{-2.3114731438475813`, -1.3804919356588132`}, {-2.2891128344028346`, \
-1.4410308206600098`}, {-2.2652255395645082`, -1.5012362017059109`}, \
{-2.239811259332603, -1.5611080787965168`}, {-2.2128699937071183`, \
-1.6206464519318273`}, {-2.1844017426880553`, -1.6798513211118422`}, \
{-2.1797405652197592`, -1.6889997697967691`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-2.1752008071024718`, -1.6979099098762809`}, \
{-2.1544065062754134`, -1.7387226863365624`}, {-2.122884284469192, \
-1.7972605476059869`}, {-2.089852500379042, -1.8553138860311842`}, \
{-2.055328577114612, -1.9127316827232226`}, {-2.0193125146759026`, \
-1.9695139376821023`}, {-1.9818043130629135`, -2.025660650907822}, \
{-1.9707926853404785`, -2.041334061513298}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.965043971201045, -2.049516499153945}, \
{-1.9428039722756458`, -2.0811718224003837`}, {-1.9023114923140978`, \
-2.1360474521597856`}, {-1.8603268731782707`, -2.1902875401860293`}, \
{-1.8168501148681642`, -2.2438920864791134`}, {-1.7773192679259577`, \
-2.292575291703386}, {-1.7365849606255306`, -2.3406084533889575`}, \
{-1.7168303624090997`, -2.362937649657312}}]}, 
      {Arrowheads[{{0.009125637219821469, 1.}}], 
       ArrowBox[{{-1.7102042759193603`, -2.370427307715628}, \
{-1.694639759609222, -2.388020332676369}, {-1.6515059649500132`, \
-2.4347246461439966`}, {-1.6030086427241341`, -2.480797449529346}, \
{-1.581875152749646, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.5, -1.6768799768963647`}, {-2.499162763063407, \
-1.6790798052967792`}, {-2.475734356291559, -1.7370499542572142`}, \
{-2.4510289993875936`, -1.7948190488411075`}, {-2.425041528876308, \
-1.8523063337948753`}, {-2.3941014814309276`, -1.910741232045118}, \
{-2.361794946511577, -1.9687543550679611`}, {-2.3281392678296435`, \
-2.026252977052514}, {-2.322877450318791, -2.0348218861634613`}}]}, 
      {Arrowheads[{{0.016396876652131742`, 1.}}], 
       ArrowBox[{{-2.3176446707436877`, -2.0433435067791885`}, \
{-2.293128664147998, -2.0832680066024065`}, {-2.256489449864597, \
-2.142827673256714}, {-2.2184016648101, -2.201717177964402}, \
{-2.1788653089845083`, -2.259936520725471}, {-2.137880382387821, \
-2.317485701539921}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.010545859618369489`, 1.}}], 
       ArrowBox[{{-2.3564436459850793`, 
        1.566414280686268}, {-2.3991992849522426`, 
        1.5244356885371335`}, {-2.4412463110806577`, 
        1.4813956576899936`}, {-2.4824236906912693`, 
        1.4334967895747301`}, {-2.5, 1.4121348601908734`}}]}}}}, 
   {RGBColor[0, 0, 1], PointSize[Large], PointBox[{0, -1}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], PointBox[{0, 0}]}, 
   {RGBColor[0.5, 0, 0.5], Arrowheads[Medium], 
    ArrowBox[NCache[{{0, -1}, {
       Rational[5, 2] 26^Rational[-1, 2], -1 + 
        Rational[-1, 2] 26^Rational[-1, 2]}}, {{0, -1}, {
       0.4902903378454601, -1.098058067569092}}]]}},
  AspectRatio->1,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->NCache[{{
      Rational[-5, 2], 
      Rational[5, 2]}, {
      Rational[-5, 2], 
      Rational[5, 2]}}, {{-2.5, 2.5}, {-2.5, 2.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.904772243772991*^9, 3.9047722744347277`*^9, 3.90477288184103*^9, 
   3.9047732719563923`*^9, 3.904773983611763*^9, 3.904774160365164*^9, {
   3.9048781995265703`*^9, 3.90487822902496*^9}, 3.904878340638461*^9, {
   3.904878819001286*^9, 3.904878828621235*^9}, {3.9048793631199408`*^9, 
   3.904879380153707*^9}},
 CellLabel->
  "Out[144]=",ExpressionUUID->"6cd73125-a629-4c7a-9052-0aef73e1a496"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"z1", "=", 
   RowBox[{"init", "-", 
    RowBox[{"\[Gamma]", " ", "Fz0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fz1", "=", 
   RowBox[{"W", "@@", "z1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z2", "=", 
   RowBox[{"z1", "-", 
    RowBox[{"\[Gamma]", " ", "Fz1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fz2", "=", 
   RowBox[{"W", "@@", "z2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z3", "=", 
   RowBox[{"z2", "-", 
    RowBox[{"\[Gamma]", " ", "Fz2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fz3", "=", 
   RowBox[{"W", "@@", "z3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Rho]", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Fz1", ".", 
       RowBox[{"(", 
        RowBox[{"z1", "-", "init"}], ")"}]}], ")"}], "/", 
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"(", "Fz1", ")"}], "^", "2"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.90477176944668*^9, 3.90477177686075*^9}, {
  3.904772493017851*^9, 3.9047725656506157`*^9}, {3.904772608062976*^9, 
  3.904772635824658*^9}, {3.90477314374903*^9, 3.9047731439686623`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"16d211c8-3caa-42ba-9f41-f8321273273a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"iterates", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"init", ",", "z1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legends", "=", 
   RowBox[{"{", "\"\<MDEG\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iteratesReduces", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ArrayResample", "[", 
       RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", "iterates"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legend", "=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "legends", "]"}], "\[NotEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"ListLinePlot", "[", 
       RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
        RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"Placed", "[", 
          RowBox[{"legends", ",", "Below"}], "]"}]}]}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     StyleBox[
      RowBox[{"{", "}"}],
      FontWeight->"Plain"]}], 
    StyleBox["]",
     FontWeight->"Plain"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lines", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"iterates", ",", 
     RowBox[{"PlotLegends", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"markers", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9047738634252357`*^9, 3.9047738661739492`*^9}, {
  3.904879348857439*^9, 3.9048793495633707`*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"16906abe-5430-4850-a700-2b1d86676c5e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Fz1", ".", 
        RowBox[{"(", 
         RowBox[{"z1", "-", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], ")"}]}], ")"}], ">=", 
      RowBox[{"\[Rho]", " ", 
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{"(", "Fz1", ")"}], "^", "2"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"StreamPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"-", 
       RowBox[{"W", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
     ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"StreamColorFunction", "->", "None"}], ",", 
     RowBox[{"StreamStyle", "\[Rule]", "Gray"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Blue", ",", 
      RowBox[{"Point", "[", "init", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
      RowBox[{"Point", "[", "z1", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", "star", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p6", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Purple", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"z1", ",", 
         RowBox[{"z1", "-", 
          RowBox[{"\[Gamma]", " ", "Fz1"}]}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "Small", "]"}], ",", "Purple", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"init", ",", 
         RowBox[{"init", "-", 
          RowBox[{"\[Alpha]", " ", "Fz1"}]}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pic2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"{", 
    RowBox[{
    "p1", ",", "lines", ",", "markers", ",", "p2", ",", "p3", ",", "p5", ",", 
     "p6", ",", "p7"}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9047717892793503`*^9, 3.904771832929264*^9}, 
   3.904772046037261*^9, {3.904772251838159*^9, 3.904772253124487*^9}, 
   3.9047722915251713`*^9, {3.90477240691365*^9, 3.90477242292489*^9}, {
   3.9047724561657963`*^9, 3.904772466371705*^9}, {3.9047725712499037`*^9, 
   3.904772590044628*^9}, {3.904773872239781*^9, 3.9047738796160603`*^9}, {
   3.904773935418333*^9, 3.9047739473631067`*^9}, {3.9047740053453197`*^9, 
   3.904774049345291*^9}, {3.904774173911882*^9, 3.904774212618462*^9}, {
   3.9047745666139307`*^9, 3.904774587573102*^9}, {3.904878971436872*^9, 
   3.904878972218951*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"e4c51643-0abe-4b1b-9d4c-08b7f454e8d2"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJx1mHtUU0cex0NQikqqVatIXXUVFfFtTbHqdqIBpdZHpOVwqjY+0SqeunZ9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     "], {{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[0.3], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHfc39MVx++NmZAdZJCdeCSRiNiEEGLGTISEIBEjRhIVq0aCEEQi9gqx
KY0YpWarSlsVqqUtrdLWbrUoHbTlvF/n/Xv98sd5zvfc8fmce++595zf02fK
jP1PbFVKGRV/Vgn9bgh2m5C1/KZ9bfWqIe1CVgtZPeRnIa1DOoa0t22NkLaO
ZdwGIZ1DuoQMq4ndSXstsddRM29dNTwdxFszpKsctG0cOC0hL8T3hjXxesjT
8H19eWjrKR88m4a0hGwU8kFI95B+Ib3lXi+kl2Ox+9gG/4auB7wBcsLTX5we
jm2nry2OBW+482kb6hwwPpJ/SMgg/YBzY9v762sv+zYJGSjWMDGwDw3ZP+SA
kBHOAW/tmtibh2whD9hbqvFlKzV4W6vh2UaN79uq2b/t1PCsCBkZsmvIbn5v
H7LDSpyj1HDuqIbzxZDNnDNabjh3VsO5i3o7cTcTd6B7z3nsvhLnQSFjQ/YO
2VNuOPdS72T/TnLurYZzHzWcH7um/dzXxvraxX62Dfl5fO8hJxzjteE8UA3n
BPVYz2Y3/T1Ybjg7Bl6HkJfju31Nzkkh4xwL7iEr+TJZLPqXh9wWcnvIFPnY
g8P1CV9OCjkq5OiQI2ybYNsksX8RMjHkyJCpYuDjpjXHTHM+Y4m1QTXbZoYc
Ly7800MOk/9YfcU+zjbGHSMGfUMDZ3DIK/F9ghhTnTPONcySH38vDPl2yJkh
p4oL/2z54D9ZDuxTbDvOOTPF+yRkRsgZIaeJAf+3XCfzz3Is+3eBY+E+V1z4
58gH/znOx55rG+POFoO+z8SZF3KeGPATj9wJ7sB8fT3Lc7025LqQS8WF/xL5
4L8x5LKQxSELbJurPU/ffxlyfsiikIVinOe88x13uWPZ41859vqQa+QD+6qQ
i0IuDrlSX7Gvto1xV4gxfyW/F7qOBdoXuy+s4Qa5LhPrLPtukQ/sm8WF8yZ9
xV5qG+Ne1d87S96Ja+S8VQzsJe4L8+9yPPz3O45598kH9necA+c97jX2vbYx
7m4x6Fum32B9VwzsQyPGHwz5bXx/oY8PhjysH2B8Tw3PI2r4H1XD+X01Pj6m
hudxNfxPqFnTc85h7PNqxnaqyf90yA/05aGQH6rx60kxeGN+pH/49awav36s
hqNLYHYO+XV8PyMGc34iJ36RG8mR5Nb3StYc1BDUGuRt8nej5sCmjmirvZrz
sak12mtTI3TQJt+TE8gNP5XzSbG62N+oObqUZs2BTX3SUX/A6qqv1BrUGeT4
TmL30NfOtpEHeKd5r0eVfP/3ELt3yfwNVh/tD0vWH31L4pLn+4k7QBuegdqs
aUNtaooWbfI8eZh8TF4i35Mj/1KythgsLrl+iLhDtXs5v0Vccv0wcYdrt4g9
XL8HOaeLfmwgLvmdvNzI2TuXZm2xZWnWFluVZm2xdWnWFtuUZm2BzRrI6SPF
3UF7Hf3uWZp1zBbi8obuKO5o7UY9Mbo0axGwXipZu4yRg7y8qxy7azfqFebw
7pMvZpZmPcEZ81bxZs0vzXpibGnWE9h/K1lP7CsHOXw/OQ7QhnOcNnEzvjTz
3+El8yF5+whtOMjRE+Q4WJs6ghpiYmnWIuPlIOceIsdk7XFiTy7NeuVA/WPs
JNumyE1uJI+Rz6gNqBcmOo78PM15R2vDcYw2HMdqwzldm/UcV5p5mpx4iuuZ
Kjc1AjXHDDlmeRZH6css/TteDDhO1lc4ZmtPF3u2uCc4hzePN5m3uFEj7uWZ
c/ZnyHem9izP/kz5z9aG7xxt+OZowzdXG/5ztRHy4QLbFmrDRy6eJ9+F2vDN
12afznMefOTUi+S7RHuO2Nj/KFl/nO+aTxMDm9xLDianktNuko88uVi+K7Th
v1Ibvqu04btaG75rtOG/VvvTkrXX6a5tsdwI+fMG25ZoX64vS9yX68SCb6m+
wneLNny3ai8Sr1HD3GYf82/Xfq1k3XCHHOTZe5xHLiYeGvn1MX26xz44ltmP
H+TiRl1wr1hL7b9P7vud08jlj5Zm7idfEoPEIvn4nyVrhQf042H78Hu5WI36
oFEvPCIW702/mm9Oo1aA73clf3eNLM18T/4nb1MTPCUuOfMJ/aD/6dLM98/K
QU3QyPPPiNWoPx6X7znn/C/kDbn/GPJ6yd/vjCVPN2oE9PP28/+FjqVZuzwn
Br+9yA8bhb//EadRl+DTn1wn73vXGLNezTpjSOjib403S/7m4f2iNv5DyXvw
Z/sY807I2yXjY9WY91bJuvgt5yyynzZirFfNsZxhm/j+WqzW8f1/feJ/F6+7
LtZHPdjafXnDdf2mZA31lD7+vuQbu0KMkba9bDu/od50LT1qjiPPvORerHAN
b+vnWjFmtZr2V57HC/rBPlHXvOb6mdeq5r68stL6Wfv7JWs45v21ZM1BvbFO
zfqmm9+c0Qeu9X3Hd6vZ1s8zei+PpvSpWbdQU3SvOQ6bnNbP38a0w0XtRBux
TvsGNd8W3s71a+bdMcZLW+uidY0Bxn1e8k3k3HvWnP+ZY3inTrSPtnmOYfzp
rod1Ubv1rnlXeUMG1LyzD9reS/tfJcc8YKx9LvaX4nRzL//tPvT1/wyD7f/S
M2Ld/3Xt+LJKTX84/6+NF86V8+WsqutlLehq/KNb+f2JfTPk+Uou/F295rrY
O2pLajFioY0xR+ysaUzj+xo1/SfuiHviFSH+X3RdfaxT3zEW3/a8eniWrLud
a//Mc+VM+/t/Et60icYEdcdHxhOxxJ3oYP3DHersmzaw5tl0EqOjOPTR9rRj
GP+AZ9HVd+NTY4J9+tCYbpw/393cv3XdZzC6iMPb09U9eVe7lWvpZ632gf5z
pn8vGbf4xn6wL8TwCu0xxkB378XHtu/qPvU0Hj7RPl289d1beLrXZvz0NObZ
876eC7h93H/it7cx8IX2ncZGb2P7VdvvcF5f567tWXOX+Q3DbwB+E7Du/u7/
laGn1HzP+H08ueY78VDoI2velRHc3ZrvGzXnCL8H2z5IoX2a7UMdw/3kt1sP
z5kY4G7ym463uKPnNdDYGB6ySc055BfGdXftAzxTeDaVa5jjweFtJU+zP9tF
287u/9LQN9fMIbeE3Frzfh4YckPNXMJdGup97OD+tBd7uPht5Gut/8P1kzG0
8zt0kns0sTT7Oun7QP3nrrJ27vhw1wj+QaFvq3nnx4VcX/N9uSJkv5pvyxah
dzR+Ng89yvi/PfTBNe/cnqEvrPlOzSU2a+a6+aH3qvkeLw69T837elLoWTXv
1rLQW9XMXUeH3tvvrUPvZPyfW/P/KcTJGexxzTva4pmxLuJi8EpxMsS95c5u
5JkW23n3EGJopnNHGFNDxKGfsxrveS0PPbJmnjwm9AS/x4SeU/Mt3Db06Jpv
AntzlPtzVeira77XU2vGOnF+SujLat7X6aGPrfm+Tgp9R826YF7NfWfPial7
jSv29TD39oTQx9d8p2eHPrlmfj4t9Kk135ixNc+D8Ytq7i97u2/Ns+FcWNNy
17Ug9CU16zju6+U17+zhoS+qWbvQf7djbqy5NtY1LfSSmnUDZ3Wd53VtzT1i
f3arGSvECbFwgfFAfO3ueu8MfVfNfMO+7u/cc0KfXTPHbh96l5pv0aWhF9bM
PcTRMmNpYs145SyIwSNc7zddCuy1
           "]], PolygonBox[CompressedData["
1:eJwtk/trz2EUx8/52samvvWt/eJHfvU7EhMxtxRzSRKzhm34fuV+p80lcst9
Cw19MZfkzxChiY0WGdEiWjQyt9e78/zw6ryez+V5nvOc84ysK9TkM2ZWBSUw
383WwTs8Q9wFO+Eb4++wB98NA/gPGI9vg6/4XKjBz4NDnvFNYi28wv9AB34M
/uLlxONwBB5ZPJuJ74df+Ago4NXwE/8As/AmeIsPWvx71GNuzbEJ3wif8M8w
HW+GbvwBrMDvQQ6eMK5POSq317AcvwtZeMh4LHGzx1yjoYgvgRd4l8Vas+G3
xZpb8S3wxeJMDuFjYJTFN+s9clIuH2EVfh8q05y3iGfhH15BbIUL6Sz74TLe
DiXwjHGeeAeGw3uLvWvP2ms25aoaqTa5tNYkRYs113qsWZFqfo1YBUW8jNgI
12FYOnPVVj2SSTVugwmwnXdDiOfgNDy1yEG9s8DjnXpoIfGix1l3WvTSYo+1
1FPK5QqUppyueuSsXPXslHJJteuBw/icVCv12D58KQxNPaNc93r0qnK+ja+E
NxZnOA0a4LlFzlPw1fAYr4ZL+CKPveqfefgZj7WV40n8hMe3qvk4fA30Wswx
Gd8AfRY90ILP8OjFl3DD45lcZzwVdnjUWmequXRnytOcEz1qrlprz8s8ekq9
pB4/iB/wuDtaU3dJd0Z3RXfqP3iHicw=
           "]]}]}, {}, {}, {}, {}}, 
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJwt0ktXDAAYx+GR69KO7WxtnSSN5FJRMUykkDTjUjEGhck1ppLblEsxIsoU
IQ227oW+QV/HM+e0eN7z37+/YDQROb0oEAhMssrI7+XOIbqoIMEZDvOZRm5S
yQ22k+INE7TSRhXd7KCMQnro5Szn2Mw6blFNOx2cp4gpmqihj53c5ghvucs9
7pDmPpOcZD0f2cUJtlBMPwNc4CJJNjBNM2EesJuHRHnMHh4xxCDvOEWcWp4Q
YSslPCVDJ5fYRohn7OUyVzjKF2I8Zx/D1PGCY7znJa8YYYxRPpB/4EZy7KeF
ckp5TT1XucZ1NvGJ4zSQ5QDjHGReA9/4zg9+8ovfzDDLH/7yjzm+kiNLhjQp
ksSJ0UCYckKsZQ1BVrOSFfn+WMZSlrCYgoU+/wP69k2K
        
        "]]}}], {}}, {{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
      LineBox[{{0., -1.}, {0.49029033784546006`, -1.098058067569092}, {
       0.49029033784546006`, -1.098058067569092}}]}}, {{}, {}}}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[
          {EdgeForm[None], DiskBox[{0, 0}]}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[
            Rational[7, 360]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}],
        TraditionalForm], {0., 0.}, Automatic, Offset[6.272]], {{{
      0., -1.}}, {{0.49029033784546006`, -1.098058067569092}}, {{
      0.49029033784546006`, -1.098058067569092}}}]}, {{}, {}}}, {{}, {
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.08053395042374835, 
        0.05877555787340594}, {-0.10825854645466215`, 
        0.015374076842259958`}, {-0.11272381043934837`, \
-0.04093496887871566}, {-0.08803193398516472, -0.0977723952998116}, \
{-0.03684999380370615, -0.13917432851429626`}, {
        0.033666388023755725`, -0.15390764668802362`}, {
        0.10968336185455071`, -0.1330187299607751}, {
        0.11951506211752265`, -0.12400353934873642`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.12688555834261508`, -0.11724515304756228`}, {
        0.17327830342518144`, -0.07470526383732816}, {0.20584902741009745`, 
        0.01183901334730142}, {0.1953066889744705, 0.11233036907181589`}, {
        0.17162433258799892`, 0.16123599539912886`}, {0.13582443016953089`, 
        0.20536816957834508`}, {0.11016753920608098`, 
        0.22511846934664195`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.10224342370798617`, 0.2312183376708645}, {
        0.0887539660788878, 0.24160232504743195`}, {0.03217730132733977, 
        0.26727400321326444`}, {-0.02525173462340204, 
        0.2792224682947744}, {-0.0863578723919625, 
        0.2789921719228537}, {-0.1485294100982113, 
        0.26542417832325443`}, {-0.20895471837347804`, 
        0.23816524186668767`}, {-0.2645467322253788, 
        0.19722704802085309`}, {-0.26595595996055704`, 0.1956439139392192}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.27260486123007255`, 
        0.18817450218806805`}, {-0.3123694029318763, 
        0.1435028003493917}, {-0.3493643957780324, 
        0.07836347702044173}, {-0.3730199805754065, 
        0.003987543185027896}, {-0.38096249355339884`, -0.0684106646219723}, \
{-0.3750591874663361, -0.14375075441048665`}, {-0.36478325588723465`, \
-0.1811977528418923}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3621369569700817, -0.19084125334954383`}, \
{-0.35430220923931455`, -0.21939222060015984`}, {-0.31846531903111513`, \
-0.2925167580103652}, {-0.2677536118729831, -0.3600514254276449}, \
{-0.2030727395186048, -0.4190769545036568}, {-0.12545024644439423`, \
-0.46673279363437614`}, {-0.10128361478339044`, -0.4759246992433453}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09193688203034728, -0.4794797782640128}, \
{-0.03707100512619312, -0.5003483034573726}, {
        0.035100132075154424`, -0.5149236410295126}, {
        0.11071805641780638`, -0.5192584422513159}, {
        0.1883578516989877, -0.5126663527193198}, {
        0.2274929332529781, -0.5047547827509514}, {
        0.26649158034571624`, -0.4939262862495361}, {
        0.29780993055389715`, -0.48173062121848603`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.30712833735638195`, -0.4781019445088017}, {
        0.34635611752289336`, -0.4628262718235441}, {
        0.42300475847247376`, -0.41903875022635867`}, {
        0.49447244353982106`, -0.3627940092963286}, {
        0.558770543170338, -0.2946422852585897}, {
        0.5970696564849124, -0.24245971987750178`}, {
        0.6073800607953709, -0.2250215663479385}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.61246956394468, -0.2164136073742228}, {
        0.6306882195940825, -0.18560010047864334`}, {
        0.6590400615896861, -0.12449296616677075`}, {
        0.6815969550675887, -0.0596152064776323}, {0.6979272204503256, 
        0.00856466657455189}, {0.70761615381186, 0.07947165067658801}, {
        0.7102620876609865, 0.15241856669054218`}, {0.7094067030190767, 
        0.16587456764052697`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7087722934698549, 0.17585442357755612`}, {
        0.7055402062501889, 0.22669818037117162`}, {0.6932230878905588, 
        0.30163431321651557`}, {0.6731383626292087, 0.37647649153096374`}, {
        0.6451666160946882, 0.4503947310323393}, {0.609275347201237, 
        0.5225640262171608}, {0.5901394382767056, 0.5530410204425188}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5848219180649035, 0.5615100214932376}, {
        0.5655104377021095, 0.5922666413026828}, {0.5140137353551719, 
        0.6586812656320755}, {0.4550239243766438, 0.7208725758231971}, {
        0.3888624240904714, 0.7779603289584983}, {0.3158906098195595, 
        0.8292165743350434}, {0.300760254490825, 0.8377362922903202}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2920466884132313, 0.8426427947321221}, {
        0.23659799023241596`, 0.8738652782246717}, {0.15160657255833163`, 
        0.9110724043076697}, {0.06160014610145757, 
        0.9401066106472941}, {-0.03275818276768201, 
        0.9605179616944891}, {-0.08488704914793258, 0.9665092406951489}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09482164944252498, 
        0.9676510449632634}, {-0.13065601171714353`, 
        0.9717695627271428}, {-0.23112322765677928`, 
        0.973219323931238}, {-0.3331683264461468, 
        0.9644153822862018}, {-0.4181235708458057, 
        0.9490940572870644}, {-0.49028973696980177`, 0.9297950213476631}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4999502601050498, 
        0.9272115560869448}, {-0.5029210006996729, 
        0.9264171058260877}, {-0.5869277491644136, 
        0.8965191946769938}, {-0.6694986107525744, 
        0.8589486437625197}, {-0.7500066220238256, 
        0.8141206564962981}, {-0.8278118426879888, 
        0.7618337611555807}, {-0.8521553487469629, 0.7423977594024173}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8599701095291714, 
        0.7361584073593879}, {-0.9022845969303801, 
        0.7023742659410683}, {-0.9727952089363158, 
        0.6360284790534616}, {-1.0386365037876655`, 
        0.5629244760266161}, {-1.099163305849056, 
        0.48331691852786385`}, {-1.1264194104784524`, 
        0.44062743580284097`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1318008169014786`, 
        0.43219888522102606`}, {-1.1538389382299397`, 
        0.3976819939581188}, {-1.2021267240397686`, 
        0.3064958897182956}, {-1.243403048264287, 
        0.20987125628737627`}, {-1.277113846388205, 
        0.10821157368188868`}, {-1.288296826623905, 0.06597672842843649}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2908564298991376`, 
        0.05630985555902219}, {-1.2909970634305334`, 
        0.055778723847192124`}, {-1.3028267672694251`, 
        0.002429273609066054}, {-1.3125489140121178`, \
-0.051722723069085375`}, {-1.3201094597658491`, -0.10656321222385778`}, \
{-1.3262317503474492`, -0.17356886349563033`}, {-1.3289814401120654`, \
-0.24130320761004753`}, {-1.3283585290596975`, -0.30976624456710944`}, \
{-1.3265778799028938`, -0.3406023925637448}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.3260013851557029`, -0.35058576142432796`}, \
{-1.3243630171903458`, -0.378957974366816}, {-1.3168869717276026`, \
-0.44854242140950984`}, {-1.3058224598950607`, -0.5181836100955336}, \
{-1.29116948169272, -0.5878815404248872}, {-1.2729280371205804`, \
-0.6576362123975708}, {-1.251058310048759, -0.7270809597021168}, \
{-1.2458530488095827`, -0.7410976666368959}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2423717384450998`, -0.7504721254557368}, \
{-1.225520484347371, -0.7958491160270577}, {-1.196314560016418, \
-0.8639406813723939}, {-1.163440537055899, -0.9313556557381248}, \
{-1.124435002853534, -1.0067375920013464`}, {-1.080783885079794, \
-1.0807839165656377`}, {-1.0616542955017225`, -1.1060241967707638`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0556140806901662`, -1.1139938771301168`}, \
{-1.0239935512513096`, -1.1557151602770417`}, {-0.9621605187836746, \
-1.227814544345588}, {-0.9091480881478889, -1.2865340247072512`}, \
{-0.8528265184908987, -1.3429224979795882`}, {-0.7931958098127043, \
-1.3969799641626002`}, {-0.7828634543443891, -1.405471503020873}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7751377495334164, -1.4118207931523534`}, \
{-0.7302559621133053, -1.448706423256286}, {-0.6642105840904254, \
-1.4977403420926636`}, {-0.5952632844417882, -1.5437201875037498`}, \
{-0.5234140631673937, -1.5866459594895443`}, {-0.44866292026724175`, \
-1.6265176580500478`}, {-0.44110170530631965`, -1.6300840787152189`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43205730161524786`, -1.63435007940356}, \
{-0.37129364800443543`, -1.6630106519502865`}, {-0.29159003864207755`, \
-1.6958003099552874`}, {-0.20955209218016813`, -1.7248866320650504`}, \
{-0.12517980861870728`, -1.7502696182795758`}, {-0.06119665240090115, \
-1.7666588565504842`}, {-0.05588878895582322, -1.7678193274569916`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.04611954899960154, -1.7699551998028404`}, {
        0.003851029826180065, -1.7808803872174532`}, {
        0.06987323707445227, -1.792854895742205}, {
        0.13677996835583134`, -1.8025030675864617`}, {
        0.2044812226822327, -1.809745588211945}, {
        0.2728869990655717, -1.8145031430803766`}, {
        0.34190729651776414`, -1.816696417653479}, {
        0.35034434446056445`, -1.816641785636856}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3603441348226757, -1.8165770344683203`}, {
        0.411452114050726, -1.8162460973929735`}, {
        0.4814289804349386, -1.8131716805894285`}, {
        0.5517446643665959, -1.8075230694807491`}, {
        0.6223080247461822, -1.7992665554496625`}, {
        0.6930279204741826, -1.7883684298788978`}, {
        0.7575571915660763, -1.7759946081526499`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7673507630913646, -1.7739809581114447`}, {
        0.8345727535773633, -1.7585125096492427`}, {
        0.9052154087535126, -1.7394872977558076`}, {
        0.9756500348800132, -1.7176856398536051`}, {
        1.0457603988003121`, -1.6931273678127137`}, {
        1.1154225467249201`, -1.6658487874993195`}, {
        1.1475545415609405`, -1.6518971688490038`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.156727204884504, -1.6479144251273274`}, {
        1.1845337566049197`, -1.6358409012903128`}, {
        1.2529913063913936`, -1.6030947115625829`}, {
        1.3206924740354231`, -1.5676012206930192`}, {
        1.3875345374880903`, -1.5293514310585123`}, {
        1.4534147747004778`, -1.4883363450359517`}, {
        1.505403252257749, -1.4532130093289444`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5136894387172943`, -1.4476148744647555`}, {
        1.5182304636236674`, -1.4445469650022265`}, {
        1.5818697986437271`, -1.3980464376132837`}, {
        1.6442181792036419`, -1.3489201077647792`}, {
        1.7051686908398727`, -1.2971922751931677`}, {
        1.7646144190888797`, -1.242887239634903}, {
        1.8187148716092199`, -1.1896998653894943`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8257205906642757`, -1.1825664174133537`}, {
        1.8785638675710594`, -1.1266427585042336`}, {
        1.9328537588771526`, -1.0647519124047375`}, {
        1.9852112089418608`, -1.000381062264406}, {
        2.0350129280543623`, -0.9343528917100311}, {
        2.078025828206587, -0.8728489406007649}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.0837040778547715`, -0.8646185932841548}, {
        2.128305552016987, -0.7956863310917494}, {
        2.171600776410988, -0.723158187371794}, {
        2.2125314887760323`, -0.6485736322739303}, {
        2.2509998488840584`, -0.5719877889701344}, {
        2.277050752689313, -0.5150138487701635}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.281209099426934, -0.505919446513296}, {
        2.2869080165070046`, -0.4934557806323819}, {
        2.320158151416809, -0.4130327304326482}, {
        2.3506851139985763`, -0.3308402292310362}, {
        2.378433826364538, -0.24702031948399486`}, {
        2.4033215408773243`, -0.16165880175802025`}, {
        2.4117469839336128`, -0.1283250676230679}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.414197518750787, -0.11862997200157879`}, {
        2.4252655098995644`, -0.07484147661960802}, {2.4441829857938906`, 
        0.013345855364745888`}, {2.459991220922931, 0.10281739362854576`}, {
        2.472607467649317, 0.19348733760529555`}, {2.4809347319270953`, 
        0.2753046761812702}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.481947288184834, 0.2852532805972129}, {
        2.4819489783356783`, 0.28526988672850034`}, {2.4879867717071797`, 
        0.37802196948648364`}, {2.49070840998515, 0.47158289253828295`}, {
        2.490055960776466, 0.5658404225734739}, {2.4859714916880042`, 
        0.6606823262816315}, {2.4840508586973495`, 0.684850944421721}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.4832586756316037`, 0.6948195173381593}, {
        2.4783970703266425`, 0.7559963703523308}, {2.4672747642992565`, 
        0.8516703214751467}, {2.452546641212724, 0.9475919463396543}, {
        2.434154768673921, 1.0436490116354284`}, {2.4237023270207225`, 
        1.0899481225928842`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.4215001585870737`, 1.0997026320213403`}, {
        2.412527892564225, 1.139445302099252}, {2.386681543186237, 
        1.2354092287986997`}, {2.357271652055331, 1.3310120112352253`}, {
        2.324250652662824, 1.4261353674945108`}, {2.3028515608648084`, 
        1.4812868913959343`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.2992342535154764`, 1.4906097175522277`}, {
        2.2875751248538103`, 1.5206585962206804`}, {2.24720579482716, 
        1.6144585766163009`}, {2.203107535135521, 1.7074097684423823`}, {
        2.155249364685315, 1.7993842120183783`}, {2.126376843167879, 
        1.8509379535629213`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{2.121490496893639, 1.8596628386675071`}, {2.12065533854911, 
        1.8611540675307932`}, {2.0843733714590322`, 1.9223640831778877`}, {
        2.0464077358242774`, 1.982970857842905}, {2.006764192966777, 
        2.042930389544664}, {1.9654499931212028`, 2.1021980754375535`}, {
        1.922473875434965, 2.1607287118115317`}, {1.8986997886637487`, 
        2.191492060152295}}]}, 
      {Arrowheads[{{0.00487273592909976, 1.}}], 
       ArrowBox[{{1.8925849257808414`, 2.199404610431645}, {
        1.8778460679682123`, 2.2184764940921284`}, {1.8315782876938322`, 
        2.2753950168404447`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.14547891007220048`, 
        0.11916598653100989`}, {-0.20018808890752074`, 
        0.04587817735195573}, {-0.21809499430669954`, \
-0.052384544834700904`}, {-0.2093502195933019, -0.10535270435621343`}, \
{-0.18788041833393657`, -0.15720883573738362`}, {-0.15360600838843486`, \
-0.20480024767999808`}, {-0.12332991323839783`, -0.2312526134122412}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.11579931417703056`, -0.2378321329826152}, \
{-0.10742852137849343`, -0.24514573374514484`}, {-0.054780795232938675`, \
-0.2735614427777287}, {0.005157862004517218, -0.29084447824351456`}, {
        0.07004484914972275, -0.29501462846205223`}, {
        0.13708011979011378`, -0.284882615864117}, {
        0.2030522933466684, -0.25955535337563435`}, {
        0.2558853264903374, -0.22488580217924484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2642459599760206, -0.21939947301321103`}, {
        0.26465776711645184`, -0.21912924115468047`}, {
        0.31832259232672183`, -0.16418240008929064`}, {
        0.36082906809652665`, -0.096308484071882}, {
        0.3885847380749037, -0.01908584924205449}, {0.4000456856539895, 
        0.06565244887021149}, {0.394164714977549, 0.14046929216935236`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.39338108314904147`, 0.1504385409453309}, {
        0.39306575857587844`, 0.15445005375106807`}, {0.3666069983991692, 
        0.24341472569769934`}, {0.32010062255986266`, 0.3281935146590073}, {
        0.25425588437216456`, 0.4044831249025242}, {0.21450821167510306`, 
        0.4380175709659093}, {0.17043784712386428`, 0.4677174219028052}, {
        0.16996086668192925`, 0.46797079637645456`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.16112954543700334`, 0.47266203982237803`}, {
        0.12252653658173288`, 0.49316815745333437`}, {0.07125602591199372, 
        0.5139552573576198}, {-0.01996522215690985, 
        0.5366825108632076}, {-0.11702795438727706`, 
        0.5434818841616339}, {-0.21721722303568305`, 
        0.5328056759298602}, {-0.22576610481923012`, 0.5303397931214757}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.23537438286674986`, 
        0.5275683326830877}, {-0.3174788920905576, 
        0.5038856917351823}, {-0.3665717420108557, 
        0.482474711568773}, {-0.41440453032129443`, 
        0.4563713009120596}, {-0.4605587565934912, 
        0.4257126024934353}, {-0.5046159203990634, 
        0.3906357590412935}, {-0.5461911457042167, 
        0.35103857787511794`}, {-0.570848451717243, 
        0.32297302843309883`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5774486373544233, 
        0.315460535534283}, {-0.5848726569594866, 
        0.30701033464151917`}, {-0.6202016044629868, 
        0.25897537455958114`}, {-0.6517191385128303, 
        0.20735804284838796`}, {-0.6843489226250916, 
        0.1398791931643146}, {-0.7101497284399011, 
        0.06779199637184315}, {-0.7285478783612251, -0.008199320690083278}, \
{-0.7336285472449531, -0.04680528939490585}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.7349333286966131, -0.05671980125194672}, \
{-0.7389696947930304, -0.08739053118252152}, {-0.7409871442374973, \
-0.1689395100171172}, {-0.734172193196806, -0.252004132105516}, \
{-0.7231780968853831, -0.3119641559013571}, {-0.7073964490523483, \
-0.37177130546142895`}, {-0.6815879730457203, -0.4461190915784071}, \
{-0.6804913318367958, -0.44851324745633364`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6763269195519824, -0.4576048738412054}, \
{-0.6481674334486417, -0.5190818625090168}, {-0.607157790347405, \
-0.5898437910725429}, {-0.5586594598082746, -0.6576107487209791}, \
{-0.5028292409574694, -0.7216731350728813}, {-0.443098831101584, \
-0.7782679702411217}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4354886283053369, -0.784737859807511}, \
{-0.37030158051751605`, -0.8356144931478727}, {-0.29438844864156155`, \
-0.8839340036069614}, {-0.2121012932887889, -0.9258331533266222}, \
{-0.12447660508806352`, -0.9603200400389009}, {-0.08523535767771111, \
-0.9715456489487521}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07562101337676386, -0.9742959914115815}, \
{-0.03220240048087697, -0.9867166049226817}, {
        0.06398392504300879, -1.0044273195395952`}, {
        0.1633700438727946, -1.0129780167687295`}, {
        0.2651152444470397, -1.0119358515330443`}, {
        0.3203329689302647, -1.0060297712032846`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3302762530457047, -1.0049662388814258`}, {
        0.3682428346284351, -1.0009053384590967`}, {
        0.4717632070324956, -0.9795925417895168}, {
        0.5233772528930066, -0.9650207495101828}, {
        0.5747412635346618, -0.9478209290994664}, {
        0.6257144895202278, -0.9279817448511882}, {
        0.6761574382250481, -0.9054986932280239}, {
        0.7104394978198866, -0.8881941734750485}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.719366675523292, -0.8836880112218868}, {
        0.7259318738370407, -0.8803741028615043}, {
        0.7749008173566987, -0.8526171345520158}, {
        0.8229285465970906, -0.8222437812687997}, {
        0.8698805961838584, -0.7892768681499539}, {
        0.9156590318247232, -0.7537395461981284}, {
        0.9601489901943709, -0.7156651529461578}, {
        1.003195319529314, -0.6751015210763552}, {
        1.0354704200881217`, -0.6416224417598404}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0424108511757042`, -0.6344231073240388}, {
        1.0446478874673881`, -0.6321026214340959}, {
        1.0843615810477507`, -0.5867285630278185}, {
        1.1221963067108809`, -0.5390455930290248}, {
        1.1580169902985804`, -0.4891260967722792}, {
        1.1916935770539712`, -0.43704859775521115`}, {
        1.2231345169907226`, -0.38287963392994007`}, {
        1.2522360159556924`, -0.32670122519028977`}, {
        1.2631738386890639`, -0.3028410089903315}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2673409809396914`, -0.29375063356007375`}, {
        1.2788598608733075`, -0.2686228752943552}, {
        1.3028764298420346`, -0.20875829296771162`}, {
        1.3241646921343795`, -0.1472253919034172}, {
        1.3426122081968872`, -0.08414629076201202}, {
        1.3581151296501417`, -0.01964731317151891}, {1.3705781992887656`, 
        0.04614101227255685}, {1.3766544291652045`, 0.08944521086776755}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3780439673005531`, 0.0993481994959753}, {
        1.3799759929023492`, 0.11311739882722877`}, {1.3862601038935094`, 
        0.18115911108816132`}, {1.389318587583144, 0.2500998157622025}, {
        1.3890546229270881`, 0.3197725422495182}, {1.3853865125161153`, 
        0.3900096826435927}, {1.3782476825759373`, 0.46064299173122786`}, {
        1.3726303666649142`, 0.49797967345288113`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.3711426071341462`, 0.507868382750793}, {
        1.3675866829672036`, 0.5315035869925432}, {1.353367187185502, 
        0.6024219486009768}, {1.3389637642846015`, 0.6606594882483303}, {
        1.322085454136531, 0.7187414688485818}, {1.3027537473980226`, 
        0.7765671150057446}, {1.2809947711310472`, 0.8340360414747908}, {
        1.257248129658711, 0.8900832994875366}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.253033530906833, 0.899151009535055}, {1.2303227002857684`,
         0.9475041451232241}, {1.2014850418575984`, 1.0033045025673564`}, {
        1.1695797063738769`, 1.0582839150890209`}, {1.1356943645126123`, 
        1.1124313257567426`}, {1.0993364454997308`, 1.165602701186843}, {
        1.060557576626015, 1.2176998019645742`}, {1.0436096412841431`, 
        1.2386743958069906`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0373247179175737`, 1.2464525535757909`}, {
        1.0194093851822454`, 1.2686243886751898`}, {0.9759434984592045, 
        1.318278221903942}, {0.930211543747674, 1.366563062236083}, {
        0.882265148338435, 1.4133806702568663`}, {0.8321559395222693, 
        1.4586328065515441`}, {0.7798828050388837, 1.5021920316786117`}, {
        0.7509828081255685, 1.524363705813906}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7430487346535213, 1.5304506162075422`}, {
        0.725463810646558, 1.5439415243881127`}, {0.6689793506639327, 
        1.5837989725526218`}, {0.6105098194096483, 1.6216820640447138`}, {
        0.5501356112023459, 1.6575084867369636`}, {0.48793712036066567`, 
        1.691195928501946}, {0.42399474120324854`, 1.7226620772122359`}, {
        0.3994766731630144, 1.7335606323578407`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3903387839876425, 1.737622526179523}, {
        0.35838886804873527`, 1.7518246207404082`}, {0.2910770022688201, 
        1.7785684808804598`}, {0.2220613335795418, 1.8027904943640523`}, {
        0.151489288816057, 1.8244262214702573`}, {0.07950829481352238, 
        1.8434112224781471`}, {0.00999642241294614, 1.8588523455184298`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.00018659713990841313`, 
        1.8607839797767523`}, {-0.06809083356806767, 
        1.8731712873152677`}, {-0.14341411427680922`, 
        1.8838174717026424`}, {-0.21955663688397295`, 
        1.8915551711079885`}, {-0.3109977393126927, 
        1.8968215374577784`}, {-0.39740241473695476`, 1.8976607646625359`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.4073992476663572, 
        1.897562608385838}, {-0.4963105316193033, 
        1.8942432131189566`}, {-0.5901822214971941, 
        1.886398522430345}, {-0.6844512307053616, 
        1.874061888216544}, {-0.7787046827576921, 
        1.8571117192984978`}, {-0.8040394998892202, 1.8513145557630724`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8137875540932025, 
        1.8490839865002553`}, {-0.8729425776541857, 
        1.8355480156762067`}, {-0.9671649153948421, 
        1.8093707773496703`}, {-1.0609249780295422`, 
        1.7785371580501284`}, {-1.1537760476081667`, 
        1.7430043115088196`}, {-1.193542786971388, 1.7256031557737626`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2027040889742628`, 
        1.7215943472709625`}, {-1.245718124130716, 
        1.7027722377257453`}, {-1.3367512075971895`, 
        1.6578409367009042`}, {-1.4302286263662656`, 
        1.6090468672910196`}, {-1.5222452072387163`, 
        1.555240327724995}, {-1.554475424122574, 1.532420890667627}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5626368989681576`, 
        1.526642454171056}, {-1.5687541366156896`, 
        1.5223113657404121`}, {-1.6146415334374957`, 
        1.4880284283385103`}, {-1.6597946936157246`, 
        1.4524304499251783`}, {-1.704251185179846, 
        1.41550445236512}, {-1.7856720026269841`, 
        1.3462796227348228`}, {-1.8642431065735035`, 
        1.2727044762288422`}, {-1.8680218462679385`, 
        1.2688157462417993`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-1.874990762209026, 
        1.2616439814237048`}, {-1.939964497019404, 
        1.1947790128471776`}, {-1.9767565496796224`, 
        1.1541849123279637`}, {-2.0128361739646863`, 
        1.112503232589829}, {-2.048090648997865, 
        1.0697920311445586`}, {-2.0824072539024274`, 
        1.0261093655039377`}, {-2.115785988678374, 
        0.9814552356679662}, {-2.133268660243372, 0.9568671957350299}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.139063423295993, 
        0.9487173048668048}, {-2.148226853325704, 
        0.9358296416366441}, {-2.179729847844419, 
        0.8892325834099719}, {-2.2102949722345175`, 
        0.8416640609879489}, {-2.239922226496, 
        0.7931240743705754}, {-2.268611610628867, 
        0.7436126235578515}, {-2.2962600922152574`, 
        0.6932113008490698}, {-2.3227646388373104`, 
        0.6420016985435231}, {-2.341239717978965, 0.6041069309449646}}]}, 
      {Arrowheads[{{0.014966800843425932`, 1.}}], 
       ArrowBox[{{-2.3456220049174075`, 
        0.5951182958322705}, {-2.3481252504950265`, 
        0.5899838166412114}, {-2.3723419271884056`, 
        0.5371576551421345}, {-2.3954146689174483`, 
        0.48352321404629267`}, {-2.4173434756821535`, 
        0.42908049335368587`}, {-2.4381283474825217`, 
        0.3738294930643138}, {-2.457769284318553, 0.317770213178177}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.005412115972872655, 
        0.434639744761163}, {-0.0992735320248458, 
        0.44167364455746383`}, {-0.19637867343681703`, 
        0.4284910286897749}, {-0.292510312353987, 
        0.3942131295900522}, {-0.3387511527179627, 
        0.36905131777866124`}, {-0.3825003968831305, 0.33882404703443814`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.39013555583711673`, 
        0.33237083906670234`}, {-0.424692290548228, 
        0.30279296452015914`}, {-0.4632831487065725, 
        0.2622772322061808}, {-0.4981035208248903, 
        0.21702445462295633`}, {-0.5285764767165013, 
        0.16728506015674866`}, {-0.5542805599236785, 
        0.11358931045594399`}, {-0.5747943139886946, 
        0.05646746716892838}, {-0.5876911686376989, -0.005101175214466895}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.589741383234593, -0.014888749996131769`}, \
{-0.5957798350245687, -0.04371587792186095}, {-0.5995868863631374, \
-0.14951363987404345`}, {-0.5945774115543174, -0.20361798760553948`}, \
{-0.5847080301112333, -0.2580460120712426}, {-0.5699900724924049, \
-0.3123567402094278}, {-0.5504348691563521, -0.3661091989583698}, \
{-0.5329287641387913, -0.4038033112115108}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5287166085045741, -0.412872916765951}, \
{-0.5259381861137769, -0.4188554106091157}, {-0.4964882409336352, \
-0.47015300117049474`}, {-0.4622350414118289, -0.5195694031574555}, \
{-0.42332859534425943`, -0.5666720490849461}, {-0.3796744905013567, \
-0.6110616423021615}, {-0.3313738506739279, -0.6523122694908995}, \
{-0.2788699876884405, -0.6899514381650126}, {-0.2594124219845771, \
-0.7015557583605792}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.25082384884571934`, -0.7066779074640797}, \
{-0.22260621337136208`, -0.7235066558383536}, {-0.14957979061056267`, \
-0.7580931697685621}, {-0.0717632496062046, -0.7854784596838134}, {
        0.010121227841374272`, -0.8050788661779351}, {
        0.09535145993183615, -0.816310729844755}, {
        0.12902155699853582`, -0.817241354437818}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13901773947631912`, -0.8175176439071398}, {
        0.1830676674992265, -0.8187351618210195}, {
        0.2724100713775927, -0.8119132732434754}, {
        0.33354929891127233`, -0.8013751901653294}, {
        0.3946096132208077, -0.7863412526061471}, {
        0.48808157792872836`, -0.7551354471564}, {
        0.5270258553613951, -0.7372314255716031}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5361116760864388, -0.7330543617999609}, {
        0.579585278471498, -0.7130680540088684}, {
        0.6678929059288734, -0.6601914634783541}, {
        0.7517697584162523, -0.5966679538893054}, {
        0.8207193516425308, -0.5324289568589449}, {
        0.853743511640356, -0.4951936741933058}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8603788548615364, -0.4877122157568019}, {
        0.8844823823085548, -0.46053509277205906`}, {
        0.942183961300501, -0.38141038182623943`}, {
        0.9930092621393032, -0.29555076228404914`}, {
        1.0362640212491345`, -0.2034801397799959}, {
        1.057934719818556, -0.14300108600946154`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0613078883861595`, -0.13358717429251138`}, {
        1.071249833322373, -0.10584097956534255`}, {
        1.0972579778228175`, -0.003398791272700319}, {1.1136694296335872`, 
        0.10303052427040114`}, {1.1181187805031256`, 0.15749446548671547`}, {
        1.1199942471494762`, 0.21266032448246852`}, {1.119350633692318, 
        0.25995989208118697`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.119140150483491, 0.2699561792101718}, {
        1.1157903845763841`, 0.3245690496497532}, {1.1096115130629183`, 
        0.38104576473628887`}, {1.1006596727382183`, 0.43769209543227355`}, {
        1.0889021217593646`, 0.49437318819148485`}, {1.0743129300050742`, 
        0.5509534782662108}, {1.0568772263022872`, 0.6073174148983237}, {
        1.037871787110824, 0.6597850085055192}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.034190103872587, 0.6690797355630174}, {
        1.0134270959530278`, 0.7188633191756706}, {0.9874030546654159, 
        0.7737426506704743}, {0.9585187274736218, 0.8278269767783417}, {
        0.926787468954924, 0.8809687281379531}, {0.8922298984457404, 
        0.9330218348735466}, {0.8548739000416281, 0.9838417265949186}, {
        0.831844502363403, 1.0122395336379555`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8255457981795712, 1.020006535994372}, {0.8147472350639777,
         1.0333223645706715`}, {0.7718887382771573, 1.0813401174123132`}, {
        0.7263532100772334, 1.127729237546196}, {0.6782019276158595, 
        1.1723294269827107`}, {0.6275026448002757, 1.2149858373162854`}, {
        0.5743295922933089, 1.2555490697253862`}, {0.5292843005309958, 
        1.2866185551448255`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5210524944163194, 1.2922963512040704`}, {
        0.5187634775133729, 1.2938751749725168`}, {0.46089148463446683`, 
        1.3298256534042197`}, {0.40078771683718284`, 1.3633027983768036`}, {
        0.3385428371638475, 1.3941961313311284`}, {0.2742770200945249, 
        1.422358996590677}, {0.2081148307049731, 1.447653958028381}, {
        0.16079550870485054`, 1.4631871857453596`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.1512943252298204, 1.466306081795858}, {0.1401852246666439,
         1.4699527990666208`}, {0.0706215482466831, 
        1.4891365226772266`}, {-0.0004384616920700135, 
        1.5050953513814767`}, {-0.07285267769108147, 
        1.5177287272500986`}, {-0.14651021008115578`, 
        1.527009721361598}, {-0.22127741018556513`, 
        1.5328874176898575`}, {-0.24183894839374673`, 1.5335276066443668`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2518341048911094, 
        1.533838808497235}, {-0.29697427641173946`, 
        1.5352442597295104`}, {-0.3734202169324854, 
        1.5339787808668612`}, {-0.45043404968598566`, 
        1.5290056043798852`}, {-0.5278340023757991, 
        1.5202554434382276`}, {-0.6054377124708609, 
        1.5076751011032052`}, {-0.6491644237807317, 1.4984099764823813`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6589472297485056, 
        1.496337126416195}, {-0.6830622272054818, 
        1.4912274703278054`}, {-0.7465162101455016, 
        1.4748316925138893`}, {-0.8097756524920166, 
        1.455771484811578}, {-0.8727335514231203, 
        1.4340702822333202`}, {-0.9352833275524565, 
        1.409756368061827}, {-0.9973188249292202, 
        1.3828628738500683`}, {-1.035578299967601, 1.3645259472554754`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0445960687985532`, 
        1.3602039285938419`}, {-1.058734311038155, 
        1.3534277794212755`}, {-1.1194244767995551`, 
        1.3214939128689402`}, {-1.1792121702353935`, 
        1.2862815124323494`}, {-1.2380877610571228`, 
        1.2489289132726151`}, {-1.2958972980262276`, 
        1.2089219984370505`}, {-1.3525365306518773`, 
        1.1663157166947977`}, {-1.3800118835443682`, 
        1.1439091668505954`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.387761577257726, 
        1.1375891789274153`}, {-1.4079012084432412`, 
        1.121165016815}, {-1.4618870809094882`, 
        1.0735248475668009`}, {-1.5143898975597878`, 
        1.0234501577193422`}, {-1.56530540790331, 
        0.9709958960417678}, {-1.6145293614492224`, 
        0.9162170113032206}, {-1.6619268970927663`, 
        0.8591130203086064}, {-1.667090845465837, 0.8523626390390251}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.6731667512237463`, 
        0.8444201350748457}, {-1.7073742848615192`, 
        0.7997035969407351}, {-1.7507839709631574`, 
        0.7380739255856067}, {-1.792068401605357, 
        0.6743091906292207}, {-1.831140022995794, 
        0.6084945764575765}, {-1.8679112813421448`, 
        0.540715267456674}, {-1.8850421381122138`, 0.5060090636304687}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8894682774868785`, 
        0.49704194089036735`}, {-1.9022946228520856`, 
        0.4710564480125124}, {-1.9342024937332927`, 
        0.39960330251109144`}, {-1.9635141693256861`, 
        0.3263116886380093}, {-1.9901209871029155`, 
        0.2511844919699191}, {-2.013953486473252, 
        0.17437743872940273`}, {-2.0278553313349295`, 
        0.12249490645400007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0304435152263984`, 
        0.11283564643348401`}, {-2.0349422068449643`, 
        0.09604625513904291}, {-2.0530176876263244`, 
        0.016346667421421525`}, {-2.0681104682256017`, -0.06456559820087951}, \
{-2.0801510880510676`, -0.14653481550527753`}, {-2.0890700865109912`, \
-0.22940525826919062`}, {-2.0924276935686574`, -0.2816865676379874}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0930685926375303`, -0.29166600892412753`}, \
{-2.0954396789355716`, -0.32858620064369465`}, {-2.0971544426509148`, \
-0.42866782732487374`}, {-2.09421437765702, -0.529650138312728}, \
{-2.0866194839538883`, -0.6315331336072576}, {-2.0794479726673916`, \
-0.6908175948349481}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.078247049363996, -0.7007452221053164}, \
{-2.0742381999459187`, -0.7338850260321633}, {-2.0569389640375118`, \
-0.8362740284111461}, {-2.0347217762286673`, -0.9387001407442059}, \
{-2.007586636519385, -1.041163363031343}, {-1.9919869680040287`, \
-1.0907421940718827`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.9889855940689332`, -1.1002811538947213`}, \
{-1.9754826555476377`, -1.1431961624309015`}, {-1.9383589439513975`, \
-1.2443310061012258`}, {-1.917914689169093, -1.2945616945379255`}, \
{-1.8962155017306648`, -1.344567894042316}, {-1.8732613816361139`, \
-1.3943496046143984`}, {-1.8490523288854397`, -1.443906826254172}, \
{-1.836531665736055, -1.469577615987888}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8321479026720746`, -1.4785655312856019`}, \
{-1.8246222972872492`, -1.4939950841094287`}, {-1.798909927668124, \
-1.5437311968014658`}, {-1.7719145480035619`, -1.5931467636891077`}, \
{-1.7436381743670684`, -1.6421469866958815`}, {-1.7099607881400833`, \
-1.6918855438167304`}, {-1.674903572937542, -1.7410260173770444`}, \
{-1.638501350743205, -1.7894586395766288`}, {-1.6180710261971891`, \
-1.8153010695294982`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.6118692726899702`, -1.8231457016710138`}, \
{-1.6007425142291518`, -1.8372199996822154`}, {-1.5648821746755486`, \
-1.8826028237307277`}, {-1.5278412959134235`, -1.9272539913960276`}, \
{-1.4896198779427767`, -1.971173502678115}, {-1.4502179207636074`, \
-2.0143613575769894`}, {-1.4096354243759166`, -2.056817556092651}, \
{-1.367872388779704, -2.098542098225101}, {-1.3449041859838369`, \
-2.1204669826195053`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.3376707392061844`, -2.127371853922786}, \
{-1.324928813974969, -2.1395349839743374`}, {-1.2808046999617122`, \
-2.179796213340362}, {-1.235558039726796, -2.219205553722463}, \
{-1.189246826257083, -2.2576427725199317`}, {-1.1418710595525732`, \
-2.295107869732767}, {-1.0934307396132663`, -2.331600845360969}, \
{-1.0439258664391626`, -2.3671216994045383`}, {-1.0270090653732915`, \
-2.37867915764739}}]}, 
      {Arrowheads[{{0.007715843167073457, 1.}}], 
       ArrowBox[{{-1.0187520833666874`, -2.384320278825189}, \
{-0.993356440030262, -2.401670431863474}, {-0.9417224603865645, \
-2.4352470427377773`}, {-0.88902392750807, -2.467851532027447}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.48892307970544124`, -0.2255960376955776}, \
{-0.47234150955369236`, -0.28040013109869155`}, {-0.4497896989994949, \
-0.3342914501283743}, {-0.42137907044760137`, -0.3866246696979429}, \
{-0.3869891971479279, -0.43671018388136307`}, {-0.34668513167425963`, \
-0.4838938114240816}, {-0.30085651541715247`, -0.5275833642466368}, \
{-0.270339106115216, -0.551298164114163}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.26244295611178625`, -0.5574341901182911}, \
{-0.24989298976716226`, -0.5671866542695669}, {-0.19397346852061423`, \
-0.6019659754417034}, {-0.13344544754921822`, -0.6313000360892431}, \
{-0.06895144135660704, -0.6547712696987723}, {-0.0011339644464142538`, \
-0.6719621097568779}, {0.055434360027338696`, -0.6808303612870098}, {
        0.11043092748202081`, -0.6847764161768118}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.12042257758643235`, -0.6849228954630304}, {
        0.17270890806693165`, -0.6843536612130827}, {
        0.23258827891210598`, -0.6787857093381425}, {
        0.29278627488733044`, -0.6680518012192428}, {
        0.35289782877765363`, -0.6520142590866653}, {
        0.4124593593504511, -0.6307186486106343}, {
        0.47100728537309855`, -0.6042105354613739}, {
        0.5030553906427077, -0.5863522199496523}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5117907293757424, -0.5814845863131567}, {
        0.5280628197234573, -0.5724172133430517}, {
        0.5831593399910003, -0.5353605935326805}, {
        0.6358515120105207, -0.49322816805975256`}, {
        0.6856940016168118, -0.4462074289537593}, {
        0.7322642943443182, -0.3942318668820284}, {
        0.7751216199677619, -0.3374381736016198}, {
        0.7954657901328375, -0.3052847373228198}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8008126202312452, -0.29683421024465706`}, {
        0.8137932606823548, -0.27631864277662344`}, {
        0.8478064986833074, -0.21136556807112983`}, {
        0.8822599427192419, -0.1274721126911481}, {
        0.908598141528878, -0.03876019951943066}, {0.9262396039195075, 
        0.053975006578883405`}, {0.9283904040025739, 
        0.07865420697662007}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9292586162741077, 0.08861644605483729}, {
        0.9346028386984222, 0.14993834073865492`}, {0.9332616664573384, 
        0.24819920715608954`}, {0.9217899077879729, 0.34782701002739524`}, {
        0.9083955110163023, 0.41242932454452597`}, {0.8905863600123586, 
        0.47681972429540115`}, {0.8883240859454332, 0.483555393477431}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8851402190432355, 0.4930350027282962}, {
        0.8708863664150545, 0.5354742620897043}, {0.8474433201847803, 
        0.5935413842855224}, {0.8202535457196413, 0.650784897323016}, {
        0.7893277714405684, 0.7069692856210272}, {0.7546958645379219, 
        0.761863662046896}, {0.7163970715958388, 0.8152336251113281}, {
        0.6946404465391068, 0.8420195307957925}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.6883357288434453, 0.8497816525919261}, {
        0.6744795354548243, 0.8668408558592295}, {0.6290081220377702, 
        0.9164496482381802}, {0.5906117597057441, 0.9540937770824589}, {
        0.5500874860588226, 0.9902448401385171}, {0.5074958404919542, 
        1.0247776613529285`}, {0.4629020890326495, 1.0575715513071615`}, {
        0.41637622434098276`, 1.08851030721758}, {0.3849836859218514, 
        1.107308166002837}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.37640421875165786`, 1.1124455527972659`}, {
        0.3679929657095911, 1.117482212935443}, {0.3178317590636746, 
        1.1443800389469043`}, {0.2659767769609969, 1.1691010423730126`}, {
        0.21250181911470198`, 1.191565135589607}, {0.15749319648984317`, 
        1.211687350674498}, {0.10105973051272016`, 1.229365807743626}, {
        0.04331335863129562, 1.2445050515339477`}, {0.0037730192033273158`, 
        1.2528975477820967`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.006009063271857058, 
        1.2549738094343676`}, {-0.015630865684804207`, 
        1.257016051403438}, {-0.0756547729442894, 
        1.2668162013310886`}, {-0.1366370776342064, 
        1.2738293199169082`}, {-0.19845337821993775`, 
        1.2779856503819227`}, {-0.26100191481429885`, 
        1.279232865547126}, {-0.32416453199904005`, 
        1.2775193891764918`}, {-0.38778962152398055`, 
        1.272787108235359}, {-0.4041258427868641, 1.2707937165327077`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.41405221613917037`, 
        1.269582472514921}, {-0.45172520660197873`, 
        1.2649855081745047`}, {-0.5158189419089344, 
        1.2540716729301442`}, {-0.5799181135837871, 
        1.2400102849239318`}, {-0.6438696392285148, 
        1.2227736250629604`}, {-0.7075200679081368, 
        1.2023415727397608`}, {-0.7707386281756257, 
        1.1787049166637287`}, {-0.799078161952956, 1.1665606269529414`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8082697560746255, 
        1.1626217695675451`}, {-0.8333822975097055, 
        1.1518603371121627`}, {-0.8952805394005738, 
        1.1218082134241214`}, {-0.9562649072574587, 
        1.0885568765794538`}, {-1.0161690444086193`, 
        1.0521226091987999`}, {-1.0748286841013455`, 
        1.01252964554359}, {-1.1320816495019577`, 
        0.9698101715160445}, {-1.1491425404473465`, 0.9557763803966897}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1568654744102358`, 
        0.9494237202448438}, {-1.1877678536958063`, 
        0.9240043246591763}, {-1.241769399051258, 
        0.875150209763368}, {-1.2939498044058326`, 
        0.8232990307692895}, {-1.3441274503762795`, 
        0.7685217026550945}, {-1.3921270847638694`, 
        0.7108960270377618}, {-1.4309149337238063`, 0.6595875510758291}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.4369453868629378`, 
        0.6516104817557882}, {-1.4377798225543965`, 
        0.6505066921730969}, {-1.4809231459181769`, 
        0.5874452729557303}, {-1.5214009042100485`, 
        0.5218102309191195}, {-1.5590633139693721`, 
        0.4537069142355479}, {-1.5938049638495435`, 
        0.3832244098885922}, {-1.6255072160359314`, 
        0.3104706254917394}, {-1.6288271462024042`, 
        0.30174937724352346`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.6323848065517754`, 
        0.29240362672050435`}, {-1.6540130385370013`, 
        0.23558761829417238`}, {-1.6791758204048892`, 
        0.15872186308229685`}, {-1.7008593717354012`, 
        0.08002425217974052}, {-1.718937923668014, -0.0003499045526464406}, \
{-1.7332961283858743`, -0.08224087971679017}, {-1.734698846209352, \
-0.09332681132135293}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7359541507234764`, -0.10324770899126261`}, \
{-1.743829059115799, -0.16548452837739408`}, {-1.7505118592399884`, \
-0.24995434755341484`}, {-1.7532941851978299`, -0.3354977327220909}, \
{-1.7520540832963638`, -0.4219081250890366}, {-1.7471002921716492`, \
-0.5022808812124216}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7463295984520784`, -0.5122486457321929}, \
{-1.7371080325549344`, -0.5965040402828665}, {-1.7232474277403165`, \
-0.6842767895636506}, {-1.7050550831170816`, -0.7720909989505056}, \
{-1.6824982964035349`, -0.8597404536917197}, {-1.6690412335588627`, \
-0.9039337602013046}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.6661282452738435`, -0.913500081294146}, \
{-1.660635306665499, -0.9315390190890313}, {-1.635751721866957, \
-1.0029871892369975`}, {-1.607878956561032, -1.0739650539691754`}, \
{-1.5770538486130814`, -1.144353394594205}, {-1.5433186592006938`, \
-1.2140336838958117`}, {-1.5081310158286114`, -1.2802354307785966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5032098763922002`, -1.2889390647785037`}, \
{-1.4673141972541315`, -1.350799457039071}, {-1.424230985015206, \
-1.4175333320759713`}, {-1.3787499864922808`, -1.4831288115348522`}, \
{-1.3303013064946478`, -1.5473893179493636`}, {-1.2789516111049455`, \
-1.610199435741108}, {-1.2739028913633146`, -1.6159060118522917`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2672767146736377`, -1.6233955901099228`}, \
{-1.2247675664058117`, -1.6714437493316847`}, {-1.1678158384798845`, \
-1.7310068431426957`}, {-1.1081630934098008`, -1.7887733015957419`}, \
{-1.0458759972781995`, -1.8446277091124248`}, {-0.981021216167718, \
-1.8984546501143444`}, {-0.9790728876541528, -1.8999472417252203`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.971134607532255, -1.9060286649719844`}, \
{-0.9136043471088339, -1.950101922372699}, {-0.8436531940600828, \
-1.9994307006224679`}, {-0.7712677334961905, -2.046345634730928}, \
{-0.6965479418918818, -2.090751374565354}, {-0.6361311367133808, \
-2.1235695501423115`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6273438517303672, -2.1283427694571246`}, \
{-0.6195937957218829, -2.1325525699930226`}, {-0.5405052714609195, \
-2.1716538708812085`}, {-0.459382345583717, -2.207959927097188}, \
{-0.3763249945650006, -2.241375388508237}, {-0.29128928278403277`, \
-2.271762660718575}, {-0.2586052958623222, -2.2819942788202194`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.24906198294688614`, -2.28498178256048}, \
{-0.20428360629115366`, -2.2989995108826244`}, {-0.11548643906770485`, \
-2.3230136311929637`}, {-0.02507625509502797, -2.343732713842172}, {
        0.06676847164553412, -2.361084451022828}, {
        0.14081476658579262`, -2.3721492143495797`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.15070495508386741`, -2.373627108619326}, {
        0.15986926717263988`, -2.37499653492751}, {
        0.25404765750494757`, -2.3853966577487973`}, {
        0.3491251686611144, -2.392212511679267}, {
        0.40555702553956163`, -2.394503185698135}, {
        0.46219705184428916`, -2.395475460846618}, {
        0.5190452475752971, -2.395129337124715}, {
        0.5497177881236338, -2.3942345178251534`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5597135354301302, -2.393942908866668}, {
        0.5761016127325852, -2.393464814532427}, {
        0.6333661473161538, -2.3904818930697544`}, {
        0.6908388513260028, -2.386180572736696}, {
        0.7485197247621321, -2.3805608535332525`}, {
        0.8064087676245419, -2.373622735459424}, {
        0.8643845424460292, -2.36533363199506}, {
        0.9223256117593912, -2.3556609566200106`}, {
        0.9567672158826616, -2.349084910964907}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.966589775481324, -2.3472094582380363`}, {
        0.9802319755646276, -2.3446047093342752`}, {
        1.0381036338617387`, -2.3321648901378547`}, {
        1.0959405866507244`, -2.318341499030748}, {
        1.1537428339315847`, -2.3031345360129554`}, {
        1.2115103757043197`, -2.286544001084478}, {
        1.2692432119689294`, -2.2685698942453145`}, {
        1.326810788274566, -2.2492021341052544`}, {
        1.3516060219070432`, -2.240209324207568}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3610068312184174`, -2.2367998104165445`}, {
        1.3840825501703824`, -2.2284306392740856`}, {
        1.4410584976563785`, -2.2062554097518086`}, {
        1.497738630732554, -2.182676445538423}, {
        1.5541229493989093`, -2.1576937466339294`}, {
        1.610211453655444, -2.1313073130383273`}, {
        1.6660041435021584`, -2.103517144751617}, {
        1.7215010189390525`, -2.074323241773798}, {
        1.7252462487005833`, -2.072354505898756}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.734097804268787, -2.0677015537151417`}, {
        1.7760965803821458`, -2.04562427074267}, {
        1.8302762837672781`, -2.0155701983468823`}, {
        1.8840725256995305`, -1.9841593086763576`}, {
        1.937388116363659, -1.9513967494613293`}, {
        1.9912472165545176`, -1.9129433965137452`}, {
        2.0444385572523616`, -1.873047175462322}, {
        2.070400735403507, -1.8525889809846636`}}]}, 
      {Arrowheads[{{0.017718733406797076`, 1.}}], 
       ArrowBox[{{2.078255189572044, -1.8463996716763194`}, {
        2.0968516306228935`, -1.8317456774931002`}, {
        2.1485232726108783`, -1.7890263722107334`}, {
        2.199064445643444, -1.7472331574141997`}, {
        2.248758030826877, -1.7041349017314662`}, {
        2.297604028161178, -1.659731605162533}, {
        2.3456024376463462`, -1.6140232677074}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2152303616974011, -0.28042702973985895`}, \
{-0.15754067421779439`, -0.33291996871865415`}, {-0.08727224031167283, \
-0.3737875580006568}, {-0.006697413648318003, -0.3998654288555584}, {
        0.08110950542760084, -0.408808280089126}, {
        0.14844231091897536`, -0.40118359594850517`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15837880591860834`, -0.4000583994668768}, {
        0.17286788412808113`, -0.3984176740577724}, {
        0.2640826120709046, -0.3676725750419981}, {
        0.35011926326192977`, -0.31612699026035673`}, {
        0.4264617591248018, -0.24470332749055243`}, {
        0.4595110576247032, -0.20205095594377892`}, {
        0.4753905003686917, -0.17617116078048423`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4806203418056172, -0.16764773667132382`}, {
        0.4883528478723934, -0.15504555180039317`}, {
        0.5125722337087619, -0.10421603232839388`}, {
        0.5317543189746988, -0.050091314795779676`}, {0.5452825451588141, 
        0.0069487838614680705`}, {0.5527016836315417, 0.06640516644175322}, {
        0.5538388330565057, 0.127569995278656}, {0.5485210920973299, 
        0.18973543270575477`}, {0.5431599457064132, 
        0.21862101328873998`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5413351156974537, 0.22845310337368127`}, {
        0.5387303303242247, 0.24248755278309628`}, {0.5239075497126736, 
        0.2950856877094599}, {0.5041023536773369, 0.34705896303243766`}, {
        0.47936434563287394`, 0.3979365042996232}, {0.44958408954146667`, 
        0.4472331102134053}, {0.41477938092727934`, 0.49447504095233596`}, {
        0.37519067054794536`, 0.5392086142782517}, {0.3440489124337388, 
        0.5686845340901876}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33678626604295386`, 0.5755586862126256}, {
        0.33105840916109813`, 0.5809801479529891}, {0.2824949245300712, 
        0.6192645439893916}, {0.22971504281363792`, 0.6535938369994969}, {
        0.17311296236259194`, 0.6836000436439332}, {0.11308288152772678`, 
        0.7089151805833288}, {0.049815151304472595`, 
        0.7290727605175513}, {-0.01633679942744882, 
        0.7436850993150766}, {-0.020254998902972457`, 
        0.7441902067777206}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.030172927423173318`, 
        0.7454687582503592}, {-0.08473415549080944, 
        0.7525024183894458}, {-0.15473810170837873`, 
        0.7552749391541987}, {-0.2509833633499199, 
        0.7489039864963659}, {-0.3480718337999697, 
        0.7304949081085088}, {-0.4239620170955642, 0.7062983599409237}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43348947146750094`, 
        0.7032606612740605}, {-0.4445279605718439, 
        0.6997411898258198}, {-0.4919934871049713, 
        0.6792945758639449}, {-0.5386695709461518, 
        0.6557230579743114}, {-0.5894801873197745, 
        0.6263639451188037}, {-0.6388663547753407, 
        0.5932093245201218}, {-0.6865453344856598, 
        0.5563111708500834}, {-0.7322401069338265, 
        0.51574120065281}, {-0.7637201703685159, 0.483752072602511}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7707342979616889, 
        0.4766245194384378}, {-0.7756877783178507, 
        0.4715909362712168}, {-0.8166222530635595, 
        0.42397157408016883`}, {-0.8547733760282061, 
        0.37301397796336894`}, {-0.8898808288020043, 
        0.3188687849877587}, {-0.9360548413670351, 
        0.23260672925337209`}, {-0.9741422771352948, 
        0.14028236985269524`}, {-0.975357669895924, 
        0.13622003193285484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9782239893551652, 
        0.12663962417756724`}, {-1.0033422584464526`, 
        0.04268413232695828}, {-1.022953881092223, -0.059340394900142424`}, \
{-1.0324251330829455`, -0.1649768414745168}, {-1.031315634105116, \
-0.2673858130726401}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.030896799459371, -0.27737016730631997`}, \
{-1.0265250379423716`, -0.328027023170868}, {-1.0189737837244246`, \
-0.3830325855649804}, {-1.0085600535212644`, -0.4381258756081202}, \
{-0.9952533472741129, -0.49316157480336903`}, {-0.9790355592938721, \
-0.548020368434877}, {-0.9598939331773839, -0.6025682173267198}, \
{-0.9378179834570557, -0.6566385616319617}, {-0.9346274804180396, \
-0.6634536725811652}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9303875876266182, -0.6725103446585484}, \
{-0.9128054663609809, -0.7100668383156166}, {-0.8848623798129401, \
-0.7626904811546478}, {-0.8540029634324002, -0.8143489207379685}, \
{-0.8202496985345138, -0.8648835844664433}, {-0.7836333081301199, \
-0.914137896552887}, {-0.7441824268579312, -0.961999061192125}, \
{-0.7073930219619015, -1.0023526134050271`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.700587098607199, -1.009676606945184}, \
{-0.6569664081631666, -1.0529653714970382`}, {-0.6093336311188752, \
-1.0957178608143137`}, {-0.5591178155651455, -1.13642555814824}, \
{-0.5064029912455846, -1.1749282695331764`}, {-0.4512803277255876, \
-1.2110722546869042`}, {-0.39384813439233607`, -1.244710227010628}, \
{-0.3830737565188886, -1.2503136863481568`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3742018523742462, -1.2549277211170198`}, \
{-0.3341858136884074, -1.2757389687137524`}, {-0.2723933364332817, \
-1.3040423230025537`}, {-0.20860849057086192`, -1.3294662845086633`}, \
{-0.14297342554508918`, -1.3518673138271116`}, {-0.07563465229994126, \
-1.3711123375163288`}, {-0.006743043279434091, -1.387078748098145}, {
        0.0012891203419983094`, -1.3885158068599466`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.011132813639236818`, -1.3902769718919359`}, {
        0.06354616757237669, -1.3996544040577894`}, {
        0.13507338481139763`, -1.4087376298438898`}, {
        0.20771379648447086`, -1.4142872903961565`}, {
        0.28131804772083163`, -1.4162469004167608`}, {
        0.3556863180491983, -1.4145114639053362`}, {
        0.4093227818922205, -1.4105604875667799`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4192957612560741, -1.4098258566334876`}, {
        0.43061860096395366`, -1.408991792107869}, {
        0.5059147039251473, -1.3996145035166974`}, {
        0.5813742483584943, -1.386322023870512}, {
        0.6567966696553744, -1.3690725861543553`}, {
        0.7319812171728336, -1.3478402305996224`}, {
        0.8081737552966216, -1.3213918297950122`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.817620773965762, -1.318112525255188}, {
        0.8303893067964545, -1.3136802372344856`}, {
        0.9276042846762083, -1.272501820345682}, {
        1.0231452202959228`, -1.2244406571364284`}, {
        1.1164945317742552`, -1.1693179763709753`}, {
        1.162206832435481, -1.139234999665231}, {
        1.1710461220115491`, -1.1329831009829054`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1792104010923126`, -1.1272086272327348`}, {
        1.2071888243775075`, -1.1074199025660105`}, {
        1.25138157613598, -1.0738998100827353`}, {
        1.294726156246543, -1.038701847224826}, {
        1.3371636332448442`, -1.0018531390017025`}, {
        1.3786350756665282`, -0.9633808104227848}, {
        1.4190815520472413`, -0.9233119864974939}, {
        1.4584441309226284`, -0.88167379223525}, {
        1.4766090342700653`, -0.8611285420906798}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.483232780192732, -0.8536368139888361}, {
        1.4966521571245488`, -0.8384589487079096}, {
        1.533639238649874, -0.7936726875100787}, {
        1.5693528387817708`, -0.7473608994353044}, {
        1.603740420803404, -0.6995694752771328}, {
        1.6367494479979408`, -0.6503443058291102}, {
        1.6683273836485468`, -0.5997312818847821}, {
        1.6984216910383882`, -0.5477762942376954}, {
        1.7103930003143533`, -0.5254539419645545}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7151191730376294`, -0.5166412640860796}, {
        1.7269798334506303`, -0.4945252336813965}, {
        1.753929924518954, -0.4400060663339747}, {
        1.779207114113216, -0.3842532763773225}, {
        1.8027694198708468`, -0.3273225317006892}, {
        1.8245748594292777`, -0.2692695001933249}, {
        1.8445814504259406`, -0.21014984974447937`}, {
        1.8627472104982656`, -0.15001924824340213`}, {
        1.8637819814943366`, -0.146137278809202}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.8663576299879914`, -0.13647466866301822`}, {
        1.8790301572836845`, -0.08893336357934331}, {
        1.893388308419628, -0.026947863641552106`}, {1.908113662453539, 
        0.049518391926908045`}, {1.9197833556664363`, 0.12730061167259465`}, {
        1.9283588499757809`, 0.2062241792517488}, {1.931843004719376, 
        0.2573655673270223}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.9325227080319014`, 0.26734244075545377`}, {
        1.9338016072990336`, 0.2861144783206123}, {1.9360730895536558`, 
        0.3667968925354268}, {1.9351347586571077`, 0.4480968055524339}, {
        1.9309480765268507`, 0.5298396010278754}, {1.9234745050803457`, 
        0.6118506626179925}, {1.9160453744963752`, 0.6663101836034845}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.9146937365619245`, 0.6762184162861657}, {
        1.909994140052624, 0.7106689851419401}, {1.8915410692069747`, 
        0.8094286664126026}, {1.868115292543398, 0.9081297064299799}, {
        1.839716810061894, 1.0067721051940723`}, {1.8201534219555722`, 
        1.064201077934058}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8169288491289424`, 1.073666918102039}, {
        1.8063017471293152`, 1.1048631274562064`}, {1.7678262291125135`, 
        1.2019100379677081`}, {1.7242902560114903`, 1.2979128367285782`}, {
        1.6756938278262448`, 1.3928715237388165`}, {1.650526048162849, 
        1.4367261399919788`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.6455485657834348`, 1.4453993556103422`}, {
        1.6220918021518098`, 1.4862725427315}, {1.5635390365832187`, 
        1.5776023374397061`}, {1.5324061263386148`, 1.6224905256871305`}, {
        1.5000355311204714`, 1.6668609078634349`}, {1.4664272509287892`, 
        1.7107134839686202`}, {1.4315812857635681`, 1.7540482540026863`}, {
        1.4163405730820744`, 1.7725597575436798`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.4099845082899278`, 1.78027988969009}, {
        1.3636568185333073`, 1.836549908743534}, {1.291284928602848, 
        1.9166718685907946`}, {1.2494219676084475`, 1.9559437543940135`}, {
        1.2064098593770232`, 1.9943759361946614`}, {1.162303003075748, 
        2.031875215527047}, {1.126414203307418, 2.0609209017537564`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1186409971355598`, 2.0672119482334597`}, {
        1.1170832656488976`, 2.0684726585464017`}, {1.0732733393700171`, 
        2.1039295805270464`}, {1.0284889906977888`, 2.138427658683751}, {
        0.9827302196322122, 2.1719668930165157`}, {0.9359970261732875, 
        2.2045472835253395`}, {0.8882894103210149, 2.236168830210224}, {
        0.8396073720753943, 2.266831533071168}, {0.7910071409999961, 
        2.295903569105418}}]}, 
      {Arrowheads[{{0.014230264992898903`, 1.}}], 
       ArrowBox[{{0.7823249990003422, 2.3008649031863957`}, {
        0.7393200284041086, 2.325280407321235}, {0.68779746510388, 
        2.3529627961509783`}, {0.6354659636611758, 2.3794787760380207`}, {
        0.5823255240759962, 2.4048283469823617`}, {0.5283761463483412, 
        2.429011508984002}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.6372851535830713, -0.9366181491302348}, \
{-0.5980603152221183, -0.974766884407405}, {-0.5566797130249603, \
-1.0113900280599104`}, {-0.5132052237606559, -1.0463608759209544`}, \
{-0.4677034973010914, -1.0795572829877884`}, {-0.42024595662097775`, \
-1.1108616634217165`}, {-0.3709087977978522, -1.1401609905480923`}, \
{-0.3197729900120796, -1.167346796856319}, {-0.314566046820035, \
-1.169806817363903}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3055243558536245, -1.1740785646022038`}, \
{-0.2669242755468488, -1.1923151739998508`}, {-0.2124378361314413, \
-1.2149850894252685`}, {-0.15640153194988188`, -1.2352706265033235`}, \
{-0.09892605592917464, -1.2530688548501279`}, {-0.04012523850909802, \
-1.2682833570196124`}, {0.019883952357793055`, -1.2808242285035258`}, {
        0.07566162859180131, -1.2897561936759396`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.08556520076337659, -1.2911213846222274`}, {
        0.1430438950579348, -1.2975580260707276`}, {
        0.20594502342220536`, -1.301603707826606}, {
        0.26958132637836907`, -1.3026923480654473`}, {
        0.33383276725911615`, -1.3007719735580727`}, {
        0.3985454930310065, -1.2957840767989501`}, {
        0.46356529161001847`, -1.287677844854856}, {
        0.4840389049929258, -1.2841381472294586`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.4938927182284156, -1.2824345144286218`}, {
        0.5287375918615465, -1.2764101593648776`}, {
        0.5939074636003985, -1.2619455965404105`}, {
        0.6589196175908014, -1.2442564271651604`}, {
        0.7236184055463978, -1.223322616595142}, {
        0.7878711498081731, -1.1991351055949786`}, {
        0.8515327859214652, -1.1716908380482214`}, {
        0.8735731424538011, -1.1609329688091858`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.8825597862227919, -1.1565465997219726`}, {
        0.9144304132048016, -1.140990588314647}, {
        0.9763932604251024, -1.1070431752822139`}, {
        1.0372526857976856`, -1.0698654623670616`}, {
        1.0968421769862637`, -1.0294823575135101`}, {
        1.1549973511029425`, -0.9859268131940623}, {
        1.211555954708226, -0.9392398264094005}, {
        1.214951736514307, -0.9361575337792243}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.2223563248077838`, -0.9294365165791194}, {
        1.2663983419524778`, -0.8894603365371352}, {
        1.3193861277037449`, -0.836640535703261}, {
        1.3703353820229658`, -0.7808525586512074}, {
        1.4190686220878967`, -0.7221755070897842}, {
        1.4654148121931112`, -0.6606954496931845}, {
        1.4862021081280807`, -0.6302273423100171}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.4918379906969637`, -0.6219667837532509}, {
        1.5092093637500021`, -0.59650542210098}, {
        1.5502941352867807`, -0.5297054269181232}, {
        1.5885174324484752`, -0.4604024337149499}, {
        1.62377243814008, -0.38868699050826255`}, {
        1.6559389695096074`, -0.3146686703611058}, {
        1.674036372751666, -0.2669974137978723}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.6775855213678275`, -0.2576484275372984}, {
        1.6848580286532926`, -0.23849155977973654`}, {
        1.710381163999459, -0.16030421746043888`}, {
        1.7323704703085165`, -0.08025967428952896}, {1.7506985886729625`, 
        0.0014845666566467575`}, {1.7652487065173819`, 0.08476653011171281}, {
        1.7709907757889374`, 0.13034046095674662`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7722408387262243`, 0.14026202044368322`}, {
        1.7759145575984463`, 0.1694197686192621}, {1.782670772521941, 
        0.2553157475682215}, {1.7854662586258496`, 0.342299608317033}, {
        1.7841776123046342`, 0.4301620998813466}, {1.7786994803399938`, 
        0.5186940201572225}, {1.7764277700346847`, 0.5394183806961363}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7753381421305456`, 0.5493588389869055}, {
        1.7689445599008635`, 0.607686215921128}, {1.754843598543416, 
        0.6969295828299383}, {1.7363453942110603`, 0.786215065420939}, {
        1.7134167952344417`, 0.8753336571118225}, {1.693685896523078, 
        0.9401680647325019}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.690716308565931, 0.9497159004683567}, {1.665976251686228, 
        1.0208146472289037`}, {1.6376992376322033`, 1.0929027752871503`}, {
        1.6064319704925805`, 1.1643951686038267`}, {1.5722169567191269`, 
        1.2351720686864336`}, {1.5351021628644153`, 1.305114404293296}, {
        1.5293579637853123`, 1.3150312560612543`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.5243457296034812`, 1.3236844351595096`}, {
        1.4951410155818237`, 1.3741037914335648`}, {1.4514605444214157`, 
        1.4419052425597498`}, {1.4053479313143875`, 1.5085556637319988`}, {
        1.3562293738340974`, 1.573857723020941}, {1.3041719488859378`, 
        1.6376947545627898`}, {1.2936210286583365`, 1.6496528919245874`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.287004945364141, 1.6571513878967319`}, {
        1.2492427333752991`, 1.6999500924937574`}, {1.1915088042075739`, 
        1.7605070709500577`}, {1.1310372382881528`, 1.819249024067903}, {
        1.0678951125224279`, 1.8760592859835068`}, {1.00214950381579, 
        1.930821190833082}, {0.9986237661887555, 1.9335326752685014`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{0.9906968511367716, 1.9396289050672075`}, {
        0.933805876060161, 1.9833811662261924`}, {0.8628920978796325, 
        2.0335990603275476`}, {0.7895088532778529, 2.081378338106078}, {
        0.7137568262584698, 2.1266224645307146`}, {0.6562416349812311, 
        2.1580356752383247`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.647465329090993, 2.162829051388907}, {0.6357367008251317, 
        2.169234904570387}, {0.5555491609814869, 2.209119123194025}, {
        0.47329489073118336`, 2.2461785853705605`}, {0.38907457407786916`, 
        2.280316756068923}, {0.3028437462698598, 2.311395152818424}, {
        0.27965192238949665`, 2.318727385651538}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.2701170996318654, 2.3217418764842583`}, {
        0.21461072392104627`, 2.33929054676278}, {0.12455536308344001`, 
        2.363929283292534}, {0.03285751980905194, 
        2.3852377077982254`}, {-0.060302949850106154`, 
        2.403142165670397}, {-0.11903573214898792`, 2.4121139910236598`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.12892106209683465`, 
        2.4136240412950762`}, {-0.15474618984202249`, 
        2.4175690022995875`}, {-0.2502923441146861, 
        2.4284445630763396`}, {-0.34676155661608554`, 
        2.435695193391194}, {-0.40398849370346135`, 
        2.4382213806592627`}, {-0.4614309419158406, 
        2.4394157439614763`}, {-0.5190889012532234, 
        2.4392782832978344`}, {-0.5276613588129198, 2.4390606467878957`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5376581376481309, 
        2.4388068497826407`}, {-0.5769623717156096, 
        2.437808998668338}, {-0.6350513533029993, 
        2.4350078900729852`}, {-0.6933558460153926, 
        2.430874957511778}, {-0.7518758498527893, 
        2.4254102009847154`}, {-0.8106113648151896, 
        2.4186136204917976`}, {-0.869440190915206, 
        2.4104518844370366`}, {-0.9282401281654513, 
        2.400891661224444}, {-0.9353273999994172, 2.3995701370818825`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.945157960905591, 
        2.397737087090746}, {-0.9870111765659256, 
        2.3899329508540204`}, {-1.0457533361166287`, 
        2.3775757533257655`}, {-1.1044666068175606`, 
        2.363820068639679}, {-1.1631509886687217`, 
        2.348665896795761}, {-1.2218064816701113`, 
        2.3321132377940126`}, {-1.28043308582173, 
        2.314162091634432}, {-1.3319095438863877`, 2.2971162677950945`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3413826098650694`, 
        2.2939146319113464`}, {-1.3970738206050315`, 
        2.2740212081343425`}, {-1.4549564994940587`, 
        2.2518206883669745`}, {-1.5125473860480034`, 
        2.2282001165880576`}, {-1.5698464802668657`, 
        2.203159492797592}, {-1.6268537821506457`, 
        2.176698816995577}, {-1.6835692916993432`, 
        2.1488180891820137`}, {-1.7084565738130093`, 
        2.1358941485118654`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.717331286930609, 
        2.1312855188803694`}, {-1.7399930089129583`, 
        2.1195173093569015`}, {-1.7953072094395397`, 
        2.090810716524266}, {-1.8502113577429942`, 
        2.060742086644723}, {-1.904737749101474, 
        2.0293098709072286`}, {-1.9587894976805227`, 
        1.996518715744915}, {-2.013404235026105, 
        1.958035137190397}, {-2.058880556193029, 1.9243766633439632`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0669184683918322`, 
        1.9184275484951538`}, {-2.0673589270263233`, 
        1.9181015510299009`}, {-2.1205434231810205`, 
        1.8767545759667181`}, {-2.1729944403235817`, 
        1.8339820057664182`}, {-2.224540234418875, 
        1.7919343829652947`}, {-2.275237791302834, 
        1.7485607516741775`}, {-2.3250871109754585`, 
        1.7038611118930669`}, {-2.3718895575201966`, 1.6599005943963983`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.487159513781295, -1.1310976383068756`}, \
{-2.471972006446341, -1.192485426955094}, {-2.455322969902396, \
-1.2538248300408745`}, {-2.43721240414946, -1.3151158475642173`}, \
{-2.417640309187534, -1.376358479525122}, {-2.396597101120562, \
-1.4374156062056047`}, {-2.374073196052488, -1.4981501078876815`}, \
{-2.3682980128666205`, -1.5126843898326539`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.364605353636635, -1.5219776275790589`}, \
{-2.3500685939833135`, -1.5585619845713523`}, {-2.3245832949130376`, \
-1.6186512362566168`}, {-2.2976172988416605`, -1.6784178629434756`}, \
{-2.2691706057691823`, -1.7378618646319282`}, {-2.239243215695603, \
-1.7969832413219748`}, {-2.207835128620922, -1.8557819930136152`}, \
{-2.193248085710886, -1.8830999819201746`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.1885378173267744`, -1.8919211707147554`}, \
{-2.1773479046042827`, -1.9128771597732415`}, {-2.145468814801469, \
-1.9695356133316808`}, {-2.1121958912495025`, -2.025790035286129}, \
{-2.0775350378373196`, -2.0815423808449993`}, {-2.037058657384927, \
-2.137780569036707}, {-1.9951058042931895`, -2.19332897178127}, \
{-1.969436896798332, -2.225715949802381}}]}, 
      {Arrowheads[{{0.0044355913101495215`, 1.}}], 
       ArrowBox[{{-1.9632255222821975`, -2.23355296623852}, \
{-1.951714375054836, -2.2480768127374415`}, {-1.9068717375056239`, \
-2.302061017352304}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{1.6956016088787649`, -2.4920063141281146`}, {
        1.7588781190773355`, -2.4642852943988105`}, {
        1.8218347776461206`, -2.435016061227807}, {
        1.8844715845851197`, -2.4041986146151024`}, {
        1.9467885398943334`, -2.3718329545606984`}, {
        2.0065904297151334`, -2.3407745476310517`}, {
        2.054030861682845, -2.3148213731582823`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.0628038576838685`, -2.3100219418205064`}, {
        2.0659640156573658`, -2.308293118370848}, {
        2.124941892208798, -2.2743870517484837`}, {
        2.1834262759061285`, -2.2390611928587703`}, {
        2.2424334109732356`, -2.1978654003084186`}, {
        2.3007627819945125`, -2.1551618967709865`}, {
        2.358304088494215, -2.110986378503709}, {
        2.392006775881207, -2.083889260772134}}]}, 
      {Arrowheads[{{0.0009812021400578618, 1.}}], 
       ArrowBox[{{2.4022654614737142`, -2.0673090153189744`}, {
        2.412628852178875, -2.0673090153189744`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6887833911683741, -0.2967896813885488}, {
        0.7250200114667311, -0.23862691375485273`}, {
        0.7564476053368271, -0.17634939179657136`}, {
        0.7827157578631752, -0.11042378838370964`}, {
        0.8034740541302889, -0.041316776386271924`}, {0.8182457394341451, 
        0.030708017663463802`}, {0.823299599997432, 0.07549081381405}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8244210088523902, 0.0854277369887566}, {0.82665513090155, 
        0.10522453016303868`}, {0.8285034213632619, 0.18152243263717702`}, {
        0.8235918036500399, 0.25889139661060323`}, {0.8065596755261463, 
        0.36065707028434024`}, {0.7772003183830122, 0.4620891769381855}, {
        0.7704406320627316, 0.478182962638404}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7665681629162953, 0.48740272308593724`}, {
        0.7353513182114847, 0.5617252855706661}, {0.7093440203599873, 
        0.610317761846529}, {0.6802307028526737, 0.65784486207625}, {
        0.649201034920911, 0.703238189174807}, {0.6152676838552481, 
        0.7473001341309962}, {0.5784786486306752, 0.7898485645554936}, {
        0.5494676640465628, 0.8197900558481754}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.5425090728291919, 0.826971838932447}, {0.5388922869151038,
         0.8307046306837986}, {0.4965806998853342, 0.8696958601336258}, {
        0.4516227553614911, 0.9066497789151787}, {0.4041037424176379, 
        0.9413935956395807}, {0.3541209666898043, 0.9737593173423175}, {
        0.2664873675777471, 1.0215816319258253`}, {0.21061098687062474`, 
        1.045607586299419}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.20142424193368938`, 1.049557740405741}, {
        0.17300072131560867`, 1.0617794018817472`}, {0.07434993077139634, 
        1.093642357971044}, {-0.028725990957929305`, 
        1.1165395142795642`}, {-0.08169569980893304, 
        1.1244628444789193`}, {-0.1354970425107005, 
        1.129962483440698}, {-0.18757993411442933`, 1.1328389306430966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1975759612602702, 
        1.1330367827192214`}, {-0.2451203706199489, 
        1.1334361942376614`}, {-0.30070192152099023`, 
        1.1312987223259372`}, {-0.35663423725991406`, 
        1.1265144716828184`}, {-0.4127937955003478, 
        1.1190433733948733`}, {-0.4690557518726557, 
        1.1088516397326793`}, {-0.5253975762272556, 
        1.095895643540885}, {-0.5816243335870999, 
        1.0801683808856597`}, {-0.5917501330038012, 1.076818219383219}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6012440037988913, 
        1.0736771340093179`}, {-0.6375894515382434, 
        1.061652096301726}, {-0.6931476814119797, 
        1.0403357764273762`}, {-0.7481550982848406, 
        1.0162151500044718`}, {-0.8024691009785972, 
        0.989292687878444}, {-0.8559484120602594, 
        0.959577602998293}, {-0.9084530778420762, 
        0.9270858504165875}, {-0.9567854249417501, 0.8939495404383341}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9648620655767992, 
        0.8880574425878481}, {-1.0100570681856211`, 
        0.8538630069023335}, {-1.0588788003185765`, 
        0.8131979482009242}, {-1.1061835220627578`, 
        0.7698870601933988}, {-1.1518280089208175`, 
        0.7239809542731646}, {-1.195672557815266, 
        0.6755367737543112}, {-1.2375809870884742`, 
        0.6246181938716105}, {-1.2493291823503916`, 0.6088940008216172}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.255314516050482, 
        0.6008830220737635}, {-1.2774206365026712`, 
        0.5712954217805164}, {-1.3150953685156155`, 
        0.5156280210299681}, {-1.3504955530139118`, 
        0.45769094202805405`}, {-1.3834762131349023`, 
        0.3975858960577989}, {-1.4138994135718592`, 
        0.33541929426667616`}, {-1.4416342605739856`, 
        0.27130224766660677`}, {-1.4488183073587473`, 
        0.2522914232760456}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.4523532516492226`, 
        0.2429370569766517}, {-1.4665569019464146`, 
        0.2053505671339601}, {-1.4885505270502102`, 
        0.13768476340955327`}, {-1.5075053668023675`, 
        0.0684300470986504}, {-1.523347286587774, -0.002311853858601512}, \
{-1.5359944521126367`, -0.07441998199791965}, {-1.5449914426060096`, \
-0.14501319343441457`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.545916358628699, -0.15496811727086887`}, \
{-1.5512807365105719`, -0.22209782575169612`}, {-1.5537331921149145`, \
-0.297344760010722}, {-1.5526175669212539`, -0.3733123587409503}, \
{-1.5478657579615753`, -0.44983499694476237`}, {-1.5394197537344039`, \
-0.5267453558965787}, {-1.5351720164720308`, -0.5537643568784644}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5336189622514704`, -0.5636430218990023}, \
{-1.5272857552526664`, -0.6039272757380868}, {-1.5114521525889324`, \
-0.6812356544339186}, {-1.4918536847148292`, -0.7584614476085884}, \
{-1.4684409549802961`, -0.8353995547688062}, {-1.4411804311135852`, \
-0.9118488193034808}, {-1.4263416425974305`, -0.9479676507589652}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.422541518731724, -0.9572174647357589}, \
{-1.410054445221259, -0.9876120284837169}, {-1.3750611937881927`, \
-1.0624959134628154`}, {-1.3362147376775744`, -1.1363111492762739`}, \
{-1.3003594911354173`, -1.1977292054087987`}, {-1.2617382404552249`, \
-1.2581414798506332`}, {-1.2284315434484232`, -1.3059299888460232`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2227136683217055`, -1.3141340064005669`}, \
{-1.2204093065328394`, -1.3174403088553968`}, {-1.176436178431811, \
-1.3755200342436689`}, {-1.1298875133833992`, -1.43227700340299}, \
{-1.080837136786573, -1.4876095692878608`}, {-1.0293640422080084`, \
-1.5414180904197448`}, {-0.9746703574264746, -1.5932626474590519`}, \
{-0.9552520571063271, -1.6104764208404787`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.947768989067409, -1.6171099487649636`}, \
{-0.9180028665704909, -1.6434967734951442`}, {-0.8588468699411993, \
-1.6917904375448374`}, {-0.7972942815245476, -1.7380490120469965`}, \
{-0.733437015306484, -1.782177869440487}, {-0.6673669852729575, \
-1.824082382164174}, {-0.6232608202510999, -1.8496864861874582`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6146124261410386, -1.854706972151691}, \
{-0.599176105409917, -1.863667922656922}, {-0.5289562897033107, \
-1.9008398633575965`}, {-0.45679945213908646`, -1.9355035767050632`}, \
{-0.3827472373089276, -1.9675133738492283`}, {-0.30685956958425026`, \
-1.9967421336814384`}, {-0.24943488216935564`, -2.0162633151835}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23996699332319762`, -2.019481867776949}, \
{-0.2292557826206017, -2.0231230802527174`}, {-0.15005521007353037`, \
-2.0465894376140894`}, {-0.06937718559858434, -2.067074429816579}, {
        0.012658957148688353`, -2.08451128091121}, {
        0.09593388451273986, -2.098833214949006}, {
        0.14994390208166825`, -2.1059626544424828`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15985790149267232`, -2.107271323873092}, {
        0.18032826283802153`, -2.1099734559809926`}, {
        0.2658531554461584, -2.117785864491934}, {
        0.3524722085761669, -2.1221531604452357`}, {
        0.4399949629485864, -2.1230518571098806`}, {
        0.5282309592839565, -2.120458467754853}, {
        0.5590984797972454, -2.118333962267085}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5690748781346858, -2.117647321012342}, {
        0.6169897383028164, -2.1143495056491353`}, {
        0.7060808407257059, -2.104701484061712}, {
        0.795313807273164, -2.0914909162615656`}, {
        0.8844981786657306, -2.07469431551768}, {
        0.9382838108511147, -2.0627753319121225`}, {
        0.9638250343013456, -2.056455378002018}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.973532275320545, -2.054053405521915}, {
        0.9919256066780664, -2.0495021354287126`}, {
        1.0454235661465858`, -2.03487472606745}, {
        1.0987776892566732`, -2.018893103828335}, {
        1.1519879760083278`, -2.001557268711367}, {
        1.2050544264015504`, -1.9828672207165465`}, {
        1.2579770404363408`, -1.9628229598438742`}, {
        1.3107558181126988`, -1.941424486093349}, {
        1.351243748034018, -1.923878362422681}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.360419192334713, -1.9199020297046046`}, {
        1.3632566293308082`, -1.91867237878054}, {
        1.4153453439908528`, -1.894567217221016}, {
        1.4670219620928326`, -1.869109001414777}, {
        1.5182864836367476`, -1.842297731361823}, {
        1.569138908622598, -1.8141334070621542`}, {
        1.6195792370503834`, -1.7846160285157704`}, {
        1.6696074689201037`, -1.7537455957226713`}, {
        1.7104437545031204`, -1.7272242330455312`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.7188302754957911`, -1.7217775583132295`}, {
        1.7192236042317592`, -1.7215221086828574`}, {
        1.768290360981491, -1.6879729563109}, {
        1.8166704571654402`, -1.653125527521371}, {
        1.8643638927836066`, -1.61697982231427}, {
        1.91137066783599, -1.579535840689597}, {
        1.9576907823225915`, -1.5407935826473527`}, {
        2.00332423624341, -1.500753048187536}, {
        2.0323468933584867`, -1.4740601065095278`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.0397072020283638`, -1.4672906267448682`}, {
        2.048271029598445, -1.4594142373101475`}, {
        2.092531162387698, -1.4167771500151873`}, {
        2.169608895516802, -1.3408061332941805`}, {
        2.207217572411441, -1.301359223198548}, {
        2.244143866400323, -1.2609600071650873`}, {
        2.2801345314749364`, -1.2161118269075195`}, {
        2.3117549160308326`, -1.1748990813535514`}}]}, 
      {Arrowheads[{{0.0055985707247047534`, 1.}}], 
       ArrowBox[{{2.31776799452296, -1.1669096523362146`}, {
        2.3495441947443156`, -1.123540194911666}, {
        2.382915029445379, -1.0758493598757939`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.09588846559184347, 0.8329915145533373}, {
        0.02264095506440067, 0.8529471663006506}, {-0.05356629185049227, 
        0.8665725212974629}, {-0.1320275410691691, 
        0.8736187226763111}, {-0.21203705850796367`, 
        0.8738369135697325}, {-0.2994848982871876, 0.8651300871450203}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.30943569691757006`, 
        0.8641393265192491}, {-0.3188386886592803, 
        0.8632031088016385}, {-0.3725216790967594, 
        0.8531080429836588}, {-0.4261476714466911, 
        0.8397683290585168}, {-0.4795248265276543, 
        0.8231610392167386}, {-0.5324613051582301, 
        0.8032632456488493}, {-0.5847009743553716, 
        0.7796573230574761}, {-0.6360526185479716, 
        0.7527580318283927}, {-0.6812274419860039, 0.72520038032918}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6897643932967431, 
        0.7199926493148063}, {-0.7117496235626016, 
        0.7065811677043126}, {-0.7844127447940255, 
        0.6530365134196151}, {-0.8533043169578355, 
        0.5922986729960933}, {-0.9177156967068955, 
        0.5246045144283649}, {-0.9770132581094895, 
        0.45023218645281216`}, {-0.9789945260087808, 0.4472457638291048}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.984522813809974, 
        0.4389128151320841}, {-1.0305435856433418`, 
        0.36954436969731796`}, {-1.0776287807794795`, 
        0.28299041782729123`}, {-1.1176424953236614`, 
        0.19107167098003836`}, {-1.1363917220315298`, 
        0.13856168111177974`}, {-1.1527738475621716`, 
        0.08467934078313086}, {-1.154217159091869, 0.07896195517556695}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.156664798595856, 
        0.06926612819389477}, {-1.1666936516023634`, 
        0.029538863040131036`}, {-1.1780625873389134`, \
-0.026742833603274258`}, {-1.1867987814586631`, -0.08404612516523347}, \
{-1.1928270341484861`, -0.1422486821959889}, {-1.1960788190952885`, \
-0.20122546977787692`}, {-1.1964922834860081`, -0.2608487475253282}, \
{-1.1940221626818384`, -0.3210145242607444}, {-1.1934701494986275`, \
-0.3272110796052861}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.192582824633492, -0.3371716345388083}, \
{-1.188624753978628, -0.3816024644835012}, {-1.1802513508892851`, \
-0.44245836949570266`}, {-1.1688609779920007`, -0.5034281569636394}, \
{-1.1544203909302482`, -0.5643578609177897}, {-1.1369040764127845`, \
-0.6250936317528195}, {-1.1162942522136485`, -0.6854817362275825}, \
{-1.1007202939304903`, -0.7248128926201706}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.097038710836692, -0.7341105238197535}, \
{-1.0925808671721626`, -0.7453685574651189}, {-1.065762522863047, \
-0.804626562462596}, {-1.0358450767541565`, -0.8631149468873553}, \
{-1.002841031856048, -0.9206624388147766}, {-0.9667707205560401, \
-0.9771006525521542}, {-0.9276623046182138, -1.0322640886386965`}, \
{-0.8929860115954009, -1.0765052822677939`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8868171108930811, -1.084375775525838}, \
{-0.8855517751834112, -1.085990133845526}, {-0.8404829527692366, \
-1.1381190611756802`}, {-0.7925074872700554, -1.188494029864111}, \
{-0.7416718757613803, -1.2369988261421578`}, {-0.6880371377385591, \
-1.283500665012279}, {-0.6316874122152022, -1.3278251974751338`}, \
{-0.5937805845498194, -1.3548085653021007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5856338135390537, -1.3606077136963177`}, \
{-0.5727132828141499, -1.3698049864448387`}, {-0.5112117777674723, \
-1.4092795067489683`}, {-0.4472863699164687, -1.4460951451285555`}, \
{-0.381046976711668, -1.4801052002380921`}, {-0.31260996021282866`, \
-1.5111698826455275`}, {-0.2420709448397877, -1.539190793327598}, \
{-0.23093443457383486`, -1.5430093610192144`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.22147506257218888`, -1.5462528593365372`}, \
{-0.16954601358117402`, -1.5640586695946836`}, {-0.0951897086838456, \
-1.5856305526650154`}, {-0.019160117563980394`, -1.6037740733764498`}, {
        0.05838112719292354, -1.6183674521864706`}, {
        0.13726884783204796`, -1.6292994991721874`}, {
        0.1681175954776956, -1.6320621015014027`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.17807773623674972`, -1.6329540634175346`}, {
        0.21733432142925463`, -1.6364696140303374`}, {
        0.298405279891086, -1.6397877860772838`}, {
        0.38034577426357224`, -1.6392208071273227`}, {
        0.4629957581575503, -1.634722233308228}, {
        0.5461446887174931, -1.626201781866284}, {
        0.5769429209372391, -1.621544623713043}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5868305149611452, -1.6200494700692945`}, {
        0.629582730111494, -1.6135846890410868`}, {
        0.7131007535312647, -1.5968117100655457`}, {
        0.7964903371921368, -1.5758391191658827`}, {
        0.8795437663330624, -1.550638709561632}, {
        0.9620540332166126, -1.5211977934656413`}, {
        0.9724346229845245, -1.517014642169293}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9817098340593646, -1.5132769343801307`}, {
        1.0167336059709768`, -1.4991631180989062`}, {
        1.071025871845557, -1.475207707922983}, {
        1.1248675157056849`, -1.449349894642751}, {
        1.178195578659701, -1.4216100845040915`}, {
        1.2309474580589561`, -1.3920107582938868`}, {
        1.28306090749781, -1.3605764713400206`}, {
        1.334474036813631, -1.3273338535113788`}, {
        1.3348707618940423`, -1.3270564363735842`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3430658985095114`, -1.3213258399077878`}, {
        1.3850645132799164`, -1.2919575542202357`}, {
        1.434850942810624, -1.25494296316264}, {
        1.483730511827456, -1.2160783973099125`}, {
        1.531642220775304, -1.1753956728834445`}, {
        1.578525070099058, -1.1329266061046253`}, {
        1.6243180602436111`, -1.088703013194845}, {
        1.6483544616412897`, -1.0639644144223883`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6553230075264393`, -1.0567922900337177`}, {
        1.6689601916538523`, -1.0427567103754927`}, {
        1.7123904647746733`, -0.9951195138679598}, {
        1.7545478800509657`, -0.9458232398936349}, {
        1.7953579735654837`, -0.8948650233360486}, {
        1.8347511775326684`, -0.842254610474317}, {
        1.8726738365949391`, -0.7880427346232075}, {
        1.902154100327097, -0.7428788356149192}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.907620100947434, -0.7345048976393623}, {
        1.9090722953947168`, -0.7322801290974876}, {
        1.9438928985744206`, -0.6750175272119255}, {
        1.9770819907764703`, -0.6163056622812898}, {
        2.008585916643286, -0.5561952676203478}, {
        2.0383510208172875`, -0.4947370765438668}, {
        2.0663033242240205`, -0.43196498237477365`}, {
        2.0881777460910413`, -0.3782322545452991}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.091948247577174, -0.36897032609906966`}, {
        2.0923762382315307`, -0.3679190020693912}, {
        2.1165271931459873`, -0.30265905439258284`}, {
        2.138713619273559, -0.23624505810921195`}, {
        2.158892946920417, -0.1687369319841421}, {
        2.1770226063927285`, -0.10019459478223666`}, {
        2.193060027996665, -0.030677965268358774`}, {2.2020759122615647`, 
        0.01499673808977818}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2040124783026487`, 0.024807431845498048`}, {
        2.2069626420383943`, 0.03975303779262757}, {2.2210832840928645`, 
        0.12818853251798118`}, {2.231694869355575, 0.21800360935358848`}, {
        2.238759518154512, 0.3090018910838745}, {2.242239350817663, 
        0.40098700049326363`}, {2.2422063243258017`, 0.4224344583424254}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2421909255531656`, 0.4324344464863084}, {
        2.2420964876730136`, 0.4937625603661805}, {2.2382930490485506`, 
        0.5871321934870499}, {2.23079115527226, 0.6808995226402962}, {
        2.2195529266721277`, 0.7748681706103441}, {2.2110573239833333`, 
        0.830745540063971}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2093273334644734`, 0.8405946027452809}, {
        2.200994226128366, 0.887663892009499}, {2.1896132181452406`, 
        0.9439816530482973}, {2.176831105021285, 1.0002460143132426`}, {
        2.1626478867565004`, 1.056456975804335}, {2.147063563350886, 
        1.1126145375215744`}, {2.130078134804442, 1.168718699464961}, {
        2.111691601117168, 1.2247694616344944`}, {2.110628181720461, 
        1.2277701575966442`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{2.107287832239936, 1.2371957644921154`}, {2.091895186873653,
         1.2806298498026065`}, {2.070680116658485, 1.3361628897417286`}, {
        2.0480463904716637`, 1.3913685814518606`}, {2.0239940083131893`, 
        1.4462469249330023`}, {1.998522970183062, 1.5007979201851542`}, {
        1.9716332760812818`, 1.5550215672083163`}, {1.9464494057976565`, 
        1.6029691654992433`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.9417330642876187`, 1.611786448249494}, {
        1.9135979199627617`, 1.6624868165676698`}, {1.8824705036353255`, 
        1.7155863850064161`}, {1.8499609227148432`, 1.768074537421282}, {
        1.8160691772013149`, 1.8199512738122672`}, {1.7807952670947398`, 
        1.8712165941793715`}, {1.7441391923951188`, 1.9218704985225954`}, {
        1.724771959400744, 1.947349714935376}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7187205269180015`, 1.9553108809873314`}, {
        1.7061009531024516`, 1.971912986841939}, {1.6666805492167382`, 
        2.0213440591374017`}, {1.6258779807379784`, 2.0701637154089836`}, {
        1.5884429395216253`, 2.1149118975600274`}, {1.5498746340763871`, 
        2.15902604394857}, {1.510165476027, 2.202533918424032}, {
        1.4693382304992535`, 2.2453522294381507`}, {1.4565991885686693`, 
        2.257041380473121}}]}, 
      {Arrowheads[{{0.0111884516294618, 1.}}], 
       ArrowBox[{{1.449231017741095, 2.2638023019085236`}, {
        1.4233835149082767`, 2.287519577205676}, {1.376269339464789, 
        2.3288210818497306`}, {1.3280477856140218`, 2.369168425209289}, {
        1.278701492874232, 2.4085910466713605`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7624958873600631`, 
        2.490665420589773}, {-1.8262331874620434`, 
        2.4613313993883748`}, {-1.8896156099242813`, 
        2.430425954414734}, {-1.9526431547467773`, 
        2.3979490856688503`}, {-2.0153158219295313`, 
        2.363900793150725}, {-2.0753384157560295`, 
        2.3312916847080363`}, {-2.1176923850485387`, 2.307082070286456}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.1263741677231542`, 
        2.3021195457685577`}, {-2.1348993709914272`, 
        2.2972465223556853`}, {-2.1940317801827147`, 
        2.261763048397995}, {-2.252636365688921, 
        2.2248480359219966`}, {-2.311662704147965, 
        2.181962949696726}, {-2.3699721792747495`, 
        2.1375603253873487`}, {-2.4274533468278205`, 
        2.091678579885938}, {-2.4521292619542625`, 2.071057861041371}}]}, 
      {Arrowheads[{{0.0015860385100881342`, 1.}}], 
       ArrowBox[{{-2.4638296535709174`, 
        2.0476700950447246`}, {-2.4801163817574294`, 2.0476700950447246`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000014`, 1.}}], 
       ArrowBox[{{2.4037345148372182`, 2.0271102687954095`}, {
        2.3712048301831965`, 2.0877523623545287`}, {2.337232862882375, 
        2.1479393335498655`}, {2.3018165297713864`, 2.2077042142423515`}, {
        2.264962080340331, 2.2669479088491933`}, {2.222134957202308, 
        2.3266375784021758`}, {2.1924664497439403`, 2.3660921423381716`}}]}, 
      {Arrowheads[{{0.008068443753518293, 1.}}], 
       ArrowBox[{{2.186456395884165, 2.374084592062918}, {2.177783440820425, 
        2.3856182919147404`}, {2.1319450949474277`, 2.4437787601084087`}, {
        2.085561192218366, 2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.564381622781802, 
        0.4619339823233991}, {-0.6135969059878413, 
        0.4173491986775392}, {-0.6594985245055178, 
        0.3677433022012669}, {-0.7016170303347863, 
        0.3134262025896493}, {-0.73939314643691, 
        0.2545767487226082}, {-0.7723394590041053, 
        0.19147863813218166`}, {-0.7938663563167657, 0.139606275430481}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7976993695133316, 
        0.13037004189970933`}, {-0.8000943148827584, 
        0.12459905349161225`}, {-0.822296060919255, 
        0.05440517747414151}, {-0.8384589969229637, -0.01884271966119042}, \
{-0.8481966603328666, -0.09471883772398072}, {-0.8512962544397704, \
-0.17250769914394398`}, {-0.8475449825344812, -0.2514938263507938}, \
{-0.8458031711733942, -0.26305975952267924`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8443139795557509, -0.2729482532566076}, \
{-0.8318758568709811, -0.35553957110516105`}, {-0.8036846916360186, \
-0.45945441290959943`}, {-0.7848289315187789, -0.5109032034529961}, \
{-0.7627823539148944, -0.5617624353683388}, {-0.7371496536995916, \
-0.611762417585823}, {-0.7156584514600576, -0.6483024909568125}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7105887687047335, -0.6569221380934631}, \
{-0.7083448792633562, -0.6607372752789245}, {-0.6771100685681256, \
-0.7082189809416406}, {-0.6428208020762122, -0.7543644744149538}, \
{-0.6055244233451589, -0.7989807952463104}, {-0.5652793590432571, \
-0.8418783277458888}, {-0.5221585449796224, -0.8828742186188677}, \
{-0.4762423642871011, -0.9217853324580959}, {-0.4406300935850602, \
-0.9486223544635444}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43264387334394744`, -0.9546406836553085}, \
{-0.42761829782736327`, -0.9584279030061061}, {-0.3763865876283746, \
-0.9926231827104987}, {-0.2876718024784652, -1.0426407168785043`}, \
{-0.19290402192960313`, -1.084997466672748}, {-0.09276922166227014, \
-1.1189655870609294`}, {-0.072606103866161, -1.1237637889312533`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.0628777656053801, -1.1260788342188939`}, {
        0.01199488727992068, -1.1438962227171987`}, {
        0.06588499043664017, -1.1528040884844326`}, {
        0.12065718468256856`, -1.1592640157197072`}, {
        0.17619309984442835`, -1.1632082572387383`}, {
        0.23237291778443048`, -1.1645753651944322`}, {
        0.2890753724002727, -1.1633101910768853`}, {
        0.33364360479423416`, -1.1602301116986589`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.34361980951948895`, -1.159540663165551}, {
        0.34617774962514114`, -1.1593638857133848`}, {
        0.40355588742771165`, -1.1526938992684084`}, {
        0.4610841758121489, -1.143263981243624}, {
        0.518998619387628, -1.130968576472626}, {
        0.576842984128467, -1.1158329829852585`}, {
        0.6344674274634163, -1.0978364871156587`}, {
        0.6917233475392416, -1.0769653057845028`}, {
        0.7296056927479534, -1.0611068611992711`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.738830040296775, -1.0572453314119266`}, {
        0.7484633832207206, -1.0532125864990063`}, {
        0.8045414140906456, -1.0265784073529238`}, {
        0.8598125604498239, -0.9970697770265483}, {
        0.9141331833170762, -0.9647006347867122}, {
        0.9673820374898937, -0.9294901811650352}, {
        1.0194282129058432`, -0.8914654079077794}, {
        1.070117126615732, -0.8506622034378077}, {
        1.076272397972157, -0.8452130118478762}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0837598615325001`, -0.8385844456807076}, {
        1.1192976927148532`, -0.807123208703535}, {
        1.1668223223429817`, -0.7608978171789293}, {
        1.2125469236843767`, -0.7120421748635111}, {
        1.2563309019677829`, -0.6606191802823511}, {
        1.2980371594664277`, -0.6066984844860741}, {
        1.3375662023463533`, -0.5503394515775313}, {
        1.3454809359443005`, -0.5378583944277895}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3508363160810535`, -0.529413283203485}, {
        1.3748044498429461`, -0.4916169829802631}, {
        1.4096016479480442`, -0.43063280135638815`}, {
        1.4418146777617915`, -0.367493564349756}, {
        1.4713075554926376`, -0.30231086458594714`}, {
        1.4979514324573384`, -0.23520122967227292`}, {
        1.5208227948743092`, -0.16862024832585604`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.523733356592806, -0.15905534522701567`}, {
        1.5422124648968552`, -0.09569193973322715}, {
        1.5596373668814885`, -0.023521620306213353`}, {1.5738134138892368`, 
        0.05010232411888055}, {1.5846267933996065`, 0.12501900415547815`}, {
        1.5919740032894525`, 0.20106562418459623`}, {1.5935795763479188`, 
        0.23370900029632946`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.5940708351185622`, 0.24369692624821088`}, {
        1.5957618518329777`, 0.27807748235484525`}, {1.5959074577017347`, 
        0.3558879705824303}, {1.5923382499646241`, 0.4343285745511492}, {
        1.5849919680878959`, 0.5132288737123933}, {1.573872949921001, 
        0.5924697362955953}, {1.564653526329308, 0.6415989428602219}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.562809153417956, 0.651427385695375}, {1.5589668241269214`,
         0.6719026993146173}, {1.5402032350270958`, 0.7513147416497244}, {
        1.5175281413921342`, 0.830496610083223}, {1.4909038164418207`, 
        0.9092428192994615}, {1.460308847845112, 0.9873516518848294}, {
        1.4406285697627128`, 1.0313416101385444`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.436544812352316, 1.0404697493472237`}, {
        1.4257381377201381`, 1.0646251583277575`}, {1.3872029026342014`, 
        1.140869157018719}, {1.3515519032253913`, 1.204315306540885}, {
        1.313055676925873, 1.2667796710546595`}, {1.271771982037057, 
        1.328151237659783}, {1.2316324495300384`, 1.38303169224597}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2256224742846356`, 1.3910220696073383`}, {
        1.1810997737605855`, 1.4471817206886097`}, {1.1318533310391634`, 
        1.5046284064573614`}, {1.0801035610609107`, 1.5605578330075598`}, {
        1.0250283974928056`, 1.6145344416158482`}, {0.9679068642694146, 
        1.6668977144518065`}, {0.95120398488836, 1.6810049544901093`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.9435642688880106, 1.6874574531870488`}, {
        0.9082078833359545, 1.7173194312622413`}, {0.8460237332762728, 
        1.7657013128361316`}, {0.7814466926742176, 1.8119450799624535`}, {
        0.7145690401136361, 1.8559524534301848`}, {0.6454830541783753, 
        1.8976251540283033`}, {0.615035633245718, 1.914404857646624}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6062775611370249, 1.9192314685630882`}, {
        0.5742810134522837, 1.9368649025457862`}, {0.5010551965192082, 
        1.9735734197716106`}, {0.4258456479139233, 2.0076011512854945`}, {
        0.3487114063708665, 2.0388171881977954`}, {0.26977324177337964`, 
        2.067151219593451}, {0.239321999067341, 2.0767380730964073`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.22978353806731178`, 2.0797410319291125`}, {
        0.1891519240048043, 2.092532934557398}, {0.10696822294848282`, 
        2.1148920221745744`}, {0.023342908487757375`, 
        2.1341581715299163`}, {-0.06160324949403034, 
        2.150261071708362}, {-0.14774948111353844`, 
        2.163130411794848}, {-0.1605286263385311, 2.1645181531232565`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17047017924566568`, 
        2.165597748322692}, {-0.23510946302628927`, 
        2.172617201029565}, {-0.323647982237309, 
        2.1786010595053367`}, {-0.4131709343875117, 
        2.1810545925860545`}, {-0.5034842151178114, 
        2.1799504056356085`}, {-0.5697597052361542, 2.17653177781233}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5797464281687555, 
        2.1760166418424594`}, {-0.594393720069122, 
        2.17526110401789}, {-0.6857053448823567, 
        2.166959293096789}, {-0.77722498519843, 
        2.155017578236197}, {-0.8687585366582558, 
        2.1394085648000045`}, {-0.9238970020613204, 
        2.128186431652593}, {-0.9748038544413787, 2.116523499662592}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.984518305003845, 
        2.1141538819017347`}, {-1.0338067447765296`, 
        2.1015954623126647`}, {-1.0885780220886738`, 
        2.0862266261201476`}, {-1.1432269033705111`, 
        2.0694755555792614`}, {-1.197753388622042, 
        2.051342250690007}, {-1.252157477843266, 
        2.0318267114523842`}, {-1.306439171034183, 
        2.010928937866392}, {-1.3604621295491208`, 
        1.9886471029699575`}, {-1.3634147640646663`, 
        1.9873440096989632`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3725634151902093`, 
        1.9833064135597858`}, {-1.4140900147424071`, 
        1.964979379801007}, {-1.4673228266140417`, 
        1.9399257683595401`}, {-1.5201605651640244`, 
        1.913486268645557}, {-1.5726032303923563`, 
        1.8856608806590582`}, {-1.6246508222990361`, 
        1.856449604400043}, {-1.6763033408840642`, 
        1.8258524398685112`}, {-1.725174859473526, 1.7953581311562983`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-1.7335669488943006`, 
        1.7899210826972387`}, {-1.7782831397293086`, 
        1.760525753432841}, {-1.8283303832698115`, 
        1.7258468464185857`}, {-1.877702516768949, 
        1.6898326660216971`}, {-1.9263995402267204`, 
        1.6524832122421753`}, {-1.9744214536431275`, 
        1.613798485080021}, {-2.0217682570181688`, 
        1.5737784845352334`}, {-2.051299676483258, 1.5476110186857972`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-2.0587841661227753`, 
        1.5409790947691682`}, {-2.0684399503518445`, 
        1.5324232106078128`}, {-2.1144365336441546`, 
        1.4897326632977592`}, {-2.155192561428974, 
        1.4518432200294389`}, {-2.195307882524382, 
        1.4129365737198567`}, {-2.234807042178689, 
        1.3730045845864645`}, {-2.273616404646967, 
        1.332071671976908}, {-2.311547713275963, 
        1.2864919643175234`}, {-2.3370386881432017`, 1.254454668027102}}]}, 
      {Arrowheads[{{0.0064206579243808225`, 1.}}], 
       ArrowBox[{{-2.343264935305781, 
        1.2466294621978298`}, {-2.3486316538636705`, 
        1.2398845199803632`}, {-2.3847917501640477`, 
        1.1922992407202326`}, {-2.420053494259109, 1.1437194926188634`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{-2.4430241610635117`, -2.044841800999949}, \
{-2.4104430890983592`, -2.1061146468366765`}, {-2.376412746194564, \
-2.166936044577026}, {-2.3409311659591037`, -2.227338998046736}, \
{-2.304004247571042, -2.287224495768588}, {-2.2610948646973754`, \
-2.3475708556553103`}, {-2.2333387950894106`, -2.3848208344683868`}}]}, 
      {Arrowheads[{{0.006821092744302866, 1.}}], 
       ArrowBox[{{-2.2273638180539623`, -2.3928395406873393`}, \
{-2.216653803342051, -2.407212894938906}, {-2.1707180076381913`, \
-2.466039419610322}, {-2.1429619356060385`, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0184081091662867`, -0.5067873791627169}, {
        1.0759191924708684`, -0.42509227429628504`}, {
        1.1271838568917605`, -0.33743822175845617`}, {
        1.1714694730002704`, -0.24413908630295406`}, {
        1.204727118262335, -0.15486110550109775`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2082039045868656`, -0.1454856256896159}, {
        1.236827818752079, -0.04269082252046425}, {1.2570615971948413`, 
        0.06403685755707506}, {1.2638259048826783`, 0.11862654650847065`}, {
        1.2682292821237293`, 0.1739498297280969}, {1.2702507739316728`, 
        0.22989828288002445`}, {1.2701280270155555`, 0.24807306785523997`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2700604916268332`, 0.25807283980120305`}, {
        1.2698694253201892`, 0.28636348162832626`}, {1.2670642813029585`, 
        0.343237001637073}, {1.2618143868936593`, 0.40041041857033527`}, {
        1.2540987871059723`, 0.4577753080921861}, {1.2438965269535767`, 
        0.5152232458666962}, {1.2298773706762682`, 0.5776234279538769}, {
        1.2127243746694811`, 0.6398814368110328}, {1.2088119188749304`, 
        0.6518486180829356}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2057044527647323`, 0.6613535459823975}, {
        1.1924654467939686`, 0.7018482103649564}, {1.169128494910485, 
        0.7633746865424406}, {1.142741426879784, 0.824311803270278}, {
        1.1133321505626186`, 0.8845104984752609}, {1.0809285738197432`, 
        0.943821710084182}, {1.0455586045119112`, 1.0020963760238348`}, {
        1.0330306354171268`, 1.020707506451819}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0274464893003394`, 1.0290031265097994`}, {
        1.0071432883411775`, 1.0591648804459457`}, {0.965642529976396, 
        1.1148650816022667`}, {0.9211425257285202, 1.1690591285696261`}, {
        0.8737294719085029, 1.2216091704248513`}, {0.8234895648272981, 
        1.2723773562447702`}, {0.7705090007958589, 1.3212258351062112`}, {
        0.76301525296278, 1.3275283282708201`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7553621012256132, 1.3339648854629764`}, {
        0.7148739761251386, 1.3680167560860017`}, {0.6566706871260901, 
        1.4126122682609699`}, {0.5958868935415962, 1.4548137568739183`}, {
        0.5325461502302017, 1.4944447031072954`}, {0.4667883461763527, 
        1.5314003999473969`}, {0.42244218546843815`, 
        1.5536766315396637`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4135062431827847, 1.5581653881010593`}, {
        0.3987533703644961, 1.5655761403805188`}, {0.3285811117790784, 
        1.5968672173929581`}, {0.2564114594045464, 1.6251689239710105`}, {
        0.18238430222534668`, 1.6503765531009726`}, {0.10663952922592544`, 
        1.6723853977691403`}, {0.036577283886393974`, 1.689227800456937}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.026829589397323553`, 
        1.6914504556223147`}, {-0.049713479558559016`, 
        1.7060250582452203`}, {-0.1300486916562981, 
        1.7174373888402237`}, {-0.21158248932588633`, 
        1.7251776798056089`}, {-0.2941344578934623, 
        1.7291956512406803`}, {-0.3705239868860921, 1.7294204253584164`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3805212427382143, 
        1.7293134518164013`}, {-0.4615712490271312, 
        1.725863515917101}, {-0.5460952422455015, 
        1.7184128493570592`}, {-0.6073669110617305, 
        1.71054669756839}, {-0.6687571905394636, 
        1.7005339505031911`}, {-0.7301910424513285, 
        1.6883733427783727`}, {-0.776376425445919, 1.6776099087104022`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7861154510414511, 
        1.6753402434378186`}, {-0.7915934285699527, 
        1.6740636090108452`}, {-0.8528893106679645, 
        1.657603483817519}, {-0.9140036505179907, 
        1.6389917018153042`}, {-0.9748614098926598, 
        1.618226997621111}, {-1.0353875505646002`, 
        1.5953081058518497`}, {-1.0955116787354866`, 
        1.5701927653120424`}, {-1.1551617117237043`, 
        1.5428536223743539`}, {-1.1616231235377632`, 
        1.5396237182905832`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1705678393983652`, 
        1.535152470346989}, {-1.214260077976946, 
        1.5133117730079049`}, {-1.2727292059429054`, 
        1.481588313181817}, {-1.330491524069274, 
        1.4477043388652124`}, {-1.387469460803745, 
        1.4116809460272124`}, {-1.4435854445940108`, 
        1.3735392306369387`}, {-1.4987619038877642`, 
        1.3333002886635132`}, {-1.5098782823539032`, 
        1.3246059302245987`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.517755194621837, 1.318445227900734}, {-1.552911542693924,
         1.2909486927231102`}, {-1.6059506011809626`, 
        1.2464822966511577`}, {-1.6578068120359046`, 
        1.1999421182456573`}, {-1.7084079079457735`, 
        1.1513691753046116`}, {-1.7576816215975934`, 
        1.1008044856260222`}, {-1.8055556856783883`, 
        1.0482890670078906`}, {-1.8085864321172536`, 1.044734301158277}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.8150743370121278`, 
        1.037124630332606}, {-1.8519578328751822`, 
        0.9938639372482194}, {-1.896815795874999, 
        0.9375701141450103}, {-1.9400655920040801`, 
        0.8793649966145819}, {-1.981640225992588, 
        0.8192363904393196}, {-2.0214629116334275`, 
        0.7572709237163249}, {-2.0480411929933386`, 0.7126992555620061}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.053162792347552, 
        0.7041103545813847}, {-2.059456862719505, 
        0.6935552245427}, {-2.0955452930437253`, 
        0.6281759210155471}, {-2.1296514163989935`, 
        0.5612196412319675}, {-2.161698446578216, 
        0.4927730132890638}, {-2.1916095973742973`, 
        0.42292266528393746`}, {-2.222571578513575, 0.3423385018646443}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.226067301162115, 
        0.33297106457213094`}, {-2.255550018792895, 
        0.24547848487758112`}, {-2.282270798158668, 
        0.15387751028273183`}, {-2.305491956628756, 
        0.06035727942676852}, {-2.325017914052913, -0.03480596835191291}, \
{-2.3280156480650516`, -0.0533136804495548}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.3296145320543222`, -0.06318503142036191}, \
{-2.3406530902808895`, -0.13133599371491653`}, {-2.3523974853126877`, \
-0.22923279666224225`}, {-2.3602510991483063`, -0.32849637719389}, \
{-2.3640610377600857`, -0.42881079620834495`}, {-2.3639370651265774`, \
-0.46121213440746434`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.363898803828446, -0.4712120612108497}, \
{-2.3636744071203655`, -0.5298601146040919}, {-2.359091207229146, \
-0.6316443323811308}, {-2.350311438086427, -0.7341634495394618}, \
{-2.3416166087327386`, -0.8164006916582516}, {-2.3342032938177177`, \
-0.8697623742984085}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.3328272513403485`, -0.8796672471951436}, \
{-2.330156251816281, -0.8988933330378628}, {-2.312614791789152, \
-0.983386542488778}, {-2.292094195414128, -1.0677568644121198`}, \
{-2.264581981304155, -1.1712605619128256`}, {-2.2347443487580243`, \
-1.2670894353087963`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.2316707946371857`, -1.2766036644713885`}, \
{-2.1959483552597128`, -1.3765463613489828`}, {-2.1759546992018324`, \
-1.427509145465261}, {-2.154826943325244, -1.4783284632844345`}, \
{-2.132566230022787, -1.5289064770021181`}, {-2.1091737016873005`, \
-1.5791453488139267`}, {-2.084649358318784, -1.6290450787198598`}, \
{-2.076463626336561, -1.6448576444165794`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.0718663762071476`, -1.6537382576413298`}, \
{-2.058993199917239, -1.678605666719918}, {-2.0322052264826636`, \
-1.7278271128141012`}, {-2.0042854380150597`, -1.7767094170024091`}, \
{-1.9752338345144254`, -1.825252579284842}, {-1.9450504159807618`, \
-1.8734565996613994`}, {-1.9137532796186734`, -1.9212222077079029`}, \
{-1.881360522632764, -1.968450133000173}, {-1.862800896455759, \
-1.9943263775205375`}}]}, 
      {Arrowheads[{{0.015330622926136378`, 1.}}], 
       ArrowBox[{{-1.856972598660174, -2.00245232022314}, \
{-1.8478721450230344`, -2.01514037553821}, {-1.8132881467894835`, \
-2.061292935322014}, {-1.7776085279321123`, -2.1069078123515848`}, \
{-1.7408332884509201`, -2.1519850066269215`}, {-1.7029624283459077`, \
-2.1965245181480255`}, {-1.6639959476170743`, -2.2405263469148964`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019446325424658885`, 1.}}], 
       ArrowBox[{{-1.5710748870367848`, -2.2389630246087853`}, \
{-1.531047294468045, -2.281835877098858}, {-1.4899345536022617`, \
-2.324084268513528}, {-1.447760695529135, -2.36563088539739}, \
{-1.4007129660924766`, -2.406347994896082}, {-1.3525732280068818`, \
-2.446199690014484}, {-1.3033919431219068`, -2.485105219299348}, \
{-1.2836924992271268`, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1157586894501688`, -1.2987569874677507`}, \
{-1.0728584922672275`, -1.351329990030476}, {-1.0276508074725494`, \
-1.402602995238057}, {-0.9801147542111261, -1.4524574332995595`}, \
{-0.9302504855706829, -1.5007816587180534`}, {-0.8781265149528307, \
-1.5474865299521239`}, {-0.8354050624917712, -1.5828783164392308`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8277043165942344, -1.5892578550292522`}, \
{-0.8238113557591806, -1.5924829054603553`}, {-0.7673735213913431, \
-1.6356816437013335`}, {-0.7088815252509286, -1.6769936031336432`}, \
{-0.6484038807395481, -1.7163296422158696`}, {-0.5860091012588117, \
-1.7536006194065983`}, {-0.5217050443668458, -1.7886766904712736`}, \
{-0.491064953830502, -1.8038460022682559`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.48210311641083603`, -1.8082828333517518`}, \
{-0.45552162429213544`, -1.821442812154664}, {-0.3875604394418276, \
-1.8518320443843403`}, {-0.3179230882230699, -1.8797774470878732`}, \
{-0.24671116904301013`, -1.9052120801928338`}, {-0.1740262803087954, \
-1.9280690036267925`}, {-0.10741679715925005`, -1.9462488186209952`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09774834967437668, -1.9487974435904183`}, \
{-0.02464398780649371, -1.9657819611919871`}, {
        0.051884917014010434`, -1.9804492979724255`}, {
        0.12953717608742563`, -1.9921814639096995`}, {
        0.20819226489748852`, -2.0009414192255273`}, {
        0.28772965892793567`, -2.0066921241416296`}, {
        0.297331025374967, -2.007015490813965}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3073253587410286, -2.0073520923113275`}, {
        0.3680288336625037, -2.009396538879725}, {
        0.44896926458492925`, -2.009017623661533}, {
        0.5304304271789486, -2.0055183387087725`}, {
        0.6122917969282988, -1.9988616442431633`}, {
        0.6945340167900809, -1.988917001278761}, {
        0.7061946924909228, -1.9870345686781201`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7160668802157693, -1.9854408593177308`}, {
        0.7771009415492629, -1.9755878705414993`}, {
        0.8598168644313833, -1.9588882118209137`}, {
        0.9425060786619794, -1.9388319849065396`}, {
        1.0249928774665893`, -1.915433149587913}, {
        1.1038814015487506`, -1.8897538688208397`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1133074310664073`, -1.886419620934467}, {
        1.1886564017000014`, -1.8586634928960455`}, {
        1.269481713579879, -1.8253205911018753`}, {
        1.3649634476623471`, -1.7810436508034948`}, {
        1.4589249922937526`, -1.7319761480086175`}, {
        1.4770859608858629`, -1.7213952274857598`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.485726436005152, -1.7163611248136894`}, {
        1.5513663474740953`, -1.6781180827172435`}, {
        1.6422875132033758`, -1.6194694549293736`}, {
        1.6870607333261327`, -1.5883727987457472`}, {
        1.7312193226906545`, -1.556126739230986}, {
        1.7747632812969407`, -1.52273127638509}, {
        1.8150955695849567`, -1.4902762259250777`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.8227883098636344`, -1.4838879671777785`}, {
        1.8600073062348075`, -1.4524921406998945`}, {
        1.9017073725663884`, -1.415648467860595}, {
        1.9427928081397334`, -1.3776553916901606`}, {
        1.9832636129548433`, -1.3385129121885915`}, {
        2.02300428193529, -1.2982682799734873`}, {
        2.0618993100046454`, -1.2569687456624474`}, {
        2.0999486971629095`, -1.2146143092554713`}, {
        2.108521456257213, -1.2046116122432906`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.1150289406149954`, -1.19701867820346}, {
        2.1371524434100824`, -1.1712049707525596`}, {
        2.173510548746164, -1.1267407301537118`}, {
        2.209023013171154, -1.0812215874589284`}, {
        2.243689836685053, -1.034647542668209}, {
        2.2775110192878607`, -0.9870185957815538}, {
        2.327440473856665, -0.9150263623818344}, {
        2.3527453660129147`, -0.8757220148797549}}]}, 
      {Arrowheads[{{0.0107802564769792, 1.}}], 
       ArrowBox[{{2.358158664139325, -0.8673139114435093}, {
        2.375223925555277, -0.8408076153184432}, {
        2.419358000171919, -0.7603789313246376}, {
        2.46086042381678, -0.6778929401290636}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.590233331341948, 1.116707293350296}, {0.5440711940330103, 
        1.1523319494581412`}, {0.49591512880009897`, 1.1861412562360063`}, {
        0.44585422963022264`, 1.2180444124812657`}, {0.3939775905103896, 
        1.247950616991294}, {0.3403743054276093, 1.2757690685634642`}, {
        0.28513346836889164`, 1.3014089659951507`}, {0.2457224119915884, 
        1.3168155623031015`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2364087720642189, 1.320456456603038}, {0.1862767543182927,
         1.3400540982424867`}, {0.08307398357211947, 1.3713268526864173`}, {
        0.03003451235916329, 1.3840962589009362`}, {-0.02386145052252265, 
        1.3948997754672015`}, {-0.07853723090454949, 
        1.403696470652745}, {-0.1339161546185282, 
        1.4104454127250994`}, {-0.15150264392482504`, 1.4118940572571679`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.16146888939123372`, 
        1.4127150026288513`}, {-0.18994766344847125`, 
        1.415060872779482}, {-0.24657170246842736`, 
        1.4174734117919507`}, {-0.30369735244506235`, 
        1.4176665328513025`}, {-0.36123369414504175`, 
        1.415623739046332}, {-0.419089808335033, 
        1.4113285334658348`}, {-0.47717477578170236`, 
        1.404764419198606}, {-0.5353976772517169, 
        1.3959148993334418`}, {-0.5596467833599197, 1.3912742195149705`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5694685421647088, 
        1.389394577532957}, {-0.5936675935117427, 
        1.3847634769591368`}, {-0.651905581964305, 
        1.3712401366176608`}, {-0.7100283448716171, 
        1.3552943241407378`}, {-0.767938430289877, 
        1.3369387345517958`}, {-0.8255383862752824, 
        1.3161860628742628`}, {-0.8827307608840316, 
        1.2930490041315663`}, {-0.9394181021723225, 
        1.267540253347135}, {-0.9479010975008977, 1.2633251765654943`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9568564984663602, 
        1.2588753683058282`}, {-0.9955029581963529, 
        1.2396725055443962`}, {-1.0508878770123211`, 
        1.2094584557467782`}, {-1.1054698767668143`, 
        1.1768519408579656`}, {-1.1591479864826422`, 
        1.1418282007342775`}, {-1.2118277705303355`, 
        1.1044320348280925`}, {-1.2634147932804254`, 
        1.064708242591789}, {-1.2913525375418884`, 1.0414230394599788`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2990342432758462`, 
        1.0350205870379081`}, {-1.313814619103443, 
        1.022701623477746}, {-1.362932812369919, 
        0.9784569769383421}, {-1.4106749374503844`, 
        0.9320191024259562}, {-1.4569465587153705`, 
        0.8834327993929668}, {-1.5011674882220853`, 
        0.8332346312379151}, {-1.5437273991565774`, 
        0.7809324690304578}, {-1.5717339081625856`, 0.7436538626848366}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.57774043346606, 
        0.7356587608231514}, {-1.5845471137370724`, 
        0.7265985971915778}, {-1.6235474541817954`, 
        0.6703053001422565}, {-1.6606492427089714`, 
        0.612124862303477}, {-1.6957733015368253`, 
        0.5521295680962217}, {-1.7288404528835828`, 
        0.49039170194147247`}, {-1.7597715189674685`, 
        0.42698354826021184`}, {-1.7763362015007584`, 
        0.3893975484266951}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7803690620721964`, 
        0.380246808805695}, {-1.7884443678725621`, 
        0.361923581550469}, {-1.8147524873680865`, 
        0.29524984355498346`}, {-1.8386401291999832`, 
        0.2270639695618027}, {-1.8600515451141928`, 
        0.15746759485897469`}, {-1.8789309868566562`, 
        0.08656235473454711}, {-1.895222706173315, 
        0.014449884476567788`}, {-1.8981417990885676`, \
-0.0012100247762499364`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8999742889865192`, -0.011040690103373286`}, \
{-1.9088709548101095`, -0.05876818062691504}, {-1.919819984512981, \
-0.13299020528785466`}, {-1.9279597318089314`, -0.20814319616407861`}, \
{-1.9331998842136677`, -0.2841437446603692}, {-1.9355143199561888`, \
-0.36087459260911003`}, {-1.9351196984764065`, -0.4087588586578548}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.935037289762155, -0.4187585190922803}, \
{-1.934876917265493, -0.4382184818426845}, {-1.9312615543705791`, \
-0.5160581541934764}, {-1.924642109500446, -0.5942763514938697}, \
{-1.9149924608840923`, -0.6727558155762474}, {-1.9022864867505167`, \
-0.7513792882729936}, {-1.8893536687477337`, -0.8154918642785607}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.8873762938797127`, -0.8252944143871457}, \
{-1.8864033409561896`, -0.8301176878798832}, {-1.8672566225839549`, \
-0.9089098685241854}, {-1.844871877702372, -0.9875904757855247}, \
{-1.8192746523800016`, -1.0659941552435255`}, {-1.7904904926854028`, \
-1.1439555524778127`}, {-1.7650649022066096`, -1.2055217224764507`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.7612478026992089`, -1.2147645440884154`}, \
{-1.7585449446871353`, -1.2213093130680108`}, {-1.723463554453759, \
-1.2978900825937443`}, {-1.685271868053834, -1.3735325066346376`}, \
{-1.6361828261843436`, -1.4613347908201704`}, {-1.5827364658432084`, \
-1.5473903891416796`}, {-1.5702659524845914`, -1.5655791176213472`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.564611211030251, -1.5738267778401343`}, \
{-1.5249327870304294`, -1.631699301599166}, {-1.4627717897460057`, \
-1.7142615281926292`}, {-1.3963721114209777`, -1.7946561836505752`}, \
{-1.3258523894863847`, -1.872462382701509}, {-1.313732671494635, \
-1.8846759503912551`}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.3066889280799876`, -1.8917742374176167`}, \
{-1.2512126239422265`, -1.947680125345431}, {-1.1724528147885034`, \
-2.020309411582341}, {-1.1315780016313726`, -2.0555511891973244`}, \
{-1.0897733931184852`, -2.0899414640088714`}, {-1.0470389892498415`, \
-2.123480236016981}, {-1.0056686389330485`, -2.154450316813538}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9975680696140309, -2.160312937724738}, \
{-0.9587807954452852, -2.188003271622889}, {-0.9132570055093725, \
-2.218987535220688}, {-0.8668034202177034, -2.24912029601505}, \
{-0.8194200395702781, -2.278401554005975}, {-0.751582506025026, \
-2.319311832593269}, {-0.6819971413679345, -2.358308274177863}, \
{-0.657440783898358, -2.370046573521433}}]}, 
      {Arrowheads[{{0.006416668167683784, 1.}}], 
       ArrowBox[{{-0.6484185773121611, -2.374359320710405}, \
{-0.6075405183771753, -2.3938996329475692`}, {-0.5314939573396571, \
-2.427217591490897}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{2.163584822582592, -2.5}, {
        2.215405182751581, -2.471559170594909}, {
        2.2773454582091284`, -2.435870988564526}, {
        2.338776102229582, -2.3987202289154466`}, {
        2.400698781224708, -2.3555617496962653`}, {
        2.4619270063016034`, -2.3108543397862635`}, {
        2.4987165330384586`, -2.282711985939136}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.0250290075413586`, -1.386237025932758}, {
        1.086836676756269, -1.3555045924695788`}, {
        1.147871066219764, -1.322132671798602}, {
        1.2080229877988455`, -1.2861491139987058`}, {
        1.2671832533605156`, -1.2475817691487694`}, {
        1.325242674771775, -1.2064584873276716`}, {
        1.3645177696526718`, -1.1762500415288804`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3724443182932387`, -1.1701533353157907`}, {
        1.3820782681037307`, -1.1627433812071863`}, {
        1.437572066080541, -1.1164237406980348`}, {
        1.4916224055487872`, -1.0675621817375172`}, {
        1.544127623355051, -1.016221320262931}, {
        1.594986056345913, -0.9624637722115769}, {
        1.6440960413679544`, -0.9063521535207535}, {
        1.6571134039208513`, -0.8902654838404263}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6634038740268915`, -0.8824918112305838}, {
        1.6913559152677573`, -0.8479490801277595}, {
        1.736664014891902, -0.7873171679698943}, {
        1.7798817059897387`, -0.7244497402400704}, {
        1.820883798345975, -0.6593653174927938}, {
        1.8595887948602272`, -0.5921643117077576}, {
        1.8824111038195512`, -0.5486781517833507}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8870581777451747`, -0.5398235087115046}, {
        1.8959151984321105`, -0.5229471348646543}, {
        1.9297815119612423`, -0.4518141989431748}, {
        1.9611062383472382`, -0.378865915923012}, {
        1.9898078804897141`, -0.3042026977838585}, {
        2.015804941288287, -0.2279249565054053}, {
        2.033539091573298, -0.1683153630544642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.036390623058706, -0.1587305433802227}, {
        2.0389611047575493`, -0.15009041309043633`}, {
        2.0591599890521013`, -0.07077231253333757}, {2.076349998281574, 
        0.009905647198794125}, {2.090479536555595, 0.09181976813886111}, {
        2.1014970079837934`, 0.17484635231976656`}, {2.107059984932449, 
        0.23435575351325816`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.1079907334512793`, 0.24431234465655088`}, {
        2.109350816675798, 0.25886170177441364`}, {2.113989366741239, 
        0.3437421185357047}, {2.1153610622897436`, 0.4293639046365429}, {
        2.1133241529620412`, 0.5157209999614283}, {2.107769671842096, 
        0.6027645669942797}, {2.1035273149906457`, 0.6436909236449984}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.1024962565022873`, 0.6536376275409422}, {
        2.098695198204392, 0.6903067416671298}, {2.086098311323413, 
        0.7781596599120093}, {2.0699765904736442`, 0.8661354576609507}, {
        2.050327614929569, 0.9540462708459857}, {2.0271489639656717`, 
        1.0417042353991457`}, {2.02592153036865, 1.04571211225586}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.022993226086215, 1.0552737561537193`}, {2.000438216856436,
         1.1289214872524629`}, {1.9825748129835725`, 1.1812978347168277`}, {
        1.9633934807279065`, 1.2333860474029534`}, {1.9428942200894386`, 
        1.2851861253108408`}, {1.921077031068168, 1.336698068440489}, {
        1.8979419136640958`, 1.387921876791899}, {1.8787811395605527`, 
        1.4278337529505396`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.8744532646643937`, 1.4368487126777485`}, {
        1.8734888678772206`, 1.4388575503650696`}, {1.8477178937075436`, 
        1.4895050891600017`}, {1.8206289911550642`, 1.539864493176695}, {
        1.792236871597378, 1.5898055367553618`}, {1.7625562464120805`, 
        1.6391979942362145`}, {1.7315871155991722`, 1.6880418656192526`}, {
        1.6993294791586524`, 1.736337150904477}, {1.6689882995338021`, 
        1.7795221816480025`}}]}, 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{1.6631556398590366`, 1.7876441660215932`}, {
        1.6309486893947789`, 1.8312819631814827`}, {1.5948255360714254`, 
        1.8779314901732642`}, {1.5574138771204606`, 1.9240324310672317`}, {
        1.5187543574321842`, 1.9694542715196903`}, {1.4788876218968956`, 
        2.014066497186945}, {1.4378136705145945`, 2.057869108068997}, {
        1.4042494100247658`, 2.0919984430612524`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.397237612474079, 2.0991282884388314`}, {
        1.3955325032852812`, 2.100862104165845}, {1.3520441202089561`, 
        2.14304548547749}, {1.3073485212856182`, 2.184419252003931}, {
        1.2614457065152682`, 2.2249834037451692`}, {1.2143356758979063`, 
        2.264737940701204}, {1.138010604139863, 2.3276836942516512`}, {
        1.0948995705242555`, 2.3606050791168873`}}]}, 
      {Arrowheads[{{0.012242891089517541`, 1.}}], 
       ArrowBox[{{1.0869519130084482`, 2.3666742421573264`}, {
        1.0587328693509175`, 2.388223481849927}, {0.9712250066777357, 
        2.4449900255925154`}, {0.880928475195002, 2.498663202063696}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.01627850610150782, 1.}}], 
       ArrowBox[{{1.780147885761933, 2.2640882282906345`}, {
        1.7397943227504709`, 2.3123434677046935`}, {1.6982197169317073`, 
        2.3599831169700094`}, {1.6554459776350743`, 2.4069197958438}, {
        1.607265043441111, 2.4532672812037717`}, {1.55783907842309, 
        2.498730203213594}, {1.5563941937603583`, 2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.4920920618923503`, 1.578933636002447}, {
        2.4706645053973837`, 1.6363729912984055`}, {2.4479763038621476`, 
        1.6935961683240297`}, {2.4240293280532317`, 1.7506296704851083`}, {
        2.398817965670865, 1.8073939875642753`}, {2.368735358623721, 
        1.865124115852994}, {2.337304322195692, 1.9224477294017965`}, {
        2.325968034470024, 1.9421099177344285`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.3209732175328153`, 1.950773162147682}, {2.304541342871922,
         1.9792733750973899`}, {2.270440925157364, 2.035631537310872}, {
        2.234762631760958, 2.094490796698635}, {2.19765419008175, 
        2.152699767193571}, {2.159115600119738, 2.2102584487956793`}, {
        2.1191468618749223`, 2.2671668415049604`}, {2.1045905006142593`, 
        2.286947887607393}}]}, 
      {Arrowheads[{{0.012350614826359735`, 1.}}], 
       ArrowBox[{{2.098663564019866, 2.2950021673769343`}, {
        2.0777479753473043`, 2.3234249453214155`}, {2.034918940536883, 
        2.3790327602450434`}, {1.9906597574436582`, 2.433990286275843}, {
        1.9449704260676304`, 2.4882975234138165`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2199832209368062`, -2.481154255856171}, {
        1.2832420794870314`, -2.4635307570556098`}, {
        1.3462556215892196`, -2.4443485107062624`}, {
        1.4090238472433716`, -2.423607516808128}, {
        1.4715467564494868`, -2.4013077753612064`}, {
        1.5338243492075658`, -2.3774492863654992`}, {
        1.595856625517608, -2.3520320498210046`}, {
        1.5979166174464694`, -2.3511326640990116`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6070812280234499`, -2.347131425169343}, {
        1.6576435853796139`, -2.3250560657277233`}, {
        1.7191852287935827`, -2.2965213340856554`}, {
        1.7803299814450055`, -2.266436216421469}, {
        1.840926269019372, -2.234809074261832}, {
        1.9009740915166824`, -2.2016399076067446`}, {
        1.9604734489369364`, -2.1669287164562068`}, {
        1.9630380107318763`, -2.1653515798244465`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.971556157968746, -2.160113148031342}, {
        2.0194243412801343`, -2.1306755008102187`}, {
        2.077826768546276, -2.09288026066878}, {
        2.135680730735361, -2.0535429960318914`}, {
        2.19298622784739, -2.0126637068995517`}, {
        2.246582001937316, -1.9744104612470812`}, {
        2.299563570413034, -1.9348295843118508`}, {
        2.30106558742602, -1.9336567700300915`}}]}, 
      {Arrowheads[{{0.012724483589402416`, 1.}}], 
       ArrowBox[{{2.3089474513132786`, -1.927502403965034}, {
        2.3519627110124857`, -1.8939149608983747`}, {
        2.4036840905218453`, -1.851684936593112}, {
        2.45511444233224, -1.8036442674170963`}, {
        2.5, -1.7597719195081778`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3012172369354242`, 1.10687774929806}, {
        1.2669103548234468`, 1.1655111349775642`}, {1.2300804399285483`, 
        1.2232155189853609`}, {1.190761524513057, 1.2798869353688656`}, {
        1.1489876408393018`, 1.335421418175495}, {1.1047928211696112`, 
        1.3897150014526651`}, {1.0683403505535751`, 1.431082679207209}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.0617290733950053`, 1.4385854129978066`}, {
        1.0581506142693033`, 1.4426463872326976`}, {1.0090565629026096`, 
        1.4941005800988574`}, {0.9575776903302278, 1.5439830679249762`}, {
        0.9037810198128557, 1.5921993385848847`}, {0.8477335746111917, 
        1.6386548799524145`}, {0.7895023779859335, 1.6832551799013968`}, {
        0.7622273553650217, 1.7025316442049208`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7540609940170662, 1.7083031728009357`}, {
        0.7291544531977792, 1.725905726305663}, {0.6667568235074267, 
        1.766512007039044}, {0.6023122106437019, 1.8049397965846248`}, {
        0.5358467187106565, 1.8410693106584881`}, {0.4674624445318283, 
        1.874827698983964}, {0.4052614685768344, 1.9025735733653337`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.39611016695251666`, 1.9066031406350583`}, {
        0.325345936730972, 1.9349396972830701`}, {0.25181789675601884`, 
        1.9611476067033597`}, {0.1767794618294323, 1.9846929892685798`}, {
        0.10033272877474907`, 2.0055029947020597`}, {0.022541898761888654`, 
        2.023449484093373}, {0.014676168949400886`, 2.0249394079250034`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.004850880331669907, 
        2.026800510710528}, {-0.05651504680155148, 
        2.0384244234898237`}, {-0.13671534073551447`, 
        2.050385120051335}, {-0.21793621585994372`, 
        2.05928888093783}, {-0.30005490499478216`, 
        2.065093013309232}, {-0.38294864095997244`, 
        2.0677548243254646`}, {-0.39243659673590053`, 2.0676954064275823`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4024364006499432, 
        2.067632783103672}, {-0.46649465657545824`, 
        2.0672316211464516`}, {-0.5505701846611825, 
        2.063480710932116}, {-0.6351605675573233, 
        2.056366313764348}, {-0.7202118350512464, 
        2.0457864995715953`}, {-0.8003206715549505, 2.032608318227648}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8101548517429319, 
        2.0308051873349147`}, {-0.8909700797953345, 
        2.014262947830174}, {-0.9763135850269479, 
        1.9933353741410256`}, {-1.0613910308192394`, 
        1.9689747111459315`}, {-1.1460206811629328`, 
        1.941189040774652}, {-1.194828672760761, 1.923058875547492}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2042028325329754`, 
        1.9195767600173868`}, {-1.2300208000487531`, 
        1.9099864449569466`}, {-1.2801158707487543`, 
        1.8895762692745541`}, {-1.3298602625452325`, 
        1.867910978587504}, {-1.379253975438187, 
        1.8449905728957954`}, {-1.4282970094276184`, 
        1.820815052199429}, {-1.4769893645135264`, 
        1.7953844164984043`}, {-1.525331040695911, 
        1.7686986657927213`}, {-1.5640692364413908`, 
        1.7461448789044027`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5727112454671879`, 
        1.741113409934207}, {-1.5733220379747728`, 
        1.7407578000823811`}, {-1.620962356350111, 
        1.7115618193673823`}, {-1.6681286484487656`, 
        1.6811317248664448`}, {-1.7146975668975755`, 
        1.6494885177982883`}, {-1.7606691116965414`, 
        1.616632198162912}, {-1.806043282845663, 
        1.5825627659603163`}, {-1.8508200803449397`, 
        1.547280221190501}, {-1.894999504194373, 
        1.510784563853467}, {-1.89759117724983, 1.508542154364521}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.9051534192029043`, 
        1.501999028456886}, {-1.9385815543939613`, 
        1.473075793949213}, {-1.9815662309437054`, 
        1.4341539114777397`}, {-2.023831253726745, 
        1.3940643342958154`}, {-2.0652543426262184`, 
        1.3528524802602082`}, {-2.105835497642126, 
        1.3105183493709176`}, {-2.1455747187744683`, 
        1.267061941627944}, {-2.1844720060232445`, 
        1.2224832570312878`}, {-2.1873064086238836`, 
        1.2190794015278734`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.193705396056377, 
        1.2113948091614044`}, {-2.222527359388456, 
        1.1767822955809484`}, {-2.259740778870101, 
        1.1299590572769262`}, {-2.2961122644681806`, 
        1.0820135421192207`}, {-2.351108956758073, 
        1.0078086182151684`}, {-2.403850481131214, 
        0.9311116933250648}, {-2.4288871232843006`, 0.8883827740129644}}]}, 
      {Arrowheads[{{0.006750075349843567, 1.}}], 
       ArrowBox[{{-2.433942613237696, 
        0.8797547950299628}, {-2.452857482417045, 
        0.8474736323236576}, {-2.4990542374767566`, 0.7615138665784038}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.018848246097497655`, 1.}}], 
       ArrowBox[{{-2.184840558412888, 2.5}, {-2.2079206355386907`, 
        2.487476726964421}, {-2.2700298971192145`, 
        2.4520910329240366`}, {-2.331637754455099, 
        2.415243513692862}, {-2.3937611947702946`, 
        2.37240831450241}, {-2.4551997819590965`, 2.328024668122555}, {-2.5, 
        2.294117978872983}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9065805888456094, -1.83885784758262}, \
{-0.8515127115686021, -1.879730314313156}, {-0.7947286092296787, \
-1.9190169687017076`}, {-0.7362863173757067, -1.9566614121565407`}, \
{-0.6762438715535545, -1.9926072460859208`}, {-0.6146593073100892, \
-2.0267980718981153`}, {-0.5680122597608632, -2.0507466481170242`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.559116177870114, -2.055313893128307}, \
{-0.5515906601921776, -2.05917749100139}, {-0.4870959657466883, \
-2.0896891048040107`}, {-0.4212332595204879, -2.1182765147142435`}, \
{-0.3540415991998354, -2.1448593653313655`}, {-0.2855669435112114, \
-2.1693660128215595`}, {-0.21587767956181467`, -2.1917531259434493`}, \
{-0.18682881693956566`, -2.2000468700572435`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17721305903902465`, -2.202792266203191}, \
{-0.14504219445884503`, -2.2119773734556576`}, {-0.07312887530950225, \
-2.2299954241168094`}, {-0.00020610922098569882`, -2.245763946685529}, {
        0.07365771669950491, -2.259239609920438}, {
        0.14839421534477007`, -2.2703790825801624`}, {
        0.2151336799242295, -2.277830381669521}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.22507193071433396`, -2.278939963227131}, {
        0.23971162356846606`, -2.280574449369923}, {
        0.3322673265292539, -2.2871248118325065`}, {
        0.425860020895385, -2.2900008333654682`}, {
        0.5202884033351107, -2.2891731773663655`}, {
        0.6153511705166818, -2.284612507232754}, {
        0.6245574257801849, -2.283810128324897}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6345196600976171, -2.282941861427809}, {
        0.7108470191083489, -2.2762894863621903`}, {
        0.8065746457783636, -2.264174778152231}, {
        0.9023327471949769, -2.2482390460004313`}, {
        0.959925734759786, -2.236764867478752}, {
        1.0173982380363227`, -2.2238551908475586`}, {
        1.0292216669133885`, -2.2208978554953274`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.0389228064806024`, -2.2184713577934043`}, {
        1.0747502570245868`, -2.2095100161068517`}, {
        1.1319817917245785`, -2.19372934325663}, {
        1.189092842136298, -2.176513172296896}, {
        1.2460834082597452`, -2.157861503227647}, {
        1.3029534900949196`, -2.1377743360488846`}, {
        1.3597030876418215`, -2.116251670760608}, {
        1.4161914175951162`, -2.0932909074972654`}, {
        1.4181200378281535`, -2.0924518225660798`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4272897742788646`, -2.0884623447275024`}, {
        1.472277696649469, -2.068889446393304}, {
        1.5279619248048797`, -2.0430472874487235`}, {
        1.5832441020613488`, -2.0157644306635247`}, {
        1.6381242284188755`, -1.9870408760377065`}, {
        1.69260230387746, -1.9568766235712698`}, {
        1.7466783284371021`, -1.9252716732642137`}, {
        1.7816374765059757`, -1.903748249007807}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.7901529611148221`, -1.898505490013108}, {
        1.8003523020978027`, -1.8922260251165393`}, {
        1.853479508052472, -1.8577649236109885`}, {
        1.905915229494021, -1.8219136132303044`}, {
        1.9576594664224496`, -1.7846720939744871`}, {
        2.0087122188377573`, -1.746040365843536}, {
        2.0590734867399454`, -1.7060184288374516`}, {
        2.1087432701290125`, -1.664606282956234}, {
        2.1120613963145733`, -1.6617065576211334`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.119591249867652, -1.655126184875674}, {
        2.1577215690049596`, -1.6218039281998828`}, {
        2.206008383367786, -1.5776113645683982`}, {
        2.2485710627592055`, -1.5385886666284443`}, {
        2.290483185916556, -1.4985168276626997`}, {
        2.331769748521188, -1.4573877400130713`}, {
        2.3723557635290473`, -1.4152257266538382`}, {
        2.405544837232568, -1.3760095126631486`}}]}, 
      {Arrowheads[{{0.007128332313076867, 1.}}], 
       ArrowBox[{{2.41200495420781, -1.368376237568788}, {
        2.412063170893118, -1.3683074487255302`}, {
        2.4509109725822524`, -1.3203285983509758`}, {
        2.4888212168793267`, -1.2713390099061095`}, {
        2.5, -1.2562268858833323`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.012672718726592267`, 1.}}], 
       ArrowBox[{{-0.47265408473015547`, -2.387718125255608}, \
{-0.4150877735253208, -2.4115720757583334`}, {-0.3566336091371818, \
-2.434100695406883}, {-0.29573850518112094`, -2.454099124419209}, \
{-0.23405875921866198`, -2.472623454161556}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.365886243396122, 
        2.485220930569832}, {-1.4200207415608026`, 
        2.4687554270684062`}, {-1.4740334841311096`, 
        2.4511631548535435`}, {-1.5279468778843366`, 
        2.4324470633573956`}, {-1.581693702488602, 
        2.4125983042835086`}, {-1.6364993910533778`, 
        2.388543779068006}, {-1.691027777962068, 
        2.363281191153415}, {-1.7380196800064236`, 2.3403268820599896`}}]}, 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{-1.7469867958041467`, 
        2.335901470906833}, {-1.7990452581519063`, 
        2.309154254632514}, {-1.8569565419568397`, 
        2.279320187043721}, {-1.91435639915761, 
        2.2481122780247897`}, {-1.9712448297542182`, 
        2.2155305275757207`}, {-2.027621833746663, 
        2.181574935696513}, {-2.083487411134946, 
        2.1462455023871683`}, {-2.09475734452487, 2.138772829504528}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.1030916844248417`, 
        2.1332466392769174`}, {-2.1388415619190657`, 
        2.1095422276476845`}, {-2.193684286099023, 
        2.0714651114780636`}, {-2.2480155836748175`, 
        2.032014153878304}, {-2.3017073623912254`, 
        1.9912215158723925`}, {-2.354631529993023, 
        1.9491193584843147`}, {-2.4067880864802107`, 
        1.9057076817140703`}, {-2.4220854190191963`, 1.892395188061502}}]}, 
      {Arrowheads[{{0.0018922328009902348`, 1.}}], 
       ArrowBox[{{-2.4344763151378923`, 
        1.865204929493287}, {-2.453329635016154, 1.865204929493287}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.33230646789875, -1.3196195467023213`}, \
{-2.3114731438475813`, -1.3804919356588132`}, {-2.2891128344028346`, \
-1.4410308206600098`}, {-2.2652255395645082`, -1.5012362017059109`}, \
{-2.239811259332603, -1.5611080787965168`}, {-2.2128699937071183`, \
-1.6206464519318273`}, {-2.1844017426880553`, -1.6798513211118422`}, \
{-2.1797405652197592`, -1.6889997697967691`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-2.1752008071024718`, -1.6979099098762809`}, \
{-2.1544065062754134`, -1.7387226863365624`}, {-2.122884284469192, \
-1.7972605476059869`}, {-2.089852500379042, -1.8553138860311842`}, \
{-2.055328577114612, -1.9127316827232226`}, {-2.0193125146759026`, \
-1.9695139376821023`}, {-1.9818043130629135`, -2.025660650907822}, \
{-1.9707926853404785`, -2.041334061513298}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.965043971201045, -2.049516499153945}, \
{-1.9428039722756458`, -2.0811718224003837`}, {-1.9023114923140978`, \
-2.1360474521597856`}, {-1.8603268731782707`, -2.1902875401860293`}, \
{-1.8168501148681642`, -2.2438920864791134`}, {-1.7773192679259577`, \
-2.292575291703386}, {-1.7365849606255306`, -2.3406084533889575`}, \
{-1.7168303624090997`, -2.362937649657312}}]}, 
      {Arrowheads[{{0.009125637219821469, 1.}}], 
       ArrowBox[{{-1.7102042759193603`, -2.370427307715628}, \
{-1.694639759609222, -2.388020332676369}, {-1.6515059649500132`, \
-2.4347246461439966`}, {-1.6030086427241341`, -2.480797449529346}, \
{-1.581875152749646, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.5, -1.6768799768963647`}, {-2.499162763063407, \
-1.6790798052967792`}, {-2.475734356291559, -1.7370499542572142`}, \
{-2.4510289993875936`, -1.7948190488411075`}, {-2.425041528876308, \
-1.8523063337948753`}, {-2.3941014814309276`, -1.910741232045118}, \
{-2.361794946511577, -1.9687543550679611`}, {-2.3281392678296435`, \
-2.026252977052514}, {-2.322877450318791, -2.0348218861634613`}}]}, 
      {Arrowheads[{{0.016396876652131742`, 1.}}], 
       ArrowBox[{{-2.3176446707436877`, -2.0433435067791885`}, \
{-2.293128664147998, -2.0832680066024065`}, {-2.256489449864597, \
-2.142827673256714}, {-2.2184016648101, -2.201717177964402}, \
{-2.1788653089845083`, -2.259936520725471}, {-2.137880382387821, \
-2.317485701539921}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.010545859618369489`, 1.}}], 
       ArrowBox[{{-2.3564436459850793`, 
        1.566414280686268}, {-2.3991992849522426`, 
        1.5244356885371335`}, {-2.4412463110806577`, 
        1.4813956576899936`}, {-2.4824236906912693`, 
        1.4334967895747301`}, {-2.5, 1.4121348601908734`}}]}}}}, 
   {RGBColor[0, 0, 1], PointSize[Large], PointBox[{0, -1}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], PointBox[{0, 0}]}, 
   {RGBColor[0.5, 0, 0.5], Arrowheads[Medium], 
    ArrowBox[NCache[{{
       Rational[5, 2] 26^Rational[-1, 2], -1 + 
        Rational[-1, 2] 26^Rational[-1, 2]}, {
       Rational[5, 2] 26^Rational[-1, 2] + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])), -1 + 
        Rational[-1, 2] 26^Rational[-1, 2] + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])}}, {{
      0.4902903378454601, -1.098058067569092}, {
      1.0767345218447664`, -0.9653469043689533}}]]}, 
   {RGBColor[0.5, 0, 0.5], Arrowheads[Small], 
    ArrowBox[NCache[{{
       0, -1}, {-(Rational[-5, 2] 26^Rational[-1, 2] + 
         5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) (
         Rational[-1, 26] - (
          Rational[-1, 2] 
           26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
          Rational[5, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))/((1 - 6 
           Rational[2, 13]^Rational[1, 2])^2 + (
           Rational[-5, 2] 26^Rational[-1, 2] + 
           5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))^2)), -1 - (1 - 6 
         Rational[2, 13]^Rational[1, 2]) (
         Rational[-1, 26] - (
          Rational[-1, 2] 
           26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
          Rational[5, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))/((1 - 6 
           Rational[2, 13]^Rational[1, 2])^2 + (
           Rational[-5, 2] 26^Rational[-1, 2] + 
           5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))^2))}}, {{0, -1}, {
       0.21527369184098702`, -0.9512839877517834}}]]}},
  AspectRatio->1,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->NCache[{{
      Rational[-5, 2], 
      Rational[5, 2]}, {
      Rational[-5, 2], 
      Rational[5, 2]}}, {{-2.5, 2.5}, {-2.5, 2.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.904771826523209*^9, 3.904771835182572*^9}, 
   3.9047720331761703`*^9, 3.9047721712315693`*^9, {3.9047722551875668`*^9, 
   3.904772296336253*^9}, 3.904772375168778*^9, {3.904772409886797*^9, 
   3.904772432222204*^9}, {3.904772575058632*^9, 3.9047725927696733`*^9}, 
   3.904772629188171*^9, 3.904772888993167*^9, 3.904773282635253*^9, {
   3.904773882124393*^9, 3.904773906878688*^9}, 3.904773949412745*^9, {
   3.904773991736916*^9, 3.904774051881748*^9}, {3.90477416820077*^9, 
   3.9047742146675577`*^9}, {3.904774568580152*^9, 3.904774589902495*^9}, 
   3.904878349161237*^9, 3.904878974866106*^9, {3.904879369310996*^9, 
   3.904879390081087*^9}},
 CellLabel->
  "Out[165]=",ExpressionUUID->"e42cfa51-7337-4d83-99a1-11d9ff2adb18"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"z2", "=", 
   RowBox[{"z1", "-", 
    RowBox[{"\[Gamma]", " ", "Fz1"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fz2", "=", 
   RowBox[{"W", "@@", "z2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z3", "=", 
   RowBox[{"z2", "-", 
    RowBox[{"\[Gamma]", " ", "Fz2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fz3", "=", 
   RowBox[{"W", "@@", "z3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z4", "=", 
   RowBox[{"z3", "-", 
    RowBox[{"\[Gamma]", " ", "Fz3"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fz4", "=", 
   RowBox[{"W", "@@", "z4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zk", "=", "z4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fzk", "=", "Fz4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"\[Rho]", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Fzk", ".", 
       RowBox[{"(", 
        RowBox[{"zk", "-", "init"}], ")"}]}], ")"}], "/", 
     RowBox[{"Total", "[", 
      RowBox[{
       RowBox[{"(", "Fzk", ")"}], "^", "2"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904772678936633*^9, 3.904772701634253*^9}, {
  3.90477276188848*^9, 3.904772776473402*^9}, {3.904773306195157*^9, 
  3.904773342139002*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"707f8cee-2d6e-4b1e-92c3-5fe8b3babd27"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"iterates", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"init", ",", "z1", ",", "z2", ",", "z3", ",", "z4"}], "}"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legends", "=", 
   RowBox[{"{", "\"\<MDEG\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"iteratesReduces", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ArrayResample", "[", 
       RowBox[{"#", ",", "5"}], "]"}], "&"}], ",", "iterates"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"legend", "=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "legends", "]"}], "\[NotEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"ListLinePlot", "[", 
       RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
        RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"Placed", "[", 
          RowBox[{"legends", ",", "Below"}], "]"}]}]}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     StyleBox[
      RowBox[{"{", "}"}],
      FontWeight->"Plain"]}], 
    StyleBox["]",
     FontWeight->"Plain"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lines", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"iterates", ",", 
     RowBox[{"PlotLegends", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"markers", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"iteratesReduces", ",", "\[IndentingNewLine]", 
     RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.904773583500533*^9, 3.904773584249989*^9}, 
   3.9047737971481037`*^9, {3.90487931953603*^9, 3.904879320513234*^9}, {
   3.904879357082288*^9, 3.904879357578823*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"5e051480-cf29-4c31-b3e2-11d823554f47"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Fzk", ".", 
        RowBox[{"(", 
         RowBox[{"zk", "-", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], ")"}]}], ")"}], ">=", 
      RowBox[{"\[Rho]", " ", 
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{"(", "Fzk", ")"}], "^", "2"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"StreamPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"-", 
       RowBox[{"W", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "side"}], ",", "side"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)\>\"", ",", 
        "\"\<\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
     ",", 
     RowBox[{"ImageSize", "\[Rule]", "Medium"}], ",", 
     RowBox[{"StreamColorFunction", "->", "None"}], ",", 
     RowBox[{"StreamStyle", "\[Rule]", "Gray"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Blue", ",", 
      RowBox[{"Point", "[", "init", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
      RowBox[{"Point", "[", "zk", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", "star", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p6", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Purple", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"zk", ",", 
         RowBox[{"zk", "-", 
          RowBox[{"\[Gamma]", " ", "Fzk"}]}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Purple", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{"init", ",", 
         RowBox[{"init", "-", 
          RowBox[{"\[Alpha]", " ", "Fzk"}]}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pic3", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"{", 
    RowBox[{
    "p1", ",", "lines", ",", "markers", ",", "p2", ",", "p3", ",", "p5", ",", 
     "p6", ",", "p7"}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.90477270990481*^9, 3.904772738319459*^9}, {
  3.9047729216004057`*^9, 3.9047729391078978`*^9}, {3.904773294519186*^9, 
  3.904773294861289*^9}, {3.904773343332224*^9, 3.904773355381507*^9}, {
  3.904773756104392*^9, 3.904773758677458*^9}, {3.904773828160054*^9, 
  3.904773828308576*^9}, {3.904774063392703*^9, 3.904774138896329*^9}, {
  3.9048789968168983`*^9, 3.904878998037238*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"afefd18a-ef93-46c9-9ea9-50ad67c5eb42"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJx1mHtUVMcdxxewFhvJw/jElCNqlUi0HHET05jMejY+YhOzwSrHqKtgfEFV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     "], {{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[0.3], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXf8V1UZx88FgR9DtrKHpigKKgqiIIoJggoqGwQZCoKyYipDWaIiSwE1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           "]], PolygonBox[CompressedData["
1:eJwtkwdLllEYhp9HLaE/IdHQDFvY0KDMFgQtzXYhRju1RXvSoIgoG3+qtL2H
hkSIRLT3um7uF77rO9f7ve95z3Oec3/D2zqbOkoiYjqUwdaMGAHP8S+wD6+H
e/gD6MBHwgv8W/jZHfA1PKcRnw038WHQgK+DT3gy7oFRcJfrH3ACr4JH+B8Y
jR+En/hL2ILXwS38GRzFT6affQgH8CPwC78PU/AN8BTvhpn4dRgKN7ieyLgI
3oVr2onvTddyB6bhm9Jr9UAt3gpPwnvaiE9N39Mabfjk9Fp6Zjveme7NbdiM
b0v3UnuYg48BPvEYZiHr4TNeyjgDlsEHrv+FezMPXoV7NAlfDO/Dc66k36G5
JcW9q1BWPHMtfSY6C/02HhbAm/AaY/Hz6bVKw73pKt6lHl1On6HOTkUvhEuF
v1VuGPenz0oZOZ4+I53Nb6jEj6W9F+bip+Ev3gdn8FPpXug3ZWsXfA9nrD3d
U/VSGVPtLfAxvIcV+EoYwIfAoXQmlAVlaH46Azp79fAsXq394f1wOF2jalOG
zqV7ol68DmdVNatWZfYCXqM8hde8iI+DcnwQdqczpSxpD6vw1el7mrMGX1v0
TnOa8Ob0WqppCb40XZvavJyvCen/pvasLFek96pM/weUFHyW
           
           "]]}]}, {}, {}, {}, {}}, 
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJwt0lk3FAAYBuBxTrfuuM6grNFClkiKonVmtArZBlkairK0yJZtUqr7+g9p
EbIU/YB+UE/nuHjO+12+53xvsDUWeZAQCAQ+kug4II/Km9zgIvlc5zRz5DBL
LXVEeEU2M9QQJsQEWVRRziTTTFHNIR4xSD8PGSCd/8Vi9NBHL2ncp5tOSugi
lQ6KaaeIKEHaOEkLhbSSQjMF3OME5zjLe95xjeM0Uckyb7nKMRo5wxuWuEID
d3lNHnEuU88dFjnCApe4zS3myeUgH6jgAufJZJyXPOMFz8lgjKcMM8oIh3nC
KYYo5TFl/PXfZLIoJ0yUEeJ8YoUvfOUb31nlB2uss8FPNtlimx1+8Ztd9vjD
5/19LTJMOyHKyCRpf3v/ALuPQtM=
        "]]}}], {}}, {{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
      LineBox[{{0., -1.}, {0.49029033784546006`, -1.098058067569092}, {
       1.0767345218447664`, -0.9653469043689533}, {
       1.6556172882229174`, -0.5320944238600375}, {2.0788446749800604`, 
       0.22746258475755654`}}]}}, {{}, {}}}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox[
       FormBox[
        StyleBox[
         GraphicsBox[
          {EdgeForm[None], DiskBox[{0, 0}]}],
         StripOnInput->False,
         GraphicsBoxOptions->{DefaultBaseStyle->Directive[
           PointSize[
            Rational[7, 360]], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6]]}],
        TraditionalForm], {0., 0.}, Automatic, Offset[6.272]], {{{
      0., -1.}}, {{0.49029033784546006`, -1.098058067569092}}, {{
      1.0767345218447664`, -0.9653469043689533}}, {{
      1.6556172882229174`, -0.5320944238600375}}, {{2.0788446749800604`, 
      0.22746258475755654`}}}]}, {{}, {}}}, {{}, {
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.08053395042374835, 
        0.05877555787340594}, {-0.10825854645466215`, 
        0.015374076842259958`}, {-0.11272381043934837`, \
-0.04093496887871566}, {-0.08803193398516472, -0.0977723952998116}, \
{-0.03684999380370615, -0.13917432851429626`}, {
        0.033666388023755725`, -0.15390764668802362`}, {
        0.10968336185455071`, -0.1330187299607751}, {
        0.11951506211752265`, -0.12400353934873642`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.12688555834261508`, -0.11724515304756228`}, {
        0.17327830342518144`, -0.07470526383732816}, {0.20584902741009745`, 
        0.01183901334730142}, {0.1953066889744705, 0.11233036907181589`}, {
        0.17162433258799892`, 0.16123599539912886`}, {0.13582443016953089`, 
        0.20536816957834508`}, {0.11016753920608098`, 
        0.22511846934664195`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.10224342370798617`, 0.2312183376708645}, {
        0.0887539660788878, 0.24160232504743195`}, {0.03217730132733977, 
        0.26727400321326444`}, {-0.02525173462340204, 
        0.2792224682947744}, {-0.0863578723919625, 
        0.2789921719228537}, {-0.1485294100982113, 
        0.26542417832325443`}, {-0.20895471837347804`, 
        0.23816524186668767`}, {-0.2645467322253788, 
        0.19722704802085309`}, {-0.26595595996055704`, 0.1956439139392192}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.27260486123007255`, 
        0.18817450218806805`}, {-0.3123694029318763, 
        0.1435028003493917}, {-0.3493643957780324, 
        0.07836347702044173}, {-0.3730199805754065, 
        0.003987543185027896}, {-0.38096249355339884`, -0.0684106646219723}, \
{-0.3750591874663361, -0.14375075441048665`}, {-0.36478325588723465`, \
-0.1811977528418923}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3621369569700817, -0.19084125334954383`}, \
{-0.35430220923931455`, -0.21939222060015984`}, {-0.31846531903111513`, \
-0.2925167580103652}, {-0.2677536118729831, -0.3600514254276449}, \
{-0.2030727395186048, -0.4190769545036568}, {-0.12545024644439423`, \
-0.46673279363437614`}, {-0.10128361478339044`, -0.4759246992433453}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09193688203034728, -0.4794797782640128}, \
{-0.03707100512619312, -0.5003483034573726}, {
        0.035100132075154424`, -0.5149236410295126}, {
        0.11071805641780638`, -0.5192584422513159}, {
        0.1883578516989877, -0.5126663527193198}, {
        0.2274929332529781, -0.5047547827509514}, {
        0.26649158034571624`, -0.4939262862495361}, {
        0.29780993055389715`, -0.48173062121848603`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.30712833735638195`, -0.4781019445088017}, {
        0.34635611752289336`, -0.4628262718235441}, {
        0.42300475847247376`, -0.41903875022635867`}, {
        0.49447244353982106`, -0.3627940092963286}, {
        0.558770543170338, -0.2946422852585897}, {
        0.5970696564849124, -0.24245971987750178`}, {
        0.6073800607953709, -0.2250215663479385}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.61246956394468, -0.2164136073742228}, {
        0.6306882195940825, -0.18560010047864334`}, {
        0.6590400615896861, -0.12449296616677075`}, {
        0.6815969550675887, -0.0596152064776323}, {0.6979272204503256, 
        0.00856466657455189}, {0.70761615381186, 0.07947165067658801}, {
        0.7102620876609865, 0.15241856669054218`}, {0.7094067030190767, 
        0.16587456764052697`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7087722934698549, 0.17585442357755612`}, {
        0.7055402062501889, 0.22669818037117162`}, {0.6932230878905588, 
        0.30163431321651557`}, {0.6731383626292087, 0.37647649153096374`}, {
        0.6451666160946882, 0.4503947310323393}, {0.609275347201237, 
        0.5225640262171608}, {0.5901394382767056, 0.5530410204425188}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5848219180649035, 0.5615100214932376}, {
        0.5655104377021095, 0.5922666413026828}, {0.5140137353551719, 
        0.6586812656320755}, {0.4550239243766438, 0.7208725758231971}, {
        0.3888624240904714, 0.7779603289584983}, {0.3158906098195595, 
        0.8292165743350434}, {0.300760254490825, 0.8377362922903202}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2920466884132313, 0.8426427947321221}, {
        0.23659799023241596`, 0.8738652782246717}, {0.15160657255833163`, 
        0.9110724043076697}, {0.06160014610145757, 
        0.9401066106472941}, {-0.03275818276768201, 
        0.9605179616944891}, {-0.08488704914793258, 0.9665092406951489}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09482164944252498, 
        0.9676510449632634}, {-0.13065601171714353`, 
        0.9717695627271428}, {-0.23112322765677928`, 
        0.973219323931238}, {-0.3331683264461468, 
        0.9644153822862018}, {-0.4181235708458057, 
        0.9490940572870644}, {-0.49028973696980177`, 0.9297950213476631}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4999502601050498, 
        0.9272115560869448}, {-0.5029210006996729, 
        0.9264171058260877}, {-0.5869277491644136, 
        0.8965191946769938}, {-0.6694986107525744, 
        0.8589486437625197}, {-0.7500066220238256, 
        0.8141206564962981}, {-0.8278118426879888, 
        0.7618337611555807}, {-0.8521553487469629, 0.7423977594024173}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8599701095291714, 
        0.7361584073593879}, {-0.9022845969303801, 
        0.7023742659410683}, {-0.9727952089363158, 
        0.6360284790534616}, {-1.0386365037876655`, 
        0.5629244760266161}, {-1.099163305849056, 
        0.48331691852786385`}, {-1.1264194104784524`, 
        0.44062743580284097`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1318008169014786`, 
        0.43219888522102606`}, {-1.1538389382299397`, 
        0.3976819939581188}, {-1.2021267240397686`, 
        0.3064958897182956}, {-1.243403048264287, 
        0.20987125628737627`}, {-1.277113846388205, 
        0.10821157368188868`}, {-1.288296826623905, 0.06597672842843649}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2908564298991376`, 
        0.05630985555902219}, {-1.2909970634305334`, 
        0.055778723847192124`}, {-1.3028267672694251`, 
        0.002429273609066054}, {-1.3125489140121178`, \
-0.051722723069085375`}, {-1.3201094597658491`, -0.10656321222385778`}, \
{-1.3262317503474492`, -0.17356886349563033`}, {-1.3289814401120654`, \
-0.24130320761004753`}, {-1.3283585290596975`, -0.30976624456710944`}, \
{-1.3265778799028938`, -0.3406023925637448}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.3260013851557029`, -0.35058576142432796`}, \
{-1.3243630171903458`, -0.378957974366816}, {-1.3168869717276026`, \
-0.44854242140950984`}, {-1.3058224598950607`, -0.5181836100955336}, \
{-1.29116948169272, -0.5878815404248872}, {-1.2729280371205804`, \
-0.6576362123975708}, {-1.251058310048759, -0.7270809597021168}, \
{-1.2458530488095827`, -0.7410976666368959}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2423717384450998`, -0.7504721254557368}, \
{-1.225520484347371, -0.7958491160270577}, {-1.196314560016418, \
-0.8639406813723939}, {-1.163440537055899, -0.9313556557381248}, \
{-1.124435002853534, -1.0067375920013464`}, {-1.080783885079794, \
-1.0807839165656377`}, {-1.0616542955017225`, -1.1060241967707638`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.0556140806901662`, -1.1139938771301168`}, \
{-1.0239935512513096`, -1.1557151602770417`}, {-0.9621605187836746, \
-1.227814544345588}, {-0.9091480881478889, -1.2865340247072512`}, \
{-0.8528265184908987, -1.3429224979795882`}, {-0.7931958098127043, \
-1.3969799641626002`}, {-0.7828634543443891, -1.405471503020873}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7751377495334164, -1.4118207931523534`}, \
{-0.7302559621133053, -1.448706423256286}, {-0.6642105840904254, \
-1.4977403420926636`}, {-0.5952632844417882, -1.5437201875037498`}, \
{-0.5234140631673937, -1.5866459594895443`}, {-0.44866292026724175`, \
-1.6265176580500478`}, {-0.44110170530631965`, -1.6300840787152189`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43205730161524786`, -1.63435007940356}, \
{-0.37129364800443543`, -1.6630106519502865`}, {-0.29159003864207755`, \
-1.6958003099552874`}, {-0.20955209218016813`, -1.7248866320650504`}, \
{-0.12517980861870728`, -1.7502696182795758`}, {-0.06119665240090115, \
-1.7666588565504842`}, {-0.05588878895582322, -1.7678193274569916`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.04611954899960154, -1.7699551998028404`}, {
        0.003851029826180065, -1.7808803872174532`}, {
        0.06987323707445227, -1.792854895742205}, {
        0.13677996835583134`, -1.8025030675864617`}, {
        0.2044812226822327, -1.809745588211945}, {
        0.2728869990655717, -1.8145031430803766`}, {
        0.34190729651776414`, -1.816696417653479}, {
        0.35034434446056445`, -1.816641785636856}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3603441348226757, -1.8165770344683203`}, {
        0.411452114050726, -1.8162460973929735`}, {
        0.4814289804349386, -1.8131716805894285`}, {
        0.5517446643665959, -1.8075230694807491`}, {
        0.6223080247461822, -1.7992665554496625`}, {
        0.6930279204741826, -1.7883684298788978`}, {
        0.7575571915660763, -1.7759946081526499`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7673507630913646, -1.7739809581114447`}, {
        0.8345727535773633, -1.7585125096492427`}, {
        0.9052154087535126, -1.7394872977558076`}, {
        0.9756500348800132, -1.7176856398536051`}, {
        1.0457603988003121`, -1.6931273678127137`}, {
        1.1154225467249201`, -1.6658487874993195`}, {
        1.1475545415609405`, -1.6518971688490038`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.156727204884504, -1.6479144251273274`}, {
        1.1845337566049197`, -1.6358409012903128`}, {
        1.2529913063913936`, -1.6030947115625829`}, {
        1.3206924740354231`, -1.5676012206930192`}, {
        1.3875345374880903`, -1.5293514310585123`}, {
        1.4534147747004778`, -1.4883363450359517`}, {
        1.505403252257749, -1.4532130093289444`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.5136894387172943`, -1.4476148744647555`}, {
        1.5182304636236674`, -1.4445469650022265`}, {
        1.5818697986437271`, -1.3980464376132837`}, {
        1.6442181792036419`, -1.3489201077647792`}, {
        1.7051686908398727`, -1.2971922751931677`}, {
        1.7646144190888797`, -1.242887239634903}, {
        1.8187148716092199`, -1.1896998653894943`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8257205906642757`, -1.1825664174133537`}, {
        1.8785638675710594`, -1.1266427585042336`}, {
        1.9328537588771526`, -1.0647519124047375`}, {
        1.9852112089418608`, -1.000381062264406}, {
        2.0350129280543623`, -0.9343528917100311}, {
        2.078025828206587, -0.8728489406007649}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.0837040778547715`, -0.8646185932841548}, {
        2.128305552016987, -0.7956863310917494}, {
        2.171600776410988, -0.723158187371794}, {
        2.2125314887760323`, -0.6485736322739303}, {
        2.2509998488840584`, -0.5719877889701344}, {
        2.277050752689313, -0.5150138487701635}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.281209099426934, -0.505919446513296}, {
        2.2869080165070046`, -0.4934557806323819}, {
        2.320158151416809, -0.4130327304326482}, {
        2.3506851139985763`, -0.3308402292310362}, {
        2.378433826364538, -0.24702031948399486`}, {
        2.4033215408773243`, -0.16165880175802025`}, {
        2.4117469839336128`, -0.1283250676230679}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.414197518750787, -0.11862997200157879`}, {
        2.4252655098995644`, -0.07484147661960802}, {2.4441829857938906`, 
        0.013345855364745888`}, {2.459991220922931, 0.10281739362854576`}, {
        2.472607467649317, 0.19348733760529555`}, {2.4809347319270953`, 
        0.2753046761812702}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.481947288184834, 0.2852532805972129}, {
        2.4819489783356783`, 0.28526988672850034`}, {2.4879867717071797`, 
        0.37802196948648364`}, {2.49070840998515, 0.47158289253828295`}, {
        2.490055960776466, 0.5658404225734739}, {2.4859714916880042`, 
        0.6606823262816315}, {2.4840508586973495`, 0.684850944421721}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.4832586756316037`, 0.6948195173381593}, {
        2.4783970703266425`, 0.7559963703523308}, {2.4672747642992565`, 
        0.8516703214751467}, {2.452546641212724, 0.9475919463396543}, {
        2.434154768673921, 1.0436490116354284`}, {2.4237023270207225`, 
        1.0899481225928842`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.4215001585870737`, 1.0997026320213403`}, {
        2.412527892564225, 1.139445302099252}, {2.386681543186237, 
        1.2354092287986997`}, {2.357271652055331, 1.3310120112352253`}, {
        2.324250652662824, 1.4261353674945108`}, {2.3028515608648084`, 
        1.4812868913959343`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.2992342535154764`, 1.4906097175522277`}, {
        2.2875751248538103`, 1.5206585962206804`}, {2.24720579482716, 
        1.6144585766163009`}, {2.203107535135521, 1.7074097684423823`}, {
        2.155249364685315, 1.7993842120183783`}, {2.126376843167879, 
        1.8509379535629213`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{2.121490496893639, 1.8596628386675071`}, {2.12065533854911, 
        1.8611540675307932`}, {2.0843733714590322`, 1.9223640831778877`}, {
        2.0464077358242774`, 1.982970857842905}, {2.006764192966777, 
        2.042930389544664}, {1.9654499931212028`, 2.1021980754375535`}, {
        1.922473875434965, 2.1607287118115317`}, {1.8986997886637487`, 
        2.191492060152295}}]}, 
      {Arrowheads[{{0.00487273592909976, 1.}}], 
       ArrowBox[{{1.8925849257808414`, 2.199404610431645}, {
        1.8778460679682123`, 2.2184764940921284`}, {1.8315782876938322`, 
        2.2753950168404447`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.14547891007220048`, 
        0.11916598653100989`}, {-0.20018808890752074`, 
        0.04587817735195573}, {-0.21809499430669954`, \
-0.052384544834700904`}, {-0.2093502195933019, -0.10535270435621343`}, \
{-0.18788041833393657`, -0.15720883573738362`}, {-0.15360600838843486`, \
-0.20480024767999808`}, {-0.12332991323839783`, -0.2312526134122412}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.11579931417703056`, -0.2378321329826152}, \
{-0.10742852137849343`, -0.24514573374514484`}, {-0.054780795232938675`, \
-0.2735614427777287}, {0.005157862004517218, -0.29084447824351456`}, {
        0.07004484914972275, -0.29501462846205223`}, {
        0.13708011979011378`, -0.284882615864117}, {
        0.2030522933466684, -0.25955535337563435`}, {
        0.2558853264903374, -0.22488580217924484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2642459599760206, -0.21939947301321103`}, {
        0.26465776711645184`, -0.21912924115468047`}, {
        0.31832259232672183`, -0.16418240008929064`}, {
        0.36082906809652665`, -0.096308484071882}, {
        0.3885847380749037, -0.01908584924205449}, {0.4000456856539895, 
        0.06565244887021149}, {0.394164714977549, 0.14046929216935236`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.39338108314904147`, 0.1504385409453309}, {
        0.39306575857587844`, 0.15445005375106807`}, {0.3666069983991692, 
        0.24341472569769934`}, {0.32010062255986266`, 0.3281935146590073}, {
        0.25425588437216456`, 0.4044831249025242}, {0.21450821167510306`, 
        0.4380175709659093}, {0.17043784712386428`, 0.4677174219028052}, {
        0.16996086668192925`, 0.46797079637645456`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.16112954543700334`, 0.47266203982237803`}, {
        0.12252653658173288`, 0.49316815745333437`}, {0.07125602591199372, 
        0.5139552573576198}, {-0.01996522215690985, 
        0.5366825108632076}, {-0.11702795438727706`, 
        0.5434818841616339}, {-0.21721722303568305`, 
        0.5328056759298602}, {-0.22576610481923012`, 0.5303397931214757}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.23537438286674986`, 
        0.5275683326830877}, {-0.3174788920905576, 
        0.5038856917351823}, {-0.3665717420108557, 
        0.482474711568773}, {-0.41440453032129443`, 
        0.4563713009120596}, {-0.4605587565934912, 
        0.4257126024934353}, {-0.5046159203990634, 
        0.3906357590412935}, {-0.5461911457042167, 
        0.35103857787511794`}, {-0.570848451717243, 
        0.32297302843309883`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5774486373544233, 
        0.315460535534283}, {-0.5848726569594866, 
        0.30701033464151917`}, {-0.6202016044629868, 
        0.25897537455958114`}, {-0.6517191385128303, 
        0.20735804284838796`}, {-0.6843489226250916, 
        0.1398791931643146}, {-0.7101497284399011, 
        0.06779199637184315}, {-0.7285478783612251, -0.008199320690083278}, \
{-0.7336285472449531, -0.04680528939490585}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.7349333286966131, -0.05671980125194672}, \
{-0.7389696947930304, -0.08739053118252152}, {-0.7409871442374973, \
-0.1689395100171172}, {-0.734172193196806, -0.252004132105516}, \
{-0.7231780968853831, -0.3119641559013571}, {-0.7073964490523483, \
-0.37177130546142895`}, {-0.6815879730457203, -0.4461190915784071}, \
{-0.6804913318367958, -0.44851324745633364`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6763269195519824, -0.4576048738412054}, \
{-0.6481674334486417, -0.5190818625090168}, {-0.607157790347405, \
-0.5898437910725429}, {-0.5586594598082746, -0.6576107487209791}, \
{-0.5028292409574694, -0.7216731350728813}, {-0.443098831101584, \
-0.7782679702411217}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4354886283053369, -0.784737859807511}, \
{-0.37030158051751605`, -0.8356144931478727}, {-0.29438844864156155`, \
-0.8839340036069614}, {-0.2121012932887889, -0.9258331533266222}, \
{-0.12447660508806352`, -0.9603200400389009}, {-0.08523535767771111, \
-0.9715456489487521}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.07562101337676386, -0.9742959914115815}, \
{-0.03220240048087697, -0.9867166049226817}, {
        0.06398392504300879, -1.0044273195395952`}, {
        0.1633700438727946, -1.0129780167687295`}, {
        0.2651152444470397, -1.0119358515330443`}, {
        0.3203329689302647, -1.0060297712032846`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.3302762530457047, -1.0049662388814258`}, {
        0.3682428346284351, -1.0009053384590967`}, {
        0.4717632070324956, -0.9795925417895168}, {
        0.5233772528930066, -0.9650207495101828}, {
        0.5747412635346618, -0.9478209290994664}, {
        0.6257144895202278, -0.9279817448511882}, {
        0.6761574382250481, -0.9054986932280239}, {
        0.7104394978198866, -0.8881941734750485}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.719366675523292, -0.8836880112218868}, {
        0.7259318738370407, -0.8803741028615043}, {
        0.7749008173566987, -0.8526171345520158}, {
        0.8229285465970906, -0.8222437812687997}, {
        0.8698805961838584, -0.7892768681499539}, {
        0.9156590318247232, -0.7537395461981284}, {
        0.9601489901943709, -0.7156651529461578}, {
        1.003195319529314, -0.6751015210763552}, {
        1.0354704200881217`, -0.6416224417598404}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0424108511757042`, -0.6344231073240388}, {
        1.0446478874673881`, -0.6321026214340959}, {
        1.0843615810477507`, -0.5867285630278185}, {
        1.1221963067108809`, -0.5390455930290248}, {
        1.1580169902985804`, -0.4891260967722792}, {
        1.1916935770539712`, -0.43704859775521115`}, {
        1.2231345169907226`, -0.38287963392994007`}, {
        1.2522360159556924`, -0.32670122519028977`}, {
        1.2631738386890639`, -0.3028410089903315}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2673409809396914`, -0.29375063356007375`}, {
        1.2788598608733075`, -0.2686228752943552}, {
        1.3028764298420346`, -0.20875829296771162`}, {
        1.3241646921343795`, -0.1472253919034172}, {
        1.3426122081968872`, -0.08414629076201202}, {
        1.3581151296501417`, -0.01964731317151891}, {1.3705781992887656`, 
        0.04614101227255685}, {1.3766544291652045`, 0.08944521086776755}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3780439673005531`, 0.0993481994959753}, {
        1.3799759929023492`, 0.11311739882722877`}, {1.3862601038935094`, 
        0.18115911108816132`}, {1.389318587583144, 0.2500998157622025}, {
        1.3890546229270881`, 0.3197725422495182}, {1.3853865125161153`, 
        0.3900096826435927}, {1.3782476825759373`, 0.46064299173122786`}, {
        1.3726303666649142`, 0.49797967345288113`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.3711426071341462`, 0.507868382750793}, {
        1.3675866829672036`, 0.5315035869925432}, {1.353367187185502, 
        0.6024219486009768}, {1.3389637642846015`, 0.6606594882483303}, {
        1.322085454136531, 0.7187414688485818}, {1.3027537473980226`, 
        0.7765671150057446}, {1.2809947711310472`, 0.8340360414747908}, {
        1.257248129658711, 0.8900832994875366}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.253033530906833, 0.899151009535055}, {1.2303227002857684`,
         0.9475041451232241}, {1.2014850418575984`, 1.0033045025673564`}, {
        1.1695797063738769`, 1.0582839150890209`}, {1.1356943645126123`, 
        1.1124313257567426`}, {1.0993364454997308`, 1.165602701186843}, {
        1.060557576626015, 1.2176998019645742`}, {1.0436096412841431`, 
        1.2386743958069906`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0373247179175737`, 1.2464525535757909`}, {
        1.0194093851822454`, 1.2686243886751898`}, {0.9759434984592045, 
        1.318278221903942}, {0.930211543747674, 1.366563062236083}, {
        0.882265148338435, 1.4133806702568663`}, {0.8321559395222693, 
        1.4586328065515441`}, {0.7798828050388837, 1.5021920316786117`}, {
        0.7509828081255685, 1.524363705813906}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.7430487346535213, 1.5304506162075422`}, {
        0.725463810646558, 1.5439415243881127`}, {0.6689793506639327, 
        1.5837989725526218`}, {0.6105098194096483, 1.6216820640447138`}, {
        0.5501356112023459, 1.6575084867369636`}, {0.48793712036066567`, 
        1.691195928501946}, {0.42399474120324854`, 1.7226620772122359`}, {
        0.3994766731630144, 1.7335606323578407`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3903387839876425, 1.737622526179523}, {
        0.35838886804873527`, 1.7518246207404082`}, {0.2910770022688201, 
        1.7785684808804598`}, {0.2220613335795418, 1.8027904943640523`}, {
        0.151489288816057, 1.8244262214702573`}, {0.07950829481352238, 
        1.8434112224781471`}, {0.00999642241294614, 1.8588523455184298`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.00018659713990841313`, 
        1.8607839797767523`}, {-0.06809083356806767, 
        1.8731712873152677`}, {-0.14341411427680922`, 
        1.8838174717026424`}, {-0.21955663688397295`, 
        1.8915551711079885`}, {-0.3109977393126927, 
        1.8968215374577784`}, {-0.39740241473695476`, 1.8976607646625359`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.4073992476663572, 
        1.897562608385838}, {-0.4963105316193033, 
        1.8942432131189566`}, {-0.5901822214971941, 
        1.886398522430345}, {-0.6844512307053616, 
        1.874061888216544}, {-0.7787046827576921, 
        1.8571117192984978`}, {-0.8040394998892202, 1.8513145557630724`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8137875540932025, 
        1.8490839865002553`}, {-0.8729425776541857, 
        1.8355480156762067`}, {-0.9671649153948421, 
        1.8093707773496703`}, {-1.0609249780295422`, 
        1.7785371580501284`}, {-1.1537760476081667`, 
        1.7430043115088196`}, {-1.193542786971388, 1.7256031557737626`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2027040889742628`, 
        1.7215943472709625`}, {-1.245718124130716, 
        1.7027722377257453`}, {-1.3367512075971895`, 
        1.6578409367009042`}, {-1.4302286263662656`, 
        1.6090468672910196`}, {-1.5222452072387163`, 
        1.555240327724995}, {-1.554475424122574, 1.532420890667627}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5626368989681576`, 
        1.526642454171056}, {-1.5687541366156896`, 
        1.5223113657404121`}, {-1.6146415334374957`, 
        1.4880284283385103`}, {-1.6597946936157246`, 
        1.4524304499251783`}, {-1.704251185179846, 
        1.41550445236512}, {-1.7856720026269841`, 
        1.3462796227348228`}, {-1.8642431065735035`, 
        1.2727044762288422`}, {-1.8680218462679385`, 
        1.2688157462417993`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-1.874990762209026, 
        1.2616439814237048`}, {-1.939964497019404, 
        1.1947790128471776`}, {-1.9767565496796224`, 
        1.1541849123279637`}, {-2.0128361739646863`, 
        1.112503232589829}, {-2.048090648997865, 
        1.0697920311445586`}, {-2.0824072539024274`, 
        1.0261093655039377`}, {-2.115785988678374, 
        0.9814552356679662}, {-2.133268660243372, 0.9568671957350299}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.139063423295993, 
        0.9487173048668048}, {-2.148226853325704, 
        0.9358296416366441}, {-2.179729847844419, 
        0.8892325834099719}, {-2.2102949722345175`, 
        0.8416640609879489}, {-2.239922226496, 
        0.7931240743705754}, {-2.268611610628867, 
        0.7436126235578515}, {-2.2962600922152574`, 
        0.6932113008490698}, {-2.3227646388373104`, 
        0.6420016985435231}, {-2.341239717978965, 0.6041069309449646}}]}, 
      {Arrowheads[{{0.014966800843425932`, 1.}}], 
       ArrowBox[{{-2.3456220049174075`, 
        0.5951182958322705}, {-2.3481252504950265`, 
        0.5899838166412114}, {-2.3723419271884056`, 
        0.5371576551421345}, {-2.3954146689174483`, 
        0.48352321404629267`}, {-2.4173434756821535`, 
        0.42908049335368587`}, {-2.4381283474825217`, 
        0.3738294930643138}, {-2.457769284318553, 0.317770213178177}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.005412115972872655, 
        0.434639744761163}, {-0.0992735320248458, 
        0.44167364455746383`}, {-0.19637867343681703`, 
        0.4284910286897749}, {-0.292510312353987, 
        0.3942131295900522}, {-0.3387511527179627, 
        0.36905131777866124`}, {-0.3825003968831305, 0.33882404703443814`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.39013555583711673`, 
        0.33237083906670234`}, {-0.424692290548228, 
        0.30279296452015914`}, {-0.4632831487065725, 
        0.2622772322061808}, {-0.4981035208248903, 
        0.21702445462295633`}, {-0.5285764767165013, 
        0.16728506015674866`}, {-0.5542805599236785, 
        0.11358931045594399`}, {-0.5747943139886946, 
        0.05646746716892838}, {-0.5876911686376989, -0.005101175214466895}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.589741383234593, -0.014888749996131769`}, \
{-0.5957798350245687, -0.04371587792186095}, {-0.5995868863631374, \
-0.14951363987404345`}, {-0.5945774115543174, -0.20361798760553948`}, \
{-0.5847080301112333, -0.2580460120712426}, {-0.5699900724924049, \
-0.3123567402094278}, {-0.5504348691563521, -0.3661091989583698}, \
{-0.5329287641387913, -0.4038033112115108}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5287166085045741, -0.412872916765951}, \
{-0.5259381861137769, -0.4188554106091157}, {-0.4964882409336352, \
-0.47015300117049474`}, {-0.4622350414118289, -0.5195694031574555}, \
{-0.42332859534425943`, -0.5666720490849461}, {-0.3796744905013567, \
-0.6110616423021615}, {-0.3313738506739279, -0.6523122694908995}, \
{-0.2788699876884405, -0.6899514381650126}, {-0.2594124219845771, \
-0.7015557583605792}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.25082384884571934`, -0.7066779074640797}, \
{-0.22260621337136208`, -0.7235066558383536}, {-0.14957979061056267`, \
-0.7580931697685621}, {-0.0717632496062046, -0.7854784596838134}, {
        0.010121227841374272`, -0.8050788661779351}, {
        0.09535145993183615, -0.816310729844755}, {
        0.12902155699853582`, -0.817241354437818}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.13901773947631912`, -0.8175176439071398}, {
        0.1830676674992265, -0.8187351618210195}, {
        0.2724100713775927, -0.8119132732434754}, {
        0.33354929891127233`, -0.8013751901653294}, {
        0.3946096132208077, -0.7863412526061471}, {
        0.48808157792872836`, -0.7551354471564}, {
        0.5270258553613951, -0.7372314255716031}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5361116760864388, -0.7330543617999609}, {
        0.579585278471498, -0.7130680540088684}, {
        0.6678929059288734, -0.6601914634783541}, {
        0.7517697584162523, -0.5966679538893054}, {
        0.8207193516425308, -0.5324289568589449}, {
        0.853743511640356, -0.4951936741933058}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8603788548615364, -0.4877122157568019}, {
        0.8844823823085548, -0.46053509277205906`}, {
        0.942183961300501, -0.38141038182623943`}, {
        0.9930092621393032, -0.29555076228404914`}, {
        1.0362640212491345`, -0.2034801397799959}, {
        1.057934719818556, -0.14300108600946154`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0613078883861595`, -0.13358717429251138`}, {
        1.071249833322373, -0.10584097956534255`}, {
        1.0972579778228175`, -0.003398791272700319}, {1.1136694296335872`, 
        0.10303052427040114`}, {1.1181187805031256`, 0.15749446548671547`}, {
        1.1199942471494762`, 0.21266032448246852`}, {1.119350633692318, 
        0.25995989208118697`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.119140150483491, 0.2699561792101718}, {
        1.1157903845763841`, 0.3245690496497532}, {1.1096115130629183`, 
        0.38104576473628887`}, {1.1006596727382183`, 0.43769209543227355`}, {
        1.0889021217593646`, 0.49437318819148485`}, {1.0743129300050742`, 
        0.5509534782662108}, {1.0568772263022872`, 0.6073174148983237}, {
        1.037871787110824, 0.6597850085055192}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.034190103872587, 0.6690797355630174}, {
        1.0134270959530278`, 0.7188633191756706}, {0.9874030546654159, 
        0.7737426506704743}, {0.9585187274736218, 0.8278269767783417}, {
        0.926787468954924, 0.8809687281379531}, {0.8922298984457404, 
        0.9330218348735466}, {0.8548739000416281, 0.9838417265949186}, {
        0.831844502363403, 1.0122395336379555`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8255457981795712, 1.020006535994372}, {0.8147472350639777,
         1.0333223645706715`}, {0.7718887382771573, 1.0813401174123132`}, {
        0.7263532100772334, 1.127729237546196}, {0.6782019276158595, 
        1.1723294269827107`}, {0.6275026448002757, 1.2149858373162854`}, {
        0.5743295922933089, 1.2555490697253862`}, {0.5292843005309958, 
        1.2866185551448255`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5210524944163194, 1.2922963512040704`}, {
        0.5187634775133729, 1.2938751749725168`}, {0.46089148463446683`, 
        1.3298256534042197`}, {0.40078771683718284`, 1.3633027983768036`}, {
        0.3385428371638475, 1.3941961313311284`}, {0.2742770200945249, 
        1.422358996590677}, {0.2081148307049731, 1.447653958028381}, {
        0.16079550870485054`, 1.4631871857453596`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.1512943252298204, 1.466306081795858}, {0.1401852246666439,
         1.4699527990666208`}, {0.0706215482466831, 
        1.4891365226772266`}, {-0.0004384616920700135, 
        1.5050953513814767`}, {-0.07285267769108147, 
        1.5177287272500986`}, {-0.14651021008115578`, 
        1.527009721361598}, {-0.22127741018556513`, 
        1.5328874176898575`}, {-0.24183894839374673`, 1.5335276066443668`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2518341048911094, 
        1.533838808497235}, {-0.29697427641173946`, 
        1.5352442597295104`}, {-0.3734202169324854, 
        1.5339787808668612`}, {-0.45043404968598566`, 
        1.5290056043798852`}, {-0.5278340023757991, 
        1.5202554434382276`}, {-0.6054377124708609, 
        1.5076751011032052`}, {-0.6491644237807317, 1.4984099764823813`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6589472297485056, 
        1.496337126416195}, {-0.6830622272054818, 
        1.4912274703278054`}, {-0.7465162101455016, 
        1.4748316925138893`}, {-0.8097756524920166, 
        1.455771484811578}, {-0.8727335514231203, 
        1.4340702822333202`}, {-0.9352833275524565, 
        1.409756368061827}, {-0.9973188249292202, 
        1.3828628738500683`}, {-1.035578299967601, 1.3645259472554754`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.0445960687985532`, 
        1.3602039285938419`}, {-1.058734311038155, 
        1.3534277794212755`}, {-1.1194244767995551`, 
        1.3214939128689402`}, {-1.1792121702353935`, 
        1.2862815124323494`}, {-1.2380877610571228`, 
        1.2489289132726151`}, {-1.2958972980262276`, 
        1.2089219984370505`}, {-1.3525365306518773`, 
        1.1663157166947977`}, {-1.3800118835443682`, 
        1.1439091668505954`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.387761577257726, 
        1.1375891789274153`}, {-1.4079012084432412`, 
        1.121165016815}, {-1.4618870809094882`, 
        1.0735248475668009`}, {-1.5143898975597878`, 
        1.0234501577193422`}, {-1.56530540790331, 
        0.9709958960417678}, {-1.6145293614492224`, 
        0.9162170113032206}, {-1.6619268970927663`, 
        0.8591130203086064}, {-1.667090845465837, 0.8523626390390251}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.6731667512237463`, 
        0.8444201350748457}, {-1.7073742848615192`, 
        0.7997035969407351}, {-1.7507839709631574`, 
        0.7380739255856067}, {-1.792068401605357, 
        0.6743091906292207}, {-1.831140022995794, 
        0.6084945764575765}, {-1.8679112813421448`, 
        0.540715267456674}, {-1.8850421381122138`, 0.5060090636304687}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8894682774868785`, 
        0.49704194089036735`}, {-1.9022946228520856`, 
        0.4710564480125124}, {-1.9342024937332927`, 
        0.39960330251109144`}, {-1.9635141693256861`, 
        0.3263116886380093}, {-1.9901209871029155`, 
        0.2511844919699191}, {-2.013953486473252, 
        0.17437743872940273`}, {-2.0278553313349295`, 
        0.12249490645400007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0304435152263984`, 
        0.11283564643348401`}, {-2.0349422068449643`, 
        0.09604625513904291}, {-2.0530176876263244`, 
        0.016346667421421525`}, {-2.0681104682256017`, -0.06456559820087951}, \
{-2.0801510880510676`, -0.14653481550527753`}, {-2.0890700865109912`, \
-0.22940525826919062`}, {-2.0924276935686574`, -0.2816865676379874}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0930685926375303`, -0.29166600892412753`}, \
{-2.0954396789355716`, -0.32858620064369465`}, {-2.0971544426509148`, \
-0.42866782732487374`}, {-2.09421437765702, -0.529650138312728}, \
{-2.0866194839538883`, -0.6315331336072576}, {-2.0794479726673916`, \
-0.6908175948349481}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.078247049363996, -0.7007452221053164}, \
{-2.0742381999459187`, -0.7338850260321633}, {-2.0569389640375118`, \
-0.8362740284111461}, {-2.0347217762286673`, -0.9387001407442059}, \
{-2.007586636519385, -1.041163363031343}, {-1.9919869680040287`, \
-1.0907421940718827`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.9889855940689332`, -1.1002811538947213`}, \
{-1.9754826555476377`, -1.1431961624309015`}, {-1.9383589439513975`, \
-1.2443310061012258`}, {-1.917914689169093, -1.2945616945379255`}, \
{-1.8962155017306648`, -1.344567894042316}, {-1.8732613816361139`, \
-1.3943496046143984`}, {-1.8490523288854397`, -1.443906826254172}, \
{-1.836531665736055, -1.469577615987888}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8321479026720746`, -1.4785655312856019`}, \
{-1.8246222972872492`, -1.4939950841094287`}, {-1.798909927668124, \
-1.5437311968014658`}, {-1.7719145480035619`, -1.5931467636891077`}, \
{-1.7436381743670684`, -1.6421469866958815`}, {-1.7099607881400833`, \
-1.6918855438167304`}, {-1.674903572937542, -1.7410260173770444`}, \
{-1.638501350743205, -1.7894586395766288`}, {-1.6180710261971891`, \
-1.8153010695294982`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-1.6118692726899702`, -1.8231457016710138`}, \
{-1.6007425142291518`, -1.8372199996822154`}, {-1.5648821746755486`, \
-1.8826028237307277`}, {-1.5278412959134235`, -1.9272539913960276`}, \
{-1.4896198779427767`, -1.971173502678115}, {-1.4502179207636074`, \
-2.0143613575769894`}, {-1.4096354243759166`, -2.056817556092651}, \
{-1.367872388779704, -2.098542098225101}, {-1.3449041859838369`, \
-2.1204669826195053`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.3376707392061844`, -2.127371853922786}, \
{-1.324928813974969, -2.1395349839743374`}, {-1.2808046999617122`, \
-2.179796213340362}, {-1.235558039726796, -2.219205553722463}, \
{-1.189246826257083, -2.2576427725199317`}, {-1.1418710595525732`, \
-2.295107869732767}, {-1.0934307396132663`, -2.331600845360969}, \
{-1.0439258664391626`, -2.3671216994045383`}, {-1.0270090653732915`, \
-2.37867915764739}}]}, 
      {Arrowheads[{{0.007715843167073457, 1.}}], 
       ArrowBox[{{-1.0187520833666874`, -2.384320278825189}, \
{-0.993356440030262, -2.401670431863474}, {-0.9417224603865645, \
-2.4352470427377773`}, {-0.88902392750807, -2.467851532027447}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.48892307970544124`, -0.2255960376955776}, \
{-0.47234150955369236`, -0.28040013109869155`}, {-0.4497896989994949, \
-0.3342914501283743}, {-0.42137907044760137`, -0.3866246696979429}, \
{-0.3869891971479279, -0.43671018388136307`}, {-0.34668513167425963`, \
-0.4838938114240816}, {-0.30085651541715247`, -0.5275833642466368}, \
{-0.270339106115216, -0.551298164114163}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.26244295611178625`, -0.5574341901182911}, \
{-0.24989298976716226`, -0.5671866542695669}, {-0.19397346852061423`, \
-0.6019659754417034}, {-0.13344544754921822`, -0.6313000360892431}, \
{-0.06895144135660704, -0.6547712696987723}, {-0.0011339644464142538`, \
-0.6719621097568779}, {0.055434360027338696`, -0.6808303612870098}, {
        0.11043092748202081`, -0.6847764161768118}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.12042257758643235`, -0.6849228954630304}, {
        0.17270890806693165`, -0.6843536612130827}, {
        0.23258827891210598`, -0.6787857093381425}, {
        0.29278627488733044`, -0.6680518012192428}, {
        0.35289782877765363`, -0.6520142590866653}, {
        0.4124593593504511, -0.6307186486106343}, {
        0.47100728537309855`, -0.6042105354613739}, {
        0.5030553906427077, -0.5863522199496523}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5117907293757424, -0.5814845863131567}, {
        0.5280628197234573, -0.5724172133430517}, {
        0.5831593399910003, -0.5353605935326805}, {
        0.6358515120105207, -0.49322816805975256`}, {
        0.6856940016168118, -0.4462074289537593}, {
        0.7322642943443182, -0.3942318668820284}, {
        0.7751216199677619, -0.3374381736016198}, {
        0.7954657901328375, -0.3052847373228198}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8008126202312452, -0.29683421024465706`}, {
        0.8137932606823548, -0.27631864277662344`}, {
        0.8478064986833074, -0.21136556807112983`}, {
        0.8822599427192419, -0.1274721126911481}, {
        0.908598141528878, -0.03876019951943066}, {0.9262396039195075, 
        0.053975006578883405`}, {0.9283904040025739, 
        0.07865420697662007}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9292586162741077, 0.08861644605483729}, {
        0.9346028386984222, 0.14993834073865492`}, {0.9332616664573384, 
        0.24819920715608954`}, {0.9217899077879729, 0.34782701002739524`}, {
        0.9083955110163023, 0.41242932454452597`}, {0.8905863600123586, 
        0.47681972429540115`}, {0.8883240859454332, 0.483555393477431}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.8851402190432355, 0.4930350027282962}, {
        0.8708863664150545, 0.5354742620897043}, {0.8474433201847803, 
        0.5935413842855224}, {0.8202535457196413, 0.650784897323016}, {
        0.7893277714405684, 0.7069692856210272}, {0.7546958645379219, 
        0.761863662046896}, {0.7163970715958388, 0.8152336251113281}, {
        0.6946404465391068, 0.8420195307957925}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.6883357288434453, 0.8497816525919261}, {
        0.6744795354548243, 0.8668408558592295}, {0.6290081220377702, 
        0.9164496482381802}, {0.5906117597057441, 0.9540937770824589}, {
        0.5500874860588226, 0.9902448401385171}, {0.5074958404919542, 
        1.0247776613529285`}, {0.4629020890326495, 1.0575715513071615`}, {
        0.41637622434098276`, 1.08851030721758}, {0.3849836859218514, 
        1.107308166002837}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.37640421875165786`, 1.1124455527972659`}, {
        0.3679929657095911, 1.117482212935443}, {0.3178317590636746, 
        1.1443800389469043`}, {0.2659767769609969, 1.1691010423730126`}, {
        0.21250181911470198`, 1.191565135589607}, {0.15749319648984317`, 
        1.211687350674498}, {0.10105973051272016`, 1.229365807743626}, {
        0.04331335863129562, 1.2445050515339477`}, {0.0037730192033273158`, 
        1.2528975477820967`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.006009063271857058, 
        1.2549738094343676`}, {-0.015630865684804207`, 
        1.257016051403438}, {-0.0756547729442894, 
        1.2668162013310886`}, {-0.1366370776342064, 
        1.2738293199169082`}, {-0.19845337821993775`, 
        1.2779856503819227`}, {-0.26100191481429885`, 
        1.279232865547126}, {-0.32416453199904005`, 
        1.2775193891764918`}, {-0.38778962152398055`, 
        1.272787108235359}, {-0.4041258427868641, 1.2707937165327077`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.41405221613917037`, 
        1.269582472514921}, {-0.45172520660197873`, 
        1.2649855081745047`}, {-0.5158189419089344, 
        1.2540716729301442`}, {-0.5799181135837871, 
        1.2400102849239318`}, {-0.6438696392285148, 
        1.2227736250629604`}, {-0.7075200679081368, 
        1.2023415727397608`}, {-0.7707386281756257, 
        1.1787049166637287`}, {-0.799078161952956, 1.1665606269529414`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8082697560746255, 
        1.1626217695675451`}, {-0.8333822975097055, 
        1.1518603371121627`}, {-0.8952805394005738, 
        1.1218082134241214`}, {-0.9562649072574587, 
        1.0885568765794538`}, {-1.0161690444086193`, 
        1.0521226091987999`}, {-1.0748286841013455`, 
        1.01252964554359}, {-1.1320816495019577`, 
        0.9698101715160445}, {-1.1491425404473465`, 0.9557763803966897}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1568654744102358`, 
        0.9494237202448438}, {-1.1877678536958063`, 
        0.9240043246591763}, {-1.241769399051258, 
        0.875150209763368}, {-1.2939498044058326`, 
        0.8232990307692895}, {-1.3441274503762795`, 
        0.7685217026550945}, {-1.3921270847638694`, 
        0.7108960270377618}, {-1.4309149337238063`, 0.6595875510758291}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.4369453868629378`, 
        0.6516104817557882}, {-1.4377798225543965`, 
        0.6505066921730969}, {-1.4809231459181769`, 
        0.5874452729557303}, {-1.5214009042100485`, 
        0.5218102309191195}, {-1.5590633139693721`, 
        0.4537069142355479}, {-1.5938049638495435`, 
        0.3832244098885922}, {-1.6255072160359314`, 
        0.3104706254917394}, {-1.6288271462024042`, 
        0.30174937724352346`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.6323848065517754`, 
        0.29240362672050435`}, {-1.6540130385370013`, 
        0.23558761829417238`}, {-1.6791758204048892`, 
        0.15872186308229685`}, {-1.7008593717354012`, 
        0.08002425217974052}, {-1.718937923668014, -0.0003499045526464406}, \
{-1.7332961283858743`, -0.08224087971679017}, {-1.734698846209352, \
-0.09332681132135293}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7359541507234764`, -0.10324770899126261`}, \
{-1.743829059115799, -0.16548452837739408`}, {-1.7505118592399884`, \
-0.24995434755341484`}, {-1.7532941851978299`, -0.3354977327220909}, \
{-1.7520540832963638`, -0.4219081250890366}, {-1.7471002921716492`, \
-0.5022808812124216}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7463295984520784`, -0.5122486457321929}, \
{-1.7371080325549344`, -0.5965040402828665}, {-1.7232474277403165`, \
-0.6842767895636506}, {-1.7050550831170816`, -0.7720909989505056}, \
{-1.6824982964035349`, -0.8597404536917197}, {-1.6690412335588627`, \
-0.9039337602013046}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.6661282452738435`, -0.913500081294146}, \
{-1.660635306665499, -0.9315390190890313}, {-1.635751721866957, \
-1.0029871892369975`}, {-1.607878956561032, -1.0739650539691754`}, \
{-1.5770538486130814`, -1.144353394594205}, {-1.5433186592006938`, \
-1.2140336838958117`}, {-1.5081310158286114`, -1.2802354307785966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5032098763922002`, -1.2889390647785037`}, \
{-1.4673141972541315`, -1.350799457039071}, {-1.424230985015206, \
-1.4175333320759713`}, {-1.3787499864922808`, -1.4831288115348522`}, \
{-1.3303013064946478`, -1.5473893179493636`}, {-1.2789516111049455`, \
-1.610199435741108}, {-1.2739028913633146`, -1.6159060118522917`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2672767146736377`, -1.6233955901099228`}, \
{-1.2247675664058117`, -1.6714437493316847`}, {-1.1678158384798845`, \
-1.7310068431426957`}, {-1.1081630934098008`, -1.7887733015957419`}, \
{-1.0458759972781995`, -1.8446277091124248`}, {-0.981021216167718, \
-1.8984546501143444`}, {-0.9790728876541528, -1.8999472417252203`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.971134607532255, -1.9060286649719844`}, \
{-0.9136043471088339, -1.950101922372699}, {-0.8436531940600828, \
-1.9994307006224679`}, {-0.7712677334961905, -2.046345634730928}, \
{-0.6965479418918818, -2.090751374565354}, {-0.6361311367133808, \
-2.1235695501423115`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6273438517303672, -2.1283427694571246`}, \
{-0.6195937957218829, -2.1325525699930226`}, {-0.5405052714609195, \
-2.1716538708812085`}, {-0.459382345583717, -2.207959927097188}, \
{-0.3763249945650006, -2.241375388508237}, {-0.29128928278403277`, \
-2.271762660718575}, {-0.2586052958623222, -2.2819942788202194`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.24906198294688614`, -2.28498178256048}, \
{-0.20428360629115366`, -2.2989995108826244`}, {-0.11548643906770485`, \
-2.3230136311929637`}, {-0.02507625509502797, -2.343732713842172}, {
        0.06676847164553412, -2.361084451022828}, {
        0.14081476658579262`, -2.3721492143495797`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.15070495508386741`, -2.373627108619326}, {
        0.15986926717263988`, -2.37499653492751}, {
        0.25404765750494757`, -2.3853966577487973`}, {
        0.3491251686611144, -2.392212511679267}, {
        0.40555702553956163`, -2.394503185698135}, {
        0.46219705184428916`, -2.395475460846618}, {
        0.5190452475752971, -2.395129337124715}, {
        0.5497177881236338, -2.3942345178251534`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5597135354301302, -2.393942908866668}, {
        0.5761016127325852, -2.393464814532427}, {
        0.6333661473161538, -2.3904818930697544`}, {
        0.6908388513260028, -2.386180572736696}, {
        0.7485197247621321, -2.3805608535332525`}, {
        0.8064087676245419, -2.373622735459424}, {
        0.8643845424460292, -2.36533363199506}, {
        0.9223256117593912, -2.3556609566200106`}, {
        0.9567672158826616, -2.349084910964907}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.966589775481324, -2.3472094582380363`}, {
        0.9802319755646276, -2.3446047093342752`}, {
        1.0381036338617387`, -2.3321648901378547`}, {
        1.0959405866507244`, -2.318341499030748}, {
        1.1537428339315847`, -2.3031345360129554`}, {
        1.2115103757043197`, -2.286544001084478}, {
        1.2692432119689294`, -2.2685698942453145`}, {
        1.326810788274566, -2.2492021341052544`}, {
        1.3516060219070432`, -2.240209324207568}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3610068312184174`, -2.2367998104165445`}, {
        1.3840825501703824`, -2.2284306392740856`}, {
        1.4410584976563785`, -2.2062554097518086`}, {
        1.497738630732554, -2.182676445538423}, {
        1.5541229493989093`, -2.1576937466339294`}, {
        1.610211453655444, -2.1313073130383273`}, {
        1.6660041435021584`, -2.103517144751617}, {
        1.7215010189390525`, -2.074323241773798}, {
        1.7252462487005833`, -2.072354505898756}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.734097804268787, -2.0677015537151417`}, {
        1.7760965803821458`, -2.04562427074267}, {
        1.8302762837672781`, -2.0155701983468823`}, {
        1.8840725256995305`, -1.9841593086763576`}, {
        1.937388116363659, -1.9513967494613293`}, {
        1.9912472165545176`, -1.9129433965137452`}, {
        2.0444385572523616`, -1.873047175462322}, {
        2.070400735403507, -1.8525889809846636`}}]}, 
      {Arrowheads[{{0.017718733406797076`, 1.}}], 
       ArrowBox[{{2.078255189572044, -1.8463996716763194`}, {
        2.0968516306228935`, -1.8317456774931002`}, {
        2.1485232726108783`, -1.7890263722107334`}, {
        2.199064445643444, -1.7472331574141997`}, {
        2.248758030826877, -1.7041349017314662`}, {
        2.297604028161178, -1.659731605162533}, {
        2.3456024376463462`, -1.6140232677074}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.2152303616974011, -0.28042702973985895`}, \
{-0.15754067421779439`, -0.33291996871865415`}, {-0.08727224031167283, \
-0.3737875580006568}, {-0.006697413648318003, -0.3998654288555584}, {
        0.08110950542760084, -0.408808280089126}, {
        0.14844231091897536`, -0.40118359594850517`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15837880591860834`, -0.4000583994668768}, {
        0.17286788412808113`, -0.3984176740577724}, {
        0.2640826120709046, -0.3676725750419981}, {
        0.35011926326192977`, -0.31612699026035673`}, {
        0.4264617591248018, -0.24470332749055243`}, {
        0.4595110576247032, -0.20205095594377892`}, {
        0.4753905003686917, -0.17617116078048423`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4806203418056172, -0.16764773667132382`}, {
        0.4883528478723934, -0.15504555180039317`}, {
        0.5125722337087619, -0.10421603232839388`}, {
        0.5317543189746988, -0.050091314795779676`}, {0.5452825451588141, 
        0.0069487838614680705`}, {0.5527016836315417, 0.06640516644175322}, {
        0.5538388330565057, 0.127569995278656}, {0.5485210920973299, 
        0.18973543270575477`}, {0.5431599457064132, 
        0.21862101328873998`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5413351156974537, 0.22845310337368127`}, {
        0.5387303303242247, 0.24248755278309628`}, {0.5239075497126736, 
        0.2950856877094599}, {0.5041023536773369, 0.34705896303243766`}, {
        0.47936434563287394`, 0.3979365042996232}, {0.44958408954146667`, 
        0.4472331102134053}, {0.41477938092727934`, 0.49447504095233596`}, {
        0.37519067054794536`, 0.5392086142782517}, {0.3440489124337388, 
        0.5686845340901876}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.33678626604295386`, 0.5755586862126256}, {
        0.33105840916109813`, 0.5809801479529891}, {0.2824949245300712, 
        0.6192645439893916}, {0.22971504281363792`, 0.6535938369994969}, {
        0.17311296236259194`, 0.6836000436439332}, {0.11308288152772678`, 
        0.7089151805833288}, {0.049815151304472595`, 
        0.7290727605175513}, {-0.01633679942744882, 
        0.7436850993150766}, {-0.020254998902972457`, 
        0.7441902067777206}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.030172927423173318`, 
        0.7454687582503592}, {-0.08473415549080944, 
        0.7525024183894458}, {-0.15473810170837873`, 
        0.7552749391541987}, {-0.2509833633499199, 
        0.7489039864963659}, {-0.3480718337999697, 
        0.7304949081085088}, {-0.4239620170955642, 0.7062983599409237}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43348947146750094`, 
        0.7032606612740605}, {-0.4445279605718439, 
        0.6997411898258198}, {-0.4919934871049713, 
        0.6792945758639449}, {-0.5386695709461518, 
        0.6557230579743114}, {-0.5894801873197745, 
        0.6263639451188037}, {-0.6388663547753407, 
        0.5932093245201218}, {-0.6865453344856598, 
        0.5563111708500834}, {-0.7322401069338265, 
        0.51574120065281}, {-0.7637201703685159, 0.483752072602511}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7707342979616889, 
        0.4766245194384378}, {-0.7756877783178507, 
        0.4715909362712168}, {-0.8166222530635595, 
        0.42397157408016883`}, {-0.8547733760282061, 
        0.37301397796336894`}, {-0.8898808288020043, 
        0.3188687849877587}, {-0.9360548413670351, 
        0.23260672925337209`}, {-0.9741422771352948, 
        0.14028236985269524`}, {-0.975357669895924, 
        0.13622003193285484`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9782239893551652, 
        0.12663962417756724`}, {-1.0033422584464526`, 
        0.04268413232695828}, {-1.022953881092223, -0.059340394900142424`}, \
{-1.0324251330829455`, -0.1649768414745168}, {-1.031315634105116, \
-0.2673858130726401}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.030896799459371, -0.27737016730631997`}, \
{-1.0265250379423716`, -0.328027023170868}, {-1.0189737837244246`, \
-0.3830325855649804}, {-1.0085600535212644`, -0.4381258756081202}, \
{-0.9952533472741129, -0.49316157480336903`}, {-0.9790355592938721, \
-0.548020368434877}, {-0.9598939331773839, -0.6025682173267198}, \
{-0.9378179834570557, -0.6566385616319617}, {-0.9346274804180396, \
-0.6634536725811652}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.9303875876266182, -0.6725103446585484}, \
{-0.9128054663609809, -0.7100668383156166}, {-0.8848623798129401, \
-0.7626904811546478}, {-0.8540029634324002, -0.8143489207379685}, \
{-0.8202496985345138, -0.8648835844664433}, {-0.7836333081301199, \
-0.914137896552887}, {-0.7441824268579312, -0.961999061192125}, \
{-0.7073930219619015, -1.0023526134050271`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.700587098607199, -1.009676606945184}, \
{-0.6569664081631666, -1.0529653714970382`}, {-0.6093336311188752, \
-1.0957178608143137`}, {-0.5591178155651455, -1.13642555814824}, \
{-0.5064029912455846, -1.1749282695331764`}, {-0.4512803277255876, \
-1.2110722546869042`}, {-0.39384813439233607`, -1.244710227010628}, \
{-0.3830737565188886, -1.2503136863481568`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3742018523742462, -1.2549277211170198`}, \
{-0.3341858136884074, -1.2757389687137524`}, {-0.2723933364332817, \
-1.3040423230025537`}, {-0.20860849057086192`, -1.3294662845086633`}, \
{-0.14297342554508918`, -1.3518673138271116`}, {-0.07563465229994126, \
-1.3711123375163288`}, {-0.006743043279434091, -1.387078748098145}, {
        0.0012891203419983094`, -1.3885158068599466`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.011132813639236818`, -1.3902769718919359`}, {
        0.06354616757237669, -1.3996544040577894`}, {
        0.13507338481139763`, -1.4087376298438898`}, {
        0.20771379648447086`, -1.4142872903961565`}, {
        0.28131804772083163`, -1.4162469004167608`}, {
        0.3556863180491983, -1.4145114639053362`}, {
        0.4093227818922205, -1.4105604875667799`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4192957612560741, -1.4098258566334876`}, {
        0.43061860096395366`, -1.408991792107869}, {
        0.5059147039251473, -1.3996145035166974`}, {
        0.5813742483584943, -1.386322023870512}, {
        0.6567966696553744, -1.3690725861543553`}, {
        0.7319812171728336, -1.3478402305996224`}, {
        0.8081737552966216, -1.3213918297950122`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.817620773965762, -1.318112525255188}, {
        0.8303893067964545, -1.3136802372344856`}, {
        0.9276042846762083, -1.272501820345682}, {
        1.0231452202959228`, -1.2244406571364284`}, {
        1.1164945317742552`, -1.1693179763709753`}, {
        1.162206832435481, -1.139234999665231}, {
        1.1710461220115491`, -1.1329831009829054`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1792104010923126`, -1.1272086272327348`}, {
        1.2071888243775075`, -1.1074199025660105`}, {
        1.25138157613598, -1.0738998100827353`}, {
        1.294726156246543, -1.038701847224826}, {
        1.3371636332448442`, -1.0018531390017025`}, {
        1.3786350756665282`, -0.9633808104227848}, {
        1.4190815520472413`, -0.9233119864974939}, {
        1.4584441309226284`, -0.88167379223525}, {
        1.4766090342700653`, -0.8611285420906798}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.483232780192732, -0.8536368139888361}, {
        1.4966521571245488`, -0.8384589487079096}, {
        1.533639238649874, -0.7936726875100787}, {
        1.5693528387817708`, -0.7473608994353044}, {
        1.603740420803404, -0.6995694752771328}, {
        1.6367494479979408`, -0.6503443058291102}, {
        1.6683273836485468`, -0.5997312818847821}, {
        1.6984216910383882`, -0.5477762942376954}, {
        1.7103930003143533`, -0.5254539419645545}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7151191730376294`, -0.5166412640860796}, {
        1.7269798334506303`, -0.4945252336813965}, {
        1.753929924518954, -0.4400060663339747}, {
        1.779207114113216, -0.3842532763773225}, {
        1.8027694198708468`, -0.3273225317006892}, {
        1.8245748594292777`, -0.2692695001933249}, {
        1.8445814504259406`, -0.21014984974447937`}, {
        1.8627472104982656`, -0.15001924824340213`}, {
        1.8637819814943366`, -0.146137278809202}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.8663576299879914`, -0.13647466866301822`}, {
        1.8790301572836845`, -0.08893336357934331}, {
        1.893388308419628, -0.026947863641552106`}, {1.908113662453539, 
        0.049518391926908045`}, {1.9197833556664363`, 0.12730061167259465`}, {
        1.9283588499757809`, 0.2062241792517488}, {1.931843004719376, 
        0.2573655673270223}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.9325227080319014`, 0.26734244075545377`}, {
        1.9338016072990336`, 0.2861144783206123}, {1.9360730895536558`, 
        0.3667968925354268}, {1.9351347586571077`, 0.4480968055524339}, {
        1.9309480765268507`, 0.5298396010278754}, {1.9234745050803457`, 
        0.6118506626179925}, {1.9160453744963752`, 0.6663101836034845}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.9146937365619245`, 0.6762184162861657}, {
        1.909994140052624, 0.7106689851419401}, {1.8915410692069747`, 
        0.8094286664126026}, {1.868115292543398, 0.9081297064299799}, {
        1.839716810061894, 1.0067721051940723`}, {1.8201534219555722`, 
        1.064201077934058}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8169288491289424`, 1.073666918102039}, {
        1.8063017471293152`, 1.1048631274562064`}, {1.7678262291125135`, 
        1.2019100379677081`}, {1.7242902560114903`, 1.2979128367285782`}, {
        1.6756938278262448`, 1.3928715237388165`}, {1.650526048162849, 
        1.4367261399919788`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.6455485657834348`, 1.4453993556103422`}, {
        1.6220918021518098`, 1.4862725427315}, {1.5635390365832187`, 
        1.5776023374397061`}, {1.5324061263386148`, 1.6224905256871305`}, {
        1.5000355311204714`, 1.6668609078634349`}, {1.4664272509287892`, 
        1.7107134839686202`}, {1.4315812857635681`, 1.7540482540026863`}, {
        1.4163405730820744`, 1.7725597575436798`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{1.4099845082899278`, 1.78027988969009}, {
        1.3636568185333073`, 1.836549908743534}, {1.291284928602848, 
        1.9166718685907946`}, {1.2494219676084475`, 1.9559437543940135`}, {
        1.2064098593770232`, 1.9943759361946614`}, {1.162303003075748, 
        2.031875215527047}, {1.126414203307418, 2.0609209017537564`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1186409971355598`, 2.0672119482334597`}, {
        1.1170832656488976`, 2.0684726585464017`}, {1.0732733393700171`, 
        2.1039295805270464`}, {1.0284889906977888`, 2.138427658683751}, {
        0.9827302196322122, 2.1719668930165157`}, {0.9359970261732875, 
        2.2045472835253395`}, {0.8882894103210149, 2.236168830210224}, {
        0.8396073720753943, 2.266831533071168}, {0.7910071409999961, 
        2.295903569105418}}]}, 
      {Arrowheads[{{0.014230264992898903`, 1.}}], 
       ArrowBox[{{0.7823249990003422, 2.3008649031863957`}, {
        0.7393200284041086, 2.325280407321235}, {0.68779746510388, 
        2.3529627961509783`}, {0.6354659636611758, 2.3794787760380207`}, {
        0.5823255240759962, 2.4048283469823617`}, {0.5283761463483412, 
        2.429011508984002}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.6372851535830713, -0.9366181491302348}, \
{-0.5980603152221183, -0.974766884407405}, {-0.5566797130249603, \
-1.0113900280599104`}, {-0.5132052237606559, -1.0463608759209544`}, \
{-0.4677034973010914, -1.0795572829877884`}, {-0.42024595662097775`, \
-1.1108616634217165`}, {-0.3709087977978522, -1.1401609905480923`}, \
{-0.3197729900120796, -1.167346796856319}, {-0.314566046820035, \
-1.169806817363903}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3055243558536245, -1.1740785646022038`}, \
{-0.2669242755468488, -1.1923151739998508`}, {-0.2124378361314413, \
-1.2149850894252685`}, {-0.15640153194988188`, -1.2352706265033235`}, \
{-0.09892605592917464, -1.2530688548501279`}, {-0.04012523850909802, \
-1.2682833570196124`}, {0.019883952357793055`, -1.2808242285035258`}, {
        0.07566162859180131, -1.2897561936759396`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.08556520076337659, -1.2911213846222274`}, {
        0.1430438950579348, -1.2975580260707276`}, {
        0.20594502342220536`, -1.301603707826606}, {
        0.26958132637836907`, -1.3026923480654473`}, {
        0.33383276725911615`, -1.3007719735580727`}, {
        0.3985454930310065, -1.2957840767989501`}, {
        0.46356529161001847`, -1.287677844854856}, {
        0.4840389049929258, -1.2841381472294586`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.4938927182284156, -1.2824345144286218`}, {
        0.5287375918615465, -1.2764101593648776`}, {
        0.5939074636003985, -1.2619455965404105`}, {
        0.6589196175908014, -1.2442564271651604`}, {
        0.7236184055463978, -1.223322616595142}, {
        0.7878711498081731, -1.1991351055949786`}, {
        0.8515327859214652, -1.1716908380482214`}, {
        0.8735731424538011, -1.1609329688091858`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.8825597862227919, -1.1565465997219726`}, {
        0.9144304132048016, -1.140990588314647}, {
        0.9763932604251024, -1.1070431752822139`}, {
        1.0372526857976856`, -1.0698654623670616`}, {
        1.0968421769862637`, -1.0294823575135101`}, {
        1.1549973511029425`, -0.9859268131940623}, {
        1.211555954708226, -0.9392398264094005}, {
        1.214951736514307, -0.9361575337792243}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.2223563248077838`, -0.9294365165791194}, {
        1.2663983419524778`, -0.8894603365371352}, {
        1.3193861277037449`, -0.836640535703261}, {
        1.3703353820229658`, -0.7808525586512074}, {
        1.4190686220878967`, -0.7221755070897842}, {
        1.4654148121931112`, -0.6606954496931845}, {
        1.4862021081280807`, -0.6302273423100171}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.4918379906969637`, -0.6219667837532509}, {
        1.5092093637500021`, -0.59650542210098}, {
        1.5502941352867807`, -0.5297054269181232}, {
        1.5885174324484752`, -0.4604024337149499}, {
        1.62377243814008, -0.38868699050826255`}, {
        1.6559389695096074`, -0.3146686703611058}, {
        1.674036372751666, -0.2669974137978723}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.6775855213678275`, -0.2576484275372984}, {
        1.6848580286532926`, -0.23849155977973654`}, {
        1.710381163999459, -0.16030421746043888`}, {
        1.7323704703085165`, -0.08025967428952896}, {1.7506985886729625`, 
        0.0014845666566467575`}, {1.7652487065173819`, 0.08476653011171281}, {
        1.7709907757889374`, 0.13034046095674662`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7722408387262243`, 0.14026202044368322`}, {
        1.7759145575984463`, 0.1694197686192621}, {1.782670772521941, 
        0.2553157475682215}, {1.7854662586258496`, 0.342299608317033}, {
        1.7841776123046342`, 0.4301620998813466}, {1.7786994803399938`, 
        0.5186940201572225}, {1.7764277700346847`, 0.5394183806961363}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7753381421305456`, 0.5493588389869055}, {
        1.7689445599008635`, 0.607686215921128}, {1.754843598543416, 
        0.6969295828299383}, {1.7363453942110603`, 0.786215065420939}, {
        1.7134167952344417`, 0.8753336571118225}, {1.693685896523078, 
        0.9401680647325019}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.690716308565931, 0.9497159004683567}, {1.665976251686228, 
        1.0208146472289037`}, {1.6376992376322033`, 1.0929027752871503`}, {
        1.6064319704925805`, 1.1643951686038267`}, {1.5722169567191269`, 
        1.2351720686864336`}, {1.5351021628644153`, 1.305114404293296}, {
        1.5293579637853123`, 1.3150312560612543`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.5243457296034812`, 1.3236844351595096`}, {
        1.4951410155818237`, 1.3741037914335648`}, {1.4514605444214157`, 
        1.4419052425597498`}, {1.4053479313143875`, 1.5085556637319988`}, {
        1.3562293738340974`, 1.573857723020941}, {1.3041719488859378`, 
        1.6376947545627898`}, {1.2936210286583365`, 1.6496528919245874`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.287004945364141, 1.6571513878967319`}, {
        1.2492427333752991`, 1.6999500924937574`}, {1.1915088042075739`, 
        1.7605070709500577`}, {1.1310372382881528`, 1.819249024067903}, {
        1.0678951125224279`, 1.8760592859835068`}, {1.00214950381579, 
        1.930821190833082}, {0.9986237661887555, 1.9335326752685014`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{0.9906968511367716, 1.9396289050672075`}, {
        0.933805876060161, 1.9833811662261924`}, {0.8628920978796325, 
        2.0335990603275476`}, {0.7895088532778529, 2.081378338106078}, {
        0.7137568262584698, 2.1266224645307146`}, {0.6562416349812311, 
        2.1580356752383247`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.647465329090993, 2.162829051388907}, {0.6357367008251317, 
        2.169234904570387}, {0.5555491609814869, 2.209119123194025}, {
        0.47329489073118336`, 2.2461785853705605`}, {0.38907457407786916`, 
        2.280316756068923}, {0.3028437462698598, 2.311395152818424}, {
        0.27965192238949665`, 2.318727385651538}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.2701170996318654, 2.3217418764842583`}, {
        0.21461072392104627`, 2.33929054676278}, {0.12455536308344001`, 
        2.363929283292534}, {0.03285751980905194, 
        2.3852377077982254`}, {-0.060302949850106154`, 
        2.403142165670397}, {-0.11903573214898792`, 2.4121139910236598`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.12892106209683465`, 
        2.4136240412950762`}, {-0.15474618984202249`, 
        2.4175690022995875`}, {-0.2502923441146861, 
        2.4284445630763396`}, {-0.34676155661608554`, 
        2.435695193391194}, {-0.40398849370346135`, 
        2.4382213806592627`}, {-0.4614309419158406, 
        2.4394157439614763`}, {-0.5190889012532234, 
        2.4392782832978344`}, {-0.5276613588129198, 2.4390606467878957`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5376581376481309, 
        2.4388068497826407`}, {-0.5769623717156096, 
        2.437808998668338}, {-0.6350513533029993, 
        2.4350078900729852`}, {-0.6933558460153926, 
        2.430874957511778}, {-0.7518758498527893, 
        2.4254102009847154`}, {-0.8106113648151896, 
        2.4186136204917976`}, {-0.869440190915206, 
        2.4104518844370366`}, {-0.9282401281654513, 
        2.400891661224444}, {-0.9353273999994172, 2.3995701370818825`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.945157960905591, 
        2.397737087090746}, {-0.9870111765659256, 
        2.3899329508540204`}, {-1.0457533361166287`, 
        2.3775757533257655`}, {-1.1044666068175606`, 
        2.363820068639679}, {-1.1631509886687217`, 
        2.348665896795761}, {-1.2218064816701113`, 
        2.3321132377940126`}, {-1.28043308582173, 
        2.314162091634432}, {-1.3319095438863877`, 2.2971162677950945`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3413826098650694`, 
        2.2939146319113464`}, {-1.3970738206050315`, 
        2.2740212081343425`}, {-1.4549564994940587`, 
        2.2518206883669745`}, {-1.5125473860480034`, 
        2.2282001165880576`}, {-1.5698464802668657`, 
        2.203159492797592}, {-1.6268537821506457`, 
        2.176698816995577}, {-1.6835692916993432`, 
        2.1488180891820137`}, {-1.7084565738130093`, 
        2.1358941485118654`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.717331286930609, 
        2.1312855188803694`}, {-1.7399930089129583`, 
        2.1195173093569015`}, {-1.7953072094395397`, 
        2.090810716524266}, {-1.8502113577429942`, 
        2.060742086644723}, {-1.904737749101474, 
        2.0293098709072286`}, {-1.9587894976805227`, 
        1.996518715744915}, {-2.013404235026105, 
        1.958035137190397}, {-2.058880556193029, 1.9243766633439632`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.0669184683918322`, 
        1.9184275484951538`}, {-2.0673589270263233`, 
        1.9181015510299009`}, {-2.1205434231810205`, 
        1.8767545759667181`}, {-2.1729944403235817`, 
        1.8339820057664182`}, {-2.224540234418875, 
        1.7919343829652947`}, {-2.275237791302834, 
        1.7485607516741775`}, {-2.3250871109754585`, 
        1.7038611118930669`}, {-2.3718895575201966`, 1.6599005943963983`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.487159513781295, -1.1310976383068756`}, \
{-2.471972006446341, -1.192485426955094}, {-2.455322969902396, \
-1.2538248300408745`}, {-2.43721240414946, -1.3151158475642173`}, \
{-2.417640309187534, -1.376358479525122}, {-2.396597101120562, \
-1.4374156062056047`}, {-2.374073196052488, -1.4981501078876815`}, \
{-2.3682980128666205`, -1.5126843898326539`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.364605353636635, -1.5219776275790589`}, \
{-2.3500685939833135`, -1.5585619845713523`}, {-2.3245832949130376`, \
-1.6186512362566168`}, {-2.2976172988416605`, -1.6784178629434756`}, \
{-2.2691706057691823`, -1.7378618646319282`}, {-2.239243215695603, \
-1.7969832413219748`}, {-2.207835128620922, -1.8557819930136152`}, \
{-2.193248085710886, -1.8830999819201746`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.1885378173267744`, -1.8919211707147554`}, \
{-2.1773479046042827`, -1.9128771597732415`}, {-2.145468814801469, \
-1.9695356133316808`}, {-2.1121958912495025`, -2.025790035286129}, \
{-2.0775350378373196`, -2.0815423808449993`}, {-2.037058657384927, \
-2.137780569036707}, {-1.9951058042931895`, -2.19332897178127}, \
{-1.969436896798332, -2.225715949802381}}]}, 
      {Arrowheads[{{0.0044355913101495215`, 1.}}], 
       ArrowBox[{{-1.9632255222821975`, -2.23355296623852}, \
{-1.951714375054836, -2.2480768127374415`}, {-1.9068717375056239`, \
-2.302061017352304}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{1.6956016088787649`, -2.4920063141281146`}, {
        1.7588781190773355`, -2.4642852943988105`}, {
        1.8218347776461206`, -2.435016061227807}, {
        1.8844715845851197`, -2.4041986146151024`}, {
        1.9467885398943334`, -2.3718329545606984`}, {
        2.0065904297151334`, -2.3407745476310517`}, {
        2.054030861682845, -2.3148213731582823`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{2.0628038576838685`, -2.3100219418205064`}, {
        2.0659640156573658`, -2.308293118370848}, {
        2.124941892208798, -2.2743870517484837`}, {
        2.1834262759061285`, -2.2390611928587703`}, {
        2.2424334109732356`, -2.1978654003084186`}, {
        2.3007627819945125`, -2.1551618967709865`}, {
        2.358304088494215, -2.110986378503709}, {
        2.392006775881207, -2.083889260772134}}]}, 
      {Arrowheads[{{0.0009812021400578618, 1.}}], 
       ArrowBox[{{2.4022654614737142`, -2.0673090153189744`}, {
        2.412628852178875, -2.0673090153189744`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.6887833911683741, -0.2967896813885488}, {
        0.7250200114667311, -0.23862691375485273`}, {
        0.7564476053368271, -0.17634939179657136`}, {
        0.7827157578631752, -0.11042378838370964`}, {
        0.8034740541302889, -0.041316776386271924`}, {0.8182457394341451, 
        0.030708017663463802`}, {0.823299599997432, 0.07549081381405}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.8244210088523902, 0.0854277369887566}, {0.82665513090155, 
        0.10522453016303868`}, {0.8285034213632619, 0.18152243263717702`}, {
        0.8235918036500399, 0.25889139661060323`}, {0.8065596755261463, 
        0.36065707028434024`}, {0.7772003183830122, 0.4620891769381855}, {
        0.7704406320627316, 0.478182962638404}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.7665681629162953, 0.48740272308593724`}, {
        0.7353513182114847, 0.5617252855706661}, {0.7093440203599873, 
        0.610317761846529}, {0.6802307028526737, 0.65784486207625}, {
        0.649201034920911, 0.703238189174807}, {0.6152676838552481, 
        0.7473001341309962}, {0.5784786486306752, 0.7898485645554936}, {
        0.5494676640465628, 0.8197900558481754}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.5425090728291919, 0.826971838932447}, {0.5388922869151038,
         0.8307046306837986}, {0.4965806998853342, 0.8696958601336258}, {
        0.4516227553614911, 0.9066497789151787}, {0.4041037424176379, 
        0.9413935956395807}, {0.3541209666898043, 0.9737593173423175}, {
        0.2664873675777471, 1.0215816319258253`}, {0.21061098687062474`, 
        1.045607586299419}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.20142424193368938`, 1.049557740405741}, {
        0.17300072131560867`, 1.0617794018817472`}, {0.07434993077139634, 
        1.093642357971044}, {-0.028725990957929305`, 
        1.1165395142795642`}, {-0.08169569980893304, 
        1.1244628444789193`}, {-0.1354970425107005, 
        1.129962483440698}, {-0.18757993411442933`, 1.1328389306430966`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.1975759612602702, 
        1.1330367827192214`}, {-0.2451203706199489, 
        1.1334361942376614`}, {-0.30070192152099023`, 
        1.1312987223259372`}, {-0.35663423725991406`, 
        1.1265144716828184`}, {-0.4127937955003478, 
        1.1190433733948733`}, {-0.4690557518726557, 
        1.1088516397326793`}, {-0.5253975762272556, 
        1.095895643540885}, {-0.5816243335870999, 
        1.0801683808856597`}, {-0.5917501330038012, 1.076818219383219}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6012440037988913, 
        1.0736771340093179`}, {-0.6375894515382434, 
        1.061652096301726}, {-0.6931476814119797, 
        1.0403357764273762`}, {-0.7481550982848406, 
        1.0162151500044718`}, {-0.8024691009785972, 
        0.989292687878444}, {-0.8559484120602594, 
        0.959577602998293}, {-0.9084530778420762, 
        0.9270858504165875}, {-0.9567854249417501, 0.8939495404383341}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9648620655767992, 
        0.8880574425878481}, {-1.0100570681856211`, 
        0.8538630069023335}, {-1.0588788003185765`, 
        0.8131979482009242}, {-1.1061835220627578`, 
        0.7698870601933988}, {-1.1518280089208175`, 
        0.7239809542731646}, {-1.195672557815266, 
        0.6755367737543112}, {-1.2375809870884742`, 
        0.6246181938716105}, {-1.2493291823503916`, 0.6088940008216172}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.255314516050482, 
        0.6008830220737635}, {-1.2774206365026712`, 
        0.5712954217805164}, {-1.3150953685156155`, 
        0.5156280210299681}, {-1.3504955530139118`, 
        0.45769094202805405`}, {-1.3834762131349023`, 
        0.3975858960577989}, {-1.4138994135718592`, 
        0.33541929426667616`}, {-1.4416342605739856`, 
        0.27130224766660677`}, {-1.4488183073587473`, 
        0.2522914232760456}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.4523532516492226`, 
        0.2429370569766517}, {-1.4665569019464146`, 
        0.2053505671339601}, {-1.4885505270502102`, 
        0.13768476340955327`}, {-1.5075053668023675`, 
        0.0684300470986504}, {-1.523347286587774, -0.002311853858601512}, \
{-1.5359944521126367`, -0.07441998199791965}, {-1.5449914426060096`, \
-0.14501319343441457`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.545916358628699, -0.15496811727086887`}, \
{-1.5512807365105719`, -0.22209782575169612`}, {-1.5537331921149145`, \
-0.297344760010722}, {-1.5526175669212539`, -0.3733123587409503}, \
{-1.5478657579615753`, -0.44983499694476237`}, {-1.5394197537344039`, \
-0.5267453558965787}, {-1.5351720164720308`, -0.5537643568784644}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.5336189622514704`, -0.5636430218990023}, \
{-1.5272857552526664`, -0.6039272757380868}, {-1.5114521525889324`, \
-0.6812356544339186}, {-1.4918536847148292`, -0.7584614476085884}, \
{-1.4684409549802961`, -0.8353995547688062}, {-1.4411804311135852`, \
-0.9118488193034808}, {-1.4263416425974305`, -0.9479676507589652}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.422541518731724, -0.9572174647357589}, \
{-1.410054445221259, -0.9876120284837169}, {-1.3750611937881927`, \
-1.0624959134628154`}, {-1.3362147376775744`, -1.1363111492762739`}, \
{-1.3003594911354173`, -1.1977292054087987`}, {-1.2617382404552249`, \
-1.2581414798506332`}, {-1.2284315434484232`, -1.3059299888460232`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2227136683217055`, -1.3141340064005669`}, \
{-1.2204093065328394`, -1.3174403088553968`}, {-1.176436178431811, \
-1.3755200342436689`}, {-1.1298875133833992`, -1.43227700340299}, \
{-1.080837136786573, -1.4876095692878608`}, {-1.0293640422080084`, \
-1.5414180904197448`}, {-0.9746703574264746, -1.5932626474590519`}, \
{-0.9552520571063271, -1.6104764208404787`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.947768989067409, -1.6171099487649636`}, \
{-0.9180028665704909, -1.6434967734951442`}, {-0.8588468699411993, \
-1.6917904375448374`}, {-0.7972942815245476, -1.7380490120469965`}, \
{-0.733437015306484, -1.782177869440487}, {-0.6673669852729575, \
-1.824082382164174}, {-0.6232608202510999, -1.8496864861874582`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.6146124261410386, -1.854706972151691}, \
{-0.599176105409917, -1.863667922656922}, {-0.5289562897033107, \
-1.9008398633575965`}, {-0.45679945213908646`, -1.9355035767050632`}, \
{-0.3827472373089276, -1.9675133738492283`}, {-0.30685956958425026`, \
-1.9967421336814384`}, {-0.24943488216935564`, -2.0162633151835}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.23996699332319762`, -2.019481867776949}, \
{-0.2292557826206017, -2.0231230802527174`}, {-0.15005521007353037`, \
-2.0465894376140894`}, {-0.06937718559858434, -2.067074429816579}, {
        0.012658957148688353`, -2.08451128091121}, {
        0.09593388451273986, -2.098833214949006}, {
        0.14994390208166825`, -2.1059626544424828`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.15985790149267232`, -2.107271323873092}, {
        0.18032826283802153`, -2.1099734559809926`}, {
        0.2658531554461584, -2.117785864491934}, {
        0.3524722085761669, -2.1221531604452357`}, {
        0.4399949629485864, -2.1230518571098806`}, {
        0.5282309592839565, -2.120458467754853}, {
        0.5590984797972454, -2.118333962267085}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5690748781346858, -2.117647321012342}, {
        0.6169897383028164, -2.1143495056491353`}, {
        0.7060808407257059, -2.104701484061712}, {
        0.795313807273164, -2.0914909162615656`}, {
        0.8844981786657306, -2.07469431551768}, {
        0.9382838108511147, -2.0627753319121225`}, {
        0.9638250343013456, -2.056455378002018}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.973532275320545, -2.054053405521915}, {
        0.9919256066780664, -2.0495021354287126`}, {
        1.0454235661465858`, -2.03487472606745}, {
        1.0987776892566732`, -2.018893103828335}, {
        1.1519879760083278`, -2.001557268711367}, {
        1.2050544264015504`, -1.9828672207165465`}, {
        1.2579770404363408`, -1.9628229598438742`}, {
        1.3107558181126988`, -1.941424486093349}, {
        1.351243748034018, -1.923878362422681}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.360419192334713, -1.9199020297046046`}, {
        1.3632566293308082`, -1.91867237878054}, {
        1.4153453439908528`, -1.894567217221016}, {
        1.4670219620928326`, -1.869109001414777}, {
        1.5182864836367476`, -1.842297731361823}, {
        1.569138908622598, -1.8141334070621542`}, {
        1.6195792370503834`, -1.7846160285157704`}, {
        1.6696074689201037`, -1.7537455957226713`}, {
        1.7104437545031204`, -1.7272242330455312`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.7188302754957911`, -1.7217775583132295`}, {
        1.7192236042317592`, -1.7215221086828574`}, {
        1.768290360981491, -1.6879729563109}, {
        1.8166704571654402`, -1.653125527521371}, {
        1.8643638927836066`, -1.61697982231427}, {
        1.91137066783599, -1.579535840689597}, {
        1.9576907823225915`, -1.5407935826473527`}, {
        2.00332423624341, -1.500753048187536}, {
        2.0323468933584867`, -1.4740601065095278`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.0397072020283638`, -1.4672906267448682`}, {
        2.048271029598445, -1.4594142373101475`}, {
        2.092531162387698, -1.4167771500151873`}, {
        2.169608895516802, -1.3408061332941805`}, {
        2.207217572411441, -1.301359223198548}, {
        2.244143866400323, -1.2609600071650873`}, {
        2.2801345314749364`, -1.2161118269075195`}, {
        2.3117549160308326`, -1.1748990813535514`}}]}, 
      {Arrowheads[{{0.0055985707247047534`, 1.}}], 
       ArrowBox[{{2.31776799452296, -1.1669096523362146`}, {
        2.3495441947443156`, -1.123540194911666}, {
        2.382915029445379, -1.0758493598757939`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.09588846559184347, 0.8329915145533373}, {
        0.02264095506440067, 0.8529471663006506}, {-0.05356629185049227, 
        0.8665725212974629}, {-0.1320275410691691, 
        0.8736187226763111}, {-0.21203705850796367`, 
        0.8738369135697325}, {-0.2994848982871876, 0.8651300871450203}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.30943569691757006`, 
        0.8641393265192491}, {-0.3188386886592803, 
        0.8632031088016385}, {-0.3725216790967594, 
        0.8531080429836588}, {-0.4261476714466911, 
        0.8397683290585168}, {-0.4795248265276543, 
        0.8231610392167386}, {-0.5324613051582301, 
        0.8032632456488493}, {-0.5847009743553716, 
        0.7796573230574761}, {-0.6360526185479716, 
        0.7527580318283927}, {-0.6812274419860039, 0.72520038032918}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.6897643932967431, 
        0.7199926493148063}, {-0.7117496235626016, 
        0.7065811677043126}, {-0.7844127447940255, 
        0.6530365134196151}, {-0.8533043169578355, 
        0.5922986729960933}, {-0.9177156967068955, 
        0.5246045144283649}, {-0.9770132581094895, 
        0.45023218645281216`}, {-0.9789945260087808, 0.4472457638291048}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.984522813809974, 
        0.4389128151320841}, {-1.0305435856433418`, 
        0.36954436969731796`}, {-1.0776287807794795`, 
        0.28299041782729123`}, {-1.1176424953236614`, 
        0.19107167098003836`}, {-1.1363917220315298`, 
        0.13856168111177974`}, {-1.1527738475621716`, 
        0.08467934078313086}, {-1.154217159091869, 0.07896195517556695}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.156664798595856, 
        0.06926612819389477}, {-1.1666936516023634`, 
        0.029538863040131036`}, {-1.1780625873389134`, \
-0.026742833603274258`}, {-1.1867987814586631`, -0.08404612516523347}, \
{-1.1928270341484861`, -0.1422486821959889}, {-1.1960788190952885`, \
-0.20122546977787692`}, {-1.1964922834860081`, -0.2608487475253282}, \
{-1.1940221626818384`, -0.3210145242607444}, {-1.1934701494986275`, \
-0.3272110796052861}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.192582824633492, -0.3371716345388083}, \
{-1.188624753978628, -0.3816024644835012}, {-1.1802513508892851`, \
-0.44245836949570266`}, {-1.1688609779920007`, -0.5034281569636394}, \
{-1.1544203909302482`, -0.5643578609177897}, {-1.1369040764127845`, \
-0.6250936317528195}, {-1.1162942522136485`, -0.6854817362275825}, \
{-1.1007202939304903`, -0.7248128926201706}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.097038710836692, -0.7341105238197535}, \
{-1.0925808671721626`, -0.7453685574651189}, {-1.065762522863047, \
-0.804626562462596}, {-1.0358450767541565`, -0.8631149468873553}, \
{-1.002841031856048, -0.9206624388147766}, {-0.9667707205560401, \
-0.9771006525521542}, {-0.9276623046182138, -1.0322640886386965`}, \
{-0.8929860115954009, -1.0765052822677939`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8868171108930811, -1.084375775525838}, \
{-0.8855517751834112, -1.085990133845526}, {-0.8404829527692366, \
-1.1381190611756802`}, {-0.7925074872700554, -1.188494029864111}, \
{-0.7416718757613803, -1.2369988261421578`}, {-0.6880371377385591, \
-1.283500665012279}, {-0.6316874122152022, -1.3278251974751338`}, \
{-0.5937805845498194, -1.3548085653021007`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5856338135390537, -1.3606077136963177`}, \
{-0.5727132828141499, -1.3698049864448387`}, {-0.5112117777674723, \
-1.4092795067489683`}, {-0.4472863699164687, -1.4460951451285555`}, \
{-0.381046976711668, -1.4801052002380921`}, {-0.31260996021282866`, \
-1.5111698826455275`}, {-0.2420709448397877, -1.539190793327598}, \
{-0.23093443457383486`, -1.5430093610192144`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.22147506257218888`, -1.5462528593365372`}, \
{-0.16954601358117402`, -1.5640586695946836`}, {-0.0951897086838456, \
-1.5856305526650154`}, {-0.019160117563980394`, -1.6037740733764498`}, {
        0.05838112719292354, -1.6183674521864706`}, {
        0.13726884783204796`, -1.6292994991721874`}, {
        0.1681175954776956, -1.6320621015014027`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.17807773623674972`, -1.6329540634175346`}, {
        0.21733432142925463`, -1.6364696140303374`}, {
        0.298405279891086, -1.6397877860772838`}, {
        0.38034577426357224`, -1.6392208071273227`}, {
        0.4629957581575503, -1.634722233308228}, {
        0.5461446887174931, -1.626201781866284}, {
        0.5769429209372391, -1.621544623713043}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.5868305149611452, -1.6200494700692945`}, {
        0.629582730111494, -1.6135846890410868`}, {
        0.7131007535312647, -1.5968117100655457`}, {
        0.7964903371921368, -1.5758391191658827`}, {
        0.8795437663330624, -1.550638709561632}, {
        0.9620540332166126, -1.5211977934656413`}, {
        0.9724346229845245, -1.517014642169293}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.9817098340593646, -1.5132769343801307`}, {
        1.0167336059709768`, -1.4991631180989062`}, {
        1.071025871845557, -1.475207707922983}, {
        1.1248675157056849`, -1.449349894642751}, {
        1.178195578659701, -1.4216100845040915`}, {
        1.2309474580589561`, -1.3920107582938868`}, {
        1.28306090749781, -1.3605764713400206`}, {
        1.334474036813631, -1.3273338535113788`}, {
        1.3348707618940423`, -1.3270564363735842`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3430658985095114`, -1.3213258399077878`}, {
        1.3850645132799164`, -1.2919575542202357`}, {
        1.434850942810624, -1.25494296316264}, {
        1.483730511827456, -1.2160783973099125`}, {
        1.531642220775304, -1.1753956728834445`}, {
        1.578525070099058, -1.1329266061046253`}, {
        1.6243180602436111`, -1.088703013194845}, {
        1.6483544616412897`, -1.0639644144223883`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6553230075264393`, -1.0567922900337177`}, {
        1.6689601916538523`, -1.0427567103754927`}, {
        1.7123904647746733`, -0.9951195138679598}, {
        1.7545478800509657`, -0.9458232398936349}, {
        1.7953579735654837`, -0.8948650233360486}, {
        1.8347511775326684`, -0.842254610474317}, {
        1.8726738365949391`, -0.7880427346232075}, {
        1.902154100327097, -0.7428788356149192}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.907620100947434, -0.7345048976393623}, {
        1.9090722953947168`, -0.7322801290974876}, {
        1.9438928985744206`, -0.6750175272119255}, {
        1.9770819907764703`, -0.6163056622812898}, {
        2.008585916643286, -0.5561952676203478}, {
        2.0383510208172875`, -0.4947370765438668}, {
        2.0663033242240205`, -0.43196498237477365`}, {
        2.0881777460910413`, -0.3782322545452991}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.091948247577174, -0.36897032609906966`}, {
        2.0923762382315307`, -0.3679190020693912}, {
        2.1165271931459873`, -0.30265905439258284`}, {
        2.138713619273559, -0.23624505810921195`}, {
        2.158892946920417, -0.1687369319841421}, {
        2.1770226063927285`, -0.10019459478223666`}, {
        2.193060027996665, -0.030677965268358774`}, {2.2020759122615647`, 
        0.01499673808977818}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2040124783026487`, 0.024807431845498048`}, {
        2.2069626420383943`, 0.03975303779262757}, {2.2210832840928645`, 
        0.12818853251798118`}, {2.231694869355575, 0.21800360935358848`}, {
        2.238759518154512, 0.3090018910838745}, {2.242239350817663, 
        0.40098700049326363`}, {2.2422063243258017`, 0.4224344583424254}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2421909255531656`, 0.4324344464863084}, {
        2.2420964876730136`, 0.4937625603661805}, {2.2382930490485506`, 
        0.5871321934870499}, {2.23079115527226, 0.6808995226402962}, {
        2.2195529266721277`, 0.7748681706103441}, {2.2110573239833333`, 
        0.830745540063971}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.2093273334644734`, 0.8405946027452809}, {
        2.200994226128366, 0.887663892009499}, {2.1896132181452406`, 
        0.9439816530482973}, {2.176831105021285, 1.0002460143132426`}, {
        2.1626478867565004`, 1.056456975804335}, {2.147063563350886, 
        1.1126145375215744`}, {2.130078134804442, 1.168718699464961}, {
        2.111691601117168, 1.2247694616344944`}, {2.110628181720461, 
        1.2277701575966442`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{2.107287832239936, 1.2371957644921154`}, {2.091895186873653,
         1.2806298498026065`}, {2.070680116658485, 1.3361628897417286`}, {
        2.0480463904716637`, 1.3913685814518606`}, {2.0239940083131893`, 
        1.4462469249330023`}, {1.998522970183062, 1.5007979201851542`}, {
        1.9716332760812818`, 1.5550215672083163`}, {1.9464494057976565`, 
        1.6029691654992433`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.9417330642876187`, 1.611786448249494}, {
        1.9135979199627617`, 1.6624868165676698`}, {1.8824705036353255`, 
        1.7155863850064161`}, {1.8499609227148432`, 1.768074537421282}, {
        1.8160691772013149`, 1.8199512738122672`}, {1.7807952670947398`, 
        1.8712165941793715`}, {1.7441391923951188`, 1.9218704985225954`}, {
        1.724771959400744, 1.947349714935376}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.7187205269180015`, 1.9553108809873314`}, {
        1.7061009531024516`, 1.971912986841939}, {1.6666805492167382`, 
        2.0213440591374017`}, {1.6258779807379784`, 2.0701637154089836`}, {
        1.5884429395216253`, 2.1149118975600274`}, {1.5498746340763871`, 
        2.15902604394857}, {1.510165476027, 2.202533918424032}, {
        1.4693382304992535`, 2.2453522294381507`}, {1.4565991885686693`, 
        2.257041380473121}}]}, 
      {Arrowheads[{{0.0111884516294618, 1.}}], 
       ArrowBox[{{1.449231017741095, 2.2638023019085236`}, {
        1.4233835149082767`, 2.287519577205676}, {1.376269339464789, 
        2.3288210818497306`}, {1.3280477856140218`, 2.369168425209289}, {
        1.278701492874232, 2.4085910466713605`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7624958873600631`, 
        2.490665420589773}, {-1.8262331874620434`, 
        2.4613313993883748`}, {-1.8896156099242813`, 
        2.430425954414734}, {-1.9526431547467773`, 
        2.3979490856688503`}, {-2.0153158219295313`, 
        2.363900793150725}, {-2.0753384157560295`, 
        2.3312916847080363`}, {-2.1176923850485387`, 2.307082070286456}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.1263741677231542`, 
        2.3021195457685577`}, {-2.1348993709914272`, 
        2.2972465223556853`}, {-2.1940317801827147`, 
        2.261763048397995}, {-2.252636365688921, 
        2.2248480359219966`}, {-2.311662704147965, 
        2.181962949696726}, {-2.3699721792747495`, 
        2.1375603253873487`}, {-2.4274533468278205`, 
        2.091678579885938}, {-2.4521292619542625`, 2.071057861041371}}]}, 
      {Arrowheads[{{0.0015860385100881342`, 1.}}], 
       ArrowBox[{{-2.4638296535709174`, 
        2.0476700950447246`}, {-2.4801163817574294`, 2.0476700950447246`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000014`, 1.}}], 
       ArrowBox[{{2.4037345148372182`, 2.0271102687954095`}, {
        2.3712048301831965`, 2.0877523623545287`}, {2.337232862882375, 
        2.1479393335498655`}, {2.3018165297713864`, 2.2077042142423515`}, {
        2.264962080340331, 2.2669479088491933`}, {2.222134957202308, 
        2.3266375784021758`}, {2.1924664497439403`, 2.3660921423381716`}}]}, 
      {Arrowheads[{{0.008068443753518293, 1.}}], 
       ArrowBox[{{2.186456395884165, 2.374084592062918}, {2.177783440820425, 
        2.3856182919147404`}, {2.1319450949474277`, 2.4437787601084087`}, {
        2.085561192218366, 2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.564381622781802, 
        0.4619339823233991}, {-0.6135969059878413, 
        0.4173491986775392}, {-0.6594985245055178, 
        0.3677433022012669}, {-0.7016170303347863, 
        0.3134262025896493}, {-0.73939314643691, 
        0.2545767487226082}, {-0.7723394590041053, 
        0.19147863813218166`}, {-0.7938663563167657, 0.139606275430481}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7976993695133316, 
        0.13037004189970933`}, {-0.8000943148827584, 
        0.12459905349161225`}, {-0.822296060919255, 
        0.05440517747414151}, {-0.8384589969229637, -0.01884271966119042}, \
{-0.8481966603328666, -0.09471883772398072}, {-0.8512962544397704, \
-0.17250769914394398`}, {-0.8475449825344812, -0.2514938263507938}, \
{-0.8458031711733942, -0.26305975952267924`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.8443139795557509, -0.2729482532566076}, \
{-0.8318758568709811, -0.35553957110516105`}, {-0.8036846916360186, \
-0.45945441290959943`}, {-0.7848289315187789, -0.5109032034529961}, \
{-0.7627823539148944, -0.5617624353683388}, {-0.7371496536995916, \
-0.611762417585823}, {-0.7156584514600576, -0.6483024909568125}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.7105887687047335, -0.6569221380934631}, \
{-0.7083448792633562, -0.6607372752789245}, {-0.6771100685681256, \
-0.7082189809416406}, {-0.6428208020762122, -0.7543644744149538}, \
{-0.6055244233451589, -0.7989807952463104}, {-0.5652793590432571, \
-0.8418783277458888}, {-0.5221585449796224, -0.8828742186188677}, \
{-0.4762423642871011, -0.9217853324580959}, {-0.4406300935850602, \
-0.9486223544635444}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.43264387334394744`, -0.9546406836553085}, \
{-0.42761829782736327`, -0.9584279030061061}, {-0.3763865876283746, \
-0.9926231827104987}, {-0.2876718024784652, -1.0426407168785043`}, \
{-0.19290402192960313`, -1.084997466672748}, {-0.09276922166227014, \
-1.1189655870609294`}, {-0.072606103866161, -1.1237637889312533`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.0628777656053801, -1.1260788342188939`}, {
        0.01199488727992068, -1.1438962227171987`}, {
        0.06588499043664017, -1.1528040884844326`}, {
        0.12065718468256856`, -1.1592640157197072`}, {
        0.17619309984442835`, -1.1632082572387383`}, {
        0.23237291778443048`, -1.1645753651944322`}, {
        0.2890753724002727, -1.1633101910768853`}, {
        0.33364360479423416`, -1.1602301116986589`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.34361980951948895`, -1.159540663165551}, {
        0.34617774962514114`, -1.1593638857133848`}, {
        0.40355588742771165`, -1.1526938992684084`}, {
        0.4610841758121489, -1.143263981243624}, {
        0.518998619387628, -1.130968576472626}, {
        0.576842984128467, -1.1158329829852585`}, {
        0.6344674274634163, -1.0978364871156587`}, {
        0.6917233475392416, -1.0769653057845028`}, {
        0.7296056927479534, -1.0611068611992711`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.738830040296775, -1.0572453314119266`}, {
        0.7484633832207206, -1.0532125864990063`}, {
        0.8045414140906456, -1.0265784073529238`}, {
        0.8598125604498239, -0.9970697770265483}, {
        0.9141331833170762, -0.9647006347867122}, {
        0.9673820374898937, -0.9294901811650352}, {
        1.0194282129058432`, -0.8914654079077794}, {
        1.070117126615732, -0.8506622034378077}, {
        1.076272397972157, -0.8452130118478762}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0837598615325001`, -0.8385844456807076}, {
        1.1192976927148532`, -0.807123208703535}, {
        1.1668223223429817`, -0.7608978171789293}, {
        1.2125469236843767`, -0.7120421748635111}, {
        1.2563309019677829`, -0.6606191802823511}, {
        1.2980371594664277`, -0.6066984844860741}, {
        1.3375662023463533`, -0.5503394515775313}, {
        1.3454809359443005`, -0.5378583944277895}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3508363160810535`, -0.529413283203485}, {
        1.3748044498429461`, -0.4916169829802631}, {
        1.4096016479480442`, -0.43063280135638815`}, {
        1.4418146777617915`, -0.367493564349756}, {
        1.4713075554926376`, -0.30231086458594714`}, {
        1.4979514324573384`, -0.23520122967227292`}, {
        1.5208227948743092`, -0.16862024832585604`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.523733356592806, -0.15905534522701567`}, {
        1.5422124648968552`, -0.09569193973322715}, {
        1.5596373668814885`, -0.023521620306213353`}, {1.5738134138892368`, 
        0.05010232411888055}, {1.5846267933996065`, 0.12501900415547815`}, {
        1.5919740032894525`, 0.20106562418459623`}, {1.5935795763479188`, 
        0.23370900029632946`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.5940708351185622`, 0.24369692624821088`}, {
        1.5957618518329777`, 0.27807748235484525`}, {1.5959074577017347`, 
        0.3558879705824303}, {1.5923382499646241`, 0.4343285745511492}, {
        1.5849919680878959`, 0.5132288737123933}, {1.573872949921001, 
        0.5924697362955953}, {1.564653526329308, 0.6415989428602219}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.562809153417956, 0.651427385695375}, {1.5589668241269214`,
         0.6719026993146173}, {1.5402032350270958`, 0.7513147416497244}, {
        1.5175281413921342`, 0.830496610083223}, {1.4909038164418207`, 
        0.9092428192994615}, {1.460308847845112, 0.9873516518848294}, {
        1.4406285697627128`, 1.0313416101385444`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.436544812352316, 1.0404697493472237`}, {
        1.4257381377201381`, 1.0646251583277575`}, {1.3872029026342014`, 
        1.140869157018719}, {1.3515519032253913`, 1.204315306540885}, {
        1.313055676925873, 1.2667796710546595`}, {1.271771982037057, 
        1.328151237659783}, {1.2316324495300384`, 1.38303169224597}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2256224742846356`, 1.3910220696073383`}, {
        1.1810997737605855`, 1.4471817206886097`}, {1.1318533310391634`, 
        1.5046284064573614`}, {1.0801035610609107`, 1.5605578330075598`}, {
        1.0250283974928056`, 1.6145344416158482`}, {0.9679068642694146, 
        1.6668977144518065`}, {0.95120398488836, 1.6810049544901093`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.9435642688880106, 1.6874574531870488`}, {
        0.9082078833359545, 1.7173194312622413`}, {0.8460237332762728, 
        1.7657013128361316`}, {0.7814466926742176, 1.8119450799624535`}, {
        0.7145690401136361, 1.8559524534301848`}, {0.6454830541783753, 
        1.8976251540283033`}, {0.615035633245718, 1.914404857646624}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6062775611370249, 1.9192314685630882`}, {
        0.5742810134522837, 1.9368649025457862`}, {0.5010551965192082, 
        1.9735734197716106`}, {0.4258456479139233, 2.0076011512854945`}, {
        0.3487114063708665, 2.0388171881977954`}, {0.26977324177337964`, 
        2.067151219593451}, {0.239321999067341, 2.0767380730964073`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.22978353806731178`, 2.0797410319291125`}, {
        0.1891519240048043, 2.092532934557398}, {0.10696822294848282`, 
        2.1148920221745744`}, {0.023342908487757375`, 
        2.1341581715299163`}, {-0.06160324949403034, 
        2.150261071708362}, {-0.14774948111353844`, 
        2.163130411794848}, {-0.1605286263385311, 2.1645181531232565`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17047017924566568`, 
        2.165597748322692}, {-0.23510946302628927`, 
        2.172617201029565}, {-0.323647982237309, 
        2.1786010595053367`}, {-0.4131709343875117, 
        2.1810545925860545`}, {-0.5034842151178114, 
        2.1799504056356085`}, {-0.5697597052361542, 2.17653177781233}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5797464281687555, 
        2.1760166418424594`}, {-0.594393720069122, 
        2.17526110401789}, {-0.6857053448823567, 
        2.166959293096789}, {-0.77722498519843, 
        2.155017578236197}, {-0.8687585366582558, 
        2.1394085648000045`}, {-0.9238970020613204, 
        2.128186431652593}, {-0.9748038544413787, 2.116523499662592}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.984518305003845, 
        2.1141538819017347`}, {-1.0338067447765296`, 
        2.1015954623126647`}, {-1.0885780220886738`, 
        2.0862266261201476`}, {-1.1432269033705111`, 
        2.0694755555792614`}, {-1.197753388622042, 
        2.051342250690007}, {-1.252157477843266, 
        2.0318267114523842`}, {-1.306439171034183, 
        2.010928937866392}, {-1.3604621295491208`, 
        1.9886471029699575`}, {-1.3634147640646663`, 
        1.9873440096989632`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.3725634151902093`, 
        1.9833064135597858`}, {-1.4140900147424071`, 
        1.964979379801007}, {-1.4673228266140417`, 
        1.9399257683595401`}, {-1.5201605651640244`, 
        1.913486268645557}, {-1.5726032303923563`, 
        1.8856608806590582`}, {-1.6246508222990361`, 
        1.856449604400043}, {-1.6763033408840642`, 
        1.8258524398685112`}, {-1.725174859473526, 1.7953581311562983`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-1.7335669488943006`, 
        1.7899210826972387`}, {-1.7782831397293086`, 
        1.760525753432841}, {-1.8283303832698115`, 
        1.7258468464185857`}, {-1.877702516768949, 
        1.6898326660216971`}, {-1.9263995402267204`, 
        1.6524832122421753`}, {-1.9744214536431275`, 
        1.613798485080021}, {-2.0217682570181688`, 
        1.5737784845352334`}, {-2.051299676483258, 1.5476110186857972`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{-2.0587841661227753`, 
        1.5409790947691682`}, {-2.0684399503518445`, 
        1.5324232106078128`}, {-2.1144365336441546`, 
        1.4897326632977592`}, {-2.155192561428974, 
        1.4518432200294389`}, {-2.195307882524382, 
        1.4129365737198567`}, {-2.234807042178689, 
        1.3730045845864645`}, {-2.273616404646967, 
        1.332071671976908}, {-2.311547713275963, 
        1.2864919643175234`}, {-2.3370386881432017`, 1.254454668027102}}]}, 
      {Arrowheads[{{0.0064206579243808225`, 1.}}], 
       ArrowBox[{{-2.343264935305781, 
        1.2466294621978298`}, {-2.3486316538636705`, 
        1.2398845199803632`}, {-2.3847917501640477`, 
        1.1922992407202326`}, {-2.420053494259109, 1.1437194926188634`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{-2.4430241610635117`, -2.044841800999949}, \
{-2.4104430890983592`, -2.1061146468366765`}, {-2.376412746194564, \
-2.166936044577026}, {-2.3409311659591037`, -2.227338998046736}, \
{-2.304004247571042, -2.287224495768588}, {-2.2610948646973754`, \
-2.3475708556553103`}, {-2.2333387950894106`, -2.3848208344683868`}}]}, 
      {Arrowheads[{{0.006821092744302866, 1.}}], 
       ArrowBox[{{-2.2273638180539623`, -2.3928395406873393`}, \
{-2.216653803342051, -2.407212894938906}, {-2.1707180076381913`, \
-2.466039419610322}, {-2.1429619356060385`, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0184081091662867`, -0.5067873791627169}, {
        1.0759191924708684`, -0.42509227429628504`}, {
        1.1271838568917605`, -0.33743822175845617`}, {
        1.1714694730002704`, -0.24413908630295406`}, {
        1.204727118262335, -0.15486110550109775`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2082039045868656`, -0.1454856256896159}, {
        1.236827818752079, -0.04269082252046425}, {1.2570615971948413`, 
        0.06403685755707506}, {1.2638259048826783`, 0.11862654650847065`}, {
        1.2682292821237293`, 0.1739498297280969}, {1.2702507739316728`, 
        0.22989828288002445`}, {1.2701280270155555`, 0.24807306785523997`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.2700604916268332`, 0.25807283980120305`}, {
        1.2698694253201892`, 0.28636348162832626`}, {1.2670642813029585`, 
        0.343237001637073}, {1.2618143868936593`, 0.40041041857033527`}, {
        1.2540987871059723`, 0.4577753080921861}, {1.2438965269535767`, 
        0.5152232458666962}, {1.2298773706762682`, 0.5776234279538769}, {
        1.2127243746694811`, 0.6398814368110328}, {1.2088119188749304`, 
        0.6518486180829356}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2057044527647323`, 0.6613535459823975}, {
        1.1924654467939686`, 0.7018482103649564}, {1.169128494910485, 
        0.7633746865424406}, {1.142741426879784, 0.824311803270278}, {
        1.1133321505626186`, 0.8845104984752609}, {1.0809285738197432`, 
        0.943821710084182}, {1.0455586045119112`, 1.0020963760238348`}, {
        1.0330306354171268`, 1.020707506451819}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.0274464893003394`, 1.0290031265097994`}, {
        1.0071432883411775`, 1.0591648804459457`}, {0.965642529976396, 
        1.1148650816022667`}, {0.9211425257285202, 1.1690591285696261`}, {
        0.8737294719085029, 1.2216091704248513`}, {0.8234895648272981, 
        1.2723773562447702`}, {0.7705090007958589, 1.3212258351062112`}, {
        0.76301525296278, 1.3275283282708201`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7553621012256132, 1.3339648854629764`}, {
        0.7148739761251386, 1.3680167560860017`}, {0.6566706871260901, 
        1.4126122682609699`}, {0.5958868935415962, 1.4548137568739183`}, {
        0.5325461502302017, 1.4944447031072954`}, {0.4667883461763527, 
        1.5314003999473969`}, {0.42244218546843815`, 
        1.5536766315396637`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.4135062431827847, 1.5581653881010593`}, {
        0.3987533703644961, 1.5655761403805188`}, {0.3285811117790784, 
        1.5968672173929581`}, {0.2564114594045464, 1.6251689239710105`}, {
        0.18238430222534668`, 1.6503765531009726`}, {0.10663952922592544`, 
        1.6723853977691403`}, {0.036577283886393974`, 1.689227800456937}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.026829589397323553`, 
        1.6914504556223147`}, {-0.049713479558559016`, 
        1.7060250582452203`}, {-0.1300486916562981, 
        1.7174373888402237`}, {-0.21158248932588633`, 
        1.7251776798056089`}, {-0.2941344578934623, 
        1.7291956512406803`}, {-0.3705239868860921, 1.7294204253584164`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.3805212427382143, 
        1.7293134518164013`}, {-0.4615712490271312, 
        1.725863515917101}, {-0.5460952422455015, 
        1.7184128493570592`}, {-0.6073669110617305, 
        1.71054669756839}, {-0.6687571905394636, 
        1.7005339505031911`}, {-0.7301910424513285, 
        1.6883733427783727`}, {-0.776376425445919, 1.6776099087104022`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.7861154510414511, 
        1.6753402434378186`}, {-0.7915934285699527, 
        1.6740636090108452`}, {-0.8528893106679645, 
        1.657603483817519}, {-0.9140036505179907, 
        1.6389917018153042`}, {-0.9748614098926598, 
        1.618226997621111}, {-1.0353875505646002`, 
        1.5953081058518497`}, {-1.0955116787354866`, 
        1.5701927653120424`}, {-1.1551617117237043`, 
        1.5428536223743539`}, {-1.1616231235377632`, 
        1.5396237182905832`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.1705678393983652`, 
        1.535152470346989}, {-1.214260077976946, 
        1.5133117730079049`}, {-1.2727292059429054`, 
        1.481588313181817}, {-1.330491524069274, 
        1.4477043388652124`}, {-1.387469460803745, 
        1.4116809460272124`}, {-1.4435854445940108`, 
        1.3735392306369387`}, {-1.4987619038877642`, 
        1.3333002886635132`}, {-1.5098782823539032`, 
        1.3246059302245987`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.517755194621837, 1.318445227900734}, {-1.552911542693924,
         1.2909486927231102`}, {-1.6059506011809626`, 
        1.2464822966511577`}, {-1.6578068120359046`, 
        1.1999421182456573`}, {-1.7084079079457735`, 
        1.1513691753046116`}, {-1.7576816215975934`, 
        1.1008044856260222`}, {-1.8055556856783883`, 
        1.0482890670078906`}, {-1.8085864321172536`, 1.044734301158277}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.8150743370121278`, 
        1.037124630332606}, {-1.8519578328751822`, 
        0.9938639372482194}, {-1.896815795874999, 
        0.9375701141450103}, {-1.9400655920040801`, 
        0.8793649966145819}, {-1.981640225992588, 
        0.8192363904393196}, {-2.0214629116334275`, 
        0.7572709237163249}, {-2.0480411929933386`, 0.7126992555620061}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.053162792347552, 
        0.7041103545813847}, {-2.059456862719505, 
        0.6935552245427}, {-2.0955452930437253`, 
        0.6281759210155471}, {-2.1296514163989935`, 
        0.5612196412319675}, {-2.161698446578216, 
        0.4927730132890638}, {-2.1916095973742973`, 
        0.42292266528393746`}, {-2.222571578513575, 0.3423385018646443}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.226067301162115, 
        0.33297106457213094`}, {-2.255550018792895, 
        0.24547848487758112`}, {-2.282270798158668, 
        0.15387751028273183`}, {-2.305491956628756, 
        0.06035727942676852}, {-2.325017914052913, -0.03480596835191291}, \
{-2.3280156480650516`, -0.0533136804495548}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.3296145320543222`, -0.06318503142036191}, \
{-2.3406530902808895`, -0.13133599371491653`}, {-2.3523974853126877`, \
-0.22923279666224225`}, {-2.3602510991483063`, -0.32849637719389}, \
{-2.3640610377600857`, -0.42881079620834495`}, {-2.3639370651265774`, \
-0.46121213440746434`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-2.363898803828446, -0.4712120612108497}, \
{-2.3636744071203655`, -0.5298601146040919}, {-2.359091207229146, \
-0.6316443323811308}, {-2.350311438086427, -0.7341634495394618}, \
{-2.3416166087327386`, -0.8164006916582516}, {-2.3342032938177177`, \
-0.8697623742984085}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.3328272513403485`, -0.8796672471951436}, \
{-2.330156251816281, -0.8988933330378628}, {-2.312614791789152, \
-0.983386542488778}, {-2.292094195414128, -1.0677568644121198`}, \
{-2.264581981304155, -1.1712605619128256`}, {-2.2347443487580243`, \
-1.2670894353087963`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.2316707946371857`, -1.2766036644713885`}, \
{-2.1959483552597128`, -1.3765463613489828`}, {-2.1759546992018324`, \
-1.427509145465261}, {-2.154826943325244, -1.4783284632844345`}, \
{-2.132566230022787, -1.5289064770021181`}, {-2.1091737016873005`, \
-1.5791453488139267`}, {-2.084649358318784, -1.6290450787198598`}, \
{-2.076463626336561, -1.6448576444165794`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.0718663762071476`, -1.6537382576413298`}, \
{-2.058993199917239, -1.678605666719918}, {-2.0322052264826636`, \
-1.7278271128141012`}, {-2.0042854380150597`, -1.7767094170024091`}, \
{-1.9752338345144254`, -1.825252579284842}, {-1.9450504159807618`, \
-1.8734565996613994`}, {-1.9137532796186734`, -1.9212222077079029`}, \
{-1.881360522632764, -1.968450133000173}, {-1.862800896455759, \
-1.9943263775205375`}}]}, 
      {Arrowheads[{{0.015330622926136378`, 1.}}], 
       ArrowBox[{{-1.856972598660174, -2.00245232022314}, \
{-1.8478721450230344`, -2.01514037553821}, {-1.8132881467894835`, \
-2.061292935322014}, {-1.7776085279321123`, -2.1069078123515848`}, \
{-1.7408332884509201`, -2.1519850066269215`}, {-1.7029624283459077`, \
-2.1965245181480255`}, {-1.6639959476170743`, -2.2405263469148964`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019446325424658885`, 1.}}], 
       ArrowBox[{{-1.5710748870367848`, -2.2389630246087853`}, \
{-1.531047294468045, -2.281835877098858}, {-1.4899345536022617`, \
-2.324084268513528}, {-1.447760695529135, -2.36563088539739}, \
{-1.4007129660924766`, -2.406347994896082}, {-1.3525732280068818`, \
-2.446199690014484}, {-1.3033919431219068`, -2.485105219299348}, \
{-1.2836924992271268`, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.1157586894501688`, -1.2987569874677507`}, \
{-1.0728584922672275`, -1.351329990030476}, {-1.0276508074725494`, \
-1.402602995238057}, {-0.9801147542111261, -1.4524574332995595`}, \
{-0.9302504855706829, -1.5007816587180534`}, {-0.8781265149528307, \
-1.5474865299521239`}, {-0.8354050624917712, -1.5828783164392308`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8277043165942344, -1.5892578550292522`}, \
{-0.8238113557591806, -1.5924829054603553`}, {-0.7673735213913431, \
-1.6356816437013335`}, {-0.7088815252509286, -1.6769936031336432`}, \
{-0.6484038807395481, -1.7163296422158696`}, {-0.5860091012588117, \
-1.7536006194065983`}, {-0.5217050443668458, -1.7886766904712736`}, \
{-0.491064953830502, -1.8038460022682559`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.48210311641083603`, -1.8082828333517518`}, \
{-0.45552162429213544`, -1.821442812154664}, {-0.3875604394418276, \
-1.8518320443843403`}, {-0.3179230882230699, -1.8797774470878732`}, \
{-0.24671116904301013`, -1.9052120801928338`}, {-0.1740262803087954, \
-1.9280690036267925`}, {-0.10741679715925005`, -1.9462488186209952`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.09774834967437668, -1.9487974435904183`}, \
{-0.02464398780649371, -1.9657819611919871`}, {
        0.051884917014010434`, -1.9804492979724255`}, {
        0.12953717608742563`, -1.9921814639096995`}, {
        0.20819226489748852`, -2.0009414192255273`}, {
        0.28772965892793567`, -2.0066921241416296`}, {
        0.297331025374967, -2.007015490813965}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.3073253587410286, -2.0073520923113275`}, {
        0.3680288336625037, -2.009396538879725}, {
        0.44896926458492925`, -2.009017623661533}, {
        0.5304304271789486, -2.0055183387087725`}, {
        0.6122917969282988, -1.9988616442431633`}, {
        0.6945340167900809, -1.988917001278761}, {
        0.7061946924909228, -1.9870345686781201`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7160668802157693, -1.9854408593177308`}, {
        0.7771009415492629, -1.9755878705414993`}, {
        0.8598168644313833, -1.9588882118209137`}, {
        0.9425060786619794, -1.9388319849065396`}, {
        1.0249928774665893`, -1.915433149587913}, {
        1.1038814015487506`, -1.8897538688208397`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.1133074310664073`, -1.886419620934467}, {
        1.1886564017000014`, -1.8586634928960455`}, {
        1.269481713579879, -1.8253205911018753`}, {
        1.3649634476623471`, -1.7810436508034948`}, {
        1.4589249922937526`, -1.7319761480086175`}, {
        1.4770859608858629`, -1.7213952274857598`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.485726436005152, -1.7163611248136894`}, {
        1.5513663474740953`, -1.6781180827172435`}, {
        1.6422875132033758`, -1.6194694549293736`}, {
        1.6870607333261327`, -1.5883727987457472`}, {
        1.7312193226906545`, -1.556126739230986}, {
        1.7747632812969407`, -1.52273127638509}, {
        1.8150955695849567`, -1.4902762259250777`}}]}, 
      {Arrowheads[{{0.020000000000000007`, 1.}}], 
       ArrowBox[{{1.8227883098636344`, -1.4838879671777785`}, {
        1.8600073062348075`, -1.4524921406998945`}, {
        1.9017073725663884`, -1.415648467860595}, {
        1.9427928081397334`, -1.3776553916901606`}, {
        1.9832636129548433`, -1.3385129121885915`}, {
        2.02300428193529, -1.2982682799734873`}, {
        2.0618993100046454`, -1.2569687456624474`}, {
        2.0999486971629095`, -1.2146143092554713`}, {
        2.108521456257213, -1.2046116122432906`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.1150289406149954`, -1.19701867820346}, {
        2.1371524434100824`, -1.1712049707525596`}, {
        2.173510548746164, -1.1267407301537118`}, {
        2.209023013171154, -1.0812215874589284`}, {
        2.243689836685053, -1.034647542668209}, {
        2.2775110192878607`, -0.9870185957815538}, {
        2.327440473856665, -0.9150263623818344}, {
        2.3527453660129147`, -0.8757220148797549}}]}, 
      {Arrowheads[{{0.0107802564769792, 1.}}], 
       ArrowBox[{{2.358158664139325, -0.8673139114435093}, {
        2.375223925555277, -0.8408076153184432}, {
        2.419358000171919, -0.7603789313246376}, {
        2.46086042381678, -0.6778929401290636}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{0.590233331341948, 1.116707293350296}, {0.5440711940330103, 
        1.1523319494581412`}, {0.49591512880009897`, 1.1861412562360063`}, {
        0.44585422963022264`, 1.2180444124812657`}, {0.3939775905103896, 
        1.247950616991294}, {0.3403743054276093, 1.2757690685634642`}, {
        0.28513346836889164`, 1.3014089659951507`}, {0.2457224119915884, 
        1.3168155623031015`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.2364087720642189, 1.320456456603038}, {0.1862767543182927,
         1.3400540982424867`}, {0.08307398357211947, 1.3713268526864173`}, {
        0.03003451235916329, 1.3840962589009362`}, {-0.02386145052252265, 
        1.3948997754672015`}, {-0.07853723090454949, 
        1.403696470652745}, {-0.1339161546185282, 
        1.4104454127250994`}, {-0.15150264392482504`, 1.4118940572571679`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.16146888939123372`, 
        1.4127150026288513`}, {-0.18994766344847125`, 
        1.415060872779482}, {-0.24657170246842736`, 
        1.4174734117919507`}, {-0.30369735244506235`, 
        1.4176665328513025`}, {-0.36123369414504175`, 
        1.415623739046332}, {-0.419089808335033, 
        1.4113285334658348`}, {-0.47717477578170236`, 
        1.404764419198606}, {-0.5353976772517169, 
        1.3959148993334418`}, {-0.5596467833599197, 1.3912742195149705`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.5694685421647088, 
        1.389394577532957}, {-0.5936675935117427, 
        1.3847634769591368`}, {-0.651905581964305, 
        1.3712401366176608`}, {-0.7100283448716171, 
        1.3552943241407378`}, {-0.767938430289877, 
        1.3369387345517958`}, {-0.8255383862752824, 
        1.3161860628742628`}, {-0.8827307608840316, 
        1.2930490041315663`}, {-0.9394181021723225, 
        1.267540253347135}, {-0.9479010975008977, 1.2633251765654943`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.9568564984663602, 
        1.2588753683058282`}, {-0.9955029581963529, 
        1.2396725055443962`}, {-1.0508878770123211`, 
        1.2094584557467782`}, {-1.1054698767668143`, 
        1.1768519408579656`}, {-1.1591479864826422`, 
        1.1418282007342775`}, {-1.2118277705303355`, 
        1.1044320348280925`}, {-1.2634147932804254`, 
        1.064708242591789}, {-1.2913525375418884`, 1.0414230394599788`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2990342432758462`, 
        1.0350205870379081`}, {-1.313814619103443, 
        1.022701623477746}, {-1.362932812369919, 
        0.9784569769383421}, {-1.4106749374503844`, 
        0.9320191024259562}, {-1.4569465587153705`, 
        0.8834327993929668}, {-1.5011674882220853`, 
        0.8332346312379151}, {-1.5437273991565774`, 
        0.7809324690304578}, {-1.5717339081625856`, 0.7436538626848366}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.57774043346606, 
        0.7356587608231514}, {-1.5845471137370724`, 
        0.7265985971915778}, {-1.6235474541817954`, 
        0.6703053001422565}, {-1.6606492427089714`, 
        0.612124862303477}, {-1.6957733015368253`, 
        0.5521295680962217}, {-1.7288404528835828`, 
        0.49039170194147247`}, {-1.7597715189674685`, 
        0.42698354826021184`}, {-1.7763362015007584`, 
        0.3893975484266951}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.7803690620721964`, 
        0.380246808805695}, {-1.7884443678725621`, 
        0.361923581550469}, {-1.8147524873680865`, 
        0.29524984355498346`}, {-1.8386401291999832`, 
        0.2270639695618027}, {-1.8600515451141928`, 
        0.15746759485897469`}, {-1.8789309868566562`, 
        0.08656235473454711}, {-1.895222706173315, 
        0.014449884476567788`}, {-1.8981417990885676`, \
-0.0012100247762499364`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.8999742889865192`, -0.011040690103373286`}, \
{-1.9088709548101095`, -0.05876818062691504}, {-1.919819984512981, \
-0.13299020528785466`}, {-1.9279597318089314`, -0.20814319616407861`}, \
{-1.9331998842136677`, -0.2841437446603692}, {-1.9355143199561888`, \
-0.36087459260911003`}, {-1.9351196984764065`, -0.4087588586578548}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.935037289762155, -0.4187585190922803}, \
{-1.934876917265493, -0.4382184818426845}, {-1.9312615543705791`, \
-0.5160581541934764}, {-1.924642109500446, -0.5942763514938697}, \
{-1.9149924608840923`, -0.6727558155762474}, {-1.9022864867505167`, \
-0.7513792882729936}, {-1.8893536687477337`, -0.8154918642785607}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.8873762938797127`, -0.8252944143871457}, \
{-1.8864033409561896`, -0.8301176878798832}, {-1.8672566225839549`, \
-0.9089098685241854}, {-1.844871877702372, -0.9875904757855247}, \
{-1.8192746523800016`, -1.0659941552435255`}, {-1.7904904926854028`, \
-1.1439555524778127`}, {-1.7650649022066096`, -1.2055217224764507`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.7612478026992089`, -1.2147645440884154`}, \
{-1.7585449446871353`, -1.2213093130680108`}, {-1.723463554453759, \
-1.2978900825937443`}, {-1.685271868053834, -1.3735325066346376`}, \
{-1.6361828261843436`, -1.4613347908201704`}, {-1.5827364658432084`, \
-1.5473903891416796`}, {-1.5702659524845914`, -1.5655791176213472`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.564611211030251, -1.5738267778401343`}, \
{-1.5249327870304294`, -1.631699301599166}, {-1.4627717897460057`, \
-1.7142615281926292`}, {-1.3963721114209777`, -1.7946561836505752`}, \
{-1.3258523894863847`, -1.872462382701509}, {-1.313732671494635, \
-1.8846759503912551`}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.3066889280799876`, -1.8917742374176167`}, \
{-1.2512126239422265`, -1.947680125345431}, {-1.1724528147885034`, \
-2.020309411582341}, {-1.1315780016313726`, -2.0555511891973244`}, \
{-1.0897733931184852`, -2.0899414640088714`}, {-1.0470389892498415`, \
-2.123480236016981}, {-1.0056686389330485`, -2.154450316813538}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9975680696140309, -2.160312937724738}, \
{-0.9587807954452852, -2.188003271622889}, {-0.9132570055093725, \
-2.218987535220688}, {-0.8668034202177034, -2.24912029601505}, \
{-0.8194200395702781, -2.278401554005975}, {-0.751582506025026, \
-2.319311832593269}, {-0.6819971413679345, -2.358308274177863}, \
{-0.657440783898358, -2.370046573521433}}]}, 
      {Arrowheads[{{0.006416668167683784, 1.}}], 
       ArrowBox[{{-0.6484185773121611, -2.374359320710405}, \
{-0.6075405183771753, -2.3938996329475692`}, {-0.5314939573396571, \
-2.427217591490897}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{2.163584822582592, -2.5}, {
        2.215405182751581, -2.471559170594909}, {
        2.2773454582091284`, -2.435870988564526}, {
        2.338776102229582, -2.3987202289154466`}, {
        2.400698781224708, -2.3555617496962653`}, {
        2.4619270063016034`, -2.3108543397862635`}, {
        2.4987165330384586`, -2.282711985939136}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.0250290075413586`, -1.386237025932758}, {
        1.086836676756269, -1.3555045924695788`}, {
        1.147871066219764, -1.322132671798602}, {
        1.2080229877988455`, -1.2861491139987058`}, {
        1.2671832533605156`, -1.2475817691487694`}, {
        1.325242674771775, -1.2064584873276716`}, {
        1.3645177696526718`, -1.1762500415288804`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.3724443182932387`, -1.1701533353157907`}, {
        1.3820782681037307`, -1.1627433812071863`}, {
        1.437572066080541, -1.1164237406980348`}, {
        1.4916224055487872`, -1.0675621817375172`}, {
        1.544127623355051, -1.016221320262931}, {
        1.594986056345913, -0.9624637722115769}, {
        1.6440960413679544`, -0.9063521535207535}, {
        1.6571134039208513`, -0.8902654838404263}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6634038740268915`, -0.8824918112305838}, {
        1.6913559152677573`, -0.8479490801277595}, {
        1.736664014891902, -0.7873171679698943}, {
        1.7798817059897387`, -0.7244497402400704}, {
        1.820883798345975, -0.6593653174927938}, {
        1.8595887948602272`, -0.5921643117077576}, {
        1.8824111038195512`, -0.5486781517833507}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.8870581777451747`, -0.5398235087115046}, {
        1.8959151984321105`, -0.5229471348646543}, {
        1.9297815119612423`, -0.4518141989431748}, {
        1.9611062383472382`, -0.378865915923012}, {
        1.9898078804897141`, -0.3042026977838585}, {
        2.015804941288287, -0.2279249565054053}, {
        2.033539091573298, -0.1683153630544642}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.036390623058706, -0.1587305433802227}, {
        2.0389611047575493`, -0.15009041309043633`}, {
        2.0591599890521013`, -0.07077231253333757}, {2.076349998281574, 
        0.009905647198794125}, {2.090479536555595, 0.09181976813886111}, {
        2.1014970079837934`, 0.17484635231976656`}, {2.107059984932449, 
        0.23435575351325816`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.1079907334512793`, 0.24431234465655088`}, {
        2.109350816675798, 0.25886170177441364`}, {2.113989366741239, 
        0.3437421185357047}, {2.1153610622897436`, 0.4293639046365429}, {
        2.1133241529620412`, 0.5157209999614283}, {2.107769671842096, 
        0.6027645669942797}, {2.1035273149906457`, 0.6436909236449984}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.1024962565022873`, 0.6536376275409422}, {
        2.098695198204392, 0.6903067416671298}, {2.086098311323413, 
        0.7781596599120093}, {2.0699765904736442`, 0.8661354576609507}, {
        2.050327614929569, 0.9540462708459857}, {2.0271489639656717`, 
        1.0417042353991457`}, {2.02592153036865, 1.04571211225586}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.022993226086215, 1.0552737561537193`}, {2.000438216856436,
         1.1289214872524629`}, {1.9825748129835725`, 1.1812978347168277`}, {
        1.9633934807279065`, 1.2333860474029534`}, {1.9428942200894386`, 
        1.2851861253108408`}, {1.921077031068168, 1.336698068440489}, {
        1.8979419136640958`, 1.387921876791899}, {1.8787811395605527`, 
        1.4278337529505396`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.8744532646643937`, 1.4368487126777485`}, {
        1.8734888678772206`, 1.4388575503650696`}, {1.8477178937075436`, 
        1.4895050891600017`}, {1.8206289911550642`, 1.539864493176695}, {
        1.792236871597378, 1.5898055367553618`}, {1.7625562464120805`, 
        1.6391979942362145`}, {1.7315871155991722`, 1.6880418656192526`}, {
        1.6993294791586524`, 1.736337150904477}, {1.6689882995338021`, 
        1.7795221816480025`}}]}, 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{1.6631556398590366`, 1.7876441660215932`}, {
        1.6309486893947789`, 1.8312819631814827`}, {1.5948255360714254`, 
        1.8779314901732642`}, {1.5574138771204606`, 1.9240324310672317`}, {
        1.5187543574321842`, 1.9694542715196903`}, {1.4788876218968956`, 
        2.014066497186945}, {1.4378136705145945`, 2.057869108068997}, {
        1.4042494100247658`, 2.0919984430612524`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.397237612474079, 2.0991282884388314`}, {
        1.3955325032852812`, 2.100862104165845}, {1.3520441202089561`, 
        2.14304548547749}, {1.3073485212856182`, 2.184419252003931}, {
        1.2614457065152682`, 2.2249834037451692`}, {1.2143356758979063`, 
        2.264737940701204}, {1.138010604139863, 2.3276836942516512`}, {
        1.0948995705242555`, 2.3606050791168873`}}]}, 
      {Arrowheads[{{0.012242891089517541`, 1.}}], 
       ArrowBox[{{1.0869519130084482`, 2.3666742421573264`}, {
        1.0587328693509175`, 2.388223481849927}, {0.9712250066777357, 
        2.4449900255925154`}, {0.880928475195002, 2.498663202063696}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.01627850610150782, 1.}}], 
       ArrowBox[{{1.780147885761933, 2.2640882282906345`}, {
        1.7397943227504709`, 2.3123434677046935`}, {1.6982197169317073`, 
        2.3599831169700094`}, {1.6554459776350743`, 2.4069197958438}, {
        1.607265043441111, 2.4532672812037717`}, {1.55783907842309, 
        2.498730203213594}, {1.5563941937603583`, 2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{2.4920920618923503`, 1.578933636002447}, {
        2.4706645053973837`, 1.6363729912984055`}, {2.4479763038621476`, 
        1.6935961683240297`}, {2.4240293280532317`, 1.7506296704851083`}, {
        2.398817965670865, 1.8073939875642753`}, {2.368735358623721, 
        1.865124115852994}, {2.337304322195692, 1.9224477294017965`}, {
        2.325968034470024, 1.9421099177344285`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.3209732175328153`, 1.950773162147682}, {2.304541342871922,
         1.9792733750973899`}, {2.270440925157364, 2.035631537310872}, {
        2.234762631760958, 2.094490796698635}, {2.19765419008175, 
        2.152699767193571}, {2.159115600119738, 2.2102584487956793`}, {
        2.1191468618749223`, 2.2671668415049604`}, {2.1045905006142593`, 
        2.286947887607393}}]}, 
      {Arrowheads[{{0.012350614826359735`, 1.}}], 
       ArrowBox[{{2.098663564019866, 2.2950021673769343`}, {
        2.0777479753473043`, 2.3234249453214155`}, {2.034918940536883, 
        2.3790327602450434`}, {1.9906597574436582`, 2.433990286275843}, {
        1.9449704260676304`, 2.4882975234138165`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.2199832209368062`, -2.481154255856171}, {
        1.2832420794870314`, -2.4635307570556098`}, {
        1.3462556215892196`, -2.4443485107062624`}, {
        1.4090238472433716`, -2.423607516808128}, {
        1.4715467564494868`, -2.4013077753612064`}, {
        1.5338243492075658`, -2.3774492863654992`}, {
        1.595856625517608, -2.3520320498210046`}, {
        1.5979166174464694`, -2.3511326640990116`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.6070812280234499`, -2.347131425169343}, {
        1.6576435853796139`, -2.3250560657277233`}, {
        1.7191852287935827`, -2.2965213340856554`}, {
        1.7803299814450055`, -2.266436216421469}, {
        1.840926269019372, -2.234809074261832}, {
        1.9009740915166824`, -2.2016399076067446`}, {
        1.9604734489369364`, -2.1669287164562068`}, {
        1.9630380107318763`, -2.1653515798244465`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.971556157968746, -2.160113148031342}, {
        2.0194243412801343`, -2.1306755008102187`}, {
        2.077826768546276, -2.09288026066878}, {
        2.135680730735361, -2.0535429960318914`}, {
        2.19298622784739, -2.0126637068995517`}, {
        2.246582001937316, -1.9744104612470812`}, {
        2.299563570413034, -1.9348295843118508`}, {
        2.30106558742602, -1.9336567700300915`}}]}, 
      {Arrowheads[{{0.012724483589402416`, 1.}}], 
       ArrowBox[{{2.3089474513132786`, -1.927502403965034}, {
        2.3519627110124857`, -1.8939149608983747`}, {
        2.4036840905218453`, -1.851684936593112}, {
        2.45511444233224, -1.8036442674170963`}, {
        2.5, -1.7597719195081778`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.3012172369354242`, 1.10687774929806}, {
        1.2669103548234468`, 1.1655111349775642`}, {1.2300804399285483`, 
        1.2232155189853609`}, {1.190761524513057, 1.2798869353688656`}, {
        1.1489876408393018`, 1.335421418175495}, {1.1047928211696112`, 
        1.3897150014526651`}, {1.0683403505535751`, 1.431082679207209}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.0617290733950053`, 1.4385854129978066`}, {
        1.0581506142693033`, 1.4426463872326976`}, {1.0090565629026096`, 
        1.4941005800988574`}, {0.9575776903302278, 1.5439830679249762`}, {
        0.9037810198128557, 1.5921993385848847`}, {0.8477335746111917, 
        1.6386548799524145`}, {0.7895023779859335, 1.6832551799013968`}, {
        0.7622273553650217, 1.7025316442049208`}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.7540609940170662, 1.7083031728009357`}, {
        0.7291544531977792, 1.725905726305663}, {0.6667568235074267, 
        1.766512007039044}, {0.6023122106437019, 1.8049397965846248`}, {
        0.5358467187106565, 1.8410693106584881`}, {0.4674624445318283, 
        1.874827698983964}, {0.4052614685768344, 1.9025735733653337`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.39611016695251666`, 1.9066031406350583`}, {
        0.325345936730972, 1.9349396972830701`}, {0.25181789675601884`, 
        1.9611476067033597`}, {0.1767794618294323, 1.9846929892685798`}, {
        0.10033272877474907`, 2.0055029947020597`}, {0.022541898761888654`, 
        2.023449484093373}, {0.014676168949400886`, 2.0249394079250034`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{0.004850880331669907, 
        2.026800510710528}, {-0.05651504680155148, 
        2.0384244234898237`}, {-0.13671534073551447`, 
        2.050385120051335}, {-0.21793621585994372`, 
        2.05928888093783}, {-0.30005490499478216`, 
        2.065093013309232}, {-0.38294864095997244`, 
        2.0677548243254646`}, {-0.39243659673590053`, 2.0676954064275823`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.4024364006499432, 
        2.067632783103672}, {-0.46649465657545824`, 
        2.0672316211464516`}, {-0.5505701846611825, 
        2.063480710932116}, {-0.6351605675573233, 
        2.056366313764348}, {-0.7202118350512464, 
        2.0457864995715953`}, {-0.8003206715549505, 2.032608318227648}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-0.8101548517429319, 
        2.0308051873349147`}, {-0.8909700797953345, 
        2.014262947830174}, {-0.9763135850269479, 
        1.9933353741410256`}, {-1.0613910308192394`, 
        1.9689747111459315`}, {-1.1460206811629328`, 
        1.941189040774652}, {-1.194828672760761, 1.923058875547492}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-1.2042028325329754`, 
        1.9195767600173868`}, {-1.2300208000487531`, 
        1.9099864449569466`}, {-1.2801158707487543`, 
        1.8895762692745541`}, {-1.3298602625452325`, 
        1.867910978587504}, {-1.379253975438187, 
        1.8449905728957954`}, {-1.4282970094276184`, 
        1.820815052199429}, {-1.4769893645135264`, 
        1.7953844164984043`}, {-1.525331040695911, 
        1.7686986657927213`}, {-1.5640692364413908`, 
        1.7461448789044027`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.5727112454671879`, 
        1.741113409934207}, {-1.5733220379747728`, 
        1.7407578000823811`}, {-1.620962356350111, 
        1.7115618193673823`}, {-1.6681286484487656`, 
        1.6811317248664448`}, {-1.7146975668975755`, 
        1.6494885177982883`}, {-1.7606691116965414`, 
        1.616632198162912}, {-1.806043282845663, 
        1.5825627659603163`}, {-1.8508200803449397`, 
        1.547280221190501}, {-1.894999504194373, 
        1.510784563853467}, {-1.89759117724983, 1.508542154364521}}]}, 
      {Arrowheads[{{0.01999999999999999, 1.}}], 
       ArrowBox[{{-1.9051534192029043`, 
        1.501999028456886}, {-1.9385815543939613`, 
        1.473075793949213}, {-1.9815662309437054`, 
        1.4341539114777397`}, {-2.023831253726745, 
        1.3940643342958154`}, {-2.0652543426262184`, 
        1.3528524802602082`}, {-2.105835497642126, 
        1.3105183493709176`}, {-2.1455747187744683`, 
        1.267061941627944}, {-2.1844720060232445`, 
        1.2224832570312878`}, {-2.1873064086238836`, 
        1.2190794015278734`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.193705396056377, 
        1.2113948091614044`}, {-2.222527359388456, 
        1.1767822955809484`}, {-2.259740778870101, 
        1.1299590572769262`}, {-2.2961122644681806`, 
        1.0820135421192207`}, {-2.351108956758073, 
        1.0078086182151684`}, {-2.403850481131214, 
        0.9311116933250648}, {-2.4288871232843006`, 0.8883827740129644}}]}, 
      {Arrowheads[{{0.006750075349843567, 1.}}], 
       ArrowBox[{{-2.433942613237696, 
        0.8797547950299628}, {-2.452857482417045, 
        0.8474736323236576}, {-2.4990542374767566`, 0.7615138665784038}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.018848246097497655`, 1.}}], 
       ArrowBox[{{-2.184840558412888, 2.5}, {-2.2079206355386907`, 
        2.487476726964421}, {-2.2700298971192145`, 
        2.4520910329240366`}, {-2.331637754455099, 
        2.415243513692862}, {-2.3937611947702946`, 
        2.37240831450241}, {-2.4551997819590965`, 2.328024668122555}, {-2.5, 
        2.294117978872983}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.9065805888456094, -1.83885784758262}, \
{-0.8515127115686021, -1.879730314313156}, {-0.7947286092296787, \
-1.9190169687017076`}, {-0.7362863173757067, -1.9566614121565407`}, \
{-0.6762438715535545, -1.9926072460859208`}, {-0.6146593073100892, \
-2.0267980718981153`}, {-0.5680122597608632, -2.0507466481170242`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-0.559116177870114, -2.055313893128307}, \
{-0.5515906601921776, -2.05917749100139}, {-0.4870959657466883, \
-2.0896891048040107`}, {-0.4212332595204879, -2.1182765147142435`}, \
{-0.3540415991998354, -2.1448593653313655`}, {-0.2855669435112114, \
-2.1693660128215595`}, {-0.21587767956181467`, -2.1917531259434493`}, \
{-0.18682881693956566`, -2.2000468700572435`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{-0.17721305903902465`, -2.202792266203191}, \
{-0.14504219445884503`, -2.2119773734556576`}, {-0.07312887530950225, \
-2.2299954241168094`}, {-0.00020610922098569882`, -2.245763946685529}, {
        0.07365771669950491, -2.259239609920438}, {
        0.14839421534477007`, -2.2703790825801624`}, {
        0.2151336799242295, -2.277830381669521}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.22507193071433396`, -2.278939963227131}, {
        0.23971162356846606`, -2.280574449369923}, {
        0.3322673265292539, -2.2871248118325065`}, {
        0.425860020895385, -2.2900008333654682`}, {
        0.5202884033351107, -2.2891731773663655`}, {
        0.6153511705166818, -2.284612507232754}, {
        0.6245574257801849, -2.283810128324897}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{0.6345196600976171, -2.282941861427809}, {
        0.7108470191083489, -2.2762894863621903`}, {
        0.8065746457783636, -2.264174778152231}, {
        0.9023327471949769, -2.2482390460004313`}, {
        0.959925734759786, -2.236764867478752}, {
        1.0173982380363227`, -2.2238551908475586`}, {
        1.0292216669133885`, -2.2208978554953274`}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{1.0389228064806024`, -2.2184713577934043`}, {
        1.0747502570245868`, -2.2095100161068517`}, {
        1.1319817917245785`, -2.19372934325663}, {
        1.189092842136298, -2.176513172296896}, {
        1.2460834082597452`, -2.157861503227647}, {
        1.3029534900949196`, -2.1377743360488846`}, {
        1.3597030876418215`, -2.116251670760608}, {
        1.4161914175951162`, -2.0932909074972654`}, {
        1.4181200378281535`, -2.0924518225660798`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{1.4272897742788646`, -2.0884623447275024`}, {
        1.472277696649469, -2.068889446393304}, {
        1.5279619248048797`, -2.0430472874487235`}, {
        1.5832441020613488`, -2.0157644306635247`}, {
        1.6381242284188755`, -1.9870408760377065`}, {
        1.69260230387746, -1.9568766235712698`}, {
        1.7466783284371021`, -1.9252716732642137`}, {
        1.7816374765059757`, -1.903748249007807}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{1.7901529611148221`, -1.898505490013108}, {
        1.8003523020978027`, -1.8922260251165393`}, {
        1.853479508052472, -1.8577649236109885`}, {
        1.905915229494021, -1.8219136132303044`}, {
        1.9576594664224496`, -1.7846720939744871`}, {
        2.0087122188377573`, -1.746040365843536}, {
        2.0590734867399454`, -1.7060184288374516`}, {
        2.1087432701290125`, -1.664606282956234}, {
        2.1120613963145733`, -1.6617065576211334`}}]}, 
      {Arrowheads[{{0.02, 1.}}], 
       ArrowBox[{{2.119591249867652, -1.655126184875674}, {
        2.1577215690049596`, -1.6218039281998828`}, {
        2.206008383367786, -1.5776113645683982`}, {
        2.2485710627592055`, -1.5385886666284443`}, {
        2.290483185916556, -1.4985168276626997`}, {
        2.331769748521188, -1.4573877400130713`}, {
        2.3723557635290473`, -1.4152257266538382`}, {
        2.405544837232568, -1.3760095126631486`}}]}, 
      {Arrowheads[{{0.007128332313076867, 1.}}], 
       ArrowBox[{{2.41200495420781, -1.368376237568788}, {
        2.412063170893118, -1.3683074487255302`}, {
        2.4509109725822524`, -1.3203285983509758`}, {
        2.4888212168793267`, -1.2713390099061095`}, {
        2.5, -1.2562268858833323`}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.012672718726592267`, 1.}}], 
       ArrowBox[{{-0.47265408473015547`, -2.387718125255608}, \
{-0.4150877735253208, -2.4115720757583334`}, {-0.3566336091371818, \
-2.434100695406883}, {-0.29573850518112094`, -2.454099124419209}, \
{-0.23405875921866198`, -2.472623454161556}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-1.365886243396122, 
        2.485220930569832}, {-1.4200207415608026`, 
        2.4687554270684062`}, {-1.4740334841311096`, 
        2.4511631548535435`}, {-1.5279468778843366`, 
        2.4324470633573956`}, {-1.581693702488602, 
        2.4125983042835086`}, {-1.6364993910533778`, 
        2.388543779068006}, {-1.691027777962068, 
        2.363281191153415}, {-1.7380196800064236`, 2.3403268820599896`}}]}, 
      {Arrowheads[{{0.02000000000000001, 1.}}], 
       ArrowBox[{{-1.7469867958041467`, 
        2.335901470906833}, {-1.7990452581519063`, 
        2.309154254632514}, {-1.8569565419568397`, 
        2.279320187043721}, {-1.91435639915761, 
        2.2481122780247897`}, {-1.9712448297542182`, 
        2.2155305275757207`}, {-2.027621833746663, 
        2.181574935696513}, {-2.083487411134946, 
        2.1462455023871683`}, {-2.09475734452487, 2.138772829504528}}]}, 
      {Arrowheads[{{0.020000000000000004`, 1.}}], 
       ArrowBox[{{-2.1030916844248417`, 
        2.1332466392769174`}, {-2.1388415619190657`, 
        2.1095422276476845`}, {-2.193684286099023, 
        2.0714651114780636`}, {-2.2480155836748175`, 
        2.032014153878304}, {-2.3017073623912254`, 
        1.9912215158723925`}, {-2.354631529993023, 
        1.9491193584843147`}, {-2.4067880864802107`, 
        1.9057076817140703`}, {-2.4220854190191963`, 1.892395188061502}}]}, 
      {Arrowheads[{{0.0018922328009902348`, 1.}}], 
       ArrowBox[{{-2.4344763151378923`, 
        1.865204929493287}, {-2.453329635016154, 1.865204929493287}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.33230646789875, -1.3196195467023213`}, \
{-2.3114731438475813`, -1.3804919356588132`}, {-2.2891128344028346`, \
-1.4410308206600098`}, {-2.2652255395645082`, -1.5012362017059109`}, \
{-2.239811259332603, -1.5611080787965168`}, {-2.2128699937071183`, \
-1.6206464519318273`}, {-2.1844017426880553`, -1.6798513211118422`}, \
{-2.1797405652197592`, -1.6889997697967691`}}]}, 
      {Arrowheads[{{0.019999999999999993`, 1.}}], 
       ArrowBox[{{-2.1752008071024718`, -1.6979099098762809`}, \
{-2.1544065062754134`, -1.7387226863365624`}, {-2.122884284469192, \
-1.7972605476059869`}, {-2.089852500379042, -1.8553138860311842`}, \
{-2.055328577114612, -1.9127316827232226`}, {-2.0193125146759026`, \
-1.9695139376821023`}, {-1.9818043130629135`, -2.025660650907822}, \
{-1.9707926853404785`, -2.041334061513298}}]}, 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-1.965043971201045, -2.049516499153945}, \
{-1.9428039722756458`, -2.0811718224003837`}, {-1.9023114923140978`, \
-2.1360474521597856`}, {-1.8603268731782707`, -2.1902875401860293`}, \
{-1.8168501148681642`, -2.2438920864791134`}, {-1.7773192679259577`, \
-2.292575291703386}, {-1.7365849606255306`, -2.3406084533889575`}, \
{-1.7168303624090997`, -2.362937649657312}}]}, 
      {Arrowheads[{{0.009125637219821469, 1.}}], 
       ArrowBox[{{-1.7102042759193603`, -2.370427307715628}, \
{-1.694639759609222, -2.388020332676369}, {-1.6515059649500132`, \
-2.4347246461439966`}, {-1.6030086427241341`, -2.480797449529346}, \
{-1.581875152749646, -2.5}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.019999999999999997`, 1.}}], 
       ArrowBox[{{-2.5, -1.6768799768963647`}, {-2.499162763063407, \
-1.6790798052967792`}, {-2.475734356291559, -1.7370499542572142`}, \
{-2.4510289993875936`, -1.7948190488411075`}, {-2.425041528876308, \
-1.8523063337948753`}, {-2.3941014814309276`, -1.910741232045118}, \
{-2.361794946511577, -1.9687543550679611`}, {-2.3281392678296435`, \
-2.026252977052514}, {-2.322877450318791, -2.0348218861634613`}}]}, 
      {Arrowheads[{{0.016396876652131742`, 1.}}], 
       ArrowBox[{{-2.3176446707436877`, -2.0433435067791885`}, \
{-2.293128664147998, -2.0832680066024065`}, {-2.256489449864597, \
-2.142827673256714}, {-2.2184016648101, -2.201717177964402}, \
{-2.1788653089845083`, -2.259936520725471}, {-2.137880382387821, \
-2.317485701539921}}]}}, 
     {GrayLevel[0.5], 
      {Arrowheads[{{0.010545859618369489`, 1.}}], 
       ArrowBox[{{-2.3564436459850793`, 
        1.566414280686268}, {-2.3991992849522426`, 
        1.5244356885371335`}, {-2.4412463110806577`, 
        1.4813956576899936`}, {-2.4824236906912693`, 
        1.4334967895747301`}, {-2.5, 1.4121348601908734`}}]}}}}, 
   {RGBColor[0, 0, 1], PointSize[Large], PointBox[{0, -1}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], PointBox[{0, 0}]}, 
   {RGBColor[0.5, 0, 0.5], Arrowheads[Medium], 
    ArrowBox[NCache[{{
       Rational[5, 2] 26^Rational[-1, 2] + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))), -1 + 
        Rational[-1, 2] 26^Rational[-1, 2] + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
          5 (Rational[5, 2] 26^Rational[-1, 2] + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
            5 (Rational[5, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
          5 (Rational[5, 2] 26^Rational[-1, 2] + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))}, {
       Rational[5, 2] 26^Rational[-1, 2] + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) + 
          5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))))), -1 + 
        Rational[-1, 2] 26^Rational[-1, 2] + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
          5 (Rational[5, 2] 26^Rational[-1, 2] + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
            5 (Rational[5, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
          5 (Rational[5, 2] 26^Rational[-1, 2] + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))) + 
        Rational[-1, 2] 
         26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
            5 (Rational[5, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
          Rational[1, 2] 
           26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
            5 (Rational[5, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))) - 
          5 (Rational[5, 2] 26^Rational[-1, 2] + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                 5 (Rational[5, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))))))}}, {{
      2.0788446749800604`, 0.22746258475755665`}, {2.1711694590569186`, 
      1.2690045842873632`}}]]}, 
   {RGBColor[0.5, 0, 0.5], Arrowheads[Medium], 
    ArrowBox[NCache[{{
       0, -1}, {-(Rational[-5, 2] 26^Rational[-1, 2] + 
         Rational[1, 2] 
          26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
           5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
         Rational[1, 2] 
          26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
           5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
         Rational[1, 2] 
          26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
           5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) + 
         5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
             5 (Rational[5, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
           Rational[-1, 2] 
            26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
             5 (Rational[5, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))))) (
         Rational[-1, 
           26] - ((Rational[5, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))))) (
            Rational[-5, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                    Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                   Rational[1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))))) + (
            Rational[-1, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) (1 + 
            Rational[1, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))) - 
            5 (Rational[5, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                   Rational[1, 2] 
                    26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                   5 (Rational[5, 2] 26^Rational[-1, 2] + 
                    Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))))))/((
           Rational[-5, 2] 26^Rational[-1, 2] + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                 5 (Rational[5, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) + 
           5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                 5 (Rational[5, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                    Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))))^2 + (1 + 
           Rational[1, 2] 26^Rational[-1, 2] + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
             5 (Rational[5, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
             5 (Rational[5, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))) - 
           5 (Rational[5, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 
                    26^Rational[-1, 2]))))))))^2)), -1 - (1 + 
         Rational[1, 2] 26^Rational[-1, 2] + 
         Rational[1, 2] 
          26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
         Rational[1, 2] 
          26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
           5 (Rational[5, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
         Rational[1, 2] 
          26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
             5 (Rational[5, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
           5 (Rational[5, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))) - 
         5 (Rational[5, 2] 26^Rational[-1, 2] + 
          Rational[-1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
          Rational[-1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
          Rational[-1, 2] 
           26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))))) (
         Rational[-1, 
           26] - ((Rational[5, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))))) (
            Rational[-5, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) + 
            5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                    Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                   Rational[1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))))) + (
            Rational[-1, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) (1 + 
            Rational[1, 2] 26^Rational[-1, 2] + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
            Rational[1, 2] 
             26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                5 (Rational[5, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
              5 (Rational[5, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))) - 
            5 (Rational[5, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                   5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                   Rational[1, 2] 
                    26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                   5 (Rational[5, 2] 26^Rational[-1, 2] + 
                    Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))))))/((
           Rational[-5, 2] 26^Rational[-1, 2] + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
               5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                 Rational[-1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                 5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
             5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
               Rational[-1, 2] 
                26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                 5 (Rational[5, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))) + 
           5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
             Rational[-1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                 Rational[1, 2] 
                  26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                 5 (Rational[5, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                    Rational[-1, 2] 
                    26^Rational[-1, 2] (1 - 6 
                    Rational[2, 13]^Rational[1, 2])) + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))))))^2 + (1 + 
           Rational[1, 2] 26^Rational[-1, 2] + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
             5 (Rational[5, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) + 
           Rational[1, 2] 
            26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
             Rational[1, 2] 
              26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
               Rational[1, 2] 
                26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
               5 (Rational[5, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])))) - 
             5 (Rational[5, 2] 26^Rational[-1, 2] + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[-1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))))) - 
           5 (Rational[5, 2] 26^Rational[-1, 2] + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
            Rational[-1, 2] 
             26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2])) + 
              Rational[1, 2] 
               26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                  Rational[-1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2])) + 
                Rational[1, 2] 
                 26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                  5 (-1 + Rational[-1, 2] 26^Rational[-1, 2]))) + 
              5 (-1 + Rational[-1, 2] 26^Rational[-1, 2] + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) + 
                Rational[-1, 2] 
                 26^Rational[-1, 2] (1 + Rational[1, 2] 26^Rational[-1, 2] + 
                  Rational[1, 2] 
                   26^Rational[-1, 2] (1 - 6 Rational[2, 13]^Rational[1, 2]) - 
                  5 (Rational[5, 2] 26^Rational[-1, 2] + 
                   Rational[-1, 2] 
                    26^Rational[-1, 2] (Rational[-5, 2] 26^Rational[-1, 2] + 
                    5 (-1 + Rational[-1, 2] 
                    26^Rational[-1, 2]))))))))^2))}}, {{0, -1}, {
       0.08795132610049287, -0.0077962167585819975`}}]]}},
  AspectRatio->1,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->NCache[{{
      Rational[-5, 2], 
      Rational[5, 2]}, {
      Rational[-5, 2], 
      Rational[5, 2]}}, {{-2.5, 2.5}, {-2.5, 2.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.904772725560832*^9, 3.904772740499386*^9}, 
   3.9047727811945457`*^9, 3.904772896585019*^9, {3.904772937017201*^9, 
   3.904772940804311*^9}, 3.9047732903118896`*^9, 3.904773360057931*^9, 
   3.904773761161044*^9, {3.904773810407177*^9, 3.90477383060531*^9}, {
   3.904774077396076*^9, 3.904774141121643*^9}, {3.904774221749342*^9, 
   3.904774229007162*^9}, 3.904878361923007*^9, {3.904878996367771*^9, 
   3.904879001167302*^9}, 3.904879410131927*^9},
 CellLabel->
  "Out[189]=",ExpressionUUID->"74698a80-88b1-43b9-981d-f759e4277f5c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<int3.eps\>\"", ",", 
   RowBox[{"Show", "[", 
    RowBox[{"pic3", ",", 
     RowBox[{"Prolog", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "0", "]"}], ",", 
        RowBox[{"Texture", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}], "}"}], 
         "]"}], ",", 
        RowBox[{"VertexTextureCoordinates", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{".1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{".1", ",", ".1"}], "}"}]}], "}"}], "]"}]}], "}"}]}]}], 
    "]"}]}], "\n", "]"}]], "Input",
 CellChangeTimes->{{3.904878832919888*^9, 3.90487901949247*^9}, {
   3.9048793386650143`*^9, 3.9048793417354383`*^9}, {3.9048794131958237`*^9, 
   3.9048794158984747`*^9}, 
   3.904880893337097*^9},ExpressionUUID->"068074c9-585c-4f46-852d-\
d6fe1bd3a2bc"]
},
WindowSize->{808, 647},
WindowMargins->{{46, Automatic}, {38, Automatic}},
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) \
(2021\:5e746\:670819\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c71f9d4b-2a06-442b-84a9-41909ff15581"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 175, 4, 44, "Input",ExpressionUUID->"11449d5e-9556-41cf-921b-74f9222ed9e4"],
Cell[CellGroupData[{
Cell[758, 28, 2663, 69, 281, "Input",ExpressionUUID->"c03cad2f-1a9e-4811-a10a-4fa17e0682bc"],
Cell[3424, 99, 793, 14, 34, "Output",ExpressionUUID->"17c85c44-7c45-494a-9c42-6870b2230c60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4254, 118, 3441, 92, 317, "Input",ExpressionUUID->"ffa3c8c6-cc51-453e-a6b9-d6e302e90377"],
Cell[7698, 212, 164799, 2929, 378, "Output",ExpressionUUID->"6cd73125-a629-4c7a-9052-0aef73e1a496"]
}, Open  ]],
Cell[172512, 3144, 1306, 37, 170, "Input",ExpressionUUID->"16d211c8-3caa-42ba-9f41-f8321273273a"],
Cell[173821, 3183, 2043, 56, 374, "Input",ExpressionUUID->"16906abe-5430-4850-a700-2b1d86676c5e"],
Cell[CellGroupData[{
Cell[175889, 3243, 4007, 112, 368, "Input",ExpressionUUID->"e4c51643-0abe-4b1b-9d4c-08b7f454e8d2"],
Cell[179899, 3357, 168163, 2994, 378, "Output",ExpressionUUID->"e42cfa51-7337-4d83-99a1-11d9ff2adb18"]
}, Open  ]],
Cell[348077, 6354, 1398, 41, 212, "Input",ExpressionUUID->"707f8cee-2d6e-4b1e-92c3-5fe8b3babd27"],
Cell[349478, 6397, 2146, 57, 374, "Input",ExpressionUUID->"5e051480-cf29-4c31-b3e2-11d823554f47"],
Cell[CellGroupData[{
Cell[351649, 6458, 3800, 109, 368, "Input",ExpressionUUID->"afefd18a-ef93-46c9-9ea9-50ad67c5eb42"],
Cell[355452, 6569, 228972, 4109, 378, "Output",ExpressionUUID->"74698a80-88b1-43b9-981d-f759e4277f5c"]
}, Open  ]],
Cell[584439, 10681, 1395, 38, 211, "Input",ExpressionUUID->"068074c9-585c-4f46-852d-d6fe1bd3a2bc"]
}
]
*)

