import json
import time
from app.routoo import Routoo


config = json.load(open("app/configs/routoo.json", "r"))

# init
routoo = Routoo(config)

# boot the machines
routoo.load_routoo_server()
routoo.load_experts_server()

# start the inference endpoints
routoo.start_inference_endpoints(max_wait_time=120)


# Wait until all endpoints are up
status = False
while not status:
    print("Checking server status...")
    status = routoo.check_servers_state()
    if status:
        print("Servers are running...")
        break
    time.sleep(30)

# Test get_response for all the servers
for expert in routoo.experts.values():
    print(expert.model_id)
    print(expert.get_response("hello"))

# Test get_response for complete pipeline
response = routoo.get_response("What is the capital of India?")
print(response)

# turn off the machines
routoo.routoo.stop_server()
for expert_id, expert in routoo.experts.items():
    res = expert.stop_server()
    print(res)

print("done!")
