import argparse

parser = argparse.ArgumentParser()

# Device
parser.add_argument('--device', type=str, default='cuda')

# System
parser.add_argument('--system', type=str, default='reaction')
parser.add_argument('--seed', type=int, default=0)

# Choose numerical data or generating with PINN.
parser.add_argument('--numerical', type=int, default=1)

# Inject noise or not.
parser.add_argument('--noise', type=int, default=0)
parser.add_argument('--noise_rate', type=int, default=5)

# Choose an extrapolation setting.
parser.add_argument('--extrapolation', type=int, default=0)

# Train epoch.
parser.add_argument('--epoch', type=int, default=4000)

# PDE information
parser.add_argument('--u0_str', default='1+sin(x)')
parser.add_argument('--beta_min', type=float, default = 0.0)
parser.add_argument('--nu_min', type=float, default = 0.0)
parser.add_argument('--rho_min', type=float, default = 1.0)
parser.add_argument('--beta_max', type=float, default = 0.0)
parser.add_argument('--nu_max', type=float, default = 0.0)
parser.add_argument('--rho_max', type=float, default = 20.0)

def get_config():
    return parser.parse_args()