# Scale-Aware Pretraining of Time Series Foundation Models via Multi-Patch Token Alignment and Hybrid Masking

Here are some guidelines to help you quickly verify the model performance of SATS. The pre-trained code will be released when needed or after recruitment. In fact, the key parameters for pre-training have been provided in the paper, and you can easily reproduce them.

## ⚙️ Installation

1. Create virtual environment:
```shell
virtualenv venv
. venv/bin/activate
```
or
```shell
conda create -n SATS python=3.10
conda activate SATS
```
2. Build from source:
```shell
pip install -e '.[notebook]'
```
3. Create a `.env` file:
```shell
touch .env
```

## 🏃 Getting Evaluation

We first need to download the pre-processed datasets and put them in the correct directory, by setting up the TSLib repository and following the instructions.
Then, assign the dataset directory to the `LSF_PATH` environment variable:

```shell
echo "LSF_PATH=PATH_TO_TSLIB/dataset" >> .env
```

We have provided the model file of the SATS base version. You should place the path of SATS in the "pretrained_model_name_or_path" item of cli/conf/eval/model/SATS_base.yaml.

The replaced YAML file should look like：

```
_target_: uni2ts.model.SATS.SATSForecast
module:
  _target_: uni2ts.model.SATS.SATSModule.from_pretrained
  pretrained_model_name_or_path: /home/uni2ts_SATS/SATS
num_samples: 100
patch_size: ???
context_length: ???
```

Finally, by running the script we provided, you can easily reproduce the results:

```shell
./project/SATS/eval/lsf_small.sh 
```

