import networkx as nx
import numpy as np
import torch
from torch_geometric.utils import add_self_loops
from A_layer import FLGnnConv

attr = [
    [(15, 25),   (0, 2500)],
    [(35, 75),  (10000, 12500)],
    [(35, 75),  (6500, 8500)]
]

n_communities = 3
n_communities_size = [15000, 300, 100]
probs = [
    [0.002, 0.001, 0.001],
    [0.001, 0.25, 0.001],
    [0.001, 0.001, 0.25],
]


def sbm(n_blocks, sizes, probs):
    # generate a random graph using stochastic block model
    G = nx.stochastic_block_model(sizes, probs, directed=True)
    x = []
    y = []
    for i in range(n_blocks):
        vector = np.concatenate([np.random.uniform(low=l, high=h, size=(sizes[i], 1)) for l, h in attr[i]], axis=1)
        x.append(vector)
        y.append([i] * sizes[i])
    return torch.tensor(np.concatenate(x, axis=0)), torch.tensor(np.concatenate(y, axis=0)), torch.transpose(
        torch.LongTensor(np.array(G.edges)), 0, 1), len(G.degree)


m = FLGnnConv(in_channels=2, out_channels=3, norm=False, num_mf=3,windows_size=2,stride_size=2).to("cuda")
x, y, edge_index, size = sbm(n_blocks=n_communities, probs=probs, sizes=n_communities_size)
edge_index, edge_attr = add_self_loops(edge_index=edge_index, edge_attr=None, num_nodes=size)
m(x.to("cuda"), edge_index.to("cuda"))
