**(1)Experiment environment:**

```python
Hardware information:
NVIDIA A10

python interpreter:
python-3.9

Libraries:
ogb                     1.3.6
torch                   2.0.1+cu117
torch-cluster           1.6.1+pt20cu117
torch-geometric         2.3.1
torch-scatter           2.1.1+pt20cu117
torch-sparse            0.6.17
torch-spline-conv       1.2.2+pt20cu117
torch-summary           1.4.5
scikit-learn            1.2.1
numpy                   1.24.2
pandas                  1.5.3
matplotlib              3.6.3
seaborn                 0.12.2
```

**(2) Dataset:**

Each dataset is automatically downloaded when the  main program runs

* Coar, CiteSeer, PubMed datasets are offered by the class "Planetoid" in library "torch-geometric" (https://pytorch-geometric.readthedocs.io/en/latest/generated/torch_geometric.datasets.Planetoid.html?highlight=Planetoid)
* Reddit dataset is offered by the class "Reddit" in library "torch-geometric" (https://pytorch-geometric.readthedocs.io/en/latest/generated/torch_geometric.datasets.Reddit.html#torch_geometric.datasets.Reddit)
* ogbg-molhiv, ogbg-molfreesolv, ogbg-molesol, ogbg-molpcba datasets are offered by library "ogb" (https://ogb.stanford.edu/docs/graphprop/)



**(3) Instructions for use:**

Here we provide the all the source codes for experiment 4.2, Appendix B, Appendix C. Users can manually 
adjust parameters to verify ablation experiments 4.1. **_According to the structure and parameter configuration of the FL-GNN vary on different 
datasets, so we independently place the code of the model on each dataset in 
different sub-folders._** 

Each sub-folder under the main folder contains the 4 source code files for each experiment,

1)The file with suffix 'main.py' denotes the main program.

2)The file with suffix "layer.py" contain the model code of FL-GNN and FL-GNN-A.

3)The file with suffix "loader.py" contain the data downloader and loader for corresponding dataset. 

4)The file with suffix "loader.py" contain complete model code.

The best configuration code for each dataset is defined in main program file of each sub-folder. 
To run the main program to directly start experiment. (remark: FL-GNN is unstable on some datasets, please run multiple times to obtain average experimental result)

**The explanation of the model configuration code is as follows:**
* in_channels (int): The number of input dimension
* hidden (int): The number of hidden units
* windows (int): The size of sliding window
* stride (int): The step size of sliding window
* order (0 or 1): 1-order / 0-order FL-GNN (In the FL-GNN-A, this parameter controls whether to use the concatenate layer)
* A_P2 (bool): Whether to enable the part-2 of FL-GNN-A
* refine_ratio (float:0.0-1.0): The refine ratio of refinement-layer
* dropout (float:0.0-1.0): dropout ratio
* cross (float:0.0-1.0): The cross point of two membership function
* num_mf (int): The number of membership function for each feature
* fix (bool): Whether fix the membership function. If turned on, the membership function parameters will not be updated
* layer (int): The stack layer of FL-GNN.
* norm (bool): whether enable the normalization layer
* value_intervals ([int, int]): Domain of definition of membership functions
* optim: Optimizer configuration
* type (string: ["regress", "multi_classify", "binary_classify"]): Task type
* epoch (int): The number of train epoch
* *attention (bool): Tentative module. Keep closed during formal experiments*
* *residual (bool): Tentative module. Keep closed during formal experiments*


