import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()
    
    # Find all non-black blocks in the input grid
    non_black_blocks = set(np.unique(input_grid)) - {black}
    
    # Iterate over each non-black block
    for block in non_black_blocks:
        # Find all locations of the current block in the input grid
        block_locations = np.where(input_grid == block)
        
        # If there are at least two locations, connect them
        if len(block_locations[0]) >= 2:
            # Find the first location of the block
            start_row, start_col = block_locations[0][0], block_locations[1][0]
            
            # Find the second location of the block
            end_row, end_col = block_locations[0][1], block_locations[1][1]
            
            # Connect the two locations with the block color
            if start_row == end_row:
                # If the two locations are in the same row, color the diagonal line between them
                output_grid[start_row, start_col:end_col+1] = block
            elif start_col == end_col:
                # If the two locations are in the same column, color the diagonal line between them
                output_grid[start_row:end_row+1, start_col] = block
            else:
                # If the two locations are not in the same row or column, connect them with a diagonal line
                if start_row < end_row and start_col > end_col:
                    # If the first location is above and to the right of the second location, connect them with a diagonal line going down and to the left
                    for i in range(end_row - start_row + 1):
                        if start_col-i >= end_col:
                            output_grid[start_row+i, start_col-i] = block
                elif start_row > end_row and start_col < end_col:
                    # If the first location is below and to the left of the second location, connect them with a diagonal line going up and to the right
                    for i in range(start_row - end_row + 1):
                        if start_col+i <= end_col:
                            output_grid[start_row-i, start_col+i] = block
                elif start_row > end_row and start_col > end_col:
                    # If the first location is below and to the right of the second location, connect them with a diagonal line going up and to the left
                    for i in range(start_row - end_row + 1):
                        if start_col-i >= end_col:
                            output_grid[start_row-i, start_col-i] = block
                else:
                    # If the first location is above and to the left of the second location, connect them with a diagonal line going down and to the right
                    for i in range(end_row - start_row + 1):
                        if start_col+i <= end_col:
                            output_grid[start_row+i, start_col+i] = block
    
    return output_grid
    