import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find all teal pixels
    teal_pixels = np.where(input_grid == teal)

    # Find up and down row numbers, left and right column numbers of teal pixels
    up_row = np.min(teal_pixels[0])
    down_row = np.max(teal_pixels[0])
    left_col = np.min(teal_pixels[1])
    right_col = np.max(teal_pixels[1])

    # Make blue pixels in input grid from up to down, left to right green
    input_grid[up_row:down_row+1, left_col:right_col+1][input_grid[up_row:down_row+1, left_col:right_col+1] == blue] = green

    return input_grid