import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Clip out the fourth to sixth lines of the input and repeat it six times vertically
    clipped_input = input_grid[3:6, :]
    repeated_input = np.tile(clipped_input, (6, 1))

    # Determine the length of the input grid
    input_length = input_grid.shape[0]

    # Cut out the output from the repeated input grid
    output = repeated_input[:input_length, :]

    return output