import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the dimensions of the input grid
    rows, cols = input_grid.shape

    # Split the input grid into four new arrays based on the central dividing line in the x and y directions
    top_left = input_grid[:rows//2, :cols//2]
    top_right = input_grid[:rows//2, cols//2+1:]
    bottom_left = input_grid[rows//2+1:, :cols//2]
    bottom_right = input_grid[rows//2+1:, cols//2+1:]

    # Check which of the four new arrays doesn't have just one color
    arrays = [top_left, top_right, bottom_left, bottom_right]
    for array in arrays:
        if len(np.unique(array)) > 1:
            return array

    # If all four new arrays have just one color, return the input grid
    return input_grid