import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find smallest matrix containing all pixels that are not black, green, or teal
    non_green_teal_pixels = np.where((input_grid != green) & (input_grid != teal) & (input_grid != black))
    min_row, max_row = np.min(non_green_teal_pixels[0]), np.max(non_green_teal_pixels[0])
    min_col, max_col = np.min(non_green_teal_pixels[1]), np.max(non_green_teal_pixels[1])
    m = input_grid[min_row:max_row+1, min_col:max_col+1]
    
    # Find smallest matrix containing all green pixels
    green_pixels = np.where(input_grid == green)
    min_row, max_row = np.min(green_pixels[0]), np.max(green_pixels[0])
    min_col, max_col = np.min(green_pixels[1]), np.max(green_pixels[1])
    n = input_grid[min_row:max_row+1, min_col:max_col+1]
    
    # Divide matrix n into 4 submatrices and replace all green pixels with the color of the corresponding pixel in m
    submatrices = np.array_split(n, 2, axis=0)
    submatrices = [np.array_split(submatrix, 2, axis=1) for submatrix in submatrices]
    for i in range(2):
        for j in range(2):
            submatrix = submatrices[i][j]
            green_pixels = np.where(submatrix == green)
            submatrix[green_pixels] = m[i, j]
            submatrices[i][j] = submatrix
    
    # Combine the submatrices to form the output grid
    output_grid = np.concatenate((np.concatenate(submatrices[0], axis=1), np.concatenate(submatrices[1], axis=1)), axis=0)
    
    return output_grid
    