import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the dimensions of the input grid
    rows, cols = input_grid.shape
    
    # Create a copy of the input grid to store the output
    output_grid = input_grid.copy()
    
    # Traverse each red pixel in the input grid
    for row in range(rows):
        for col in range(cols):
            if input_grid[row, col] == red:
                # Check if the red pixel has no red pixel up, down, left or right
                if (row == 0 or input_grid[row-1, col] != red) and \
                   (row == rows-1 or input_grid[row+1, col] != red) and \
                   (col == 0 or input_grid[row, col-1] != red) and \
                   (col == cols-1 or input_grid[row, col+1] != red):
                    # Turn the red pixel blue
                    output_grid[row, col] = blue
    
    return output_grid