import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    ngrid = np.zeros_like(input_grid)
    
    # Traverse each row in the inputgrid
    for i in range(input_grid.shape[0]):
        if np.all(input_grid[i,:] == black):
            # Paint the corresponding row in the ngrid red
            ngrid[i,:] = red
    
    # Traverse each column in inputgrid
    for j in range(input_grid.shape[1]):
        if np.all(input_grid[:,j] == black):
            # Paint the corresponding column in ngrid red
            ngrid[:,j] = red
    
    # Traverse each cell in inputgrid
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i,j] != black:
                # Copy the cell from inputgrid to ngrid
                ngrid[i,j] = input_grid[i,j]
    
    return ngrid

# Example input grid
input_grid = np.array([[0, 0, 0, 0],
                       [0, 1, 1, 0],
                       [0, 1, 1, 0],
                       [0, 0, 0, 0]])

# Call the main function with the example input grid
output_grid = main(input_grid)

# Print the input and output grids
print("Input grid:")
print(input_grid)
print("Output grid:")
print(output_grid)