import unittest
from anpl.parser import ANPLParser
from anpl.tracer import anpl_check, anpl_trace
from anpl.anpl import IOExample
import numpy as np
from copy import deepcopy

class TestTrace(unittest.TestCase):

    def setUp(self) -> None:
        self.parser = ANPLParser()

    def test_anpl_check(self):
        source_code = """
def hello(x, y):
    return x * 2 + y * 2

def main(a, b):
    return hello(a, b) + 3
"""
        anpl = self.parser.parse(source_code)
        anpl.funs["hello"].gloden_ios.extend([IOExample({"x": 3, "y": 4}, 14)])
        self.assertTrue(anpl_check(anpl, "hello"))


    def test_recursive(self):
        source_code = """
def flood_fill(grid, x, y):
    if grid[x, y] == black:
        grid[x, y] = yellow
        if x > 0:
            flood_fill(grid, x-1, y)
        if x < grid.shape[0] - 1:
            flood_fill(grid, x+1, y)
        if y > 0:
            flood_fill(grid, x, y-1)
        if y < grid.shape[1] - 1:
            flood_fill(grid, x, y+1)
    return grid
"""
        golden_in = {"grid": np.zeros((3, 3), dtype=int), "x": 0, "y": 0}
        golden_out = np.full((3, 3), 4, dtype=int)
        anpl = self.parser.parse(source_code)
        anpl.funs["flood_fill"].gloden_ios.extend([IOExample(golden_in, golden_out)])
        self.assertTrue(anpl_check(anpl, "flood_fill"))
        