import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the color with the fewest occurrences in the grid
    unique, counts = np.unique(input_grid, return_counts=True)
    min_count_color = unique[np.argmin(counts)]
    # Find the indices of the minimum count color
    indices = np.where(input_grid == min_count_color)
    # Find the minimum and maximum indices to create a square frame
    min_row, min_col = np.min(indices[0]), np.min(indices[1])
    max_row, max_col = np.max(indices[0]), np.max(indices[1])
    # Create the output grid by slicing the sub grid inside the frame
    output_grid = input_grid[min_row:max_row+1, min_col:max_col+1]
    return output_grid
