import numpy as np
# Define color codes
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Initialize dictionary to store color counts
    color_counts = {}
    # Iterate through input grid and count colors
    for row in input_grid:
        for color in row:
            if color != black:
                if color not in color_counts:
                    color_counts[color] = 1
                else:
                    color_counts[color] += 1
    # Find color(s) with maximum count
    max_count = max(color_counts.values())
    max_colors = [color for color, count in color_counts.items() if count == max_count]
    # Create output grid
    output_grid = np.zeros_like(input_grid)
    # Iterate through input grid and update output grid
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            color = input_grid[i][j]
            if color == black:
                output_grid[i][j] = grey
            elif color in max_colors:
                output_grid[i][j] = color
            else:
                output_grid[i][j] = grey
    return output_grid
