import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid)
    rows, cols = input_grid.shape
    
    # Find all non-black lines
    lines = []
    for i in range(rows):
        for j in range(cols):
            if input_grid[i][j] != black:
                # Check if line already exists
                line_exists = False
                for line in lines:
                    if (i,j) in line:
                        line_exists = True
                        break
                if not line_exists:
                    # Create new line
                    line = [(i,j)]
                    # Check if line continues horizontally
                    for k in range(j+1, cols):
                        if input_grid[i][k] != black:
                            line.append((i,k))
                        else:
                            break
                    # Check if line continues vertically
                    for k in range(i+1, rows):
                        if input_grid[k][j] != black:
                            line.append((k,j))
                        else:
                            break
                    lines.append(line)
    
    # Find intersection pixels
    intersections = []
    for i in range(len(lines)):
        for j in range(i+1, len(lines)):
            intersection = set(lines[i]) & set(lines[j])
            if intersection:
                intersections.append(list(intersection)[0])
    
    # Color adjacent pixels yellow
    for intersection in intersections:
        i, j = intersection
        for k in range(i-1, i+2):
            for l in range(j-1, j+2):
                if k >= 0 and k < rows and l >= 0 and l < cols and (k,l) != intersection:
                    output_grid[k][l] = yellow
    
    return output_grid
    