import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the not black pixel
    not_black = np.where(input_grid != black)
    row, col = not_black[0][0], not_black[1][0]
    color = input_grid[row, col]  
    # Move the not black pixel downwards
    output_grid = np.copy(input_grid)
    output_grid[row, col] = yellow
    output_grid[row+1, col] = color
    
    # Color the pixels above the not black pixel in yellow
    for r in range(row):
        output_grid[r, col] = yellow  
    # Copy the yellow line to every other column to the left and right of the not black pixel
    prev_yellow_col = col
    spacing = 1
    for c in range(col+1, input_grid.shape[1]):
        if spacing == 0:
            # Find the yellow part of the column that corresponds to the yellow line in the previous column
            yellow_rows = np.where(output_grid[:, prev_yellow_col] == yellow)[0]
            if len(yellow_rows) > 0:
                output_grid[yellow_rows, c] = output_grid[yellow_rows, prev_yellow_col]
            # Update the previous yellow column
            prev_yellow_col = c
            spacing = 1
        else:
            spacing -= 1
    prev_yellow_col = col
    spacing = 1
    for c in range(col-1, -1, -1):
        if spacing == 0:
            # Find the yellow part of the column that corresponds to the yellow line in the previous column
            yellow_rows = np.where(output_grid[:, prev_yellow_col] == yellow)[0]
            if len(yellow_rows) > 0:
                output_grid[yellow_rows, c] = output_grid[yellow_rows, prev_yellow_col]
            # Update the previous yellow column
            prev_yellow_col = c
            spacing = 1
        else:
            spacing -= 1
    return output_grid
