import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: Traverse the inputgrid to find the first black pixel
    tx, ty = None, None
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == black:
                tx, ty = i, j
                break
        if tx is not None:
            break

    # Step 2: Rotate the inputgrid 90 degrees clockwise and get the subgrid
    rotated_grid = np.rot90(input_grid)
    sub_grid = rotated_grid[tx:tx+3, ty:ty+3]

    # Step 3: Return the subgrid
    return sub_grid
    