import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = np.copy(input_grid)

    # Define the radius of the cross
    radius = 2

    # Traverse the input grid
    for i in range(radius, input_grid.shape[0]-radius):
        for j in range(radius, input_grid.shape[1]-radius):
            # Create a list of colors for the five positions
            colors = [input_grid[i][j], input_grid[i-2][j], input_grid[i+2][j], input_grid[i][j-2], input_grid[i][j+2]]

            # Check if at least three of the colors are red
            if colors.count(red) < 3:
                continue

            # Change the non-red positions of the cross to teal
            for k in range(i-radius, i+radius+1):
                if k == i:
                    if input_grid[k][j] != red:
                        output_grid[k][j] = teal
                    continue
                if input_grid[k][j] != red:
                    output_grid[k][j] = teal
            for l in range(j-radius, j+radius+1):
                if l == j:
                    if input_grid[i][l] != red:
                        output_grid[i][l] = teal
                    continue
                if input_grid[i][l] != red:
                    output_grid[i][l] = teal

    return output_grid